/**
 * DataAccessManager.java
 * Created on 2004/02/15
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.dataaccess;

import java.io.IOException;
import java.util.Properties;

import net.prixdami.alexis.logic.Message;
import net.prixdami.alexis.system.SystemParameter;

/**
 * f[^ANZXp}l[WNX
 * f[^ANZX͂[ȁ[[[SẴNXoRB
 * DataAcquireModuleDataStoreModulẽCX^XێB
 * @author es
 */
public class DataAccessManager {

	private static DataAccessManager me;
	private DataAcquireModule dam;
	private DataStoreModule dsm;
	
	//vpeB擾p̃L[
	private static final String DAM = "DataAcquireModule";
	private static final String DSM = "DataStoreModule";
	
	//VOgŕێ
	private DataAccessManager() {
		init();
	}

	//
	private void init() {
		//VXep[^炱̃NXp̃vpeB擾
		Properties p = SystemParameter.getProperties(this.getClass().getName());
		String damName = p.getProperty(DAM);
		String dsmName = p.getProperty(DSM);
		try {
			//gpDataAcquireModuleDataStoreModule̎NX擾ACX^XA
			//ƃf[^擾/i[ύXꍇł`t@C邾ł悢
			dam = (DataAcquireModule)Class.forName(p.getProperty(DAM)).getConstructor(null).newInstance(null);
			dam.init(SystemParameter.getProperties(damName));

			dsm = (DataStoreModule)Class.forName(p.getProperty(DSM)).getConstructor(null).newInstance(null);
			dsm.init(SystemParameter.getProperties(dsmName));
        } catch (Exception e) {
        	//ORuntimeException
			throw new RuntimeException(e);
        }
	}

	/**
	 * CX^X擾
     * @return ̃NX̒P̃CX^X
     */
    public static DataAccessManager getInstace() {
		if(me == null) {
			me = new DataAccessManager();
		}
		return me;
	}

	/**
	 * f[^i[
     * @param target i[掯ʖ
     * @param data i[f[^f
     * @throws IOException@炩̊i[O
     */
    public void store(String target, Message data) throws IOException {
		//ԂDataStoreModuleւ̈Ϗ
		dsm.store(target, data);
	}

	/**
	 * f[^擾
     * @param target 擾Ώێʖ
     * @param start 擾Jnindex
     * @param max 擾Iindex
     * @return@擾f[^f̔z 擾ł
     * @throws IOException 炩̎擾O
     */
    public Message[] acquire(String target, int start, int max) throws IOException {
		//ԂDataAcquireModuleւ̈Ϗ
		return dam.acquire(target, start, max);
	}
}
