/**
 * GenericController.java
 * Created on 2003/05/03
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.controller;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.prixdami.alexis.Const;
import net.prixdami.alexis.logic.ActionModel;
import net.prixdami.alexis.logic.Logic;
import net.prixdami.alexis.model.ResultModel;
import net.prixdami.alexis.system.SystemParameter;

/**
 * Rg[̒ۊNX
 * HTML\ʂ́form action="c"ŌĂ΂Servlet͑SĂp邱
 * @author es
 */
abstract public class GenericController extends HttpServlet {

    public static final String ACTION = "action";
	public static final String KEY_EXCEPTION = Const.KEY_EXCEPTION;
    public static final String RESULT = Const.KEY_RESULT;
    private static final String SELF = Const.SYSTEM_SELF;

    protected String systemErrorTo = null;
    protected String systemFatalTo = null;
    protected String systemNoticeTo = null;
    protected String systemSatisfyTo = null;

	private Map actionList = null;
	private Map logicCache = new Hashtable();

    /**
     * NGXgɑ΂ALogics
     * @param req HttpNGXg
     * @param res HttpX|X
     * @return sʂ̃_CNgURL
     * @throws javax.servlet.ServletException
     * @throws java.io.IOException
     */
    abstract protected String action(HttpServletRequest req, HttpServletResponse res) throws javax.servlet.ServletException, java.io.IOException;

    /**
     * ActionModel擾
     * @param key ActionModel(actionmap`XMLɂname)
     * @return keyɑΉActionModel
     */
    protected ActionModel getAction(String key) {
        return (ActionModel) actionList.get(key);
    }

    /**
     * ActionModelŎw肳ꂽLogic擾.
     * Ɉx擾Ă̂̓LbV擾
     * @param model 擾ΏۂActionModel
     * @return ΏۂLogic
     * @throws Exception
     */
    protected Logic getLogic(ActionModel model) throws Exception {
        String key = model.getLogicFQN();
        Logic returnValue = (Logic) logicCache.get(key);
        if (returnValue == null) {
            Properties prop = model.getProperty();
            returnValue = (Logic) Class.forName(key).getConstructor(null).newInstance(null);
            returnValue.init(prop);
            logicCache.put(key, returnValue);
        }
        return returnValue;
    }

    protected String getReturnPath(int code, ActionModel model, String selfTo) {
        String returnPath;
        switch (code) {
            case ResultModel.SATISFY :
                returnPath = model.getReturnPath(ResultModel.SATISFY);
                if (returnPath == null) {
                    returnPath = this.systemSatisfyTo;
                }
                break;
            case ResultModel.NOTICE :
                returnPath = model.getReturnPath(ResultModel.NOTICE);
                if (returnPath == null) {
                    returnPath = this.systemNoticeTo;
                }
                break;
            case ResultModel.ERROR :
                returnPath = model.getReturnPath(ResultModel.ERROR);
                if (returnPath == null) {
                    returnPath = this.systemErrorTo;
                }
                break;
            case ResultModel.FATAL :
                returnPath = model.getReturnPath(ResultModel.FATAL);
                if (returnPath == null) {
                    returnPath = this.systemFatalTo;
                }
                break;
            default :
                returnPath = model.getReturnPath(code);
                if (returnPath == null) {
                    returnPath = this.systemFatalTo;
                }
        }

        if (returnPath.equals(GenericController.SELF)) {
            returnPath = selfTo;
        }
        return returnPath;
    }

    /* ( Javadoc)
     * @see javax.servlet.Servlet#init(javax.servlet.ServletConfig)
     */
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);

        systemSatisfyTo = SystemParameter.getSystemProperty(Const.SYSTEM_SATISFY);
        systemNoticeTo = SystemParameter.getSystemProperty(Const.SYSTEM_NOTICE);
        systemErrorTo = SystemParameter.getSystemProperty(Const.SYSTEM_ERROR);
        systemFatalTo = SystemParameter.getSystemProperty(Const.SYSTEM_FATAL);

        if (actionList == null) {
            actionList = SystemParameter.getActionMap();
        }
    }
}
