# 0.0.25

**Version:** 0.0.25
**Published:** 2024-03-23T20:56:02Z

## Release Notes

📦 **Rust Coreutils 0.0.25 Release:**

We're thrilled to announce version 0.0.25. We added +15 GNU passing tests since our last update!
More and more programs have a full compatibility with the GNU testsuite.
The current list is: base64, basename, cat, chgrp, chmod, chown, dirname, expand, fold, groups, join, ln, mktemp, nice, nl, nproc, paste, pathchk, printenv, realpath, shuf, sleep, split, sync, unexpand, uniq, wc and yes.

This release saw contributions from 31 developers, including 14 newcomers.

Some of this work has been supported by the [Sovereign Tech Fund](https://www.sovereigntechfund.de/tech/coreutils).

If you want to help us, please consider sponsoring on GitHub. This helps us use better tools like GitHub Actions. Sponsor us at [https://github.com/sponsors/uutils](https://github.com/sponsors/uutils).

Visit our website at [https://uutils.github.io](https://uutils.github.io).

## GNU test suite compatibility

Here's how version 0.0.25 compares to the previous release - running GNU/Coreutils 9.4:

| Result | 0.0.24 | 0.0.25 | Change 0.0.24 to 0.0.25 | % Total 0.0.24 | % Total 0.0.25 | % Change 0.0.24 to 0.0.25 |
|--------|--------|--------|-------------------------|----------------|----------------|--------------------------|
| Pass   | 422    | 437    | +15                     | 69.87%         | 72.35%         | +2.48%                   |
| Skip   | 50     | 50     | 0                       | 8.28%          | 8.28%          | 0.00%                    |
| Fail   | 132    | 117    | -15                     | 21.85%         | 19.37%         | -2.48%                   |
| Error  | 0      | 0      | 0                       | 0.00%          | 0.00%          | 0.00%                    |


![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

For more details, visit [https://github.com/uutils/coreutils-tracking/](https://github.com/uutils/coreutils-tracking/).


## What's Changed
### base32/base64/basenc
* implement and test proper flag parsing by @BenWiederhake in https://github.com/uutils/coreutils/pull/6007

### basename
* Fix handling of repeated flags/arguments by @BenWiederhake in https://github.com/uutils/coreutils/pull/6018

### cat
* Handle all flags correctly by @BenWiederhake in https://github.com/uutils/coreutils/pull/6034

### chcon
* Handle repeated flags and overrides between --no-XXX and --XXX by @BenWiederhake in https://github.com/uutils/coreutils/pull/6039

### chmod
* Fix chmod -c --reference reporting when no change is made by @mtimaN in https://github.com/uutils/coreutils/pull/6016
* Fix handling of preserve root flag and error messages by @BenWiederhake in https://github.com/uutils/coreutils/pull/6042

### cksum
* permit repeated flags, handle overrides correctly, implement base64 output by @BenWiederhake in https://github.com/uutils/coreutils/pull/6041
* enable encoding feature by @cakebaker in https://github.com/uutils/coreutils/pull/6095

### cp
* remove lint exceptions by @kralo in https://github.com/uutils/coreutils/pull/5891
* improve the support of --attributes-only by @sylvestre in https://github.com/uutils/coreutils/pull/6051
* Split the copy_file function a bit by @sylvestre in https://github.com/uutils/coreutils/pull/6056
* fix flaky test test_cp_arg_interactive_update, document adjacent bug by @BenWiederhake in https://github.com/uutils/coreutils/pull/6020

### csplit
* use `printf` functionality from `uucore` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5958
* adjust the error message to match GNU's by @sylvestre in https://github.com/uutils/coreutils/pull/6090
* remove `crate_name` attribute by @cakebaker in https://github.com/uutils/coreutils/pull/6091

### cut
* set exit code to 1 if directory is specified by @cakebaker in https://github.com/uutils/coreutils/pull/5886
* refactor delimiters OsString handling by @zhitkoff in https://github.com/uutils/coreutils/pull/6072
* allow non utf8 characters for delimiters by @zhitkoff in https://github.com/uutils/coreutils/pull/6037
* show error for multiple mode args (`-b`, `-c`, `-f`) by @wolimst in https://github.com/uutils/coreutils/pull/5962

### dd
* parse big numbers and return u64::MAX by @jfinkels in https://github.com/uutils/coreutils/pull/5901
* fail on missing number in count, fix #5904 by @sudhackar in https://github.com/uutils/coreutils/pull/5920
* misc gnu test  by @matrixhead in https://github.com/uutils/coreutils/pull/6084
* fix flaky test_final_stats_unspec by @BenWiederhake in https://github.com/uutils/coreutils/pull/6001
* treat arg as bytes if it contains a 'B' by @matrixhead in https://github.com/uutils/coreutils/pull/6050
* fix gnu test `not-rewound.sh` by @cre4ture in https://github.com/uutils/coreutils/pull/6088

### df
* switch from u64 to u128 to handle fs with large inodes nr by @cre4ture in https://github.com/uutils/coreutils/pull/6071

### du
* adapt error message to match GNU's by @cakebaker in https://github.com/uutils/coreutils/pull/5916
* adjust one of the GNU error message as ours is better by @sylvestre in https://github.com/uutils/coreutils/pull/6085

### echo
* do not infer long args by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5911

### env
* support string args by "-S", "-vS" or "--split-strings" by @cre4ture in https://github.com/uutils/coreutils/pull/5801
* Fix/findings for env string args by @cre4ture in https://github.com/uutils/coreutils/pull/6105

### expand
* Continue work when one of given files doesn't exist by @D9nni in https://github.com/uutils/coreutils/pull/5873
* make tab explicit in test by @cakebaker in https://github.com/uutils/coreutils/pull/5875
* do not ignore invalid UTF-8 by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5987

### factor
* remove clippy exceptions by reformatting "unreadable literals" by @kralo in https://github.com/uutils/coreutils/pull/5890
* rename input parameter by @kralo in https://github.com/uutils/coreutils/pull/5892
* enable a debug_assert! statement by @cakebaker in https://github.com/uutils/coreutils/pull/5995

### fmt
* Make sure the goal is always positive when given a positive width by @sargas in https://github.com/uutils/coreutils/pull/6094
* fail if goal is bigger than default width by @cakebaker in https://github.com/uutils/coreutils/pull/6096

### hashsum
* also escape/unescape files with checks by @sylvestre in https://github.com/uutils/coreutils/pull/5868

### install
* invalid link at destination by @cre4ture in https://github.com/uutils/coreutils/pull/5851

### ln
* fix help text by @cakebaker in https://github.com/uutils/coreutils/pull/5977

### ls
* fix "unused variable" warning on Redox by @cakebaker in https://github.com/uutils/coreutils/pull/5931
* test_ls_allocation_size fails on filesystem `f2fs` (android) by @cre4ture in https://github.com/uutils/coreutils/pull/6076
* rename `chrono::Duration` to `chrono::TimeDelta` by @cakebaker in https://github.com/uutils/coreutils/pull/5970

### more
* Disable raw mode before exiting if a panic occurs by @Ideflop in https://github.com/uutils/coreutils/pull/5914
* Implement argument pattern by @Ideflop in https://github.com/uutils/coreutils/pull/5966
* handle errors with multiple files by @Ludmuterol in https://github.com/uutils/coreutils/pull/4997
* fix two incorrect tests by @cakebaker in https://github.com/uutils/coreutils/pull/6104

### numfmt
* remove clap workaround by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5986

### od
* disable failing test_od::test_f16() for android CI by @cre4ture in https://github.com/uutils/coreutils/pull/5984
* re-enable f16 test with newer AVD system image by @cre4ture in https://github.com/uutils/coreutils/pull/6099

### printf
* pad unsigned numbers properly by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5955
* Make operate on bytes instead of strings by @RenjiSann in https://github.com/uutils/coreutils/pull/6028
* '%0c' and '%0s' should fail by @RenjiSann in https://github.com/uutils/coreutils/pull/6032

### pr
* use chrono instead of time in tests #5972 by @biplab5464 in https://github.com/uutils/coreutils/pull/5973
* Check the correct timestamp in test_with_pr_core_utils_tests by @BenWiederhake in https://github.com/uutils/coreutils/pull/6010
* relax some error messages by @sylvestre in https://github.com/uutils/coreutils/pull/6087

### seq
* fix about text not found by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5949

### shuf
* Treat empty file as zero elements instead of one empty string by @BenWiederhake in https://github.com/uutils/coreutils/pull/5979
* Refuse repeating zero lines by @BenWiederhake in https://github.com/uutils/coreutils/pull/6011
* include all echo args, not just the last by @BenWiederhake in https://github.com/uutils/coreutils/pull/5978
* Fix OOM crash for huge number ranges by @BenWiederhake in https://github.com/uutils/coreutils/pull/5980
* add missing word to BENCHMARKING.md by @cakebaker in https://github.com/uutils/coreutils/pull/5996
* Fix off-by-one errors in range handling by @BenWiederhake in https://github.com/uutils/coreutils/pull/6014
* treat -e as a flag, not as a multi-value arg by @BenWiederhake in https://github.com/uutils/coreutils/pull/5989
* Do not read input when -n0 is given by @BenWiederhake in https://github.com/uutils/coreutils/pull/5990

### sort
* fix incorrectly placed "}" in test by @cakebaker in https://github.com/uutils/coreutils/pull/6064

### split
* fix android memory kill in split by @cre4ture in https://github.com/uutils/coreutils/pull/5940
* fix error message shown if file doesn't exist by @cakebaker in https://github.com/uutils/coreutils/pull/5909

### stat
* Refactor to remove #[allow(clippy::cognitive_complexity)] #5881 by @biplab5464 in https://github.com/uutils/coreutils/pull/5924
* should fail without arguments #5928 by @biplab5464 in https://github.com/uutils/coreutils/pull/5935
* use chrono instead of time in fsext by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5934
* add 0xDE flag to support zfs file system by @hanbings in https://github.com/uutils/coreutils/pull/6101

### tsort
* drastically reduce memory copies by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5969

### tty
* fix for Ctrl-D when stdin is a terminal by @zhitkoff in https://github.com/uutils/coreutils/pull/6059

### truncate
* correctly handle file (non-)creation by @BenWiederhake in https://github.com/uutils/coreutils/pull/6108

### uname
* Refactor into public fns for Nushell by @dmatos2012 in https://github.com/uutils/coreutils/pull/5921

### uniq
* pass remaining GNU tests by @zhitkoff in https://github.com/uutils/coreutils/pull/5994
* Fix flaky test gnu_tests by @BenWiederhake in https://github.com/uutils/coreutils/pull/6017
* use `concat!` in tests for better readability by @cakebaker in https://github.com/uutils/coreutils/pull/6022

### CI
* Android disable mirror selection by @kralo in https://github.com/uutils/coreutils/pull/5894
* Android delete AVD lockfile when running from cached image by @kralo in https://github.com/uutils/coreutils/pull/5917
* Add Android x86_64 by @cakebaker in https://github.com/uutils/coreutils/pull/5843
* github action: run on native m1 - and execute the tests by @sylvestre in https://github.com/uutils/coreutils/pull/5923
* CI Android: set environmental variable for BACKTRACE to right value by @cre4ture in https://github.com/uutils/coreutils/pull/5965
* run CICD workflow on tag creation by @malt3 in https://github.com/uutils/coreutils/pull/5971
* `ci:android` stabilize and improve android github actions by @cre4ture in https://github.com/uutils/coreutils/pull/5939
* use latest version of `cspell` by @cakebaker in https://github.com/uutils/coreutils/pull/5947
* android disk space issue by @cre4ture in https://github.com/uutils/coreutils/pull/5943
* tests/common/util.rs: add `cfg(feature = "env")` by @cakebaker in https://github.com/uutils/coreutils/pull/6044
* deny.toml: add redox_syscall to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/6066
* Android CI: workaround: run builds with retry by @cre4ture in https://github.com/uutils/coreutils/pull/5993
* deny.toml: remove deprecated keys, opt-in to v2 by @cakebaker in https://github.com/uutils/coreutils/pull/6065
* test utilities: easy way to simulate terminal context by @cre4ture in https://github.com/uutils/coreutils/pull/5869
* ci: use codecov token in CICD/GnuTests workflows by @cakebaker in https://github.com/uutils/coreutils/pull/5938

### Documentation
* Adjust the link to the doc by @sylvestre in https://github.com/uutils/coreutils/pull/6093
* docs: add paragraph about yocto recipe by @Ecordonnier in https://github.com/uutils/coreutils/pull/5918/pull/5919
* doc: fixed benchmark table by @SamuelLarkin in https://github.com/uutils/coreutils/pull/5936

### Security
* fuzzing: use LC_ALL instead of LC_COLLATE by @cakebaker in https://github.com/uutils/coreutils/pull/5889
* fuzzing: set LC_ALL=C when running GNU printf by @cakebaker in https://github.com/uutils/coreutils/pull/5983
* parser: if closing square bracket not found, stop looking for it again by @cj-zoltan-kiss in https://github.com/uutils/coreutils/pull/6036

### Various improvements
* Clippy suggestions by @kralo in https://github.com/uutils/coreutils/pull/5895
* uucore: fix "X is never used" warnings on Redox by @cakebaker in https://github.com/uutils/coreutils/pull/5932
* lint: fix lints of new Rust version by @Krysztal112233 in https://github.com/uutils/coreutils/pull/6102
* cargo: rename `config` to `config.toml` by @cakebaker in https://github.com/uutils/coreutils/pull/5954
* added shebang to run python scripts by @thesayfulla in https://github.com/uutils/coreutils/pull/6098
* clippy: fix warnings introduced by Rust 1.76 by @cakebaker in https://github.com/uutils/coreutils/pull/5959
* Fix clippy warnings by @sylvestre in https://github.com/uutils/coreutils/pull/6052
* tests: Harden two tests, prevent 4 flaky tests (cat, numfmt, sort, split, tee) by @BenWiederhake in https://github.com/uutils/coreutils/pull/6000
* Fix/flaky `split` round robin limited fds by @cre4ture in https://github.com/uutils/coreutils/pull/6043
* Fix "item x imported redundantly" warnings by @cakebaker in https://github.com/uutils/coreutils/pull/5988
* cargo: fix feature = "cargo-clippy" deprecation by @rex4539 in https://github.com/uutils/coreutils/pull/6027
* Fix/flaky timeout kill subprocess by @cre4ture in https://github.com/uutils/coreutils/pull/6061
* Fix two "item x is imported redundantly" warnings by @cakebaker in https://github.com/uutils/coreutils/pull/6077
* pr/chgrp: fix warnings by @cakebaker in https://github.com/uutils/coreutils/pull/6054
* Un-Ignore two tests that fail for nonsense reasons by @BenWiederhake in https://github.com/uutils/coreutils/pull/5997

### dependency updates
* Bump wild from 2.2.0 to 2.2.1 by @cakebaker in https://github.com/uutils/coreutils/pull/5899
* chore(deps): update rust crate chrono to ^0.4.33 by @renovate in https://github.com/uutils/coreutils/pull/5880
* chore(deps): update vmactions/freebsd-vm action to v1.0.6 by @renovate in https://github.com/uutils/coreutils/pull/5887
* chore(deps): update rust crate itertools to 0.12.1 by @renovate in https://github.com/uutils/coreutils/pull/5913
* chore(deps): update mozilla-actions/sccache-action action to v0.0.4 by @renovate in https://github.com/uutils/coreutils
* chore(deps): update codecov/codecov-action action to v4 by @renovate in https://github.com/uutils/coreutils/pull/5926
* chore(deps): update rust crate libc to 0.2.153 by @renovate in https://github.com/uutils/coreutils/pull/5927
* chore(deps): update rust crate exacl to 0.12.0 by @renovate in https://github.com/uutils/coreutils/pull/5937
* chore(deps): update rust crate tempfile to 3.10.0 by @renovate in https://github.com/uutils/coreutils/pull/5948
* chore(deps): update rust crate unicode-segmentation to 1.11.0 by @renovate in https://github.com/uutils/coreutils/pull/5953
* chore(deps): update rust crate num-traits to 0.2.18 by @renovate in https://github.com/uutils/coreutils/pull/5956
* chore(deps): update rust crate chrono to ^0.4.34 by @renovate in https://github.com/uutils/coreutils/pull/5967
* chore(deps): update rust crate textwrap to 0.16.1 by @renovate in https://github.com/uutils/coreutils/pull/5985
* chore(deps): update rust crate tempfile to 3.10.1 by @renovate in https://github.com/uutils/coreutils/pull/6023
* chore(deps): update rust crate half to 2.4 by @renovate in https://github.com/uutils/coreutils/pull/6021
* chore(deps): update rust crate rayon to 1.9 by @renovate in https://github.com/uutils/coreutils/pull/6026
* chore(deps): update rust crate walkdir to 2.5 by @renovate in https://github.com/uutils/coreutils/pull/6038
* chore(deps): update softprops/action-gh-release action to v2 by @renovate in https://github.com/uutils/coreutils/pull/6049
* chore(deps): update rust crate blake3 to 1.5.1 by @renovate in https://github.com/uutils/coreutils/pull/6057
* chore(deps): update rust crate regex to 1.10.4 by @renovate in https://github.com/uutils/coreutils/pull/6107
* Bump smallvec from 1.13.0 to 1.13.1 by @cakebaker in https://github.com/uutils/coreutils/pull/5874
* Bump shlex from 1.1.0 to 1.3.0 by @cakebaker in https://github.com/uutils/coreutils/pull/5871
* Bump mio from 0.8.10 to 0.8.11 by @cakebaker in https://github.com/uutils/coreutils/pull/6045
* Bump chrono to 0.4.35 & replace usage of deprecated functions by @cakebaker in https://github.com/uutils/coreutils/pull/6047
* Bump nix from 0.27 to 0.28 & fix issues due to API changes by @cakebaker in https://github.com/uutils/coreutils/pull/6055
* Bump redox_syscall from 0.4 to 0.5 by @cakebaker in https://github.com/uutils/coreutils/pull/6068

## New Contributors
* @kralo made their first contribution in https://github.com/uutils/coreutils/pull/5890
* @harshRn made their first contribution in https://github.com/uutils/coreutils/pull/5897
* @Ecordonnier made their first contribution in https://github.com/uutils/coreutils/pull/5918
* @SamuelLarkin made their first contribution in https://github.com/uutils/coreutils/pull/5936
* @BaherSalama made their first contribution in https://github.com/uutils/coreutils/pull/5945
* @wolimst made their first contribution in https://github.com/uutils/coreutils/pull/5962
* @BenWiederhake made their first contribution in https://github.com/uutils/coreutils/pull/5979
* @rex4539 made their first contribution in https://github.com/uutils/coreutils/pull/6027
* @ysthakur made their first contribution in https://github.com/uutils/coreutils/pull/5951
* @matrixhead made their first contribution in https://github.com/uutils/coreutils/pull/6050
* @cj-zoltan-kiss made their first contribution in https://github.com/uutils/coreutils/pull/6036
* @Krysztal112233 made their first contribution in https://github.com/uutils/coreutils/pull/6092
* @thesayfulla made their first contribution in https://github.com/uutils/coreutils/pull/6098
* @hanbings made their first contribution in https://github.com/uutils/coreutils/pull/6101

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.24...0.0.25
