/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { MCPServerConfig, GeminiCLIExtension } from '@qwen-code/qwen-code-core';
import { SettingScope } from '../config/settings.js';
export declare const EXTENSIONS_DIRECTORY_NAME: string;
export declare const EXTENSIONS_CONFIG_FILENAME = "qwen-extension.json";
export declare const EXTENSIONS_CONFIG_FILENAME_OLD = "gemini-extension.json";
export declare const INSTALL_METADATA_FILENAME = ".qwen-extension-install.json";
export interface Extension {
    path: string;
    config: ExtensionConfig;
    contextFiles: string[];
    installMetadata?: ExtensionInstallMetadata | undefined;
}
export interface ExtensionConfig {
    name: string;
    version: string;
    mcpServers?: Record<string, MCPServerConfig>;
    contextFileName?: string | string[];
    excludeTools?: string[];
}
export interface ExtensionInstallMetadata {
    source: string;
    type: 'git' | 'local';
}
export interface ExtensionUpdateInfo {
    originalVersion: string;
    updatedVersion: string;
}
export declare class ExtensionStorage {
    private readonly extensionName;
    constructor(extensionName: string);
    getExtensionDir(): string;
    getConfigPath(): string;
    static getUserExtensionsDir(): string;
    static createTmpDir(): Promise<string>;
}
export declare function getWorkspaceExtensions(workspaceDir: string): Extension[];
export declare function performWorkspaceExtensionMigration(extensions: Extension[]): Promise<string[]>;
export declare function loadExtensions(workspaceDir: string): Extension[];
export declare function loadUserExtensions(): Extension[];
export declare function loadExtensionsFromDir(dir: string): Extension[];
export declare function loadExtension(extensionDir: string): Extension | null;
/**
 * Returns an annotated list of extensions. If an extension is listed in enabledExtensionNames, it will be active.
 * If enabledExtensionNames is empty, an extension is active unless it is in list of disabled extensions in settings.
 * @param extensions The base list of extensions.
 * @param enabledExtensionNames The names of explicitly enabled extensions.
 * @param workspaceDir The current workspace directory.
 */
export declare function annotateActiveExtensions(extensions: Extension[], enabledExtensionNames: string[], workspaceDir: string): GeminiCLIExtension[];
export declare function installExtension(installMetadata: ExtensionInstallMetadata, cwd?: string): Promise<string>;
export declare function uninstallExtension(extensionName: string, cwd?: string): Promise<void>;
export declare function toOutputString(extension: Extension): string;
export declare function updateExtension(extensionName: string, cwd?: string): Promise<ExtensionUpdateInfo | undefined>;
export declare function disableExtension(name: string, scope: SettingScope, cwd?: string): void;
export declare function enableExtension(name: string, scopes: SettingScope[]): void;
