import subprocess
import sys

import pytest

from spin.cmds.util import run

skip_on_windows = pytest.mark.skipif(
    sys.platform.startswith("win"), reason="Skipped; platform is Windows"
)

skip_unless_linux = pytest.mark.skipif(
    not sys.platform.startswith("linux"), reason="Skipped; platform not Linux"
)

skip_unless_macos = pytest.mark.skipif(
    not sys.platform.startswith("darwin"), reason="Skipped; platform not macOS"
)

skip_py_lt_311 = pytest.mark.skipif(
    sys.version_info[:2] < (3, 11), reason="Skipped; Python < 3.11"
)


def spin(*args, **user_kwargs):
    args = (str(el) for el in args)
    # Capture stdout, stderr separately
    default_kwargs = {
        "stdout": subprocess.PIPE,
        "stderr": subprocess.PIPE,
        "sys_exit": False,
    }
    p = run(["spin"] + list(args), **{**default_kwargs, **user_kwargs})
    if p.returncode != 0:
        print(p.stdout.decode("utf-8"), end="")
        print(p.stderr.decode("utf-8"), end="")
        # Exit unless the spin call explicitly asks us not to
        # by setting sys_exit=False
        if user_kwargs.get("sys_exit", True):
            sys.exit(p.returncode)
    return p


def stdout(p):
    return p.stdout.decode("utf-8").strip()


def stderr(p):
    return p.stderr.decode("utf-8").strip()


def get_usage(cmd):
    ctx = cmd.make_context(None, [])
    return cmd.get_help(ctx)
