# journalctl

> Запросить записи из журнала systemd.
> Больше информации: <https://www.freedesktop.org/software/systemd/man/journalctl.html>.

- Показать все сообщения с уровнем приоритета 3 (ошибки) с момента текущей загрузки:

`journalctl {{[-b|--boot]}} {{[-p|--priority]}} 3`

- Удалить записи журнала, которые старше 2 дней:

`journalctl --vacuum-time 2d`

- Показать только последние `n` строк и отслеживать новые сообщения (аналогично `tail -f` для традиционного syslog):

`journalctl {{[-n|--lines]}} {{количество}} {{[-f|--follow]}}`

- Показать все сообщения от определенного юнита:

`journalctl {{[-u|--unit]}} {{юнит}}`

- Показать логи для указанного юнита с момента его последнего запуска:

`journalctl _SYSTEMD_INVOCATION_ID=$(systemctl show --value --property=InvocationID {{юнит}})`

- Отфильтровать сообщения по временному диапазону (можно использовать метку времени или плейсхолдеры, такие как "yesterday"):

`journalctl {{[-S|--since]}} {{now|today|yesterday|tomorrow}} {{[-U|--until]}} "{{ГГГГ-ММ-ДД ЧЧ:ММ:СС}}"`

- Показать все сообщения от определенного процесса:

`journalctl _PID={{id_процесса}}`

- Показать все сообщения от определенного исполняемого файла:

`journalctl {{путь/к/исполняемому_файлу}}`
