! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_19

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_19
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_19(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_19
  
  
! [-20kT;19kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867307941634_p
w(1)=10.40132042031513_p
x(2)=-3.761795460646811_p
w(2)=9.598679576143224_p
else if(N==3)then
x(1)=-17.56069690137027_p
w(1)=6.008951988025991_p
x(2)=-9.213298429796698_p
w(2)=9.514823306971520_p
x(3)=-1.155164283035185_p
w(3)=4.476224701460845_p
else if(N==4)then
x(1)=-18.43110491437138_p
w(1)=3.928589467426063_p
x(2)=-12.55788085551937_p
w(2)=7.327533963639898_p
x(3)=-5.008613420170193_p
w(3)=7.006533301213313_p
x(4)=6.702726954596806e-1_p
w(4)=1.737343264179083_p
else if(N==5)then
x(1)=-18.89090621794261_p
w(1)=2.799893227985836_p
x(2)=-14.5528553808479_p
w(2)=5.634684579088588_p
x(3)=-8.252157757238948_p
w(3)=6.589927942730289_p
x(4)=-2.227028788656793_p
w(4)=4.559011614681439_p
x(5)=2.574847356051018_p
w(5)=4.164826319722069e-1_p
else if(N==6)then
x(1)=-19.1643199087578_p
w(1)=2.119453067912400_p
x(2)=-15.81364475558247_p
w(2)=4.448348480719039_p
x(3)=-10.62563437372994_p
w(3)=5.710012995324859_p
x(4)=-4.897449131161411_p
w(4)=5.411430976597063_p
x(5)=-2.123643258610887e-1_p
w(5)=2.256910454234269_p
x(6)=4.855111319321981_p
w(6)=5.384402167072849e-2_p
else if(N==7)then
x(1)=-19.34152615542642_p
w(1)=1.674860956062843_p
x(2)=-16.66030439999633_p
w(2)=3.607239245310709_p
x(3)=-12.34647837283948_p
w(3)=4.884908730204188_p
x(4)=-7.206093039573076_p
w(4)=5.210890364919567_p
x(5)=-2.344119976089479_p
w(5)=3.916231548863814_p
x(6)=1.632316614428218_p
w(6)=7.013080450759883e-1_p
x(7)=7.442357290369917_p
w(7)=4.561106021247109e-3_p
else if(N==8)then
x(1)=-19.46456460393432_p
w(1)=1.364546843468830_p
x(2)=-17.2617513223317_p
w(2)=2.989675259703235_p
x(3)=-13.62759880969867_p
w(3)=4.189711115166416_p
x(4)=-9.091316322965405_p
w(4)=4.762718003902875_p
x(5)=-4.379390592935830_p
w(5)=4.437832317701996_p
x(6)=-3.827482109608433e-1_p
w(6)=2.131265306172542_p
x(7)=3.669522694201822_p
w(7)=1.239177105003788e-1_p
x(8)=10.11679554680551_p
w(8)=3.334398420830210e-4_p
else if(N==9)then
x(1)=-19.55495242260083_p
w(1)=1.135746765100124_p
x(2)=-17.71065019318817_p
w(2)=2.518458515842169_p
x(3)=-14.61441291265935_p
w(3)=3.613341467577683_p
x(4)=-10.62766932154049_p
w(4)=4.277537413199260_p
x(5)=-6.247362630787014_p
w(5)=4.365320424673611_p
x(6)=-2.142330805458851_p
w(6)=3.319809393453413_p
x(7)=1.348401906959567_p
w(7)=7.540903605404180e-1_p
x(8)=5.856775911259898_p
w(8)=1.566738682111185e-2_p
x(9)=12.57116381483631_p
w(9)=2.826925056716833e-5_p
else if(N==10)then
x(1)=-19.62410765077327_p
w(1)=9.602287553343499e-1_p
x(2)=-18.05806155117596_p
w(2)=2.148047011957648_p
x(3)=-15.39540924817398_p
w(3)=3.134573056501959_p
x(4)=-11.89060167648625_p
w(4)=3.816406544727467_p
x(5)=-7.895339198117474_p
w(5)=4.097368028949085_p
x(6)=-3.871616641936594_p
w(6)=3.761279797818262_p
x(7)=-3.801512258964450e-1_p
w(7)=1.907921269903598_p
x(8)=3.121998191309523_p
w(8)=1.722485742305520e-1_p
x(9)=7.989739870095327_p
w(9)=1.923365680773808e-3_p
x(10)=14.52477905355223_p
w(10)=3.591354661436126e-6_p
else if(N==11)then
x(1)=-19.678404391512_p
w(1)=8.221506592241747e-1_p
x(2)=-18.33315783638326_p
w(2)=1.851390287737154_p
x(3)=-16.02404070144006_p
w(3)=2.736034662696629_p
x(4)=-12.93481157779636_p
w(4)=3.399776698688175_p
x(5)=-9.320951064758761_p
w(5)=3.773506292724094_p
x(6)=-5.511036573596715_p
w(6)=3.757528832431767_p
x(7)=-1.949896485526627_p
w(7)=2.865027371606075_p
x(8)=1.171159273940785_p
w(8)=7.631973745286442e-1_p
x(9)=4.939336871943647_p
w(9)=3.111341355566490e-2_p
x(10)=9.921807201010992_p
w(10)=2.736597761575729e-4_p
x(11)=15.90393555097246_p
w(11)=7.434898223781028e-7_p
else if(N==12)then
x(1)=-19.72180771279876_p
w(1)=7.116099194512429e-1_p
x(2)=-18.55448342621448_p
w(2)=1.610684165391012_p
x(3)=-16.53604401182158_p
w(3)=2.403449694649808_p
x(4)=-13.80219909711674_p
w(4)=3.032558461032353_p
x(5)=-10.54264776107058_p
w(5)=3.446377420498201_p
x(6)=-6.999172160105122_p
w(6)=3.586030809970632_p
x(7)=-3.487746757695979_p
w(7)=3.259097063566275_p
x(8)=-3.815035993307972e-1_p
w(8)=1.728763654881865_p
x(9)=2.715993648590466_p
w(9)=2.158818762800248e-1_p
x(10)=6.698488805225346_p
w(10)=5.497794980693148e-3_p
x(11)=11.58377434793714_p
w(11)=4.890186152790162e-5_p
x(12)=16.81681293349883_p
w(12)=2.338947220733192e-7_p
else if(N==13)then
x(1)=-19.75702091354914_p
w(1)=6.218241060877830e-1_p
x(2)=-18.73494345485903_p
w(2)=1.413140775854999_p
x(3)=-16.95746509270141_p
w(3)=2.124685172420935_p
x(4)=-14.52682190489001_p
w(4)=2.712616642762966_p
x(5)=-11.58660262187628_p
w(5)=3.137439538433810_p
x(6)=-8.319328968986724_p
w(6)=3.358670811938496_p
x(7)=-4.954691492671389_p
w(7)=3.294354509900178_p
x(8)=-1.804937181004813_p
w(8)=2.519640713408318_p
x(9)=1.018975730899281_p
w(9)=7.662612081112612e-1_p
x(10)=4.276241768041498_p
w(10)=5.029011278275941e-2_p
x(11)=8.324529407422448_p
w(11)=1.065059522068152e-3_p
x(12)=12.96017321324621_p
w(12)=1.124552601102925e-5_p
x(13)=17.41292700702006_p
w(13)=9.970877228086264e-8_p
else if(N==14)then
x(1)=-19.78596728516148_p
w(1)=5.479497189555571e-1_p
x(2)=-18.88387301590493_p
w(2)=1.249279485109558_p
x(3)=-17.30783581614192_p
w(3)=1.889661235356954_p
x(4)=-15.13624711756657_p
w(4)=2.435049156577656_p
x(5)=-12.47966292472144_p
w(5)=2.854697660511436_p
x(6)=-9.478626708840542_p
w(6)=3.118557365977119_p
x(7)=-6.306247810718687_p
w(7)=3.183254883647376_p
x(8)=-3.190252939917888_p
w(8)=2.871685999506336_p
x(9)=-3.885032826765860e-1_p
w(9)=1.583741080409239_p
x(10)=2.395293142227476_p
w(10)=2.545522533936779e-1_p
x(11)=5.792406795774820_p
w(11)=1.132963786985237e-2_p
x(12)=9.779443438155292_p
w(12)=2.381717425777646e-4_p
x(13)=14.07015920550778_p
w(13)=3.295099365445362e-6_p
x(14)=17.8085746482694_p
w(14)=5.230165351266434e-8_p
else if(N==15)then
x(1)=-19.81004361081715_p
w(1)=4.864590051721042e-1_p
x(2)=-19.00813871705495_p
w(2)=1.111997552031776_p
x(3)=-17.60191429772503_p
w(3)=1.690221556522663_p
x(4)=-15.65243121836284_p
w(4)=2.194308864651181_p
x(5)=-13.24611697456256_p
w(5)=2.599975700777259_p
x(6)=-10.49297620887119_p
w(6)=2.883993737496634_p
x(7)=-7.527064144960627_p
w(7)=3.018706229729287_p
x(8)=-4.516540895101769_p
w(8)=2.929968125506320_p
x(9)=-1.689124481781052_p
w(9)=2.247503389358227_p
x(10)=8.907704750741622e-1_p
w(10)=7.626771255974636e-1_p
x(11)=3.772243699624606_p
w(11)=7.142092259075876e-2_p
x(12)=7.214079496633711_p
w(12)=2.703876738271532e-3_p
x(13)=11.0508517951797_p
w(13)=6.268322130745202e-5_p
x(14)=14.951225001524_p
w(14)=1.195488066413220e-6_p
x(15)=18.07879055740897_p
w(15)=3.157703864967390e-8_p
else if(N==16)then
x(1)=-19.83028098042701_p
w(1)=4.347419252917751e-1_p
x(2)=-19.11285999286303_p
w(2)=9.959251299184761e-1_p
x(3)=-17.85093041008793_p
w(3)=1.519852829125773_p
x(4)=-16.09272689833366_p
w(4)=1.985115139670502_p
x(5)=-13.9067419229739_p
w(5)=2.372288397171841_p
x(6)=-11.38029697936789_p
w(6)=2.662968167800029_p
x(7)=-8.619273241464747_p
w(7)=2.837371182763137_p
x(8)=-5.752358591208486_p
w(8)=2.859097972590988_p
x(9)=-2.950217513990236_p
w(9)=2.563519248439738_p
x(10)=-3.959834884815657e-1_p
w(10)=1.461966338002425_p
x(11)=2.136835584955770_p
w(11)=2.871899347507539e-1_p
x(12)=5.113480209989524_p
w(12)=1.923094554079117e-2_p
x(13)=8.514190892919865_p
w(13)=7.128160773709763e-4_p
x(14)=12.14325773941447_p
w(14)=1.942987502634338e-5_p
x(15)=15.64600318463444_p
w(15)=5.184290480479347e-7_p
x(16)=18.26920694499953_p
w(16)=2.101068316302891e-8_p
else if(N==17)then
x(1)=-19.84745255344157_p
w(1)=3.908378104024764e-1_p
x(2)=-19.20190611880359_p
w(2)=8.969591723847037e-1_p
x(3)=-18.06350823579793_p
w(3)=1.373371269120696_p
x(4)=-16.4708449294664_p
w(4)=1.802779062976433_p
x(5)=-14.47886562570886_p
w(5)=2.169470492326429_p
x(6)=-12.15775001740777_p
w(6)=2.458610924749957_p
x(7)=-9.592415146728484_p
w(7)=2.655099943352401_p
x(8)=-6.884220880671277_p
w(8)=2.737506673081921_p
x(9)=-4.160908686819742_p
w(9)=2.635672209212657_p
x(10)=-1.593220280846775_p
w(10)=2.027221867822040_p
x(11)=7.824794778185448e-1_p
w(11)=7.538253825737263e-1_p
x(12)=3.374344167109271_p
w(12)=9.306107475297133e-2_p
x(13)=6.383417857024225_p
w(13)=5.365697424924827e-3_p
x(14)=9.682456067984011_p
w(14)=2.111204342910616e-4_p
x(15)=13.07128980327874_p
w(15)=7.021174825416947e-6_p
x(16)=16.1941177566051_p
w(16)=2.596871364950943e-7_p
x(17)=18.40744358907493_p
w(17)=1.498076763501307e-8_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;19kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201389907063_p
w(1)=9.919647892511689_p
x(2)=-3.526768543701005_p
w(2)=9.080352107488311_p
else if(N==3)then
x(1)=-16.66602246555822_p
w(1)=5.749158107742921_p
x(2)=-8.682926312789579_p
w(2)=9.091368825964961_p
x(3)=-9.856494589547888e-1_p
w(3)=4.159473066292118_p
else if(N==4)then
x(1)=-17.49428395775053_p
w(1)=3.770211334095687_p
x(2)=-11.85933527577145_p
w(2)=7.027536536629106_p
x(3)=-4.631505407008391_p
w(3)=6.664644356833299_p
x(4)=8.528376681739086e-1_p
w(4)=1.537607772441907_p
else if(N==5)then
x(1)=-17.93263630595417_p
w(1)=2.694434323498973_p
x(2)=-13.75887676087718_p
w(2)=5.419811412409999_p
x(3)=-7.703604972584919_p
w(3)=6.322729187935330_p
x(4)=-1.942562201917986_p
w(4)=4.225858450609169_p
x(5)=2.819267223209448_p
w(5)=3.371666255465285e-1_p
else if(N==6)then
x(1)=-18.19383762391939_p
w(1)=2.044512844614154_p
x(2)=-14.96223586253925_p
w(2)=4.289327073635645_p
x(3)=-9.962524645311815_p
w(3)=5.498174305068574_p
x(4)=-4.460480847847506_p
w(4)=5.154293496435675_p
x(5)=4.088011475433560e-2_p
w(5)=1.973852159412760_p
x(6)=5.171296205537097_p
w(6)=3.984012083319172e-2_p
else if(N==7)then
x(1)=-18.36356292352227_p
w(1)=1.618754661003504_p
x(2)=-15.77257487259712_p
w(2)=3.485207637385900_p
x(3)=-11.60646284620636_p
w(3)=4.715011469383506_p
x(4)=-6.651671996488323_p
w(4)=5.008815656451329_p
x(5)=-1.996997569539249_p
w(5)=3.611576041779739_p
x(6)=1.920888035028816_p
w(6)=5.574533853913169e-1_p
x(7)=7.809330560929925_p
w(7)=3.181148604704568e-3_p
else if(N==8)then
x(1)=-18.48179799773438_p
w(1)=1.320589507745951_p
x(2)=-16.35023356882048_p
w(2)=2.892544171864200_p
x(3)=-12.83531281279262_p
w(3)=4.050612612729738_p
x(4)=-8.453442876988866_p
w(4)=4.594415228776553_p
x(5)=-3.922149198736484_p
w(5)=4.216398783585452_p
x(6)=-8.212336220707424e-2_p
w(6)=1.835304687033255_p
x(7)=4.012551206633916_p
w(7)=8.990722403527872e-2_p
x(8)=10.49677704930889_p
w(8)=2.277842295723042e-4_p
else if(N==9)then
x(1)=-18.568938187062_p
w(1)=1.100028985174350_p
x(2)=-16.78283446526619_p
w(2)=2.438693566350431_p
x(3)=-13.78542955199484_p
w(3)=3.496949952130479_p
x(4)=-9.929392196458803_p
w(4)=4.133967795618012_p
x(5)=-5.703588940475742_p
w(5)=4.193717698724003_p
x(6)=-1.771873855888098_p
w(6)=3.034799024917223_p
x(7)=1.662941962088109_p
w(7)=5.909281125781811e-1_p
x(8)=6.225511006008691_p
w(8)=1.089505657824222e-2_p
x(9)=12.91283776562969_p
w(9)=1.980792907932947e-5_p
else if(N==10)then
x(1)=-18.63574095287005_p
w(1)=9.304927111543148e-1_p
x(2)=-17.11832768323415_p
w(2)=2.081140495564624_p
x(3)=-14.53912498358333_p
w(3)=3.035641194454097_p
x(4)=-11.14637258693587_p
w(4)=3.692411514043001_p
x(5)=-7.285032953523641_p
w(5)=3.952681500081536_p
x(6)=-3.415829089412303_p
w(6)=3.557663127525049_p
x(7)=-5.709064195369063e-2_p
w(7)=1.623854857657394_p
x(8)=3.469177111617920_p
w(8)=1.247791625868555e-1_p
x(9)=8.352356357413807_p
w(9)=1.332769825226644e-3_p
x(10)=14.79229890560242_p
w(10)=2.667107901602403e-6_p
else if(N==11)then
x(1)=-18.68823754226441_p
w(1)=7.969995169125564e-1_p
x(2)=-17.38423985743467_p
w(2)=1.794482663275133_p
x(3)=-15.14645243272433_p
w(3)=2.651049721152230_p
x(4)=-12.15412106048963_p
w(4)=3.291887094708113_p
x(5)=-8.657387860836659_p
w(5)=3.647479996603824_p
x(6)=-4.981949298919756_p
w(6)=3.603658142929072_p
x(7)=-1.569641785970455_p
w(7)=2.598097419118386_p
x(8)=1.498610301451455_p
w(8)=5.943844264908749e-1_p
x(9)=5.301144072710544_p
w(9)=2.176715347346189e-2_p
x(10)=10.25733154019728_p
w(10)=1.932771765794406e-4_p
x(11)=16.09560056101859_p
w(11)=5.881597695430426e-7_p
else if(N==12)then
x(1)=-18.73022266360248_p
w(1)=6.900753520644486e-1_p
x(2)=-17.59829178633116_p
w(2)=1.561749112770104_p
x(3)=-15.64142363870621_p
w(3)=2.329808704708972_p
x(4)=-12.9919830084342_p
w(4)=2.938101597624367_p
x(5)=-9.835505925574497_p
w(5)=3.335233322566845_p
x(6)=-6.410422394052785_p
w(6)=3.457599853920244_p
x(7)=-3.034290023392135_p
w(7)=3.068027314808803_p
x(8)=-4.248933758942090e-2_p
w(8)=1.459036160171450_p
x(9)=3.065901978188152_p
w(9)=1.565033038317639e-1_p
x(10)=7.054994409662700_p
w(10)=3.829446759642136e-3_p
x(11)=11.88077513516901_p
w(11)=3.563593070225744e-5_p
x(12)=16.94989585149283_p
w(12)=1.948426575676384e-7_p
else if(N==13)then
x(1)=-18.76429954445389_p
w(1)=6.031900563604431e-1_p
x(2)=-17.77290017051949_p
w(2)=1.370652848392431_p
x(3)=-16.04904260407255_p
w(3)=2.060358137245684_p
x(4)=-13.69243813106857_p
w(4)=2.629417200270358_p
x(5)=-10.84342789674902_p
w(5)=3.038746224461461_p
x(6)=-7.681416974012339_p
w(6)=3.246278810485339_p
x(7)=-4.435892208577912_p
w(7)=3.152654573313355_p
x(8)=-1.415872836170417_p
w(8)=2.268474953205752_p
x(9)=1.357835900923374_p
w(9)=5.942237999962944e-1_p
x(10)=4.637240890592893_p
w(10)=3.524387307650684e-2_p
x(11)=8.662439608798117_p
w(11)=7.509394315964510e-4_p
x(12)=13.21472582024814_p
w(12)=8.497519823134356e-6_p
x(13)=17.50592328394476_p
w(13)=8.624095791901582e-8_p
else if(N==14)then
x(1)=-18.79232292046124_p
w(1)=5.316734378145334e-1_p
x(2)=-17.91706141936435_p
w(2)=1.212066420245633_p
x(3)=-16.38810189752228_p
w(3)=1.833045910786718_p
x(4)=-14.28189768374483_p
w(4)=2.361326544995562_p
x(5)=-11.70645375756802_p
w(5)=2.766592907031433_p
x(6)=-8.799631809418029_p
w(6)=3.018299298883087_p
x(7)=-5.733195117016030_p
w(7)=3.066718202697731_p
x(8)=-2.737312673037633_p
w(8)=2.690170949753021_p
x(9)=-3.577585061580004e-2_p
w(9)=1.327520623663218_p
x(10)=2.749849656379633_p
w(10)=1.845230892279941e-1_p
x(11)=6.149449074210088_p
w(11)=7.888450872267808e-3_p
x(12)=10.09093867218987_p
w(12)=1.715362821038852e-4_p
x(13)=14.28377959765385_p
w(13)=2.581301356913449e-6_p
x(14)=17.87511582286254_p
w(14)=4.644534052058538e-8_p
else if(N==15)then
x(1)=-18.81564009977686_p
w(1)=4.721231139993144e-1_p
x(2)=-18.0373952061809_p
w(2)=1.079148199157516_p
x(3)=-16.67281011299669_p
w(3)=1.640046824360257_p
x(4)=-14.78143500649401_p
w(4)=2.128608456159044_p
x(5)=-12.44767478836747_p
w(5)=2.520946526401898_p
x(6)=-9.779290486424189_p
w(6)=2.793743672832077_p
x(7)=-6.908647103006909_p
w(7)=2.916924111891265_p
x(8)=-4.005053733085957_p
w(8)=2.796857509478016_p
x(9)=-1.292105318748793_p
w(9)=2.010080350073474_p
x(10)=1.240021585801178_p
w(10)=5.895227367473113e-1_p
x(11)=4.135202353106674_p
w(11)=5.005292193042354e-2_p
x(12)=7.556775583164324_p
w(12)=1.898255140815058e-3_p
x(13)=11.33223494341922_p
w(13)=4.632553897167421e-5_p
x(14)=15.12852202460936_p
w(14)=9.677233240889380e-7_p
x(15)=18.12779234088788_p
w(15)=2.856629356852267e-8_p
else if(N==16)then
x(1)=-18.83524591706781_p
w(1)=4.220210851695899e-1_p
x(2)=-18.13883858521192_p
w(2)=9.667232264370621e-1_p
x(3)=-16.9139852595978_p
w(3)=1.475103244800230_p
x(4)=-15.20772669082141_p
w(4)=1.926247204933000_p
x(5)=-13.08693571917296_p
w(5)=2.301081459019491_p
x(6)=-10.63707366906341_p
w(6)=2.581271452541718_p
x(7)=-7.962352906547506_p
w(7)=2.746067707605162_p
x(8)=-5.191312752721779_p
w(8)=2.751322411095885_p
x(9)=-2.496965482530159_p
w(9)=2.389646930965895_p
x(10)=-3.157791262051330e-2_p
w(10)=1.218473993700743_p
x(11)=2.496651834177452_p
w(11)=2.081533335038811e-1_p
x(12)=5.473165467761794_p
w(12)=1.336416567871810e-2_p
x(13)=8.836351261240535_p
w(13)=5.085778919900710e-4_p
x(14)=12.39385046959734_p
w(14)=1.475571814617949e-5_p
x(15)=15.7926817765441_p
w(15)=4.316763792100126e-7_p
x(16)=18.30632614776082_p
w(16)=1.926210953283375e-8_p
else if(N==17)then
x(1)=-18.85188663780059_p
w(1)=3.794750547960328e-1_p
x(2)=-18.22512471139584_p
w(2)=8.708350937777143e-1_p
x(3)=-17.11994050820455_p
w(3)=1.333228769692604_p
x(4)=-15.57396462411331_p
w(4)=1.749766648615205_p
x(5)=-13.64083675298152_p
w(5)=2.105038980743225_p
x(6)=-11.38919564512598_p
w(6)=2.384340490904250_p
x(7)=-8.902442079874774_p
w(7)=2.572184686662695_p
x(8)=-6.281171092033749_p
w(8)=2.643987340797951_p
x(9)=-3.654872580256004_p
w(9)=2.508788791496325_p
x(10)=-1.189200303160231_p
w(10)=1.801987900208610_p
x(11)=1.141029809994086_p
w(11)=5.812626812526507e-1_p
x(12)=3.740332883138298_p
w(12)=6.519475559015865e-2_p
x(13)=6.731318212088275_p
w(13)=3.749383972140979e-3_p
x(14)=9.980855388072762_p
w(14)=1.537104162042934e-4_p
x(15)=13.29241882214179_p
w(15)=5.475812980027500e-6_p
x(16)=16.31573635226964_p
w(16)=2.213920644825971e-7_p
x(17)=18.43629162900696_p
w(17)=1.386918960139478e-8_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;19kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466045650769_p
w(1)=9.439548676268180_p
x(2)=-3.289241555645433_p
w(2)=8.560451333359003_p
else if(N==3)then
x(1)=-15.77083059255647_p
w(1)=5.490610279188253_p
x(2)=-8.150663914585554_p
w(2)=8.668233687017606_p
x(3)=-8.101004542916992e-1_p
w(3)=3.841156043421324_p
else if(N==4)then
x(1)=-16.55710956394537_p
w(1)=3.612701721118992_p
x(2)=-11.15929222333104_p
w(2)=6.728642905353993_p
x(3)=-4.252954199601130_p
w(3)=6.315438439585288_p
x(4)=1.047481400398760_p
w(4)=1.343216943568911_p
else if(N==5)then
x(1)=-16.97413145248912_p
w(1)=2.589558255431665_p
x(2)=-12.96384634756594_p
w(2)=5.205847705958540_p
x(3)=-7.153598341560452_p
w(3)=6.054032880471338_p
x(4)=-1.655509679331994_p
w(4)=3.882948193482342_p
x(5)=3.081403509036465_p
w(5)=2.676129742832982e-1_p
else if(N==6)then
x(1)=-17.22320662228104_p
w(1)=1.969943213058622_p
x(2)=-14.11014504271133_p
w(2)=4.130927306230010_p
x(3)=-9.298302539437092_p
w(3)=5.286191592524842_p
x(4)=-4.023844025961787_p
w(4)=4.886368999062888_p
x(5)=3.045860239965369e-1_p
w(5)=1.697659072813086_p
x(6)=5.505681611353420_p
w(6)=2.890982593773465e-2_p
else if(N==7)then
x(1)=-17.38552101597623_p
w(1)=1.562844295397994_p
x(2)=-14.88448569063206_p
w(2)=3.363502380039952_p
x(3)=-10.86585730985428_p
w(3)=4.545098118748626_p
x(4)=-6.097474115907502_p
w(4)=4.802836329501618_p
x(5)=-1.649960390374936_p
w(5)=3.291027947744700_p
x(6)=2.227793922992730_p
w(6)=4.325075744412202e-1_p
x(7)=8.191436238077859_p
w(7)=2.183363753072467e-3_p
else if(N==8)then
x(1)=-17.4990056939518_p
w(1)=1.276695062351259_p
x(2)=-15.43860859230962_p
w(2)=2.795492728307840_p
x(3)=-12.04291363835535_p
w(3)=3.911377432385539_p
x(4)=-7.815994959171312_p
w(4)=4.424515986137416_p
x(5)=-3.467780814424857_p
w(5)=3.980071458674921_p
x(6)=2.271756820451352e-1_p
w(6)=1.547788402774185_p
x(7)=4.372741852996785_p
w(7)=6.390483931364029e-2_p
x(8)=10.88482768683355_p
w(8)=1.540996823830427e-4_p
else if(N==9)then
x(1)=-17.58292412989127_p
w(1)=1.064309120279928_p
x(2)=-15.85503470787126_p
w(2)=2.358888069520325_p
x(3)=-12.95656570127472_p
w(3)=3.380357046169118_p
x(4)=-9.231659567314198_p
w(4)=3.989524703647991_p
x(5)=-5.162064921185908_p
w(5)=4.015657495214958_p
x(6)=-1.402958258388562_p
w(6)=2.732534949221300_p
x(7)=1.993980410481775_p
w(7)=4.512407470402128e-1_p
x(8)=6.605919278976768_p
w(8)=7.474025710252614e-3_p
x(9)=13.25351228685093_p
w(9)=1.385282309760850e-5_p
else if(N==10)then
x(1)=-17.64738032486149_p
w(1)=9.007400813910120e-1_p
x(2)=-16.17863507461288_p
w(2)=2.014173388550916_p
x(3)=-13.68299095679352_p
w(3)=2.936531983668285_p
x(4)=-10.40260755859891_p
w(4)=3.567871960320003_p
x(5)=-6.676205458551171_p
w(5)=3.805295121083485_p
x(6)=-2.964014484138506_p
w(6)=3.336383352441032_p
x(7)=2.738431881599677e-1_p
w(7)=1.349515748288109_p
x(8)=3.831660701559677_p
w(8)=8.857048067143707e-2_p
x(9)=8.721516344369705_p
w(9)=9.159065209185491e-4_p
x(10)=15.05347164827027_p
w(10)=1.986691985479685e-6_p
else if(N==11)then
x(1)=-17.69807629969583_p
w(1)=7.718332857297052e-1_p
x(2)=-16.43535781584539_p
w(2)=1.737524833510707_p
x(3)=-14.26898541196053_p
w(3)=2.565931699563699_p
x(4)=-11.37377347496417_p
w(4)=3.183640393652716_p
x(5)=-7.994790652829071_p
w(5)=3.520149064215365_p
x(6)=-4.455783754612224_p
w(6)=3.441182661981817_p
x(7)=-1.190678981727738_p
w(7)=2.314039724579839_p
x(8)=1.841332682157302_p
w(8)=4.505368390177792e-1_p
x(9)=5.673847232595441_p
w(9)=1.502512339177844e-2_p
x(10)=10.59534198324776_p
w(10)=1.359167935238618e-4_p
x(11)=16.28033361627596_p
w(11)=4.671902527033919e-7_p
else if(N==12)then
x(1)=-17.73864222317997_p
w(1)=6.685284495416904e-1_p
x(2)=-16.64212903164296_p
w(2)=1.512774545823471_p
x(3)=-14.74689747590464_p
w(3)=2.256068088978131_p
x(4)=-12.18202121045296_p
w(4)=2.843397909044185_p
x(5)=-9.129026008692168_p
w(5)=3.223355957328006_p
x(6)=-5.823540112219566_p
w(6)=3.325424838052252_p
x(7)=-2.584851126854168_p
w(7)=2.857440123182599_p
x(8)=3.041526220435899e-1_p
w(8)=1.199256940030373_p
x(9)=3.430412257859110_p
w(9)=1.110830626867905e-1_p
x(10)=7.418497582662791_p
w(10)=2.644002044834962e-3_p
x(11)=12.17736420835922_p
w(11)=2.593006054344557e-5_p
x(12)=17.07750009642166_p
w(12)=1.628543068428429e-7_p
else if(N==13)then
x(1)=-17.77158212670315_p
w(1)=5.845454916568226e-1_p
x(2)=-16.81088108007618_p
w(2)=1.328132553880069_p
x(3)=-15.14069633337221_p
w(3)=1.995953527992831_p
x(4)=-12.85825121039334_p
w(4)=2.546037989928847_p
x(5)=-10.10073354807793_p
w(5)=2.939590048046375_p
x(6)=-7.044736819919814_p
w(6)=3.132104502660866_p
x(7)=-3.920359590562118_p
w(7)=3.000310196519546_p
x(8)=-1.027688657952875_p
w(8)=2.000559463598152_p
x(9)=1.711009494123855_p
w(9)=4.478782244408404e-1_p
x(10)=5.009026520767345_p
w(10)=2.435498467843305e-2_p
x(11)=9.004278330550596_p
w(11)=5.265286728886945e-4_p
x(12)=13.467137309318_p
w(12)=6.422790703735561e-6_p
x(13)=17.59504501800487_p
w(13)=7.476080832494252e-8_p
else if(N==14)then
x(1)=-17.79868205596949_p
w(1)=5.153878933721978e-1_p
x(2)=-16.95027077917025_p
w(2)=1.174825932121295_p
x(3)=-15.46843180665613_p
w(3)=1.776368062565693_p
x(4)=-13.42770638800023_p
w(4)=2.287467395554758_p
x(5)=-10.93360988876919_p
w(5)=2.678171159970781_p
x(6)=-8.121498082965950_p
w(6)=2.917072216686728_p
x(7)=-5.162357257775585_p
w(7)=2.945248008719567_p
x(8)=-2.288301389495244_p
w(8)=2.487868399597932_p
x(9)=3.242726352060829e-1_p
w(9)=1.081196352811623_p
x(10)=3.118429437566275_p
w(10)=1.308280247827885e-1_p
x(11)=6.513814771075997_p
w(11)=5.441348500069935e-3_p
x(12)=10.40405235646768_p
w(12)=1.231491802455474e-4_p
x(13)=14.49449770932679_p
w(13)=2.024462710852894e-6_p
x(14)=17.93899552379455_p
w(14)=4.130079214029586e-8_p
else if(N==15)then
x(1)=-17.82123972823501_p
w(1)=4.577789524113309e-1_p
x(2)=-17.06667013911548_p
w(2)=1.046275172197351_p
x(3)=-15.74376048166946_p
w(3)=1.589820476321148_p
x(4)=-13.91056912223475_p
w(4)=2.062801014110287_p
x(5)=-11.6495201282291_p
w(5)=2.441687546670595_p
x(6)=-9.066238264066774_p
w(6)=2.702901067296646_p
x(7)=-6.291733772439904_p
w(7)=2.812765267659722_p
x(8)=-3.497082138477984_p
w(8)=2.651223779057197_p
x(9)=-8.956131591033363e-1_p
w(9)=1.756531404915031_p
x(10)=1.602677389468021_p
w(10)=4.422938093313009e-1_p
x(11)=4.508867400004648_p
w(11)=3.456221367068922e-2_p
x(12)=7.904130478510790_p
w(12)=1.324311938587509e-3_p
x(13)=11.61361853089691_p
w(13)=3.418371381337143e-5_p
x(14)=15.3027946445516_p
w(14)=7.844724701441062e-7_p
x(15)=18.17495616593134_p
w(15)=2.586101361365396e-8_p
else if(N==16)then
x(1)=-17.84021368085129_p
w(1)=4.092928250089044e-1_p
x(2)=-17.16483353365031_p
w(2)=9.375006633357109e-1_p
x(3)=-15.97708732431211_p
w(3)=1.430310312227628_p
x(4)=-14.32283585602434_p
w(4)=1.867293297521144_p
x(5)=-12.26736173853452_p
w(5)=2.229700932745734_p
x(6)=-9.894335240203738_p
w(6)=2.499178749752142_p
x(7)=-7.306497278894081_p
w(7)=2.653496827434323_p
x(8)=-4.632784957174990_p
w(8)=2.637336734632171_p
x(9)=-2.047469265084305_p
w(9)=2.194221323994991_p
x(10)=3.398246538798630e-1_p
w(10)=9.846992370114335e-1_p
x(11)=2.869932793519867_p
w(11)=1.474007510028620e-1_p
x(12)=5.840402186371603_p
w(12)=9.195417976637419e-3_p
x(13)=9.161165676379248_p
w(13)=3.613585135412867e-4_p
x(14)=12.64341372671693_p
w(14)=1.120087430609497e-5_p
x(15)=15.93655096953059_p
w(15)=3.599318558126475e-7_p
x(16)=18.34215193769481_p
w(16)=1.766379957951319e-8_p
else if(N==17)then
x(1)=-17.85632327204321_p
w(1)=3.681056266322234e-1_p
x(2)=-17.24835787501306_p
w(2)=8.446928526517619e-1_p
x(3)=-16.17641400826938_p
w(3)=1.293049381231502_p
x(4)=-14.67717738135658_p
w(4)=1.696683820862850_p
x(5)=-12.80299924001071_p
w(5)=2.040472211139730_p
x(6)=-10.62102393281176_p
w(6)=2.309787936082047_p
x(7)=-8.213256661735043_p
w(7)=2.488517314069405_p
x(8)=-5.679878940401747_p
w(8)=2.547393015057865_p
x(9)=-3.152497809120680_p
w(9)=2.367732126436541_p
x(10)=-7.853897941023232e-1_p
w(10)=1.561416582132140_p
x(11)=1.512143170350116_p
w(11)=4.344694289092895e-1_p
x(12)=4.116937923059793_p
w(12)=4.496158141464611e-2_p
x(13)=7.084342656855272_p
w(13)=2.602038161042780e-3_p
x(14)=10.28043589512493_p
w(14)=1.116216526855233e-4_p
x(15)=13.51194206162405_p
w(15)=4.271392683530726e-6_p
x(16)=16.43489392419416_p
w(16)=1.889611159218650e-7_p
x(17)=18.46420821104735_p
w(17)=1.283965388937344e-8_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;19kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653116041374_p
w(1)=8.961195650019476_p
x(2)=-3.048806268655201_p
w(2)=8.038804385777103_p
else if(N==3)then
x(1)=-14.87507806064197_p
w(1)=5.233407684384698_p
x(2)=-7.616422524781421_p
w(2)=8.245050062500097_p
x(3)=-6.275471843665559e-1_p
w(3)=3.521542288911786_p
else if(N==4)then
x(1)=-15.61956219802272_p
w(1)=3.456105945401317_p
x(2)=-10.45770024053047_p
w(2)=6.430797969749945_p
x(3)=-3.873020998086850_p
w(3)=5.957238117321815_p
x(4)=1.255916190941393_p
w(4)=1.155858003323502_p
else if(N==5)then
x(1)=-16.01538484231212_p
w(1)=2.485280231197553_p
x(2)=-12.16775119665278_p
w(2)=4.992765634300654_p
x(3)=-6.602292814794508_p
w(3)=5.782959889222541_p
x(4)=-1.365003554528225_p
w(4)=3.531091115097432_p
x(5)=3.362762753665543_p
w(5)=2.079031659784003e-1_p
else if(N==6)then
x(1)=-16.25242781515784_p
w(1)=1.895740689731033_p
x(2)=-13.25738832108284_p
w(2)=3.973111477151696_p
x(3)=-8.633093457990601_p
w(3)=5.073732007254383_p
x(4)=-3.587934291474606_p
w(4)=4.604869919196152_p
x(5)=5.809602827790589e-1_p
w(5)=1.431988314093835_p
x(6)=5.859069611426123_p
w(6)=2.055762836948037e-2_p
else if(N==7)then
x(1)=-16.40740649838192_p
w(1)=1.507113738049231_p
x(2)=-13.99607420125281_p
w(2)=3.242071842015079_p
x(3)=-10.12479315541865_p
w(3)=4.374982574794365_p
x(4)=-5.543975323805296_p
w(4)=4.591329571620963_p
x(5)=-1.302045596701555_p
w(5)=2.956051137047312_p
x(6)=2.554616468123363_p
w(6)=3.269767064221436e-1_p
x(7)=8.588724049789217_p
w(7)=1.474465847485781e-3_p
else if(N==8)then
x(1)=-16.5161945934017_p
w(1)=1.232845503070734_p
x(2)=-14.52691555992173_p
w(2)=2.698471701192717_p
x(3)=-11.25051741399778_p
w(3)=3.771881006921558_p
x(4)=-7.179311148821416_p
w(4)=4.252340451307130_p
x(5)=-3.016774161239048_p
w(5)=3.725428789277018_p
x(6)=5.477181519404816e-1_p
w(6)=1.274427614697949_p
x(7)=4.750226470536766_p
w(7)=4.450165494117192e-2_p
x(8)=11.27996201312254_p
w(8)=1.033143883016870e-4_p
else if(N==9)then
x(1)=-16.5969147747659_p
w(1)=1.028575352791982_p
x(2)=-14.92727667103213_p
w(2)=2.279009655205086_p
x(3)=-12.1278969349628_p
w(3)=3.263485826793299_p
x(4)=-8.534677881567683_p
w(4)=3.843900859054965_p
x(5)=-4.623372737738165_p
w(5)=3.828726344738755_p
x(6)=-1.034172755772330_p
w(6)=2.415875011521329_p
x(7)=2.342924467430739_p
w(7)=3.353576536511927e-1_p
x(8)=6.997643031470457_p
w(8)=5.059652678117665e-3_p
x(9)=13.59187748463762_p
w(9)=9.679361853798041e-6_p
else if(N==10)then
x(1)=-16.65902843991254_p
w(1)=8.709638445063119e-1_p
x(2)=-15.23899924792773_p
w(2)=1.947125784661769_p
x(3)=-12.82705377868203_p
w(3)=2.837197754134651_p
x(4)=-9.659432253794133_p
w(4)=3.442629575654502_p
x(5)=-6.069235472953351_p
w(5)=3.654129478655362_p
x(6)=-2.516387376644807_p
w(6)=3.094052780928119_p
x(7)=6.154090159135474e-1_p
w(7)=1.091645880370595_p
x(8)=4.209444898064644_p
w(8)=6.162895987646202e-2_p
x(9)=9.096708958955672_p
w(9)=6.244918183274419e-4_p
x(10)=15.30756263123737_p
w(10)=1.485190480776585e-6_p
else if(N==11)then
x(1)=-16.70792261327709_p
w(1)=7.466468424916481e-1_p
x(2)=-15.48652302962274_p
w(2)=1.680502316331887_p
x(3)=-13.39167330516431_p
w(3)=2.480647117453433_p
x(4)=-10.59385570384366_p
w(4)=3.074942150370110_p
x(5)=-7.333402160321755_p
w(5)=3.391028614576255_p
x(6)=-3.933118339024905_p
w(6)=3.266967667113224_p
x(7)=-8.112490006441966e-1_p
w(7)=2.016869355221420_p
x(8)=2.200701914368714_p
w(8)=3.320629597291810e-1_p
x(9)=6.057117202169535_p
w(9)=1.023743127248201e-2_p
x(10)=10.93528878436018_p
w(10)=9.520855541438389e-5_p
x(11)=16.4579497249833_p
w(11)=3.726815257511653e-7_p
else if(N==12)then
x(1)=-16.74706802489222_p
w(1)=6.469649315777294e-1_p
x(2)=-15.6860045225286_p
w(2)=1.463748673716040_p
x(3)=-13.85249260706626_p
w(3)=2.182202105285171_p
x(4)=-11.37237981197093_p
w(4)=2.748384224298786_p
x(5)=-8.423374830584484_p
w(5)=3.110500961628834_p
x(6)=-5.238981331361954_p
w(6)=3.187911721003832_p
x(7)=-2.139411441303930_p
w(7)=2.624259906185673_p
x(8)=6.612222522813698e-1_p
w(8)=9.569490617431261e-1_p
x(9)=3.809484636357466_p
w(9)=7.724928029866010e-2_p
x(10)=7.788604205759153_p
w(10)=1.810186712365729e-3_p
x(11)=12.47305528541653_p
w(11)=1.884677863549485e-5_p
x(12)=17.19966341254053_p
w(12)=1.365677271915374e-7_p
else if(N==13)then
x(1)=-16.77887006437984_p
w(1)=5.658867424197896e-1_p
x(2)=-15.84889413351017_p
w(2)=1.285570021926401_p
x(3)=-14.23244872859427_p
w(3)=1.931450822053853_p
x(4)=-12.02431351822466_p
w(4)=2.462433629594228_p
x(5)=-9.358641097363172_p
w(5)=2.839831479410075_p
x(6)=-6.409602472514947_p
w(6)=3.015397951997685_p
x(7)=-3.408660061611857_p
w(7)=2.833595822590841_p
x(8)=-6.384013970557604e-1_p
w(8)=1.720968810680892_p
x(9)=2.079852193732572_p
w(9)=3.278862731535628e-1_p
x(10)=5.391228307469243_p
w(10)=1.660630203530196e-2_p
x(11)=9.349639071237036_p
w(11)=3.672576840275102e-4_p
x(12)=13.7170467888276_p
w(12)=4.857300822287663e-6_p
x(13)=17.68037339082471_p
w(13)=6.494910142045269e-8_p
else if(N==14)then
x(1)=-16.80504589925959_p
w(1)=4.990899361103400e-1_p
x(2)=-15.98350786979456_p
w(2)=1.137549703317227_p
x(3)=-14.54884431915548_p
w(3)=1.719611032706930_p
x(4)=-12.57371558350871_p
w(4)=2.213437569426937_p
x(5)=-10.16122360727765_p
w(5)=2.589344039817776_p
x(6)=-7.444444113129023_p
w(6)=2.814501654071226_p
x(7)=-4.594255449425849_p
w(7)=2.816688871299568_p
x(8)=-1.842965947899698_p
w(8)=2.262243348339529_p
x(9)=6.944408991584702e-1_p
w(9)=8.529104385412997e-1_p
x(10)=3.500981806678509_p
w(10)=9.081363940792234e-2_p
x(11)=6.885120164502248_p
w(11)=3.720021076253643e-3_p
x(12)=10.71840771064204_p
w(12)=8.815506500381801e-5_p
x(13)=14.70208119209279_p
w(13)=1.589844202647039e-6_p
x(14)=18.0002835021724_p
w(14)=3.677236380701539e-8_p
else if(N==15)then
x(1)=-16.82684353684462_p
w(1)=4.434238105675962e-1_p
x(2)=-16.09596931170567_p
w(2)=1.013371417810686_p
x(3)=-14.81478123469143_p
w(3)=1.539528795304355_p
x(4)=-13.03986836314602_p
w(4)=1.996859990866090_p
x(5)=-10.85172532896766_p
w(5)=2.362138200383088_p
x(6)=-8.353977929862728_p
w(6)=2.611260195879936_p
x(7)=-5.676704196558107_p
w(7)=2.705148290958885_p
x(8)=-2.993131695709111_p
w(8)=2.488939020411853_p
x(9)=-4.974945849250107e-1_p
w(9)=1.492887553922675_p
x(10)=1.980092867689347_p
w(10)=3.219634674490662e-1_p
x(11)=4.892832647592315_p
w(11)=2.353503249336227e-2_p
x(12)=8.255784385325130_p
w(12)=9.184078946406161e-4_p
x(13)=11.89468415091981_p
w(13)=2.519154441981617e-5_p
x(14)=15.47390905995792_p
w(14)=6.368833856462425e-7_p
x(15)=18.2203322689217_p
w(15)=2.342654009705146e-8_p
else if(N==16)then
x(1)=-16.84518517267459_p
w(1)=3.965548019253876e-1_p
x(2)=-16.19084982599584_p
w(2)=9.082514143855838e-1_p
x(3)=-15.04025006802466_p
w(3)=1.385462588084146_p
x(4)=-13.43808338533348_p
w(4)=1.808232237456676_p
x(5)=-11.44807809944553_p
w(5)=2.158102837841184_p
x(6)=-9.152201128591908_p
w(6)=2.416565759341709_p
x(7)=-6.651976343500731_p
w(7)=2.559108340956071_p
x(8)=-4.077332901642092_p
w(8)=2.514429295138462_p
x(9)=-1.601243225642185_p
w(9)=1.975410123909547_p
x(10)=7.209980797007222e-1_p
w(10)=7.692427728552902e-1_p
x(11)=3.256644517236387_p
w(11)=1.021074019054018e-1_p
x(12)=6.214792298077462_p
w(12)=6.267882193826067e-3_p
x(13)=9.488308019355831_p
w(13)=2.557629482834667e-4_p
x(14)=12.89169738771003_p
w(14)=8.500125528852127e-6_p
x(15)=16.07754074546341_p
w(15)=3.005282755890831e-7_p
x(16)=18.3767186640612_p
w(16)=1.620120745643263e-8_p
else if(N==17)then
x(1)=-16.86076324032663_p
w(1)=3.567274888182351e-1_p
x(2)=-16.27160992961765_p
w(2)=8.185272612639759e-1_p
x(3)=-15.2329402830529_p
w(3)=1.252823445898342_p
x(4)=-13.78050765160557_p
w(4)=1.643513333264350_p
x(5)=-11.96540071876821_p
w(5)=1.975736838213463_p
x(6)=-9.853327996970323_p
w(6)=2.234871777671342_p
x(7)=-7.525055396930957_p
w(7)=2.403799099124294_p
x(8)=-5.080780605085613_p
w(8)=2.446260414255817_p
x(9)=-2.654191868411418_p
w(9)=2.208174136469315_p
x(10)=-3.795119268621795e-1_p
w(10)=1.312369674075263_p
x(11)=1.897182255174219_p
w(11)=3.147597584259108e-1_p
x(12)=4.503730413858179_p
w(12)=3.055835097211947e-2_p
x(13)=7.442142243944804_p
w(13)=1.794085537788435e-3_p
x(14)=10.58091349884793_p
w(14)=8.086551282300408e-5_p
x(15)=13.72967347715674_p
w(15)=3.332943934702843e-6_p
x(16)=16.55155751196377_p
w(16)=1.614642901761179e-7_p
x(17)=18.49121658386315_p
w(17)=1.188531560222970e-8_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;19kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753472318929_p
w(1)=8.484774879831503_p
x(2)=-2.804963042535969_p
w(2)=7.515225227100869_p
else if(N==3)then
x(1)=-13.97871957910064_p
w(1)=4.977651875492455_p
x(2)=-7.080132791331680_p
w(2)=7.821263566528694_p
x(3)=-4.368155571490870e-1_p
w(3)=3.201084664911222_p
else if(N==4)then
x(1)=-14.68162315785548_p
w(1)=3.300466092091263_p
x(2)=-9.754524319405604_p
w(2)=6.133885419526512_p
x(3)=-3.491744359171638_p
w(3)=5.588176877256286_p
x(4)=1.480095035756116_p
w(4)=9.774717180583112e-1_p
else if(N==5)then
x(1)=-15.05639142473783_p
w(1)=2.381610414109515_p
x(2)=-11.37059280440013_p
w(2)=4.780506907837298_p
x(3)=-6.049918646588747_p
w(3)=5.508260029302417_p
x(4)=-1.069839518675824_p
w(4)=3.171793948014532_p
x(5)=3.664880234237972_p
w(5)=1.578288076686105e-1_p
else if(N==6)then
x(1)=-15.28150428803854_p
w(1)=1.821895941308700_p
x(2)=-12.40399564857078_p
w(2)=3.815820085599147_p
x(3)=-7.967080960729522_p
w(3)=4.860303158232063_p
x(4)=-3.153115076243476_p
w(4)=4.306703353238253_p
x(5)=8.725141346234616e-1_p
w(5)=1.180963027666195_p
x(6)=6.232230050807538_p
w(6)=1.431454088801383e-2_p
else if(N==7)then
x(1)=-15.42922748331012_p
w(1)=1.451541459731032_p
x(2)=-13.10738983024167_p
w(2)=3.120847723310484_p
x(3)=-9.383443345359119_p
w(3)=4.204404219078649_p
x(4)=-4.991765483480294_p
w(4)=4.372035406817784_p
x(5)=-9.517570432557572e-1_p
w(5)=2.609670015552905_p
x(6)=2.902777880021518_p
w(6)=2.405215695391961e-1_p
x(7)=9.001094853245061_p
w(7)=9.797129023222026e-4_p
else if(N==8)then
x(1)=-15.53337277167433_p
w(1)=1.189019700820866_p
x(2)=-13.6152006778829_p
w(2)=2.601422086016972_p
x(3)=-10.45826426995369_p
w(3)=3.631961553442594_p
x(4)=-6.543812804951138_p
w(4)=4.076893723054496_p
x(5)=-2.569437216041262_p
w(5)=3.449112236350028_p
x(6)=8.823157937217735e-1_p
w(6)=1.021154978839020_p
x(7)=5.144997431198521_p
w(7)=3.036712453003594e-2_p
x(8)=11.68098517281391_p
w(8)=6.870387835990115e-5_p
else if(N==9)then
x(1)=-15.61091525070326_p
w(1)=9.928142274203614e-1_p
x(2)=-13.99958990845349_p
w(2)=2.199020431036652_p
x(3)=-11.2995123947824_p
w(3)=3.146239211017844_p
x(4)=-7.838702307652698_p
w(4)=3.696649189781665_p
x(5)=-4.088169962763279_p
w(5)=3.629680755954092_p
x(6)=-6.634447222938998e-1_p
w(6)=2.089825677364392_p
x(7)=2.710900696140762_p
w(7)=2.423824430344002e-1_p
x(8)=7.400250023826009_p
w(8)=3.381407108785085e-3_p
x(9)=13.92657290666058_p
w(9)=6.764214179230857e-6_p
else if(N==10)then
x(1)=-15.67068848861969_p
w(1)=8.411555897473014e-1_p
x(2)=-14.29943887204846_p
w(2)=1.879973404708189_p
x(3)=-11.97137046511667_p
w(3)=2.737577455025473_p
x(4)=-8.917005311956743_p
w(4)=3.316457590759503_p
x(5)=-5.464598975249143_p
w(5)=3.497582920570443_p
x(6)=-2.072819316842974_p
w(6)=2.827956686455469_p
x(7)=9.705031828604784e-1_p
w(7)=8.568125761423607e-1_p
x(8)=4.602386188858056_p
w(8)=4.206012155688618e-2_p
x(9)=9.477364372570253_p
w(9)=4.226470834943986e-4_p
x(10)=15.55389850407751_p
w(10)=1.114883252327725e-6_p
else if(N==11)then
x(1)=-15.71777891276145_p
w(1)=7.214337864629402e-1_p
x(2)=-14.53774963472344_p
w(2)=1.623396887892301_p
x(3)=-12.51455844152576_p
w(3)=2.395152686030743_p
x(4)=-9.814478865396323_p
w(4)=2.965659953641199_p
x(5)=-6.673537472423963_p
w(5)=3.259378579207176_p
x(6)=-3.414556729648229_p
w(6)=3.076997767541347_p
x(7)=-4.288989707525538e-1_p
w(7)=1.713130876323931_p
x(8)=2.577746003597720_p
w(8)=2.378943626275566e-1_p
x(9)=6.450571785777105_p
w(9)=6.888444132823897e-3_p
x(10)=11.27658278606389_p
w(10)=6.646448188393044e-5_p
x(11)=16.62831496958943_p
w(11)=2.985904696249856e-7_p
else if(N==12)then
x(1)=-15.75550211474488_p
w(1)=6.253794246862904e-1_p
x(2)=-14.72992999761202_p
w(2)=1.414656622562301_p
x(3)=-12.95824314285139_p
w(3)=2.108177644463061_p
x(4)=-10.56314309572838_p
w(4)=2.652974112330485_p
x(5)=-7.718769411440165_p
w(5)=2.996298075884468_p
x(6)=-4.657308055556010_p
w(6)=3.042725865111685_p
x(7)=-1.697472215504946_p
w(7)=2.366754975904567_p
x(8)=1.031569445276048_p
w(8)=7.391118879213505e-1_p
x(9)=4.202910972287154_p
w(9)=5.267830937871350e-2_p
x(10)=8.164880526041964_p
w(10)=1.229385204369663e-3_p
x(11)=12.76734701482322_p
w(11)=1.368858978653740e-5_p
x(12)=17.31644531650799_p
w(12)=1.148952948785487e-7_p
else if(N==13)then
x(1)=-15.78616510774985_p
w(1)=5.472092239322364e-1_p
x(2)=-14.88694925403187_p
w(2)=1.242952862296840_p
x(3)=-13.32432792141057_p
w(3)=1.866823836783579_p
x(4)=-11.19069136693391_p
w(4)=2.378543325338715_p
x(5)=-8.617307514878950_p
w(5)=2.739264065203892_p
x(6)=-5.776418848194468_p
w(6)=2.895003245494103_p
x(7)=-2.901304337970234_p
w(7)=2.648024759615670_p
x(8)=-2.453265117816035e-1_p
w(8)=1.437579899637792_p
x(9)=2.465317844234723_p
w(9)=2.331609794484059e-1_p
x(10)=5.783427750618035_p
w(10)=1.117925514346728e-2_p
x(11)=9.698086340668194_p
w(11)=2.549210839776503e-4_p
x(12)=13.96409522693279_p
w(12)=3.676412578605242e-6_p
x(13)=17.76199633643935_p
w(13)=5.654111429949408e-8_p
else if(N==14)then
x(1)=-15.81141594984661_p
w(1)=4.827756459406914e-1_p
x(2)=-15.0167811153081_p
w(2)=1.100227334344257_p
x(3)=-13.6293628695613_p
w(3)=1.662753702091531_p
x(4)=-11.71997859637837_p
w(4)=2.139192063504745_p
x(5)=-9.389413185805436_p
w(5)=2.499984385613919_p
x(6)=-6.768754650971984_p
w(6)=2.710003630814288_p
x(7)=-4.029504287143062_p
w(7)=2.677960925183158_p
x(8)=-1.400453763449435_p
w(8)=2.012789999737220_p
x(9)=1.077502029174260_p
w(9)=6.499391015960011e-1_p
x(10)=3.897257954672921_p
w(10)=6.178739363489902e-2_p
x(11)=7.262954815592832_p
w(11)=2.521699619825467e-3_p
x(12)=11.0336108689385_p
w(12)=6.294169630533811e-5_p
x(13)=14.90630610971824_p
w(13)=1.250377264776235e-6_p
x(14)=18.05905095454618_p
w(14)=3.277826717350654e-8_p
else if(N==15)then
x(1)=-15.83245281491386_p
w(1)=4.290543231436207e-1_p
x(2)=-15.12529991447815_p
w(2)=9.804281394057153e-1_p
x(3)=-13.88589207884545_p
w(3)=1.489154468104883_p
x(4)=-12.16937636901413_p
w(4)=1.930750804234094_p
x(5)=-10.05438247435133_p
w(5)=2.282213588005769_p
x(6)=-7.642715361487008_p
w(6)=2.518503462883500_p
x(7)=-5.064040769107685_p
w(7)=2.592412535948085_p
x(8)=-2.493553870564043_p
w(8)=2.305396706566447_p
x(9)=-9.491262757465807e-2_p
w(9)=1.228124342230341_p
x(10)=2.373177205710648_p
w(10)=2.274921590118207e-1_p
x(11)=5.286642641221332_p
w(11)=1.581715466761094e-2_p
x(12)=8.611357149811187_p
w(12)=6.333382495066947e-4_p
x(13)=12.17510600349478_p
w(13)=1.854536996348558e-5_p
x(14)=15.64174008187585_p
w(14)=5.178785122957673e-7_p
x(15)=18.26397082611649_p
w(15)=2.123250294068608e-8_p
else if(N==16)then
x(1)=-15.85016150709273_p
w(1)=3.838041103910020e-1_p
x(2)=-15.21689364092457_p
w(2)=8.789679770291309e-1_p
x(3)=-14.10349021968761_p
w(3)=1.340545676749116_p
x(4)=-12.55350553053302_p
w(4)=1.749036679952721_p
x(5)=-10.62915839271853_p
w(5)=2.086226853437848_p
x(6)=-8.410825659525349_p
w(6)=2.333244634581964_p
x(7)=-5.999140994905028_p
w(7)=2.462032746452731_p
x(8)=-3.525576130811395_p
w(8)=2.378850671227326_p
x(9)=-1.157109099550357_p
w(9)=1.734055299681770_p
x(10)=1.114624954988409_p
w(10)=5.795221484691234e-1_p
x(11)=3.656524136659005_p
w(11)=6.929163027504465e-2_p
x(12)=6.595919457877284_p
w(12)=4.234587561646689e-3_p
x(13)=9.817437939734493_p
w(13)=1.803749772164253e-4_p
x(14)=13.1384501059174_p
w(14)=6.450003792137969e-6_p
x(15)=16.2155876847914_p
w(15)=2.512806017689944e-7_p
x(16)=18.410060315096_p
w(16)=1.486133778413366e-8_p
else if(N==17)then
x(1)=-15.86520751177815_p
w(1)=3.453381175694725e-1_p
x(2)=-15.29488622058486_p
w(2)=7.923318694341850e-1_p
x(3)=-14.28953365951271_p
w(3)=1.212538845534243_p
x(4)=-12.88398593856544_p
w(4)=1.590233071542958_p
x(5)=-11.12810124439872_p
w(5)=1.910787927261468_p
x(6)=-9.086227379038464_p
w(6)=2.159471945088723_p
x(7)=-6.838094844272905_p
w(7)=2.317555944613305_p
x(8)=-4.484416712244126_p
w(8)=2.338371081684962_p
x(9)=-2.160103463716937_p
w(9)=2.025723473236916_p
x(10)=3.135756882190408e-2_p
w(10)=1.064677556997521_p
x(11)=2.297028842667796_p
w(11)=2.211902420072317e-1_p
x(12)=4.900225631339895_p
w(12)=2.048939768927555e-2_p
x(13)=7.804354590856207_p
w(13)=1.229424914587177e-3_p
x(14)=10.88199552385304_p
w(14)=5.845841526141038e-5_p
x(15)=13.94542890422479_p
w(15)=2.601819517540904e-6_p
x(16)=16.66569861941311_p
w(16)=1.381227817166444e-7_p
x(17)=18.51733965760902_p
w(17)=1.099996397837238e-8_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;19kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60757011160354_p
w(1)=8.010479748250502_p
x(2)=-2.557094653510492_p
w(2)=6.989520552048976_p
else if(N==3)then
x(1)=-13.08170876183341_p
w(1)=4.723442861632945_p
x(2)=-6.541755060580799_p
w(2)=7.396057054730933_p
x(3)=-2.364774565799119e-1_p
w(3)=2.880500383935600_p
else if(N==4)then
x(1)=-13.74327555214668_p
w(1)=3.145817956461167_p
x(2)=-9.049755181196296_p
w(2)=5.837692927546938_p
x(3)=-3.109098546347981_p
w(3)=5.206292466060828_p
x(4)=1.722223501197670_p
w(4)=8.101969502305451e-1_p
else if(N==5)then
x(1)=-14.09714874466552_p
w(1)=2.278551509081225_p
x(2)=-10.57239344011085_p
w(2)=4.568967003449998_p
x(3)=-5.496799498385655_p
w(3)=5.228166563764793_p
x(4)=-7.683911891993095e-1_p
w(4)=2.807425197447879_p
x(5)=3.989301111382562_p
w(5)=1.168900265555825e-1_p
else if(N==6)then
x(1)=-14.3104420064966_p
w(1)=1.748391806077938_p
x(2)=-11.55001562022023_p
w(2)=3.658962729462983_p
x(3)=-7.300526545173084_p
w(3)=4.645167284020639_p
x(4)=-2.719624675566397_p
w(4)=3.988751730992073_p
x(5)=1.182030883857900_p
w(5)=9.489734862099762e-1_p
x(6)=6.625886006817609_p
w(6)=9.753263535868301e-3_p
else if(N==7)then
x(1)=-14.45099457839556_p
w(1)=1.396099261150437_p
x(2)=-12.21849702545209_p
w(2)=2.999739764514112_p
x(3)=-8.642034788044395_p
w(3)=4.032988268329389_p
x(4)=-4.441551971314312_p
w(4)=4.141863949001666_p
x(5)=-5.969611849647630e-1_p
w(5)=2.256705363338485_p
x(6)=3.273482121375732_p
w(6)=1.719631175753993e-1_p
x(7)=9.428263764727214_p
w(7)=6.405763899887064e-4_p
else if(N==8)then
x(1)=-14.55054969510535_p
w(1)=1.145192764993515_p
x(2)=-12.70351871536774_p
w(2)=2.504272207702686_p
x(3)=-9.666325160540570_p
w(3)=3.491401002644099_p
x(4)=-5.910025259970377_p
w(4)=3.896701311386830_p
x(5)=-2.125722419448691_p
w(5)=3.148492207928558_p
x(6)=1.233902019366057_p
w(6)=7.935837495842030e-1_p
x(7)=5.556911851145885_p
w(7)=2.031169142190816e-2_p
x(8)=12.08648411182946_p
w(8)=4.536463767941246e-5_p
else if(N==9)then
x(1)=-14.62493149368072_p
w(1)=9.570100731830939e-1_p
x(2)=-13.07200908949185_p
w(2)=2.118874766659632_p
x(3)=-10.4715198458625_p
w(3)=3.028489174265113_p
x(4)=-7.144054690465146_p
w(4)=3.547097047564696_p
x(5)=-3.557149529643025_p
w(5)=3.414345289468949_p
x(6)=-2.879853582925037e-1_p
w(6)=1.761625289567240_p
x(7)=3.098712472836795_p
w(7)=1.703220178190144e-1_p
x(8)=7.813230117706015_p
w(8)=2.231909029614937e-3_p
x(9)=14.25621282256853_p
w(9)=4.732742125530398e-6_p
else if(N==10)then
x(1)=-14.68236437126837_p
w(1)=8.113049781413602e-1_p
x(2)=-13.35997693807841_p
w(2)=1.812685788038743_p
x(3)=-11.11601244856094_p
w(3)=2.637589842288242_p
x(4)=-8.175531423785571_p
w(4)=3.189017318476173_p
x(5)=-4.862887026457561_p
w(5)=3.333292268523897_p
x(6)=-1.632621750981538_p
w(6)=2.537035841980437_p
x(7)=1.341982903327675_p
w(7)=6.506171238546581e-1_p
x(8)=5.010220554816000_p
w(8)=2.817223142142377e-2_p
x(9)=9.862851037759967_p
w(9)=2.840667955412353e-4_p
x(10)=15.79187850684779_p
w(10)=8.407790016160598e-7_p
else if(N==11)then
x(1)=-14.7276482641779_p
w(1)=6.961860032880863e-1_p
x(2)=-13.58905551940357_p
w(2)=1.566185194644051_p
x(3)=-11.63769483736255_p
w(3)=2.309390790761117_p
x(4)=-9.035787458081284_p
w(4)=2.855600116556423_p
x(5)=-6.015607370267310_p
w(5)=3.124052104164282_p
x(6)=-2.900631773860101_p
w(6)=2.866503629336255_p
x(7)=-4.048683007706631e-2_p
w(7)=1.411757413977114_p
x(8)=2.973112146382447_p
w(8)=1.656990674652931e-1_p
x(9)=6.853776031982849_p
w(9)=4.579477540637239e-3_p
x(10)=11.61859673280037_p
w(10)=4.626227561227598e-5_p
x(11)=16.79134588855925_p
w(11)=2.402906059249159e-7_p
else if(N==12)then
x(1)=-14.76394707721096_p
w(1)=6.037651105255836e-1_p
x(2)=-13.7739203169294_p
w(2)=1.365479355910020_p
x(3)=-12.06419254018976_p
w(3)=2.033951070573466_p
x(4)=-9.754420078815981_p
w(4)=2.557044378215891_p
x(5)=-7.015495274785429_p
w(5)=2.880169038930060_p
x(6)=-4.079187188701116_p
w(6)=2.886524280393083_p
x(7)=-1.257818116494953_p
w(7)=2.085749520486980_p
x(8)=1.417877712670844_p
w(8)=5.512204905130501e-1_p
x(9)=4.610345947069514_p
w(9)=3.525844093968358e-2_p
x(10)=8.546851776634783_p
w(10)=8.285778852822664e-4_p
x(11)=13.05972629853133_p
w(11)=9.938959529717584e-6_p
x(12)=17.42792517458926_p
w(12)=9.696684752095143e-8_p
else if(N==13)then
x(1)=-14.79346945759833_p
w(1)=5.285071449220548e-1_p
x(2)=-13.92505894628745_p
w(2)=1.200265299088666_p
x(3)=-12.41636956629538_p
w(3)=1.802038406684985_p
x(4)=-10.35746990479612_p
w(4)=2.294282440962366_p
x(5)=-7.876938540267327_p
w(5)=2.637569723347799_p
x(6)=-5.145704464840460_p
w(6)=2.769134791093313_p
x(7)=-2.398590101211065_p
w(7)=2.438811119575004_p
x(8)=1.548510095248831e-1_p
w(8)=1.160617128299621_p
x(9)=2.867933171008804_p
w(9)=1.611603425646936e-1_p
x(10)=6.185164337188186_p
w(10)=7.434916104944727e-3_p
x(11)=10.04915596112621_p
w(11)=1.761526900550373e-4_p
x(12)=14.20792822610201_p
w(12)=2.785649076197936e-6_p
x(13)=17.84000753794901_p
w(13)=4.931689755369399e-8_p
else if(N==14)then
x(1)=-14.81779408717416_p
w(1)=4.664400866479053e-1_p
x(2)=-14.05010109640436_p
w(2)=1.062845634121713_p
x(3)=-12.71001704454953_p
w(3)=1.605768717225880_p
x(4)=-10.86656350733313_p
w(4)=2.064669398273777_p
x(5)=-8.618332614319879_p
w(5)=2.409900701386696_p
x(6)=-6.094802972582489_p
w(6)=2.602649741184210_p
x(7)=-3.468778621874312_p
w(7)=2.524841394471182_p
x(8)=-9.590824532218895e-1_p
w(8)=1.742358658396314_p
x(9)=1.475958641302652_p
w(9)=4.775292389868530e-1_p
x(10)=4.306854399273401_p
w(10)=4.125522563904051e-2_p
x(11)=7.646881422724826_p
w(11)=1.695651925420472e-3_p
x(12)=11.34925216726653_p
w(12)=4.483780264350959e-5_p
x(13)=15.10695845822221_p
w(13)=9.849893982822330e-7_p
x(14)=18.11537013491281_p
w(14)=2.924844555623832e-8_p
else if(N==15)then
x(1)=-14.83806917534611_p
w(1)=4.146662602469252e-1_p
x(2)=-14.15467096031468_p
w(2)=9.474342069266798e-1_p
x(3)=-12.95711782932031_p
w(3)=1.438675192509582_p
x(4)=-11.29914861761587_p
w(4)=1.864426899171253_p
x(5)=-9.257610677885566_p
w(5)=2.201788986164728_p
x(6)=-6.932721560557387_p
w(6)=2.424124404911173_p
x(7)=-4.454342856534646_p
w(7)=2.472034979436654_p
x(8)=-1.998333609110368_p
w(8)=2.096363161439878_p
x(9)=3.155151393532987e-1_p
w(9)=9.733383460249764e-1_p
x(10)=2.782375828839830_p
w(10)=1.561994897749133e-1_p
x(11)=5.689805036350782_p
w(11)=1.049984104589882e-2_p
x(12)=8.970448276286920_p
w(12)=4.344498450832508e-4_p
x(13)=12.45455234803688_p
w(13)=1.364175005257307e-5_p
x(14)=15.80617175902905_p
w(14)=4.217994269186502e-7_p
x(15)=18.30592182334558_p
w(15)=1.925225322371559e-8_p
else if(N==16)then
x(1)=-14.85514407665745_p
w(1)=3.710371027066557e-1_p
x(2)=-14.2429727121609_p
w(2)=8.496408754045710e-1_p
x(3)=-13.1668288044682_p
w(3)=1.295541111053132_p
x(4)=-11.66914822718484_p
w(4)=1.689670230595115_p
x(5)=-9.810697273916379_p
w(5)=2.013986385864587_p
x(6)=-7.670411346071723_p
w(6)=2.248919312739203_p
x(7)=-5.348446562665768_p
w(7)=2.360885092585600_p
x(8)=-2.978120925977277_p
w(8)=2.225737814295844_p
x(9)=-7.129931356323852e-1_p
w(9)=1.474987412413356_p
x(10)=1.523033057195205_p
w(10)=4.204914558623385e-1_p
x(11)=4.069134959689226_p
w(11)=4.613462815713121e-2_p
x(12)=6.983350246968352_p
w(12)=2.836971906344799e-3_p
x(13)=10.14820144653497_p
w(13)=1.267879045898985e-4_p
x(14)=13.38342050310612_p
w(14)=4.894780344308597e-6_p
x(15)=16.35063515837433_p
w(15)=2.103980971446600e-7_p
x(16)=18.44221048100649_p
w(16)=1.363256732564337e-8_p
else if(N==17)then
x(1)=-14.86965729613357_p
w(1)=3.339343470901837e-1_p
x(2)=-14.3181934314639_p
w(2)=7.660985416405219e-1_p
x(3)=-13.34621211687718_p
w(3)=1.172180085392269_p
x(4)=-11.98765079395462_p
w(4)=1.536813865388973_p
x(5)=-10.29117769779528_p
w(5)=1.845562249478114_p
x(6)=-8.319878100091618_p
w(6)=2.083402831810030_p
x(7)=-6.152712747580469_p
w(7)=2.229018666109704_p
x(8)=-3.891430429644987_p
w(8)=2.220442552637070_p
x(9)=-1.669867893366535_p
w(9)=1.817164002818513_p
x(10)=4.505897756449273e-1_p
w(10)=8.299320428495713e-1_p
x(11)=2.712072060130368_p
w(11)=1.510029448836137e-1_p
x(12)=5.305902396683133_p
w(12)=1.356621876369341e-2_p
x(13)=8.170603829021802_p
w(13)=8.376114636979328e-4_p
x(14)=11.18338153366435_p
w(14)=4.217930942394495e-5_p
x(15)=14.15902688824266_p
w(15)=2.032202127940133e-6_p
x(16)=16.77729324561843_p
w(16)=1.182840116601514e-7_p
x(17)=18.5425999983523_p
w(17)=1.017795845353467e-8_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;19kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652742549931_p
w(1)=7.538498666698110_p
x(2)=-2.304431007286181_p
w(2)=6.461502159227468_p
else if(N==3)then
x(1)=-12.18399981062787_p
w(1)=4.470872247731750_p
x(2)=-6.001291524534851_p
w(2)=6.968248622921372_p
x(3)=-2.478854844720644e-2_p
w(3)=2.560879955272454_p
else if(N==4)then
x(1)=-12.80450574984805_p
w(1)=2.992186285479923_p
x(2)=-8.343422540545674_p
w(2)=5.541856390619412_p
x(3)=-2.724925893223477_p
w(3)=4.809700245556097_p
x(4)=1.984759702177560_p
w(4)=6.562579042701454e-1_p
else if(N==5)then
x(1)=-13.1376581108773_p
w(1)=2.176095209133521_p
x(2)=-9.773205204741144_p
w(2)=4.357969414061926_p
x(3)=-4.943367909058023_p
w(3)=4.940213879818985_p
x(4)=-4.585169520724060e-1_p
w(4)=2.441397826933908_p
x(5)=4.337562405049559_p
w(5)=8.432449597723732e-2_p
else if(N==6)then
x(1)=-13.33925076361198_p
w(1)=1.675200520207144_p
x(2)=-10.69552200264913_p
w(2)=3.502403695583021_p
x(3)=-6.633795399039744_p
w(3)=4.427206502977526_p
x(4)=-2.287429582265062_p
w(4)=3.648379722187226_p
x(5)=1.512494518841647_p
w(5)=7.403120111534242e-1_p
x(6)=7.040694274206376_p
w(6)=6.498373817235526e-3_p
else if(N==7)then
x(1)=-13.47272146566745_p
w(1)=1.340750550513931_p
x(2)=-11.32947921843778_p
w(2)=2.878627538185830_p
x(3)=-7.900865347484164_p
w(3)=3.860179266087487_p
x(4)=-3.894138328359791_p
w(4)=3.896729343844835_p
x(5)=-2.348109356502825e-1_p
w(5)=1.903886809018397_p
x(6)=3.667671961968752_p
w(6)=1.194150487714756e-1_p
x(7)=9.869718094235726_p
w(7)=4.122695036218182e-4_p
else if(N==8)then
x(1)=-13.56773654099702_p
w(1)=1.101335047981253_p
x(2)=-11.79193528224408_p
w(2)=2.406932925509089_p
x(3)=-8.874912012319996_p
w(3)=3.349891735911395_p
x(4)=-5.278600261341842_p
w(4)=3.709570227795894_p
x(5)=-1.684993518701661_p
w(5)=2.822626149957119_p
x(6)=1.605365180668866_p
w(6)=5.962928184628111e-1_p
x(7)=5.985695835201829_p
w(7)=1.332214216203570e-2_p
x(8)=12.49482645373667_p
w(8)=2.977814598041329e-5_p
else if(N==9)then
x(1)=-13.63897054925073_p
w(1)=9.211440967149455e-1_p
x(2)=-12.14457597171132_p
w(2)=2.038515668135386_p
x(3)=-9.644053277240710_p
w(3)=2.910057915088933_p
x(4)=-6.451147828348202_p
w(4)=3.394205335788240_p
x(5)=-3.030943627439302_p
w(5)=3.177714747987907_p
x(6)=9.569344649883653e-2_p
w(6)=1.440516911285874_p
x(7)=3.506828761716786_p
w(7)=1.163871280611550e-1_p
x(8)=8.235991216896112_p
w(8)=1.455703950066850e-3_p
x(9)=14.57941505155459_p
w(9)=3.318913069898246e-6_p
else if(N==10)then
x(1)=-13.6940609677894_p
w(1)=7.813989491875196e-1_p
x(2)=-12.42064243039061_p
w(2)=1.745223476922680_p
x(3)=-10.26107139515098_p
w(3)=2.537121833428583_p
x(4)=-7.435279875429342_p
w(4)=3.059783066162238_p
x(5)=-4.264811334087963_p
w(5)=3.157835984410908_p
x(6)=-1.194296436759520_p
w(6)=2.223068168439710_p
x(7)=1.732460494930123_p
w(7)=4.768465847758305e-1_p
x(8)=5.432580449985370_p
w(8)=1.853241489913626e-2_p
x(9)=10.25247350756843_p
w(9)=1.897104326610722e-4_p
x(10)=16.02098393227272_p
w(10)=6.372663093664684e-7_p
else if(N==11)then
x(1)=-13.73753458678918_p
w(1)=6.708930279160447e-1_p
x(2)=-12.64046363910981_p
w(2)=1.508836617764255_p
x(3)=-10.76115254377286_p
w(3)=2.223281871941899_p
x(4)=-8.257972582966309_p
w(4)=2.744466461742574_p
x(5)=-5.360145265803088_p
w(5)=2.983260988549316_p
x(6)=-2.391625995829041_p
w(6)=2.630512128980870_p
x(7)=3.577080662215280e-1_p
w(7)=1.123416449154684_p
x(8)=3.387073152186238_p
w(8)=1.122914876568611e-1_p
x(9)=7.266241387283869_p
w(9)=3.009475261994350e-3_p
x(10)=11.96066757566566_p
w(10)=3.212272122337846e-5_p
x(11)=16.94700796749509_p
w(11)=1.942358559791654e-7_p
else if(N==12)then
x(1)=-13.77240621127818_p
w(1)=5.821132084365459e-1_p
x(2)=-12.81799451177214_p
w(2)=1.316192014446724_p
x(3)=-11.17039693875701_p
w(3)=1.959462942624705_p
x(4)=-8.946354086474038_p
w(4)=2.460410991187234_p
x(5)=-6.313931049870785_p
w(5)=2.761189124426174_p
x(6)=-3.505354379712286_p
w(6)=2.714717563481729_p
x(7)=-8.182892052183881e-1_p
w(7)=1.785839363827026_p
x(8)=1.822440611207504_p
w(8)=3.963291027768958e-1_p
x(9)=5.031336033678315_p
w(9)=2.318478352261963e-2_p
x(10)=8.934001147700789_p
w(10)=5.544320982048852e-4_p
x(11)=13.3496721882337_p
w(11)=7.217012921455955e-6_p
x(12)=17.53420018919502_p
w(12)=8.208479781675024e-8_p
else if(N==13)then
x(1)=-13.80078591157293_p
w(1)=5.097730772738563e-1_p
x(2)=-12.96323915638066_p
w(2)=1.157486841844353_p
x(3)=-11.50861948234434_p
w(3)=1.737048542788208_p
x(4)=-9.524760276359537_p
w(4)=2.209527487739445_p
x(5)=-7.137807590900750_p
w(5)=2.534239992542274_p
x(6)=-4.518109410340762_p
w(6)=2.635060942369556_p
x(7)=-1.900348029873845_p
w(7)=2.201945551923330_p
x(8)=5.658740017128708e-1_p
w(8)=9.014991263079517e-1_p
x(9)=3.287820808440481_p
w(9)=1.084079488447742e-1_p
x(10)=6.595939385729719_p
w(10)=4.887932692733779e-3_p
x(11)=10.40235586525197_p
w(11)=1.212249609058909e-4_p
x(12)=14.44819893646593_p
w(12)=2.113544852028326e-6_p
x(13)=17.91450547756013_p
w(13)=4.309333868155959e-8_p
else if(N==14)then
x(1)=-13.8241826940149_p
w(1)=4.500769428634678e-1_p
x(2)=-13.08348126657673_p
w(2)=1.025387534250152_p
x(3)=-11.79084472173075_p
w(3)=1.548619587422946_p
x(4)=-10.01355866724897_p
w(4)=1.989781690454239_p
x(5)=-7.848185730244854_p
w(5)=2.318791099174990_p
x(6)=-5.423077993758896_p
w(6)=2.490949189564971_p
x(7)=-2.912718107127863_p
w(7)=2.351939336460687_p
x(8)=-5.161683770680355e-1_p
w(8)=1.458199143562475_p
x(9)=1.891815793578988_p
w(9)=3.380262654997530e-1_p
x(10)=4.729253872529461_p
w(10)=2.706582936027532e-2_p
x(11)=8.036435609961034_p
w(11)=1.131524709042621e-3_p
x(12)=11.66490780070109_p
w(12)=3.187919240086706e-5_p
x(13)=15.30383565954369_p
w(13)=7.772873892795296e-7_p
x(14)=18.16931400852222_p
w(14)=2.612278867402797e-8_p
else if(N==15)then
x(1)=-13.8436946596872_p
w(1)=4.002542180493711e-1_p
x(2)=-13.18409388776057_p
w(2)=9.143752559998953e-1_p
x(3)=-12.02849017025163_p
w(3)=1.388061417051870_p
x(4)=-10.42925677949646_p
w(4)=1.797822844007079_p
x(5)=-8.461566744227785_p
w(5)=2.120671636330000_p
x(6)=-6.224356551865973_p
w(6)=2.327294980227421_p
x(7)=-3.848322058454070_p
w(7)=2.340283598535893_p
x(8)=-1.506785429386958_p
w(8)=1.859541647372674_p
x(9)=7.374337914914545e-1_p
w(9)=7.401060317687133e-1_p
x(10)=3.207708571953855_p
w(10)=1.043925842886905e-1_p
x(11)=6.101799047724864_p
w(11)=6.889669923133224e-3_p
x(12)=9.332637246654867_p
w(12)=2.965515782924631e-4_p
x(13)=12.73268717516692_p
w(13)=1.002920829331249e-5_p
x(14)=15.96709796500604_p
w(14)=3.441218749789147e-7_p
x(15)=18.34623494823096_p
w(15)=1.746237443535132e-8_p
else if(N==16)then
x(1)=-13.86013464206417_p
w(1)=3.582491230992799e-1_p
x(2)=-13.26909684166379_p
w(2)=8.202579032220539e-1_p
x(3)=-12.23029261292344_p
w(3)=1.250424549552126_p
x(4)=-10.78507060511222_p
w(4)=1.630082438191969_p
x(5)=-8.992818670089834_p
w(5)=1.941250420337818_p
x(6)=-6.931227772716946_p
w(6)=2.163105646500640_p
x(7)=-4.700475903194758_p
w(7)=2.253467125039598_p
x(8)=-2.435397057099580_p
w(8)=2.049449045981321_p
x(9)=-2.658345293396009e-1_p
w(9)=1.207710701597504_p
x(10)=1.947974645723445_p
w(10)=2.938438825466574e-1_p
x(11)=4.493918736920533_p
w(11)=3.018159477481173e-2_p
x(12)=7.376634750287342_p
w(12)=1.885638478332233e-3_p
x(13)=10.48023177410187_p
w(13)=8.885216633889297e-5_p
x(14)=13.62635847373564_p
w(14)=3.715520187528272e-6_p
x(15)=16.482633504624_p
w(15)=1.764124508614186e-7_p
x(16)=18.47320232909135_p
w(16)=1.250448819169490e-8_p
else if(N==17)then
x(1)=-13.87411412166658_p
w(1)=3.225121392575724e-1_p
x(2)=-13.3415400242951_p
w(2)=7.398168135817320e-1_p
x(3)=-12.40299852717936_p
w(3)=1.131726827514120_p
x(4)=-11.09155169748954_p
w(4)=1.483215727682007_p
x(5)=-9.454730240319854_p
w(5)=1.779966056317846_p
x(6)=-7.554487252715205_p
w(6)=2.006364059177895_p
x(7)=-5.469354454255584_p
w(7)=2.136923589065745_p
x(8)=-3.302526232345048_p
w(8)=2.087839054568876_p
x(9)=-1.182284090547550_p
w(9)=1.582378487612232_p
x(10)=8.816569203102927e-1_p
w(10)=6.194262450634551e-1_p
x(11)=3.142259879933244_p
w(11)=1.003544198356864e-1_p
x(12)=5.720216613450909_p
w(12)=8.877758510719494e-3_p
x(13)=8.540500704391839_p
w(13)=5.675662741809074e-4_p
x(14)=11.48476435271025_p
w(14)=3.038230896342818e-5_p
x(15)=14.37028957001686_p
w(15)=1.588339565621810e-6_p
x(16)=16.88632191873353_p
w(16)=1.014008084995573e-7_p
x(17)=18.56701982973224_p
w(17)=9.414171448455192e-9_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;19kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429038570594_p
w(1)=7.068991480076371_p
x(2)=-2.046001035926373_p
w(2)=5.931010774647685_p
else if(N==3)then
x(1)=-11.28555031247186_p
w(1)=4.220011245248818_p
x(2)=-5.458798365241868_p
w(2)=6.536160897259668_p
x(3)=2.003877014301106e-1_p
w(3)=2.243830112215569_p
else if(N==4)then
x(1)=-11.86530554547457_p
w(1)=2.839577131831864_p
x(2)=-7.635613817673846_p
w(2)=5.245770025798510_p
x(3)=-2.338833629251278_p
w(3)=4.396870842168755_p
x(4)=2.270397507506272_p
w(4)=5.177842549249266e-1_p
else if(N==5)then
x(1)=-12.17792626929402_p
w(1)=2.074216737890340_p
x(2)=-8.973123123309886_p
w(2)=4.147222323230837_p
x(3)=-4.390169210759010_p
w(3)=4.641036734098409_p
x(4)=-1.374654987852157e-1_p
w(4)=2.078361436278051_p
x(5)=4.711177131400753_p
w(5)=5.916502322641781e-2_p
else if(N==6)then
x(1)=-12.36794548006532_p
w(1)=1.602279638319536_p
x(2)=-9.840622952921260_p
w(2)=3.345938013061583_p
x(3)=-5.967388156476821_p
w(3)=4.204715073270163_p
x(4)=-1.856014750576618_p
w(4)=3.284196561331101_p
x(5)=1.866973264157307_p
w(5)=5.586415430765270e-1_p
x(6)=7.477219193540831_p
w(6)=4.231425665145602e-3_p
else if(N==7)then
x(1)=-12.49442568490051_p
w(1)=1.285447810566006_p
x(2)=-10.44044437943584_p
w(2)=2.757346815602685_p
x(3)=-7.160327188343379_p
w(3)=3.685128525438858_p
x(4)=-3.350352724645821_p
w(4)=3.631524683031078_p
x(5)=1.382780203649265e-1_p
w(5)=1.559775727591289_p
x(6)=4.086005603979172_p
w(6)=8.051738438193429e-2_p
x(7)=10.32467100283846_p
w(7)=2.613081122056130e-4_p
else if(N==8)then
x(1)=-12.5849466900755_p
w(1)=1.057410492804501_p
x(2)=-10.88053033962969_p
w(2)=2.309289250494567_p
x(3)=-8.084292928586324_p
w(3)=3.206977460263716_p
x(4)=-4.650331925074958_p
w(4)=3.512267659580771_p
x(5)=-1.245752364632742_p
w(5)=2.473394418318402_p
x(6)=1.999352139919606_p
w(6)=4.320712822287445e-1_p
x(7)=6.430947701711498_p
w(7)=8.572232030491995e-3_p
x(8)=12.90416934426279_p
w(8)=1.945900286261103e-5_p
else if(N==9)then
x(1)=-12.65304102806446_p
w(1)=8.851929167344793e-1_p
x(2)=-11.21734238629034_p
w(2)=1.957868590192960_p
x(3)=-8.817284359662821_p
w(3)=2.790684013863375_p
x(4)=-5.760516112302267_p
w(4)=3.236341969041824_p
x(5)=-2.509937995142903_p
w(5)=2.914481092585579_p
x(6)=4.916627982103013e-1_p
w(6)=1.137106945624442_p
x(7)=3.935402353776846_p
w(7)=7.738568926060040e-2_p
x(8)=8.667854765003186_p
w(8)=9.387022509696905e-4_p
x(9)=14.89483224447155_p
w(9)=2.335169826869600e-6_p
else if(N==10)then
x(1)=-12.70578452505956_p
w(1)=7.514204932623144e-1_p
x(2)=-11.48147275507449_p
w(2)=1.677533371926577_p
x(3)=-9.406667792652403_p
w(3)=2.436007717526385_p
x(4)=-6.696610354776923_p
w(4)=2.927912237912665_p
x(5)=-3.671175876566590_p
w(5)=2.966444537831771_p
x(6)=-7.553021120642841e-1_p
w(6)=1.891760166042789_p
x(7)=2.144102921267248_p
w(7)=3.368158717522109e-1_p
x(8)=5.869008158387489_p
w(8)=1.198140847510881e-2_p
x(9)=10.645471173003_p
w(9)=1.259643742509917e-4_p
x(10)=16.24078541234525_p
w(10)=4.856199839240613e-7_p
else if(N==11)then
x(1)=-12.74744296342974_p
w(1)=6.455410587951239e-1_p
x(2)=-11.69200391981922_p
w(2)=1.451309772363863_p
x(3)=-9.885024052553000_p
w(3)=2.136710880512213_p
x(4)=-7.481291091515837_p
w(4)=2.631786329550906_p
x(5)=-4.707831776992173_p
w(5)=2.834233110994840_p
x(6)=-1.887283745093750_p
w(6)=2.365057227776103_p
x(7)=7.697487868855601e-1_p
w(7)=8.592633378207685e-1_p
x(8)=3.819567164114244_p
w(8)=7.412210886555086e-2_p
x(9)=7.687424204181839_p
w(9)=1.956007552287361e-3_p
x(10)=12.30209992655005_p
w(10)=2.226278833472679e-5_p
x(11)=17.09531335105548_p
w(11)=1.577040657628366e-7_p
else if(N==12)then
x(1)=-12.78088378349489_p
w(1)=5.604121692689130e-1_p
x(2)=-11.86217730867073_p
w(2)=1.266761196460999_p
x(3)=-10.27693008308865_p
w(3)=1.884628679345776_p
x(4)=-8.139136876832699_p
w(4)=2.362785045450800_p
x(5)=-5.614579476293765_p
w(5)=2.637858101009059_p
x(6)=-2.936506590814331_p
w(6)=2.521451715903053_p
x(7)=-3.756370793629665e-1_p
w(7)=1.476143643808948_p
x(8)=2.246978045231656_p
w(8)=2.745957977014628e-1_p
x(9)=5.465343543262495_p
w(9)=1.499209647024207e-2_p
x(10)=9.325769323661158_p
w(10)=3.684966015284125e-4_p
x(11)=13.63666035953152_p
w(11)=5.243014585331988e-6_p
x(12)=17.63538335463762_p
w(12)=6.968868851598967e-8_p
else if(N==13)then
x(1)=-12.80811807480911_p
w(1)=4.909972834390151e-1_p
x(2)=-12.00151052027172_p
w(2)=1.114590113832059_p
x(3)=-10.60113754520303_p
w(3)=1.671789686432207_p
x(4)=-8.692710260706654_p
w(4)=2.124088444211709_p
x(5)=-6.400281985298934_p
w(5)=2.428437530676565_p
x(6)=-3.894412105730206_p
w(6)=2.488712029572672_p
x(7)=-1.405592465704933_p
w(7)=1.936003542855982_p
x(8)=9.915805224709620e-1_p
w(8)=6.710400141179310e-1_p
x(9)=3.724759005901918_p
w(9)=7.108037718041882e-2_p
x(10)=7.015218229917863_p
w(10)=3.178471180264878e-3_p
x(11)=10.7571674963095_p
w(11)=8.311736945140720e-5_p
x(12)=14.68457108924906_p
w(12)=1.606138102767884e-6_p
x(13)=17.98559255662809_p
w(13)=3.771767881222953e-8_p
else if(N==14)then
x(1)=-12.83058483401011_p
w(1)=4.336779515625963e-1_p
x(2)=-12.11693899034753_p
w(2)=9.878303191867139e-1_p
x(3)=-10.87189521264624_p
w(3)=1.491255622495647_p
x(4)=-9.161080903330518_p
w(4)=1.914396320709342_p
x(5)=-7.079246636886417_p
w(5)=2.226159443898447_p
x(6)=-4.754211655217345_p
w(6)=2.372512939536339_p
x(7)=-2.361725034654143_p
w(7)=2.153189728018665_p
x(8)=-6.800691631631187e-2_p
w(8)=1.172106794038737_p
x(9)=2.326425563101449_p
w(9)=2.306323553773160e-1_p
x(10)=5.163859396744056_p
w(10)=1.746784819698187e-2_p
x(11)=8.431125909275368_p
w(11)=7.496644953083913e-4_p
x(12)=11.98014190575529_p
w(12)=2.262933390223311e-5_p
x(13)=15.49674802985901_p
w(13)=6.145244304666702e-7_p
x(14)=18.22095595288683_p
w(14)=2.334963063444533e-8_p
else if(N==15)then
x(1)=-12.84933188917664_p
w(1)=3.858111334432816e-1_p
x(2)=-12.21358343446773_p
w(2)=8.812322222902609e-1_p
x(3)=-11.10005023543909_p
w(3)=1.337272425433940_p
x(4)=-9.559795190845318_p
w(4)=1.730841612286054_p
x(5)=-7.666460874812524_p
w(5)=2.038548335957637_p
x(6)=-5.518099748570098_p
w(6)=2.226641053386427_p
x(7)=-3.246748238159959_p
w(7)=2.191914402224031_p
x(8)=-1.017197457901039_p
w(8)=1.596720068354933_p
x(9)=1.174354978778268_p
w(9)=5.382948941657869e-1_p
x(10)=3.648846836361179_p
w(10)=6.804519495767267e-2_p
x(11)=6.522080818182011_p
w(11)=4.471744629257344e-3_p
x(12)=9.697484248248815_p
w(12)=2.014994381928457e-4_p
x(13)=13.00917212726959_p
w(13)=7.371086738253204e-6_p
x(14)=16.124422960316_p
w(14)=2.812275826907009e-7_p
x(15)=18.38495950806733_p
w(15)=1.584226095713221e-8_p
else if(N==16)then
x(1)=-12.86513546171996_p
w(1)=3.454340897421825e-1_p
x(2)=-12.29527864176662_p
w(2)=7.908028934878267e-1_p
x(3)=-11.29391634985634_p
w(3)=1.205162671675953_p
x(4)=-9.901350196111151_p
w(4)=1.570199611747844_p
x(5)=-8.175687976744314_p
w(5)=1.867809426373357_p
x(6)=-6.193637694445823_p
w(6)=2.074989110606783_p
x(7)=-4.055949660963876_p
w(7)=2.136355588840737_p
x(8)=-1.897366078657849_p
w(8)=1.844719048831894_p
x(9)=1.882988719546829e-1_p
w(9)=9.457761674100176e-1_p
x(10)=2.390503966038005_p
w(10)=1.980162834135152e-1_p
x(11)=4.930239125208004_p
w(11)=1.942827967975023e-2_p
x(12)=7.775306901348663_p
w(12)=1.244004258433578e-3_p
x(13)=10.81315058274636_p
w(13)=6.209750425136390e-5_p
x(14)=13.86701662245827_p
w(14)=2.821564723389862e-6_p
x(15)=16.6115402064822_p
w(15)=1.481190175167505e-7_p
x(16)=18.50306859347891_p
w(16)=1.146776976638474e-8_p
else if(N==17)then
x(1)=-12.87857994715682_p
w(1)=3.110662208160866e-1_p
x(2)=-12.3649368757749_p
w(2)=7.134728473444307e-1_p
x(3)=-11.4599224661794_p
w(3)=1.091151377293423_p
x(4)=-10.19575331936582_p
w(4)=1.429380994857094_p
x(5)=-8.618891940161909_p
w(5)=1.713851988291646_p
x(6)=-6.790333994252050_p
w(6)=1.927849921014911_p
x(7)=-4.788601237253201_p
w(7)=2.039193711267413_p
x(8)=-2.718346911002481_p
w(8)=1.934539009964569_p
x(9)=-6.950044116250950e-1_p
w(9)=1.326497969391859_p
x(10)=1.327704813725860_p
w(10)=4.417676137190756e-1_p
x(11)=3.587191161451714_p
w(11)=6.507814953225102e-2_p
x(12)=6.142610001046978_p
w(12)=5.746633680341921e-3_p
x(13)=8.913642959057686_p
w(13)=3.826265002424167e-4_p
x(14)=11.785831327962_p
w(14)=2.185297085786483e-5_p
x(15)=14.57904364550737_p
w(15)=1.242361867905439e-6_p
x(16)=16.99276974510085_p
w(16)=8.701404990605331e-8_p
x(17)=18.59062104393752_p
w(17)=8.703937073335078e-9_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;19kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741450760383_p
w(1)=6.602046151094187_p
x(2)=-1.780566410234671_p
w(2)=5.397959987496495_p
else if(N==3)then
x(1)=-10.38632578553631_p
w(1)=3.970889514253765_p
x(2)=-4.914393220416941_p
w(2)=6.097466080258507_p
x(3)=4.416700540567974e-1_p
w(3)=1.931650544078408_p
else if(N==4)then
x(1)=-10.92567543306899_p
w(1)=2.687965056225047_p
x(2)=-6.926499842875626_p
w(2)=4.948441529369929_p
x(3)=-1.950045225681799_p
w(3)=3.967029767988715_p
x(4)=2.582029276031540_p
w(4)=3.965697850069890e-1_p
else if(N==5)then
x(1)=-11.21796785221923_p
w(1)=1.972866014431411_p
x(2)=-8.172304153918180_p
w(2)=3.936243933579672_p
x(3)=-3.837836137484238_p
w(3)=4.326210256275895_p
x(4)=1.982070011752457e-1_p
w(4)=1.724368307233326_p
x(5)=5.111621389720193_p
w(5)=4.031762707037789e-2_p
else if(N==6)then
x(1)=-11.39654803762051_p
w(1)=1.529565647930968_p
x(2)=-8.985474290987504_p
w(2)=3.189249840045183_p
x(3)=-5.301975575925398_p
w(3)=3.975091506919060_p
x(4)=-1.424113138186330_p
w(4)=2.897030660161330_p
x(5)=2.248462315042904_p
w(5)=4.063770515580094e-1_p
x(6)=7.935897897393642_p
w(6)=2.691431976130429e-3_p
else if(N==7)then
x(1)=-11.51612974841538_p
w(1)=1.230128532922584_p
x(2)=-9.551533123168001_p
w(2)=2.635665484430368_p
x(3)=-6.420938013502813_p
w(3)=3.506504328581485_p
x(4)=-2.810888301034490_p
w(4)=3.340446478583232_p
x(5)=5.265673447541891e-1_p
w(5)=1.234382335427278_p
x(6)=4.528852733352589_p
w(6)=5.271574191355590e-2_p
x(7)=10.79201283267654_p
w(7)=1.632367321777114e-4_p
else if(N==8)then
x(1)=-11.60219650340185_p
w(1)=1.013373732913044_p
x(2)=-9.969403722146346_p
w(2)=2.211184989770141_p
x(3)=-7.294814771688196_p
w(3)=3.061947107717444_p
x(4)=-4.026147538763831_p
w(4)=3.300151346749719_p
x(5)=-8.053704523672218e-1_p
w(5)=2.106558601483455_p
x(6)=2.418075405531928_p
w(6)=3.013633536069950e-1_p
x(7)=6.892139687045701_p
w(7)=5.414328435075698e-3_p
x(8)=13.31248036398437_p
w(8)=1.267791480706229e-5_p
else if(N==9)then
x(1)=-11.66715379885946_p
w(1)=8.491260826260374e-1_p
x(2)=-10.29037480781899_p
w(2)=1.876830350501357_p
x(3)=-7.991439698887122_p
w(3)=2.669960282510798_p
x(4)=-5.072848833344007_p
w(4)=3.070932837539183_p
x(5)=-1.993964474955468_p
w(5)=2.620241571999022_p
x(6)=9.043395437938424e-1_p
w(6)=8.622053887176663e-1_p
x(7)=4.384309285598564_p
w(7)=5.010913755001480e-2_p
x(8)=9.108051189148581_p
w(8)=5.988370448557749e-4_p
x(9)=15.20118423215542_p
w(9)=1.650101747281774e-6_p
else if(N==10)then
x(1)=-11.71754322755414_p
w(1)=7.213466251480645e-1_p
x(2)=-10.5425173604021_p
w(2)=1.609540568027416_p
x(3)=-8.552963818285123_p
w(3)=2.333990669157679_p
x(4)=-5.960007230469354_p
w(4)=2.792023150767315_p
x(5)=-3.082774962876734_p
w(5)=2.752905485493780_p
x(6)=-3.119132606715367e-1_p
w(6)=1.553325588308245_p
x(7)=2.578480435905549_p
w(7)=2.291721631082930e-1_p
x(8)=6.318965052563781_p
w(8)=7.618307827698284e-3_p
x(9)=11.04101833344328_p
w(9)=8.320859695191393e-5_p
x(10)=16.45094781140035_p
w(10)=3.721552375350936e-7_p
else if(N==11)then
x(1)=-11.75738009812072_p
w(1)=6.201113229855759e-1_p
x(2)=-10.74371609474869_p
w(2)=1.393546364689325_p
x(3)=-9.009433937483051_p
w(3)=2.049502084572679_p
x(4)=-6.706092916985694_p
w(4)=2.516777081250978_p
x(5)=-4.059500411212109_p
w(5)=2.672766377218236_p
x(6)=-1.386417949370669_p
w(6)=2.069141508310984_p
x(7)=1.199685939466477_p
w(7)=6.291670986345173e-1_p
x(8)=4.270257522050260_p
w(8)=4.772073353981043e-2_p
x(9)=8.116724166219624_p
w(9)=1.258029944833115e-3_p
x(10)=12.64217082924536_p
w(10)=1.540884209841206e-5_p
x(11)=17.23631791890395_p
w(11)=1.286016434996120e-7_p
else if(N==12)then
x(1)=-11.78938540242393_p
w(1)=5.386463296853786e-1_p
x(2)=-10.90650140522117_p
w(2)=1.217140185868934_p
x(3)=-9.383890753485966_p
w(3)=1.809321175117264_p
x(4)=-7.333029488160248_p
w(4)=2.263690868071983_p
x(5)=-4.918101005287460_p
w(5)=2.507736833125996_p
x(6)=-2.373071160215645_p
w(6)=2.300179100957854_p
x(7)=7.444290553405926e-2_p
w(7)=1.170051580108038_p
x(8)=2.692536433538976_p
w(8)=1.834508200474902e-1_p
x(9)=5.911764811685463_p
w(9)=9.541985334166446e-3_p
x(10)=9.721554837644245_p
w(10)=2.433887008694034e-4_p
x(11)=13.92016817231167_p
w(11)=3.812245519947238e-6_p
x(12)=17.73160144390132_p
w(12)=5.932718774766271e-8_p
else if(N==13)then
x(1)=-11.81547067177626_p
w(1)=4.721665895159269e-1_p
x(2)=-11.03990022717369_p
w(2)=1.071537045786589_p
x(3)=-9.694003562155842_p
w(3)=1.606166167135112_p
x(4)=-7.861520221670254_p
w(4)=2.037656387812489_p
x(5)=-5.664857298175080_p
w(5)=2.318756186876585_p
x(6)=-3.275459930370176_p
w(6)=2.324333665887115_p
x(7)=-9.121333418006621e-1_p
w(7)=1.644420157309800_p
x(8)=1.435488104034281_p
w(8)=4.773587540200228e-1_p
x(9)=4.178259714652492_p
w(9)=4.550757563074360e-2_p
x(10)=7.442431461781889_p
w(10)=2.045549701229193e-3_p
x(11)=11.11304794713818_p
w(11)=5.680310810647948e-5_p
x(12)=14.91672214571593_p
w(12)=1.222744751523068e-6_p
x(13)=18.053374304046_p
w(13)=3.306221031461475e-8_p
else if(N==14)then
x(1)=-11.8370045144045_p
w(1)=4.172319467322352e-1_p
x(2)=-11.15049709102347_p
w(2)=9.501425278715876e-1_p
x(3)=-9.953234000851438_p
w(3)=1.433602547672045_p
x(4)=-8.309287911305450_p
w(4)=1.838300920542296_p
x(5)=-6.311888511485214_p
w(5)=2.131162763973753_p
x(6)=-4.088992382339951_p
w(6)=2.243582790630053_p
x(7)=-1.815611224580763_p
w(7)=1.923324376600242_p
x(8)=3.899102579830705e-1_p
w(8)=8.991341704694573e-1_p
x(9)=2.780439677321270_p
w(9)=1.519119057938997e-1_p
x(10)=5.610020061307919_p
w(10)=1.110230458064279e-2_p
x(11)=8.830434206635720_p
w(11)=4.933331611603211e-4_p
x(12)=12.29450914513147_p
w(12)=1.604288707597829e-5_p
x(13)=15.68552023889139_p
w(13)=4.867917476483420e-7_p
x(14)=18.27036951370373_p
w(14)=2.088448445775513e-8_p
else if(N==15)then
x(1)=-11.85498428816909_p
w(1)=3.713274660016606e-1_p
x(2)=-11.2431589377527_p
w(2)=8.479787771133407e-1_p
x(3)=-10.17185249247433_p
w(3)=1.286249099469277_p
x(4)=-8.690890656808330_p
w(4)=1.663330178947259_p
x(5)=-6.872579643677264_p
w(5)=1.954887131987335_p
x(6)=-4.814583068087440_p
w(6)=2.119877789848026_p
x(7)=-2.650293839458060_p
w(7)=2.020214701282065_p
x(8)=-5.265349104880432e-1_p
w(8)=1.315795155203052_p
x(9)=1.629233035846392_p
w(9)=3.739830840865589e-1_p
x(10)=4.105206528801831_p
w(10)=4.334796842199720e-2_p
x(11)=6.950086709543355_p
w(11)=2.872785679743632e-3_p
x(12)=10.06453144121988_p
w(12)=1.363388417726744e-4_p
x(13)=13.28366871706191_p
w(13)=5.417113105446407e-6_p
x(14)=16.27806195418788_p
w(14)=2.302217334985063e-7_p
x(15)=18.42214437856714_p
w(15)=1.437375394829066e-8_p
else if(N==16)then
x(1)=-11.87014948331053_p
w(1)=3.325837880395656e-1_p
x(2)=-11.32153463911177_p
w(2)=7.612535659683697e-1_p
x(3)=-10.35774586327234_p
w(3)=1.159707455632363_p
x(4)=-9.018090826838543_p
w(4)=1.509907170818435_p
x(5)=-7.359530245235194_p
w(5)=1.793310147058203_p
x(6)=-5.458130826078162_p
w(6)=1.983175764448233_p
x(7)=-3.415694360458536_p
w(7)=2.004441203187612_p
x(8)=-1.363089620811049_p
w(8)=1.608983559985304_p
x(9)=6.538319859900971e-1_p
w(9)=7.044824748529105e-1_p
x(10)=2.850977346217249_p
w(10)=1.289790882034129e-1_p
x(11)=5.377414238199781_p
w(11)=1.232137757894471e-2_p
x(12)=8.178884961817523_p
w(12)=8.149702243363736e-4_p
x(13)=11.14656958101349_p
w(13)=4.329362178253738e-5_p
x(14)=14.10515187305455_p
w(14)=2.143928377720126e-6_p
x(15)=16.73732009163363_p
w(15)=1.245287952101464e-7_p
x(16)=18.53184158364436_p
w(16)=1.051403687336271e-8_p
else if(N==17)then
x(1)=-11.88305732737974_p
w(1)=2.995894679616481e-1_p
x(2)=-11.38839822273546_p
w(2)=6.870476025218285e-1_p
x(3)=-10.51702293040265_p
w(3)=1.050414063107121_p
x(4)=-9.300341977719322_p
w(4)=1.375221145198870_p
x(5)=-7.783843274529625_p
w(5)=1.646974352157251_p
x(6)=-6.027798817132337_p
w(6)=1.846983579785621_p
x(7)=-4.111188328775403_p
w(7)=1.932469058750037_p
x(8)=-2.139208287354122_p
w(8)=1.753850233847714_p
x(9)=-2.043894501558303e-1_p
w(9)=1.061170146974819_p
x(10)=1.791157974391014_p
w(10)=3.010535352412677e-1_p
x(11)=4.046220511662272_p
w(11)=4.127725464349371e-2_p
x(12)=6.572515380125601_p
w(12)=3.682219070322424e-3_p
x(13)=9.289616139051693_p
w(13)=2.567251887611971e-4_p
x(14)=12.08626589517779_p
w(14)=1.569879870325577e-5_p
x(15)=14.78512143342698_p
w(15)=9.725620292574606e-7_p
x(16)=17.09662649286726_p
w(16)=7.473818989641779e-8_p
x(17)=18.61342522541539_p
w(17)=8.043005005038926e-9_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;19kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770961580563_p
w(1)=6.137601389627813_p
x(2)=-1.506529262048464_p
w(2)=4.862415306330710_p
else if(N==3)then
x(1)=-9.486306953900472_p
w(1)=3.723457190631736_p
x(2)=-4.368247774512525_p
w(2)=5.649029195445139_p
x(3)=7.022607076791781e-1_p
w(3)=1.627530309881648_p
else if(N==4)then
x(1)=-9.985629621984360_p
w(1)=2.537270709814344_p
x(2)=-6.216368315654546_p
w(2)=4.648261537118187_p
x(3)=-1.557197970665229_p
w(3)=3.520684033598183_p
x(4)=2.922687731198557_p
w(4)=2.938004154278085e-1_p
else if(N==5)then
x(1)=-10.25780904661601_p
w(1)=1.871952477983505_p
x(2)=-7.370994594469521_p
w(2)=3.724231756165322_p
x(3)=-3.287002582462993_p
w(3)=3.990264604191081_p
x(4)=5.526847194133929e-1_p
w(4)=1.386920093498785_p
x(5)=5.540324434958924_p
w(5)=2.664776411982876e-2_p
else if(N==6)then
x(1)=-10.42508994602291_p
w(1)=1.456963219608914_p
x(2)=-8.130298859097149_p
w(2)=3.031837478194721_p
x(3)=-4.638425231484705_p
w(3)=3.734416747033141_p
x(4)=-9.893969852476814e-1_p
w(4)=2.490976446158419_p
x(5)=2.659705024207487_p
w(5)=2.841511784398398e-1_p
x(6)=8.416994904297669_p
w(6)=1.671626523487134e-3_p
else if(N==7)then
x(1)=-10.53786281040166_p
w(1)=1.174708084554172_p
x(2)=-8.662930918804657_p
w(2)=2.513238863097802_p
x(3)=-5.683379945171239_p
w(3)=3.322178492320404_p
x(4)=-2.276009354826734_p
w(4)=3.017961498190602_p
x(5)=9.348182737882503e-1_p
w(5)=9.383058378139640e-1_p
x(6)=4.996306029715360_p
w(6)=3.352331219924998e-2_p
x(7)=11.27026346665077_p
w(7)=1.006077823273970e-4_p
else if(N==8)then
x(1)=-10.6195065706102_p
w(1)=9.691647178217875e-1_p
x(2)=-9.058683925296620_p
w(2)=2.112393483880280_p
x(3)=-6.506935669832094_p
w(3)=2.913644736251145_p
x(4)=-3.407034861336260_p
w(4)=3.066894895442869_p
x(5)=-3.598969470138718e-1_p
w(5)=1.732389431618010_p
x(6)=2.863166625869578_p
w(6)=2.021622882387206e-1_p
x(7)=7.368618193233945_p
w(7)=3.358893887106461e-3_p
x(8)=13.71757208236833_p
w(8)=8.248818604020320e-6_p
else if(N==9)then
x(1)=-10.68132306017919_p
w(1)=8.129016176026149e-1_p
x(2)=-9.363761442390878_p
w(2)=1.795248275101493_p
x(3)=-7.166826526798598_p
w(3)=2.547218110079756_p
x(4)=-4.389012854567310_p
w(4)=2.893967664187667_p
x(5)=-1.481865049973838_p
w(5)=2.293514804569216_p
x(6)=1.338128530758820_p
w(6)=6.251548720147803e-1_p
x(7)=4.853198265638330_p
w(7)=3.163198895653010e-2_p
x(8)=9.555715868083542_p
w(8)=3.781913336583436e-4_p
x(9)=15.49728986705556_p
w(9)=1.172112805807389e-6_p
else if(N==10)then
x(1)=-10.72934806321446_p
w(1)=6.911447828226256e-1_p
x(2)=-9.603843273059949_p
w(2)=1.541133093110648_p
x(3)=-7.700182743887962_p
w(3)=2.230649610052994_p
x(4)=-5.226120442083234_p
w(4)=2.649826494978180_p
x(5)=-2.500156618585277_p
w(5)=2.510053058608043_p
x(6)=1.407388360558958e-1_p
w(6)=1.222097315722060_p
x(7)=3.036500176325915_p
w(7)=1.502897725427713e-1_p
x(8)=6.781837279892774_p
w(8)=4.767560758101024e-3_p
x(9)=11.43822611677014_p
w(9)=5.472049476001484e-5_p
x(10)=16.65123266199543_p
w(10)=2.868683390614125e-7_p
else if(N==11)then
x(1)=-10.76735501218991_p
w(1)=5.945771500284125e-1_p
x(2)=-9.795654051352004_p
w(2)=1.335459680575085_p
x(3)=-8.134553570829949_p
w(3)=1.961370534520887_p
x(4)=-5.932858420418466_p
w(4)=2.398107237270092_p
x(5)=-3.416086949275346_p
w(5)=2.492787463330523_p
x(6)=-8.864758841737028e-1_p
w(6)=1.747119419356776_p
x(7)=1.651135378570746_p
w(7)=4.397743004595761e-1_p
x(8)=4.738598320343755_p
w(8)=3.000902391572440e-2_p
x(9)=8.553483275397980_p
w(9)=8.011243232473963e-4_p
x(10)=12.98013603846515_p
w(10)=1.065686331895228e-5_p
x(11)=17.37011789868639_p
w(11)=1.053148804734435e-7_p
else if(N==12)then
x(1)=-10.79791858962341_p
w(1)=5.167934879860063e-1_p
x(2)=-9.951010963622828_p
w(2)=1.167259991126339_p
x(3)=-8.491414185754099_p
w(3)=1.733337041235731_p
x(4)=-6.528392461427109_p
w(4)=2.162312975744087_p
x(5)=-4.225335805511392_p
w(5)=2.366917421541637_p
x(6)=-1.814798555966987_p
w(6)=2.045331103276301_p
x(7)=5.370264412674818e-1_p
w(7)=8.835518908842300e-1_p
x(8)=3.159492702543729_p
w(8)=1.183672056715534e-1_p
x(9)=6.369943053486989_p
w(9)=5.982917722640957e-3_p
x(10)=10.12071556291523_p
w(10)=1.598347714302759e-4_p
x(11)=14.19968034655044_p
w(11)=2.775362620521955e-6_p
x(12)=17.82299309274771_p
w(12)=5.063594508250305e-8_p
else if(N==13)then
x(1)=-10.82285002186268_p
w(1)=4.532623458703904e-1_p
x(2)=-10.07844487921205_p
w(2)=1.028271720662725_p
x(3)=-8.787326325186879_p
w(3)=1.540026741231792_p
x(4)=-7.031466931680863_p
w(4)=1.949702943207036_p
x(5)=-4.932196658396354_p
w(5)=2.202820426736253_p
x(6)=-2.661990900332075_p
w(6)=2.134536331952350_p
x(7)=-4.162844183290935e-1_p
w(7)=1.337360417715738_p
x(8)=1.900390983656716_p
w(8)=3.241933606725026e-1_p
x(9)=4.647647474167434_p
w(9)=2.849910910257117e-2_p
x(10)=7.876976006157729_p
w(10)=1.303627276679121e-3_p
x(11)=11.46943302929113_p
w(11)=3.870978234039367e-5_p
x(12)=15.14434658568593_p
w(12)=9.327282094549223e-7_p
x(13)=18.11795869586521_p
w(13)=2.901993420214797e-8_p
else if(N==14)then
x(1)=-10.84344708656877_p
w(1)=4.007231233038850e-1_p
x(2)=-10.18418622407071_p
w(2)=9.122781231389183e-1_p
x(3)=-9.034950048895466_p
w(3)=1.375544156900292_p
x(4)=-7.458397065663455_p
w(4)=1.761134957562124_p
x(5)=-5.546621827395400_p
w(5)=2.032337779926973_p
x(6)=-3.428329781077234_p
w(6)=2.098497911229243_p
x(7)=-1.273090757478541_p
w(7)=1.660630901520929_p
x(8)=8.624121458094065e-1_p
w(8)=6.547502684242894e-1_p
x(9)=3.253870737668814_p
w(9)=9.682867431777588e-2_p
x(10)=6.067049122617912_p
w(10)=6.956418668173195e-3_p
x(11)=9.233816966701996_p
w(11)=3.226131514482776e-4_p
x(12)=12.60755791559706_p
w(12)=1.136273829561138e-5_p
x(13)=15.8699928021755_p
w(13)=3.863872003568970e-7_p
x(14)=18.31762822780872_p
w(14)=1.868897412449066e-8_p
else if(N==15)then
x(1)=-10.86065642459536_p
w(1)=3.567897051580848e-1_p
x(2)=-10.27284632736337_p
w(2)=8.145764952732508e-1_p
x(3)=-9.243970732756472_p
w(3)=1.234899753126680_p
x(4)=-7.822717466361636_p
w(4)=1.595031282369604_p
x(5)=-6.080318602422311_p
w(5)=1.868753341695969_p
x(6)=-4.114612389405090_p
w(6)=2.003265268974441_p
x(7)=-2.059203665964964_p
w(7)=1.817994473871111_p
x(8)=-3.037982773803044e-2_p
w(8)=1.031398042817115_p
x(9)=2.104133267916052_p
w(9)=2.483408873789374e-1_p
x(10)=4.576036688653612_p
w(10)=2.704348611437257e-2_p
x(11)=7.385235550435507_p
w(11)=1.827879234437186e-3_p
x(12)=10.43330495140666_p
w(12)=9.189636437069069e-5_p
x(13)=13.55584092927618_p
w(13)=3.981752217445942e-6_p
x(14)=16.42794171052164_p
w(14)=1.887871040429025e-7_p
x(15)=18.45783799230097_p
w(15)=1.304082616931379e-8_p
else if(N==16)then
x(1)=-10.87518063563016_p
w(1)=3.196865754838257e-1_p
x(2)=-10.34788696497429_p
w(2)=7.315774644721738e-1_p
x(3)=-9.421843121995995_p
w(3)=1.113984969010737_p
x(4)=-8.135434768283131_p
w(4)=1.449014489388853_p
x(5)=-6.544656943392916_p
w(5)=1.717130011133403_p
x(6)=-4.725361112174021_p
w(6)=1.885274095925901_p
x(7)=-2.780509644840353_p
w(7)=1.850695650345670_p
x(8)=-8.302330948677897e-1_p
w(8)=1.345638396731032_p
x(9)=1.135081820662497_p
w(9)=4.973003641845964e-1_p
x(10)=3.329157648428617_p
w(10)=8.144485754150875e-2_p
x(11)=5.834739049707191_p
w(11)=7.707548891945224e-3_p
x(12)=8.586872510919809_p
w(12)=5.304089390057588e-4_p
x(13)=11.48009270485974_p
w(13)=3.011924810531376e-5_p
x(14)=14.34052731752242_p
w(14)=1.630196813136340e-6_p
x(15)=16.85994559410235_p
w(15)=1.048291899754947e-7_p
x(16)=18.55955321873456_p
w(16)=9.635761959808705e-9_p
else if(N==17)then
x(1)=-10.88754966514732_p
w(1)=2.880717737227195e-1_p
x(2)=-10.41194310895113_p
w(2)=6.605133778542939e-1_p
x(3)=-9.574352523061201_p
w(3)=1.009454179945757_p
x(4)=-8.405435605210133_p
w(4)=1.320590407477908_p
x(5)=-6.949833921386831_p
w(5)=1.578901263486483_p
x(6)=-5.267401307755526_p
w(6)=1.762219659401462_p
x(7)=-3.437980696492574_p
w(7)=1.811529621252627_p
x(8)=-1.564638279350000_p
w(8)=1.540561334237841_p
x(9)=2.942962972316600e-1_p
w(9)=8.035664101288623e-1_p
x(10)=2.273479244702793_p
w(10)=1.964234853807903e-1_p
x(11)=4.518553927542987_p
w(11)=2.566444729654481e-2_p
x(12)=7.009359899997876_p
w(12)=2.337142824519375e-3_p
x(13)=9.667995018384461_p
w(13)=1.714928738745748e-4_p
x(14)=12.38574955573417_p
w(14)=1.126635329425940e-5_p
x(15)=14.98836210986963_p
w(15)=7.620448554470671e-7_p
x(16)=17.19788674084419_p
w(16)=6.424919001274244e-8_p
x(17)=18.63545369300124_p
w(17)=7.427498829088459e-9_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;19kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291909174637_p
w(1)=5.675311277887483_p
x(2)=-1.221802619372282_p
w(2)=4.324734115408938_p
else if(N==3)then
x(1)=-8.585501196670016_p
w(1)=3.477515456998133_p
x(2)=-3.820545452225130_p
w(2)=5.186808779894982_p
x(3)=9.860489018660579e-1_p
w(3)=1.335721156403306_p
else if(N==4)then
x(1)=-9.045203797680095_p
w(1)=2.387319768036922_p
x(2)=-5.505662549463902_p
w(2)=4.342647832231838_p
x(3)=-1.158083259381156_p
w(3)=3.060266937714999_p
x(4)=3.295472213362913_p
w(4)=2.098108553126613e-1_p
else if(N==5)then
x(1)=-9.297493201540576_p
w(1)=1.771317428029983_p
x(2)=-6.569568457504683_p
w(2)=3.509832961832255_p
x(3)=-2.738107380574562_p
w(3)=3.627115468298367_p
x(4)=9.308683417275654e-1_p
w(4)=1.074718289321713_p
x(5)=5.998661040468140_p
w(5)=1.706124581410171e-2_p
else if(N==6)then
x(1)=-9.453616343107171_p
w(1)=1.384325710120091_p
x(2)=-7.275414737442038_p
w(2)=2.872874929793315_p
x(3)=-3.977792208019372_p
w(3)=3.476965941652042_p
x(4)=-5.481799664860426e-1_p
w(4)=2.074288408191859_p
x(5)=3.103025779446948_p
w(5)=1.905767847519443e-1_p
x(6)=8.920544102678564_p
w(6)=1.013618787169935e-3_p
else if(N==7)then
x(1)=-9.559663276180897_p
w(1)=1.119066166891349_p
x(2)=-7.774886780585995_p
w(2)=2.389523912795926_p
x(3)=-4.948539422663710_p
w(3)=3.128733423960846_p
x(4)=-1.745088666701519_p
w(4)=2.660673787542542_p
x(5)=1.367973050937775_p
w(5)=6.812692584329093e-1_p
x(6)=5.488202374155950_p
w(6)=2.071758258466036e-2_p
x(7)=11.75753084896299_p
w(7)=6.126108818899352e-5_p
else if(N==8)then
x(1)=-9.636903741358800_p
w(1)=9.246982208516903e-1_p
x(2)=-8.148542112219824_p
w(2)=2.012560087421307_p
x(3)=-5.721268536531634_p
w(3)=2.760134677843808_p
x(4)=-2.793838528166482_p
w(4)=2.804666127732204_p
x(5)=9.596594542053144e-2_p
w(5)=1.365481118269799_p
x(6)=3.335611780596440_p
w(6)=1.304516976800652e-1_p
x(7)=7.859603207539837_p
w(7)=2.048094435384605e-3_p
x(8)=14.11715095801436_p
w(8)=5.369062163383946e-6_p
else if(N==9)then
x(1)=-9.695568029408539_p
w(1)=7.764574883808485e-1_p
x(2)=-8.437623336400314_p
w(2)=1.712879250444751_p
x(3)=-6.343869730497091_p
w(3)=2.421311963586090_p
x(4)=-3.710030067216264_p
w(4)=2.699418424704208_p
x(5)=-9.709829172482721e-1_p
w(5)=1.938287445352602_p
x(6)=1.796989344291740_p
w(6)=4.319650183954352e-1_p
x(7)=5.341540098931015_p
w(7)=1.948833936655655e-2_p
x(8)=10.00988649245721_p
w(8)=2.366254465031030e-4_p
x(9)=15.78209676190155_p
w(9)=8.376194263058783e-7_p
else if(N==10)then
x(1)=-9.741214175266810_p
w(1)=6.607659376804962e-1_p
x(2)=-8.665543740263791_p
w(2)=1.472131831775441_p
x(3)=-6.848637910628833_p
w(3)=2.125258239186657_p
x(4)=-4.495801601536265_p
w(4)=2.497552878334287_p
x(5)=-1.923181369972066_p
w(5)=2.231428913388389_p
x(6)=6.083638943996816e-1_p
w(6)=9.148050704828177e-1_p
x(7)=3.518435150542823_p
w(7)=9.512787956258149e-2_p
x(8)=7.256939178840019_p
w(8)=2.938568948067843e-3_p
x(9)=11.83614691211286_p
w(9)=3.585149788845632e-5_p
x(10)=16.84149825428585_p
w(10)=2.224397941852060e-7_p
else if(N==11)then
x(1)=-9.777380134507693_p
w(1)=5.688983277977168e-1_p
x(2)=-8.847892646745068_p
w(2)=1.276911753216956_p
x(3)=-7.260623608643454_p
w(3)=1.871826394840141_p
x(4)=-5.162244218365910_p
w(4)=2.273481054587240_p
x(5)=-2.778450796391753_p
w(5)=2.286275125746112_p
x(6)=-3.832132485771831e-1_p
w(6)=1.410569018526292_p
x(7)=2.126888501766411_p
w(7)=2.931118696441516e-1_p
x(8)=5.223894656921565_p
w(8)=1.845896777289950e-2_p
x(9)=8.996986191765423_p
w(9)=5.054256464655892e-4_p
x(10)=13.31523805397119_p
w(10)=7.368921600548078e-6_p
x(11)=17.4968462207672_p
w(11)=8.659684651996519e-8_p
else if(N==12)then
x(1)=-9.806493675431334_p
w(1)=4.948201969025118e-1_p
x(2)=-8.995767101424681_p
w(2)=1.117011484321874_p
x(3)=-7.599689752372607_p
w(3)=1.656329061036094_p
x(4)=-5.725727396440321_p
w(4)=2.057212846445282_p
x(5)=-3.537276426227280_p
w(5)=2.209383065147864_p
x(6)=-1.260173632348563_p
w(6)=1.755422981190788_p
x(7)=1.017406290209709_p
w(7)=6.321324474508089e-1_p
x(8)=3.647648192288742_p
w(8)=7.392812863098212e-2_p
x(9)=6.839177403855299_p
w(9)=3.698696783571242e-3_p
x(10)=10.52257178963878_p
w(10)=1.044183445240542e-4_p
x(11)=14.47469533557139_p
w(11)=2.023722058207713e-6_p
x(12)=17.90970705792634_p
w(12)=4.332006282510195e-8_p
else if(N==13)then
x(1)=-9.830264785624442_p
w(1)=4.342564455350227e-1_p
x(2)=-9.117194989073003_p
w(2)=9.847060574330607e-1_p
x(3)=-7.881257732401076_p
w(3)=1.473115143701854_p
x(4)=-6.202938196457443_p
w(4)=1.859286827528864_p
x(5)=-4.203159921130083_p
w(5)=2.076666888987868_p
x(6)=-2.054247467887944_p
w(6)=1.911448686636089_p
x(7)=8.713682774581942e-2_p
w(7)=1.031845413719011_p
x(8)=2.388087845507018_p
w(8)=2.103823510213801e-1_p
x(9)=5.132127416898625_p
w(9)=1.748733340491855e-2_p
x(10)=8.318216880069958_p
w(10)=8.231903500789248e-4_p
x(11)=11.82574156421609_p
w(11)=2.631643854412351e-5_p
x(12)=15.36715941310203_p
w(12)=7.130387322468554e-7_p
x(13)=18.17945561858847_p
w(13)=2.550099773685532e-8_p
else if(N==14)then
x(1)=-9.849919874378418_p
w(1)=3.841276302790730e-1_p
x(2)=-9.218048610538775_p
w(2)=8.741647852241963e-1_p
x(3)=-8.117167246130425_p
w(3)=1.316884948853922_p
x(4)=-6.608713618568991_p
w(4)=1.682254625490127_p
x(5)=-4.784137858029993_p
w(5)=1.927129634691239_p
x(6)=-2.773099001254064_p
w(6)=1.929429185490571_p
x(7)=-7.312252943904706e-1_p
w(7)=1.370538935834529_p
x(8)=1.353977172979109_p
w(8)=4.511026946976679e-1_p
x(9)=3.746228249977749_p
w(9)=5.989389524600256e-2_p
x(10)=6.534236343801882_p
w(10)=4.300945308478587e-3_p
x(11)=9.640707657235485_p
w(11)=2.097452244826938e-4_p
x(12)=12.91883437885202_p
w(12)=8.042903216433625e-6_p
x(13)=16.05002369182137_p
w(13)=3.073229824485265e-7_p
x(14)=18.36280553338684_p
w(14)=1.672993142772949e-8_p
else if(N==15)then
x(1)=-9.866354544044482_p
w(1)=3.421774258665646e-1_p
x(2)=-9.302681260210019_p
w(2)=7.809651203054084e-1_p
x(3)=-8.316507481135982_p
w(3)=1.183071119538391_p
x(4)=-6.955520325876489_p
w(4)=1.525486388581974_p
x(5)=-5.290225045025831_p
w(5)=1.778471815471289_p
x(6)=-3.419138173408671_p
w(6)=1.870935871822887_p
x(7)=-1.472732994159283_p
w(7)=1.580304649891891_p
x(8)=4.767217298857021e-1_p
w(8)=7.628606516563076e-1_p
x(9)=2.600092771292986_p
w(9)=1.580015434680915e-1_p
x(10)=5.060492055483592_p
w(10)=1.655341463557516e-2_p
x(11)=7.826930890667263_p
w(11)=1.152570990036945e-3_p
x(12)=10.80331787724764_p
w(12)=6.172636620367918e-5_p
x(13)=13.82535835593891_p
w(13)=2.927804909911734e-6_p
x(14)=16.57400127544717_p
w(14)=1.550675818038401e-7_p
x(15)=18.4920883820679_p
w(15)=1.182930836717860e-8_p
else if(N==16)then
x(1)=-9.880234286334645_p
w(1)=3.067248145213982e-1_p
x(2)=-9.374366014060383_p
w(2)=7.017237447522271e-1_p
x(3)=-8.486294047758799_p
w(3)=1.067872307569017_p
x(4)=-7.253581512230789_p
w(4)=1.387183217320299_p
x(5)=-5.731503598394857_p
w(5)=1.638136946545320_p
x(6)=-3.996169687395467_p
w(6)=1.777252273808701_p
x(7)=-2.150839883370579_p
w(7)=1.666862717459860_p
x(8)=-2.947197225822652e-1_p
w(8)=1.066791503840760_p
x(9)=1.635597985003121_p
w(9)=3.323545336503803e-1_p
x(10)=3.824375316595459_p
w(10)=5.001750623981924e-2_p
x(11)=6.301500056364388_p
w(11)=4.760476898452141e-3_p
x(12)=8.998760390586540_p
w(12)=3.430978719832789e-4_p
x(13)=11.81331907616717_p
w(13)=2.091504210178622e-5_p
x(14)=14.57291442849607_p
w(14)=1.240597970446558e-6_p
x(15)=16.97939714072832_p
w(15)=8.835196224562595e-8_p
x(16)=18.58623509974481_p
w(16)=8.826169249136838e-9_p
else if(N==17)then
x(1)=-9.892061606621031_p
w(1)=2.764977920748109e-1_p
x(2)=-9.435597660649332_p
w(2)=6.338267974240738e-1_p
x(3)=-8.631984046907657_p
w(3)=9.681712876016848e-1_p
x(4)=-7.511199269565589_p
w(4)=1.265231405839908_p
x(5)=-6.117214670974518_p
w(5)=1.508841759397527_p
x(6)=-4.509839895496058_p
w(6)=1.670836000325219_p
x(7)=-2.769837276581698_p
w(7)=1.668903520931956_p
x(8)=-9.927489260032929e-1_p
w(8)=1.294858564646171_p
x(9)=8.062625233729789e-1_p
w(9)=5.724773078121964e-1_p
x(10)=2.775147962339334_p
w(10)=1.231343400108833e-1_p
x(11)=5.003323829314946_p
w(11)=1.567347014456123e-2_p
x(12)=7.452567540796352_p
w(12)=1.470316595050016e-3_p
x(13)=10.0483459235487_p
w(13)=1.140918135405220e-4_p
x(14)=12.68396444323302_p
w(14)=8.078883221967401e-6_p
x(15)=15.18861321426318_p
w(15)=5.976672866784761e-7_p
x(16)=17.29655014336124_p
w(16)=5.527445213233978e-8_p
x(17)=18.65672757013173_p
w(17)=6.853878133657961e-9_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;19kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781261222301113_p
w(1)=5.214313508277648_p
x(2)=-9.236274877684147e-1_p
w(2)=3.785809888309279_p
else if(N==3)then
x(1)=-7.683960070982323_p
w(1)=3.232587640852082_p
x(2)=-3.271368320248969_p
w(2)=4.705938700152037_p
x(3)=1.297698652056836_p
w(3)=1.061597055582808_p
else if(N==4)then
x(1)=-8.104467128096822_p
w(1)=2.237764760997535_p
x(2)=-4.795013752327463_p
w(2)=4.027531092489482_p
x(3)=-7.493355191652789e-1_p
w(3)=2.590882108659493_p
x(4)=3.703471690368356_p
w(4)=1.439454344404174e-1_p
else if(N==5)then
x(1)=-8.337089503037703_p
w(1)=1.670680895939905_p
x(2)=-5.768577268530009_p
w(2)=3.290746390648785_p
x(3)=-2.191025148645203_p
w(3)=3.231246087851724_p
x(4)=1.338233640740957_p
w(4)=7.968813576279354e-1_p
x(5)=6.487945048775943_p
w(5)=1.056866451857705e-2_p
else if(N==6)then
x(1)=-8.482192139365287_p
w(1)=1.311417392705083_p
x(2)=-6.421275204666621_p
w(2)=2.710954029894957_p
x(3)=-3.321213342248663_p
w(3)=3.194870431257927_p
x(4)=-9.520940895892482e-2_p
w(4)=1.659834588864131_p
x(5)=3.580212087834858_p
w(5)=1.224468746202002e-1_p
x(6)=9.446276831457384_p
w(6)=6.000792446279444e-4_p
else if(N==7)then
x(1)=-8.581582995088768_p
w(1)=1.063019489789099_p
x(2)=-6.887741615423665_p
w(2)=2.263611555227736_p
x(3)=-4.217524211260979_p
w(3)=2.920763204848354_p
x(4)=-1.215992263218487_p
w(4)=2.270044116484314_p
x(5)=1.830713078983188_p
w(5)=4.701968518884379e-1_p
x(6)=6.004148734729713_p
w(6)=1.245126274020391e-2_p
x(7)=12.25148283838145_p
w(7)=3.691560878219396e-5_p
else if(N==8)then
x(1)=-8.654424452056116_p
w(1)=8.798423761280588e-1_p
x(2)=-7.239214148675981_p
w(2)=1.911086745271984_p
x(3)=-4.938629951922173_p
w(3)=2.598136315051285_p
x(4)=-2.186830801640101_p
w(4)=2.505409204488283_p
x(5)=5.686264565968401e-1_p
w(5)=1.023364823172284_p
x(6)=3.835779240532157_p
w(6)=8.105203841185978e-2_p
x(7)=8.364188185147807_p
w(7)=1.228391986137483e-3_p
x(8)=14.50888014199701_p
w(8)=3.502077035354783e-6_p
else if(N==9)then
x(1)=-8.709915647239407_p
w(1)=7.396942916496411e-1_p
x(2)=-7.512131789149835_p
w(2)=1.629306709189537_p
x(3)=-5.523161125933595_p
w(3)=2.290224260127361_p
x(4)=-3.036934955340113_p
w(4)=2.478866020378979_p
x(5)=-4.567298242361723e-1_p
w(5)=1.566204599086966_p
x(6)=2.284027491995288_p
w(6)=2.839487084878198e-1_p
x(7)=5.848671075963481_p
w(7)=1.173141023196818e-2_p
x(8)=10.4695031397202_p
w(8)=1.467948201495443e-4_p
x(9)=16.05470750850326_p
w(9)=6.026145057545623e-7_p
else if(N==10)then
x(1)=-8.753163020967374_p
w(1)=6.301305340040890e-1_p
x(2)=-7.727751848172551_p
w(2)=1.402228865426481_p
x(3)=-5.998774228282596_p
w(3)=2.016513560201385_p
x(4)=-3.770099725095460_p
w(4)=2.329182025555363_p
x(5)=-1.350347993675327_p
w(5)=1.914587416837319_p
x(6)=1.096924061600486_p
w(6)=6.474415786576215e-1_p
x(7)=4.024029328929749_p
w(7)=5.823058914707396e-2_p
x(8)=7.743516387654858_p
w(8)=1.785234339297611e-3_p
x(9)=12.23378220882871_p
w(9)=2.341891241711983e-5_p
x(10)=17.02169768303936_p
w(10)=1.735058801798208e-7_p
else if(N==11)then
x(1)=-8.787473048516516_p
w(1)=5.430094865438455e-1_p
x(2)=-7.900538527738168_p
w(2)=1.217666075572615_p
x(3)=-6.387987569177007_p
w(3)=1.779984676284050_p
x(4)=-4.395124318270212_p
w(4)=2.138961344581783_p
x(5)=-2.146958106749248_p
w(5)=2.044339214207498_p
x(6)=1.293091096230450e-1_p
w(6)=1.078288749505647_p
x(7)=2.628672034855824_p
w(7)=1.864309352853226e-1_p
x(8)=5.725352281941126_p
w(8)=1.112163908547221e-2_p
x(9)=9.446462994606151_p
w(9)=3.161067976031722e-4_p
x(10)=13.64671628021716_p
w(10)=5.097241747392250e-6_p
x(11)=17.61666886065389_p
w(11)=7.148134312773216e-8_p
else if(N==12)then
x(1)=-8.815125236804358_p
w(1)=4.726720088784644e-1_p
x(2)=-8.040856647610539_p
w(2)=1.066208114761796_p
x(3)=-6.708988025680664_p
w(3)=1.577668826864050_p
x(4)=-4.925726853617765_p
w(4)=1.945821748740493_p
x(5)=-2.854908466122197_p
w(5)=2.026597913313687_p
x(6)=-7.057693096141091e-1_p
w(6)=1.437030168084306_p
x(7)=1.520364580019866_p
w(7)=4.269900134622241e-1_p
x(8)=4.156374169824756_p
w(8)=4.480891131621918e-2_p
x(9)=7.318730331158712_p
w(9)=2.256278111053929e-3_p
x(10)=10.92641157152974_p
w(10)=6.789744029702198e-5_p
x(11)=14.74473258885478_p
w(11)=1.478474134300782e-6_p
x(12)=17.9919007480749_p
w(12)=3.714020109206547e-8_p
else if(N==13)then
x(1)=-8.837727163337698_p
w(1)=4.151030233368780e-1_p
x(2)=-8.156222171203188_p
w(2)=9.406897285867796e-1_p
x(3)=-6.976014736361449_p
w(3)=1.404967887359607_p
x(4)=-5.376479497301443_p
w(4)=1.764687399692117_p
x(5)=-3.478778398407093_p
w(5)=1.933944445699419_p
x(6)=-1.451311037125128_p
w(6)=1.649888218048686_p
x(7)=6.043465586558702e-1_p
w(7)=7.489882199299769e-1_p
x(8)=2.899320257955487_p
w(8)=1.307906835297012e-1_p
x(9)=5.630838074356994_p
w(9)=1.053001789723608e-2_p
x(10)=8.765490689391349_p
w(10)=5.153479463723565e-4_p
x(11)=12.18138137137636_p
w(11)=1.785578552037519e-5_p
x(12)=15.58490005244806_p
w(12)=5.463448661101050e-7_p
x(13)=18.23797652690362_p
w(13)=2.242976602395460e-8_p
else if(N==14)then
x(1)=-8.856433183840730_p
w(1)=3.674064277053420e-1_p
x(2)=-8.252144017025222_p
w(2)=8.356791712452746e-1_p
x(3)=-7.200062382215128_p
w(3)=1.257271947545442_p
x(4)=-5.760671053263496_p
w(4)=1.600467181834500_p
x(5)=-4.025337298157947_p
w(5)=1.811147065664477_p
x(6)=-2.123746951935816_p
w(6)=1.727228105477192_p
x(7)=-1.850894030636078e-1_p
w(7)=1.068208444125673_p
x(8)=1.868070429408351_p
w(8)=2.938908474856836e-1_p
x(9)=4.256681664718394_p
w(9)=3.605646425273618e-2_p
x(10)=7.010857177919655_p
w(10)=2.626155691068423e-3_p
x(11)=10.05052100942828_p
w(11)=1.356344264601760e-4_p
x(12)=13.22788766060212_p
w(12)=5.691212087489873e-6_p
x(13)=16.22549022644904_p
w(13)=2.449423606993557e-7_p
x(14)=18.40597480225021_p
w(14)=1.497862997659933e-8_p
else if(N==15)then
x(1)=-8.872087428167740_p
w(1)=3.274570818244346e-1_p
x(2)=-8.332714148015651_p
w(2)=7.470418832643876e-1_p
x(3)=-7.389608872368512_p
w(3)=1.130487054017814_p
x(4)=-6.089648387000119_p
w(4)=1.453839779101838_p
x(5)=-4.503043374181555_p
w(5)=1.681036429193045_p
x(6)=-2.729088257312382_p
w(6)=1.714459925375877_p
x(7)=-8.884107084645607e-1_p
w(7)=1.309071393267795_p
x(8)=1.000467668203953_p
w(8)=5.293351829223795e-1_p
x(9)=3.117197390709116_p
w(9)=9.667268461954166e-2_p
x(10)=5.557686564608775_p
w(10)=9.957732064049129e-3_p
x(11)=8.274564419078729_p
w(11)=7.206258119356489e-4_p
x(12)=11.17407478780874_p
w(12)=4.133278163859355e-5_p
x(13)=14.0919001344156_p
w(13)=2.154040345357525e-6_p
x(14)=16.71619296110655_p
w(14)=1.275751953951321e-7_p
x(15)=18.52494330574511_p
w(15)=1.072665065481224e-8_p
else if(N==16)then
x(1)=-8.885317977883744_p
w(1)=2.936694328243739e-1_p
x(2)=-8.401014713111792_p
w(2)=6.716056435685807e-1_p
x(3)=-7.551220958575156_p
w(3)=1.021148486505162_p
x(4)=-6.372816288622565_p
w(4)=1.323779693533168_p
x(5)=-4.920676878552528_p
w(5)=1.554242818583632_p
x(6)=-3.271542880997879_p
w(6)=1.652635170806032_p
x(7)=-1.526150779289842_p
w(7)=1.446223087508317_p
x(8)=2.491480140152188e-1_p
w(8)=7.930105929610464e-1_p
x(9)=2.157678723859601_p
w(9)=2.107004606594468e-1_p
x(10)=4.335695524468511_p
w(10)=2.996606621626769e-2_p
x(11)=6.776985317384555_p
w(11)=2.905743365588551e-3_p
x(12)=9.414030232287562_p
w(12)=2.206718313768632e-4_p
x(13)=12.14584712046936_p
w(13)=1.450061241013854e-5_p
x(14)=14.80209585566654_p
w(14)=9.449853386676540e-7_p
x(15)=17.09566377037551_p
w(15)=7.454703830186111e-8_p
x(16)=18.61191864042731_p
w(16)=8.079148879237178e-9_p
else if(N==17)then
x(1)=-8.896599677034514_p
w(1)=2.648421339918257e-1_p
x(2)=-8.459398742591295_p
w(2)=6.069137697916974e-1_p
x(3)=-7.690021016102377_p
w(3)=9.263851203654064e-1_p
x(4)=-6.617869121171092_p
w(4)=1.208661538347751_p
x(5)=-5.286480826507229_p
w(5)=1.435310787542149_p
x(6)=-3.756007406594538_p
w(6)=1.568153298859782_p
x(7)=-2.107243376838197_p
w(7)=1.495513031125901_p
x(8)=-4.196646340444230e-1_p
w(8)=1.026782094523432_p
x(9)=1.336273126746796_p
w(9)=3.826522512390343e-1_p
x(10)=3.295827946368721_p
w(10)=7.449204764230059e-2_p
x(11)=5.499641908175472_p
w(11)=9.418038515625421e-3_p
x(12)=7.901562226826227_p
w(12)=9.173520375418234e-4_p
x(13)=10.43023042299034_p
w(13)=7.561983032138096e-5_p
x(14)=12.98059679072997_p
w(14)=5.789661990427616e-6_p
x(15)=15.38573261103187_p
w(15)=4.692088478019450e-7_p
x(16)=17.39262189713656_p
w(16)=4.758441637029047e-8_p
x(17)=18.6772678998118_p
w(17)=6.318903574722698e-9_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;19kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704939611111_p
w(1)=4.752845119444999_p
x(2)=-6.083146930579379e-1_p
w(2)=3.247490281325101_p
else if(N==3)then
x(1)=-6.781804639386830_p
w(1)=2.987678301286060_p
x(2)=-2.720455127956515_p
w(2)=4.201207104461131_p
x(3)=1.642690557745330_p
w(3)=8.114499950229075e-1_p
else if(N==4)then
x(1)=-7.163540432718857_p
w(1)=2.087932223581755_p
x(2)=-4.085232480757788_p
w(2)=3.696710700077584_p
x(3)=-3.260931155349066e-1_p
w(3)=2.121106668737378_p
x(4)=4.149703706904368_p
w(4)=9.458580837338175e-2_p
else if(N==5)then
x(1)=-7.376706307805177_p
w(1)=1.569535495030418_p
x(2)=-4.968802759045955_p
w(2)=3.063061630960030_p
x(3)=-1.644469601724681_p
w(3)=2.799935638651649_p
x(4)=1.780536821659661_p
w(4)=5.614758048567102e-1_p
x(5)=7.009423279378288_p
w(5)=6.326831271291669e-3_p
else if(N==6)then
x(1)=-7.510911517750716_p
w(1)=1.237836580001674_p
x(2)=-5.568520454025368_p
w(2)=2.543610002467511_p
x(3)=-2.669594683310755_p
w(3)=2.878491093966207_p
x(4)=3.763416024021460e-1_p
w(4)=1.264714108755989_p
x(5)=4.092472963650923_p
w(5)=7.533665158985800e-2_p
x(6)=9.993536476353146_p
w(6)=3.469639888590582e-4_p
else if(N==7)then
x(1)=-7.603694031419186_p
w(1)=1.006264264595477_p
x(2)=-6.001968978961540_p
w(2)=2.133898946196467_p
x(3)=-3.491593976096681_p
w(3)=2.690101579806762_p
x(4)=-6.844283255998520e-1_p
w(4)=1.855301927517693_p
x(5)=2.326980511441468_p
w(5)=3.074636191140597e-1_p
x(6)=6.543550583770543_p
w(6)=7.283004823164852e-3_p
x(7)=12.74934163876916_p
w(7)=2.205871647515392e-5_p
else if(N==8)then
x(1)=-7.672120140991551_p
w(1)=8.343731134117417e-1_p
x(2)=-6.331033869906264_p
w(2)=1.806898639015239_p
x(3)=-4.160068044870980_p
w(3)=2.422155266719071_p
x(4)=-1.584973971990840_p
w(4)=2.163995994246489_p
x(5)=1.065042778282397_p
w(5)=7.236215454401952e-1_p
x(6)=4.363523851790498_p
w(6)=4.856325030776142e-2_p
x(7)=8.881342653862509_p
w(7)=7.252985643729847e-4_p
x(8)=14.89045447443016_p
w(8)=2.293065228881407e-6_p
else if(N==9)then
x(1)=-7.724404927465279_p
w(1)=7.024384479633949e-1_p
x(2)=-6.587535030727444_p
w(2)=1.543769326265406_p
x(3)=-4.705512408652311_p
w(3)=2.150373307586519_p
x(4)=-2.370379864755125_p
w(4)=2.222129641661120_p
x(5)=6.753502956985445e-2_p
w(5)=1.197024517864610_p
x(6)=2.801236212994984_p
w(6)=1.776017983949870e-1_p
x(7)=6.373829320913223_p
w(7)=6.907551932275276e-3_p
x(8)=10.93341311084288_p
w(8)=9.037240585575271e-5_p
x(9)=16.31440136917042_p
w(9)=4.366959320601967e-7_p
else if(N==10)then
x(1)=-7.765225851152698_p
w(1)=5.990983479710132e-1_p
x(2)=-6.790661721323298_p
w(2)=1.330858004701510_p
x(3)=-5.151221217297667_p
w(3)=1.902024822930675_p
x(4)=-3.050129276173653_p
w(4)=2.135746510787589_p
x(5)=-7.779963702427496e-1_p
w(5)=1.565626424888131_p
x(6)=1.611845679310622_p
w(6)=4.313485067959896e-1_p
x(7)=4.552642354392673_p
w(7)=3.454760411296117e-2_p
x(8)=8.240751376319741_p
w(8)=1.069778716676122e-3_p
x(9)=12.63009512165852_p
w(9)=1.526373787077334e-5_p
x(10)=17.19187537421638_p
w(10)=1.361276829341862e-7_p
else if(N==11)then
x(1)=-7.797659319863167_p
w(1)=5.167949867695767e-1_p
x(2)=-6.953747189925619_p
w(2)=1.157286919986852_p
x(3)=-5.517138502042537_p
w(3)=1.684190266411362_p
x(4)=-3.632581669911824_p
w(4)=1.988016174618696_p
x(5)=-1.520720122899173_p
w(5)=1.760592202367287_p
x(6)=6.582134351885347e-1_p
w(6)=7.732516436116067e-1_p
x(7)=3.157129311558645_p
w(7)=1.134316981169619e-1_p
x(8)=6.242117016089615_p
w(8)=6.571807068139824e-3_p
x(9)=9.901095964064934_p
w(9)=1.961135863757739e-4_p
x(10)=13.9738199284333_p
w(10)=3.529015835381553e-6_p
x(11)=17.72978147747973_p
w(11)=5.921740579643004e-8_p
else if(N==12)then
x(1)=-7.823834430115570_p
w(1)=4.502522376776023e-1_p
x(2)=-7.086406064985795_p
w(2)=1.014505647015681_p
x(3)=-5.819700232222995_p
w(3)=1.496167385731541_p
x(4)=-4.129312318153171_p
w(4)=1.823600114586852_p
x(5)=-2.178773724087208_p
w(5)=1.808289025269205_p
x(6)=-1.458556127403827e-1_p
w(6)=1.107551735496094_p
x(7)=2.049490011573688_p
w(7)=2.721407162787959e-1_p
x(8)=4.684767421233389_p
w(8)=2.642428371596290e-2_p
x(9)=7.807836214876072_p
w(9)=1.359172446738607e-3_p
x(10)=11.33149945273302_p
w(10)=4.396814720655999e-5_p
x(11)=15.00934110458333_p
w(11)=1.082502878161788e-6_p
x(12)=18.06973916734768_p
w(12)=3.190154319743185e-8_p
else if(N==13)then
x(1)=-7.845254842610398_p
w(1)=3.957202685306456e-1_p
x(2)=-7.195630643933339_p
w(2)=8.959448170671688e-1_p
x(3)=-6.071912316931812_p
w(3)=1.334701605427727_p
x(4)=-4.552844919618511_p
w(4)=1.662741250710585_p
x(5)=-2.760070970978149_p
w(5)=1.765333151262547_p
x(6)=-8.502255114160158e-1_p
w(6)=1.352729361756121_p
x(7)=1.141659916767259_p
w(7)=5.084209005025461e-1_p
x(8)=3.433917236561751_p
w(8)=7.818068600241702e-2_p
x(9)=6.142890807607413_p
w(9)=6.230786932223882e-3_p
x(10)=9.218112347335797_p
w(10)=3.200367827288429e-4_p
x(11)=12.53575775814335_p
w(11)=1.209643451332797e-5_p
x(12)=15.79733697852707_p
w(12)=4.196184680548023e-7_p
x(13)=18.29363437965672_p
w(13)=1.974240806269662e-8_p
else if(N==14)then
x(1)=-7.863001945778571_p
w(1)=3.504895447419304e-1_p
x(2)=-7.286559363100316_p
w(2)=7.965927579047812e-1_p
x(3)=-6.283892699899306_p
w(3)=1.196029167115932_p
x(4)=-4.914881964447986_p
w(4)=1.513522510064643_p
x(5)=-3.271283020280056_p
w(5)=1.677204791220185_p
x(6)=-1.479536410617038_p
w(6)=1.484787822379209_p
x(7)=3.719826651821111e-1_p
w(7)=7.773634423669724e-1_p
x(8)=2.406731848833880_p
w(8)=1.814864397501901e-1_p
x(9)=4.784211676364112_p
w(9)=2.118253210849240e-2_p
x(10)=7.496181859284851_p
w(10)=1.584877836765036e-3_p
x(11)=10.4626601552301_p
w(11)=8.727926096726706e-5_p
x(12)=13.53427682523328_p
w(12)=4.026988222992830e-6_p
x(13)=16.3962915301239_p
w(13)=1.956216757117560e-7_p
x(14)=18.44720955454346_p
w(14)=1.341013264621639e-8_p
else if(N==15)then
x(1)=-7.877867792835127_p
w(1)=3.125682523794632e-1_p
x(2)=-7.363018262769459_p
w(2)=7.126159227951094e-1_p
x(3)=-6.463487784113719_p
w(3)=1.076616946424636_p
x(4)=-5.225601602665098_p
w(4)=1.378448984165545_p
x(5)=-3.719730593217719_p
w(5)=1.571186438367960_p
x(6)=-2.044910090398430_p
w(6)=1.523731402120281_p
x(7)=-3.014305737176129e-1_p
w(7)=1.017823066057469_p
x(8)=1.545771602021837_p
w(8)=3.438466381460112e-1_p
x(9)=3.654812401394244_p
w(9)=5.712620295752802e-2_p
x(10)=6.066731090273153_p
w(10)=5.895246607063255e-3_p
x(11)=8.727522027986087_p
w(11)=4.469992310870322e-4_p
x(12)=11.54507852961716_p
w(12)=2.760077000516479e-5_p
x(13)=14.35516016968073_p
w(13)=1.585910294224761e-6_p
x(14)=16.85448381917278_p
w(14)=1.051159335527153e-7_p
x(15)=18.55645049887455_p
w(15)=9.721712816846531e-9_p
else if(N==16)then
x(1)=-7.890442627363475_p
w(1)=2.804678084802580e-1_p
x(2)=-7.427895421625448_p
w(2)=6.410616069031545e-1_p
x(3)=-6.616802121503495_p
w(3)=9.733878311987464e-1_p
x(4)=-5.493550811487682_p
w(4)=1.257573162561272_p
x(5)=-4.112995132022839_p
w(5)=1.461628260352318_p
x(6)=-2.552389653183798_p
w(6)=1.502051309510007_p
x(7)=-9.040337531670586e-1_p
w(7)=1.189181864310499_p
x(8)=8.078791026396669e-1_p
w(8)=5.482468860376268e-1_p
x(9)=2.702236382971589_p
w(9)=1.272682696289955e-1_p
x(10)=4.862058820827028_p
w(10)=1.756215935055823e-2_p
x(11)=7.260493289899418_p
w(11)=1.754231628155634e-3_p
x(12)=9.832160558166942_p
w(12)=1.411798678245277e-4_p
x(13)=12.47728050615081_p
w(13)=1.004006241414936e-5_p
x(14)=15.0278691998066_p
w(14)=7.205279842657029e-7_p
x(15)=17.20874417112952_p
w(15)=6.296110596007632e-8_p
x(16)=18.6366352932238_p
w(16)=7.389178960000578e-9_p
else if(N==17)then
x(1)=-7.901173317979389_p
w(1)=2.530586175266488e-1_p
x(2)=-7.483399881767313_p
w(2)=5.796359542595230e-1_p
x(3)=-6.748614304360394_p
w(3)=8.837477401329478e-1_p
x(4)=-5.725787715260177_p
w(4)=1.149935647701191_p
x(5)=-4.458320209713438_p
w(5)=1.355508466376631_p
x(6)=-3.006908444426820_p
w(6)=1.446623018369970_p
x(7)=-1.449576203826617_p
w(7)=1.283918057083917_p
x(8)=1.605463902207703e-1_p
w(8)=7.577078152516060e-1_p
x(9)=1.887780018179221_p
w(9)=2.403142579259746e-1_p
x(10)=3.834631800402478_p
w(10)=4.368700794007351e-2_p
x(11)=6.006634516333738_p
w(11)=5.576383369910938e-3_p
x(12)=8.355773097691042_p
w(12)=5.679233976940536e-4_p
x(13)=10.81321117732572_p
w(13)=4.994864305658855e-5_p
x(14)=13.27534184482408_p
w(14)=4.147262488280274e-6_p
x(15)=15.57959123282217_p
w(15)=3.687233203516579e-7_p
x(16)=17.48611355807108_p
w(16)=4.098554215949609e-8_p
x(17)=18.69709583326285_p
w(17)=5.819603964482878e-9_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;19kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160733444183043_p
w(1)=4.287641529949322_p
x(2)=-2.708845647472475e-1_p
w(2)=2.713269930901656_p
else if(N==3)then
x(1)=-5.879257469091348_p
w(1)=2.740827254659603_p
x(2)=-2.166748749659721_p
w(2)=3.668241982150560_p
x(3)=2.027279912502804_p
w(3)=5.918422240408143e-1_p
else if(N==4)then
x(1)=-6.222621805832440_p
w(1)=1.936520760272704_p
x(2)=-3.377176922876856_p
w(2)=3.341317960118510_p
x(3)=1.183128392227022e-1_p
w(3)=1.663711897169614_p
x(4)=4.637093060259707_p
w(4)=5.936084329014944e-2_p
else if(N==5)then
x(1)=-6.416510731737779_p
w(1)=1.466929695769883_p
x(2)=-4.171276705410748_p
w(2)=2.820266914436368_p
x(3)=-1.095173226060905_p
w(3)=2.336489116508721_p
x(4)=2.263380533768294_p
w(4)=3.735695981033693e-1_p
x(5)=7.564270331031781_p
w(5)=3.656136032636862e-3_p
else if(N==6)then
x(1)=-6.539912190050775_p
w(1)=1.162854589782755_p
x(2)=-4.718028165277052_p
w(2)=2.366488382174021_p
x(3)=-2.022934392507346_p
w(3)=2.518527200073005_p
x(4)=8.745527131463461e-1_p
w(4)=9.084473959459344e-1_p
x(5)=4.640480442931708_p
w(5)=4.439782981055701e-2_p
x(6)=10.5611834603454_p
w(6)=1.960630647050650e-4_p
else if(N==7)then
x(1)=-6.626099264783456_p
w(1)=9.482523739292746e-1_p
x(2)=-5.118225197884529_p
w(2)=1.997464843892274_p
x(3)=-2.771865721488565_p
w(3)=2.425579380653047_p
x(4)=-1.435032696382765e-1_p
w(4)=1.435212809727597_p
x(5)=2.859611596542519_p
w(5)=1.902394598582050e-1_p
x(6)=7.105644985349580_p
w(6)=4.149492129732768e-3_p
x(7)=13.24791173433112_p
w(7)=1.310066084665726e-5_p
else if(N==8)then
x(1)=-6.690065787250489_p
w(1)=7.878751055768713e-1_p
x(2)=-5.424478242269754_p
w(2)=1.697977925897903_p
x(3)=-3.386790670347387_p
w(3)=2.223418772266904_p
x(4)=-9.849111491782382e-1_p
w(4)=1.783365938160000_p
x(5)=1.591875825176914_p
w(5)=4.797406614818139e-1_p
x(6)=4.918334624767705_p
w(6)=2.810958757547729e-2_p
x(7)=9.409921376538428_p
w(7)=4.219602732795000e-4_p
x(8)=15.25968481883821_p
w(8)=1.509618728847236e-6_p
else if(N==9)then
x(1)=-6.739093806595007_p
w(1)=6.643615966271968e-1_p
x(2)=-5.664196171183995_p
w(2)=1.454807832306281_p
x(3)=-3.891973012618136_p
w(3)=1.995524894312125_p
x(4)=-1.709819562887227_p
w(4)=1.920319109588710_p
x(5)=6.100677308700411e-1_p
w(5)=8.559596028362708e-1_p
x(6)=3.349474957304641_p
w(6)=1.059005090613546e-1_p
x(7)=6.916188025771495_p
w(7)=3.982334885283863e-3_p
x(8)=11.40038371256309_p
w(8)=5.526235850793225e-5_p
x(9)=16.56065107203161_p
w(9)=3.188752473575990e-7_p
else if(N==10)then
x(1)=-6.777449225711718_p
w(1)=5.674018311871586e-1_p
x(2)=-5.854559713628753_p
w(2)=1.256921395837016_p
x(3)=-4.306840024768393_p
w(3)=1.777409390532866_p
x(4)=-2.336637081030429_p
w(4)=1.905684168307441_p
x(5)=-1.997279633256195e-1_p
w(5)=1.202798581497569_p
x(6)=2.157262651710908_p
w(6)=2.701439963451674e-1_p
x(7)=5.103399914598436_p
w(7)=1.990928123901569e-2_p
x(8)=8.747775314487424_p
w(8)=6.327746307577638e-4_p
x(9)=13.02402952258653_p
w(9)=9.933869198912218e-6_p
x(10)=17.35216286223026_p
w(10)=1.074047871609531e-7_p
else if(N==11)then
x(1)=-6.807977005678730_p
w(1)=4.900329022608120e-1_p
x(2)=-6.007748677775785_p
w(2)=1.094922807915322_p
x(3)=-4.648771750832307_p
w(3)=1.581306772981720_p
x(4)=-2.875733567411967_p
w(4)=1.810644128689253_p
x(5)=-8.965267375463214e-1_p
w(5)=1.437285645415304_p
x(6)=1.210755637843291_p
w(6)=5.165343918930188e-1_p
x(7)=3.712006900496842_p
w(7)=6.624870381878728e-2_p
x(8)=6.773308877041538_p
w(8)=3.812842569840367e-3_p
x(9)=10.36003292462512_p
w(9)=1.207694530717898e-4_p
x(10)=14.29582472294865_p
w(10)=2.446634453335404e-6_p
x(11)=17.83640675363352_p
w(11)=4.921939545764410e-8_p
else if(N==12)then
x(1)=-6.832652727125034_p
w(1)=4.273742334302719e-1_p
x(2)=-6.132602772938711_p
w(2)=9.612270504572915e-1_p
x(3)=-4.932388286839238_p
w(3)=1.409520494850861_p
x(4)=-3.337592155288779_p
w(4)=1.682880966542105_p
x(5)=-1.508085239675272_p
w(5)=1.546146493485265_p
x(6)=4.273110736343034e-1_p
w(6)=7.936793130369606e-1_p
x(7)=2.606798243049524_p
w(7)=1.640481739431795e-1_p
x(8)=5.231788878610605_p
w(8)=1.519643955659201e-2_p
x(9)=8.305714795868033_p
w(9)=8.091034841409976e-4_p
x(10)=11.73709042091359_p
w(10)=2.837012243391501e-5_p
x(11)=15.26811003172686_p
w(11)=7.944968646315948e-7_p
x(12)=18.1433944824409_p
w(12)=2.744501115674318e-8_p
else if(N==13)then
x(1)=-6.852874127780963_p
w(1)=3.759492894340133e-1_p
x(2)=-6.235575059361223_p
w(2)=8.499215823182613e-1_p
x(3)=-5.169408172067869_p
w(3)=1.260576735711870_p
x(4)=-3.733014920047970_p
w(4)=1.547764429916370_p
x(5)=-2.047508735076030_p
w(5)=1.559473128554647_p
x(6)=-2.452834173435197e-1_p
w(6)=1.036207143503342_p
x(7)=1.704350734766582_p
w(7)=3.220691138359355e-1_p
x(8)=3.991066162866588_p
w(8)=4.511695706792057e-2_p
x(9)=6.667401845818169_p
w(9)=3.627297261599900e-3_p
x(10)=9.675387326553652_p
w(10)=1.972575869676034e-4_p
x(11)=12.88828588625829_p
w(11)=8.185209330058862e-6_p
x(12)=16.00427370260206_p
w(12)=3.230658214436997e-7_p
x(13)=18.34654399285957_p
w(13)=1.738489884854211e-8_p
else if(N==14)then
x(1)=-6.869648362567914_p
w(1)=3.332402656179164e-1_p
x(2)=-6.321423752291431_p
w(2)=7.564511256443497e-1_p
x(3)=-5.369034880093976_p
w(3)=1.131809584909883_p
x(4)=-4.072179733722546_p
w(4)=1.417206083776285_p
x(5)=-2.522931637715942_p
w(5)=1.514768935346861_p
x(6)=-8.374637866547031e-1_p
w(6)=1.203737741516281_p
x(7)=9.473621349484481e-1_p
w(7)=5.237932618982555e-1_p
x(8)=2.970558138138084_p
w(8)=1.067266896327308e-1_p
x(9)=5.327731832679774_p
w(9)=1.217282979504987e-2_p
x(10)=7.989488125629834_p
w(10)=9.460127879261275e-4_p
x(11)=10.87652839970174_p
w(11)=5.591138947118010e-5_p
x(12)=13.83758068548115_p
w(12)=2.849994372710181e-6_p
x(13)=16.56235206376342_p
w(13)=1.565388639179572e-7_p
x(14)=18.48658395847819_p
w(14)=1.200273169598423e-8_p
else if(N==15)then
x(1)=-6.883714546209966_p
w(1)=2.973921854157178e-1_p
x(2)=-6.393702510335286_p
w(2)=6.773058369617473e-1_p
x(3)=-5.538457557221134_p
w(3)=1.020393769555809_p
x(4)=-4.364079665139032_p
w(4)=1.296146507913029_p
x(5)=-2.941346756775510_p
w(5)=1.440329782805260_p
x(6)=-1.365655426270690_p
w(6)=1.291120513262219_p
x(7)=2.952811574819649e-1_p
w(7)=7.321901556413882e-1_p
x(8)=2.115917933662688_p
w(8)=2.095584993807963e-1_p
x(9)=4.211866690407607_p
w(9)=3.274028734569099e-2_p
x(10)=6.586762383056220_p
w(10)=3.439056174957288e-3_p
x(11)=9.185194711645620_p
w(11)=2.752161966790665e-4_p
x(12)=11.91584075228032_p
w(12)=1.838605716362894e-5_p
x(13)=14.61485448606864_p
w(13)=1.168605384801339e-6_p
x(14)=16.98885800242739_p
w(14)=8.673055692887190e-8_p
x(15)=18.58665813393529_p
w(15)=8.804577629498893e-9_p
else if(N==16)then
x(1)=-6.895624468205247_p
w(1)=2.670159239250676e-1_p
x(2)=-6.455100870605326_p
w(2)=6.097672835699252e-1_p
x(3)=-5.683300876991476_p
w(3)=9.237280499167047e-1_p
x(4)=-4.616372100743713_p
w(4)=1.186139140847074_p
x(5)=-3.309463641880759_p
w(5)=1.353602807174139_p
x(6)=-1.838936994032539_p
w(6)=1.314673634863432_p
x(7)=-2.794027761805460e-1_p
w(7)=9.097322973493944e-1_p
x(8)=1.387453365901262_p
w(8)=3.513490141346894e-1_p
x(9)=3.269012830260956_p
w(9)=7.366576275261219e-2_p
x(10)=5.402385723979688_p
w(10)=1.009190887696432e-2_p
x(11)=7.751344287850803_p
w(11)=1.048204818514560e-3_p
x(12)=10.25263712054106_p
w(12)=8.987879808042622e-5_p
x(13)=12.80723705635268_p
w(13)=6.943906864884339e-6_p
x(14)=15.25005245302119_p
w(14)=5.499461552987134e-7_p
x(15)=17.31864845069016_p
w(15)=5.322010767079327e-8_p
x(16)=18.66041693222299_p
w(16)=6.751253205053973e-9_p
else if(N==17)then
x(1)=-6.905796569079595_p
w(1)=2.410554472047197e-1_p
x(2)=-6.507680702413247_p
w(2)=5.517143532268194e-1_p
x(3)=-5.807987349707684_p
w(3)=8.395500278839123e-1_p
x(4)=-4.835449677252281_p
w(4)=1.087161903757715_p
x(5)=-3.633630611869758_p
w(5)=1.264287807540440_p
x(6)=-2.263313499403706_p
w(6)=1.295644312052238_p
x(7)=-7.940326133248781e-1_p
w(7)=1.035268703928163_p
x(8)=7.550184174683416e-1_p
w(8)=5.151055903337074e-1_p
x(9)=2.462494215308443_p
w(9)=1.425404097432607e-1_p
x(10)=4.390386462487120_p
w(10)=2.494028673952261e-2_p
x(11)=6.523468363223897_p
w(11)=3.257387752938554e-3_p
x(12)=8.814644060823404_p
w(12)=3.490420249781539e-4_p
x(13)=11.19686132813633_p
w(13)=3.288811796933576e-5_p
x(14)=13.56791117945301_p
w(14)=2.969844134862215e-6_p
x(15)=15.77007717215031_p
w(15)=2.900327788236496e-7_p
x(16)=17.5770444602931_p
w(16)=3.531443572538262e-8_p
x(17)=18.71623294173243_p
w(17)=5.353244126342055e-9_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;19kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348503282909581_p
w(1)=3.813106847001558_p
x(2)=9.542031717972847e-2_p
w(2)=2.189368832533376_p
else if(N==3)then
x(1)=-4.976668500940183_p
w(1)=2.488316701574643_p
x(2)=-1.607641645568114_p
w(2)=3.105736947427007_p
x(3)=2.458344450211525_p
w(3)=4.084220305332835e-1_p
else if(N==4)then
x(1)=-5.282015956786002_p
w(1)=1.781013719375389_p
x(2)=-2.671331139970352_p
w(2)=2.950124578999479_p
x(3)=5.925294324459224e-1_p
w(3)=1.235847691954636_p
x(4)=5.168516220473375_p
w(4)=3.548968920542861e-2_p
else if(N==5)then
x(1)=-5.456753598755993_p
w(1)=1.361026513981612_p
x(2)=-3.377163487716671_p
w(2)=2.552102297179386_p
x(3)=-5.369764518012083e-1_p
w(3)=1.853742138846246_p
x(4)=2.791743778878568_p
w(4)=2.335674662409239e-1_p
x(5)=8.153587623870221_p
w(5)=2.037263286765501e-3_p
else if(N==6)then
x(1)=-5.569394473148267_p
w(1)=1.085077155084233_p
x(2)=-3.870908952975305_p
w(2)=2.172045497224838_p
x(3)=-1.379151334518645_p
w(3)=2.110979105010052_p
x(4)=1.408012969107078_p
w(4)=6.091866179248150e-1_p
x(5)=5.224483863039491_p
w(5)=2.507890944698523e-2_p
x(6)=11.14750031669778_p
w(6)=1.083948440106241e-4_p
else if(N==7)then
x(1)=-5.648947331693478_p
w(1)=8.879242092036400e-1_p
x(2)=-4.237382400895591_p
w(2)=1.848960631861905_p
x(3)=-2.058555615372417_p
w(3)=2.114844387533578_p
x(4)=4.161825274855039e-1_p
w(4)=1.036978839138998_p
x(5)=3.430224832960389_p
w(5)=1.114550708270129e-1_p
x(6)=7.689545610314240_p
w(6)=2.304788500353693e-3_p
x(7)=13.74365278434233_p
w(7)=7.752469446918308e-6_p
else if(N==8)then
x(1)=-5.708372176568648_p
w(1)=7.395252598714107e-1_p
x(2)=-4.520211473019128_p
w(2)=1.580473770642060_p
x(3)=-2.619807370477071_p
w(3)=1.989389961586469_p
x(4)=-3.799944354748726e-1_p
w(4)=1.379906381805923_p
x(5)=2.154572164132617_p
w(5)=2.971912762475112e-1_p
x(6)=5.499497522868062_p
w(6)=1.574592965486578e-2_p
x(7)=9.948686329628957_p
w(7)=2.420990513397748e-4_p
x(8)=15.61458803706992_p
w(8)=1.000675354185636e-6_p
else if(N==9)then
x(1)=-5.754069102277954_p
w(1)=6.248023581289172e-1_p
x(2)=-4.742636329585230_p
w(2)=1.359558272864581_p
x(3)=-3.083695713649876_p
w(3)=1.815504815112615_p
x(4)=-1.052213975910044_p
w(4)=1.572543418515120_p
x(5)=1.179639316828915_p
w(5)=5.674030495444929e-1_p
x(6)=3.928678562032070_p
w(6)=6.037990691082561e-2_p
x(7)=7.474894063244347_p
w(7)=2.250027928352959e-3_p
x(8)=11.86912777938381_p
w(8)=3.359587324055458e-5_p
x(9)=16.79313512291206_p
w(9)=2.346567880145720e-7_p
else if(N==10)then
x(1)=-5.789903143239234_p
w(1)=5.344970752410049e-1_p
x(2)=-4.919863042459562_p
w(2)=1.178223681000276_p
x(3)=-3.466695502037324_p
w(3)=1.634921331688162_p
x(4)=-1.629021562841391_p
w(4)=1.628339631567035_p
x(5)=3.934340010118487e-1_p
w(5)=8.556280580352278e-1_p
x(6)=2.735590787602924_p
w(6)=1.593231049821886e-1_p
x(7)=5.675332472626240_p
w(7)=1.116653941001555e-2_p
x(8)=9.263692048999427_p
w(8)=3.697121754576525e-4_p
x(9)=13.41453863196509_p
w(9)=6.460241068988593e-6_p
x(10)=17.50277484509781_p
w(10)=8.519449758379952e-8_p
else if(N==11)then
x(1)=-5.818483374581922_p
w(1)=4.622685998748849e-1_p
x(2)=-5.062881215224687_p
w(2)=1.028847016933529_p
x(3)=-3.783803915954305_p
w(3)=1.465494945212891_p
x(4)=-2.125152477605789_p
w(4)=1.593990750617979_p
x(5)=-2.678869710935897e-1_p
w(5)=1.091883299713161_p
x(6)=1.793028743868564_p
w(6)=3.204611453143544e-1_p
x(7)=4.292460866179728_p
w(7)=3.728016276839753e-2_p
x(8)=7.318059461216369_p
w(8)=2.174152260970576e-3_p
x(9)=10.82241117626349_p
w(9)=7.386655391203403e-5_p
x(10)=14.61205514434186_p
w(10)=1.699255947003210e-6_p
x(11)=17.9367929652142_p
w(11)=4.102890766764305e-8_p
else if(N==12)then
x(1)=-5.841627529993099_p
w(1)=4.036528200041657e-1_p
x(2)=-5.179724114808518_p
w(2)=9.049836823857722e-1_p
x(3)=-4.047822378975724_p
w(3)=1.313280670859575_p
x(4)=-2.551564601303085_p
w(4)=1.512049523002979_p
x(5)=-8.393996443590024e-1_p
w(5)=1.241675597578954_p
x(6)=1.022273456647235_p
w(6)=5.238338451887430e-1_p
x(7)=3.192791851297660_p
w(7)=9.396452853120935e-2_p
x(8)=5.796378741460787_p
w(8)=8.539876163714735e-3_p
x(9)=8.811594719683058_p
w(9)=4.762788091030924e-4_p
x(10)=12.14245206648028_p
w(10)=1.824876374456255e-5_p
x(11)=15.52068261088118_p
w(11)=5.846067227519963e-7_p
x(12)=18.21304652124035_p
w(12)=2.364024964074588e-8_p
else if(N==13)then
x(1)=-5.860624675828957_p
w(1)=3.554598923176483e-1_p
x(2)=-5.276285389892848_p
w(2)=8.014816181944491e-1_p
x(3)=-4.269145912600046_p
w(3)=1.179146558868311_p
x(4)=-2.918064231207875_p
w(4)=1.410244891791820_p
x(5)=-1.339903314868041_p
w(5)=1.307862573513040_p
x(6)=3.718535999082904e-1_p
w(6)=7.299808990818255e-1_p
x(7)=2.295791497266376_p
w(7)=1.908598318082540e-1_p
x(8)=4.569612875396965_p
w(8)=2.523324789499089e-2_p
x(9)=7.203525690430167_p
w(9)=2.079637109964144e-3_p
x(10)=10.13663312069557_p
w(10)=1.207303200777284e-4_p
x(11)=13.23840926489344_p
w(11)=5.534001294526218e-6_p
x(12)=16.20555714456139_p
w(12)=2.493219019358922e-7_p
x(13)=18.39682302541998_p
w(13)=1.531135601150420e-8_p
else if(N==14)then
x(1)=-5.876405936824804_p
w(1)=3.153725943371455e-1_p
x(2)=-5.356929884471460_p
w(2)=7.143054319886076e-1_p
x(3)=-4.456028026026752_p
w(3)=1.061890865861299_p
x(4)=-3.233575681116506_p
w(4)=1.303983489550837_p
x(5)=-1.780382827194481_p
w(5)=1.311768673121386_p
x(6)=-1.913296148474389e-1_p
w(6)=9.017866954115110e-1_p
x(7)=1.547563561815260_p
w(7)=3.258021553650097e-1_p
x(8)=3.559028354865811_p
w(8)=6.011305397515774e-2_p
x(9)=5.886182343453058_p
w(9)=6.856050981069004e-3_p
x(10)=8.490082494053352_p
w(10)=5.588450815065875e-4_p
x(11)=11.29154852188125_p
w(11)=3.566984929624171e-5_p
x(12)=14.13741219811845_p
w(12)=2.017780866525996e-6_p
x(13)=16.72362704344167_p
w(13)=1.254937785366722e-7_p
x(14)=18.52417377762012_p
w(14)=1.073746295565766e-8_p
else if(N==15)then
x(1)=-5.889656242788747_p
w(1)=2.816789060375220e-1_p
x(2)=-5.424929918423097_p
w(2)=6.403093908158907e-1_p
x(3)=-4.614972323469696_p
w(3)=9.596274061960556e-1_p
x(4)=-3.505985339187174_p
w(4)=1.201000941417588_p
x(5)=-2.168603365721524_p
w(5)=1.276461660399679_p
x(6)=-6.876743193940505e-1_p
w(6)=1.020029375992743_p
x(7)=9.098893074364005e-1_p
w(7)=4.824142852383437e-1_p
x(8)=2.712279482237709_p
w(8)=1.205270763605685e-1_p
x(9)=4.787112398078139_p
w(9)=1.826638181883136e-2_p
x(10)=7.116972137874114_p
w(10)=1.978825045344288e-3_p
x(11)=9.646997711605273_p
w(11)=1.682675508988898e-4_p
x(12)=12.28589849100657_p
w(12)=1.222116583672318e-5_p
x(13)=14.87073210840063_p
w(13)=8.618818913976389e-7_p
x(14)=17.11932065504524_p
w(14)=7.164735936243393e-8_p
x(15)=18.615615612344_p
w(15)=7.966381178990096e-9_p
else if(N==16)then
x(1)=-5.900888032923120_p
w(1)=2.530935242205236e-1_p
x(2)=-5.482770196790665_p
w(2)=5.770359253646958e-1_p
x(3)=-4.751102441707841_p
w(3)=8.703770331534145e-1_p
x(4)=-3.742068563745350_p
w(4)=1.104780618187038_p
x(5)=-2.511024685152224_p
w(5)=1.219635669112762_p
x(6)=-1.129555655848365_p
w(6)=1.084187061458810_p
x(7)=3.554514108824830e-1_p
w(7)=6.366050645704719e-1_p
x(8)=1.992055101312700_p
w(8)=2.092778998817749e-1_p
x(9)=3.856992857032548_p
w(9)=4.110358087974415e-2_p
x(10)=5.955652983488751_p
w(10)=5.696788284343783e-3_p
x(11)=8.248899304246372_p
w(11)=6.202891347143340e-4_p
x(12)=10.67497023097634_p
w(12)=5.695593779941180e-5_p
x(13)=13.1353625480694_p
w(13)=4.798006488995645e-6_p
x(14)=15.46849224302809_p
w(14)=4.201666357520250e-7_p
x(15)=17.4254011480745_p
w(15)=4.501490424707942e-8_p
x(16)=18.6832964926882_p
w(16)=6.160811347734512e-9_p
else if(N==17)then
x(1)=-5.910490660800765_p
w(1)=2.286371594701963e-1_p
x(2)=-5.532360899539499_p
w(2)=5.225546810183486e-1_p
x(3)=-4.868469291510785_p
w(3)=7.923029251428954e-1_p
x(4)=-3.947537998877748_p
w(4)=1.016579525826030_p
x(5)=-2.813394497143908_p
w(5)=1.152877362166919_p
x(6)=-1.524888748599076_p
w(6)=1.104487426092230_p
x(7)=-1.347389685220644e-1_p
w(7)=7.670874616885788e-1_p
x(8)=1.370422875785074_p
w(8)=3.214786558132074e-1_p
x(9)=3.060532514980124_p
w(9)=8.044655096957921e-2_p
x(10)=4.961847556517689_p
w(10)=1.390785291168567e-2_p
x(11)=7.049375562094340_p
w(11)=1.879050395491312e-3_p
x(12)=9.277650833348996_p
w(12)=2.130467852030545e-4_p
x(13)=11.58077972812984_p
w(13)=2.159136859480351e-5_p
x(14)=13.85804399546114_p
w(14)=2.126202532427366e-6_p
x(15)=15.95710205567582_p
w(15)=2.283332247407195e-7_p
x(16)=17.66544414603801_p
w(16)=3.043292497937974e-8_p
x(17)=18.73470173131158_p
w(17)=4.917291816633398e-9_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;19kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535013710067906_p
w(1)=3.320509345666956_p
x(2)=4.997471508226763e-1_p
w(2)=1.686205997219365_p
else if(N==3)then
x(1)=-4.074485535570214_p
w(1)=2.223408350782166_p
x(2)=-1.037864373828903_p
w(2)=2.518908919645788_p
x(3)=2.943143903365203_p
w(3)=2.643980724583680e-1_p
else if(N==4)then
x(1)=-4.342143894091221_p
w(1)=1.616607053331562_p
x(2)=-1.966824485108366_p
w(2)=2.512262358263874_p
x(3)=1.107029762391564_p
w(3)=8.576842053455697e-1_p
x(4)=5.746938766584876_p
w(4)=2.016172594531614e-2_p
else if(N==5)then
x(1)=-4.497787102221528_p
w(1)=1.248243005604788_p
x(2)=-2.587260002777178_p
w(2)=2.244290262550138_p
x(3)=3.985162246224810e-2_p
w(3)=1.376255892161492_p
x(4)=3.369661339956464_p
w(4)=1.368328160817409e-1_p
x(5)=8.778413208134385_p
w(5)=1.093366488162545e-3_p
else if(N==6)then
x(1)=-4.599637713494748_p
w(1)=1.001755908931178_p
x(2)=-3.028285781229288_p
w(2)=1.948102507643751_p
x(3)=-7.325246000183816e-1_p
w(3)=1.664759772506125_p
x(4)=1.984736775087057_p
w(4)=3.784493535299739e-1_p
x(5)=5.844482911191600_p
w(5)=1.358908246354073e-2_p
x(6)=11.75011372642146_p
w(6)=5.871781175363659e-5_p
else if(N==7)then
x(1)=-4.672447349151522_p
w(1)=8.231491303141893e-1_p
x(2)=-3.360446118832864_p
w(2)=1.678972651004068_p
x(3)=-1.349503576191912_p
w(3)=1.750628516657972_p
x(4)=1.005609707436903_p
w(4)=6.907531609747303e-1_p
x(5)=4.039416148040086_p
w(5)=6.195833477927844e-2_p
x(6)=8.294311759859063_p
w(6)=1.248966137829761e-3_p
x(7)=14.2328065128482_p
w(7)=4.583018253622652e-6_p
else if(N==8)then
x(1)=-4.727198944736958_p
w(1)=6.876305687587599e-1_p
x(2)=-3.619067406251193_p
w(2)=1.447199172620313_p
x(3)=-1.858948372106835_p
w(3)=1.706161083232044_p
x(4)=2.400139160996307e-1_p
w(4)=9.849827554781699e-1_p
x(5)=2.756749140525862_p
w(5)=1.720551146344426e-1_p
x(6)=6.106262293703942_p
w(6)=8.548872812610495e-3_p
x(7)=10.49635033855249_p
w(7)=1.371067181340835e-4_p
x(8)=15.95347799714441_p
w(8)=6.686318472817847e-7_p
else if(N==9)then
x(1)=-4.769457630377294_p
w(1)=5.823797438819270e-1_p
x(2)=-3.823544662523557_p
w(2)=1.252458442980293_p
x(3)=-2.281373574068549_p
w(3)=1.596043045833947_p
x(4)=-3.906079048115866e-1_p
w(4)=1.194707061479943_p
x(5)=1.784015574750903_p
w(5)=3.468322815188315e-1_p
x(6)=4.538213442338114_p
w(6)=3.302744750764396e-2_p
x(7)=8.049124307788091_p
w(7)=1.246823161319782e-3_p
x(8)=12.33834815725079_p
w(8)=2.032250826641400e-5_p
x(9)=17.01174655803441_p
w(9)=1.740141495372697e-7_p
else if(N==10)then
x(1)=-4.802690466357092_p
w(1)=4.992361660362099e-1_p
x(2)=-3.987141016184002_p
w(2)=1.090379159562971_p
x(3)=-2.631756462083034_p
w(3)=1.462182655669406_p
x(4)=-9.236965192033245e-1_p
w(4)=1.302836010525973_p
x(5)=1.011756647039675_p
w(5)=5.568947725986368e-1_p
x(6)=3.347611868988160_p
w(6)=8.886344064752365e-2_p
x(7)=6.267504651692231_p
w(7)=6.105365438079352e-3_p
x(8)=9.787622070150524_p
w(8)=2.135038236345369e-4_p
x(9)=13.80062665330011_p
w(9)=4.200676050581426e-6_p
x(10)=17.64400660680757_p
w(10)=6.790783714734209e-8_p
else if(N==11)then
x(1)=-4.829262926760963_p
w(1)=4.325337067379106e-1_p
x(2)=-4.119616175605894_p
w(2)=9.555354888967855e-1_p
x(3)=-2.923223536945013_p
w(3)=1.326615379333865_p
x(4)=-1.379559115207528_p
w(4)=1.327575977408194_p
x(5)=3.749878685236484e-1_p
w(5)=7.578968611925093e-1_p
x(6)=2.408989033522300_p
w(6)=1.850087051473946e-1_p
x(7)=4.897389491750299_p
w(7)=2.028368390631630e-2_p
x(8)=7.875563905036502_p
w(8)=1.219426926747720e-3_p
x(9)=11.28739763169521_p
w(9)=4.489642061817612e-5_p
x(10)=14.92191448034436_p
w(10)=1.182630334685213e-6_p
x(11)=18.0312143485351_p
w(11)=3.428564507902914e-8_p
else if(N==12)then
x(1)=-4.850829025929079_p
w(1)=3.782606969833408e-1_p
x(2)=-4.228162609997064_p
w(2)=8.428930022980703e-1_p
x(3)=-3.166914652020067_p
w(3)=1.199272189754792_p
x(4)=-1.771228216625672_p
w(4)=1.297442578972992_p
x(5)=-1.654139801314502e-1_p
w(5)=9.151850835620051e-1_p
x(6)=1.646548588726354_p
w(6)=3.172465113401208e-1_p
x(7)=3.806883253200479_p
w(7)=5.142864571776438e-2_p
x(8)=6.377558244331981_p
w(8)=4.697094148294386e-3_p
x(9)=9.324754216708376_p
w(9)=2.773819408842915e-4_p
x(10)=12.54689909520951_p
w(10)=1.170651074477009e-5_p
x(11)=15.76677518005203_p
w(11)=4.312773123518941e-7_p
x(12)=18.27888456178862_p
w(12)=2.038000128452233e-8_p
else if(N==13)then
x(1)=-4.868565384096522_p
w(1)=3.335374659877962e-1_p
x(2)=-4.318090920113801_p
w(2)=7.482288382635726e-1_p
x(3)=-3.371933901263761_p
w(3)=1.083808645324114_p
x(4)=-2.108601410449328_p
w(4)=1.236737564354571_p
x(5)=-6.327870947125761e-1_p
w(5)=1.015246010816811_p
x(6)=1.010693195902555_p
w(6)=4.677252952549550e-1_p
x(7)=2.917275376038801_p
w(7)=1.064568179260137e-1_p
x(8)=5.168329419382403_p
w(8)=1.372218023443848e-2_p
x(9)=7.750500570964146_p
w(9)=1.175174654990468e-3_p
x(10)=10.6012151635486_p
w(10)=7.340445980538488e-5_p
x(11)=13.58562750425903_p
w(11)=3.739282454982788e-6_p
x(12)=16.40108976297867_p
w(12)=1.928441540805378e-7_p
x(13)=18.4445938633664_p
w(13)=1.348264482996437e-8_p
else if(N==14)then
x(1)=-4.883324555601901_p
w(1)=2.962632692690809e-1_p
x(2)=-4.393356176895147_p
w(2)=6.681352548056468e-1_p
x(3)=-3.545576744407934_p
w(3)=9.808941903866794e-1_p
x(4)=-2.399921017154161_p
w(4)=1.161922969743764_p
x(5)=-1.041405802238132_p
w(5)=1.062149437994133_p
x(6)=4.680695179707231e-1_p
w(6)=6.128949272711622e-1_p
x(7)=2.176912271315535_p
w(7)=1.877007564512657e-1_p
x(8)=4.170990728435332_p
w(8)=3.261300797817710e-2_p
x(9)=6.458610563336301_p
w(9)=3.790437690044298e-3_p
x(10)=8.997336559094450_p
w(10)=3.268823011651332e-4_p
x(11)=11.70719376444377_p
w(11)=2.266937566928040e-5_p
x(12)=14.43343989023763_p
w(12)=1.429253051196356e-6_p
x(13)=16.88011082894653_p
w(13)=1.007688036032720e-7_p
x(14)=18.56005797258667_p
w(14)=9.597678139915902e-9_p
else if(N==15)then
x(1)=-4.895735497542844_p
w(1)=2.648801803998818e-1_p
x(2)=-4.456937724901993_p
w(2)=5.999013006579854e-1_p
x(3)=-3.693642739201716_p
w(3)=8.898852606035191e-1_p
x(4)=-2.652227769869735_p
w(4)=1.082863974681336_p
x(5)=-1.400731546850680_p
w(5)=1.068251823724661_p
x(6)=-3.646168652593513e-3_p
w(6)=7.334657617377365e-1_p
x(7)=1.549651268954364_p
w(7)=2.903581398305781e-1_p
x(8)=3.334653866935879_p
w(8)=6.592350662013881e-2_p
x(9)=5.379331079059586_p
w(9)=9.950447607017356e-3_p
x(10)=7.656646348268031_p
w(10)=1.123941555213843e-3_p
x(11)=10.11240280201578_p
w(11)=1.021955872775539e-4_p
x(12)=12.65484016331982_p
w(12)=8.107216459179760e-6_p
x(13)=15.12259142849633_p
w(13)=6.362209081215162e-7_p
x(14)=17.24590418874516_p
w(14)=5.924445488740410e-8_p
x(15)=18.64337485322355_p
w(15)=7.199154527850384e-9_p
else if(N==16)then
x(1)=-4.906270005905852_p
w(1)=2.382147213483028e-1_p
x(2)=-4.511107046798011_p
w(2)=5.413778105745739e-1_p
x(3)=-3.820735833060559_p
w(3)=8.096374024134244e-1_p
x(4)=-2.871520978678862_p
w(4)=1.005001249968431_p
x(5)=-1.717758820709417_p
w(5)=1.046855019441407_p
x(6)=-4.192550683201346e-1_p
w(6)=8.198070523357323e-1_p
x(7)=1.009335377172027_p
w(7)=4.032817725654073e-1_p
x(8)=2.623552655504032_p
w(8)=1.167484982351336e-1_p
x(9)=4.464839477071508_p
w(9)=2.222498016784045e-2_p
x(10)=6.520958005001134_p
w(10)=3.163533736220208e-3_p
x(11)=8.752592223468632_p
w(11)=3.636896245755554e-4_p
x(12)=11.09872309578162_p
w(12)=3.593506602764954e-5_p
x(13)=13.46135214401268_p
w(13)=3.312405905074670e-6_p
x(14)=15.68307647185648_p
w(14)=3.213001511968733e-7_p
x(15)=17.52904617272478_p
w(15)=3.808952030585186e-8_p
x(16)=18.70530899899564_p
w(16)=5.613669414896945e-9_p
else if(N==17)then
x(1)=-4.915287394516603_p
w(1)=2.153702168866828e-1_p
x(2)=-4.557616499483752_p
w(2)=4.908579377026476e-1_p
x(3)=-3.930519470951827_p
w(3)=7.388857098996818e-1_p
x(4)=-3.062868894681760_p
w(4)=9.310958982804026e-1_p
x(5)=-1.998140516132438_p
w(5)=1.008808069471955_p
x(6)=-7.886782712350473e-1_p
w(6)=8.714724450319958e-1_p
x(7)=5.369074091895981e-1_p
w(7)=5.128671864618517e-1_p
x(8)=2.011348310362332_p
w(8)=1.850057590532529e-1_p
x(9)=3.680957152946857_p
w(9)=4.353957067474779e-2_p
x(10)=5.547856941221383_p
w(10)=7.596259939555657e-3_p
x(11)=7.583687706228812_p
w(11)=1.071236560679984e-3_p
x(12)=9.744330046894481_p
w(12)=1.291849818550562e-4_p
x(13)=11.96461537616574_p
w(13)=1.413545572005082e-5_p
x(14)=14.14552467885057_p
w(14)=1.521864418774647e-6_p
x(15)=16.14061100855408_p
w(15)=1.798875748159534e-7_p
x(16)=17.75135636337314_p
w(16)=2.622391801700604e-8_p
x(17)=18.75252646804356_p
w(17)=4.509381762501909e-9_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;19kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719497422133438_p
w(1)=2.798300083794759_p
x(2)=9.542745521848743e-1_p
w(2)=1.219849838520255_p
else if(N==3)then
x(1)=-3.173025226223157_p
w(1)=1.934905081456161_p
x(2)=-4.481012213443291e-1_p
w(2)=1.923966881618095_p
x(3)=3.489097550515006_p
w(3)=1.592779592407574e-1_p
else if(N==4)then
x(1)=-3.403449085183262_p
w(1)=1.434586233717932_p
x(2)=-1.259629863777440_p
w(2)=2.024442185794294_p
x(3)=1.673442584029819_p
w(3)=5.482685357325136e-1_p
x(4)=6.375668331594738_p
w(4)=1.085296707027315e-2_p
else if(N==5)then
x(1)=-3.540022254639207_p
w(1)=1.121787269600206_p
x(2)=-1.800677766390585_p
w(2)=1.882065068161143_p
x(3)=6.485480320987750e-1_p
w(3)=9.387071144097791e-1_p
x(4)=4.000231125178944_p
w(4)=7.502600528177653e-2_p
x(5)=9.439743213452948_p
w(5)=5.644648621089533e-4_p
else if(N==6)then
x(1)=-3.630978720630763_p
w(1)=9.075373939075222e-1_p
x(2)=-2.190483593370523_p
w(2)=1.678175344277080_p
x(3)=-7.236652875324406e-2_p
w(3)=1.208387589124855_p
x(4)=2.611122464415415_p
w(4)=2.169509237800401e-1_p
x(5)=6.500449699737863_p
w(5)=7.067446738714324e-3_p
x(6)=12.36595084647918_p
w(6)=3.122448680182754e-5_p
else if(N==7)then
x(1)=-3.696858925090337_p
w(1)=7.496629639726771e-1_p
x(2)=-2.488083836325471_p
w(2)=1.472819620327304_p
x(3)=-6.380847128407561e-1_p
w(3)=1.342241760735563_p
x(4)=1.635604785741156_p
w(4)=4.199956471647264e-1_p
x(5)=4.687194663437591_p
w(5)=3.276652046859549e-2_p
x(6)=8.919051576190032_p
w(6)=6.606961967307297e-4_p
x(7)=14.71157573940991_p
w(7)=2.713449417006830e-6_p
else if(N==8)then
x(1)=-3.746750777802971_p
w(1)=6.287229863218606e-1_p
x(2)=-2.721776666520241_p
w(2)=1.285887576812309_p
x(3)=-1.100930585535282_p
w(3)=1.367530418180766_p
x(4)=8.878673808537011e-1_p
w(4)=6.380429630155376e-1_p
x(5)=3.400189639341448_p
w(5)=9.338533107744540e-2_p
x(6)=6.738017320571838_p
w(6)=4.503496926852792e-3_p
x(7)=11.05164868002237_p
w(7)=7.669929266221275e-5_p
x(8)=16.27504944988159_p
w(8)=4.506875794955665e-7_p
else if(N==9)then
x(1)=-3.785425459374617_p
w(1)=5.342173940786198e-1_p
x(2)=-2.907618070404329_p
w(2)=1.123420019243857_p
x(3)=-1.483791891943735_p
w(3)=1.323552173305075_p
x(4)=2.863888658531037e-1_p
w(4)=8.233567280042360e-1_p
x(5)=2.428677408755394_p
w(5)=1.955295448087133e-1_p
x(6)=5.177280935038270_p
w(6)=1.738371485876061e-2_p
x(7)=8.638170606124401_p
w(7)=6.779770555151146e-4_p
x(8)=12.8068045586475_p
w(8)=1.224096517916815e-5_p
x(9)=17.21659768266917_p
w(9)=1.299950573206235e-7_p
else if(N==10)then
x(1)=-3.815947776268507_p
w(1)=4.591968527630462e-1_p
x(2)=-3.057019900294554_p
w(2)=9.850810630963180e-1_p
x(3)=-1.801903265575337_p
w(3)=1.243739879854278_p
x(4)=-2.123706562281809e-1_p
w(4)=9.499682338726272e-1_p
x(5)=1.664633004116862_p
w(5)=3.296589806277851e-1_p
x(6)=3.992993929811295_p
w(6)=4.712227281104654e-2_p
x(7)=6.879148269852400_p
w(7)=3.257933823803510e-3_p
x(8)=10.3187726193549_p
w(8)=1.219188368467189e-4_p
x(9)=14.18140462140732_p
w(9)=2.732267876679603e-6_p
x(10)=17.77623284700442_p
w(10)=5.436138517788747e-8_p
else if(N==11)then
x(1)=-3.840429072985841_p
w(1)=3.987620857297788e-1_p
x(2)=-3.178501506159381_p
w(2)=8.680930345693241e-1_p
x(3)=-2.067432575090371_p
w(3)=1.149934651939540_p
x(4)=-6.337772322575693e-1_p
w(4)=1.015791347565416_p
x(5)=1.043529543854241_p
w(5)=4.741819719479829e-1_p
x(6)=3.060297741796428_p
w(6)=9.998523848301455e-2_p
x(7)=5.525737849151263_p
w(7)=1.070050648741497e-2_p
x(8)=8.445157317958589_p
w(8)=6.731042480194445e-4_p
x(9)=11.75424914598793_p
w(9)=2.712775994490707e-5_p
x(10)=15.22492323424049_p
w(10)=8.248794463405550e-7_p
x(11)=18.1199732005965_p
w(11)=2.870513144596378e-8_p
else if(N==12)then
x(1)=-3.860352251538501_p
w(1)=3.494156303941396e-1_p
x(2)=-3.278392650813294_p
w(2)=7.691707286191953e-1_p
x(3)=-2.290285297091828_p
w(3)=1.054383717438075_p
x(4)=-9.937595260309781e-1_p
w(4)=1.032455962663835_p
x(5)=5.248631973694092e-1_p
w(5)=6.061003291635770e-1_p
x(6)=2.305117369166012_p
w(6)=1.768839214657221e-1_p
x(7)=4.447971557950772_p
w(7)=2.704045932086140e-2_p
x(8)=6.974534363273494_p
w(8)=2.531460605035700e-3_p
x(9)=9.844584726288987_p
w(9)=1.598849568613342e-4_p
x(10)=12.94984288482784_p
w(10)=7.491166483656566e-6_p
x(11)=16.00620176991436_p
w(11)=3.189456313337628e-7_p
x(12)=18.34111039454793_p
w(12)=1.757559590002441e-8_p
else if(N==13)then
x(1)=-3.876776592969654_p
w(1)=3.086294403215917e-1_p
x(2)=-3.361401244164462_p
w(2)=6.852569874682807e-1_p
x(3)=-2.478458331197766_p
w(3)=9.632162985988514e-1_p
x(4)=-1.303338749328310_p
w(4)=1.015145451904082_p
x(5)=8.276034404428091e-2_p
w(5)=7.097440216557164e-1_p
x(6)=1.679524758685914_p
w(6)=2.718573364455306e-1_p
x(7)=3.568524264330980_p
w(7)=5.632443473431220e-2_p
x(8)=5.786134967407598_p
w(8)=7.274042734325334e-3_p
x(9)=8.307715101908835_p
w(9)=6.548754514198500e-4_p
x(10)=11.0686013738732_p
w(10)=4.434636451406699e-5_p
x(11)=13.92953525246097_p
w(11)=2.525313808285546e-6_p
x(12)=16.59084595597582_p
w(12)=1.494573729258568e-7_p
x(13)=18.4899864304378_p
w(13)=1.186520771452042e-8_p
else if(N==14)then
x(1)=-3.890472694248349_p
w(1)=2.745479710637468e-1_p
x(2)=-3.431056675645948_p
w(2)=6.137345754513408e-1_p
x(3)=-2.638360105847027_p
w(3)=8.790920788784402e-1_p
x(4)=-1.570848917061918_p
w(4)=9.770776715276673e-1_p
x(5)=-2.996066535912940e-1_p
w(5)=7.793929711581188e-1_p
x(6)=1.150941913368462_p
w(6)=3.739145603154276e-1_p
x(7)=2.837176132948466_p
w(7)=1.010017746120800e-1_p
x(8)=4.805137552715017_p
w(8)=1.712426108208359e-2_p
x(9)=7.044255178855862_p
w(9)=2.059224566296161e-3_p
x(10)=9.510743786754336_p
w(10)=1.893771207147361e-4_p
x(11)=12.12303368887668_p
w(11)=1.435413656803755e-5_p
x(12)=14.7254177903554_p
w(12)=1.012812971588507e-6_p
x(13)=17.03184874350187_p
w(13)=8.102089011503175e-8_p
x(14)=18.59432100620341_p
w(14)=8.568667531064737e-9_p
else if(N==15)then
x(1)=-3.902011116688596_p
w(1)=2.457878310096920e-1_p
x(2)=-3.490032897628125_p
w(2)=5.524400359262779e-1_p
x(3)=-2.775107953930021_p
w(3)=8.028323991239618e-1_p
x(4)=-1.802959817669696_p
w(4)=9.278915565571180e-1_p
x(5)=-6.335740553570237e-1_p
w(5)=8.170648161509517e-1_p
x(6)=6.967126419342281e-1_p
w(6)=4.709927251102508e-1_p
x(7)=2.219225570619749_p
w(7)=1.605858291873972e-1_p
x(8)=3.981948469008852_p
w(8)=3.455263963629722e-2_p
x(9)=5.987495229230531_p
w(9)=5.304052645174425e-3_p
x(10)=8.205223454685353_p
w(10)=6.304776208785055e-4_p
x(11)=10.58098782608903_p
w(11)=6.166618304476305e-5_p
x(12)=13.0223434712037_p
w(12)=5.367661968211562e-6_p
x(13)=15.37030324586081_p
w(13)=4.699866110346386e-7_p
x(14)=17.36867734658804_p
w(14)=4.901971450381449e-8_p
x(15)=18.6699921344628_p
w(15)=6.495675248099261e-9_p
else if(N==16)then
x(1)=-3.911821243140819_p
w(1)=2.213022297103346e-1_p
x(2)=-3.540378636561230_p
w(2)=4.996115578497094e-1_p
x(3)=-2.892787723543804_p
w(3)=7.343402021354999e-1_p
x(4)=-2.005157584821823_p
w(4)=8.739422566814342e-1_p
x(5)=-9.272016591054845e-1_p
w(5)=8.287459196220446e-1_p
x(6)=3.009366235864392e-1_p
w(6)=5.536294646514187e-1_p
x(7)=1.689670402682957_p
w(7)=2.313076802891904e-1_p
x(8)=3.281898122176996_p
w(8)=6.161080464815442e-2_p
x(9)=5.091251317184523_p
w(9)=1.169338079389447e-2_p
x(10)=7.097588005586049_p
w(10)=1.729946377787556e-3_p
x(11)=9.261980581733479_p
w(11)=2.113362794570603e-4_p
x(12)=11.52355446662127_p
w(12)=2.257534962225492e-5_p
x(13)=13.78498146203249_p
w(13)=2.284723423017822e-6_p
x(14)=15.89375233434397_p
w(14)=2.458655696063531e-7_p
x(15)=17.62965402007361_p
w(15)=3.223152379473223e-8_p
x(16)=18.72649303596971_p
w(16)=5.105949440427539e-9_p
else if(N==17)then
x(1)=-3.920231034291494_p
w(1)=2.002881116570451e-1_p
x(2)=-3.583681142641814_p
w(2)=4.538219286554884e-1_p
x(3)=-2.994669483327727_p
w(3)=6.730962459636094e-1_p
x(4)=-2.182002666514155_p
w(4)=8.191427494470589e-1_p
x(5)=-1.186575827987506_p
w(5)=8.213503163028283e-1_p
x(6)=-4.763956623323833e-2_p
w(6)=6.167252365571945e-1_p
x(7)=1.230052265817330_p
w(7)=3.070061706719772e-1_p
x(8)=2.679709306695690_p
w(8)=9.920307551795937e-2_p
x(9)=4.322404505684147_p
w(9)=2.275236230922605e-2_p
x(10)=6.147463561606662_p
w(10)=4.071569528603270e-3_p
x(11)=8.125886912982988_p
w(11)=6.038388620369965e-4_p
x(12)=10.21432438220873_p
w(12)=7.783084698958360e-5_p
x(13)=12.34810377899276_p
w(13)=9.228564429640042e-6_p
x(14)=14.43020826757737_p
w(14)=1.088928255376833e-6_p
x(15)=16.32059703849765_p
w(15)=1.417871066293936e-7_p
x(16)=17.83484493593178_p
w(16)=2.258792804842687e-8_p
x(17)=18.7697343647944_p
w(17)=4.127276507328867e-9_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;19kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899027119095821_p
w(1)=2.236587173155091_p
x(2)=1.474545099693169_p
w(2)=8.120001728158548e-1_p
else if(N==3)then
x(1)=-2.271716832478135_p
w(1)=1.607635719936348_p
x(2)=1.762273729477246e-1_p
w(2)=1.352307472118145_p
x(3)=4.103719150150076_p
w(3)=8.864415391645220e-2_p
else if(N==4)then
x(1)=-2.465971132969993_p
w(1)=1.221250432463430_p
x(2)=-5.401174886467407e-1_p
w(2)=1.502976629627007_p
x(3)=2.303340055240179_p
w(3)=3.188440914886876e-1_p
x(4)=7.058689207113395_p
w(4)=5.516192391821093e-3_p
else if(N==5)then
x(1)=-2.583664971775044_p
w(1)=9.701452349607153e-1_p
x(2)=-1.012332093251382_p
w(2)=1.462101049756246_p
x(3)=1.304482058748706_p
w(3)=5.775648797185217e-1_p
x(4)=4.685967251309652_p
w(4)=3.849625384133804e-2_p
x(5)=10.13850713697142_p
w(5)=2.799276941249502e-4_p
else if(N==6)then
x(1)=-2.663636441258348_p
w(1)=7.929096628539299e-1_p
x(2)=-1.355060684765965_p
w(2)=1.348858092818979_p
x(3)=6.168635473959421e-1_p
w(3)=7.884880529782512e-1_p
x(4)=3.291484984381236_p
w(4)=1.147868510773408e-1_p
x(5)=7.192558298225315_p
w(5)=3.528350259596079e-3_p
x(6)=12.99120729727827_p
w(6)=1.633598284828327e-5_p
else if(N==7)then
x(1)=-2.722372392107272_p
w(1)=6.595996211433676e-1_p
x(2)=-1.619221276165195_p
w(2)=1.213962043363196_p
x(3)=8.838416086310230e-2_p
w(3)=9.260014070123319e-1_p
x(4)=2.314905602109457_p
w(4)=2.321593191991274e-1_p
x(5)=5.373499933611639_p
w(5)=1.652207833208030e-2_p
x(6)=9.563030964136885_p
w(6)=3.412643350720795e-4_p
x(7)=15.17631610760399_p
w(7)=1.612585770587752e-6_p
else if(N==8)then
x(1)=-2.767192744778429_p
w(1)=5.562160921947972e-1_p
x(2)=-1.827984856035032_p
w(2)=1.080114271468104_p
x(3)=-3.368657007892184e-1_p
w(3)=9.911136092276351e-1_p
x(4)=1.576271634798909_p
w(4)=3.710575466945488e-1_p
x(5)=4.085416907578189_p
w(5)=4.774002600905462e-2_p
x(6)=7.394453748128866_p
w(6)=2.303089226179868e-3_p
x(7)=11.61341401567712_p
w(7)=4.240461519541828e-5_p
x(8)=16.57843061982681_p
w(8)=3.065354301389590e-7_p
else if(N==9)then
x(1)=-2.802116078518311_p
w(1)=4.747312469655097e-1_p
x(2)=-1.994868885610289_p
w(2)=9.573819670938405e-1_p
x(3)=-6.852968848103517e-1_p
w(3)=9.997775330052254e-1_p
x(4)=9.929782881989591e-1_p
w(4)=5.053220069488911e-1_p
x(5)=3.116469179230794_p
w(5)=1.021817988984579e-1_p
x(6)=5.845277488853075_p
w(6)=8.823528294125752e-3_p
x(7)=9.241534752540591_p
w(7)=3.618216703450777e-4_p
x(8)=13.27338207450917_p
w(8)=7.345330550582357e-6_p
x(9)=17.40801140899196_p
w(9)=9.776399957039617e-8_p
else if(N==10)then
x(1)=-2.829799060945694_p
w(1)=4.095933341595124e-1_p
x(2)=-2.129686449634453_p
w(2)=8.489626864280414e-1_p
x(3)=-9.737618179070849e-1_p
w(3)=9.715579030782281e-1_p
x(4)=5.181004463977398e-1_p
w(4)=6.149782318168107e-1_p
x(5)=2.358624868893626_p
w(5)=1.778523505351238e-1_p
x(6)=4.670978627600639_p
w(6)=2.387439646700133e-2_p
x(7)=7.509789537590513_p
w(7)=1.697765943434213e-3_p
x(8)=10.85651568219058_p
w(8)=6.885581616914020e-5_p
x(9)=14.55614385749692_p
w(9)=1.778056581099549e-6_p
x(10)=17.89990240465171_p
w(10)=4.367004341528545e-8_p
else if(N==11)then
x(1)=-2.852088680897431_p
w(1)=3.568115308974470e-1_p
x(2)=-2.239798496592324_p
w(2)=7.548002266139147e-1_p
x(3)=-1.214526890276774_p
w(3)=9.226231666405997e-1_p
x(4)=1.228566577280622e-1_p
w(4)=6.911867661260380e-1_p
x(5)=1.747876711052079_p
w(5)=2.663251495351104e-1_p
x(6)=3.746964173398681_p
w(6)=5.097403997884975e-2_p
x(7)=6.176741752780469_p
w(7)=5.483843226133557e-3_p
x(8)=9.026401198575416_p
w(8)=3.657250615334568e-4_p
x(9)=12.22237722290427_p
w(9)=1.629728630476597e-5_p
x(10)=15.52075369470703_p
w(10)=5.765431950866904e-7_p
x(11)=18.20340017860479_p
w(11)=2.406181920528916e-8_p
else if(N==12)then
x(1)=-2.870289424104562_p
w(1)=3.135001902846082e-1_p
x(2)=-2.330699277934499_p
w(2)=6.735679164860046e-1_p
x(3)=-1.416938279357302_p
w(3)=8.640852158634230e-1_p
x(4)=-2.112415319161028e-1_p
w(4)=7.343950700776803e-1_p
x(5)=1.243616083471091_p
w(5)=3.562969368326946e-1_p
x(6)=3.000094620733155_p
w(6)=9.159170047959965e-2_p
x(7)=5.114969434460635_p
w(7)=1.371640397938351e-2_p
x(8)=7.586801963237321_p
w(8)=1.337659546496150e-3_p
x(9)=10.37066298576151_p
w(9)=9.121891690826381e-5_p
x(10)=13.35084295225469_p
w(10)=4.781975025694906e-6_p
x(11)=16.2388956030848_p
w(11)=2.363757028346172e-7_p
x(12)=18.39994036419755_p
w(12)=1.515341874794850e-8_p
else if(N==13)then
x(1)=-2.885338125045709_p
w(1)=2.775509835697391e-1_p
x(2)=-2.406499780892787_p
w(2)=6.035846440180972e-1_p
x(3)=-1.588271817605957_p
w(3)=8.027998212692314e-1_p
x(4)=-4.967346555717266e-1_p
w(4)=7.501505779708366e-1_p
x(5)=8.190608661263975e-1_p
w(5)=4.375680034604456e-1_p
x(6)=2.383530134882738_p
w(6)=1.443037733240290e-1_p
x(7)=4.248513715117550_p
w(7)=2.847631338416126e-2_p
x(8)=6.422265772859824_p
w(8)=3.764829045991422e-3_p
x(9)=8.874784415812011_p
w(9)=3.599479727329301e-4_p
x(10)=11.53842253376008_p
w(10)=2.662112338310576e-5_p
x(11)=14.26986170876443_p
w(11)=1.704388542971130e-6_p
x(12)=16.7748864771507_p
w(12)=1.160136241106984e-7_p
x(13)=18.53314038947798_p
w(13)=1.043013087979445e-8_p
else if(N==14)then
x(1)=-2.897919725000745_p
w(1)=2.474021893936741e-1_p
x(2)=-2.470301023176774_p
w(2)=5.431994053304752e-1_p
x(3)=-1.734257097817500_p
w(3)=7.426676611013175e-1_p
x(4)=-7.426373341300175e-1_p
w(4)=7.455256025281507e-1_p
x(5)=4.560552134876187e-1_p
w(5)=5.034813642353143e-1_p
x(6)=1.865517099137465_p
w(6)=2.050724350901346e-1_p
x(7)=3.528213778076934_p
w(7)=5.128744858766545e-2_p
x(8)=5.460369631894225_p
w(8)=8.732784553956693e-3_p
x(9)=7.642630392229830_p
w(9)=1.099938215472050e-3_p
x(10)=10.02998480759907_p
w(10)=1.086713725690349e-4_p
x(11)=12.53878394180267_p
w(11)=9.054876965401639e-6_p
x(12)=15.01321542657285_p
w(12)=7.178493914479908e-7_p
x(13)=17.17894772461959_p
w(13)=6.519850230787285e-8_p
x(14)=18.62705478613253_p
w(14)=7.637356870874799e-9_p
else if(N==15)then
x(1)=-2.908543656907895_p
w(1)=2.218803645942275e-1_p
x(2)=-2.524466070446135_p
w(2)=4.909338107960700e-1_p
x(3)=-1.859437610639688_p
w(3)=6.857233380585591e-1_p
x(4)=-9.557650283959892e-1_p
w(4)=7.270602995134087e-1_p
x(5)=1.419610706402952e-1_p
w(5)=5.513791950915187e-1_p
x(6)=1.423728752771339_p
w(6)=2.684209372155369e-1_p
x(7)=2.920330597160837_p
w(7)=8.256544707035257e-2_p
x(8)=4.652866667992875_p
w(8)=1.746319715172298e-2_p
x(9)=6.610892164698824_p
w(9)=2.770495994773402e-3_p
x(10)=8.762361473545923_p
w(10)=3.493525413913831e-4_p
x(11)=11.05249269677146_p
w(11)=3.696779830262362e-5_p
x(12)=13.38821596907345_p
w(12)=3.546395532902363e-6_p
x(13)=15.61383379413497_p
w(13)=3.473331232604516e-7_p
x(14)=17.4877536062666_p
w(14)=4.056707796958518e-8_p
x(15)=18.69552972116226_p
w(15)=5.849347716497666e-9_p
else if(N==16)then
x(1)=-2.917594845820355_p
w(1)=2.000916442307306e-1_p
x(2)=-2.570814973379200_p
w(2)=4.455184879435765e-1_p
x(3)=-1.967435817933405_p
w(3)=6.328880745792522e-1_p
x(4)=-1.141465626646742_p
w(4)=6.999675098081524e-1_p
x(5)=-1.322902555966019e-1_p
w(5)=5.817362698037742e-1_p
x(6)=1.042096386252876_p
w(6)=3.288932867785223e-1_p
x(7)=2.400703881098242_p
w(7)=1.213669318541962e-1_p
x(8)=3.966027657375356_p
w(8)=3.105171136348939e-2_p
x(9)=5.735212011080737_p
w(9)=6.003751811086410e-3_p
x(10)=7.685091002189450_p
w(10)=9.320525335490247e-4_p
x(11)=9.776804633601705_p
w(11)=1.217109742947279e-4_p
x(12)=11.94926617305896_p
w(12)=1.412007473069653e-5_p
x(13)=14.10613955439207_p
w(13)=1.574113274964734e-6_p
x(14)=16.10054439547148_p
w(14)=1.882039878984636e-7_p
x(15)=17.7273286338128_p
w(15)=2.726430584950724e-8_p
x(16)=18.74689209890167_p
w(16)=4.634022308098809e-9_p
else if(N==17)then
x(1)=-2.925368353123408_p
w(1)=1.813463344262606e-1_p
x(2)=-2.610764441507909_p
w(2)=4.058855605385865e-1_p
x(3)=-2.061154844617635_p
w(3)=5.844467888720547e-1_p
x(4)=-1.304039600760297_p
w(4)=6.680559569938410e-1_p
x(5)=-3.734320899212083e-1_p
w(5)=5.968674104964571e-1_p
x(6)=7.088617169611688e-1_p
w(6)=3.821965008986694e-1_p
x(7)=1.951501660648897_p
w(7)=1.655266273850883e-1_p
x(8)=3.375352059715831_p
w(8)=5.018889027887160e-2_p
x(9)=4.983587667246335_p
w(9)=1.153894217513343e-2_p
x(10)=6.760017864469100_p
w(10)=2.144222632567794e-3_p
x(11)=8.675665410787255_p
w(11)=3.366036792665875e-4_p
x(12)=10.68743438345845_p
w(12)=4.658665097172016e-5_p
x(13)=12.73110707283636_p
w(13)=6.007290324184426e-6_p
x(14)=14.71204738541722_p
w(14)=7.786766283479189e-7_p
x(15)=16.49711557663906_p
w(15)=1.117671407047664e-7_p
x(16)=17.91599946661423_p
w(16)=1.944024965339628e-8_p
x(17)=18.78635670269104_p
w(17)=3.768833969721762e-9_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;19kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066221378960867_p
w(1)=1.641098855735538_p
x(2)=2.078591071736455_p
w(2)=4.858291497046385e-1_p
else if(N==3)then
x(1)=-1.367401740810540_p
w(1)=1.231400311742700_p
x(2)=8.547653527269875e-1_p
w(2)=8.502413546854517e-1_p
x(3)=4.794548007183885_p
w(3)=4.528633901202469e-2_p
else if(N==4)then
x(1)=-1.528185920529946_p
w(1)=9.626206650447684e-1_p
x(2)=2.085439356248363e-1_p
w(2)=9.943077543618354e-1_p
x(3)=3.006688332762052_p
w(3)=1.673637874886009e-1_p
x(4)=7.800746258848244_p
w(4)=2.635798544971359e-3_p
else if(N==5)then
x(1)=-1.627901156178935_p
w(1)=7.794505685908727e-1_p
x(2)=-2.100474150178000e-1_p
w(2)=1.012478362576287_p
x(3)=2.022229604300772_p
w(3)=3.163803078002256e-1_p
x(4)=5.429119176666869_p
w(4)=1.848559367118619e-2_p
x(5)=10.87517004052248_p
w(5)=1.331728016050383e-4_p
else if(N==6)then
x(1)=-1.697123038188384_p
w(1)=6.452922213105409e-1_p
x(2)=-5.137374677590245e-1_p
w(2)=9.701217631861700e-1_p
x(3)=1.352735790047769_p
w(3)=4.535847304467501e-1_p
x(4)=4.028230369704058_p
w(4)=5.623063512950832e-2_p
x(5)=7.921167566372207_p
w(5)=1.690224326718036e-3_p
x(6)=13.62112203451311_p
w(6)=8.431040488681367e-6_p
else if(N==7)then
x(1)=-1.748675248723106_p
w(1)=5.418463017183988e-1_p
x(2)=-7.483420219232553e-1_p
w(2)=9.002879608274261e-1_p
x(3)=8.474691766937082e-1_p
w(3)=5.596695276379950e-1_p
x(4)=3.048919804530954_p
w(4)=1.169964270096806e-1_p
x(5)=6.098470986254850_p
w(5)=7.954713846147345e-3_p
x(6)=10.22557924725422_p
w(6)=1.721106064742642e-4_p
x(7)=15.62358696462898_p
w(7)=9.637940539050766e-7_p
else if(N==8)then
x(1)=-1.788323279627137_p
w(1)=4.603386277516203e-1_p
x(2)=-9.340409654413871e-1_p
w(2)=8.210648974993383e-1_p
x(3)=4.485491733991325e-1_p
w(3)=6.277327490597471e-1_p
x(4)=2.314820368668448_p
w(4)=1.935334222382505e-1_p
x(5)=4.812357273307276_p
w(5)=2.309158500524530e-2_p
x(6)=8.075535859266704_p
w(6)=1.143336079576102e-3_p
x(7)=12.18049314093029_p
w(7)=2.317746247442763e-5_p
x(8)=16.8631248817893_p
w(8)=2.103439241206791e-7_p
else if(N==9)then
x(1)=-1.819398226779534_p
w(1)=3.953237285795497e-1_p
x(2)=-1.082861015970652_p
w(2)=7.423845291731103e-1_p
x(3)=1.263395456620581e-1_p
w(3)=6.607098018034796e-1_p
x(4)=1.742293221044148_p
w(4)=2.741140644108787e-1_p
x(5)=3.848135846296544_p
w(5)=4.987752174724133e-2_p
x(6)=6.541914714829618_p
w(6)=4.324404026604195e-3_p
x(7)=9.858875175033301_p
w(7)=1.894895419303522e-4_p
x(8)=13.73704014707798_p
w(8)=4.392207014177591e-6_p
x(9)=17.58645764707152_p
w(9)=7.395036786372014e-8_p
else if(N==10)then
x(1)=-1.844157527061931_p
w(1)=3.428382156329809e-1_p
x(2)=-1.203489764014581_p
w(2)=6.689673040965928e-1_p
x(3)=-1.380274720100506e-1_p
w(3)=6.664543640297478e-1_p
x(4)=1.282578780560285_p
w(4)=3.479405301966558e-1_p
x(5)=3.096777478413510_p
w(5)=8.822290003715845e-2_p
x(6)=5.380844635450967_p
w(6)=1.160093511245932e-2_p
x(7)=8.159225188207159_p
w(7)=8.641051564766803e-4_p
x(8)=11.40034378088578_p
w(8)=3.845838334929209e-5_p
x(9)=14.92423847005969_p
w(9)=1.157623933296773e-6_p
x(10)=18.01550356691014_p
w(10)=3.517082174053122e-8_p
else if(N==11)then
x(1)=-1.864183664737786_p
w(1)=2.999573298664283e-1_p
x(2)=-1.302369276414623_p
w(2)=6.025908161696532e-1_p
x(3)=-3.575972580731294e-1_p
w(3)=6.534393996801940e-1_p
x(4)=9.050440288451981e-1_p
w(4)=4.080801059132838e-1_p
x(5)=2.494349474239732_p
w(5)=1.352280683019395e-1_p
x(6)=4.468196181267580_p
w(6)=2.469346100393842e-2_p
x(7)=6.849977207312759_p
w(7)=2.733089948870431e-3_p
x(8)=9.619050363475930_p
w(8)=1.955770120346219e-4_p
x(9)=12.69131285925987_p
w(9)=9.733699028258981e-6_p
x(10)=15.809196993203_p
w(10)=4.036678377147532e-7_p
x(11)=18.28183651610043_p
w(11)=2.017696790902773e-8_p
else if(N==12)then
x(1)=-1.880601420507810_p
w(1)=2.645252574808460e-1_p
x(2)=-1.384285530699601_p
w(2)=5.435463231777711e-1_p
x(3)=-5.417903867636791e-1_p
w(3)=6.287403521532964e-1_p
x(4)=5.895883077319615e-1_p
w(4)=4.517959892997737e-1_p
x(5)=2.000375492919376_p
w(5)=1.863211218095380e-1_p
x(6)=3.731463459442662_p
w(6)=4.451886063067608e-2_p
x(7)=5.807061388725292_p
w(7)=6.732234003760744e-3_p
x(8)=8.214122529617109_p
w(8)=6.931307699576886e-4_p
x(9)=10.90272197939984_p
w(9)=5.150310761968570e-5_p
x(10)=13.74957778005819_p
w(10)=3.044489663486796e-6_p
x(11)=16.46488143783011_p
w(11)=1.754647523970493e-7_p
x(12)=18.45559547766717_p
w(12)=1.305252072897369e-8_p
else if(N==13)then
x(1)=-1.894223626673522_p
w(1)=2.349415205954101e-1_p
x(2)=-1.452820211745447_p
w(2)=4.914391692924341e-1_p
x(3)=-6.976357151395737e-1_p
w(3)=5.975613911992655e-1_p
x(4)=3.224704774615976e-1_p
w(4)=4.794899868192034e-1_p
x(5)=1.587906550401159_p
w(5)=2.366879102208572e-1_p
x(6)=3.124485736232017_p
w(6)=7.085419734355007e-2_p
x(7)=4.956108900519269_p
w(7)=1.383739209799847e-2_p
x(8)=7.076290213270335_p
w(8)=1.904198935732516e-3_p
x(9)=9.451525970304491_p
w(9)=1.951147658774334e-4_p
x(10)=12.01044723325874_p
w(10)=1.587564167243303e-5_p
x(11)=14.60644562797804_p
w(11)=1.149233730604624e-6_p
x(12)=16.95333695935002_p
w(12)=9.014181985761482e-8_p
x(13)=18.57419912504771_p
w(13)=9.152624289659075e-9_p
else if(N==14)then
x(1)=-1.905648028946825_p
w(1)=2.100045366980869e-1_p
x(2)=-1.510681694474301_p
w(2)=4.456014867994900e-1_p
x(3)=-8.305050667285676e-1_p
w(3)=5.634429571907188e-1_p
x(4)=9.391454641495897e-2_p
w(4)=4.933308620915778e-1_p
x(5)=1.238335254689332_p
w(5)=2.823747418252305e-1_p
x(6)=2.616098235386308_p
w(6)=1.023843648176675e-1_p
x(7)=4.248948456431910_p
w(7)=2.480823413684888e-2_p
x(8)=6.135929237441667_p
w(8)=4.335059249655418e-3_p
x(9)=8.253506308558265_p
w(9)=5.777526789825954e-4_p
x(10)=10.55490617482451_p
w(10)=6.175303483817202e-5_p
x(11)=12.95428438110383_p
w(11)=5.688969638569089e-6_p
x(12)=15.29679648777001_p
w(12)=5.086757354855260e-7_p
x(13)=17.32156035102766_p
w(13)=5.247949819807773e-8_p
x(14)=18.65835475092794_p
w(14)=6.792207242620732e-9_p
else if(N==15)then
x(1)=-1.915321549846651_p
w(1)=1.888011469465528e-1_p
x(2)=-1.559940853421063_p
w(2)=4.052961200659370e-1_p
x(3)=-9.445753922903878e-1_p
w(3)=5.286594473420909e-1_p
x(4)=-1.032930240078483e-1_p
w(4)=4.961449882122336e-1_p
x(5)=9.384354027836347e-1_p
w(5)=3.208153092976886e-1_p
x(6)=2.184372358601541_p
w(6)=1.370455806749728e-1_p
x(7)=3.652587850125723_p
w(7)=3.998164271551698e-2_p
x(8)=5.346302372577850_p
w(8)=8.548866767238266e-3_p
x(9)=7.249122284271809_p
w(9)=1.419066896912008e-3_p
x(10)=9.327918640518231_p
w(10)=1.911925121125651e-4_p
x(11)=11.5268006444765_p
w(11)=2.201114342932640e-5_p
x(12)=13.75237585859427_p
w(12)=2.337376458518943e-6_p
x(13)=15.85322690421893_p
w(13)=2.566759629511658e-7_p
x(14)=17.6032794508839_p
w(14)=3.355886636600153e-8_p
x(15)=18.72005319577496_p
w(15)=5.254203527283524e-9_p
else if(N==16)then
x(1)=-1.923583478069358_p
w(1)=1.706289835869904e-1_p
x(2)=-1.602198628321022_p
w(2)=3.698117359440359e-1_p
x(3)=-1.043136678336230_p
w(3)=4.945970072177693e-1_p
x(4)=-2.746436377635653e-1_p
w(4)=4.907250011899431e-1_p
x(5)=6.785609021450081e-1_p
w(5)=3.508474314097658e-1_p
x(6)=1.813409725320806_p
w(6)=1.724963500838259e-1_p
x(7)=3.143475470119459_p
w(7)=5.917441440990844e-2_p
x(8)=4.674630929370621_p
w(8)=1.505937016817099e-2_p
x(9)=6.396054154043522_p
w(9)=3.013395448878271e-3_p
x(10)=8.283257519116663_p
w(10)=4.948181188184127e-4_p
x(11)=10.29697068623712_p
w(11)=6.945373002855536e-5_p
x(12)=12.37578636474062_p
w(12)=8.789976698799881e-6_p
x(13)=14.42481212698295_p
w(13)=1.082877648738876e-6_p
x(14)=16.30353998598535_p
w(14)=1.440416920944597e-7_p
x(15)=17.82219875727991_p
w(15)=2.304147155731829e-8_p
x(16)=18.76655270686622_p
w(16)=4.194529757194621e-9_p
else if(N==17)then
x(1)=-1.930694996861059_p
w(1)=1.549415662810734e-1_p
x(2)=-1.638705839804758_p
w(2)=3.385024807747000e-1_p
x(3)=-1.128807037270365_p
w(3)=4.620484956119993e-1_p
x(4)=-4.244244248415102e-1_p
w(4)=4.794928991959655e-1_p
x(5)=4.515037230890684e-1_p
w(5)=3.724276207608947e-1_p
x(6)=1.491419806468059_p
w(6)=2.065525211584021e-1_p
x(7)=2.704264451541202_p
w(7)=8.170909940907627e-2_p
x(8)=4.097098296508088_p
w(8)=2.422635160638069e-2_p
x(9)=5.663524726424796_p
w(9)=5.699035388244043e-3_p
x(10)=7.385161817768270_p
w(10)=1.110143576809062e-3_p
x(11)=9.232909150922735_p
w(11)=1.855339018093498e-4_p
x(12)=11.16360374990217_p
w(12)=2.769580607713586e-5_p
x(13)=13.11359901816436_p
w(13)=3.897519130011035e-6_p
x(14)=14.99107773626045_p
w(14)=5.562411271226857e-7_p
x(15)=16.67027268135421_p
w(15)=8.806741901223886e-8_p
x(16)=17.99492888516687_p
w(16)=1.670903764379098e-8_p
x(17)=18.80242746033931_p
w(17)=3.432030723889580e-9_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;19kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078098494184512e-1_p
w(1)=1.057153013431959_p
x(2)=2.782846373863315_p
w(2)=2.561086684834678e-1_p
else if(N==3)then
x(1)=-4.523405263043018e-1_p
w(1)=8.262782615511450e-1_p
x(2)=1.607963876704931_p
w(2)=4.658378362013601e-1_p
x(3)=5.567734646306901_p
w(3)=2.114558416292134e-2_p
else if(N==4)then
x(1)=-5.852502326486796e-1_p
w(1)=6.651604633921389e-1_p
x(2)=1.007524602362042_p
w(2)=5.677111930707655e-1_p
x(3)=3.789593352799553_p
w(3)=7.921046465597882e-2_p
x(4)=8.605866235770691_p
w(4)=1.179560796543370e-3_p
else if(N==5)then
x(1)=-6.694747962984441e-1_p
w(1)=5.497077389024635e-1_p
x(2)=6.248706599975727e-1_p
w(2)=6.012119672832252e-1_p
x(3)=2.811307143097546_p
w(3)=1.539669174868608e-1_p
x(4)=6.230684667562443_p
w(4)=8.314254043635800e-3_p
x(5)=11.64785469977622_p
w(5)=6.080419924115091e-5_p
else if(N==6)then
x(1)=-7.291206403129249e-1_p
w(1)=4.616875417368872e-1_p
x(2)=3.487404196072111e-1_p
w(2)=5.965993874310825e-1_p
x(3)=2.149016741667370_p
w(3)=2.285559832226180e-1_p
x(4)=4.821482076708151_p
w(4)=2.563732237592372e-2_p
x(5)=8.685630535902863_p
w(5)=7.771366757023718e-4_p
x(6)=14.2488975488187_p
w(6)=4.310473212606206e-6_p
else if(N==7)then
x(1)=-7.740671832350721e-1_p
w(1)=3.919746530797774e-1_p
x(2)=1.365109602609373e-1_p
w(2)=5.708018582704103e-1_p
x(3)=1.655741466884448_p
w(3)=2.925298318204208e-1_p
x(4)=3.838964992077456_p
w(4)=5.420769155830452e-2_p
x(5)=6.861584964580756_p
w(5)=3.662253622597467e-3_p
x(6)=10.90506655249886_p
w(6)=8.481300289584707e-5_p
x(7)=16.04967303210994_p
w(7)=5.805610201717104e-7_p
else if(N==8)then
x(1)=-8.088698762534617e-1_p
w(1)=3.360324149715989e-1_p
x(2)=-3.072578681559593e-2_p
w(2)=5.343905239825941e-1_p
x(3)=1.272591231860256_p
w(3)=3.402737922190948e-1_p
x(4)=3.107580172333881_p
w(4)=9.138708027389067e-2_p
x(5)=5.580001995842522_p
w(5)=1.061400886549500e-2_p
x(6)=8.780589064039262_p
w(6)=5.511802093585235e-4_p
x(7)=12.75097087691825_p
w(7)=1.253579646466718e-5_p
x(8)=17.12864367077344_p
w(8)=1.455969297500123e-7_p
else if(N==9)then
x(1)=-8.362988908597747e-1_p
w(1)=2.907571920625109e-1_p
x(2)=-1.644856843324857e-1_p
w(2)=4.940565272391704e-1_p
x(3)=9.674909192101183e-1_p
w(3)=3.709369736086582e-1_p
x(4)=2.541895842648649_p
w(4)=1.324318221847866e-1_p
x(5)=4.622513909027967_p
w(5)=2.293014573096899e-2_p
x(6)=7.266450505758062_p
w(6)=2.048929971740992e-3_p
x(7)=10.48924321812085_p
w(7)=9.741605486058387e-5_p
x(8)=14.19625777549406_p
w(8)=2.618850994434902e-6_p
x(9)=17.7523229623757_p
w(9)=5.621173519948308e-8_p
else if(N==10)then
x(1)=-8.582638575134942e-1_p
w(1)=2.537600918087073e-1_p
x(2)=-2.729048126287135e-1_p
w(2)=4.536543560051742e-1_p
x(3)=7.198981162147934e-1_p
w(3)=3.866498629921906e-1_p
x(4)=2.091802589052475_p
w(4)=1.725885662811203e-1_p
x(5)=3.878701906290939_p
w(5)=4.073342564857702e-2_p
x(6)=6.121426250650350_p
w(6)=5.423639680276013e-3_p
x(7)=8.826795103849870_p
w(7)=4.297066755432974e-4_p
x(8)=11.94925788745834_p
w(8)=2.125029945017945e-5_p
x(9)=15.2848038518971_p
w(9)=7.541525741577218e-7_p
x(10)=18.12343017210739_p
w(10)=2.837181324934713e-8_p
else if(N==11)then
x(1)=-8.761107512618048e-1_p
w(1)=2.232214356889090e-1_p
x(2)=-3.618717287453219e-1_p
w(2)=4.151972376317543e-1_p
x(3)=5.158986140470637e-1_p
w(3)=3.906451989053618e-1_p
x(4)=1.725658076035600_p
w(4)=2.083115440721802e-1_p
x(5)=3.284380544754182_p
w(5)=6.301309586373099e-2_p
x(6)=5.222409879016726_p
w(6)=1.143812130612185e-2_p
x(7)=7.544693029747971_p
w(7)=1.326011536448489e-3_p
x(8)=10.22243625287398_p
w(8)=1.029561822037711e-4_p
x(9)=13.16022263313876_p
w(9)=5.780763780825573e-6_p
x(10)=16.08986769691895_p
w(10)=2.830532720410103e-7_p
x(11)=18.35555222158177_p
w(11)=1.691166323446465e-8_p
else if(N==12)then
x(1)=-8.908013715388327e-1_p
w(1)=1.977665630138904e-1_p
x(2)=-4.356969536624979e-1_p
w(2)=3.796074791686880e-1_p
x(3)=3.457129453261190e-1_p
w(3)=3.861467659607662e-1_p
x(4)=1.422516999197950_p
w(4)=2.375894485811248e-1_p
x(5)=2.799102950089052_p
w(5)=8.804303586628925e-2_p
x(6)=4.497571556974742_p
w(6)=2.052053523065650e-2_p
x(7)=6.523178192568038_p
w(7)=3.204692733472952e-3_p
x(8)=8.855917706693406_p
w(8)=3.523063009990877e-4_p
x(9)=11.44013777052249_p
w(9)=2.878027381995099e-5_p
x(10)=14.14546287457252_p
w(10)=1.933160162729269e-6_p
x(11)=16.68405717761653_p
w(11)=1.304015220159750e-7_p
x(12)=18.50824800363965_p
w(12)=1.122403456908226e-8_p
else if(N==13)then
x(1)=-9.030347171594955e-1_p
w(1)=1.763537448405873e-1_p
x(2)=-4.975802317386687e-1_p
w(2)=3.471945813765778e-1_p
x(3)=2.022430464350616e-1_p
w(3)=3.758877353599823e-1_p
x(4)=1.167955519405708_p
w(4)=2.597427960920380e-1_p
x(5)=2.395923353703151_p
w(5)=1.138859142795147e-1_p
x(6)=3.901286342340067_p
w(6)=3.264837105822795e-2_p
x(7)=5.689839725552693_p
w(7)=6.492015576966680e-3_p
x(8)=7.747527599143009_p
w(8)=9.419497288855889e-4_p
x(9)=10.0374384884383_p
w(9)=1.043162593928843e-4_p
x(10)=12.48415726543563_p
w(10)=9.405242091667506e-6_p
x(11)=14.93893300419769_p
w(11)=7.740186631287337e-7_p
x(12)=17.12622553942534_p
w(12)=7.007008411769159e-8_p
x(13)=18.61327297166809_p
w(13)=8.012414339159437e-9_p
else if(N==14)then
x(1)=-9.133276288444073e-1_p
w(1)=1.581872500505201e-1_p
x(2)=-5.499309989352502e-1_p
w(2)=3.179404018083151e-1_p
x(3)=8.019802835877278e-2_p
w(3)=3.619894939432177e-1_p
x(4)=9.516942503912580e-1_p
w(4)=2.750207183697930e-1_p
x(5)=2.056138915024334_p
w(5)=1.387935728927804e-1_p
x(6)=3.402821529686572_p
w(6)=4.737567692980090e-2_p
x(7)=4.997601442073176_p
w(7)=1.151888547377255e-2_p
x(8)=6.830888146542877_p
w(8)=2.098469654633046e-3_p
x(9)=8.876388544356056_p
w(9)=2.984952457967694e-4_p
x(10)=11.08507629952267_p
w(10)=3.474962430883595e-5_p
x(11)=13.36914819231833_p
w(11)=3.559415080656214e-6_p
x(12)=15.57597855420603_p
w(12)=3.602552874720303e-7_p
x(13)=17.45976273150637_p
w(13)=4.222844739867329e-8_p
x(14)=18.68829349694479_p
w(14)=6.023672519464302e-9_p
else if(N==15)then
x(1)=-9.220684915916914e-1_p
w(1)=1.426534210067890e-1_p
x(2)=-5.945882198743114e-1_p
w(2)=2.916635355569951e-1_p
x(3)=-2.445115351463317e-2_p
w(3)=3.460082607246663e-1_p
x(4)=7.661866052079714e-1_p
w(4)=2.842021598000617e-1_p
x(5)=1.766347494763251_p
w(5)=1.614342543366468e-1_p
x(6)=2.980573815584004_p
w(6)=6.395560988774081e-2_p
x(7)=4.414189395183354_p
w(7)=1.844601501457465e-2_p
x(8)=6.060994401163251_p
w(8)=4.067079493235612e-3_p
x(9)=7.901588162043969_p
w(9)=7.132228525707733e-4_p
x(10)=9.901500872835904_p
w(10)=1.033493225260443e-4_p
x(11)=12.00356043555542_p
w(11)=1.301545465744936e-5_p
x(12)=14.11456169821776_p
w(12)=1.536431232184796e-6_p
x(13)=16.08841206379092_p
w(13)=1.895935823459097e-7_p
x(14)=17.7153411295713_p
w(14)=2.773486976551175e-8_p
x(15)=18.7436119273383_p
w(15)=4.705277727976862e-9_p
else if(N==16)then
x(1)=-9.295535192067050e-1_p
w(1)=1.292742911589418e-1_p
x(2)=-6.329730723684238e-1_p
w(2)=2.681115985618848e-1_p
x(3)=-1.148259722135818e-1_p
w(3)=3.290398455811329e-1_p
x(4)=6.057489196969783e-1_p
w(4)=2.882899019536222e-1_p
x(5)=1.516690924681293_p
w(5)=1.809606178395285e-1_p
x(6)=2.618860663639480_p
w(6)=8.149836009634433e-2_p
x(7)=3.916574004302275_p
w(7)=2.723433013800338e-2_p
x(8)=5.406113115362635_p
w(8)=7.067671879094053e-3_p
x(9)=7.072981859227382_p
w(9)=1.480572349549227e-3_p
x(10)=8.891664744421965_p
w(10)=2.589022413279116e-4_p
x(11)=10.8221586910848_p
w(11)=3.926800060788922e-5_p
x(12)=12.80284814468179_p
w(12)=5.445126563319528e-6_p
x(13)=14.74084076518043_p
w(13)=7.435864287343060e-7_p
x(14)=16.5027348666966_p
w(14)=1.101734725434415e-7_p
x(15)=17.91434556132516_p
w(15)=1.944424985951861e-8_p
x(16)=18.78550955586402_p
w(16)=3.784674901500934e-9_p
else if(N==17)then
x(1)=-9.360117002182947e-1_p
w(1)=1.176739164759088e-1_p
x(2)=-6.661965744232586e-1_p
w(2)=2.470115403149505e-1_p
x(3)=-1.933792839309045e-1_p
w(3)=3.118297593454030e-1_p
x(4)=4.660063914838524e-1_p
w(4)=2.883120666480647e-1_p
x(5)=1.299753654746841_p
w(5)=1.969693971474639e-1_p
x(6)=2.306007094305905_p
w(6)=9.911703364453633e-2_p
x(7)=3.487805081491416_p
w(7)=3.765851440437276e-2_p
x(8)=4.843126401397447_p
w(8)=1.125559825338356e-2_p
x(9)=6.361151132912938_p
w(9)=2.748033704026851e-3_p
x(10)=8.022374991210304_p
w(10)=5.653483874073346e-4_p
x(11)=9.797297186385917_p
w(11)=1.011193504513242e-4_p
x(12)=11.64257897339024_p
w(12)=1.635093390017397e-5_p
x(13)=13.49539133729548_p
w(13)=2.519735128083921e-6_p
x(14)=15.26721768716696_p
w(14)=3.967884109651982e-7_p
x(15)=16.84009997217367_p
w(15)=6.933181579825713e-8_p
x(16)=18.07170436638454_p
w(16)=1.433501737023878e-8_p
x(17)=18.81797177741195_p
w(17)=3.115184866974605e-9_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;19kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905331739306666e-1_p
w(1)=5.746607594270893e-1_p
x(2)=3.592349395695955_p
w(2)=1.184864155300597e-1_p
else if(N==3)then
x(1)=4.839504453798400e-1_p
w(1)=4.632934209675443e-1_p
x(2)=2.446209610749050_p
w(2)=2.208037972057484e-1_p
x(3)=6.422516098473507_p
w(3)=9.049956783856214e-3_p
else if(N==4)then
x(1)=3.704701976393611e-1_p
w(1)=3.819025721909884e-1_p
x(2)=1.871343037765604_p
w(2)=2.766361546538804e-1_p
x(3)=4.649534392604974_p
w(3)=3.411303022860532e-2_p
x(4)=9.471904092642738_p
w(4)=4.954178836747553e-4_p
else if(N==5)then
x(1)=2.973138793503305e-1_p
w(1)=3.210183995286234e-1_p
x(2)=1.508187887709417_p
w(2)=3.011362119536685e-1_p
x(3)=3.670604324510461_p
w(3)=6.744272889246941e-2_p
x(4)=7.086043610836327_p
w(4)=3.523002755195559e-3_p
x(5)=12.44733524814493_p
w(5)=2.683182719206772e-5_p
else if(N==6)then
x(1)=2.447225161876167e-1_p
w(1)=2.729610065620222e-1_p
x(2)=1.247519961038608_p
w(2)=3.065773802732260e-1_p
x(3)=3.008202914993009_p
w(3)=1.022786753905806e-1_p
x(4)=5.665964608116967_p
w(4)=1.098329307648023e-2_p
x(5)=9.480440895175423_p
w(5)=3.446175831108863e-4_p
x(6)=14.86309252156657_p
w(6)=2.202071728948420e-6_p
else if(N==7)then
x(1)=2.048168248334665e-1_p
w(1)=2.340376612987102e-1_p
x(2)=1.048917685799166_p
w(2)=3.002096045295576e-1_p
x(3)=2.519475338876966_p
w(3)=1.338234040547150e-1_p
x(4)=4.680011793727775_p
w(4)=2.341475405005439e-2_p
x(5)=7.658286200050024_p
w(5)=1.620372392327419e-3_p
x(6)=11.59589502019228_p
w(6)=4.102467973808161e-5_p
x(7)=16.44928818371998_p
w(7)=3.539520462148545e-7_p
else if(N==8)then
x(1)=1.738051826373538e-1_p
w(1)=2.023030353668862e-1_p
x(2)=8.936991540011056e-1_p
w(2)=2.869650268664927e-1_p
x(3)=2.144430688942713_p
w(3)=1.591578045519100e-1_p
x(4)=3.950710566271044_p
w(4)=3.978690205969335e-2_p
x(5)=6.383625953130782_p
w(5)=4.668567504803891e-3_p
x(6)=9.505416153548842_p
w(6)=2.590014172394745e-4_p
x(7)=13.31998906845795_p
w(7)=6.735419896903783e-6_p
x(8)=17.3736977383336_p
w(8)=1.017702263762232e-7_p
else if(N==9)then
x(1)=1.492817431116379e-1_p
w(1)=1.762789255007720e-1_p
x(2)=7.702334509887308e-1_p
w(2)=2.702384891584775e-1_p
x(3)=1.849062007901433_p
w(3)=1.773871307131908e-1_p
x(4)=3.390096090747942_p
w(4)=5.821838052503269e-2_p
x(5)=5.434547531642766_p
w(5)=1.003096751652419e-2_p
x(6)=8.014983979556979_p
w(6)=9.423553361307993e-4_p
x(7)=11.1287683078767_p
w(7)=4.932189292487836e-5_p
x(8)=14.6474990991232_p
w(8)=1.561374606185345e-6_p
x(9)=17.90542966246888_p
w(9)=4.293948978057138e-8_p
else if(N==10)then
x(1)=1.295781976553215e-1_p
w(1)=1.547718188373707e-1_p
x(2)=6.704905948084662e-1_p
w(2)=2.521908824248354e-1_p
x(3)=1.611597462817635_p
w(3)=1.889555332835944e-1_p
x(4)=2.946756300491920_p
w(4)=7.679251454415223e-2_p
x(5)=4.699348369539152_p
w(5)=1.776227760227237e-2_p
x(6)=6.888673146253121_p
w(6)=2.452559580979846e-3_p
x(7)=9.509081656777916_p
w(7)=2.094258807633835e-4_p
x(8)=12.49995113989683_p
w(8)=1.164743540734069e-5_p
x(9)=15.63558718331812_p
w(9)=4.924485770852837e-7_p
x(10)=18.22368928700278_p
w(10)=2.291919616525669e-8_p
else if(N==11)then
x(1)=1.135185062112289e-1_p
w(1)=1.368466835749561e-1_p
x(2)=5.887974066051064e-1_p
w(2)=2.341104159253021e-1_p
x(3)=1.417445158999612_p
w(3)=1.949189438970499e-1_p
x(4)=2.588338919444817_p
w(4)=9.401142169449433e-2_p
x(5)=4.113523443430173_p
w(5)=2.747030857497822e-2_p
x(6)=6.005230200083021_p
w(6)=5.103895281623965e-3_p
x(7)=8.257575300564781_p
w(7)=6.283838017160946e-4_p
x(8)=10.83356260012493_p
w(8)=5.348825760660848e-5_p
x(9)=13.62649532596119_p
w(9)=3.420826586185444e-6_p
x(10)=16.36141794682866_p
w(10)=1.989585513266267e-7_p
x(11)=18.42455722973056_p
w(11)=1.416428412892464e-8_p
else if(N==12)then
x(1)=1.002607572230322e-1_p
w(1)=1.217808058335318e-1_p
x(2)=5.210713254118001e-1_p
w(2)=2.167184101520191e-1_p
x(3)=1.256476011510917_p
w(3)=1.964848782213873e-1_p
x(4)=2.293421080453301_p
w(4)=1.089288347157258e-1_p
x(5)=3.636588907108521_p
w(5)=3.848959733124228e-2_p
x(6)=5.293761417332346_p
w(6)=9.065571630472453e-3_p
x(7)=7.259880620632909_p
w(7)=1.485690070992833e-3_p
x(8)=9.509351135966039_p
w(8)=1.761040270496851e-4_p
x(9)=11.98036730158791_p
w(9)=1.595023898259691e-5_p
x(10)=14.53655001585746_p
w(10)=1.226036880043939e-6_p
x(11)=16.89561848706769_p
w(11)=9.706628689016904e-8_p
x(12)=18.55789260430931_p
w(12)=9.632578126245564e-9_p
else if(N==13)then
x(1)=8.919135688480458e-2_p
w(1)=1.090157505584774e-1_p
x(2)=4.643177729832831e-1_p
w(2)=2.003839306264530e-1_p
x(3)=1.121437549207718_p
w(3)=1.947777195778073e-1_p
x(4)=2.047226449426275_p
w(4)=1.210977224558005e-1_p
x(5)=3.241617375992109_p
w(5)=5.007110164721961e-2_p
x(6)=4.709225881143415_p
w(6)=1.432546210189651e-2_p
x(7)=6.446005805024344_p
w(7)=2.957244543077879e-3_p
x(8)=8.433151495417746_p
w(8)=4.569946687969471e-4_p
x(9)=10.63007652818565_p
w(9)=5.512171976175311e-5_p
x(10)=12.9574699595366_p
w(10)=5.544339964823433e-6_p
x(11)=15.26591502247315_p
w(11)=5.212230612266947e-7_p
x(12)=17.29305456024271_p
w(12)=5.449949216901551e-8_p
x(13)=18.6503474503946_p
w(13)=6.995339804313948e-9_p
else if(N==14)then
x(1)=7.985521427200439e-2_p
w(1)=9.811783300633861e-2_p
x(2)=4.163008391085051e-1_p
w(2)=1.852639681902399e-1_p
x(3)=1.006998794554465_p
w(3)=1.907447417811139e-1_p
x(4)=1.839216990497347_p
w(4)=1.304441617073320e-1_p
x(5)=2.909911230545103_p
w(5)=6.152497634885699e-2_p
x(6)=4.221298762674268_p
w(6)=2.070964540779361e-2_p
x(7)=5.770171982366957_p
w(7)=5.174019852929939e-3_p
x(8)=7.542305203395682_p
w(8)=9.939011764316193e-4_p
x(9)=9.508872033929105_p
w(9)=1.520161049706003e-4_p
x(10)=11.61841289789436_p
w(10)=1.939641261968467e-5_p
x(11)=13.78171613139257_p
w(11)=2.220516039258249e-6_p
x(12)=15.84975267238528_p
w(12)=2.551583922478092e-7_p
x(13)=17.59322988157192_p
w(13)=3.396860864513888e-8_p
x(14)=18.71685320847784_p
w(14)=5.325481924768177e-9_p
else if(N==15)then
x(1)=7.190929583886871e-2_p
w(1)=8.874782355166662e-2_p
x(2)=3.753242577805214e-1_p
w(2)=1.713918319179331e-1_p
x(3)=9.091542521236080e-1_p
w(3)=1.851380195095902e-1_p
x(4)=1.661665828167194_p
w(4)=1.371345138852597e-1_p
x(5)=2.628047684850604_p
w(5)=7.230055085035371e-2_p
x(6)=3.808672855830422_p
w(6)=2.793343225499190e-2_p
x(7)=5.200899376669986_p
w(7)=8.195709950391854e-3_p
x(8)=6.793794356956193_p
w(8)=1.888608225468999e-3_p
x(9)=8.565851288683342_p
w(9)=3.525810045701874e-4_p
x(10)=10.48104095290955_p
w(10)=5.527502233507487e-5_p
x(11)=12.48102819907138_p
w(11)=7.653491699034637e-6_p
x(12)=14.47347368652703_p
w(12)=1.008167089880467e-6_p
x(13)=16.31866242410595_p
w(13)=1.400290091947120e-7_p
x(14)=17.8237140995017_p
w(14)=2.289720446936090e-8_p
x(15)=18.76618793954676_p
w(15)=4.199585046117918e-9_p
else if(N==16)then
x(1)=6.509120108843351e-2_p
w(1)=8.063824396435722e-2_p
x(2)=3.400826891482172e-1_p
w(2)=1.587316868324821e-1_p
x(3)=8.248383763439704e-1_p
w(3)=1.785314930537908e-1_p
x(4)=1.508773354908028_p
w(4)=1.414661593370516e-1_p
x(5)=2.386128796253338_p
w(5)=8.201318070701637e-2_p
x(6)=3.455879059467300_p
w(6)=3.566009021991127e-2_p
x(7)=4.715693244809043_p
w(7)=1.200360959265442e-2_p
x(8)=6.157067920456448_p
w(8)=3.228843404451817e-3_p
x(9)=7.763451058849680_p
w(9)=7.141098090793675e-4_p
x(10)=9.508234107440156_p
w(10)=1.337558659085907e-4_p
x(11)=11.35059719213577_p
w(11)=2.202801852044366e-5_p
x(12)=13.22901122446325_p
w(12)=3.360138009714064e-6_p
x(13)=15.05321442229359_p
w(13)=5.099976902162363e-7_p
x(14)=16.69759722018542_p
w(14)=8.423136432901630e-8_p
x(15)=18.00360589451828_p
w(15)=1.638189572298315e-8_p
x(16)=18.80374593289755_p
w(16)=3.402964883889926e-9_p
else if(N==17)then
x(1)=5.919750970799958e-2_p
w(1)=7.357645009714250e-2_p
x(2)=3.095586710672094e-1_p
w(2)=1.472116389396766e-1_p
x(3)=7.516679645845592e-1_p
w(3)=1.713505691661745e-1_p
x(4)=1.376099080310753_p
w(4)=1.437895107830286e-1_p
x(5)=2.176691311659191_p
w(5)=9.043595876876000e-2_p
x(6)=3.151391338465662_p
w(6)=4.355171820697055e-2_p
x(7)=4.297986582534194_p
w(7)=1.650943221011936e-2_p
x(8)=5.609774214097552_p
w(8)=5.073722107302746e-3_p
x(9)=7.073755305154719_p
w(9)=1.298252202927414e-3_p
x(10)=8.669526854818383_p
w(10)=2.837724447374902e-4_p
x(11)=10.36703830026209_p
w(11)=5.457584287997865e-5_p
x(12)=12.12285270586889_p
w(12)=9.597252158330723e-6_p
x(13)=13.87530526170302_p
w(13)=1.624539499008285e-6_p
x(14)=15.53968032091651_p
w(14)=2.827682736966062e-7_p
x(15)=17.00620030047868_p
w(15)=5.453691062668148e-8_p
x(16)=18.14620237460127_p
w(16)=1.227305895473735e-8_p
x(17)=18.83297470660069_p
w(17)=2.817528584880869e-9_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;19kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631813848627812_p
w(1)=2.640303401037254e-1_p
x(2)=4.490253531420829_p
w(2)=4.923134181170098e-2_p
else if(N==3)then
x(1)=1.445954392622900_p
w(1)=2.167663228795516e-1_p
x(2)=3.358539563698049_p
w(2)=9.288406404150160e-2_p
x(3)=7.343778684992558_p
w(3)=3.611294994373277e-3_p
else if(N==4)then
x(1)=1.343209463754137_p
w(1)=1.812325353935905e-1_p
x(2)=2.794971808667003_p
w(2)=1.181536252653354e-1_p
x(3)=5.569953626513050_p
w(3)=1.367726722663282e-2_p
x(4)=10.38324057323769_p
w(4)=1.982540298676728e-4_p
else if(N==5)then
x(1)=1.276100166880076_p
w(1)=1.538275506507240e-1_p
x(2)=2.439113136001021_p
w(2)=1.306355998006909e-1_p
x(3)=4.584281941660849_p
w(3)=2.735730490697764e-2_p
x(4)=7.979393451554877_p
w(4)=1.429564291060029e-3_p
x(5)=13.25184200790301_p
w(5)=1.166226597374547e-5_p
else if(N==6)then
x(1)=1.227434814495587_p
w(1)=1.316963291189970e-1_p
x(2)=2.184503649460865_p
w(2)=1.349151726690595e-1_p
x(3)=3.917174131205889_p
w(3)=4.199875451373839e-2_p
x(4)=6.546816739327697_p
w(4)=4.500821373763127e-3_p
x(5)=10.29089872168048_p
w(5)=1.494626835641673e-4_p
x(6)=15.446217381555_p
w(6)=1.141556304285119e-6_p
else if(N==7)then
x(1)=1.190467427734751_p
w(1)=1.135458203364087e-1_p
x(2)=1.992234330529479_p
w(2)=1.338256584150125e-1_p
x(3)=3.428833158680870_p
w(3)=5.554401905831735e-2_p
x(4)=5.557807553870174_p
w(4)=9.628375593611575e-3_p
x(5)=8.476004838886775_p
w(5)=6.978786792177091e-4_p
x(6)=12.28546878621478_p
w(6)=1.970975301073939e-5_p
x(7)=16.81509293488769_p
w(7)=2.200798477894579e-7_p
else if(N==8)then
x(1)=1.161752481223603_p
w(1)=9.861843156761539e-2_p
x(2)=1.843243354678502_p
w(2)=1.294189503554939e-1_p
x(3)=3.057464450438402_p
w(3)=6.672953992873568e-2_p
x(4)=4.830681851235048_p
w(4)=1.637961432279315e-2_p
x(5)=7.211271548432119_p
w(5)=1.991553816464629e-3_p
x(6)=10.23913258488969_p
w(6)=1.198914163629451e-4_p
x(7)=13.877782980697_p
w(7)=3.628429594873744e-6_p
x(8)=17.5958434465061_p
w(8)=7.207836581625880e-8_p
else if(N==9)then
x(1)=1.139043215897227_p
w(1)=8.628514561514926e-2_p
x(2)=1.725482188867127_p
w(2)=1.231614037090847e-1_p
x(3)=2.767303690810469_p
w(3)=7.512412416554304e-2_p
x(4)=4.274574868939434_p
w(4)=2.400031021702335e-2_p
x(5)=6.272439197296830_p
w(5)=4.239858490185841e-3_p
x(6)=8.777370471526417_p
w(6)=4.250585353451851e-4_p
x(7)=11.76826157356278_p
w(7)=2.481112851677551e-5_p
x(8)=15.08394058247527_p
w(8)=9.370324201466825e-7_p
x(9)=18.04480017360603_p
w(9)=3.302215814825274e-8_p
else if(N==10)then
x(1)=1.120788164543728_p
w(1)=7.602539480171072e-2_p
x(2)=1.630786942259278_p
w(2)=1.160247964776294e-1_p
x(3)=2.535615268365438_p
w(3)=8.083373374877745e-2_p
x(4)=3.836802899466273_p
w(4)=3.173594008048376e-2_p
x(5)=5.547028615647992_p
w(5)=7.450013732469325e-3_p
x(6)=7.672739359026313_p
w(6)=1.084195158435273e-3_p
x(7)=10.19740018663407_p
w(7)=1.008875932227789e-4_p
x(8)=13.04502165127478_p
w(8)=6.377988774413294e-6_p
x(9)=15.9720999780679_p
w(9)=3.237724127861963e-7_p
x(10)=18.31574060777263_p
w(10)=1.856151052483859e-8_p
else if(N==11)then
x(1)=1.105899046083166_p
w(1)=6.742543299962495e-2_p
x(2)=1.553491979745550_p
w(2)=1.086193016125859e-1_p
x(3)=2.347297440036587_p
w(3)=8.422055972746417e-2_p
x(4)=3.484418733547312_p
w(4)=3.899851511528946e-2_p
x(5)=4.970371369932623_p
w(5)=1.145486619568837e-2_p
x(6)=6.806874235166456_p
w(6)=2.219870461533900e-3_p
x(7)=8.980240016589009_p
w(7)=2.933348081239585e-4_p
x(8)=11.44509864102948_p
w(8)=2.762020987388626e-5_p
x(9)=14.08440383554209_p
w(9)=2.028303126968101e-6_p
x(10)=16.62091834154563_p
w(10)=1.406181439615154e-7_p
x(11)=18.48848587236289_p
w(11)=1.186397089755396e-8_p
else if(N==12)then
x(1)=1.093598532702206_p
w(1)=6.016131251968691e-2_p
x(2)=1.489574083753077_p
w(2)=1.013110976348016e-1_p
x(3)=2.191949481755127_p
w(3)=8.572638058409651e-2_p
x(4)=3.195671955889746_p
w(4)=4.541032008774661e-2_p
x(5)=4.501995822626450_p
w(5)=1.598785646028305e-2_p
x(6)=6.110217571743399_p
w(6)=3.891167602269390e-3_p
x(7)=8.008916502396863_p
w(7)=6.766840517582580e-4_p
x(8)=10.16723708045474_p
w(8)=8.718358132456683e-5_p
x(9)=12.51734937875108_p
w(9)=8.818662192925605e-6_p
x(10)=14.91851102059775_p
w(10)=7.799537378936045e-7_p
x(11)=17.09760217523247_p
w(11)=7.252221370411562e-8_p
x(12)=18.60426015459949_p
w(12)=8.255314945847062e-9_p
else if(N==13)then
x(1)=1.083320597293785_p
w(1)=5.397985761191652e-2_p
x(2)=1.436112307144008_p
w(2)=9.430818908767510e-2_p
x(3)=2.062181553485987_p
w(3)=8.577922394995535e-2_p
x(4)=2.955585516593063_p
w(4)=5.078123765742686e-2_p
x(5)=4.115028379594556_p
w(5)=2.075734141667779e-2_p
x(6)=5.538477210179138_p
w(6)=6.083867694402540e-3_p
x(7)=7.216363949937544_p
w(7)=1.320327371365389e-3_p
x(8)=9.126079675899426_p
w(8)=2.190089133930440e-4_p
x(9)=11.22331684093656_p
w(9)=2.895982403883784e-5_p
x(10)=13.42545987954373_p
w(10)=3.267748980909823e-6_p
x(11)=15.58414288626217_p
w(11)=3.520678030703106e-7_p
x(12)=17.45245496456061_p
w(12)=4.247814672496889e-8_p
x(13)=18.68521740514987_p
w(13)=6.093644274348274e-9_p
else if(N==14)then
x(1)=1.074645523187998_p
w(1)=4.868250200790795e-2_p
x(2)=1.390943366781651_p
w(2)=8.771866482900785e-2_p
x(3)=1.952603568293427_p
w(3)=8.475233206411679e-2_p
x(4)=2.753493707134606_p
w(4)=5.506170809384819e-2_p
x(5)=3.790825455483410_p
w(5)=2.549864186497081e-2_p
x(6)=5.061804465508492_p
w(6)=8.722328100232020e-3_p
x(7)=6.558352183094433_p
w(7)=2.272336834104275e-3_p
x(8)=8.263137090963031_p
w(8)=4.640005528211133e-4_p
x(9)=10.1448434240587_p
w(9)=7.677452593931085e-5_p
x(10)=12.14974600403757_p
w(10)=1.079327649487600e-5_p
x(11)=14.18802718521327_p
w(11)=1.386546666734376e-6_p
x(12)=16.1156665602147_p
w(12)=1.811782167129806e-7_p
x(13)=17.72096827381568_p
w(13)=2.734592434330536e-8_p
x(14)=18.743874360848_p
w(14)=4.695175433831597e-9_p
else if(N==15)then
x(1)=1.067256901006890_p
w(1)=4.411259285348685e-2_p
x(2)=1.352436737033679_p
w(2)=8.158889883994837e-2_p
x(3)=1.859196294821094_p
w(3)=8.295219867475082e-2_p
x(4)=2.581589889243571_p
w(4)=5.829466436929996e-2_p
x(5)=3.516007512374235_p
w(5)=3.000108688167379e-2_p
x(6)=4.659219191142175_p
w(6)=1.169166570668100e-2_p
x(7)=6.004323967553901_p
w(7)=3.550623510595354e-3_p
x(8)=7.537635914631938_p
w(8)=8.627754138313316e-4_p
x(9)=9.235810925409154_p
w(9)=1.724911805013799e-4_p
x(10)=11.06126979319787_p
w(10)=2.940147455027106e-5_p
x(11)=12.95487286929849_p
w(11)=4.494350601050499e-6_p
x(12)=14.8259372838305_p
w(12)=6.624171899258470e-7_p
x(13)=16.54210286690352_p
w(13)=1.036065694364748e-7_p
x(14)=17.92765204299601_p
w(14)=1.889909712564582e-8_p
x(15)=18.78765530241051_p
w(15)=3.736649749147850e-9_p
else if(N==16)then
x(1)=1.060912615318509_p
w(1)=4.014568670074679e-2_p
x(2)=1.319344210544370_p
w(2)=7.592810522431942e-2_p
x(3)=1.778905915668882_p
w(3)=8.062097065462034e-2_p
x(4)=2.434028157489457_p
w(4)=6.057621343979930e-2_p
x(5)=3.280708737262382_p
w(5)=3.411577509931606e-2_p
x(6)=4.315486824211368_p
w(6)=1.486076535759931e-2_p
x(7)=5.532384398371803_p
w(7)=5.142127063973172e-3_p
x(8)=6.920358350016357_p
w(8)=1.448369179666340e-3_p
x(9)=8.461350775651823_p
w(9)=3.402619287702937e-4_p
x(10)=10.12765276063833_p
w(10)=6.858854952677657e-5_p
x(11)=11.87776175662386_p
w(11)=1.231439328530554e-5_p
x(12)=13.65066418122126_p
w(12)=2.072779139100780e-6_p
x(13)=15.35938333055775_p
w(13)=3.502431794405238e-7_p
x(14)=16.88666986375715_p
w(14)=6.446359726469430e-8_p
x(15)=18.08940305585524_p
w(15)=1.378821124246684e-8_p
x(16)=18.82116109702171_p
w(16)=3.049676245546755e-9_p
else if(N==17)then
x(1)=1.055424884902425_p
w(1)=3.668220148081447e-2_p
x(2)=1.290696945907771_p
w(2)=7.072391066593432e-2_p
x(3)=1.709374326966801_p
w(3)=7.794481963158115e-2_p
x(4)=2.306345479425003_p
w(4)=6.202725007543931e-2_p
x(5)=3.077489829363734_p
w(5)=3.775146763673846e-2_p
x(6)=4.019253442036727_p
w(6)=1.810081422399683e-2_p
x(7)=5.126382106319991_p
w(7)=7.007891589977563e-3_p
x(8)=6.389808115545874_p
w(8)=2.241004673058711e-3_p
x(9)=7.795185373887230_p
w(9)=6.049488861081219e-4_p
x(10)=9.321274897760865_p
w(10)=1.411452609965795e-4_p
x(11)=10.9375025761361_p
w(11)=2.930107171108586e-5_p
x(12)=12.60055274726682_p
w(12)=5.621503976532436e-6_p
x(13)=14.25033336084291_p
w(13)=1.047551372100370e-6_p
x(14)=15.80640532251862_p
w(14)=2.017198365267385e-7_p
x(15)=17.16742204923956_p
w(15)=4.291295469030446e-8_p
x(16)=18.21796695540936_p
w(16)=1.049132741291399e-8_p
x(17)=18.84735466490294_p
w(17)=2.539602559206437e-9_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;19kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604143119627001_p
w(1)=1.077971013530677e-1_p
x(2)=5.444035183381478_p
w(2)=1.913090408710841e-2_p
else if(N==3)then
x(1)=2.427642721622487_p
w(1)=8.925116174242829e-2_p
x(2)=4.318109749390539_p
w(2)=3.629611688182816e-2_p
x(3)=8.305658468727675_p
w(3)=1.380726815919618e-3_p
else if(N==4)then
x(1)=2.329495696854081_p
w(1)=7.506841360519480e-2_p
x(2)=3.757158908493430_p
w(2)=4.651914242207328e-2_p
x(3)=6.524871035563937_p
w(3)=5.262908001147271e-3_p
x(4)=11.31320562092558_p
w(4)=7.754141176072218e-5_p
else if(N==5)then
x(1)=2.264695395592952_p
w(1)=6.390372949243014e-2_p
x(2)=3.401252338138191_p
w(2)=5.181809920863015e-2_p
x(3)=5.527767253630419_p
w(3)=1.063226631853860e-2_p
x(4)=8.887121096513837_p
w(4)=5.687834317103667e-4_p
x(5)=14.031801035492_p
w(5)=5.126988866797673e-6_p
else if(N==6)then
x(1)=2.217555610523636_p
w(1)=5.478469610145827e-2_p
x(2)=3.147265143506018_p
w(2)=5.383575659353015e-2_p
x(3)=4.853813636449682_p
w(3)=1.643755348423429e-2_p
x(4)=7.443096288787328_p
w(4)=1.804720388316599e-3_p
x(5)=11.09656416981627_p
w(5)=6.466781539173498e-5_p
x(6)=15.98032486342602_p
w(6)=6.110572450293249e-7_p
else if(N==7)then
x(1)=2.181866283479671_p
w(1)=4.728242132842879e-2_p
x(2)=2.957050192547042_p
w(2)=5.365515451029623e-2_p
x(3)=4.364240033685091_p
w(3)=2.182278254115551e-2_p
x(4)=6.452763625190970_p
w(4)=3.860118796414615e-3_p
x(5)=9.297065986975165_p
w(5)=2.978314329825359e-4_p
x(6)=12.95747856510287_p
w(6)=9.556144533784307e-6_p
x(7)=17.14079772231177_p
w(7)=1.406863646095014e-7_p
else if(N==8)then
x(1)=2.154241828278633_p
w(1)=4.110315326120836e-2_p
x(2)=2.810767141945850_p
w(2)=5.209775663400992e-2_p
x(3)=3.994685774573172_p
w(3)=2.628439146327678e-2_p
x(4)=5.728854746070730_p
w(4)=6.546791822586500e-3_p
x(5)=8.046471043528653_p
w(5)=8.383939356337168e-4_p
x(6)=10.96686195970585_p
w(6)=5.548314482938183e-5_p
x(7)=14.41251894708202_p
w(7)=1.983247108868664e-6_p
x(8)=17.79304448909053_p
w(8)=5.193152255506591e-8_p
else if(N==9)then
x(1)=2.132450383379877_p
w(1)=3.599037321328660e-2_p
x(2)=2.695820863169199_p
w(2)=4.975443402593575e-2_p
x(3)=3.707700473492981_p
w(3)=2.965698958178302e-2_p
x(4)=5.177685812254740_p
w(4)=9.559527922561125e-3_p
x(5)=7.120405694616983_p
w(5)=1.762826961071872e-3_p
x(6)=9.539637125669431_p
w(6)=1.907061653702100e-4_p
x(7)=12.3956405452814_p
w(7)=1.255114992748515e-5_p
x(8)=15.49767068502912_p
w(8)=5.707902723287687e-7_p
x(9)=18.16951710126919_p
w(9)=2.562996769552942e-8_p
else if(N==10)then
x(1)=2.114965976781062_p
w(1)=3.173147927397960e-2_p
x(2)=2.603810915026021_p
w(2)=4.701920579359251e-2_p
x(3)=3.479726844237804_p
w(3)=3.198269079717940e-2_p
x(4)=4.745447771475208_p
w(4)=1.260300778561694e-2_p
x(5)=6.406435671036551_p
w(5)=3.064132057074621e-3_p
x(6)=8.460239997629275_p
w(6)=4.751273618669538e-4_p
x(7)=10.87998436903105_p
w(7)=4.860907673800069e-5_p
x(8)=13.57504951240242_p
w(8)=3.522625343705183e-6_p
x(9)=16.28921834600352_p
w(9)=2.155710431974450e-7_p
x(10)=18.39900355049947_p
w(10)=1.509774115175660e-8_p
else if(N==11)then
x(1)=2.100726308609973_p
w(1)=2.815737309431880e-2_p
x(2)=2.528982650594937_p
w(2)=4.414230548169555e-2_p
x(3)=3.295251702563915_p
w(3)=3.340078902925091e-2_p
x(4)=4.398706779705251_p
w(4)=1.545277884358163e-2_p
x(5)=5.840048002075067_p
w(5)=4.668092989036987e-3_p
x(6)=7.614343986141407_p
w(6)=9.545693982643312e-4_p
x(7)=9.701261731479104_p
w(7)=1.364568203411937e-4_p
x(8)=12.04731312086309_p
w(8)=1.431556416111504e-5_p
x(9)=14.52681235370107_p
w(9)=1.213932343199177e-6_p
x(10)=16.86500097133897_p
w(10)=1.003353236533227e-7_p
x(11)=18.54691239973017_p
w(11)=9.951858688325613e-9_p
else if(N==12)then
x(1)=2.088976270482422_p
w(1)=2.513537003025864e-2_p
x(2)=2.467289017696654_p
w(2)=4.127643386118985e-2_p
x(3)=3.143661234195682_p
w(3)=3.408044333246046e-2_p
x(4)=4.115478599560789_p
w(4)=1.796789012541928e-2_p
x(5)=5.380929008368796_p
w(5)=6.465685276321757e-3_p
x(6)=6.934209806266375_p
w(6)=1.647231968510041e-3_p
x(7)=8.759138520100173_p
w(7)=3.063168498545402e-4_p
x(8)=10.81986187806582_p
w(8)=4.316859716587281e-5_p
x(9)=13.0431753485664_p
w(9)=4.903259610596717e-6_p
x(10)=15.28600446509222_p
w(10)=5.005202791992346e-7_p
x(11)=17.28770697275117_p
w(11)=5.454591482618488e-8_p
x(12)=18.64702371887799_p
w(12)=7.073191010838194e-9_p
else if(N==13)then
x(1)=2.079167906159324_p
w(1)=2.256152779201149e-2_p
x(2)=2.415814403081302_p
w(2)=3.851051654888819e-2_p
x(3)=3.017457595152639_p
w(3)=3.418557141651046e-2_p
x(4)=3.880668381269216_p
w(4)=2.007930195555930e-2_p
x(5)=5.002342295948226_p
w(5)=8.342451564941511e-3_p
x(6)=6.376524699613483_p
w(6)=2.541881921006905e-3_p
x(7)=7.989974724130758_p
w(7)=5.845920720962122e-4_p
x(8)=9.816705843812683_p
w(8)=1.046926888445051e-4_p
x(9)=11.80897084128416_p
w(9)=1.525315909729309e-5_p
x(10)=13.88177439231499_p
w(10)=1.938187623788713e-6_p
x(11)=15.88960850015053_p
w(11)=2.395809109380859e-7_p
x(12)=17.60278431239465_p
w(12)=3.325149968068771e-8_p
x(13)=18.71762728254193_p
w(13)=5.301185806593774e-9_p
else if(N==14)then
x(1)=2.070895979597577_p
w(1)=2.035414763294041e-2_p
x(2)=2.372413280123020_p
w(2)=3.589273841388371e-2_p
x(3)=2.911201187121260_p
w(3)=3.385952338638409e-2_p
x(4)=3.683552616744585_p
w(4)=2.177057481005478e-2_p
x(5)=4.685758300922546_p
w(5)=1.019755751824232e-2_p
x(6)=5.912037204016373_p
w(6)=3.604288913817243e-3_p
x(7)=7.351353788216918_p
w(7)=9.877308712718941e-4_p
x(8)=8.983896241012047_p
w(8)=2.156134578737548e-4_p
x(9)=10.77603644460622_p
w(9)=3.877442484971880e-5_p
x(10)=12.67222662052225_p
w(10)=6.029212919525086e-6_p
x(11)=14.5830026334165_p
w(11)=8.711855376456922e-7_p
x(12)=16.37067695146784_p
w(12)=1.294114978013668e-7_p
x(13)=17.84175927392236_p
w(13)=2.206970053786538e-8_p
x(14)=18.76915481284367_p
w(14)=4.131202654084522e-9_p
else if(N==15)then
x(1)=2.063855652820202_p
w(1)=1.844865250723622e-2_p
x(2)=2.335477217273365_p
w(2)=3.344575949941085e-2_p
x(3)=2.820856295818093_p
w(3)=3.322059992721901e-2_p
x(4)=3.516300483311061_p
w(4)=2.305927313219384e-2_p
x(5)=4.417890994180294_p
w(5)=1.195269330553518e-2_p
x(6)=5.520164030218367_p
w(6)=4.786838747181064e-3_p
x(7)=6.813790424090104_p
w(7)=1.519507553162458e-3_p
x(8)=8.283134532018691_p
w(8)=3.916154467169226e-4_p
x(9)=9.903206534449840_p
w(9)=8.421554425594147e-5_p
x(10)=11.63510068687062_p
w(10)=1.566517691097581e-5_p
x(11)=13.41939427697549_p
w(11)=2.650974898414522e-6_p
x(12)=15.16788680463375_p
w(12)=4.376907876919198e-7_p
x(13)=16.7563845875663_p
w(13)=7.700104290789059e-8_p
x(14)=18.02622167500972_p
w(14)=1.561700638032470e-8_p
x(15)=18.8078523519971_p
w(15)=3.316618207005822e-9_p
else if(N==16)then
x(1)=2.057814077732712_p
w(1)=1.679365707671070e-2_p
x(2)=2.303780552504282_p
w(2)=3.117658551327199e-2_p
x(3)=2.743371072535076_p
w(3)=3.236289175892939e-2_p
x(4)=3.373061622378338_p
w(4)=2.398223604342825e-2_p
x(5)=4.188951384928496_p
w(5)=1.355376320776743e-2_p
x(6)=5.185950416291829_p
w(6)=6.037633144561951e-3_p
x(7)=6.356077782387701_p
w(7)=2.171561258343649e-3_p
x(8)=7.686680577687493_p
w(8)=6.444937723917867e-4_p
x(9)=9.158456661493043_p
w(9)=1.615264371655834e-4_p
x(10)=10.74272786985344_p
w(10)=3.516471653315209e-5_p
x(11)=12.39759737705515_p
w(11)=6.902581903093755e-6_p
x(12)=14.06307057293459_p
w(12)=1.284420114845221e-6_p
x(13)=15.65607422861214_p
w(13)=2.416849357258868e-7_p
x(14)=17.06810777602169_p
w(14)=4.949190566204189e-8_p
x(15)=18.17100404511312_p
w(15)=1.160665297480377e-8_p
x(16)=18.83762433936321_p
w(16)=2.725559887135880e-9_p
else if(N==17)then
x(1)=2.052590929225798_p
w(1)=1.534798139005381e-2_p
x(2)=2.276375660393687_p
w(2)=2.908289595194983e-2_p
x(3)=2.676399302448242_p
w(3)=3.135933442274581e-2_p
x(4)=3.249380311795606_p
w(4)=2.458515917297999e-2_p
x(5)=3.991563959772726_p
w(5)=1.496847879265000e-2_p
x(6)=4.898248066985058_p
w(6)=7.307309163682153e-3_p
x(7)=5.962534577592256_p
w(7)=2.926043956591843e-3_p
x(8)=7.173985871209061_p
w(8)=9.803748445694077e-4_p
x(9)=8.517259006244265_p
w(9)=2.804293222985600e-4_p
x(10)=9.970387026538058_p
w(10)=7.007940883266202e-5_p
x(11)=11.50243477273143_p
w(11)=1.574791473830599e-5_p
x(12)=13.07051530497912_p
w(12)=3.303197641369459e-6_p
x(13)=14.61653454663854_p
w(13)=6.783572582606658e-7_p
x(14)=16.06473536723123_p
w(14)=1.444626786316210e-7_p
x(15)=17.32229108565147_p
w(15)=3.383664451394839e-8_p
x(16)=18.28641066919328_p
w(16)=8.962531003378454e-9_p
x(17)=18.86100483984426_p
w(17)=2.282329916813044e-9_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;19kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592725710762557_p
w(1)=4.139162736582477e-2_p
x(2)=6.425195549436530_p
w(2)=7.195718605120873e-3_p
else if(N==3)then
x(1)=3.419834201997312_p
w(1)=3.437986446761074e-2_p
x(2)=5.300426895027138_p
w(2)=1.368962995199228e-2_p
x(3)=9.285178049151863_p
w(3)=5.178515513426195e-4_p
else if(N==4)then
x(1)=3.322984506546079_p
w(1)=2.894788607456119e-2_p
x(2)=4.737089606591363_p
w(2)=1.761690825983271e-2_p
x(3)=7.491703277787922_p
w(3)=1.992184977580204e-3_p
x(4)=12.23560145414464_p
w(4)=3.036665897153186e-5_p
else if(N==5)then
x(1)=3.258463455293387_p
w(1)=2.460949601182633e-2_p
x(2)=4.377377091669094_p
w(2)=1.968636030365623e-2_p
x(3)=6.480414878461539_p
w(3)=4.062769423931740e-3_p
x(4)=9.788681082158158_p
w(4)=2.263885287101946e-4_p
x(5)=14.76193866034519_p
w(5)=2.331702821149630e-6_p
else if(N==6)then
x(1)=3.211584528848660_p
w(1)=2.105427573728424e-2_p
x(2)=4.121673632478460_p
w(2)=2.047852585804497e-2_p
x(3)=5.799556386507687_p
w(3)=6.304800772577441e-3_p
x(4)=8.337418958810050_p
w(4)=7.210278701172785e-4_p
x(5)=11.88043104799967_p
w(5)=2.837418440137939e-5_p
x(6)=16.45493084955322_p
w(6)=3.415485203277431e-7_p
else if(N==7)then
x(1)=3.176303248997006_p
w(1)=1.813728609668213e-2_p
x(2)=3.931725672793412_p
w(2)=2.041180250194233e-2_p
x(3)=5.308876792412903_p
w(3)=8.369341789506294e-3_p
x(4)=7.348943826039562_p
w(4)=1.536296109128373e-3_p
x(5)=10.10682731047939_p
w(5)=1.277921135851411e-4_p
x(6)=13.59919387666095_p
w(6)=4.734537458034405e-6_p
x(7)=17.42468890601105_p
w(7)=9.282264333311560e-8_p
else if(N==8)then
x(1)=3.149135644795585_p
w(1)=1.574169483757944e-2_p
x(2)=3.786650658166879_p
w(2)=1.981189216662423e-2_p
x(3)=4.940934711573329_p
w(3)=1.006415992578405e-2_p
x(4)=6.630235804285448_p
w(4)=2.589323694984661e-3_p
x(5)=8.875746699359837_p
w(5)=3.531506840632226e-4_p
x(6)=11.67656226775482_p
w(6)=2.597705730485583e-5_p
x(7)=14.91572513317792_p
w(7)=1.109477279550572e-6_p
x(8)=17.96543725152241_p
w(8)=3.812732562401113e-8_p
else if(N==9)then
x(1)=3.127790253474680_p
w(1)=1.376424850241311e-2_p
x(2)=3.673263961411071_p
w(2)=1.891041407915746e-2_p
x(3)=4.656694324475070_p
w(3)=1.133271804063568e-2_p
x(4)=6.085251210093460_p
w(4)=3.756121323034517e-3_p
x(5)=7.965718151167529_p
w(5)=7.309443463858344e-4_p
x(6)=10.29041945760107_p
w(6)=8.607940424633329e-5_p
x(7)=13.00148545633099_p
w(7)=6.445242359735035e-6_p
x(8)=15.88352324724105_p
w(8)=3.549331685365205e-7_p
x(9)=18.27975225897219_p
w(9)=2.009954443002127e-8_p
else if(N==10)then
x(1)=3.110719137351670_p
w(1)=1.212035875714642e-2_p
x(2)=3.582895459957584_p
w(2)=1.786021449335448e-2_p
x(3)=4.431882361266383_p
w(3)=1.219728021065286e-2_p
x(4)=5.659314238399154_p
w(4)=4.921572490855308e-3_p
x(5)=7.265387105182274_p
w(5)=1.253438820456920e-3_p
x(6)=9.240343088194747_p
w(6)=2.087013016784586e-4_p
x(7)=11.54743456997919_p
w(7)=2.364516286639755e-5_p
x(8)=14.08299729248074_p
w(8)=1.976498079335506e-6_p
x(9)=16.58385180312915_p
w(9)=1.458902904872246e-7_p
x(10)=18.47350577833381_p
w(10)=1.234556497438073e-8_p
else if(N==11)then
x(1)=3.096853753178842_p
w(1)=1.074321680088213e-2_p
x(2)=3.509666947734728_p
w(2)=1.675759575664681e-2_p
x(3)=4.250643483766805_p
w(3)=1.271529739391387e-2_p
x(4)=5.318647875773231_p
w(4)=6.001357818346594e-3_p
x(5)=6.710821775326911_p
w(5)=1.887403604289981e-3_p
x(6)=8.417217116871896_p
w(6)=4.103076535607458e-4_p
x(7)=10.4114532982942_p
w(7)=6.384445785468959e-5_p
x(8)=12.63261363574836_p
w(8)=7.504359262473109e-6_p
x(9)=14.94860368905968_p
w(9)=7.372994847967523e-7_p
x(10)=17.09174315486444_p
w(10)=7.245964353888168e-8_p
x(11)=18.59978133892854_p
w(11)=8.367060009552436e-9_p
else if(N==12)then
x(1)=3.085439090091351_p
w(1)=9.580628939231964e-3_p
x(2)=3.449476398772214_p
w(2)=1.566090770234337e-2_p
x(3)=4.102195182181801_p
w(3)=1.295377247840507e-2_p
x(4)=5.041128831341740_p
w(4)=6.944819121900206e-3_p
x(5)=6.262075905690809_p
w(5)=2.588003911136642e-3_p
x(6)=7.755638742048549_p
w(6)=6.954692906085520e-4_p
x(7)=9.501595600544384_p
w(7)=1.390696162089504e-4_p
x(8)=11.4595146757316_p
w(8)=2.154371497499434e-5_p
x(9)=13.55182696300534_p
w(9)=2.758451136880861e-6_p
x(10)=15.63533135345963_p
w(10)=3.253078783395031e-7_p
x(11)=17.46465423148402_p
w(11)=4.137407062317080e-8_p
x(12)=18.68609636292232_p
w(12)=6.063050044062802e-9_p
else if(N==13)then
x(1)=3.075929842982839_p
w(1)=8.591842344265818e-3_p
x(2)=3.399387153505482_p
w(2)=1.460387731377466e-2_p
x(3)=3.978958919444710_p
w(3)=1.297635544005762e-2_p
x(4)=4.811613437666671_p
w(4)=7.729054464455153e-3_p
x(5)=5.892669984697100_p
w(5)=3.310331682572544e-3_p
x(6)=7.213538209493825_p
w(6)=1.057090400541354e-3_p
x(7)=8.758103537289637_p
w(7)=2.590244432994242e-4_p
x(8)=10.49735760607517_p
w(8)=5.030590404586397e-5_p
x(9)=12.38063953638442_p
w(9)=8.105939226780318e-6_p
x(10)=14.32169167208133_p
w(10)=1.162511287436789e-6_p
x(11)=16.17960939212809_p
w(11)=1.647418694647580e-7_p
x(12)=17.74313335454916_p
w(12)=2.617711533092350e-8_p
x(13)=18.74748465911326_p
w(13)=4.608434187338992e-9_p
else if(N==14)then
x(1)=3.067924318123521_p
w(1)=7.744912881391694e-3_p
x(2)=3.357249676052001_p
w(2)=1.360460424941796e-2_p
x(3)=3.875461176504363_p
w(3)=1.283800207480053e-2_p
x(4)=4.619372242967414_p
w(4)=8.350752390619970e-3_p
x(5)=5.584265732122967_p
w(5)=4.016277349915047e-3_p
x(6)=6.762409485715794_p
w(6)=1.479660978583861e-3_p
x(7)=8.140631037291376_p
w(7)=4.288626295669218e-4_p
x(8)=9.697004195313790_p
w(8)=1.004954771459327e-4_p
x(9)=11.39590979725276_p
w(9)=1.971134031272816e-5_p
x(10)=13.18058843247558_p
w(10)=3.398988347874319e-6_p
x(11)=14.9629437976684_p
w(11)=5.529079561058973e-7_p
x(12)=16.61276878270117_p
w(12)=9.319812609076358e-8_p
x(13)=17.95492032770526_p
w(13)=1.787524158091280e-8_p
x(14)=18.79260758006404_p
w(14)=3.629519341857657e-9_p
else if(N==15)then
x(1)=3.061121356111821_p
w(1)=7.014650723827881e-3_p
x(2)=3.321459901261826_p
w(2)=1.267145452111236e-2_p
x(3)=3.787657552760847_p
w(3)=1.258364780075453e-2_p
x(4)=4.456589324858510_p
w(4)=8.818814884058977e-3_p
x(5)=5.323725414085947_p
w(5)=4.677299273313094e-3_p
x(6)=6.382156606450534_p
w(6)=1.943359741068437e-3_p
x(7)=7.620918089571116_p
w(7)=6.484882463001544e-4_p
x(8)=9.022820602568611_p
w(8)=1.779769715267769e-4_p
x(9)=10.56146745751426_p
w(9)=4.130416818425523e-5_p
x(10)=12.19698655037032_p
w(10)=8.406937162681573e-6_p
x(11)=13.8702756504222_p
w(11)=1.577525250322967e-6_p
x(12)=15.49640987980636_p
w(12)=2.917229561544275e-7_p
x(13)=16.95996841594572_p
w(13)=5.758686843383596e-8_p
x(14)=18.11888989478832_p
w(14)=1.293073030723743e-8_p
x(15)=18.82670129332638_p
w(15)=2.937831273039629e-9_p
else if(N==16)then
x(1)=3.055291589924111_p
w(1)=6.381053626732455e-3_p
x(2)=3.290800363355115_p
w(2)=1.180685877673321e-2_p
x(3)=3.712500974599925_p
w(3)=1.224877829893796e-2_p
x(4)=4.317439046618758_p
w(4)=9.148746955071917e-3_p
x(5)=5.101378253371918_p
w(5)=5.274503775279214e-3_p
x(6)=6.058164121827736_p
w(6)=2.427617384783821e-3_p
x(7)=7.178542247301525_p
w(7)=9.131346323978611e-4_p
x(8)=8.448672496639269_p
w(8)=2.867072421349446e-4_p
x(9)=9.848222376757874_p
w(9)=7.689913886452441e-5_p
x(10)=11.3477764805936_p
w(10)=1.812766448689234e-5_p
x(11)=12.90541704116888_p
w(11)=3.897717591756126e-6_p
x(12)=14.46269139570512_p
w(12)=8.023899407567189e-7_p
x(13)=15.94097153124999_p
w(13)=1.679871785801500e-7_p
x(14)=17.24070687462254_p
w(14)=3.817248153902866e-8_p
x(15)=18.24798058263452_p
w(15)=9.778283334833832e-9_p
x(16)=18.85306766187391_p
w(16)=2.430046871964794e-9_p
else if(N==17)then
x(1)=3.050257846380896_p
w(1)=5.828121780544774e-3_p
x(2)=3.264333064873986_p
w(2)=1.100973407957797e-2_p
x(3)=3.647656863716385_p
w(3)=1.186074222371982e-2_p
x(4)=4.197494449192773_p
w(4)=9.358816162625601e-3_p
x(5)=4.909944957782318_p
w(5)=5.797331102328458e-3_p
x(6)=5.779531297539460_p
w(6)=2.913590324959962e-3_p
x(7)=6.798355724048818_p
w(7)=1.214658963464831e-3_p
x(8)=7.955046241363291_p
w(8)=4.281844473230927e-4_p
x(9)=9.233478371652570_p
w(9)=1.301822709291809e-4_p
x(10)=10.61112507130051_p
w(10)=3.493262837790462e-5_p
x(11)=12.05693120476128_p
w(11)=8.514128688407610e-6_p
x(12)=13.52878517189875_p
w(12)=1.954863209543342e-6_p
x(13)=14.97099720115232_p
w(13)=4.424593809635890e-7_p
x(14)=16.3128069832201_p
w(14)=1.040680637798592e-7_p
x(15)=17.46984484966519_p
w(15)=2.676611817297266e-8_p
x(16)=18.35118236755697_p
w(16)=7.655981065304384e-9_p
x(17)=18.87386637748865_p
w(17)=2.045652110956994e-9_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;19kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588279168498033_p
w(1)=1.547965466770412e-2_p
x(2)=7.417635291309760_p
w(2)=2.670267647309195e-3_p
else if(N==3)then
x(1)=4.416432847842315_p
w(1)=1.286636060521332e-2_p
x(2)=6.291228578442736_p
w(2)=5.090295376556615e-3_p
x(3)=10.26779572641969_p
w(3)=1.932663332433826e-4_p
else if(N==4)then
x(1)=4.319266683174476_p
w(1)=1.081560751701225e-2_p
x(2)=5.722270912009106_p
w(2)=6.569521475171461e-3_p
x(3)=8.456318992425349_p
w(3)=7.526746298767022e-4_p
x(4)=13.12987864727161_p
w(4)=1.211869295291031e-5_p
else if(N==5)then
x(1)=4.254110439315655_p
w(1)=9.160752485602429e-3_p
x(2)=5.357089966860721_p
w(2)=7.348689666199462e-3_p
x(3)=7.430131130824834_p
w(3)=1.548117745629118e-3_p
x(4)=10.67098811037178_p
w(4)=9.125045897407009e-5_p
x(5)=15.42656808317329_p
w(5)=1.111958608238876e-6_p
else if(N==6)then
x(1)=4.206995105666494_p
w(1)=7.807321127793119e-3_p
x(2)=5.099088674266641_p
w(2)=7.634628962142179e-3_p
x(3)=6.743806904470288_p
w(3)=2.405037179543843e-3_p
x(4)=9.219469873322259_p
w(4)=2.899886326885868e-4_p
x(5)=12.63220808512987_p
w(5)=1.274641558937825e-5_p
x(6)=16.86805918974462_p
w(6)=1.999972562131570e-7_p
else if(N==7)then
x(1)=4.171795686430962_p
w(1)=6.703232116150024e-3_p
x(2)=4.909013396698151_p
w(2)=7.591990792361458e-3_p
x(3)=6.253186432102174_p
w(3)=3.183636690955001e-3_p
x(4)=8.237155888917938_p
w(4)=6.129977552515392e-4_p
x(5)=10.89659202963805_p
w(5)=5.558898786373425e-5_p
x(6)=14.20370984799268_p
w(6)=2.412805055877639e-6_p
x(7)=17.6691758783987_p
w(7)=6.316737568405020e-8_p
else if(N==8)then
x(1)=4.144852064624850_p
w(1)=5.801117591783008e-3_p
x(2)=4.764791935161697_p
w(2)=7.349488202728471e-3_p
x(3)=5.887570714865257_p
w(3)=3.812607099921148e-3_p
x(4)=7.526334885343171_p
w(4)=1.023661568492306e-3_p
x(5)=9.691249296083450_p
w(5)=1.499958209685981e-4_p
x(6)=12.36132568010533_p
w(6)=1.238584600861116e-5_p
x(7)=15.38363464353179_p
w(7)=6.376867427899081e-7_p
x(8)=18.1150314679965_p
w(8)=2.849836838798168e-8_p
else if(N==9)then
x(1)=4.123782476413527_p
w(1)=5.059650887778472e-3_p
x(2)=4.652653698820554_p
w(2)=6.996762251514213e-3_p
x(3)=5.606496986904319_p
w(3)=4.274441276123782e-3_p
x(4)=6.989336885650268_p
w(4)=1.471591104309445e-3_p
x(5)=8.801093521816215_p
w(5)=3.045243004357867e-4_p
x(6)=11.02317553491449_p
w(6)=3.933473125776600e-5_p
x(7)=13.58074849542882_p
w(7)=3.376106853480468e-6_p
x(8)=16.23981197476379_p
w(8)=2.257389600629935e-7_p
x(9)=18.37665662360813_p
w(9)=1.591778031078126e-8_p
else if(N==10)then
x(1)=4.106997811281317_p
w(1)=4.445531995732500e-3_p
x(2)=4.563659611930881_p
w(2)=6.591886456311984e-3_p
x(3)=5.385082755810931_p
w(3)=4.581154128637815e-3_p
x(4)=6.570961437209877_p
w(4)=1.912175471628592e-3_p
x(5)=8.117014816564847_p
w(5)=5.138202533811160e-4_p
x(6)=10.00685598775526_p
w(6)=9.244270683818216e-5_p
x(7)=12.19450606465164_p
w(7)=1.167032124822916e-5_p
x(8)=14.56543044130602_p
w(8)=1.130387250366003e-6_p
x(9)=16.85536086038105_p
w(9)=1.004480271844875e-7_p
x(10)=18.53985714706796_p
w(10)=1.014595734950387e-8_p
else if(N==11)then
x(1)=4.093410456217278_p
w(1)=3.932730572161039e-3_p
x(2)=4.491803735462728_p
w(2)=6.170819441988009e-3_p
x(3)=5.207196526913430_p
w(3)=4.757048121016961e-3_p
x(4)=6.237266984307524_p
w(4)=2.314212515924084e-3_p
x(5)=7.576155789711622_p
w(5)=7.630726374668095e-4_p
x(6)=9.209591438490937_p
w(6)=1.773371932460796e-4_p
x(7)=11.10563794437266_p
w(7)=3.019227584771943e-5_p
x(8)=13.19695347328998_p
w(8)=3.994069579573701e-6_p
x(9)=15.3475413025349_p
w(9)=4.554534027117941e-7_p
x(10)=17.300935507403_p
w(10)=5.298452899096649e-8_p
x(11)=18.64741333799562_p
w(11)=7.049851341443732e-9_p
else if(N==12)then
x(1)=4.082256880086989_p
w(1)=3.501062140524790e-3_p
x(2)=4.432923766094847_p
w(2)=5.754939508618881e-3_p
x(3)=5.061930099898796_p
w(3)=4.829011486936511e-3_p
x(4)=5.966099208447673_p
w(4)=2.660083095095341e-3_p
x(5)=7.139187031243036_p
w(5)=1.033895484918939e-3_p
x(6)=8.568841041001036_p
w(6)=2.945913869191818e-4_p
x(7)=10.23124537008969_p
w(7)=6.363306063447466e-5_p
x(8)=12.08195863019658_p
w(8)=1.088015369177966e-5_p
x(9)=14.04026921795871_p
w(9)=1.574699365600574e-6_p
x(10)=15.96505361563757_p
w(10)=2.144433748436934e-7_p
x(11)=17.62838133483963_p
w(11)=3.165580965575601e-8_p
x(12)=18.72164781611595_p
w(12)=5.199123319142621e-9_p
else if(N==13)then
x(1)=4.072988542451974_p
w(1)=3.134861899489831e-3_p
x(2)=4.384056817420284_p
w(2)=5.356312866027524e-3_p
x(3)=4.941652749775590_p
w(3)=4.821876101361880e-3_p
x(4)=5.742337174880113_p
w(4)=2.942839349292962e-3_p
x(5)=6.780029044445042_p
w(5)=1.308783002834503e-3_p
x(6)=8.044055897909292_p
w(6)=4.402386027375556e-4_p
x(7)=9.515851156263864_p
w(7)=1.154079730075518e-4_p
x(8)=11.16377253600538_p
w(8)=2.439631828839604e-5_p
x(9)=12.93491944320809_p
w(9)=4.360296606288589e-6_p
x(10)=14.74296918950585_p
w(10)=7.066011893419374e-7_p
x(11)=16.45320627080494_p
w(11)=1.145741161917938e-7_p
x(12)=17.87347635463397_p
w(12)=2.072698205263101e-8_p
x(13)=18.77487942174995_p
w(13)=4.003079240321423e-9_p
else if(N==14)then
x(1)=4.065203190219696_p
w(1)=2.821914106663696e-3_p
x(2)=4.343044685143084_p
w(2)=4.981184267010014e-3_p
x(3)=4.840875932183783_p
w(3)=4.756661685807928e-3_p
x(4)=5.555295356907462_p
w(4)=3.162744798657379e-3_p
x(5)=6.480624985462182_p
w(5)=1.573509415589944e-3_p
x(6)=7.607636873282538_p
w(6)=6.073385480873288e-4_p
x(7)=8.921419370415084_p
w(7)=1.868989213892326e-4_p
x(8)=10.39823917548551_p
w(8)=4.717148634851559e-5_p
x(9)=12.00090185730055_p
w(9)=1.011994746575424e-5_p
x(10)=13.67213168974426_p
w(10)=1.938708118623272e-6_p
x(11)=15.32619652302996_p
w(11)=3.550027388623077e-7_p
x(12)=16.84130533989767_p
w(12)=6.771309464698805e-8_p
x(13)=18.06042655087438_p
w(13)=1.453025797043121e-8_p
x(14)=18.8142793542965_p
w(14)=3.183783423530754e-9_p
else if(N==15)then
x(1)=4.058600429005742_p
w(1)=2.552629010002356e-3_p
x(2)=4.308283641906205_p
w(2)=4.632228997985060e-3_p
x(3)=4.755559015885344_p
w(3)=4.650286383727113e-3_p
x(4)=5.397208495516940_p
w(4)=3.324341404611161e-3_p
x(5)=6.228046313356068_p
w(5)=1.817897209068643e-3_p
x(6)=7.240076342338853_p
w(6)=7.876935430322288e-4_p
x(7)=8.421065156956409_p
w(7)=2.773556571228933e-4_p
x(8)=9.752538372995780_p
w(8)=8.131192968464629e-5_p
x(9)=11.20697837082485_p
w(9)=2.041941503946587e-5_p
x(10)=12.74397920658255_p
w(10)=4.556819175887120e-6_p
x(11)=14.30538750501783_p
w(11)=9.489172754078734e-7_p
x(12)=15.8102751145601_p
w(12)=1.963484548978671e-7_p
x(13)=17.15240097576751_p
w(13)=4.335509566491188e-8_p
x(14)=18.20562425649894_p
w(14)=1.072790440349974e-8_p
x(15)=18.84422496132551_p
w(15)=2.596833490114388e-9_p
else if(N==16)then
x(1)=4.052952266339583_p
w(1)=2.319421788778766e-3_p
x(2)=4.278561009915211_p
w(2)=4.309984135823519e-3_p
x(3)=4.682667839447268_p
w(3)=4.515930300102878e-3_p
x(4)=5.262301735989450_p
w(4)=3.434316629974921e-3_p
x(5)=6.012783774436897_p
w(5)=2.035603560659995e-3_p
x(6)=6.927165297225157_p
w(6)=9.732151037251037e-4_p
x(7)=7.995248362562272_p
w(7)=3.842774319045112e-4_p
x(8)=9.202252045029708_p
w(8)=1.280238601590398e-4_p
x(9)=10.52703155557668_p
w(9)=3.684053898225431e-5_p
x(10)=11.93972197537459_p
w(10)=9.423020211044892e-6_p
x(11)=13.39879444408979_p
w(11)=2.222137545659104e-6_p
x(12)=14.84784561985839_p
w(12)=5.061095304946622e-7_p
x(13)=16.21314300638333_p
w(13)=1.177068296603161e-7_p
x(14)=17.40412719750539_p
w(14)=2.958519042275288e-8_p
x(15)=18.32029319737336_p
w(15)=8.244418577533231e-9_p
x(16)=18.8675005315776_p
w(16)=2.161176471354786e-9_p
else if(N==17)then
x(1)=4.048083133254152_p
w(1)=2.116246628476882e-3_p
x(2)=4.252945572012692_p
w(2)=4.013749033166231e-3_p
x(3)=4.619884707412595_p
w(3)=4.363626070409654e-3_p
x(4)=5.146196042347142_p
w(4)=3.500100469387461e-3_p
x(5)=5.827686246336367_p
w(5)=2.223453328421080e-3_p
x(6)=6.658297481545420_p
w(6)=1.156793115794036e-3_p
x(7)=7.629421275038038_p
w(7)=5.040158854121476e-4_p
x(8)=8.728981082091611_p
w(8)=1.874723981257802e-4_p
x(9)=9.940252385445440_p
w(9)=6.072778563471445e-5_p
x(10)=11.24035300975968_p
w(10)=1.753266754924030e-5_p
x(11)=12.5983860234814_p
w(11)=4.641568893158018e-6_p
x(12)=13.97336934426627_p
w(12)=1.167274608937078e-6_p
x(13)=15.31238633796633_p
w(13)=2.910217876316583e-7_p
x(14)=16.54989931706497_p
w(14)=7.545513207993435e-8_p
x(15)=17.60981618217349_p
w(15)=2.124473250682919e-8_p
x(16)=18.41223820792329_p
w(16)=6.539056328344485e-9_p
x(17)=18.88594121641752_p
w(17)=1.828425450722874e-9_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;19kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586508014335801_p
w(1)=5.729340261009130e-3_p
x(2)=8.414030317181453_p
w(2)=9.860026253125174e-4_p
else if(N==3)then
x(1)=5.414484269421695_p
w(1)=4.758979091073740e-3_p
x(2)=7.283509351040167_p
w(2)=1.883987662681725e-3_p
x(3)=11.24406697094467_p
w(3)=7.237613256618234e-5_p
else if(N==4)then
x(1)=5.316145972270114_p
w(1)=3.986616202754092e-3_p
x(2)=6.706468722748626_p
w(2)=2.437696913106257e-3_p
x(3)=9.410306666534879_p
w(3)=2.860375625927254e-4_p
x(4)=13.97944843843506_p
w(4)=4.992207868572030e-6_p
else if(N==5)then
x(1)=5.250006363518493_p
w(1)=3.359484000707257e-3_p
x(2)=6.335386196657042_p
w(2)=2.725627944331249e-3_p
x(3)=8.370638703799468_p
w(3)=5.921725750286432e-4_p
x(4)=11.52617232808476_p
w(4)=3.749886502090990e-5_p
x(5)=16.01814768898294_p
w(5)=5.595012335878546e-7_p
else if(N==6)then
x(1)=5.202540174128827_p
w(1)=2.849468389947953e-3_p
x(2)=6.075402007965558_p
w(2)=2.823490735782629e-3_p
x(3)=7.681360990810618_p
w(3)=9.183662253938691e-4_p
x(4)=10.08365963114122_p
w(4)=1.180043383623941e-4_p
x(5)=13.34620767647499_p
w(5)=5.890735672453972e-6_p
x(6)=17.22296415349094_p
w(6)=1.224611623472035e-7_p
else if(N==7)then
x(1)=5.167364824247129_p
w(1)=2.436464456134632e-3_p
x(2)=5.885476599512089_p
w(2)=2.797110287854615e-3_p
x(3)=7.192591506992359_p
w(3)=1.209498181180949e-3_p
x(4)=9.112671967767106_p
w(4)=2.463432520137225e-4_p
x(5)=11.66164999970031_p
w(5)=2.461453798751227e-5_p
x(6)=14.76804418321479_p
w(6)=1.267974435757004e-6_p
x(7)=17.87855610115619_p
w(7)=4.419671445974539e-8_p
else if(N==8)then
x(1)=5.140610254166357_p
w(1)=2.101109716773030e-3_p
x(2)=5.742299671509757_p
w(2)=2.697202785713972e-3_p
x(3)=6.830521149031306_p
w(3)=1.439791865855280e-3_p
x(4)=8.412945516848563_p
w(4)=4.063351958103400e-4_p
x(5)=10.48887408809755_p
w(5)=6.447321572278389e-5_p
x(6)=13.01767752102405_p
w(6)=6.031675288329551e-6_p
x(7)=15.81549890269497_p
w(7)=3.767953817146220e-7_p
x(8)=18.24456021101982_p
w(8)=2.163577619756015e-8_p
else if(N==9)then
x(1)=5.119795226182326_p
w(1)=1.826924204730809e-3_p
x(2)=5.631545611665944_p
w(2)=2.558179293922765e-3_p
x(3)=6.553474891211053_p
w(3)=1.604571002448648e-3_p
x(4)=7.886117940720864_p
w(4)=5.775483169243825e-4_p
x(5)=9.622843856693182_p
w(5)=1.279053008519913e-4_p
x(6)=11.73457233806646_p
w(6)=1.824821510014766e-5_p
x(7)=14.13126086418806_p
w(7)=1.807065334982241e-6_p
x(8)=16.56695523119815_p
w(8)=1.467760180561677e-7_p
x(9)=18.4617545742971_p
w(9)=1.271098986485091e-8_p
else if(N==10)then
x(1)=5.103284108481328_p
w(1)=1.600863402941352e-3_p
x(2)=5.544025246824734_p
w(2)=2.401825379215882e-3_p
x(3)=6.336082758843771_p
w(3)=1.710047641265070e-3_p
x(4)=7.476872900083284_p
w(4)=7.428435563972648e-4_p
x(5)=8.957933850505885_p
w(5)=2.117674503298064e-4_p
x(6)=10.75665883258699_p
w(6)=4.140104676224735e-5_p
x(7)=12.81870088113066_p
w(7)=5.856253476749352e-6_p
x(8)=15.02123192293832_p
w(8)=6.594826291185485e-7_p
x(9)=17.10451941646851_p
w(9)=7.030159569679625e-8_p
x(10)=18.59890465206314_p
w(10)=8.371708458472178e-9_p
else if(N==11)then
x(1)=5.089966955567724_p
w(1)=1.412849176771162e-3_p
x(2)=5.473616188163907_p
w(2)=2.241322388074880e-3_p
x(3)=6.162010627696905_p
w(3)=1.766545265195055e-3_p
x(4)=7.151314693577413_p
w(4)=8.908846496172418e-4_p
x(5)=8.432899146614865_p
w(5)=3.095216454865331e-4_p
x(6)=9.988542505601147_p
w(6)=7.726596112712403e-5_p
x(7)=11.78129011935327_p
w(7)=1.446131945924242e-5_p
x(8)=13.7386036414011_p
w(8)=2.161144912789393e-6_p
x(9)=15.72319585135405_p
w(9)=2.861931742514683e-7_p
x(10)=17.49332787178184_p
w(10)=3.919411390867741e-8_p
x(11)=18.69029418018007_p
w(11)=5.948389458304224e-9_p
else if(N==12)then
x(1)=5.079069766795642_p
w(1)=1.255136344409218e-3_p
x(2)=5.416103222961702_p
w(2)=2.084301934711660e-3_p
x(3)=6.020272455433425_p
w(3)=1.784872318135749e-3_p
x(4)=6.887381506462527_p
w(4)=1.015781898762883e-3_p
x(5)=8.009303813182534_p
w(5)=4.136853789101086e-4_p
x(6)=9.371058266134810_p
w(6)=1.255074282284349e-4_p
x(7)=10.94562453154712_p
w(7)=2.940367102465452e-5_p
x(8)=12.68524038586845_p
w(8)=5.568850693289031e-6_p
x(9)=14.5073907689601_p
w(9)=9.128500447978289e-7_p
x(10)=16.27512107635006_p
w(10)=1.433435842576776e-7_p
x(11)=17.77949744626463_p
w(11)=2.441052953899562e-8_p
x(12)=18.7539678558715_p
w(12)=4.457287054430791e-9_p
else if(N==13)then
x(1)=5.070039591234976_p
w(1)=1.121758288627449e-3_p
x(2)=5.368502219479560_p
w(2)=1.934921780646670e-3_p
x(3)=5.903217665340228_p
w(3)=1.774698976868915e-3_p
x(4)=6.670053998005637_p
w(4)=1.115703652599418e-3_p
x(5)=7.661627904384044_p
w(5)=5.175112198006083e-4_p
x(6)=8.865459697432565_p
w(6)=1.840687557952824e-4_p
x(7)=10.26084047146312_p
w(7)=5.180827559914763e-5_p
x(8)=11.81393330442619_p
w(8)=1.195950822627770e-5_p
x(9)=13.47036047569932_p
w(9)=2.376529747985626e-6_p
x(10)=15.14494132750855_p
w(10)=4.353713639556196e-7_p
x(11)=16.71052461761179_p
w(11)=8.056001639179661e-8_p
x(12)=17.99427465974098_p
w(12)=1.649431574341338e-8_p
x(13)=18.79999109903453_p
w(13)=3.472713802502471e-9_p
else if(N==14)then
x(1)=5.062472895175599_p
w(1)=1.008091406584445e-3_p
x(2)=5.328649734587013_p
w(2)=1.795211231983008e-3_p
x(3)=5.805365042222275_p
w(3)=1.744023108778006e-3_p
x(4)=6.488743728186049_p
w(4)=1.191423567802491e-3_p
x(5)=7.372195900423361_p
w(5)=6.157814678677796e-4_p
x(6)=8.445222339467504_p
w(6)=2.498970489406605e-4_p
x(7)=9.691429663213437_p
w(7)=8.191370470445976e-5_p
x(8)=11.08558823411724_p
w(8)=2.233363975633626e-5_p
x(9)=12.58940398155728_p
w(9)=5.253372675839259e-6_p
x(10)=14.14581568016386_p
w(10)=1.119498925151222e-6_p
x(11)=15.67239122994511_p
w(11)=2.305969364260682e-7_p
x(12)=17.05647333199001_p
w(12)=4.960813568456739e-8_p
x(13)=18.15861734138921_p
w(13)=1.184613079113964e-8_p
x(14)=18.83428518704903_p
w(14)=2.787100567999009e-9_p
else if(N==15)then
x(1)=5.056069598638835_p
w(1)=9.105258984485710e-4_p
x(2)=5.294944776464395_p
w(2)=1.665922582946969e-3_p
x(3)=5.722693443753641_p
w(3)=1.699159923710175e-3_p
x(4)=6.335773294777918_p
w(4)=1.245164772356125e-3_p
x(5)=7.128354929003974_p
w(5)=7.049690877555182e-4_p
x(6)=8.091533649344520_p
w(6)=3.196433335888666e-4_p
x(7)=9.212025241404705_p
w(7)=1.191147681501230e-4_p
x(8)=10.47030818430074_p
w(8)=3.740353234506486e-5_p
x(9)=11.83806491013973_p
w(9)=1.018765210920014e-5_p
x(10)=13.27482427015267_p
w(10)=2.496687318041036e-6_p
x(11)=14.72400210300729_p
w(11)=5.771711601459687e-7_p
x(12)=16.10929683514089_p
w(12)=1.334328778563724e-7_p
x(13)=17.33387362355666_p
w(13)=3.284115354334622e-8_p
x(14)=18.28667190528627_p
w(14)=8.912848600556608e-9_p
x(15)=18.8604992810807_p
w(15)=2.289552846414718e-9_p
else if(N==16)then
x(1)=5.050602797792144_p
w(1)=8.262204293375171e-4_p
x(2)=5.266181157250995_p
w(2)=1.547062623608023e-3_p
x(3)=5.652192835329455_p
w(3)=1.644946224284820e-3_p
x(4)=6.205445343426182_p
w(4)=1.279799096543977e-3_p
x(5)=6.920803578366547_p
w(5)=7.830532409680091e-4_p
x(6)=7.790662639198316_p
w(6)=3.901706949280375e-4_p
x(7)=8.804065821496287_p
w(7)=1.621749438505801e-4_p
x(8)=9.945484062525265_p
w(8)=5.747194056632034e-5_p
x(9)=11.19319233356484_p
w(9)=1.778284518982792e-5_p
x(10)=12.51719364321865_p
w(10)=4.943724924493990e-6_p
x(11)=13.87676780868764_p
w(11)=1.279753476346680e-6_p
x(12)=15.21803371157786_p
w(12)=3.223512240159752e-7_p
x(13)=16.47251062322577_p
w(13)=8.311903515712219e-8_p
x(14)=17.55854065252089_p
w(14)=2.302912184387536e-8_p
x(15)=18.38812165508034_p
w(15)=6.952839797808969e-9_p
x(16)=18.8809743256814_p
w(16)=1.916422879636542e-9_p
else if(N==17)then
x(1)=5.045898344158073_p
w(1)=7.529198849633832e-4_p
x(2)=5.241435666482290_p
w(2)=1.438221159113341e-3_p
x(3)=5.591570509580478_p
w(3)=1.585005097501012e-3_p
x(4)=6.093448335186341_p
w(4)=1.298344371768061e-3_p
x(5)=6.742552309183629_p
w(5)=8.491994548342815e-4_p
x(6)=7.532347615827426_p
w(6)=4.588441534491532e-4_p
x(7)=8.453671006870522_p
w(7)=2.094954764436046e-4_p
x(8)=9.493902920166308_p
w(8)=8.241339662999816e-5_p
x(9)=10.63589672405993_p
w(9)=2.850219273903658e-5_p
x(10)=11.85664131577005_p
w(10)=8.868849279838838e-6_p
x(11)=13.12569119162649_p
w(11)=2.553211207670708e-6_p
x(12)=14.40353856919731_p
w(12)=7.034584620006208e-7_p
x(13)=15.64036301299262_p
w(13)=1.930143050936443e-7_p
x(14)=16.77599347448126_p
w(14)=5.504446600594036e-8_p
x(15)=17.74234992782795_p
w(15)=1.691065000549805e-8_p
x(16)=18.46970936590934_p
w(16)=5.581489751768854e-9_p
x(17)=18.89726487077012_p
w(17)=1.629019408487786e-9_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_19
