title: QM/MM Implementation

The current version of SIESTA has the capability of performing electron density
calculations under a potential generated by classical point charges. This is
known in  QM/MM as the _electrostatic embedding_ approach, which provides insight
on QM-region polarization due to the presence of the MM environment.

It is important to note that the interaction between QM and MM atoms tipically
has two components:

$$ E_{QMMM} = E_{QM-MM}^{elec} + E_{QM-MM}^{vdW} $$

SIESTA takes care of just the first of those to components. The second, usually
calculated as a simple Lennard-Jones potential, should be handled by the MM
engine.

## Communication with other MM engines.
Communication with MM engines is needed for the following pieces of information,
which change across the full length of a molecular dynamics simulation:

* Recieved by SIESTA from the MM program:
    * QM and MM atom positions
    * MM atom charges
    * Unit cell dimensions
* Sent by SIESTA to the MM program:
    * Forces computed over QM and MM atoms.
    * Stress

The most straightforward method of communication is just running SIESTA as
stand-alone (see the relevant QM/MM options), and then getting the forces and
stress compontents from the output. However, this can be highly inefficient
in terms of computational cost, since SIESTA needs to be restarted over and
over again.

A much better approach is to communicate through pipes or sockets; you can
take a look at SIESTA's own implementation for further reference. Within this
implementation, the following information is exchanged in every MD step:

* SIESTA receives (in order):
    1. The unit cell, as a double precision size 3x3 (in pipes) or 9
       (in sockets) array.
    2. The number of QM atoms N_qm, for verification purposes.
    3. The QM atom coordinates, as a double precision size 3xN_qm (in pipes) or
       3.N_qm (in sockets) array.
    4. A short 4-character string which is ignored unless it's equal to "last",
       indicating the last step of the MD. It is used to properly finalize
       SIESTA.
    5. The number of MM atoms, N_mm.
    6. MM Coordinates and charges:
        1. If using pipes, an array of size 4xN_mm, which contains in each
           column the coordinates x, y, z, and the partial charge of said atom.
        2. If using sockets, an array of size 3.N_mm containing the coordinates,
           followed by a second array of size N_mm containing the partial
           charges.

When using pipes, the above items 1-4 use a pipe different than the one used
for items 5-6. It is important to note that coordinates and cell vectors should
be in Bohr.

* SIESTA sends (in order):
    1. Total energy in Ry.
    2. Cell stress in Ry/Bohr^3, either in a size 3x3 (pipes) or 9 (sockets)
       double precision array.
    3. Number of QM atoms N_qm, for verification purposes.
    4. Forces over QM atoms in Ry/Bohr, either in a size 3xN_qm (pipes) or
       3.N_qm (sockets) double precision array.
    5. If the number of MM atoms is non-zero, sends N_mm for verification.
    6. If the number of MM atoms is non-zero, sends the forces over MM atoms
       in Ry/Bohr, either in a size 3xN_mm (pipes) or 3.N_mm (sockets) double
       precision array.

When using pipes, the above items are sent through a third pipe different
from the previous two. Please refer to the module [[qmmm_interface]] for
further details.

## Inner workings
SIESTA reads or receives information about QM and MM atoms during
initialization (see available options in the manual), and then enters the
regular calculation loop.

It calculates the electrostatic potential generated by point charges (Vpc) in
[[dhscf_init]] (see also [[qmmm_pcpot]]), and adds it to the SCF potential in
[[dhscf]] in each SCF step. At the final SCF step, when forces are calculated,
forces over MM atoms are also calculated with [[qmmm_mmforces]]. It is important
to note that this last call requires the _complete_ denisity, i.e. the total
electron density plus the ionic density. The nuclei-point charge interaction
is calculated via [[PcPotOnMesh]], and then the electrostatic potential Vpc is
subtracted from the Vscf potential before entering [[dfscf]].

Finally, in [[siesta_move]], forces are sent to the MM program. If it's no the
last step of the dynamics, then a new set of QM and MM region information is
expected and the above procedure is repeated.

The method for both the generation of the potential Vpc, and the calculation
of the forces over point charges involves the use of Ewald summations, with an
algorithm not unlike Particle Mesh Ewald. A simple cutoff is also available for
testing purposes, but not recommended since it does not take into account
periodic effects properly.

