// This file is @generated by prost-build.
/// ---
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Error {
    #[prost(uint32, tag = "1")]
    pub code: u32,
    #[prost(string, tag = "2")]
    pub error_info: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct PingRequest {
    #[prost(uint64, tag = "1")]
    pub version: u64,
    #[prost(bytes = "bytes", tag = "2")]
    pub body: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct PingResponse {
    #[prost(uint64, tag = "1")]
    pub version: u64,
    #[prost(bytes = "bytes", tag = "2")]
    pub body: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct HealBucketRequest {
    #[prost(string, tag = "1")]
    pub bucket: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub options: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct HealBucketResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListBucketRequest {
    #[prost(string, tag = "1")]
    pub options: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListBucketResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, repeated, tag = "2")]
    pub bucket_infos: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct MakeBucketRequest {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub options: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct MakeBucketResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetBucketInfoRequest {
    #[prost(string, tag = "1")]
    pub bucket: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub options: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetBucketInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub bucket_info: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteBucketRequest {
    #[prost(string, tag = "1")]
    pub bucket: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteBucketResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadAllRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadAllResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub data: ::prost::bytes::Bytes,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WriteAllRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(bytes = "bytes", tag = "4")]
    pub data: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WriteAllResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub options: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct VerifyFileRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub file_info: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct VerifyFileResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub check_parts_resp: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadPartsRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub bucket: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "3")]
    pub paths: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadPartsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub object_part_infos: ::prost::bytes::Bytes,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CheckPartsRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub file_info: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CheckPartsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub check_parts_resp: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct RenamePartRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub src_volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub src_path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub dst_volume: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub dst_path: ::prost::alloc::string::String,
    #[prost(bytes = "bytes", tag = "6")]
    pub meta: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct RenamePartResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct RenameFileRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub src_volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub src_path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub dst_volume: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub dst_path: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct RenameFileResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WriteRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(bool, tag = "4")]
    pub is_append: bool,
    #[prost(bytes = "bytes", tag = "5")]
    pub data: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WriteResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadAtRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(int64, tag = "4")]
    pub offset: i64,
    #[prost(int64, tag = "5")]
    pub length: i64,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadAtResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub data: ::prost::bytes::Bytes,
    #[prost(int64, tag = "3")]
    pub read_size: i64,
    #[prost(message, optional, tag = "4")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListDirRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub dir_path: ::prost::alloc::string::String,
    #[prost(int32, tag = "4")]
    pub count: i32,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListDirResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, repeated, tag = "2")]
    pub volumes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WalkDirRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(bytes = "bytes", tag = "2")]
    pub walk_dir_options: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WalkDirResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub meta_cache_entry: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct RenameDataRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub src_volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub src_path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub file_info: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub dst_volume: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub dst_path: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct RenameDataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub rename_data_resp: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct MakeVolumesRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub volumes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct MakeVolumesResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct MakeVolumeRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct MakeVolumeResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListVolumesRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ListVolumesResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, repeated, tag = "2")]
    pub volume_infos: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct StatVolumeRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct StatVolumeResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub volume_info: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeletePathsRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "3")]
    pub paths: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeletePathsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadMetadataRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadMetadataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
    #[prost(bytes = "bytes", tag = "3")]
    pub data: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct UpdateMetadataRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub file_info: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub opts: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct UpdateMetadataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WriteMetadataRequest {
    /// indicate which one in the disks
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub file_info: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct WriteMetadataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadVersionRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub version_id: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub opts: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadVersionResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub file_info: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadXlRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(bool, tag = "4")]
    pub read_data: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadXlResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub raw_file_info: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteVersionRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub file_info: ::prost::alloc::string::String,
    #[prost(bool, tag = "5")]
    pub force_del_marker: bool,
    #[prost(string, tag = "6")]
    pub opts: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteVersionResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub raw_file_info: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteVersionsRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "3")]
    pub versions: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "4")]
    pub opts: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteVersionsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, repeated, tag = "2")]
    pub errors: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadMultipleRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub read_multiple_req: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReadMultipleResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, repeated, tag = "2")]
    pub read_multiple_resps: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteVolumeRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub volume: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteVolumeResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<Error>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DiskInfoRequest {
    #[prost(string, tag = "1")]
    pub disk: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub opts: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DiskInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub disk_info: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<Error>,
}
/// lock api have same argument type
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GenerallyLockRequest {
    #[prost(string, tag = "1")]
    pub args: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GenerallyLockResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
    /// JSON serialized LockInfo
    #[prost(string, optional, tag = "3")]
    pub lock_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Mss {
    #[prost(map = "string, string", tag = "1")]
    pub value: ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LocalStorageInfoRequest {
    #[prost(bool, tag = "1")]
    pub metrics: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LocalStorageInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub storage_info: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ServerInfoRequest {
    #[prost(bool, tag = "1")]
    pub metrics: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ServerInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub server_properties: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetCpusRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetCpusResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub cpus: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetNetInfoRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetNetInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub net_info: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetPartitionsRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetPartitionsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub partitions: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetOsInfoRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetOsInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub os_info: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSeLinuxInfoRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSeLinuxInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub sys_services: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSysConfigRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSysConfigResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub sys_config: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSysErrorsRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSysErrorsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub sys_errors: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetMemInfoRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetMemInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub mem_info: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetMetricsRequest {
    #[prost(bytes = "bytes", tag = "1")]
    pub metric_type: ::prost::bytes::Bytes,
    #[prost(bytes = "bytes", tag = "2")]
    pub opts: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetMetricsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub realtime_metrics: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetProcInfoRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetProcInfoResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub proc_info: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct StartProfilingRequest {
    #[prost(string, tag = "1")]
    pub profiler: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct StartProfilingResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DownloadProfileDataRequest {}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DownloadProfileDataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(map = "string, bytes", tag = "2")]
    pub data: ::std::collections::HashMap<::prost::alloc::string::String, ::prost::bytes::Bytes>,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetBucketStatsDataRequest {
    #[prost(string, tag = "1")]
    pub bucket: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetBucketStatsDataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub bucket_stats: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSrMetricsDataRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetSrMetricsDataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub sr_metrics_summary: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetAllBucketStatsRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetAllBucketStatsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub bucket_stats_map: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadBucketMetadataRequest {
    #[prost(string, tag = "1")]
    pub bucket: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadBucketMetadataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteBucketMetadataRequest {
    #[prost(string, tag = "1")]
    pub bucket: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteBucketMetadataResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeletePolicyRequest {
    #[prost(string, tag = "1")]
    pub policy_name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeletePolicyResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadPolicyRequest {
    #[prost(string, tag = "1")]
    pub policy_name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadPolicyResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadPolicyMappingRequest {
    #[prost(string, tag = "1")]
    pub user_or_group: ::prost::alloc::string::String,
    #[prost(uint64, tag = "2")]
    pub user_type: u64,
    #[prost(bool, tag = "3")]
    pub is_group: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadPolicyMappingResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteUserRequest {
    #[prost(string, tag = "1")]
    pub access_key: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteUserResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteServiceAccountRequest {
    #[prost(string, tag = "1")]
    pub access_key: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteServiceAccountResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadUserRequest {
    #[prost(string, tag = "1")]
    pub access_key: ::prost::alloc::string::String,
    #[prost(bool, tag = "2")]
    pub temp: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadUserResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadServiceAccountRequest {
    #[prost(string, tag = "1")]
    pub access_key: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadServiceAccountResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadGroupRequest {
    #[prost(string, tag = "1")]
    pub group: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadGroupResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReloadSiteReplicationConfigRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReloadSiteReplicationConfigResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SignalServiceRequest {
    #[prost(message, optional, tag = "1")]
    pub vars: ::core::option::Option<Mss>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SignalServiceResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct BackgroundHealStatusRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct BackgroundHealStatusResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub bg_heal_state: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetMetacacheListingRequest {
    #[prost(bytes = "bytes", tag = "1")]
    pub opts: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetMetacacheListingResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub metacache: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct UpdateMetacacheListingRequest {
    #[prost(bytes = "bytes", tag = "1")]
    pub metacache: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct UpdateMetacacheListingResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(bytes = "bytes", tag = "2")]
    pub metacache: ::prost::bytes::Bytes,
    #[prost(string, optional, tag = "3")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReloadPoolMetaRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReloadPoolMetaResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct StopRebalanceRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct StopRebalanceResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadRebalanceMetaRequest {
    #[prost(bool, tag = "1")]
    pub start_rebalance: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadRebalanceMetaResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadTransitionTierConfigRequest {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LoadTransitionTierConfigResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, optional, tag = "2")]
    pub error_info: ::core::option::Option<::prost::alloc::string::String>,
}
/// Generated client implementations.
pub mod node_service_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::wildcard_imports, clippy::let_unit_value)]
    use tonic::codegen::http::Uri;
    use tonic::codegen::*;
    #[derive(Debug, Clone)]
    pub struct NodeServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl NodeServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> NodeServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(inner: T, interceptor: F) -> NodeServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                    http::Request<tonic::body::Body>,
                    Response = http::Response<<T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody>,
                >,
            <T as tonic::codegen::Service<http::Request<tonic::body::Body>>>::Error:
                Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            NodeServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// -------------------------------meta service--------------------------
        pub async fn ping(
            &mut self,
            request: impl tonic::IntoRequest<super::PingRequest>,
        ) -> std::result::Result<tonic::Response<super::PingResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/Ping");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "Ping"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn heal_bucket(
            &mut self,
            request: impl tonic::IntoRequest<super::HealBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::HealBucketResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/HealBucket");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "HealBucket"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn list_bucket(
            &mut self,
            request: impl tonic::IntoRequest<super::ListBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::ListBucketResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ListBucket");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ListBucket"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn make_bucket(
            &mut self,
            request: impl tonic::IntoRequest<super::MakeBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::MakeBucketResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/MakeBucket");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "MakeBucket"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_bucket_info(
            &mut self,
            request: impl tonic::IntoRequest<super::GetBucketInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetBucketInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetBucketInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetBucketInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_bucket(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteBucketResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeleteBucket");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeleteBucket"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn read_all(
            &mut self,
            request: impl tonic::IntoRequest<super::ReadAllRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadAllResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReadAll");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReadAll"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn write_all(
            &mut self,
            request: impl tonic::IntoRequest<super::WriteAllRequest>,
        ) -> std::result::Result<tonic::Response<super::WriteAllResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/WriteAll");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "WriteAll"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/Delete");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "Delete"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn verify_file(
            &mut self,
            request: impl tonic::IntoRequest<super::VerifyFileRequest>,
        ) -> std::result::Result<tonic::Response<super::VerifyFileResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/VerifyFile");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "VerifyFile"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn read_parts(
            &mut self,
            request: impl tonic::IntoRequest<super::ReadPartsRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadPartsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReadParts");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReadParts"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn check_parts(
            &mut self,
            request: impl tonic::IntoRequest<super::CheckPartsRequest>,
        ) -> std::result::Result<tonic::Response<super::CheckPartsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/CheckParts");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "CheckParts"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn rename_part(
            &mut self,
            request: impl tonic::IntoRequest<super::RenamePartRequest>,
        ) -> std::result::Result<tonic::Response<super::RenamePartResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/RenamePart");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "RenamePart"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn rename_file(
            &mut self,
            request: impl tonic::IntoRequest<super::RenameFileRequest>,
        ) -> std::result::Result<tonic::Response<super::RenameFileResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/RenameFile");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "RenameFile"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn write(
            &mut self,
            request: impl tonic::IntoRequest<super::WriteRequest>,
        ) -> std::result::Result<tonic::Response<super::WriteResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/Write");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "Write"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn write_stream(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::WriteRequest>,
        ) -> std::result::Result<tonic::Response<tonic::codec::Streaming<super::WriteResponse>>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/WriteStream");
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "WriteStream"));
            self.inner.streaming(req, path, codec).await
        }
        /// rpc Append(AppendRequest) returns (AppendResponse) {};
        pub async fn read_at(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::ReadAtRequest>,
        ) -> std::result::Result<tonic::Response<tonic::codec::Streaming<super::ReadAtResponse>>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReadAt");
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReadAt"));
            self.inner.streaming(req, path, codec).await
        }
        pub async fn list_dir(
            &mut self,
            request: impl tonic::IntoRequest<super::ListDirRequest>,
        ) -> std::result::Result<tonic::Response<super::ListDirResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ListDir");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ListDir"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn walk_dir(
            &mut self,
            request: impl tonic::IntoRequest<super::WalkDirRequest>,
        ) -> std::result::Result<tonic::Response<tonic::codec::Streaming<super::WalkDirResponse>>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/WalkDir");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "WalkDir"));
            self.inner.server_streaming(req, path, codec).await
        }
        pub async fn rename_data(
            &mut self,
            request: impl tonic::IntoRequest<super::RenameDataRequest>,
        ) -> std::result::Result<tonic::Response<super::RenameDataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/RenameData");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "RenameData"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn make_volumes(
            &mut self,
            request: impl tonic::IntoRequest<super::MakeVolumesRequest>,
        ) -> std::result::Result<tonic::Response<super::MakeVolumesResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/MakeVolumes");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "MakeVolumes"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn make_volume(
            &mut self,
            request: impl tonic::IntoRequest<super::MakeVolumeRequest>,
        ) -> std::result::Result<tonic::Response<super::MakeVolumeResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/MakeVolume");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "MakeVolume"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn list_volumes(
            &mut self,
            request: impl tonic::IntoRequest<super::ListVolumesRequest>,
        ) -> std::result::Result<tonic::Response<super::ListVolumesResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ListVolumes");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ListVolumes"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn stat_volume(
            &mut self,
            request: impl tonic::IntoRequest<super::StatVolumeRequest>,
        ) -> std::result::Result<tonic::Response<super::StatVolumeResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/StatVolume");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "StatVolume"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_paths(
            &mut self,
            request: impl tonic::IntoRequest<super::DeletePathsRequest>,
        ) -> std::result::Result<tonic::Response<super::DeletePathsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeletePaths");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeletePaths"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn update_metadata(
            &mut self,
            request: impl tonic::IntoRequest<super::UpdateMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::UpdateMetadataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/UpdateMetadata");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "UpdateMetadata"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn read_metadata(
            &mut self,
            request: impl tonic::IntoRequest<super::ReadMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadMetadataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReadMetadata");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReadMetadata"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn write_metadata(
            &mut self,
            request: impl tonic::IntoRequest<super::WriteMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::WriteMetadataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/WriteMetadata");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "WriteMetadata"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn read_version(
            &mut self,
            request: impl tonic::IntoRequest<super::ReadVersionRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadVersionResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReadVersion");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReadVersion"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn read_xl(
            &mut self,
            request: impl tonic::IntoRequest<super::ReadXlRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadXlResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReadXL");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReadXL"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_version(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteVersionRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteVersionResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeleteVersion");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeleteVersion"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_versions(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteVersionsRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteVersionsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeleteVersions");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeleteVersions"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn read_multiple(
            &mut self,
            request: impl tonic::IntoRequest<super::ReadMultipleRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadMultipleResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReadMultiple");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReadMultiple"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_volume(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteVolumeRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteVolumeResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeleteVolume");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeleteVolume"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn disk_info(
            &mut self,
            request: impl tonic::IntoRequest<super::DiskInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::DiskInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DiskInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DiskInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn lock(
            &mut self,
            request: impl tonic::IntoRequest<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/Lock");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "Lock"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn un_lock(
            &mut self,
            request: impl tonic::IntoRequest<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/UnLock");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "UnLock"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn force_un_lock(
            &mut self,
            request: impl tonic::IntoRequest<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ForceUnLock");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ForceUnLock"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn refresh(
            &mut self,
            request: impl tonic::IntoRequest<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/Refresh");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "Refresh"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn local_storage_info(
            &mut self,
            request: impl tonic::IntoRequest<super::LocalStorageInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::LocalStorageInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LocalStorageInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LocalStorageInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn server_info(
            &mut self,
            request: impl tonic::IntoRequest<super::ServerInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::ServerInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ServerInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ServerInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_cpus(
            &mut self,
            request: impl tonic::IntoRequest<super::GetCpusRequest>,
        ) -> std::result::Result<tonic::Response<super::GetCpusResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetCpus");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetCpus"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_net_info(
            &mut self,
            request: impl tonic::IntoRequest<super::GetNetInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetNetInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetNetInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetNetInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_partitions(
            &mut self,
            request: impl tonic::IntoRequest<super::GetPartitionsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetPartitionsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetPartitions");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetPartitions"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_os_info(
            &mut self,
            request: impl tonic::IntoRequest<super::GetOsInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetOsInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetOsInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetOsInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_se_linux_info(
            &mut self,
            request: impl tonic::IntoRequest<super::GetSeLinuxInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSeLinuxInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetSELinuxInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetSELinuxInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_sys_config(
            &mut self,
            request: impl tonic::IntoRequest<super::GetSysConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSysConfigResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetSysConfig");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetSysConfig"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_sys_errors(
            &mut self,
            request: impl tonic::IntoRequest<super::GetSysErrorsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSysErrorsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetSysErrors");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetSysErrors"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_mem_info(
            &mut self,
            request: impl tonic::IntoRequest<super::GetMemInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetMemInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetMemInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetMemInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_metrics(
            &mut self,
            request: impl tonic::IntoRequest<super::GetMetricsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetMetricsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetMetrics");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetMetrics"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_proc_info(
            &mut self,
            request: impl tonic::IntoRequest<super::GetProcInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetProcInfoResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetProcInfo");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetProcInfo"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn start_profiling(
            &mut self,
            request: impl tonic::IntoRequest<super::StartProfilingRequest>,
        ) -> std::result::Result<tonic::Response<super::StartProfilingResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/StartProfiling");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "StartProfiling"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn download_profile_data(
            &mut self,
            request: impl tonic::IntoRequest<super::DownloadProfileDataRequest>,
        ) -> std::result::Result<tonic::Response<super::DownloadProfileDataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DownloadProfileData");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DownloadProfileData"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_bucket_stats(
            &mut self,
            request: impl tonic::IntoRequest<super::GetBucketStatsDataRequest>,
        ) -> std::result::Result<tonic::Response<super::GetBucketStatsDataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetBucketStats");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetBucketStats"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_sr_metrics(
            &mut self,
            request: impl tonic::IntoRequest<super::GetSrMetricsDataRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSrMetricsDataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetSRMetrics");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetSRMetrics"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_all_bucket_stats(
            &mut self,
            request: impl tonic::IntoRequest<super::GetAllBucketStatsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetAllBucketStatsResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetAllBucketStats");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetAllBucketStats"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_bucket_metadata(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadBucketMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadBucketMetadataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadBucketMetadata");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadBucketMetadata"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_bucket_metadata(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteBucketMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteBucketMetadataResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeleteBucketMetadata");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeleteBucketMetadata"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_policy(
            &mut self,
            request: impl tonic::IntoRequest<super::DeletePolicyRequest>,
        ) -> std::result::Result<tonic::Response<super::DeletePolicyResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeletePolicy");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeletePolicy"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_policy(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadPolicyRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadPolicyResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadPolicy");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadPolicy"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_policy_mapping(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadPolicyMappingRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadPolicyMappingResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadPolicyMapping");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadPolicyMapping"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_user(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteUserRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteUserResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeleteUser");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeleteUser"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn delete_service_account(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteServiceAccountRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteServiceAccountResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/DeleteServiceAccount");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "DeleteServiceAccount"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_user(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadUserRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadUserResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadUser");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadUser"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_service_account(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadServiceAccountRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadServiceAccountResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadServiceAccount");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadServiceAccount"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_group(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadGroupRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadGroupResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadGroup");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadGroup"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn reload_site_replication_config(
            &mut self,
            request: impl tonic::IntoRequest<super::ReloadSiteReplicationConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::ReloadSiteReplicationConfigResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReloadSiteReplicationConfig");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReloadSiteReplicationConfig"));
            self.inner.unary(req, path, codec).await
        }
        /// rpc VerifyBinary() returns () {};
        /// rpc CommitBinary() returns () {};
        pub async fn signal_service(
            &mut self,
            request: impl tonic::IntoRequest<super::SignalServiceRequest>,
        ) -> std::result::Result<tonic::Response<super::SignalServiceResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/SignalService");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "SignalService"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn background_heal_status(
            &mut self,
            request: impl tonic::IntoRequest<super::BackgroundHealStatusRequest>,
        ) -> std::result::Result<tonic::Response<super::BackgroundHealStatusResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/BackgroundHealStatus");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "BackgroundHealStatus"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_metacache_listing(
            &mut self,
            request: impl tonic::IntoRequest<super::GetMetacacheListingRequest>,
        ) -> std::result::Result<tonic::Response<super::GetMetacacheListingResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/GetMetacacheListing");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "GetMetacacheListing"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn update_metacache_listing(
            &mut self,
            request: impl tonic::IntoRequest<super::UpdateMetacacheListingRequest>,
        ) -> std::result::Result<tonic::Response<super::UpdateMetacacheListingResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/UpdateMetacacheListing");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "UpdateMetacacheListing"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn reload_pool_meta(
            &mut self,
            request: impl tonic::IntoRequest<super::ReloadPoolMetaRequest>,
        ) -> std::result::Result<tonic::Response<super::ReloadPoolMetaResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/ReloadPoolMeta");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "ReloadPoolMeta"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn stop_rebalance(
            &mut self,
            request: impl tonic::IntoRequest<super::StopRebalanceRequest>,
        ) -> std::result::Result<tonic::Response<super::StopRebalanceResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/StopRebalance");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "StopRebalance"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_rebalance_meta(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadRebalanceMetaRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadRebalanceMetaResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadRebalanceMeta");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadRebalanceMeta"));
            self.inner.unary(req, path, codec).await
        }
        pub async fn load_transition_tier_config(
            &mut self,
            request: impl tonic::IntoRequest<super::LoadTransitionTierConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadTransitionTierConfigResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| tonic::Status::unknown(format!("Service was not ready: {}", e.into())))?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/node_service.NodeService/LoadTransitionTierConfig");
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("node_service.NodeService", "LoadTransitionTierConfig"));
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod node_service_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::wildcard_imports, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with NodeServiceServer.
    #[async_trait]
    pub trait NodeService: std::marker::Send + std::marker::Sync + 'static {
        /// -------------------------------meta service--------------------------
        async fn ping(
            &self,
            request: tonic::Request<super::PingRequest>,
        ) -> std::result::Result<tonic::Response<super::PingResponse>, tonic::Status>;
        async fn heal_bucket(
            &self,
            request: tonic::Request<super::HealBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::HealBucketResponse>, tonic::Status>;
        async fn list_bucket(
            &self,
            request: tonic::Request<super::ListBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::ListBucketResponse>, tonic::Status>;
        async fn make_bucket(
            &self,
            request: tonic::Request<super::MakeBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::MakeBucketResponse>, tonic::Status>;
        async fn get_bucket_info(
            &self,
            request: tonic::Request<super::GetBucketInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetBucketInfoResponse>, tonic::Status>;
        async fn delete_bucket(
            &self,
            request: tonic::Request<super::DeleteBucketRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteBucketResponse>, tonic::Status>;
        async fn read_all(
            &self,
            request: tonic::Request<super::ReadAllRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadAllResponse>, tonic::Status>;
        async fn write_all(
            &self,
            request: tonic::Request<super::WriteAllRequest>,
        ) -> std::result::Result<tonic::Response<super::WriteAllResponse>, tonic::Status>;
        async fn delete(
            &self,
            request: tonic::Request<super::DeleteRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteResponse>, tonic::Status>;
        async fn verify_file(
            &self,
            request: tonic::Request<super::VerifyFileRequest>,
        ) -> std::result::Result<tonic::Response<super::VerifyFileResponse>, tonic::Status>;
        async fn read_parts(
            &self,
            request: tonic::Request<super::ReadPartsRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadPartsResponse>, tonic::Status>;
        async fn check_parts(
            &self,
            request: tonic::Request<super::CheckPartsRequest>,
        ) -> std::result::Result<tonic::Response<super::CheckPartsResponse>, tonic::Status>;
        async fn rename_part(
            &self,
            request: tonic::Request<super::RenamePartRequest>,
        ) -> std::result::Result<tonic::Response<super::RenamePartResponse>, tonic::Status>;
        async fn rename_file(
            &self,
            request: tonic::Request<super::RenameFileRequest>,
        ) -> std::result::Result<tonic::Response<super::RenameFileResponse>, tonic::Status>;
        async fn write(
            &self,
            request: tonic::Request<super::WriteRequest>,
        ) -> std::result::Result<tonic::Response<super::WriteResponse>, tonic::Status>;
        /// Server streaming response type for the WriteStream method.
        type WriteStreamStream: tonic::codegen::tokio_stream::Stream<Item = std::result::Result<super::WriteResponse, tonic::Status>>
            + std::marker::Send
            + 'static;
        async fn write_stream(
            &self,
            request: tonic::Request<tonic::Streaming<super::WriteRequest>>,
        ) -> std::result::Result<tonic::Response<Self::WriteStreamStream>, tonic::Status>;
        /// Server streaming response type for the ReadAt method.
        type ReadAtStream: tonic::codegen::tokio_stream::Stream<Item = std::result::Result<super::ReadAtResponse, tonic::Status>>
            + std::marker::Send
            + 'static;
        /// rpc Append(AppendRequest) returns (AppendResponse) {};
        async fn read_at(
            &self,
            request: tonic::Request<tonic::Streaming<super::ReadAtRequest>>,
        ) -> std::result::Result<tonic::Response<Self::ReadAtStream>, tonic::Status>;
        async fn list_dir(
            &self,
            request: tonic::Request<super::ListDirRequest>,
        ) -> std::result::Result<tonic::Response<super::ListDirResponse>, tonic::Status>;
        /// Server streaming response type for the WalkDir method.
        type WalkDirStream: tonic::codegen::tokio_stream::Stream<Item = std::result::Result<super::WalkDirResponse, tonic::Status>>
            + std::marker::Send
            + 'static;
        async fn walk_dir(
            &self,
            request: tonic::Request<super::WalkDirRequest>,
        ) -> std::result::Result<tonic::Response<Self::WalkDirStream>, tonic::Status>;
        async fn rename_data(
            &self,
            request: tonic::Request<super::RenameDataRequest>,
        ) -> std::result::Result<tonic::Response<super::RenameDataResponse>, tonic::Status>;
        async fn make_volumes(
            &self,
            request: tonic::Request<super::MakeVolumesRequest>,
        ) -> std::result::Result<tonic::Response<super::MakeVolumesResponse>, tonic::Status>;
        async fn make_volume(
            &self,
            request: tonic::Request<super::MakeVolumeRequest>,
        ) -> std::result::Result<tonic::Response<super::MakeVolumeResponse>, tonic::Status>;
        async fn list_volumes(
            &self,
            request: tonic::Request<super::ListVolumesRequest>,
        ) -> std::result::Result<tonic::Response<super::ListVolumesResponse>, tonic::Status>;
        async fn stat_volume(
            &self,
            request: tonic::Request<super::StatVolumeRequest>,
        ) -> std::result::Result<tonic::Response<super::StatVolumeResponse>, tonic::Status>;
        async fn delete_paths(
            &self,
            request: tonic::Request<super::DeletePathsRequest>,
        ) -> std::result::Result<tonic::Response<super::DeletePathsResponse>, tonic::Status>;
        async fn update_metadata(
            &self,
            request: tonic::Request<super::UpdateMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::UpdateMetadataResponse>, tonic::Status>;
        async fn read_metadata(
            &self,
            request: tonic::Request<super::ReadMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadMetadataResponse>, tonic::Status>;
        async fn write_metadata(
            &self,
            request: tonic::Request<super::WriteMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::WriteMetadataResponse>, tonic::Status>;
        async fn read_version(
            &self,
            request: tonic::Request<super::ReadVersionRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadVersionResponse>, tonic::Status>;
        async fn read_xl(
            &self,
            request: tonic::Request<super::ReadXlRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadXlResponse>, tonic::Status>;
        async fn delete_version(
            &self,
            request: tonic::Request<super::DeleteVersionRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteVersionResponse>, tonic::Status>;
        async fn delete_versions(
            &self,
            request: tonic::Request<super::DeleteVersionsRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteVersionsResponse>, tonic::Status>;
        async fn read_multiple(
            &self,
            request: tonic::Request<super::ReadMultipleRequest>,
        ) -> std::result::Result<tonic::Response<super::ReadMultipleResponse>, tonic::Status>;
        async fn delete_volume(
            &self,
            request: tonic::Request<super::DeleteVolumeRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteVolumeResponse>, tonic::Status>;
        async fn disk_info(
            &self,
            request: tonic::Request<super::DiskInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::DiskInfoResponse>, tonic::Status>;
        async fn lock(
            &self,
            request: tonic::Request<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status>;
        async fn un_lock(
            &self,
            request: tonic::Request<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status>;
        async fn force_un_lock(
            &self,
            request: tonic::Request<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status>;
        async fn refresh(
            &self,
            request: tonic::Request<super::GenerallyLockRequest>,
        ) -> std::result::Result<tonic::Response<super::GenerallyLockResponse>, tonic::Status>;
        async fn local_storage_info(
            &self,
            request: tonic::Request<super::LocalStorageInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::LocalStorageInfoResponse>, tonic::Status>;
        async fn server_info(
            &self,
            request: tonic::Request<super::ServerInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::ServerInfoResponse>, tonic::Status>;
        async fn get_cpus(
            &self,
            request: tonic::Request<super::GetCpusRequest>,
        ) -> std::result::Result<tonic::Response<super::GetCpusResponse>, tonic::Status>;
        async fn get_net_info(
            &self,
            request: tonic::Request<super::GetNetInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetNetInfoResponse>, tonic::Status>;
        async fn get_partitions(
            &self,
            request: tonic::Request<super::GetPartitionsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetPartitionsResponse>, tonic::Status>;
        async fn get_os_info(
            &self,
            request: tonic::Request<super::GetOsInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetOsInfoResponse>, tonic::Status>;
        async fn get_se_linux_info(
            &self,
            request: tonic::Request<super::GetSeLinuxInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSeLinuxInfoResponse>, tonic::Status>;
        async fn get_sys_config(
            &self,
            request: tonic::Request<super::GetSysConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSysConfigResponse>, tonic::Status>;
        async fn get_sys_errors(
            &self,
            request: tonic::Request<super::GetSysErrorsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSysErrorsResponse>, tonic::Status>;
        async fn get_mem_info(
            &self,
            request: tonic::Request<super::GetMemInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetMemInfoResponse>, tonic::Status>;
        async fn get_metrics(
            &self,
            request: tonic::Request<super::GetMetricsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetMetricsResponse>, tonic::Status>;
        async fn get_proc_info(
            &self,
            request: tonic::Request<super::GetProcInfoRequest>,
        ) -> std::result::Result<tonic::Response<super::GetProcInfoResponse>, tonic::Status>;
        async fn start_profiling(
            &self,
            request: tonic::Request<super::StartProfilingRequest>,
        ) -> std::result::Result<tonic::Response<super::StartProfilingResponse>, tonic::Status>;
        async fn download_profile_data(
            &self,
            request: tonic::Request<super::DownloadProfileDataRequest>,
        ) -> std::result::Result<tonic::Response<super::DownloadProfileDataResponse>, tonic::Status>;
        async fn get_bucket_stats(
            &self,
            request: tonic::Request<super::GetBucketStatsDataRequest>,
        ) -> std::result::Result<tonic::Response<super::GetBucketStatsDataResponse>, tonic::Status>;
        async fn get_sr_metrics(
            &self,
            request: tonic::Request<super::GetSrMetricsDataRequest>,
        ) -> std::result::Result<tonic::Response<super::GetSrMetricsDataResponse>, tonic::Status>;
        async fn get_all_bucket_stats(
            &self,
            request: tonic::Request<super::GetAllBucketStatsRequest>,
        ) -> std::result::Result<tonic::Response<super::GetAllBucketStatsResponse>, tonic::Status>;
        async fn load_bucket_metadata(
            &self,
            request: tonic::Request<super::LoadBucketMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadBucketMetadataResponse>, tonic::Status>;
        async fn delete_bucket_metadata(
            &self,
            request: tonic::Request<super::DeleteBucketMetadataRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteBucketMetadataResponse>, tonic::Status>;
        async fn delete_policy(
            &self,
            request: tonic::Request<super::DeletePolicyRequest>,
        ) -> std::result::Result<tonic::Response<super::DeletePolicyResponse>, tonic::Status>;
        async fn load_policy(
            &self,
            request: tonic::Request<super::LoadPolicyRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadPolicyResponse>, tonic::Status>;
        async fn load_policy_mapping(
            &self,
            request: tonic::Request<super::LoadPolicyMappingRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadPolicyMappingResponse>, tonic::Status>;
        async fn delete_user(
            &self,
            request: tonic::Request<super::DeleteUserRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteUserResponse>, tonic::Status>;
        async fn delete_service_account(
            &self,
            request: tonic::Request<super::DeleteServiceAccountRequest>,
        ) -> std::result::Result<tonic::Response<super::DeleteServiceAccountResponse>, tonic::Status>;
        async fn load_user(
            &self,
            request: tonic::Request<super::LoadUserRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadUserResponse>, tonic::Status>;
        async fn load_service_account(
            &self,
            request: tonic::Request<super::LoadServiceAccountRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadServiceAccountResponse>, tonic::Status>;
        async fn load_group(
            &self,
            request: tonic::Request<super::LoadGroupRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadGroupResponse>, tonic::Status>;
        async fn reload_site_replication_config(
            &self,
            request: tonic::Request<super::ReloadSiteReplicationConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::ReloadSiteReplicationConfigResponse>, tonic::Status>;
        /// rpc VerifyBinary() returns () {};
        /// rpc CommitBinary() returns () {};
        async fn signal_service(
            &self,
            request: tonic::Request<super::SignalServiceRequest>,
        ) -> std::result::Result<tonic::Response<super::SignalServiceResponse>, tonic::Status>;
        async fn background_heal_status(
            &self,
            request: tonic::Request<super::BackgroundHealStatusRequest>,
        ) -> std::result::Result<tonic::Response<super::BackgroundHealStatusResponse>, tonic::Status>;
        async fn get_metacache_listing(
            &self,
            request: tonic::Request<super::GetMetacacheListingRequest>,
        ) -> std::result::Result<tonic::Response<super::GetMetacacheListingResponse>, tonic::Status>;
        async fn update_metacache_listing(
            &self,
            request: tonic::Request<super::UpdateMetacacheListingRequest>,
        ) -> std::result::Result<tonic::Response<super::UpdateMetacacheListingResponse>, tonic::Status>;
        async fn reload_pool_meta(
            &self,
            request: tonic::Request<super::ReloadPoolMetaRequest>,
        ) -> std::result::Result<tonic::Response<super::ReloadPoolMetaResponse>, tonic::Status>;
        async fn stop_rebalance(
            &self,
            request: tonic::Request<super::StopRebalanceRequest>,
        ) -> std::result::Result<tonic::Response<super::StopRebalanceResponse>, tonic::Status>;
        async fn load_rebalance_meta(
            &self,
            request: tonic::Request<super::LoadRebalanceMetaRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadRebalanceMetaResponse>, tonic::Status>;
        async fn load_transition_tier_config(
            &self,
            request: tonic::Request<super::LoadTransitionTierConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::LoadTransitionTierConfigResponse>, tonic::Status>;
    }
    #[derive(Debug)]
    pub struct NodeServiceServer<T> {
        inner: Arc<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    impl<T> NodeServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(inner: T, interceptor: F) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for NodeServiceServer<T>
    where
        T: NodeService,
        B: Body + std::marker::Send + 'static,
        B::Error: Into<StdError> + std::marker::Send + 'static,
    {
        type Response = http::Response<tonic::body::Body>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(&mut self, _cx: &mut Context<'_>) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            match req.uri().path() {
                "/node_service.NodeService/Ping" => {
                    #[allow(non_camel_case_types)]
                    struct PingSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::PingRequest> for PingSvc<T> {
                        type Response = super::PingResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::PingRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::ping(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = PingSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/HealBucket" => {
                    #[allow(non_camel_case_types)]
                    struct HealBucketSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::HealBucketRequest> for HealBucketSvc<T> {
                        type Response = super::HealBucketResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::HealBucketRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::heal_bucket(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = HealBucketSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ListBucket" => {
                    #[allow(non_camel_case_types)]
                    struct ListBucketSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ListBucketRequest> for ListBucketSvc<T> {
                        type Response = super::ListBucketResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ListBucketRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::list_bucket(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ListBucketSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/MakeBucket" => {
                    #[allow(non_camel_case_types)]
                    struct MakeBucketSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::MakeBucketRequest> for MakeBucketSvc<T> {
                        type Response = super::MakeBucketResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::MakeBucketRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::make_bucket(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = MakeBucketSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetBucketInfo" => {
                    #[allow(non_camel_case_types)]
                    struct GetBucketInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetBucketInfoRequest> for GetBucketInfoSvc<T> {
                        type Response = super::GetBucketInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetBucketInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_bucket_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetBucketInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeleteBucket" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteBucketSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteBucketRequest> for DeleteBucketSvc<T> {
                        type Response = super::DeleteBucketResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteBucketRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_bucket(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteBucketSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReadAll" => {
                    #[allow(non_camel_case_types)]
                    struct ReadAllSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReadAllRequest> for ReadAllSvc<T> {
                        type Response = super::ReadAllResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReadAllRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::read_all(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReadAllSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/WriteAll" => {
                    #[allow(non_camel_case_types)]
                    struct WriteAllSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::WriteAllRequest> for WriteAllSvc<T> {
                        type Response = super::WriteAllResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::WriteAllRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::write_all(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = WriteAllSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/Delete" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteRequest> for DeleteSvc<T> {
                        type Response = super::DeleteResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/VerifyFile" => {
                    #[allow(non_camel_case_types)]
                    struct VerifyFileSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::VerifyFileRequest> for VerifyFileSvc<T> {
                        type Response = super::VerifyFileResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::VerifyFileRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::verify_file(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = VerifyFileSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReadParts" => {
                    #[allow(non_camel_case_types)]
                    struct ReadPartsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReadPartsRequest> for ReadPartsSvc<T> {
                        type Response = super::ReadPartsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReadPartsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::read_parts(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReadPartsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/CheckParts" => {
                    #[allow(non_camel_case_types)]
                    struct CheckPartsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::CheckPartsRequest> for CheckPartsSvc<T> {
                        type Response = super::CheckPartsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::CheckPartsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::check_parts(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = CheckPartsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/RenamePart" => {
                    #[allow(non_camel_case_types)]
                    struct RenamePartSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::RenamePartRequest> for RenamePartSvc<T> {
                        type Response = super::RenamePartResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::RenamePartRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::rename_part(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = RenamePartSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/RenameFile" => {
                    #[allow(non_camel_case_types)]
                    struct RenameFileSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::RenameFileRequest> for RenameFileSvc<T> {
                        type Response = super::RenameFileResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::RenameFileRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::rename_file(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = RenameFileSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/Write" => {
                    #[allow(non_camel_case_types)]
                    struct WriteSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::WriteRequest> for WriteSvc<T> {
                        type Response = super::WriteResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::WriteRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::write(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = WriteSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/WriteStream" => {
                    #[allow(non_camel_case_types)]
                    struct WriteStreamSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::StreamingService<super::WriteRequest> for WriteStreamSvc<T> {
                        type Response = super::WriteResponse;
                        type ResponseStream = T::WriteStreamStream;
                        type Future = BoxFuture<tonic::Response<Self::ResponseStream>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<tonic::Streaming<super::WriteRequest>>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::write_stream(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = WriteStreamSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReadAt" => {
                    #[allow(non_camel_case_types)]
                    struct ReadAtSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::StreamingService<super::ReadAtRequest> for ReadAtSvc<T> {
                        type Response = super::ReadAtResponse;
                        type ResponseStream = T::ReadAtStream;
                        type Future = BoxFuture<tonic::Response<Self::ResponseStream>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<tonic::Streaming<super::ReadAtRequest>>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::read_at(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReadAtSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ListDir" => {
                    #[allow(non_camel_case_types)]
                    struct ListDirSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ListDirRequest> for ListDirSvc<T> {
                        type Response = super::ListDirResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ListDirRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::list_dir(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ListDirSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/WalkDir" => {
                    #[allow(non_camel_case_types)]
                    struct WalkDirSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::ServerStreamingService<super::WalkDirRequest> for WalkDirSvc<T> {
                        type Response = super::WalkDirResponse;
                        type ResponseStream = T::WalkDirStream;
                        type Future = BoxFuture<tonic::Response<Self::ResponseStream>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::WalkDirRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::walk_dir(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = WalkDirSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/RenameData" => {
                    #[allow(non_camel_case_types)]
                    struct RenameDataSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::RenameDataRequest> for RenameDataSvc<T> {
                        type Response = super::RenameDataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::RenameDataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::rename_data(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = RenameDataSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/MakeVolumes" => {
                    #[allow(non_camel_case_types)]
                    struct MakeVolumesSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::MakeVolumesRequest> for MakeVolumesSvc<T> {
                        type Response = super::MakeVolumesResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::MakeVolumesRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::make_volumes(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = MakeVolumesSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/MakeVolume" => {
                    #[allow(non_camel_case_types)]
                    struct MakeVolumeSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::MakeVolumeRequest> for MakeVolumeSvc<T> {
                        type Response = super::MakeVolumeResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::MakeVolumeRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::make_volume(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = MakeVolumeSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ListVolumes" => {
                    #[allow(non_camel_case_types)]
                    struct ListVolumesSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ListVolumesRequest> for ListVolumesSvc<T> {
                        type Response = super::ListVolumesResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ListVolumesRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::list_volumes(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ListVolumesSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/StatVolume" => {
                    #[allow(non_camel_case_types)]
                    struct StatVolumeSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::StatVolumeRequest> for StatVolumeSvc<T> {
                        type Response = super::StatVolumeResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::StatVolumeRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::stat_volume(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = StatVolumeSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeletePaths" => {
                    #[allow(non_camel_case_types)]
                    struct DeletePathsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeletePathsRequest> for DeletePathsSvc<T> {
                        type Response = super::DeletePathsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeletePathsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_paths(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeletePathsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/UpdateMetadata" => {
                    #[allow(non_camel_case_types)]
                    struct UpdateMetadataSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::UpdateMetadataRequest> for UpdateMetadataSvc<T> {
                        type Response = super::UpdateMetadataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::UpdateMetadataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::update_metadata(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = UpdateMetadataSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReadMetadata" => {
                    #[allow(non_camel_case_types)]
                    struct ReadMetadataSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReadMetadataRequest> for ReadMetadataSvc<T> {
                        type Response = super::ReadMetadataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReadMetadataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::read_metadata(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReadMetadataSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/WriteMetadata" => {
                    #[allow(non_camel_case_types)]
                    struct WriteMetadataSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::WriteMetadataRequest> for WriteMetadataSvc<T> {
                        type Response = super::WriteMetadataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::WriteMetadataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::write_metadata(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = WriteMetadataSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReadVersion" => {
                    #[allow(non_camel_case_types)]
                    struct ReadVersionSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReadVersionRequest> for ReadVersionSvc<T> {
                        type Response = super::ReadVersionResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReadVersionRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::read_version(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReadVersionSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReadXL" => {
                    #[allow(non_camel_case_types)]
                    struct ReadXLSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReadXlRequest> for ReadXLSvc<T> {
                        type Response = super::ReadXlResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReadXlRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::read_xl(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReadXLSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeleteVersion" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteVersionSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteVersionRequest> for DeleteVersionSvc<T> {
                        type Response = super::DeleteVersionResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteVersionRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_version(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteVersionSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeleteVersions" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteVersionsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteVersionsRequest> for DeleteVersionsSvc<T> {
                        type Response = super::DeleteVersionsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteVersionsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_versions(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteVersionsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReadMultiple" => {
                    #[allow(non_camel_case_types)]
                    struct ReadMultipleSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReadMultipleRequest> for ReadMultipleSvc<T> {
                        type Response = super::ReadMultipleResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReadMultipleRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::read_multiple(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReadMultipleSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeleteVolume" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteVolumeSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteVolumeRequest> for DeleteVolumeSvc<T> {
                        type Response = super::DeleteVolumeResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteVolumeRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_volume(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteVolumeSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DiskInfo" => {
                    #[allow(non_camel_case_types)]
                    struct DiskInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DiskInfoRequest> for DiskInfoSvc<T> {
                        type Response = super::DiskInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DiskInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::disk_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DiskInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/Lock" => {
                    #[allow(non_camel_case_types)]
                    struct LockSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GenerallyLockRequest> for LockSvc<T> {
                        type Response = super::GenerallyLockResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GenerallyLockRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::lock(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LockSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/UnLock" => {
                    #[allow(non_camel_case_types)]
                    struct UnLockSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GenerallyLockRequest> for UnLockSvc<T> {
                        type Response = super::GenerallyLockResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GenerallyLockRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::un_lock(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = UnLockSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ForceUnLock" => {
                    #[allow(non_camel_case_types)]
                    struct ForceUnLockSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GenerallyLockRequest> for ForceUnLockSvc<T> {
                        type Response = super::GenerallyLockResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GenerallyLockRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::force_un_lock(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ForceUnLockSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/Refresh" => {
                    #[allow(non_camel_case_types)]
                    struct RefreshSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GenerallyLockRequest> for RefreshSvc<T> {
                        type Response = super::GenerallyLockResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GenerallyLockRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::refresh(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = RefreshSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LocalStorageInfo" => {
                    #[allow(non_camel_case_types)]
                    struct LocalStorageInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LocalStorageInfoRequest> for LocalStorageInfoSvc<T> {
                        type Response = super::LocalStorageInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LocalStorageInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::local_storage_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LocalStorageInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ServerInfo" => {
                    #[allow(non_camel_case_types)]
                    struct ServerInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ServerInfoRequest> for ServerInfoSvc<T> {
                        type Response = super::ServerInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ServerInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::server_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ServerInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetCpus" => {
                    #[allow(non_camel_case_types)]
                    struct GetCpusSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetCpusRequest> for GetCpusSvc<T> {
                        type Response = super::GetCpusResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetCpusRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_cpus(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetCpusSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetNetInfo" => {
                    #[allow(non_camel_case_types)]
                    struct GetNetInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetNetInfoRequest> for GetNetInfoSvc<T> {
                        type Response = super::GetNetInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetNetInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_net_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetNetInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetPartitions" => {
                    #[allow(non_camel_case_types)]
                    struct GetPartitionsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetPartitionsRequest> for GetPartitionsSvc<T> {
                        type Response = super::GetPartitionsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetPartitionsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_partitions(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetPartitionsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetOsInfo" => {
                    #[allow(non_camel_case_types)]
                    struct GetOsInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetOsInfoRequest> for GetOsInfoSvc<T> {
                        type Response = super::GetOsInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetOsInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_os_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetOsInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetSELinuxInfo" => {
                    #[allow(non_camel_case_types)]
                    struct GetSELinuxInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetSeLinuxInfoRequest> for GetSELinuxInfoSvc<T> {
                        type Response = super::GetSeLinuxInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetSeLinuxInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_se_linux_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetSELinuxInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetSysConfig" => {
                    #[allow(non_camel_case_types)]
                    struct GetSysConfigSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetSysConfigRequest> for GetSysConfigSvc<T> {
                        type Response = super::GetSysConfigResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetSysConfigRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_sys_config(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetSysConfigSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetSysErrors" => {
                    #[allow(non_camel_case_types)]
                    struct GetSysErrorsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetSysErrorsRequest> for GetSysErrorsSvc<T> {
                        type Response = super::GetSysErrorsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetSysErrorsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_sys_errors(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetSysErrorsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetMemInfo" => {
                    #[allow(non_camel_case_types)]
                    struct GetMemInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetMemInfoRequest> for GetMemInfoSvc<T> {
                        type Response = super::GetMemInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetMemInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_mem_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetMemInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetMetrics" => {
                    #[allow(non_camel_case_types)]
                    struct GetMetricsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetMetricsRequest> for GetMetricsSvc<T> {
                        type Response = super::GetMetricsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetMetricsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_metrics(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetMetricsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetProcInfo" => {
                    #[allow(non_camel_case_types)]
                    struct GetProcInfoSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetProcInfoRequest> for GetProcInfoSvc<T> {
                        type Response = super::GetProcInfoResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetProcInfoRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_proc_info(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetProcInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/StartProfiling" => {
                    #[allow(non_camel_case_types)]
                    struct StartProfilingSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::StartProfilingRequest> for StartProfilingSvc<T> {
                        type Response = super::StartProfilingResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::StartProfilingRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::start_profiling(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = StartProfilingSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DownloadProfileData" => {
                    #[allow(non_camel_case_types)]
                    struct DownloadProfileDataSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DownloadProfileDataRequest> for DownloadProfileDataSvc<T> {
                        type Response = super::DownloadProfileDataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DownloadProfileDataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::download_profile_data(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DownloadProfileDataSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetBucketStats" => {
                    #[allow(non_camel_case_types)]
                    struct GetBucketStatsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetBucketStatsDataRequest> for GetBucketStatsSvc<T> {
                        type Response = super::GetBucketStatsDataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetBucketStatsDataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_bucket_stats(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetBucketStatsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetSRMetrics" => {
                    #[allow(non_camel_case_types)]
                    struct GetSRMetricsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetSrMetricsDataRequest> for GetSRMetricsSvc<T> {
                        type Response = super::GetSrMetricsDataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetSrMetricsDataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_sr_metrics(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetSRMetricsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetAllBucketStats" => {
                    #[allow(non_camel_case_types)]
                    struct GetAllBucketStatsSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetAllBucketStatsRequest> for GetAllBucketStatsSvc<T> {
                        type Response = super::GetAllBucketStatsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetAllBucketStatsRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_all_bucket_stats(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetAllBucketStatsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadBucketMetadata" => {
                    #[allow(non_camel_case_types)]
                    struct LoadBucketMetadataSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadBucketMetadataRequest> for LoadBucketMetadataSvc<T> {
                        type Response = super::LoadBucketMetadataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadBucketMetadataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_bucket_metadata(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadBucketMetadataSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeleteBucketMetadata" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteBucketMetadataSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteBucketMetadataRequest> for DeleteBucketMetadataSvc<T> {
                        type Response = super::DeleteBucketMetadataResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteBucketMetadataRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_bucket_metadata(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteBucketMetadataSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeletePolicy" => {
                    #[allow(non_camel_case_types)]
                    struct DeletePolicySvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeletePolicyRequest> for DeletePolicySvc<T> {
                        type Response = super::DeletePolicyResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeletePolicyRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_policy(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeletePolicySvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadPolicy" => {
                    #[allow(non_camel_case_types)]
                    struct LoadPolicySvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadPolicyRequest> for LoadPolicySvc<T> {
                        type Response = super::LoadPolicyResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadPolicyRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_policy(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadPolicySvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadPolicyMapping" => {
                    #[allow(non_camel_case_types)]
                    struct LoadPolicyMappingSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadPolicyMappingRequest> for LoadPolicyMappingSvc<T> {
                        type Response = super::LoadPolicyMappingResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadPolicyMappingRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_policy_mapping(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadPolicyMappingSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeleteUser" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteUserSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteUserRequest> for DeleteUserSvc<T> {
                        type Response = super::DeleteUserResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteUserRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_user(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteUserSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/DeleteServiceAccount" => {
                    #[allow(non_camel_case_types)]
                    struct DeleteServiceAccountSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::DeleteServiceAccountRequest> for DeleteServiceAccountSvc<T> {
                        type Response = super::DeleteServiceAccountResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::DeleteServiceAccountRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::delete_service_account(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DeleteServiceAccountSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadUser" => {
                    #[allow(non_camel_case_types)]
                    struct LoadUserSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadUserRequest> for LoadUserSvc<T> {
                        type Response = super::LoadUserResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadUserRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_user(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadUserSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadServiceAccount" => {
                    #[allow(non_camel_case_types)]
                    struct LoadServiceAccountSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadServiceAccountRequest> for LoadServiceAccountSvc<T> {
                        type Response = super::LoadServiceAccountResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadServiceAccountRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_service_account(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadServiceAccountSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadGroup" => {
                    #[allow(non_camel_case_types)]
                    struct LoadGroupSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadGroupRequest> for LoadGroupSvc<T> {
                        type Response = super::LoadGroupResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadGroupRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_group(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadGroupSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReloadSiteReplicationConfig" => {
                    #[allow(non_camel_case_types)]
                    struct ReloadSiteReplicationConfigSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReloadSiteReplicationConfigRequest>
                        for ReloadSiteReplicationConfigSvc<T>
                    {
                        type Response = super::ReloadSiteReplicationConfigResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReloadSiteReplicationConfigRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::reload_site_replication_config(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReloadSiteReplicationConfigSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/SignalService" => {
                    #[allow(non_camel_case_types)]
                    struct SignalServiceSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::SignalServiceRequest> for SignalServiceSvc<T> {
                        type Response = super::SignalServiceResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::SignalServiceRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::signal_service(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = SignalServiceSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/BackgroundHealStatus" => {
                    #[allow(non_camel_case_types)]
                    struct BackgroundHealStatusSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::BackgroundHealStatusRequest> for BackgroundHealStatusSvc<T> {
                        type Response = super::BackgroundHealStatusResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::BackgroundHealStatusRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::background_heal_status(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = BackgroundHealStatusSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/GetMetacacheListing" => {
                    #[allow(non_camel_case_types)]
                    struct GetMetacacheListingSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::GetMetacacheListingRequest> for GetMetacacheListingSvc<T> {
                        type Response = super::GetMetacacheListingResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::GetMetacacheListingRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::get_metacache_listing(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetMetacacheListingSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/UpdateMetacacheListing" => {
                    #[allow(non_camel_case_types)]
                    struct UpdateMetacacheListingSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::UpdateMetacacheListingRequest> for UpdateMetacacheListingSvc<T> {
                        type Response = super::UpdateMetacacheListingResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::UpdateMetacacheListingRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::update_metacache_listing(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = UpdateMetacacheListingSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/ReloadPoolMeta" => {
                    #[allow(non_camel_case_types)]
                    struct ReloadPoolMetaSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::ReloadPoolMetaRequest> for ReloadPoolMetaSvc<T> {
                        type Response = super::ReloadPoolMetaResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::ReloadPoolMetaRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::reload_pool_meta(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReloadPoolMetaSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/StopRebalance" => {
                    #[allow(non_camel_case_types)]
                    struct StopRebalanceSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::StopRebalanceRequest> for StopRebalanceSvc<T> {
                        type Response = super::StopRebalanceResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::StopRebalanceRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::stop_rebalance(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = StopRebalanceSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadRebalanceMeta" => {
                    #[allow(non_camel_case_types)]
                    struct LoadRebalanceMetaSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadRebalanceMetaRequest> for LoadRebalanceMetaSvc<T> {
                        type Response = super::LoadRebalanceMetaResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadRebalanceMetaRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_rebalance_meta(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadRebalanceMetaSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/node_service.NodeService/LoadTransitionTierConfig" => {
                    #[allow(non_camel_case_types)]
                    struct LoadTransitionTierConfigSvc<T: NodeService>(pub Arc<T>);
                    impl<T: NodeService> tonic::server::UnaryService<super::LoadTransitionTierConfigRequest> for LoadTransitionTierConfigSvc<T> {
                        type Response = super::LoadTransitionTierConfigResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::LoadTransitionTierConfigRequest>) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { <T as NodeService>::load_transition_tier_config(&inner, request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = LoadTransitionTierConfigSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(accept_compression_encodings, send_compression_encodings)
                            .apply_max_message_size_config(max_decoding_message_size, max_encoding_message_size);
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => Box::pin(async move {
                    let mut response = http::Response::new(tonic::body::Body::default());
                    let headers = response.headers_mut();
                    headers.insert(tonic::Status::GRPC_STATUS, (tonic::Code::Unimplemented as i32).into());
                    headers.insert(http::header::CONTENT_TYPE, tonic::metadata::GRPC_CONTENT_TYPE);
                    Ok(response)
                }),
            }
        }
    }
    impl<T> Clone for NodeServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    /// Generated gRPC service name
    pub const SERVICE_NAME: &str = "node_service.NodeService";
    impl<T> tonic::server::NamedService for NodeServiceServer<T> {
        const NAME: &'static str = SERVICE_NAME;
    }
}
