# Query-параметры { #query-parameters }

Когда вы объявляете параметры функции, которые не являются параметрами пути, они автоматически интерпретируются как "query"-параметры.

{* ../../docs_src/query_params/tutorial001_py310.py hl[9] *}

Query-параметры представляют из себя набор пар ключ-значение, которые идут после знака `?` в URL-адресе, разделенные символами `&`.

Например, в этом URL-адресе:

```
http://127.0.0.1:8000/items/?skip=0&limit=10
```

...параметры запроса такие:

* `skip`: со значением `0`
* `limit`: со значением `10`

Будучи частью URL-адреса, они "по умолчанию" являются строками.

Но когда вы объявляете их с использованием типов Python (в примере выше, как `int`), они конвертируются в указанный тип данных и проходят проверку на соответствие ему.

Все те же правила, которые применяются к path-параметрам, также применяются и query-параметрам:

* Поддержка от редактора кода (очевидно)
* <dfn title="преобразование строки, полученной из HTTP-запроса в данные Python">"Парсинг"</dfn> данных
* Проверка на соответствие данных (Валидация)
* Автоматическая документация

## Значения по умолчанию { #defaults }

Поскольку query-параметры не являются фиксированной частью пути, они могут быть не обязательными и иметь значения по умолчанию.

В примере выше значения по умолчанию равны `skip=0` и `limit=10`.

Таким образом, результат перехода по URL-адресу:

```
http://127.0.0.1:8000/items/
```

будет таким же, как если перейти используя параметры по умолчанию:

```
http://127.0.0.1:8000/items/?skip=0&limit=10
```

Но если вы введёте, например:

```
http://127.0.0.1:8000/items/?skip=20
```

Значения параметров в вашей функции будут:

* `skip=20`: потому что вы установили это в URL-адресе
* `limit=10`: т.к это было значение по умолчанию

## Необязательные параметры { #optional-parameters }

Аналогично, вы можете объявлять необязательные query-параметры, установив их значение по умолчанию, равное `None`:

{* ../../docs_src/query_params/tutorial002_py310.py hl[7] *}

В этом случае, параметр  `q` будет не обязательным и будет иметь значение `None` по умолчанию.

/// check | Важно

Также обратите внимание, что **FastAPI** достаточно умён чтобы заметить, что параметр `item_id` является path-параметром, а `q` нет, поэтому, это параметр запроса.

///

## Преобразование типа параметра запроса { #query-parameter-type-conversion }

Вы также можете объявлять параметры с типом `bool`, которые будут преобразованы соответственно:

{* ../../docs_src/query_params/tutorial003_py310.py hl[7] *}

В этом случае, если вы сделаете запрос:

```
http://127.0.0.1:8000/items/foo?short=1
```

или

```
http://127.0.0.1:8000/items/foo?short=True
```

или

```
http://127.0.0.1:8000/items/foo?short=true
```

или

```
http://127.0.0.1:8000/items/foo?short=on
```

или

```
http://127.0.0.1:8000/items/foo?short=yes
```

или в любом другом варианте написания (в верхнем регистре, с заглавной буквой, и т.п), внутри вашей функции параметр `short` будет иметь значение `True` типа данных `bool` . В противном случае - `False`.

## Смешивание query-параметров и path-параметров { #multiple-path-and-query-parameters }

Вы можете объявлять несколько query-параметров и path-параметров одновременно, **FastAPI** сам разберётся, что чем является.

И вы не обязаны объявлять их в каком-либо определенном порядке.

Они будут обнаружены по именам:

{* ../../docs_src/query_params/tutorial004_py310.py hl[6,8] *}

## Обязательные query-параметры { #required-query-parameters }

Когда вы объявляете значение по умолчанию для параметра, который не является path-параметром (в этом разделе мы пока что рассмотрели только query-параметры), то он не является обязательным.

Если вы не хотите задавать конкретное значение, но хотите сделать параметр необязательным, вы можете установить значение по умолчанию равным `None`.

Но если вы хотите сделать query-параметр обязательным, вы можете просто не указывать значение по умолчанию:

{* ../../docs_src/query_params/tutorial005_py310.py hl[6:7] *}

Здесь параметр запроса `needy` является обязательным параметром с типом данных  `str`.

Если вы откроете в браузере URL-адрес, например:

```
http://127.0.0.1:8000/items/foo-item
```

...без добавления обязательного параметра `needy`, вы увидите подобного рода ошибку:

```JSON
{
  "detail": [
    {
      "type": "missing",
      "loc": [
        "query",
        "needy"
      ],
      "msg": "Field required",
      "input": null
    }
  ]
}
```

Поскольку `needy` является обязательным параметром, вам необходимо указать его в URL-адресе:

```
http://127.0.0.1:8000/items/foo-item?needy=sooooneedy
```

...это будет работать:

```JSON
{
    "item_id": "foo-item",
    "needy": "sooooneedy"
}
```

Конечно, вы можете определить некоторые параметры как обязательные, некоторые — со значением по умолчанию, а некоторые — полностью необязательные:

{* ../../docs_src/query_params/tutorial006_py310.py hl[8] *}

В этом примере, у нас есть 3 параметра запроса:

* `needy`, обязательный `str`.
* `skip`, типа `int` и со значением по умолчанию `0`.
* `limit`, необязательный `int`.

/// tip | Подсказка

Вы можете использовать класс `Enum` также, как ранее применяли его с [Path-параметрами](path-params.md#predefined-values){.internal-link target=_blank}.

///
