# История, проектирование и будущее { #history-design-and-future }

Однажды, <a href="https://github.com/fastapi/fastapi/issues/3#issuecomment-454956920" class="external-link" target="_blank">один из пользователей **FastAPI** задал вопрос</a>:

> Какова история этого проекта? Создаётся впечатление, что он явился из ниоткуда и завоевал мир за несколько недель [...]

Что ж, вот небольшая часть истории проекта.

## Альтернативы { #alternatives }

В течение нескольких лет я, возглавляя различные команды разработчиков, создавал довольно сложные API для машинного обучения, распределённых систем, асинхронных задач, баз данных NoSQL и т.д.

В рамках работы над этими проектами я исследовал, проверял и использовал многие фреймворки.

Во многом история **FastAPI** - история его предшественников.

Как написано в разделе [Альтернативы](alternatives.md){.internal-link target=_blank}:

<blockquote markdown="1">

**FastAPI** не существовал бы, если б не было более ранних работ других людей.

Они создали большое количество инструментов, которые и вдохновили меня на создание **FastAPI**.

Я всячески избегал создания нового фреймворка в течение нескольких лет. Сначала я пытался собрать все нужные возможности, которые ныне есть в **FastAPI**, используя множество различных фреймворков, плагинов и инструментов.

Но в какой-то момент не осталось другого выбора, кроме как создать что-то, что предоставляло бы все эти возможности сразу. Взять самые лучшие идеи из предыдущих инструментов и, используя введённые в Python аннотации типов (которых не было до версии 3.6), объединить их.

</blockquote>

## Исследования { #investigation }

Используя все существовавшие ранее альтернативы, я получил возможность у каждой из них чему-то научиться, позаимствовать идеи и объединить их наилучшим образом для себя и для команд разработчиков, с которыми я работал.

Например, стало ясно, что необходимо брать за основу стандартные аннотации типов Python.

Также наилучшим подходом является использование уже существующих стандартов.

Итак, прежде чем приступить к написанию **FastAPI**, я потратил несколько месяцев на изучение OpenAPI, JSON Schema, OAuth2, и т.п. для понимания их взаимосвязей, совпадений и различий.

## Проектирование { #design }

Затем я потратил некоторое время на придумывание "API" разработчика, который я хотел иметь как пользователь (как разработчик, использующий FastAPI).

Я проверил несколько идей на самых популярных редакторах кода: PyCharm, VS Code, редакторы на базе Jedi.

Согласно последнему <a href="https://www.jetbrains.com/research/python-developers-survey-2018/#development-tools" class="external-link" target="_blank">опросу Python-разработчиков</a>, который охватывает около 80% пользователей.

Это означает, что **FastAPI** был специально проверен на редакторах, используемых 80% Python-разработчиками. И поскольку большинство других редакторов, как правило, работают аналогичным образом, все его преимущества должны работать практически для всех редакторов.

Таким образом, я смог найти наилучшие способы сократить дублирование кода, обеспечить повсеместное автозавершение, проверку типов и ошибок и т.д.

И все это, чтобы все разработчики могли получать наилучший опыт разработки.

## Зависимости { #requirements }

Протестировав несколько вариантов, я решил, что в качестве основы буду использовать <a href="https://docs.pydantic.dev/" class="external-link" target="_blank">**Pydantic**</a> и его преимущества.

По моим предложениям был изменён код этого фреймворка, чтобы сделать его полностью совместимым с JSON Schema, поддержать различные способы определения ограничений и улучшить поддержку в редакторах кода (проверки типов, автозавершение) на основе тестов в нескольких редакторах.

Во время разработки я также внес вклад в <a href="https://www.starlette.dev/" class="external-link" target="_blank">**Starlette**</a>, другую ключевую зависимость.

## Разработка { #development }

К тому времени, когда я начал создавать **FastAPI**, большинство необходимых деталей уже существовало, дизайн был определён, зависимости и прочие инструменты были готовы, а знания о стандартах и спецификациях были четкими и свежими.

## Будущее { #future }

Сейчас уже ясно, что **FastAPI** со своими идеями стал полезен многим людям.

При сравнении с альтернативами, выбор падает на него, поскольку он лучше подходит для множества вариантов использования.

Многие разработчики и команды уже используют **FastAPI** в своих проектах (включая меня и мою команду).

Но, тем не менее, грядёт добавление ещё многих улучшений и возможностей.

У **FastAPI** великое будущее.

И [ваш вклад в это](help-fastapi.md){.internal-link target=_blank} - очень ценен.
