Chrono 3.0.0 training material {#tutorial_slides_300}
============================================

The following sets of slides contain material used in various week-long Chrono tutorials offered in the past.
These slides refer to the API of Chrono release 3.0.0.

## Introductory Material

- Overview of Chrono 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/1_Intro/1_ProjectChrono_Overview.pdf)

- C++ primer 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/1_Intro/2_C++_Primer.pdf)

- GitHub primer 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/1_Intro/3_GitHub_Primer.pdf)

- CMake primer 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/1_Intro/4_Cmake_Primer.pdf)

- OVerview of available Chrono demos 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/1_Intro/5_ProjectChrono_Demos.pdf)

## Multibody Dynamics with Chrono

- General concepts of multibody dynamics 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/2_Multibody/1_Chrono_TheoryMBS.pdf)

- Basic multibody system modeling support in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/2_Multibody/2_Chrono_ModelingMBS.pdf)

- Visualization options in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/2_Multibody/3_Chrono_Visualization.pdf)

## Contact and Friction, Solution Methods

- Handling of frictional contact in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/3_Contact/1_Chrono_TheoryContact.pdf)

- Collision detection in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/3_Contact/2_Chrono_CollisionDetection.pdf)

- Solution methods: time steppers and linear solvers 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/3_Contact/3_Chrono_Solvers.pdf)

## Finite Element Analysys (Chrono::FEA)

- ANCF support for flexible body dynamics in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/4_FEA/1_ChronoFEA_ANCF.pdf)

- Co-rotational FEA in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/4_FEA/2_ChronoFEA_Corotational.pdf)

- Validation of the Chrono FEA solution
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/4_FEA/3_ChronoFEA_Validation.pdf)

- Chrono FEA API 
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/4_FEA/4_ChronoFEA_API.pdf)

## Vehicle Modeling and Simulation (Chrono::Vehicle)

- Overview of Chrono::Vehicle
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/5_Vehicle/1_ChronoVehicle.pdf)

- Chrono::Vehicle, Wheeled Vehicles
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/5_Vehicle/2_ChronoVehicle_Wheeled.pdf)

- Chrono::Vehicle, Tracked Vehicles
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/5_Vehicle/3_ChronoVehicle_Tracked.pdf)

## Other Chrono modules

- Chrono::Parallel and support for granular dynamics
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/6_OtherModules/1_ChronoParallel.pdf)

- Chrono::Matlab and interfacing to Matlab/Simulink
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/6_OtherModules/2_ChronoMatlab.pdf)

- Chrono::Python and interfacing to Python
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/6_OtherModules/3_ChronoPython.pdf)

- Chrono::Solidworks plugin
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/6_OtherModules/4_ChronoSolidworks.pdf)

- Support for robotics in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/6_OtherModules/5_ChronoRoboticsSupport.pdf)

- Looking ahead: Autonomous vehicle simulation support in Chrono
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/6_OtherModules/6_ChronoCAVE.pdf)

- Chrono support for multi-physics
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/6_OtherModules/7_ChronoMultiphysicsSupport.pdf)

## Hands-on Exercises

The following hands-on exercises use code available in the GitHub repository [chrono-tutorials](https://github.com/projectchrono/chrono-tutorial)

- Chrono core exercises
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/7_HandsOn/Chrono_Handson.pdf)

- Chrono::FEA exercises
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/7_HandsOn/ChronoFEA_Handson.pdf)

- Chrono::Vehicle exercises
  [pdf](http://www.projectchrono.org/assets/slides_3_0_0/7_HandsOn/ChronoVehicle_HandsOn.pdf)



