Chrono MBS module tutorials         {#tutorial_table_of_content_chrono_mbs}
======================================

Tutorials that teach how to use the Chrono [CORE module](group__chrono.html) for multibody system analysis.

The following are some examples to get started with Chrono. 
These demos require the IRRLICHT run-time visualization module, with some of them optionally using the VSG run-time visualization module.

- @subpage  tutorial_demo_crank
  The simplest MBS example: the skeleton of a slider-crank mechanism.
  
- @subpage  tutorial_demo_fourbar
  Create a four bar linkage and display it with simple lines 
  
- @subpage  tutorial_demo_collision
  Learn how to setup collisions in Chrono with this introductory example
  
- @subpage  tutorial_demo_bricks
  Simulate collisions between a wrecking ball and a wall
  (Irrlicht or VSG run-time visualization)
  
- @subpage  tutorial_demo_pendulum
  Simulate articulated pendulums that interact with a force field
  
- @subpage  tutorial_demo_motors
  Different ways of using motors in Chrono
  
- @subpage  tutorial_demo_gears
  Create a transmission made of pulleys, spur gears, bevel gears.
  
- @subpage  tutorial_demo_mecanum
  Create a robot with omnidirectional wheels; learn coordinate transformations
  
- @subpage  tutorial_demo_friction
  Learn how to enable rolling and spinning friction 
  (Irrlicht or VSG run-time visualization)

- @subpage  tutorial_demo_suspension
  Create a very simplified vehicle model with suspensions
  
- @subpage  tutorial_demo_tracks
  Simulate a vehicle with tracks interacting with obstacles, and that can be driven by the user

- @subpage  tutorial_demo_conveyor
  Demonstration of the conveyor belt primitive.
  
- @subpage  tutorial_demo_forklift
  Advanced demo: create a forklift that can be driven by the user
  
  