<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

Jube 8, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk

# **OCIO TSC Meeting Notes**

* Move OCIO Slack to LF organization to ease sign-up?
    - Michael: Emily and John reached out about the possibility of moving our 
      Slack channels to the ASWF Slack workspace. I didn't think we would want 
      to merge with their workspace since we have many active channels, but 
      John proposed that if we moved our existing workspace to the ASWF 
      organization, LF could setup self-sign-up, to make the space more 
      publicly accessible. Thoughts on that?
    - TSC agrees that sounds good.
    - Sean: Do they have paid access? Would be good to not have message limits, 
      since we are losing discussion history now.
    - Carol: Can the existing discussion be migrated?
    - **TODO**: Michael will follow up with LF for more details of their Slack 
      account.

* OCIO docs discussion
    - Carol: We are going to meet to discuss structure and writing of docs. 
      Maybe discuss in v2 working group?
    - Doug: Time can be made available, but maybe a doc-focused meeting could 
      be held sooner.
    - [Sean's straw-man docs for demo](https://seancooper.xyz/OpenColorIO-Docs/index.html)
    - Sean: Best example of work is the API section, under Baker. Small but 
      complete example. Has generic class description at top, and API docs 
      below. Method signatures needs some work, but C++ and Python are grouped 
      together in tabs. In general, the goal is to have a page per class, and a 
      tab per language in each API section. Language tabs are ganged together 
      to avoid confusion while browsing docs.
        - Docstrings are pulled from C++ headers, and from Python bindings via 
          autodoc. 
        - Doxygen is used to parse C++ headers. This is good for flexibility 
          without maintaining our own parsing code. Doxygen and Breathe convert 
          docs to Sphinx.
        - It's a bit awkward if someone wants to modify a docstring. They would 
          need to modify the header, which means more traffic on the public 
          headers. Could get messy if we're not careful. It's a downside, but 
          in general we can create the outline and from there just update it 
          when the code changes. If you add additional methods or classes, they 
          also need to be addded to the reST doc structure.
        - Currently cant' be super language specific in docs.
    - Mark: Does it include text blocks which are stored somewhere else?
    - Carol: The text part at the top might be nice to separate. If you are 
      changing API docs you are changing code. Maybe it would be safer to 
      separate descriptive sections. There may be times where we need to make 
      examples and reference something. Would be good to have control over that 
      text outside of header.
    - Sean: It's just like that right now because of the current header 
      structure. We can decide what's in the header vs. what's in the reST. 
      Sphinx is nice because you can directly reference classes (with links), 
      which is hard to do with markdown. Still some quirks with the VuePress 
      theme that's being worked out. Some clean up needed. Remaining work is to 
      continue working on fleshing out API. Need to decide how to interface 
      with docs. How do people want to build?
    - Michael: Needing to build the lib to build the docs could be a blocker 
      for something like RTD.
    - Sean: Yeah, build time could be issue, since there is a timeout. Can 
      deploy Sphinx in RTD. We still need to add a version picker. Also need to 
      consider compiling code embedded in docs in CI to make sure it is still 
      valid. The old code base had examples that no longer worked. Also not 
      sure how to handle localization yet. Someone offered some language 
      translation if needed.
    - Doug: How does this work fit with other things in documentation; 
      site-generators, etc. Does this proposal replace that?
    - Sean: We haven't decided yet if Sphinx should just generate API docs and 
      something else build the website. Currently it's all through Sphinx. 
      Could go either way. We could have all the expository stuff on the 
      website, and API docs in RTD. It's flexible so we could do both. The 
      Doxyfy static site generator is user friendly, so could be used for the 
      website. Perhaps host API on RTD and host Doxyfy page on GH pages; two 
      deployments linked together.
    - Carol: Worth seeing how much complexity is needed. A nice homepage and 
      separation of API docs all within one framework would be nice. Does 
      separating it make generation more complicated? 
    - Sean: Updating the headers requires recompiling python bindings.
    - Mark B: There will be a lot of churn up front, but it should stabilize. 
      We could take the pain of rebuilding often up front, and it should get 
      better. It's not going to impact contributors long term.
    - Sean: Complicated to find balance of being nice for contributors and nice 
      for documentation. The current design favors developers a bit more. So 
      far the work has mainly involved a slight change in header comment 
      formatting. There's still a lot of work to do for OCIO v2 docs, and 
      deciding what to cover and talk about. In theory much of the docs will 
      involve writing plain text.
    - Carol: We'll set up a time to look over everything. It would be good to 
      discuss what makes contribution easier too.
    - Sean: We can form a TODO list, so that interested contributors can pick 
      things to work on.
    - Michael (post-TSC meeting note): This could implemented by adding issues 
      for each item to the documentation GH Project, which could be assigned 
      and tracked.
    - **TODO**: Sean and Carol to plan a meeting to discuss structure and next 
      steps.

* ACES Config
    - Michael: Working on scheduling a meeting to discuss next steps, possibly 
      this Friday, but it is flexible if that conflicts with another meeting.

* Items for next TSC meeting agenda:
    - Carol: cineSync OCIO integration
