; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-vectorize -force-vector-width=4 -S %s | FileCheck %s

define void @narrow_select_to_single_scalar(i1 %invar.cond, ptr noalias %A, ptr noalias %B, ptr noalias %C) {
; CHECK-LABEL: define void @narrow_select_to_single_scalar(
; CHECK-SAME: i1 [[INVAR_COND:%.*]], ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], ptr noalias [[C:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; CHECK:       [[VECTOR_PH]]:
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[INVAR_COND]], i16 0, i16 1
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr i16, ptr [[C]], i16 [[TMP0]]
; CHECK-NEXT:    br label %[[VECTOR_BODY:.*]]
; CHECK:       [[VECTOR_BODY]]:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i32 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = trunc i32 [[INDEX]] to i16
; CHECK-NEXT:    [[TMP2:%.*]] = add i16 [[OFFSET_IDX]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = add i16 [[OFFSET_IDX]], 1
; CHECK-NEXT:    [[TMP4:%.*]] = add i16 [[OFFSET_IDX]], 2
; CHECK-NEXT:    [[TMP5:%.*]] = add i16 [[OFFSET_IDX]], 3
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[A]], i16 [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = load i16, ptr [[TMP6]], align 1
; CHECK-NEXT:    store i16 [[TMP7]], ptr [[B]], align 1
; CHECK-NEXT:    store i16 0, ptr [[TMP1]], align 1
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i32 [[INDEX]], 4
; CHECK-NEXT:    [[TMP8:%.*]] = icmp eq i32 [[INDEX_NEXT]], 1024
; CHECK-NEXT:    br i1 [[TMP8]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       [[MIDDLE_BLOCK]]:
; CHECK-NEXT:    br i1 false, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; CHECK:       [[SCALAR_PH]]:
; CHECK-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i16 [ 1024, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_HEADER]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr i8, ptr [[A]], i16 [[IV]]
; CHECK-NEXT:    [[L_0:%.*]] = load i16, ptr [[GEP_A]], align 1
; CHECK-NEXT:    store i16 [[L_0]], ptr [[B]], align 1
; CHECK-NEXT:    [[INVAR_SEL:%.*]] = select i1 [[INVAR_COND]], i16 0, i16 1
; CHECK-NEXT:    [[GEP_C:%.*]] = getelementptr i16, ptr [[C]], i16 [[INVAR_SEL]]
; CHECK-NEXT:    store i16 0, ptr [[GEP_C]], align 1
; CHECK-NEXT:    [[IV_NEXT]] = add i16 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp ne i16 [[IV]], 1024
; CHECK-NEXT:    br i1 [[EC]], label %[[LOOP_HEADER]], label %[[EXIT]], !llvm.loop [[LOOP3:![0-9]+]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i16 [ 0, %entry ], [ %iv.next, %loop.header ]
  %gep.A = getelementptr i8, ptr %A, i16 %iv
  %l.0 = load i16, ptr %gep.A, align 1
  store i16 %l.0, ptr %B, align 1
  %invar.sel = select i1 %invar.cond, i16 0, i16 1
  %gep.C = getelementptr i16, ptr %C, i16 %invar.sel
  store i16 0, ptr %gep.C, align 1
  %iv.next = add i16 %iv, 1
  %ec = icmp ne i16 %iv, 1024
  br i1 %ec, label %loop.header, label %exit

exit:
  ret void
}
;.
; CHECK: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]]}
; CHECK: [[META1]] = !{!"llvm.loop.isvectorized", i32 1}
; CHECK: [[META2]] = !{!"llvm.loop.unroll.runtime.disable"}
; CHECK: [[LOOP3]] = distinct !{[[LOOP3]], [[META2]], [[META1]]}
;.
