; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>" 2>&1 | FileCheck %s

define i64 @test64(i64 %a) {
; CHECK-LABEL: 'test64'
; CHECK-NEXT:  Classifying expressions for: @test64
; CHECK-NEXT:    %add = shl i64 %a, 8
; CHECK-NEXT:    --> (256 * %a) U: [0,-255) S: [-9223372036854775808,9223372036854775553)
; CHECK-NEXT:    %shl = add i64 %add, 256
; CHECK-NEXT:    --> (256 + (256 * %a)) U: [0,-255) S: [-9223372036854775808,9223372036854775553)
; CHECK-NEXT:    %ashr = ashr exact i64 %shl, 8
; CHECK-NEXT:    --> (sext i56 (1 + (trunc i64 %a to i56)) to i64) U: [-36028797018963968,36028797018963968) S: [-36028797018963968,36028797018963968)
; CHECK-NEXT:  Determining loop execution counts for: @test64
;
  %add = shl i64 %a, 8
  %shl = add i64 %add, 256
  %ashr = ashr exact i64 %shl, 8
  ret i64 %ashr
}

define i128 @test128(i128 %a) {
; CHECK-LABEL: 'test128'
; CHECK-NEXT:  Classifying expressions for: @test128
; CHECK-NEXT:    %shl = shl i128 %a, 4
; CHECK-NEXT:    --> (16 * %a) U: [0,-15) S: [-170141183460469231731687303715884105728,170141183460469231731687303715884105713)
; CHECK-NEXT:    %add = add i128 %shl, -55
; CHECK-NEXT:    --> (-55 + (16 * %a)) U: [-55,-70) S: [170141183460469231731687303715884105673,170141183460469231731687303715884105658)
; CHECK-NEXT:    %ashr = ashr i128 %add, 4
; CHECK-NEXT:    --> (sext i124 (-4 + (trunc i128 %a to i124)) to i128) U: [-10633823966279326983230456482242756608,10633823966279326983230456482242756608) S: [-10633823966279326983230456482242756608,10633823966279326983230456482242756608)
; CHECK-NEXT:  Determining loop execution counts for: @test128
;
  %shl = shl i128 %a, 4
  %add = add i128 %shl, -55
  %ashr = ashr i128 %add, 4
  ret i128 %ashr
}
