; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s -check-prefixes=SSE23,SSE2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s -check-prefixes=SSE23,SSSE3
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s -check-prefixes=SSE4
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s -check-prefixes=AVX1
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s -check-prefixes=AVX2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s -check-prefixes=AVX512,AVX512F
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512vl,+avx512dq | FileCheck %s -check-prefixes=AVX512,AVX512DQ
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512vl,+avx512bw | FileCheck %s -check-prefixes=AVX512,AVX512BW

;
; abs(X, not_posion)
;

define void @cost_abs_i64(i64 %a64, <2 x i64> %a128, <4 x i64> %a256, <8 x i64> %a512) {
; SSE23-LABEL: 'cost_abs_i64'
; SSE23-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 false)
; SSE23-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:6 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 false)
; SSE23-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:12 SizeLat:10 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 false)
; SSE23-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:24 SizeLat:20 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 false)
; SSE23-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i64'
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:10 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:20 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:12 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:24 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:4 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:4 SizeLat:5 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:10 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'cost_abs_i64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I64    = call i64 @llvm.abs.i64(i64 %a64, i1 0)
  %V2I64  = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 0)
  %V4I64  = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 0)
  %V8I64  = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 0)
  ret void
}

define void @cost_abs_i32(i32 %a32, <4 x i32> %a128, <8 x i32> %a256, <16 x i32> %a512) {
; SSE2-LABEL: 'cost_abs_i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:8 SizeLat:8 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:16 Lat:16 SizeLat:16 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'cost_abs_i32'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i32'
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'cost_abs_i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I32   = call i32 @llvm.abs.i32(i32 %a32, i1 0)
  %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 0)
  %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 0)
  %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 0)
  ret void
}

define void @cost_abs_i16(i16 %a16, <8 x i16> %a128, <16 x i16> %a256, <32 x i16> %a512) {
; SSE2-LABEL: 'cost_abs_i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:4 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:8 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'cost_abs_i16'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i16'
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512F-LABEL: 'cost_abs_i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512DQ-LABEL: 'cost_abs_i16'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512BW-LABEL: 'cost_abs_i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I16    = call i16 @llvm.abs.i16(i16 %a16, i1 0)
  %V8I16  = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 0)
  %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 0)
  %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 0)
  ret void
}

define void @cost_abs_i8(i8 %a8, <16 x i8> %a128, <32 x i8> %a256, <64 x i8> %a512) {
; SSE2-LABEL: 'cost_abs_i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:4 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:8 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'cost_abs_i8'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i8'
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512F-LABEL: 'cost_abs_i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512DQ-LABEL: 'cost_abs_i8'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512BW-LABEL: 'cost_abs_i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I8    = call i8 @llvm.abs.i8(i8 %a8, i1 0)
  %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 0)
  %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 0)
  %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 0)
  ret void
}

;
; abs(X, posion)
;

define void @cost_abs_i64_poison(i64 %a64, <2 x i64> %a128, <4 x i64> %a256, <8 x i64> %a512) {
; SSE23-LABEL: 'cost_abs_i64_poison'
; SSE23-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 true)
; SSE23-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:6 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 true)
; SSE23-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:12 SizeLat:10 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 true)
; SSE23-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:24 SizeLat:20 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 true)
; SSE23-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i64_poison'
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:10 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:20 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i64_poison'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:12 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:24 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i64_poison'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:4 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:4 SizeLat:5 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:10 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'cost_abs_i64_poison'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I64 = call i64 @llvm.abs.i64(i64 %a64, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I64    = call i64 @llvm.abs.i64(i64 %a64, i1 -1)
  %V2I64  = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a128, i1 -1)
  %V4I64  = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a256, i1 -1)
  %V8I64  = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %a512, i1 -1)
  ret void
}

define void @cost_abs_i32_poison(i32 %a32, <4 x i32> %a128, <8 x i32> %a256, <16 x i32> %a512) {
; SSE2-LABEL: 'cost_abs_i32_poison'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:8 SizeLat:8 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:16 Lat:16 SizeLat:16 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'cost_abs_i32_poison'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i32_poison'
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i32_poison'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i32_poison'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'cost_abs_i32_poison'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.abs.i32(i32 %a32, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I32   = call i32 @llvm.abs.i32(i32 %a32, i1 -1)
  %V2I32 = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a128, i1 -1)
  %V4I32 = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a256, i1 -1)
  %V8I32 = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %a512, i1 -1)
  ret void
}

define void @cost_abs_i16_poison(i16 %a16, <8 x i16> %a128, <16 x i16> %a256, <32 x i16> %a512) {
; SSE2-LABEL: 'cost_abs_i16_poison'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:4 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:8 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'cost_abs_i16_poison'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i16_poison'
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i16_poison'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i16_poison'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512F-LABEL: 'cost_abs_i16_poison'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512DQ-LABEL: 'cost_abs_i16_poison'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512BW-LABEL: 'cost_abs_i16_poison'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %I16 = call i16 @llvm.abs.i16(i16 %a16, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I16    = call i16 @llvm.abs.i16(i16 %a16, i1 -1)
  %V8I16  = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a128, i1 -1)
  %V16I16 = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a256, i1 -1)
  %V32I16 = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %a512, i1 -1)
  ret void
}

define void @cost_abs_i8_poison(i8 %a8, <16 x i8> %a128, <32 x i8> %a256, <64 x i8> %a512) {
; SSE2-LABEL: 'cost_abs_i8_poison'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:4 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:8 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'cost_abs_i8_poison'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE4-LABEL: 'cost_abs_i8_poison'
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'cost_abs_i8_poison'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'cost_abs_i8_poison'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512F-LABEL: 'cost_abs_i8_poison'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512DQ-LABEL: 'cost_abs_i8_poison'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512BW-LABEL: 'cost_abs_i8_poison'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:3 for: %I8 = call i8 @llvm.abs.i8(i8 %a8, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %I8    = call i8 @llvm.abs.i8(i8 %a8, i1 -1)
  %V16I8 = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a128, i1 -1)
  %V32I8 = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a256, i1 -1)
  %V64I8 = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %a512, i1 -1)
  ret void
}

declare i64 @llvm.abs.i64(i64, i1)
declare i32 @llvm.abs.i32(i32, i1)
declare i16 @llvm.abs.i16(i16, i1)
declare  i8 @llvm.abs.i8(i8, i1)

declare <2 x i64>  @llvm.abs.v2i64(<2 x i64>, i1)
declare <4 x i32>  @llvm.abs.v4i32(<4 x i32>, i1)
declare <8 x i16>  @llvm.abs.v8i16(<8 x i16>, i1)
declare <16 x i8>  @llvm.abs.v16i8(<16 x i8>, i1)

declare <4 x i64>  @llvm.abs.v4i64(<4 x i64>, i1)
declare <8 x i32>  @llvm.abs.v8i32(<8 x i32>, i1)
declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1)
declare <32 x i8>  @llvm.abs.v32i8(<32 x i8>, i1)

declare <8 x i64>  @llvm.abs.v8i64(<8 x i64>, i1)
declare <16 x i32> @llvm.abs.v16i32(<16 x i32>, i1)
declare <32 x i16> @llvm.abs.v32i16(<32 x i16>, i1)
declare <64 x i8>  @llvm.abs.v64i8(<64 x i8>, i1)
