; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S -passes=instcombine %s | FileCheck %s
; RUN: opt -S -passes=instcombine -disable-builtin=ldexpf -disable-builtin=ldexp -disable-builtin=ldexpl %s | FileCheck %s

define float @exp2_f32_sitofp_i8(i8 %x) {
; CHECK-LABEL: define float @exp2_f32_sitofp_i8(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[X]] to i32
; CHECK-NEXT:    [[EXP2:%.*]] = call float @llvm.ldexp.f32.i32(float 1.000000e+00, i32 [[TMP1]])
; CHECK-NEXT:    ret float [[EXP2]]
;
  %itofp = sitofp i8 %x to float
  %exp2 = call float @llvm.exp2.f32(float %itofp)
  ret float %exp2
}

define float @exp2_f32_sitofp_i8_flags(i8 %x) {
; CHECK-LABEL: define float @exp2_f32_sitofp_i8_flags(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[X]] to i32
; CHECK-NEXT:    [[EXP2:%.*]] = call nnan ninf float @llvm.ldexp.f32.i32(float 1.000000e+00, i32 [[TMP1]])
; CHECK-NEXT:    ret float [[EXP2]]
;
  %itofp = sitofp i8 %x to float
  %exp2 = call nnan ninf float @llvm.exp2.f32(float %itofp)
  ret float %exp2
}

define <2 x float> @exp2_v2f32_sitofp_v2i8(<2 x i8> %x) {
; CHECK-LABEL: define <2 x float> @exp2_v2f32_sitofp_v2i8(
; CHECK-SAME: <2 x i8> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = sext <2 x i8> [[X]] to <2 x i32>
; CHECK-NEXT:    [[EXP2:%.*]] = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> splat (float 1.000000e+00), <2 x i32> [[TMP1]])
; CHECK-NEXT:    ret <2 x float> [[EXP2]]
;
  %itofp = sitofp <2 x i8> %x to <2 x float>
  %exp2 = call <2 x float> @llvm.exp2.v2f32(<2 x float> %itofp)
  ret <2 x float> %exp2
}

define float @exp2_f32_uitofp_i8(i8 %x) {
; CHECK-LABEL: define float @exp2_f32_uitofp_i8(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[X]] to i32
; CHECK-NEXT:    [[EXP2:%.*]] = call float @llvm.ldexp.f32.i32(float 1.000000e+00, i32 [[TMP1]])
; CHECK-NEXT:    ret float [[EXP2]]
;
  %itofp = uitofp i8 %x to float
  %exp2 = call float @llvm.exp2.f32(float %itofp)
  ret float %exp2
}

define half @exp2_f16_sitofp_i8(i8 %x) {
; CHECK-LABEL: define half @exp2_f16_sitofp_i8(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[X]] to i32
; CHECK-NEXT:    [[EXP2:%.*]] = call half @llvm.ldexp.f16.i32(half 0xH3C00, i32 [[TMP1]])
; CHECK-NEXT:    ret half [[EXP2]]
;
  %itofp = sitofp i8 %x to half
  %exp2 = call half @llvm.exp2.f16(half %itofp)
  ret half %exp2
}

define double @exp2_f64_sitofp_i8(i8 %x) {
; CHECK-LABEL: define double @exp2_f64_sitofp_i8(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[X]] to i32
; CHECK-NEXT:    [[EXP2:%.*]] = call double @llvm.ldexp.f64.i32(double 1.000000e+00, i32 [[TMP1]])
; CHECK-NEXT:    ret double [[EXP2]]
;
  %itofp = sitofp i8 %x to double
  %exp2 = call double @llvm.exp2.f64(double %itofp)
  ret double %exp2
}

define fp128 @exp2_fp128_sitofp_i8(i8 %x) {
; CHECK-LABEL: define fp128 @exp2_fp128_sitofp_i8(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[X]] to i32
; CHECK-NEXT:    [[EXP2:%.*]] = call fp128 @llvm.ldexp.f128.i32(fp128 0xL00000000000000003FFF000000000000, i32 [[TMP1]])
; CHECK-NEXT:    ret fp128 [[EXP2]]
;
  %itofp = sitofp i8 %x to fp128
  %exp2 = call fp128 @llvm.exp2.fp128(fp128 %itofp)
  ret fp128 %exp2
}

define <vscale x 4 x float> @exp2_nxv4f32_sitofp_i8(<vscale x 4 x i8> %x) {
; CHECK-LABEL: define <vscale x 4 x float> @exp2_nxv4f32_sitofp_i8(
; CHECK-SAME: <vscale x 4 x i8> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = sext <vscale x 4 x i8> [[X]] to <vscale x 4 x i32>
; CHECK-NEXT:    [[EXP2:%.*]] = call <vscale x 4 x float> @llvm.ldexp.nxv4f32.nxv4i32(<vscale x 4 x float> splat (float 1.000000e+00), <vscale x 4 x i32> [[TMP1]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[EXP2]]
;
  %itofp = sitofp <vscale x 4 x i8> %x to <vscale x 4 x float>
  %exp2 = call <vscale x 4 x float> @llvm.exp2.nxv4f32(<vscale x 4 x float> %itofp)
  ret <vscale x 4 x float> %exp2
}

; FIXME: This asserts
; define bfloat @exp2_bf16_sitofp_i8(i8 %x) {
;   %itofp = sitofp i8 %x to bfloat
;   %exp2 = call bfloat @llvm.exp2.bf16(bfloat %itofp)
;   ret bfloat %exp2
; }

; FIXME: This asserts
; define ppc_fp128 @exp2_ppc_fp128_sitofp_i8(i8 %x) {
;   %itofp = sitofp i8 %x to ppc_fp128
;   %exp2 = call ppc_fp128 @llvm.exp2.ppcf128(ppc_fp128 %itofp)
;   ret ppc_fp128 %exp2
; }

; FIXME: This asserts
; define x86_fp80 @exp2_x86_fp80_sitofp_i8(i8 %x) {
;   %itofp = sitofp i8 %x to x86_fp80
;   %exp2 = call x86_fp80 @llvm.exp2.f80(x86_fp80 %itofp)
;   ret x86_fp80 %exp2
; }
