/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_x_1d_exponential.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t7, t8, t11, t12, t14;
  double t16, t17, t18, t24, tzk0;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = rho[0] / 0.2e1 <= p->dens_threshold || t3;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t3, t5, t3, -t5, 0);
  t8 = 0.1e1 + t7;
  t11 = t8 * M_PI * params->beta * rho[0];
  t12 = xc_integrate(func1, NULL, 1e-20, t11);
  t14 = xc_integrate(func2, NULL, 1e-20, t11);
  t16 = t14 / M_PI;
  t17 = 0.1e1 / params->beta;
  t18 = 0.1e1 / rho[0];
  t24 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * (-t16 * t17 * t18 + t8 * t12) * t17);
  tzk0 = 0.2e1 * t24;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t7, t8, t11, t12, t14;
  double t16, t17, t18, t24, tzk0;

  double t25, t26, t27, t28, t29, t32, tvrho0;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = rho[0] / 0.2e1 <= p->dens_threshold || t3;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t3, t5, t3, -t5, 0);
  t8 = 0.1e1 + t7;
  t11 = t8 * M_PI * params->beta * rho[0];
  t12 = xc_integrate(func1, NULL, 1e-20, t11);
  t14 = xc_integrate(func2, NULL, 1e-20, t11);
  t16 = t14 / M_PI;
  t17 = 0.1e1 / params->beta;
  t18 = 0.1e1 / rho[0];
  t24 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * (-t16 * t17 * t18 + t8 * t12) * t17);
  tzk0 = 0.2e1 * t24;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t25 = params->beta * params->beta;
  t26 = 0.1e1 / t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t29 = t26 * t28;
  t32 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * t16 * t29);
  tvrho0 = 0.2e1 * rho[0] * t32 + 0.2e1 * t24;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t7, t8, t11, t12, t14;
  double t16, t17, t18, t24, tzk0;

  double t25, t26, t27, t28, t29, t32, tvrho0;

  double t36, t37, t38, t42, t47, t48, t52, tv2rho20;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = rho[0] / 0.2e1 <= p->dens_threshold || t3;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t3, t5, t3, -t5, 0);
  t8 = 0.1e1 + t7;
  t11 = t8 * M_PI * params->beta * rho[0];
  t12 = xc_integrate(func1, NULL, 1e-20, t11);
  t14 = xc_integrate(func2, NULL, 1e-20, t11);
  t16 = t14 / M_PI;
  t17 = 0.1e1 / params->beta;
  t18 = 0.1e1 / rho[0];
  t24 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * (-t16 * t17 * t18 + t8 * t12) * t17);
  tzk0 = 0.2e1 * t24;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t25 = params->beta * params->beta;
  t26 = 0.1e1 / t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t29 = t26 * t28;
  t32 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * t16 * t29);
  tvrho0 = 0.2e1 * rho[0] * t32 + 0.2e1 * t24;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t36 = t8 * t8;
  t37 = t36 * M_PI;
  t38 = M_PI * M_PI;
  t42 = xc_E1_scaled(t36 * t38 * t25 * t27);
  t47 = 0.1e1 / t27 / rho[0];
  t48 = t26 * t47;
  t52 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * t37 * t42 * t18 + 0.15915494309189533577e0 * t16 * t48);
  tv2rho20 = 0.2e1 * rho[0] * t52 + 0.4e1 * t32;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t7, t8, t11, t12, t14;
  double t16, t17, t18, t24, tzk0;

  double t25, t26, t27, t28, t29, t32, tvrho0;

  double t36, t37, t38, t42, t47, t48, t52, tv2rho20;

  double t56, t58, t61, t63, t64, t70, t76, tv3rho30;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = rho[0] / 0.2e1 <= p->dens_threshold || t3;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t3, t5, t3, -t5, 0);
  t8 = 0.1e1 + t7;
  t11 = t8 * M_PI * params->beta * rho[0];
  t12 = xc_integrate(func1, NULL, 1e-20, t11);
  t14 = xc_integrate(func2, NULL, 1e-20, t11);
  t16 = t14 / M_PI;
  t17 = 0.1e1 / params->beta;
  t18 = 0.1e1 / rho[0];
  t24 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * (-t16 * t17 * t18 + t8 * t12) * t17);
  tzk0 = 0.2e1 * t24;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t25 = params->beta * params->beta;
  t26 = 0.1e1 / t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t29 = t26 * t28;
  t32 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * t16 * t29);
  tvrho0 = 0.2e1 * rho[0] * t32 + 0.2e1 * t24;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t36 = t8 * t8;
  t37 = t36 * M_PI;
  t38 = M_PI * M_PI;
  t42 = xc_E1_scaled(t36 * t38 * t25 * t27);
  t47 = 0.1e1 / t27 / rho[0];
  t48 = t26 * t47;
  t52 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * t37 * t42 * t18 + 0.15915494309189533577e0 * t16 * t48);
  tv2rho20 = 0.2e1 * rho[0] * t52 + 0.4e1 * t32;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t56 = t36 * t36;
  t58 = t56 * t38 * M_PI;
  t61 = 0.1e1 / t36 / t38;
  t63 = -t61 * t29 + t42;
  t64 = t63 * t25;
  t70 = t27 * t27;
  t76 = my_piecewise3(t4, 0, -0.15915494309189533577e0 * t58 * t64 + 0.23873241463784300365e0 * t37 * t42 * t28 - 0.47746482927568600731e0 * t16 * t26 / t70);
  tv3rho30 = 0.2e1 * rho[0] * t76 + 0.6e1 * t52;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t7, t8, t11, t12, t14;
  double t16, t17, t18, t24, tzk0;

  double t25, t26, t27, t28, t29, t32, tvrho0;

  double t36, t37, t38, t42, t47, t48, t52, tv2rho20;

  double t56, t58, t61, t63, t64, t70, t76, tv3rho30;

  double t102, tv4rho40;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = rho[0] / 0.2e1 <= p->dens_threshold || t3;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t3, t5, t3, -t5, 0);
  t8 = 0.1e1 + t7;
  t11 = t8 * M_PI * params->beta * rho[0];
  t12 = xc_integrate(func1, NULL, 1e-20, t11);
  t14 = xc_integrate(func2, NULL, 1e-20, t11);
  t16 = t14 / M_PI;
  t17 = 0.1e1 / params->beta;
  t18 = 0.1e1 / rho[0];
  t24 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * (-t16 * t17 * t18 + t8 * t12) * t17);
  tzk0 = 0.2e1 * t24;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t25 = params->beta * params->beta;
  t26 = 0.1e1 / t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t29 = t26 * t28;
  t32 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * t16 * t29);
  tvrho0 = 0.2e1 * rho[0] * t32 + 0.2e1 * t24;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t36 = t8 * t8;
  t37 = t36 * M_PI;
  t38 = M_PI * M_PI;
  t42 = xc_E1_scaled(t36 * t38 * t25 * t27);
  t47 = 0.1e1 / t27 / rho[0];
  t48 = t26 * t47;
  t52 = my_piecewise3(t4, 0, -0.79577471545947667883e-1 * t37 * t42 * t18 + 0.15915494309189533577e0 * t16 * t48);
  tv2rho20 = 0.2e1 * rho[0] * t52 + 0.4e1 * t32;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t56 = t36 * t36;
  t58 = t56 * t38 * M_PI;
  t61 = 0.1e1 / t36 / t38;
  t63 = -t61 * t29 + t42;
  t64 = t63 * t25;
  t70 = t27 * t27;
  t76 = my_piecewise3(t4, 0, -0.15915494309189533577e0 * t58 * t64 + 0.23873241463784300365e0 * t37 * t42 * t28 - 0.47746482927568600731e0 * t16 * t26 / t70);
  tv3rho30 = 0.2e1 * rho[0] * t76 + 0.6e1 * t52;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t102 = my_piecewise3(t4, 0, -0.15915494309189533577e0 * t58 * (0.2e1 * t63 * t36 * t38 * t25 * rho[0] + 0.2e1 * t61 * t48) * t25 + 0.4774648292756860073e0 * t58 * t64 * t18 - 0.95492965855137201461e0 * t37 * t42 * t47 + 0.19098593171027440292e1 * t16 * t26 / t70 / rho[0]);
  tv4rho40 = 0.2e1 * rho[0] * t102 + 0.8e1 * t76;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t13, t14, t15, t16, t17, t18, t20;
  double t21, t22, t23, t24, t29, t31, t32, t33;
  double t34, t35, t36, t38, t39, t44, tzk0;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = rho[0] <= p->dens_threshold || t7;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = 0.1e1 - t5 <= p->zeta_threshold;
  t12 = -t9;
  t13 = my_piecewise5(t7, t9, t11, t12, t5);
  t14 = 0.1e1 + t13;
  t15 = t14 * M_PI;
  t16 = params->beta * t3;
  t17 = t15 * t16;
  t18 = xc_integrate(func1, NULL, 1e-20, t17);
  t20 = xc_integrate(func2, NULL, 1e-20, t17);
  t21 = 0.1e1 / M_PI;
  t22 = t20 * t21;
  t23 = 0.1e1 / params->beta;
  t24 = t23 * t4;
  t29 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t14 * t18 - t22 * t24) * t23);
  t31 = rho[1] <= p->dens_threshold || t11;
  t32 = my_piecewise5(t11, t9, t7, t12, -t5);
  t33 = 0.1e1 + t32;
  t34 = t33 * M_PI;
  t35 = t34 * t16;
  t36 = xc_integrate(func1, NULL, 1e-20, t35);
  t38 = xc_integrate(func2, NULL, 1e-20, t35);
  t39 = t38 * t21;
  t44 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (-t39 * t24 + t33 * t36) * t23);
  tzk0 = t29 + t44;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t13, t14, t15, t16, t17, t18, t20;
  double t21, t22, t23, t24, t29, t31, t32, t33;
  double t34, t35, t36, t38, t39, t44, tzk0;

  double t45, t46, t47, t48, t49, t51, t52, t56;
  double t58, t60, t64, tvrho0, t67, t68, t73, t75;
  double t80, tvrho1;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = rho[0] <= p->dens_threshold || t7;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = 0.1e1 - t5 <= p->zeta_threshold;
  t12 = -t9;
  t13 = my_piecewise5(t7, t9, t11, t12, t5);
  t14 = 0.1e1 + t13;
  t15 = t14 * M_PI;
  t16 = params->beta * t3;
  t17 = t15 * t16;
  t18 = xc_integrate(func1, NULL, 1e-20, t17);
  t20 = xc_integrate(func2, NULL, 1e-20, t17);
  t21 = 0.1e1 / M_PI;
  t22 = t20 * t21;
  t23 = 0.1e1 / params->beta;
  t24 = t23 * t4;
  t29 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t14 * t18 - t22 * t24) * t23);
  t31 = rho[1] <= p->dens_threshold || t11;
  t32 = my_piecewise5(t11, t9, t7, t12, -t5);
  t33 = 0.1e1 + t32;
  t34 = t33 * M_PI;
  t35 = t34 * t16;
  t36 = xc_integrate(func1, NULL, 1e-20, t35);
  t38 = xc_integrate(func2, NULL, 1e-20, t35);
  t39 = t38 * t21;
  t44 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (-t39 * t24 + t33 * t36) * t23);
  tzk0 = t29 + t44;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t3 * t3;
  t46 = 0.1e1 / t45;
  t47 = t2 * t46;
  t48 = t4 - t47;
  t49 = my_piecewise5(t7, 0, t11, 0, t48);
  t51 = t23 * t46;
  t52 = t22 * t51;
  t56 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t49 * t18 + t52) * t23);
  t58 = my_piecewise5(t11, 0, t7, 0, -t48);
  t60 = t39 * t51;
  t64 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t58 * t36 + t60) * t23);
  tvrho0 = t29 + t44 + t3 * (t56 + t64);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = -t4 - t47;
  t68 = my_piecewise5(t7, 0, t11, 0, t67);
  t73 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t68 * t18 + t52) * t23);
  t75 = my_piecewise5(t11, 0, t7, 0, -t67);
  t80 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t75 * t36 + t60) * t23);
  tvrho1 = t29 + t44 + t3 * (t73 + t80);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t13, t14, t15, t16, t17, t18, t20;
  double t21, t22, t23, t24, t29, t31, t32, t33;
  double t34, t35, t36, t38, t39, t44, tzk0;

  double t45, t46, t47, t48, t49, t51, t52, t56;
  double t58, t60, t64, tvrho0, t67, t68, t73, t75;
  double t80, tvrho1;

  double t86, t87, t89, t90, t92, t94, t95, t96;
  double t97, t98, t99, t100, t101, t103, t105, t106;
  double t107, t108, t110, t114, t116, t118, t120, t121;
  double t122, t123, t124, t126, t128, t129, t130, t132;
  double t136, tv2rho20, t139, t140, t142, t147, t148, t150;
  double t155, tv2rho21, t161, t162, t164, t166, t167, t169;
  double t174, t176, t178, t180, t181, t183, t188, tv2rho22;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = rho[0] <= p->dens_threshold || t7;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = 0.1e1 - t5 <= p->zeta_threshold;
  t12 = -t9;
  t13 = my_piecewise5(t7, t9, t11, t12, t5);
  t14 = 0.1e1 + t13;
  t15 = t14 * M_PI;
  t16 = params->beta * t3;
  t17 = t15 * t16;
  t18 = xc_integrate(func1, NULL, 1e-20, t17);
  t20 = xc_integrate(func2, NULL, 1e-20, t17);
  t21 = 0.1e1 / M_PI;
  t22 = t20 * t21;
  t23 = 0.1e1 / params->beta;
  t24 = t23 * t4;
  t29 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t14 * t18 - t22 * t24) * t23);
  t31 = rho[1] <= p->dens_threshold || t11;
  t32 = my_piecewise5(t11, t9, t7, t12, -t5);
  t33 = 0.1e1 + t32;
  t34 = t33 * M_PI;
  t35 = t34 * t16;
  t36 = xc_integrate(func1, NULL, 1e-20, t35);
  t38 = xc_integrate(func2, NULL, 1e-20, t35);
  t39 = t38 * t21;
  t44 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (-t39 * t24 + t33 * t36) * t23);
  tzk0 = t29 + t44;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t3 * t3;
  t46 = 0.1e1 / t45;
  t47 = t2 * t46;
  t48 = t4 - t47;
  t49 = my_piecewise5(t7, 0, t11, 0, t48);
  t51 = t23 * t46;
  t52 = t22 * t51;
  t56 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t49 * t18 + t52) * t23);
  t58 = my_piecewise5(t11, 0, t7, 0, -t48);
  t60 = t39 * t51;
  t64 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t58 * t36 + t60) * t23);
  tvrho0 = t29 + t44 + t3 * (t56 + t64);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = -t4 - t47;
  t68 = my_piecewise5(t7, 0, t11, 0, t67);
  t73 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t68 * t18 + t52) * t23);
  t75 = my_piecewise5(t11, 0, t7, 0, -t67);
  t80 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t75 * t36 + t60) * t23);
  tvrho1 = t29 + t44 + t3 * (t73 + t80);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t86 = 0.1e1 / t45 / t3;
  t87 = t2 * t86;
  t89 = -0.2e1 * t46 + 0.2e1 * t87;
  t90 = my_piecewise5(t7, 0, t11, 0, t89);
  t92 = t49 * M_PI;
  t94 = t15 * params->beta;
  t95 = t92 * t16 + t94;
  t96 = t49 * t95;
  t97 = t14 * t14;
  t98 = M_PI * M_PI;
  t99 = t97 * t98;
  t100 = params->beta * params->beta;
  t101 = t100 * t45;
  t103 = xc_E1_scaled(t99 * t101);
  t105 = t95 * t103;
  t106 = t14 * t4;
  t107 = t105 * t106;
  t108 = t23 * t86;
  t110 = 0.2e1 * t22 * t108;
  t114 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t96 * t103 + t90 * t18 + t107 - t110) * t23);
  t116 = my_piecewise5(t11, 0, t7, 0, -t89);
  t118 = t58 * M_PI;
  t120 = t34 * params->beta;
  t121 = t118 * t16 + t120;
  t122 = t58 * t121;
  t123 = t33 * t33;
  t124 = t123 * t98;
  t126 = xc_E1_scaled(t124 * t101);
  t128 = t121 * t126;
  t129 = t33 * t4;
  t130 = t128 * t129;
  t132 = 0.2e1 * t39 * t108;
  t136 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t116 * t36 + t122 * t126 + t130 - t132) * t23);
  tv2rho20 = 0.2e1 * t56 + 0.2e1 * t64 + t3 * (t114 + t136);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t139 = 0.2e1 * t87;
  t140 = my_piecewise5(t7, 0, t11, 0, t139);
  t142 = t68 * t95;
  t147 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t142 * t103 + t140 * t18 + t107 - t110) * t23);
  t148 = my_piecewise5(t11, 0, t7, 0, -t139);
  t150 = t75 * t121;
  t155 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t150 * t126 + t148 * t36 + t130 - t132) * t23);
  tv2rho21 = t56 + t64 + t73 + t80 + t3 * (t147 + t155);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t161 = 0.2e1 * t46 + 0.2e1 * t87;
  t162 = my_piecewise5(t7, 0, t11, 0, t161);
  t164 = t68 * M_PI;
  t166 = t164 * t16 + t94;
  t167 = t68 * t166;
  t169 = t166 * t103;
  t174 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t167 * t103 + t169 * t106 + t162 * t18 - t110) * t23);
  t176 = my_piecewise5(t11, 0, t7, 0, -t161);
  t178 = t75 * M_PI;
  t180 = t178 * t16 + t120;
  t181 = t75 * t180;
  t183 = t180 * t126;
  t188 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t181 * t126 + t183 * t129 + t176 * t36 - t132) * t23);
  tv2rho22 = 0.2e1 * t73 + 0.2e1 * t80 + t3 * (t174 + t188);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t13, t14, t15, t16, t17, t18, t20;
  double t21, t22, t23, t24, t29, t31, t32, t33;
  double t34, t35, t36, t38, t39, t44, tzk0;

  double t45, t46, t47, t48, t49, t51, t52, t56;
  double t58, t60, t64, tvrho0, t67, t68, t73, t75;
  double t80, tvrho1;

  double t86, t87, t89, t90, t92, t94, t95, t96;
  double t97, t98, t99, t100, t101, t103, t105, t106;
  double t107, t108, t110, t114, t116, t118, t120, t121;
  double t122, t123, t124, t126, t128, t129, t130, t132;
  double t136, tv2rho20, t139, t140, t142, t147, t148, t150;
  double t155, tv2rho21, t161, t162, t164, t166, t167, t169;
  double t174, t176, t178, t180, t181, t183, t188, tv2rho22;

  double t193, t194, t195, t197, t198, t200, t203, t205;
  double t207, t208, t211, t212, t213, t214, t216, t217;
  double t220, t221, t223, t224, t226, t227, t228, t229;
  double t230, t231, t232, t233, t234, t235, t236, t237;
  double t239, t243, t245, t247, t250, t252, t254, t255;
  double t258, t260, t261, t264, t266, t267, t269, t270;
  double t271, t272, t273, t274, t275, t276, t277, t278;
  double t279, t281, t285, tv3rho30, t288, t289, t290, t291;
  double t292, t293, t295, t298, t304, t306, t308, t311;
  double t317, tv3rho31, t320, t321, t323, t325, t327, t329;
  double t330, t331, t334, t336, t339, t341, t344, t346;
  double t348, t350, t352, t354, t355, t356, t359, t361;
  double t364, t366, t369, tv3rho32, t375, t376, t378, t381;
  double t384, t385, t387, t390, t391, t393, t395, t396;
  double t398, t404, t406, t408, t411, t414, t415, t417;
  double t420, t421, t423, t425, t426, t428, t434, tv3rho33;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = rho[0] <= p->dens_threshold || t7;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = 0.1e1 - t5 <= p->zeta_threshold;
  t12 = -t9;
  t13 = my_piecewise5(t7, t9, t11, t12, t5);
  t14 = 0.1e1 + t13;
  t15 = t14 * M_PI;
  t16 = params->beta * t3;
  t17 = t15 * t16;
  t18 = xc_integrate(func1, NULL, 1e-20, t17);
  t20 = xc_integrate(func2, NULL, 1e-20, t17);
  t21 = 0.1e1 / M_PI;
  t22 = t20 * t21;
  t23 = 0.1e1 / params->beta;
  t24 = t23 * t4;
  t29 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t14 * t18 - t22 * t24) * t23);
  t31 = rho[1] <= p->dens_threshold || t11;
  t32 = my_piecewise5(t11, t9, t7, t12, -t5);
  t33 = 0.1e1 + t32;
  t34 = t33 * M_PI;
  t35 = t34 * t16;
  t36 = xc_integrate(func1, NULL, 1e-20, t35);
  t38 = xc_integrate(func2, NULL, 1e-20, t35);
  t39 = t38 * t21;
  t44 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (-t39 * t24 + t33 * t36) * t23);
  tzk0 = t29 + t44;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t3 * t3;
  t46 = 0.1e1 / t45;
  t47 = t2 * t46;
  t48 = t4 - t47;
  t49 = my_piecewise5(t7, 0, t11, 0, t48);
  t51 = t23 * t46;
  t52 = t22 * t51;
  t56 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t49 * t18 + t52) * t23);
  t58 = my_piecewise5(t11, 0, t7, 0, -t48);
  t60 = t39 * t51;
  t64 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t58 * t36 + t60) * t23);
  tvrho0 = t29 + t44 + t3 * (t56 + t64);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = -t4 - t47;
  t68 = my_piecewise5(t7, 0, t11, 0, t67);
  t73 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t68 * t18 + t52) * t23);
  t75 = my_piecewise5(t11, 0, t7, 0, -t67);
  t80 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t75 * t36 + t60) * t23);
  tvrho1 = t29 + t44 + t3 * (t73 + t80);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t86 = 0.1e1 / t45 / t3;
  t87 = t2 * t86;
  t89 = -0.2e1 * t46 + 0.2e1 * t87;
  t90 = my_piecewise5(t7, 0, t11, 0, t89);
  t92 = t49 * M_PI;
  t94 = t15 * params->beta;
  t95 = t92 * t16 + t94;
  t96 = t49 * t95;
  t97 = t14 * t14;
  t98 = M_PI * M_PI;
  t99 = t97 * t98;
  t100 = params->beta * params->beta;
  t101 = t100 * t45;
  t103 = xc_E1_scaled(t99 * t101);
  t105 = t95 * t103;
  t106 = t14 * t4;
  t107 = t105 * t106;
  t108 = t23 * t86;
  t110 = 0.2e1 * t22 * t108;
  t114 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t96 * t103 + t90 * t18 + t107 - t110) * t23);
  t116 = my_piecewise5(t11, 0, t7, 0, -t89);
  t118 = t58 * M_PI;
  t120 = t34 * params->beta;
  t121 = t118 * t16 + t120;
  t122 = t58 * t121;
  t123 = t33 * t33;
  t124 = t123 * t98;
  t126 = xc_E1_scaled(t124 * t101);
  t128 = t121 * t126;
  t129 = t33 * t4;
  t130 = t128 * t129;
  t132 = 0.2e1 * t39 * t108;
  t136 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t116 * t36 + t122 * t126 + t130 - t132) * t23);
  tv2rho20 = 0.2e1 * t56 + 0.2e1 * t64 + t3 * (t114 + t136);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t139 = 0.2e1 * t87;
  t140 = my_piecewise5(t7, 0, t11, 0, t139);
  t142 = t68 * t95;
  t147 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t142 * t103 + t140 * t18 + t107 - t110) * t23);
  t148 = my_piecewise5(t11, 0, t7, 0, -t139);
  t150 = t75 * t121;
  t155 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t150 * t126 + t148 * t36 + t130 - t132) * t23);
  tv2rho21 = t56 + t64 + t73 + t80 + t3 * (t147 + t155);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t161 = 0.2e1 * t46 + 0.2e1 * t87;
  t162 = my_piecewise5(t7, 0, t11, 0, t161);
  t164 = t68 * M_PI;
  t166 = t164 * t16 + t94;
  t167 = t68 * t166;
  t169 = t166 * t103;
  t174 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t167 * t103 + t169 * t106 + t162 * t18 - t110) * t23);
  t176 = my_piecewise5(t11, 0, t7, 0, -t161);
  t178 = t75 * M_PI;
  t180 = t178 * t16 + t120;
  t181 = t75 * t180;
  t183 = t180 * t126;
  t188 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t181 * t126 + t183 * t129 + t176 * t36 - t132) * t23);
  tv2rho22 = 0.2e1 * t73 + 0.2e1 * t80 + t3 * (t174 + t188);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t193 = t45 * t45;
  t194 = 0.1e1 / t193;
  t195 = t2 * t194;
  t197 = 0.6e1 * t86 - 0.6e1 * t195;
  t198 = my_piecewise5(t7, 0, t11, 0, t197);
  t200 = t90 * t95;
  t203 = t90 * M_PI;
  t205 = t92 * params->beta;
  t207 = t203 * t16 + 0.2e1 * t205;
  t208 = t49 * t207;
  t211 = 0.1e1 / t98;
  t212 = 0.1e1 / t97 * t211;
  t213 = 0.1e1 / t100;
  t214 = t213 * t46;
  t216 = -t212 * t214 + t103;
  t217 = t14 * t98;
  t220 = t100 * t3;
  t221 = t99 * t220;
  t223 = 0.2e1 * t217 * t101 * t49 + 0.2e1 * t221;
  t224 = t216 * t223;
  t226 = t207 * t103;
  t227 = t226 * t106;
  t228 = t95 * t216;
  t229 = t223 * t14;
  t230 = t229 * t4;
  t231 = t228 * t230;
  t232 = t49 * t4;
  t233 = t105 * t232;
  t234 = t14 * t46;
  t235 = t105 * t234;
  t236 = 0.3e1 * t235;
  t237 = t23 * t194;
  t239 = 0.6e1 * t22 * t237;
  t243 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (0.2e1 * t200 * t103 + t208 * t103 + t198 * t18 + t96 * t224 + t227 + t231 + t233 - t236 + t239) * t23);
  t245 = my_piecewise5(t11, 0, t7, 0, -t197);
  t247 = t116 * t121;
  t250 = t116 * M_PI;
  t252 = t118 * params->beta;
  t254 = t250 * t16 + 0.2e1 * t252;
  t255 = t58 * t254;
  t258 = 0.1e1 / t123 * t211;
  t260 = -t258 * t214 + t126;
  t261 = t33 * t98;
  t264 = t124 * t220;
  t266 = 0.2e1 * t261 * t101 * t58 + 0.2e1 * t264;
  t267 = t260 * t266;
  t269 = t254 * t126;
  t270 = t269 * t129;
  t271 = t121 * t260;
  t272 = t266 * t33;
  t273 = t272 * t4;
  t274 = t271 * t273;
  t275 = t58 * t4;
  t276 = t128 * t275;
  t277 = t33 * t46;
  t278 = t128 * t277;
  t279 = 0.3e1 * t278;
  t281 = 0.6e1 * t39 * t237;
  t285 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t122 * t267 + 0.2e1 * t247 * t126 + t255 * t126 + t245 * t36 + t270 + t274 + t276 - t279 + t281) * t23);
  tv3rho30 = 0.3e1 * t114 + 0.3e1 * t136 + t3 * (t243 + t285);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t288 = 0.2e1 * t147;
  t289 = 0.2e1 * t155;
  t290 = 0.2e1 * t86;
  t291 = 0.6e1 * t195;
  t292 = t290 - t291;
  t293 = my_piecewise5(t7, 0, t11, 0, t292);
  t295 = t140 * t95;
  t298 = t68 * t207;
  t304 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (0.2e1 * t295 * t103 + t298 * t103 + t142 * t224 + t293 * t18 + t227 + t231 + t233 - t236 + t239) * t23);
  t306 = my_piecewise5(t11, 0, t7, 0, -t292);
  t308 = t148 * t121;
  t311 = t75 * t254;
  t317 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (0.2e1 * t308 * t126 + t311 * t126 + t150 * t267 + t306 * t36 + t270 + t274 + t276 - t279 + t281) * t23);
  tv3rho31 = t114 + t136 + t288 + t289 + t3 * (t304 + t317);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t320 = -t290 - t291;
  t321 = my_piecewise5(t7, 0, t11, 0, t320);
  t323 = t162 * t95;
  t325 = t140 * t166;
  t327 = t140 * M_PI;
  t329 = t164 * params->beta;
  t330 = t327 * t16 + t205 + t329;
  t331 = t68 * t330;
  t334 = t330 * t103;
  t336 = t166 * t216;
  t339 = t169 * t234;
  t341 = t323 * t103 + t325 * t103 + t331 * t103 + t334 * t106 + t167 * t224 + t169 * t232 + t321 * t18 + t336 * t230 - 0.2e1 * t235 + t239 - t339;
  t344 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * t341 * t23);
  t346 = my_piecewise5(t11, 0, t7, 0, -t320);
  t348 = t176 * t121;
  t350 = t148 * t180;
  t352 = t148 * M_PI;
  t354 = t178 * params->beta;
  t355 = t352 * t16 + t252 + t354;
  t356 = t75 * t355;
  t359 = t355 * t126;
  t361 = t180 * t260;
  t364 = t183 * t277;
  t366 = t348 * t126 + t350 * t126 + t356 * t126 + t359 * t129 + t181 * t267 + t183 * t275 + t361 * t273 + t346 * t36 - 0.2e1 * t278 + t281 - t364;
  t369 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * t366 * t23);
  tv3rho32 = t288 + t289 + t174 + t188 + t3 * (t344 + t369);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t375 = -0.6e1 * t86 - 0.6e1 * t195;
  t376 = my_piecewise5(t7, 0, t11, 0, t375);
  t378 = t162 * t166;
  t381 = t162 * M_PI;
  t384 = t381 * t16 + 0.2e1 * t329;
  t385 = t68 * t384;
  t387 = t101 * t68;
  t390 = 0.2e1 * t217 * t387 + 0.2e1 * t221;
  t391 = t216 * t390;
  t393 = t384 * t103;
  t395 = t390 * t14;
  t396 = t395 * t4;
  t398 = t68 * t4;
  t404 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (0.2e1 * t378 * t103 + t385 * t103 + t393 * t106 + t167 * t391 + t169 * t398 + t376 * t18 + t336 * t396 + t239 - 0.3e1 * t339) * t23);
  t406 = my_piecewise5(t11, 0, t7, 0, -t375);
  t408 = t176 * t180;
  t411 = t176 * M_PI;
  t414 = t411 * t16 + 0.2e1 * t354;
  t415 = t75 * t414;
  t417 = t101 * t75;
  t420 = 0.2e1 * t261 * t417 + 0.2e1 * t264;
  t421 = t260 * t420;
  t423 = t414 * t126;
  t425 = t420 * t33;
  t426 = t425 * t4;
  t428 = t75 * t4;
  t434 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (0.2e1 * t408 * t126 + t415 * t126 + t423 * t129 + t181 * t421 + t183 * t428 + t406 * t36 + t361 * t426 + t281 - 0.3e1 * t364) * t23);
  tv3rho33 = 0.3e1 * t174 + 0.3e1 * t188 + t3 * (t404 + t434);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t13, t14, t15, t16, t17, t18, t20;
  double t21, t22, t23, t24, t29, t31, t32, t33;
  double t34, t35, t36, t38, t39, t44, tzk0;

  double t45, t46, t47, t48, t49, t51, t52, t56;
  double t58, t60, t64, tvrho0, t67, t68, t73, t75;
  double t80, tvrho1;

  double t86, t87, t89, t90, t92, t94, t95, t96;
  double t97, t98, t99, t100, t101, t103, t105, t106;
  double t107, t108, t110, t114, t116, t118, t120, t121;
  double t122, t123, t124, t126, t128, t129, t130, t132;
  double t136, tv2rho20, t139, t140, t142, t147, t148, t150;
  double t155, tv2rho21, t161, t162, t164, t166, t167, t169;
  double t174, t176, t178, t180, t181, t183, t188, tv2rho22;

  double t193, t194, t195, t197, t198, t200, t203, t205;
  double t207, t208, t211, t212, t213, t214, t216, t217;
  double t220, t221, t223, t224, t226, t227, t228, t229;
  double t230, t231, t232, t233, t234, t235, t236, t237;
  double t239, t243, t245, t247, t250, t252, t254, t255;
  double t258, t260, t261, t264, t266, t267, t269, t270;
  double t271, t272, t273, t274, t275, t276, t277, t278;
  double t279, t281, t285, tv3rho30, t288, t289, t290, t291;
  double t292, t293, t295, t298, t304, t306, t308, t311;
  double t317, tv3rho31, t320, t321, t323, t325, t327, t329;
  double t330, t331, t334, t336, t339, t341, t344, t346;
  double t348, t350, t352, t354, t355, t356, t359, t361;
  double t364, t366, t369, tv3rho32, t375, t376, t378, t381;
  double t384, t385, t387, t390, t391, t393, t395, t396;
  double t398, t404, t406, t408, t411, t414, t415, t417;
  double t420, t421, t423, t425, t426, t428, t434, tv3rho33;

  double t439, t440, t443, t446, t450, t452, t453, t455;
  double t456, t461, t467, t468, t470, t471, t473, t475;
  double t476, t477, t478, t479, t480, t481, t483, t484;
  double t486, t499, t501, t504, t505, t506, t507, t509;
  double t510, t512, t514, t517, t519, t520, t521, t522;
  double t525, t526, t527, t530, t533, t538, t539, t541;
  double t542, t547, t553, t554, t556, t557, t566, t568;
  double t571, t572, t573, t575, t581, t583, t586, t588;
  double t589, t590, t592, t594, t595, t596, t597, t598;
  double t599, t600, t602, t603, t606, tv4rho40, t611, t612;
  double t613, t614, t630, t633, t635, t651, t654, tv4rho41;
  double t661, t676, t677, t683, t684, t686, t688, t703;
  double t705, t708, t713, t717, t718, t733, t734, t740;
  double t741, t743, t745, t760, t762, t765, t770, t774;
  double tv4rho42, t779, t780, t786, t788, t800, t806, t811;
  double t812, t815, t834, t835, t848, t852, t857, t863;
  double t874, t875, t880, t886, t888, t889, t901, t902;
  double t922, t926, tv4rho43, t940, t943, t951, t968, t986;
  double t987, t989, t992, t1002, t1005, t1013, t1030, t1048;
  double t1050, t1053, tv4rho44;

  lda_x_1d_exponential_params *params;

  assert(p->params != NULL);
  params = (lda_x_1d_exponential_params * )(p->params);

  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = rho[0] <= p->dens_threshold || t7;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = 0.1e1 - t5 <= p->zeta_threshold;
  t12 = -t9;
  t13 = my_piecewise5(t7, t9, t11, t12, t5);
  t14 = 0.1e1 + t13;
  t15 = t14 * M_PI;
  t16 = params->beta * t3;
  t17 = t15 * t16;
  t18 = xc_integrate(func1, NULL, 1e-20, t17);
  t20 = xc_integrate(func2, NULL, 1e-20, t17);
  t21 = 0.1e1 / M_PI;
  t22 = t20 * t21;
  t23 = 0.1e1 / params->beta;
  t24 = t23 * t4;
  t29 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t14 * t18 - t22 * t24) * t23);
  t31 = rho[1] <= p->dens_threshold || t11;
  t32 = my_piecewise5(t11, t9, t7, t12, -t5);
  t33 = 0.1e1 + t32;
  t34 = t33 * M_PI;
  t35 = t34 * t16;
  t36 = xc_integrate(func1, NULL, 1e-20, t35);
  t38 = xc_integrate(func2, NULL, 1e-20, t35);
  t39 = t38 * t21;
  t44 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (-t39 * t24 + t33 * t36) * t23);
  tzk0 = t29 + t44;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t3 * t3;
  t46 = 0.1e1 / t45;
  t47 = t2 * t46;
  t48 = t4 - t47;
  t49 = my_piecewise5(t7, 0, t11, 0, t48);
  t51 = t23 * t46;
  t52 = t22 * t51;
  t56 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t49 * t18 + t52) * t23);
  t58 = my_piecewise5(t11, 0, t7, 0, -t48);
  t60 = t39 * t51;
  t64 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t58 * t36 + t60) * t23);
  tvrho0 = t29 + t44 + t3 * (t56 + t64);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = -t4 - t47;
  t68 = my_piecewise5(t7, 0, t11, 0, t67);
  t73 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t68 * t18 + t52) * t23);
  t75 = my_piecewise5(t11, 0, t7, 0, -t67);
  t80 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t75 * t36 + t60) * t23);
  tvrho1 = t29 + t44 + t3 * (t73 + t80);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t86 = 0.1e1 / t45 / t3;
  t87 = t2 * t86;
  t89 = -0.2e1 * t46 + 0.2e1 * t87;
  t90 = my_piecewise5(t7, 0, t11, 0, t89);
  t92 = t49 * M_PI;
  t94 = t15 * params->beta;
  t95 = t92 * t16 + t94;
  t96 = t49 * t95;
  t97 = t14 * t14;
  t98 = M_PI * M_PI;
  t99 = t97 * t98;
  t100 = params->beta * params->beta;
  t101 = t100 * t45;
  t103 = xc_E1_scaled(t99 * t101);
  t105 = t95 * t103;
  t106 = t14 * t4;
  t107 = t105 * t106;
  t108 = t23 * t86;
  t110 = 0.2e1 * t22 * t108;
  t114 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t96 * t103 + t90 * t18 + t107 - t110) * t23);
  t116 = my_piecewise5(t11, 0, t7, 0, -t89);
  t118 = t58 * M_PI;
  t120 = t34 * params->beta;
  t121 = t118 * t16 + t120;
  t122 = t58 * t121;
  t123 = t33 * t33;
  t124 = t123 * t98;
  t126 = xc_E1_scaled(t124 * t101);
  t128 = t121 * t126;
  t129 = t33 * t4;
  t130 = t128 * t129;
  t132 = 0.2e1 * t39 * t108;
  t136 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t116 * t36 + t122 * t126 + t130 - t132) * t23);
  tv2rho20 = 0.2e1 * t56 + 0.2e1 * t64 + t3 * (t114 + t136);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t139 = 0.2e1 * t87;
  t140 = my_piecewise5(t7, 0, t11, 0, t139);
  t142 = t68 * t95;
  t147 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t142 * t103 + t140 * t18 + t107 - t110) * t23);
  t148 = my_piecewise5(t11, 0, t7, 0, -t139);
  t150 = t75 * t121;
  t155 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t150 * t126 + t148 * t36 + t130 - t132) * t23);
  tv2rho21 = t56 + t64 + t73 + t80 + t3 * (t147 + t155);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t161 = 0.2e1 * t46 + 0.2e1 * t87;
  t162 = my_piecewise5(t7, 0, t11, 0, t161);
  t164 = t68 * M_PI;
  t166 = t164 * t16 + t94;
  t167 = t68 * t166;
  t169 = t166 * t103;
  t174 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t167 * t103 + t169 * t106 + t162 * t18 - t110) * t23);
  t176 = my_piecewise5(t11, 0, t7, 0, -t161);
  t178 = t75 * M_PI;
  t180 = t178 * t16 + t120;
  t181 = t75 * t180;
  t183 = t180 * t126;
  t188 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t181 * t126 + t183 * t129 + t176 * t36 - t132) * t23);
  tv2rho22 = 0.2e1 * t73 + 0.2e1 * t80 + t3 * (t174 + t188);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t193 = t45 * t45;
  t194 = 0.1e1 / t193;
  t195 = t2 * t194;
  t197 = 0.6e1 * t86 - 0.6e1 * t195;
  t198 = my_piecewise5(t7, 0, t11, 0, t197);
  t200 = t90 * t95;
  t203 = t90 * M_PI;
  t205 = t92 * params->beta;
  t207 = t203 * t16 + 0.2e1 * t205;
  t208 = t49 * t207;
  t211 = 0.1e1 / t98;
  t212 = 0.1e1 / t97 * t211;
  t213 = 0.1e1 / t100;
  t214 = t213 * t46;
  t216 = -t212 * t214 + t103;
  t217 = t14 * t98;
  t220 = t100 * t3;
  t221 = t99 * t220;
  t223 = 0.2e1 * t217 * t101 * t49 + 0.2e1 * t221;
  t224 = t216 * t223;
  t226 = t207 * t103;
  t227 = t226 * t106;
  t228 = t95 * t216;
  t229 = t223 * t14;
  t230 = t229 * t4;
  t231 = t228 * t230;
  t232 = t49 * t4;
  t233 = t105 * t232;
  t234 = t14 * t46;
  t235 = t105 * t234;
  t236 = 0.3e1 * t235;
  t237 = t23 * t194;
  t239 = 0.6e1 * t22 * t237;
  t243 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (0.2e1 * t200 * t103 + t208 * t103 + t198 * t18 + t96 * t224 + t227 + t231 + t233 - t236 + t239) * t23);
  t245 = my_piecewise5(t11, 0, t7, 0, -t197);
  t247 = t116 * t121;
  t250 = t116 * M_PI;
  t252 = t118 * params->beta;
  t254 = t250 * t16 + 0.2e1 * t252;
  t255 = t58 * t254;
  t258 = 0.1e1 / t123 * t211;
  t260 = -t258 * t214 + t126;
  t261 = t33 * t98;
  t264 = t124 * t220;
  t266 = 0.2e1 * t261 * t101 * t58 + 0.2e1 * t264;
  t267 = t260 * t266;
  t269 = t254 * t126;
  t270 = t269 * t129;
  t271 = t121 * t260;
  t272 = t266 * t33;
  t273 = t272 * t4;
  t274 = t271 * t273;
  t275 = t58 * t4;
  t276 = t128 * t275;
  t277 = t33 * t46;
  t278 = t128 * t277;
  t279 = 0.3e1 * t278;
  t281 = 0.6e1 * t39 * t237;
  t285 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t122 * t267 + 0.2e1 * t247 * t126 + t255 * t126 + t245 * t36 + t270 + t274 + t276 - t279 + t281) * t23);
  tv3rho30 = 0.3e1 * t114 + 0.3e1 * t136 + t3 * (t243 + t285);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t288 = 0.2e1 * t147;
  t289 = 0.2e1 * t155;
  t290 = 0.2e1 * t86;
  t291 = 0.6e1 * t195;
  t292 = t290 - t291;
  t293 = my_piecewise5(t7, 0, t11, 0, t292);
  t295 = t140 * t95;
  t298 = t68 * t207;
  t304 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (0.2e1 * t295 * t103 + t298 * t103 + t142 * t224 + t293 * t18 + t227 + t231 + t233 - t236 + t239) * t23);
  t306 = my_piecewise5(t11, 0, t7, 0, -t292);
  t308 = t148 * t121;
  t311 = t75 * t254;
  t317 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (0.2e1 * t308 * t126 + t311 * t126 + t150 * t267 + t306 * t36 + t270 + t274 + t276 - t279 + t281) * t23);
  tv3rho31 = t114 + t136 + t288 + t289 + t3 * (t304 + t317);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t320 = -t290 - t291;
  t321 = my_piecewise5(t7, 0, t11, 0, t320);
  t323 = t162 * t95;
  t325 = t140 * t166;
  t327 = t140 * M_PI;
  t329 = t164 * params->beta;
  t330 = t327 * t16 + t205 + t329;
  t331 = t68 * t330;
  t334 = t330 * t103;
  t336 = t166 * t216;
  t339 = t169 * t234;
  t341 = t323 * t103 + t325 * t103 + t331 * t103 + t334 * t106 + t167 * t224 + t169 * t232 + t321 * t18 + t336 * t230 - 0.2e1 * t235 + t239 - t339;
  t344 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * t341 * t23);
  t346 = my_piecewise5(t11, 0, t7, 0, -t320);
  t348 = t176 * t121;
  t350 = t148 * t180;
  t352 = t148 * M_PI;
  t354 = t178 * params->beta;
  t355 = t352 * t16 + t252 + t354;
  t356 = t75 * t355;
  t359 = t355 * t126;
  t361 = t180 * t260;
  t364 = t183 * t277;
  t366 = t348 * t126 + t350 * t126 + t356 * t126 + t359 * t129 + t181 * t267 + t183 * t275 + t361 * t273 + t346 * t36 - 0.2e1 * t278 + t281 - t364;
  t369 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * t366 * t23);
  tv3rho32 = t288 + t289 + t174 + t188 + t3 * (t344 + t369);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t375 = -0.6e1 * t86 - 0.6e1 * t195;
  t376 = my_piecewise5(t7, 0, t11, 0, t375);
  t378 = t162 * t166;
  t381 = t162 * M_PI;
  t384 = t381 * t16 + 0.2e1 * t329;
  t385 = t68 * t384;
  t387 = t101 * t68;
  t390 = 0.2e1 * t217 * t387 + 0.2e1 * t221;
  t391 = t216 * t390;
  t393 = t384 * t103;
  t395 = t390 * t14;
  t396 = t395 * t4;
  t398 = t68 * t4;
  t404 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (0.2e1 * t378 * t103 + t385 * t103 + t393 * t106 + t167 * t391 + t169 * t398 + t376 * t18 + t336 * t396 + t239 - 0.3e1 * t339) * t23);
  t406 = my_piecewise5(t11, 0, t7, 0, -t375);
  t408 = t176 * t180;
  t411 = t176 * M_PI;
  t414 = t411 * t16 + 0.2e1 * t354;
  t415 = t75 * t414;
  t417 = t101 * t75;
  t420 = 0.2e1 * t261 * t417 + 0.2e1 * t264;
  t421 = t260 * t420;
  t423 = t414 * t126;
  t425 = t420 * t33;
  t426 = t425 * t4;
  t428 = t75 * t4;
  t434 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (0.2e1 * t408 * t126 + t415 * t126 + t423 * t129 + t181 * t421 + t183 * t428 + t406 * t36 + t361 * t426 + t281 - 0.3e1 * t364) * t23);
  tv3rho33 = 0.3e1 * t174 + 0.3e1 * t188 + t3 * (t404 + t434);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t439 = t226 * t234;
  t440 = 0.4e1 * t439;
  t443 = 0.2e1 * t207 * t216 * t230;
  t446 = 0.1e1 / t97 / t14 * t211;
  t450 = t213 * t86;
  t452 = 0.2e1 * t212 * t450;
  t453 = 0.2e1 * t446 * t214 * t49 + t224 + t452;
  t455 = t95 * t453 * t230;
  t456 = t49 * t49;
  t461 = t217 * t220 * t49;
  t467 = 0.2e1 * t99 * t100;
  t468 = 0.2e1 * t217 * t101 * t90 + 0.2e1 * t456 * t98 * t101 + 0.8e1 * t461 + t467;
  t470 = t468 * t14 * t4;
  t471 = t228 * t470;
  t473 = t223 * t49 * t4;
  t475 = 0.2e1 * t228 * t473;
  t476 = t49 * t46;
  t477 = t105 * t476;
  t478 = 0.4e1 * t477;
  t479 = t14 * t86;
  t480 = t105 * t479;
  t481 = 0.12e2 * t480;
  t483 = 0.1e1 / t193 / t3;
  t484 = t23 * t483;
  t486 = 0.24e2 * t22 * t484;
  t499 = t203 * params->beta;
  t501 = t198 * M_PI * t16 + 0.3e1 * t499;
  t504 = t229 * t46;
  t505 = t228 * t504;
  t506 = 0.4e1 * t505;
  t507 = t2 * t483;
  t509 = -0.24e2 * t194 + 0.24e2 * t507;
  t510 = my_piecewise5(t7, 0, t11, 0, t509);
  t512 = t453 * t223;
  t514 = t216 * t468;
  t517 = t501 * t103 * t106;
  t519 = 0.2e1 * t226 * t232;
  t520 = t90 * t4;
  t521 = t105 * t520;
  t522 = 0.3e1 * t198 * t95 * t103 + 0.3e1 * t90 * t207 * t103 + t49 * t501 * t103 + t510 * t18 + 0.3e1 * t200 * t224 + 0.2e1 * t208 * t224 + t96 * t512 + t96 * t514 - t440 + t443 + t455 + t471 + t475 - t478 + t481 - t486 - t506 + t517 + t519 + t521;
  t525 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * t522 * t23);
  t526 = t269 * t277;
  t527 = 0.4e1 * t526;
  t530 = 0.2e1 * t254 * t260 * t273;
  t533 = 0.1e1 / t123 / t33 * t211;
  t538 = 0.2e1 * t258 * t450;
  t539 = 0.2e1 * t533 * t214 * t58 + t267 + t538;
  t541 = t121 * t539 * t273;
  t542 = t58 * t58;
  t547 = t261 * t220 * t58;
  t553 = 0.2e1 * t124 * t100;
  t554 = 0.2e1 * t261 * t101 * t116 + 0.2e1 * t542 * t98 * t101 + 0.8e1 * t547 + t553;
  t556 = t554 * t33 * t4;
  t557 = t271 * t556;
  t566 = t250 * params->beta;
  t568 = t245 * M_PI * t16 + 0.3e1 * t566;
  t571 = t272 * t46;
  t572 = t271 * t571;
  t573 = 0.4e1 * t572;
  t575 = my_piecewise5(t11, 0, t7, 0, -t509);
  t581 = t539 * t266;
  t583 = t260 * t554;
  t586 = t568 * t126 * t129;
  t588 = 0.2e1 * t269 * t275;
  t589 = t116 * t4;
  t590 = t128 * t589;
  t592 = t266 * t58 * t4;
  t594 = 0.2e1 * t271 * t592;
  t595 = t58 * t46;
  t596 = t128 * t595;
  t597 = 0.4e1 * t596;
  t598 = t33 * t86;
  t599 = t128 * t598;
  t600 = 0.12e2 * t599;
  t602 = 0.24e2 * t39 * t484;
  t603 = 0.3e1 * t116 * t254 * t126 + 0.3e1 * t245 * t121 * t126 + t58 * t568 * t126 + t122 * t581 + t122 * t583 + 0.3e1 * t247 * t267 + 0.2e1 * t255 * t267 + t575 * t36 - t527 + t530 + t541 + t557 - t573 + t586 + t588 + t590 + t594 - t597 + t600 - t602;
  t606 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * t603 * t23);
  tv4rho40 = 0.4e1 * t243 + 0.4e1 * t285 + t3 * (t525 + t606);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t611 = 0.12e2 * t194;
  t612 = 0.24e2 * t507;
  t613 = -t611 + t612;
  t614 = my_piecewise5(t7, 0, t11, 0, t613);
  t630 = 0.3e1 * t140 * t207 * t103 + 0.3e1 * t293 * t95 * t103 + t68 * t501 * t103 + t142 * t512 + t142 * t514 + t614 * t18 + 0.3e1 * t295 * t224 + 0.2e1 * t298 * t224 - t440 + t443 + t455 + t471 + t475 - t478 + t481 - t486 - t506 + t517 + t519 + t521;
  t633 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * t630 * t23);
  t635 = my_piecewise5(t11, 0, t7, 0, -t613);
  t651 = 0.3e1 * t306 * t121 * t126 + 0.3e1 * t148 * t254 * t126 + t75 * t568 * t126 + t150 * t581 + t150 * t583 + 0.3e1 * t308 * t267 + 0.2e1 * t311 * t267 + t635 * t36 - t527 + t530 + t541 + t557 - t573 + t586 + t588 + t590 + t594 - t597 + t600 - t602;
  t654 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * t651 * t23);
  tv4rho41 = t243 + t285 + 0.3e1 * t304 + 0.3e1 * t317 + t3 * (t633 + t654);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t661 = my_piecewise5(t7, 0, t11, 0, t612);
  t676 = 0.2e1 * t327 * params->beta;
  t677 = t293 * M_PI * t16 + t499 + t676;
  t683 = t677 * t103 * t106 + t167 * t512 + t167 * t514 + t169 * t520 + t661 * t18 + t323 * t224 + 0.2e1 * t325 * t224 + 0.2e1 * t331 * t224 + 0.2e1 * t334 * t232 - 0.2e1 * t439 - 0.2e1 * t477 + 0.1e2 * t480 - t486;
  t684 = t334 * t234;
  t686 = t169 * t476;
  t688 = t169 * t479;
  t703 = t336 * t504;
  t705 = t330 * t216;
  t708 = t166 * t453;
  t713 = 0.2e1 * t140 * t330 * t103 + t162 * t207 * t103 + t293 * t166 * t103 + 0.2e1 * t321 * t95 * t103 + t68 * t677 * t103 + 0.2e1 * t705 * t230 + t708 * t230 + t336 * t470 + 0.2e1 * t336 * t473 - 0.2e1 * t505 - 0.2e1 * t684 - 0.2e1 * t686 + 0.2e1 * t688 - 0.2e1 * t703;
  t717 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t683 + t713) * t23);
  t718 = my_piecewise5(t11, 0, t7, 0, -t612);
  t733 = 0.2e1 * t352 * params->beta;
  t734 = t306 * M_PI * t16 + t566 + t733;
  t740 = t734 * t126 * t129 + t181 * t581 + t181 * t583 + t183 * t589 + t348 * t267 + 0.2e1 * t350 * t267 + 0.2e1 * t356 * t267 + 0.2e1 * t359 * t275 + t718 * t36 - 0.2e1 * t526 - 0.2e1 * t596 + 0.1e2 * t599 - t602;
  t741 = t359 * t277;
  t743 = t183 * t595;
  t745 = t183 * t598;
  t760 = t361 * t571;
  t762 = t355 * t260;
  t765 = t180 * t539;
  t770 = 0.2e1 * t346 * t121 * t126 + 0.2e1 * t148 * t355 * t126 + t176 * t254 * t126 + t306 * t180 * t126 + t75 * t734 * t126 + 0.2e1 * t762 * t273 + t765 * t273 + t361 * t556 + 0.2e1 * t361 * t592 - 0.2e1 * t572 - 0.2e1 * t741 - 0.2e1 * t743 + 0.2e1 * t745 - 0.2e1 * t760;
  t774 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t740 + t770) * t23);
  tv4rho42 = 0.2e1 * t304 + 0.2e1 * t317 + 0.2e1 * t344 + 0.2e1 * t369 + t3 * (t717 + t774);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t779 = t611 + t612;
  t780 = my_piecewise5(t7, 0, t11, 0, t779);
  t786 = t393 * t234;
  t788 = t169 * t68 * t46;
  t800 = t217 * t220 * t68;
  t806 = 0.2e1 * t217 * t101 * t140 + 0.2e1 * t49 * t98 * t387 + 0.4e1 * t461 + t467 + 0.4e1 * t800;
  t811 = t381 * params->beta;
  t812 = t321 * M_PI * t16 + t676 + t811;
  t815 = t812 * t103 * t106 + t167 * t216 * t806 + t167 * t453 * t390 + t780 * t18 + 0.2e1 * t378 * t224 + t385 * t224 + t325 * t391 + t331 * t391 + 0.6e1 * t480 - t486 - 0.3e1 * t684 - 0.3e1 * t686 + 0.6e1 * t688 - t786 - t788;
  t834 = t336 * t395 * t46;
  t835 = t384 * t216;
  t848 = t336 * t806 * t14 * t4 + t336 * t223 * t68 * t4 + t336 * t390 * t49 * t4 + t140 * t384 * t103 + 0.2e1 * t162 * t330 * t103 + 0.2e1 * t321 * t166 * t103 + t376 * t95 * t103 + t68 * t812 * t103 + t169 * t140 * t4 + t835 * t230 + t393 * t232 + t334 * t398 + t705 * t396 + t708 * t396 - 0.3e1 * t703 - t834;
  t852 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * (t815 + t848) * t23);
  t857 = t261 * t220 * t75;
  t863 = 0.2e1 * t261 * t101 * t148 + 0.2e1 * t58 * t98 * t417 + 0.4e1 * t547 + t553 + 0.4e1 * t857;
  t874 = t361 * t425 * t46;
  t875 = t414 * t260;
  t880 = my_piecewise5(t11, 0, t7, 0, -t779);
  t886 = t423 * t277;
  t888 = t183 * t75 * t46;
  t889 = t361 * t266 * t75 * t4 + t361 * t863 * t33 * t4 + t361 * t420 * t58 * t4 + t875 * t273 + t880 * t36 + t762 * t426 + t765 * t426 + 0.6e1 * t599 - t602 - 0.3e1 * t741 - 0.3e1 * t743 + 0.6e1 * t745 - t874 - t886 - t888;
  t901 = t411 * params->beta;
  t902 = t346 * M_PI * t16 + t733 + t901;
  t922 = t406 * t121 * t126 + t902 * t126 * t129 + t148 * t414 * t126 + 0.2e1 * t176 * t355 * t126 + 0.2e1 * t346 * t180 * t126 + t75 * t902 * t126 + t183 * t148 * t4 + t181 * t260 * t863 + t181 * t539 * t420 + 0.2e1 * t408 * t267 + t415 * t267 + t423 * t275 + t350 * t421 + t356 * t421 + t359 * t428 - 0.3e1 * t760;
  t926 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * (t889 + t922) * t23);
  tv4rho43 = 0.3e1 * t344 + 0.3e1 * t369 + t404 + t434 + t3 * (t852 + t926);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t940 = 0.2e1 * t446 * t214 * t68 + t391 + t452;
  t943 = t68 * t68;
  t951 = 0.2e1 * t217 * t101 * t162 + 0.2e1 * t943 * t98 * t101 + t467 + 0.8e1 * t800;
  t968 = t376 * M_PI * t16 + 0.3e1 * t811;
  t986 = 0.24e2 * t194 + 0.24e2 * t507;
  t987 = my_piecewise5(t7, 0, t11, 0, t986);
  t989 = -t486 - 0.4e1 * t834 + 0.12e2 * t688 - 0.4e1 * t786 - 0.4e1 * t788 + 0.2e1 * t835 * t396 + t166 * t940 * t396 + t336 * t951 * t14 * t4 + 0.2e1 * t336 * t390 * t68 * t4 + 0.3e1 * t376 * t166 * t103 + 0.3e1 * t162 * t384 * t103 + t68 * t968 * t103 + 0.3e1 * t378 * t391 + 0.2e1 * t385 * t391 + t167 * t940 * t390 + t167 * t216 * t951 + t968 * t103 * t106 + 0.2e1 * t393 * t398 + t169 * t162 * t4 + t987 * t18;
  t992 = my_piecewise3(t8, 0, -0.79577471545947667883e-1 * t989 * t23);
  t1002 = 0.2e1 * t533 * t214 * t75 + t421 + t538;
  t1005 = t75 * t75;
  t1013 = 0.2e1 * t1005 * t98 * t101 + 0.2e1 * t261 * t101 * t176 + t553 + 0.8e1 * t857;
  t1030 = t406 * M_PI * t16 + 0.3e1 * t901;
  t1048 = my_piecewise5(t11, 0, t7, 0, -t986);
  t1050 = -0.4e1 * t874 - t602 + 0.12e2 * t745 - 0.4e1 * t886 - 0.4e1 * t888 + 0.2e1 * t875 * t426 + t180 * t1002 * t426 + t361 * t1013 * t33 * t4 + 0.2e1 * t361 * t420 * t75 * t4 + 0.3e1 * t406 * t180 * t126 + 0.3e1 * t176 * t414 * t126 + t75 * t1030 * t126 + 0.3e1 * t408 * t421 + 0.2e1 * t415 * t421 + t181 * t1002 * t420 + t181 * t260 * t1013 + t1030 * t126 * t129 + 0.2e1 * t423 * t428 + t183 * t176 * t4 + t1048 * t36;
  t1053 = my_piecewise3(t31, 0, -0.79577471545947667883e-1 * t1050 * t23);
  tv4rho44 = 0.4e1 * t404 + 0.4e1 * t434 + t3 * (t992 + t1053);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

