// ------------------------------------------------------------------------------
// NOTE: This file was generated from Microsoft's Language Server Protocol (LSP)
// specification. Please do not edit it by hand.
// ------------------------------------------------------------------------------

#include <stdexcept>

#include <server/lsp_specification.h>

namespace LCompilers::LanguageServerProtocol {

    const std::map<SemanticTokenTypes, std::string> SemanticTokenTypesNames = {
        {SemanticTokenTypes::Namespace, "Namespace"},
        {SemanticTokenTypes::Type, "Type"},
        {SemanticTokenTypes::Class, "Class"},
        {SemanticTokenTypes::Enum, "Enum"},
        {SemanticTokenTypes::Interface, "Interface"},
        {SemanticTokenTypes::Struct, "Struct"},
        {SemanticTokenTypes::TypeParameter, "TypeParameter"},
        {SemanticTokenTypes::Parameter, "Parameter"},
        {SemanticTokenTypes::Variable, "Variable"},
        {SemanticTokenTypes::Property, "Property"},
        {SemanticTokenTypes::EnumMember, "EnumMember"},
        {SemanticTokenTypes::Event, "Event"},
        {SemanticTokenTypes::Function, "Function"},
        {SemanticTokenTypes::Method, "Method"},
        {SemanticTokenTypes::Macro, "Macro"},
        {SemanticTokenTypes::Keyword, "Keyword"},
        {SemanticTokenTypes::Modifier, "Modifier"},
        {SemanticTokenTypes::Comment, "Comment"},
        {SemanticTokenTypes::String, "String"},
        {SemanticTokenTypes::Number, "Number"},
        {SemanticTokenTypes::Regexp, "Regexp"},
        {SemanticTokenTypes::Operator, "Operator"},
        {SemanticTokenTypes::Decorator, "Decorator"},
    };

    const std::map<SemanticTokenTypes, std::string>
    SemanticTokenTypesValues = {
        {SemanticTokenTypes::Namespace, "namespace"},
        {SemanticTokenTypes::Type, "type"},
        {SemanticTokenTypes::Class, "class"},
        {SemanticTokenTypes::Enum, "enum"},
        {SemanticTokenTypes::Interface, "interface"},
        {SemanticTokenTypes::Struct, "struct"},
        {SemanticTokenTypes::TypeParameter, "typeParameter"},
        {SemanticTokenTypes::Parameter, "parameter"},
        {SemanticTokenTypes::Variable, "variable"},
        {SemanticTokenTypes::Property, "property"},
        {SemanticTokenTypes::EnumMember, "enumMember"},
        {SemanticTokenTypes::Event, "event"},
        {SemanticTokenTypes::Function, "function"},
        {SemanticTokenTypes::Method, "method"},
        {SemanticTokenTypes::Macro, "macro"},
        {SemanticTokenTypes::Keyword, "keyword"},
        {SemanticTokenTypes::Modifier, "modifier"},
        {SemanticTokenTypes::Comment, "comment"},
        {SemanticTokenTypes::String, "string"},
        {SemanticTokenTypes::Number, "number"},
        {SemanticTokenTypes::Regexp, "regexp"},
        {SemanticTokenTypes::Operator, "operator"},
        {SemanticTokenTypes::Decorator, "decorator"},
    };

    auto semanticTokenTypesByName(
        const std::string &name
    ) -> SemanticTokenTypes
    {
        for (const auto &[enum_name, enum_value] : SemanticTokenTypesNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SemanticTokenTypes name: " + name
        );
    }

    auto semanticTokenTypesByValue(
        const std::string &value
    ) -> SemanticTokenTypes
    {
        for (const auto &[enum_name, enum_value] : SemanticTokenTypesValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SemanticTokenTypes value: \"" + value + "\""
        );
    }

    auto isSemanticTokenTypes(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : SemanticTokenTypesValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<SemanticTokenModifiers, std::string>
    SemanticTokenModifiersNames = {
        {SemanticTokenModifiers::Declaration, "Declaration"},
        {SemanticTokenModifiers::Definition, "Definition"},
        {SemanticTokenModifiers::Readonly, "Readonly"},
        {SemanticTokenModifiers::Static, "Static"},
        {SemanticTokenModifiers::Deprecated, "Deprecated"},
        {SemanticTokenModifiers::Abstract, "Abstract"},
        {SemanticTokenModifiers::Async, "Async"},
        {SemanticTokenModifiers::Modification, "Modification"},
        {SemanticTokenModifiers::Documentation, "Documentation"},
        {SemanticTokenModifiers::DefaultLibrary, "DefaultLibrary"},
    };

    const std::map<SemanticTokenModifiers, std::string>
    SemanticTokenModifiersValues = {
        {SemanticTokenModifiers::Declaration, "declaration"},
        {SemanticTokenModifiers::Definition, "definition"},
        {SemanticTokenModifiers::Readonly, "readonly"},
        {SemanticTokenModifiers::Static, "static"},
        {SemanticTokenModifiers::Deprecated, "deprecated"},
        {SemanticTokenModifiers::Abstract, "abstract"},
        {SemanticTokenModifiers::Async, "async"},
        {SemanticTokenModifiers::Modification, "modification"},
        {SemanticTokenModifiers::Documentation, "documentation"},
        {SemanticTokenModifiers::DefaultLibrary, "defaultLibrary"},
    };

    auto semanticTokenModifiersByName(
        const std::string &name
    ) -> SemanticTokenModifiers
    {
        for (const auto &[enum_name, enum_value]
                : SemanticTokenModifiersNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SemanticTokenModifiers name: " + name
        );
    }

    auto semanticTokenModifiersByValue(
        const std::string &value
    ) -> SemanticTokenModifiers
    {
        for (const auto &[enum_name, enum_value]
                : SemanticTokenModifiersValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SemanticTokenModifiers value: \"" + value + "\""
        );
    }

    auto isSemanticTokenModifiers(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value]
                : SemanticTokenModifiersValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<DocumentDiagnosticReportKind, std::string>
    DocumentDiagnosticReportKindNames = {
        {DocumentDiagnosticReportKind::Full, "Full"},
        {DocumentDiagnosticReportKind::Unchanged, "Unchanged"},
    };

    const std::map<DocumentDiagnosticReportKind, std::string>
    DocumentDiagnosticReportKindValues = {
        {DocumentDiagnosticReportKind::Full, "full"},
        {DocumentDiagnosticReportKind::Unchanged, "unchanged"},
    };

    auto documentDiagnosticReportKindByName(
        const std::string &name
    ) -> DocumentDiagnosticReportKind
    {
        for (const auto &[enum_name, enum_value]
                : DocumentDiagnosticReportKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid DocumentDiagnosticReportKind name: " + name
        );
    }

    auto documentDiagnosticReportKindByValue(
        const std::string &value
    ) -> DocumentDiagnosticReportKind
    {
        for (const auto &[enum_name, enum_value]
                : DocumentDiagnosticReportKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid DocumentDiagnosticReportKind value: \"" + value + "\""
        );
    }

    auto isDocumentDiagnosticReportKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value]
                : DocumentDiagnosticReportKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<ErrorCodes, std::string> ErrorCodesNames = {
        {ErrorCodes::ParseError, "ParseError"},
        {ErrorCodes::InvalidRequest, "InvalidRequest"},
        {ErrorCodes::MethodNotFound, "MethodNotFound"},
        {ErrorCodes::InvalidParams, "InvalidParams"},
        {ErrorCodes::InternalError, "InternalError"},
        {ErrorCodes::ServerNotInitialized, "ServerNotInitialized"},
        {ErrorCodes::UnknownErrorCode, "UnknownErrorCode"},
    };

    auto errorCodesByName(const std::string &name) -> ErrorCodes
    {
        for (const auto &[enum_name, enum_value] : ErrorCodesNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid ErrorCodes name: " + name);
    }

    auto errorCodesByValue(int value) -> ErrorCodes
    {
        for (const auto &[enum_name, enum_value] : ErrorCodesNames) {
            if (value == static_cast<int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid ErrorCodes value: " + std::to_string(value)
        );
    }


    const std::map<LSPErrorCodes, std::string> LSPErrorCodesNames = {
        {LSPErrorCodes::RequestFailed, "RequestFailed"},
        {LSPErrorCodes::ServerCancelled, "ServerCancelled"},
        {LSPErrorCodes::ContentModified, "ContentModified"},
        {LSPErrorCodes::RequestCancelled, "RequestCancelled"},
    };

    auto lspErrorCodesByName(const std::string &name) -> LSPErrorCodes
    {
        for (const auto &[enum_name, enum_value] : LSPErrorCodesNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid LSPErrorCodes name: " + name);
    }

    auto lspErrorCodesByValue(int value) -> LSPErrorCodes
    {
        for (const auto &[enum_name, enum_value] : LSPErrorCodesNames) {
            if (value == static_cast<int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid LSPErrorCodes value: " + std::to_string(value)
        );
    }


    const std::map<FoldingRangeKind, std::string> FoldingRangeKindNames = {
        {FoldingRangeKind::Comment, "Comment"},
        {FoldingRangeKind::Imports, "Imports"},
        {FoldingRangeKind::Region, "Region"},
    };

    const std::map<FoldingRangeKind, std::string> FoldingRangeKindValues = {
        {FoldingRangeKind::Comment, "comment"},
        {FoldingRangeKind::Imports, "imports"},
        {FoldingRangeKind::Region, "region"},
    };

    auto foldingRangeKindByName(const std::string &name) -> FoldingRangeKind
    {
        for (const auto &[enum_name, enum_value] : FoldingRangeKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid FoldingRangeKind name: " + name);
    }

    auto foldingRangeKindByValue(const std::string &value) -> FoldingRangeKind
    {
        for (const auto &[enum_name, enum_value] : FoldingRangeKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid FoldingRangeKind value: \"" + value + "\""
        );
    }

    auto isFoldingRangeKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : FoldingRangeKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    FoldingRangeClientCapabilities_foldingRangeKind::FoldingRangeClientCapabilities_foldingRangeKind()
    {
        // empty
    }

    FoldingRangeClientCapabilities_foldingRangeKind::FoldingRangeClientCapabilities_foldingRangeKind(
        FoldingRangeClientCapabilities_foldingRangeKind &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    FoldingRangeClientCapabilities_foldingRangeKind::FoldingRangeClientCapabilities_foldingRangeKind(
        const FoldingRangeClientCapabilities_foldingRangeKind &other
    )
    {
        if (other.valueSet.has_value()) {
            auto &array_0 = valueSet.emplace();
            const auto &array_1 = other.valueSet.value();
            array_0 = array_1;
        }
    }

    FoldingRangeClientCapabilities_foldingRangeKind::~FoldingRangeClientCapabilities_foldingRangeKind()
    {
        // empty
    }

    auto FoldingRangeClientCapabilities_foldingRangeKind::operator=(
        FoldingRangeClientCapabilities_foldingRangeKind &&other
    ) -> FoldingRangeClientCapabilities_foldingRangeKind &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto FoldingRangeClientCapabilities_foldingRangeKind::operator=(
        const FoldingRangeClientCapabilities_foldingRangeKind &other
    ) -> FoldingRangeClientCapabilities_foldingRangeKind &
    {
        if (this != &other) {
            if (other.valueSet.has_value()) {
                auto &array_0 = valueSet.emplace();
                const auto &array_1 = other.valueSet.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    const std::map<SymbolKind, std::string> SymbolKindNames = {
        {SymbolKind::File, "File"},
        {SymbolKind::Module, "Module"},
        {SymbolKind::Namespace, "Namespace"},
        {SymbolKind::Package, "Package"},
        {SymbolKind::Class, "Class"},
        {SymbolKind::Method, "Method"},
        {SymbolKind::Property, "Property"},
        {SymbolKind::Field, "Field"},
        {SymbolKind::Constructor, "Constructor"},
        {SymbolKind::Enum, "Enum"},
        {SymbolKind::Interface, "Interface"},
        {SymbolKind::Function, "Function"},
        {SymbolKind::Variable, "Variable"},
        {SymbolKind::Constant, "Constant"},
        {SymbolKind::String, "String"},
        {SymbolKind::Number, "Number"},
        {SymbolKind::Boolean, "Boolean"},
        {SymbolKind::Array, "Array"},
        {SymbolKind::Object, "Object"},
        {SymbolKind::Key, "Key"},
        {SymbolKind::Null, "Null"},
        {SymbolKind::EnumMember, "EnumMember"},
        {SymbolKind::Struct, "Struct"},
        {SymbolKind::Event, "Event"},
        {SymbolKind::Operator, "Operator"},
        {SymbolKind::TypeParameter, "TypeParameter"},
    };

    auto symbolKindByName(const std::string &name) -> SymbolKind
    {
        for (const auto &[enum_name, enum_value] : SymbolKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid SymbolKind name: " + name);
    }

    auto symbolKindByValue(unsigned int value) -> SymbolKind
    {
        for (const auto &[enum_name, enum_value] : SymbolKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SymbolKind value: " + std::to_string(value)
        );
    }


    WorkspaceSymbolClientCapabilities_symbolKind::WorkspaceSymbolClientCapabilities_symbolKind()
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities_symbolKind::WorkspaceSymbolClientCapabilities_symbolKind(
        WorkspaceSymbolClientCapabilities_symbolKind &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities_symbolKind::WorkspaceSymbolClientCapabilities_symbolKind(
        const WorkspaceSymbolClientCapabilities_symbolKind &other
    )
    {
        if (other.valueSet.has_value()) {
            auto &array_0 = valueSet.emplace();
            const auto &array_1 = other.valueSet.value();
            array_0 = array_1;
        }
    }

    WorkspaceSymbolClientCapabilities_symbolKind::~WorkspaceSymbolClientCapabilities_symbolKind()
    {
        // empty
    }

    auto WorkspaceSymbolClientCapabilities_symbolKind::operator=(
        WorkspaceSymbolClientCapabilities_symbolKind &&other
    ) -> WorkspaceSymbolClientCapabilities_symbolKind &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto WorkspaceSymbolClientCapabilities_symbolKind::operator=(
        const WorkspaceSymbolClientCapabilities_symbolKind &other
    ) -> WorkspaceSymbolClientCapabilities_symbolKind &
    {
        if (this != &other) {
            if (other.valueSet.has_value()) {
                auto &array_0 = valueSet.emplace();
                const auto &array_1 = other.valueSet.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    DocumentSymbolClientCapabilities_symbolKind::DocumentSymbolClientCapabilities_symbolKind()
    {
        // empty
    }

    DocumentSymbolClientCapabilities_symbolKind::DocumentSymbolClientCapabilities_symbolKind(
        DocumentSymbolClientCapabilities_symbolKind &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    DocumentSymbolClientCapabilities_symbolKind::DocumentSymbolClientCapabilities_symbolKind(
        const DocumentSymbolClientCapabilities_symbolKind &other
    )
    {
        if (other.valueSet.has_value()) {
            auto &array_0 = valueSet.emplace();
            const auto &array_1 = other.valueSet.value();
            array_0 = array_1;
        }
    }

    DocumentSymbolClientCapabilities_symbolKind::~DocumentSymbolClientCapabilities_symbolKind()
    {
        // empty
    }

    auto DocumentSymbolClientCapabilities_symbolKind::operator=(
        DocumentSymbolClientCapabilities_symbolKind &&other
    ) -> DocumentSymbolClientCapabilities_symbolKind &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto DocumentSymbolClientCapabilities_symbolKind::operator=(
        const DocumentSymbolClientCapabilities_symbolKind &other
    ) -> DocumentSymbolClientCapabilities_symbolKind &
    {
        if (this != &other) {
            if (other.valueSet.has_value()) {
                auto &array_0 = valueSet.emplace();
                const auto &array_1 = other.valueSet.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    const std::map<SymbolTag, std::string> SymbolTagNames = {
        {SymbolTag::Deprecated, "Deprecated"},
    };

    auto symbolTagByName(const std::string &name) -> SymbolTag
    {
        for (const auto &[enum_name, enum_value] : SymbolTagNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid SymbolTag name: " + name);
    }

    auto symbolTagByValue(unsigned int value) -> SymbolTag
    {
        for (const auto &[enum_name, enum_value] : SymbolTagNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SymbolTag value: " + std::to_string(value)
        );
    }


    WorkspaceSymbolClientCapabilities_tagSupport::WorkspaceSymbolClientCapabilities_tagSupport()
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities_tagSupport::WorkspaceSymbolClientCapabilities_tagSupport(
        WorkspaceSymbolClientCapabilities_tagSupport &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities_tagSupport::WorkspaceSymbolClientCapabilities_tagSupport(
        const WorkspaceSymbolClientCapabilities_tagSupport &other
    )
    {
        valueSet = other.valueSet;
    }

    WorkspaceSymbolClientCapabilities_tagSupport::~WorkspaceSymbolClientCapabilities_tagSupport()
    {
        // empty
    }

    auto WorkspaceSymbolClientCapabilities_tagSupport::operator=(
        WorkspaceSymbolClientCapabilities_tagSupport &&other
    ) -> WorkspaceSymbolClientCapabilities_tagSupport &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto WorkspaceSymbolClientCapabilities_tagSupport::operator=(
        const WorkspaceSymbolClientCapabilities_tagSupport &other
    ) -> WorkspaceSymbolClientCapabilities_tagSupport &
    {
        if (this != &other) {
            valueSet = other.valueSet;
        }
        return *this;
    }

    DocumentSymbolClientCapabilities_tagSupport::DocumentSymbolClientCapabilities_tagSupport()
    {
        // empty
    }

    DocumentSymbolClientCapabilities_tagSupport::DocumentSymbolClientCapabilities_tagSupport(
        DocumentSymbolClientCapabilities_tagSupport &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    DocumentSymbolClientCapabilities_tagSupport::DocumentSymbolClientCapabilities_tagSupport(
        const DocumentSymbolClientCapabilities_tagSupport &other
    )
    {
        valueSet = other.valueSet;
    }

    DocumentSymbolClientCapabilities_tagSupport::~DocumentSymbolClientCapabilities_tagSupport()
    {
        // empty
    }

    auto DocumentSymbolClientCapabilities_tagSupport::operator=(
        DocumentSymbolClientCapabilities_tagSupport &&other
    ) -> DocumentSymbolClientCapabilities_tagSupport &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto DocumentSymbolClientCapabilities_tagSupport::operator=(
        const DocumentSymbolClientCapabilities_tagSupport &other
    ) -> DocumentSymbolClientCapabilities_tagSupport &
    {
        if (this != &other) {
            valueSet = other.valueSet;
        }
        return *this;
    }

    const std::map<UniquenessLevel, std::string> UniquenessLevelNames = {
        {UniquenessLevel::Document, "Document"},
        {UniquenessLevel::Project, "Project"},
        {UniquenessLevel::Group, "Group"},
        {UniquenessLevel::Scheme, "Scheme"},
        {UniquenessLevel::Global, "Global"},
    };

    const std::map<UniquenessLevel, std::string> UniquenessLevelValues = {
        {UniquenessLevel::Document, "document"},
        {UniquenessLevel::Project, "project"},
        {UniquenessLevel::Group, "group"},
        {UniquenessLevel::Scheme, "scheme"},
        {UniquenessLevel::Global, "global"},
    };

    auto uniquenessLevelByName(const std::string &name) -> UniquenessLevel
    {
        for (const auto &[enum_name, enum_value] : UniquenessLevelNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid UniquenessLevel name: " + name);
    }

    auto uniquenessLevelByValue(const std::string &value) -> UniquenessLevel
    {
        for (const auto &[enum_name, enum_value] : UniquenessLevelValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid UniquenessLevel value: \"" + value + "\""
        );
    }

    auto isUniquenessLevel(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : UniquenessLevelValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<MonikerKind, std::string> MonikerKindNames = {
        {MonikerKind::Import, "Import"},
        {MonikerKind::Export, "Export"},
        {MonikerKind::Local, "Local"},
    };

    const std::map<MonikerKind, std::string> MonikerKindValues = {
        {MonikerKind::Import, "import"},
        {MonikerKind::Export, "export"},
        {MonikerKind::Local, "local"},
    };

    auto monikerKindByName(const std::string &name) -> MonikerKind
    {
        for (const auto &[enum_name, enum_value] : MonikerKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid MonikerKind name: " + name);
    }

    auto monikerKindByValue(const std::string &value) -> MonikerKind
    {
        for (const auto &[enum_name, enum_value] : MonikerKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid MonikerKind value: \"" + value + "\""
        );
    }

    auto isMonikerKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : MonikerKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<InlayHintKind, std::string> InlayHintKindNames = {
        {InlayHintKind::Type, "Type"},
        {InlayHintKind::Parameter, "Parameter"},
    };

    auto inlayHintKindByName(const std::string &name) -> InlayHintKind
    {
        for (const auto &[enum_name, enum_value] : InlayHintKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid InlayHintKind name: " + name);
    }

    auto inlayHintKindByValue(unsigned int value) -> InlayHintKind
    {
        for (const auto &[enum_name, enum_value] : InlayHintKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid InlayHintKind value: " + std::to_string(value)
        );
    }


    const std::map<MessageType, std::string> MessageTypeNames = {
        {MessageType::Error, "Error"},
        {MessageType::Warning, "Warning"},
        {MessageType::Info, "Info"},
        {MessageType::Log, "Log"},
        {MessageType::Debug, "Debug"},
    };

    auto messageTypeByName(const std::string &name) -> MessageType
    {
        for (const auto &[enum_name, enum_value] : MessageTypeNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid MessageType name: " + name);
    }

    auto messageTypeByValue(unsigned int value) -> MessageType
    {
        for (const auto &[enum_name, enum_value] : MessageTypeNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid MessageType value: " + std::to_string(value)
        );
    }


    const std::map<TextDocumentSyncKind, std::string>
    TextDocumentSyncKindNames = {
        {TextDocumentSyncKind::None, "None"},
        {TextDocumentSyncKind::Full, "Full"},
        {TextDocumentSyncKind::Incremental, "Incremental"},
    };

    auto textDocumentSyncKindByName(
        const std::string &name
    ) -> TextDocumentSyncKind
    {
        for (const auto &[enum_name, enum_value] : TextDocumentSyncKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid TextDocumentSyncKind name: " + name
        );
    }

    auto textDocumentSyncKindByValue(
        unsigned int value
    ) -> TextDocumentSyncKind
    {
        for (const auto &[enum_name, enum_value] : TextDocumentSyncKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid TextDocumentSyncKind value: " + std::to_string(value)
        );
    }


    const std::map<TextDocumentSaveReason, std::string>
    TextDocumentSaveReasonNames = {
        {TextDocumentSaveReason::Manual, "Manual"},
        {TextDocumentSaveReason::AfterDelay, "AfterDelay"},
        {TextDocumentSaveReason::FocusOut, "FocusOut"},
    };

    auto textDocumentSaveReasonByName(
        const std::string &name
    ) -> TextDocumentSaveReason
    {
        for (const auto &[enum_name, enum_value]
                : TextDocumentSaveReasonNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid TextDocumentSaveReason name: " + name
        );
    }

    auto textDocumentSaveReasonByValue(
        unsigned int value
    ) -> TextDocumentSaveReason
    {
        for (const auto &[enum_name, enum_value]
                : TextDocumentSaveReasonNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid TextDocumentSaveReason value: " + std::to_string(value)
        );
    }


    const std::map<CompletionItemKind, std::string> CompletionItemKindNames = {
        {CompletionItemKind::Text, "Text"},
        {CompletionItemKind::Method, "Method"},
        {CompletionItemKind::Function, "Function"},
        {CompletionItemKind::Constructor, "Constructor"},
        {CompletionItemKind::Field, "Field"},
        {CompletionItemKind::Variable, "Variable"},
        {CompletionItemKind::Class, "Class"},
        {CompletionItemKind::Interface, "Interface"},
        {CompletionItemKind::Module, "Module"},
        {CompletionItemKind::Property, "Property"},
        {CompletionItemKind::Unit, "Unit"},
        {CompletionItemKind::Value, "Value"},
        {CompletionItemKind::Enum, "Enum"},
        {CompletionItemKind::Keyword, "Keyword"},
        {CompletionItemKind::Snippet, "Snippet"},
        {CompletionItemKind::Color, "Color"},
        {CompletionItemKind::File, "File"},
        {CompletionItemKind::Reference, "Reference"},
        {CompletionItemKind::Folder, "Folder"},
        {CompletionItemKind::EnumMember, "EnumMember"},
        {CompletionItemKind::Constant, "Constant"},
        {CompletionItemKind::Struct, "Struct"},
        {CompletionItemKind::Event, "Event"},
        {CompletionItemKind::Operator, "Operator"},
        {CompletionItemKind::TypeParameter, "TypeParameter"},
    };

    auto completionItemKindByName(
        const std::string &name
    ) -> CompletionItemKind
    {
        for (const auto &[enum_name, enum_value] : CompletionItemKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CompletionItemKind name: " + name
        );
    }

    auto completionItemKindByValue(unsigned int value) -> CompletionItemKind
    {
        for (const auto &[enum_name, enum_value] : CompletionItemKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CompletionItemKind value: " + std::to_string(value)
        );
    }


    CompletionClientCapabilities_completionItemKind::CompletionClientCapabilities_completionItemKind()
    {
        // empty
    }

    CompletionClientCapabilities_completionItemKind::CompletionClientCapabilities_completionItemKind(
        CompletionClientCapabilities_completionItemKind &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    CompletionClientCapabilities_completionItemKind::CompletionClientCapabilities_completionItemKind(
        const CompletionClientCapabilities_completionItemKind &other
    )
    {
        if (other.valueSet.has_value()) {
            auto &array_0 = valueSet.emplace();
            const auto &array_1 = other.valueSet.value();
            array_0 = array_1;
        }
    }

    CompletionClientCapabilities_completionItemKind::~CompletionClientCapabilities_completionItemKind()
    {
        // empty
    }

    auto CompletionClientCapabilities_completionItemKind::operator=(
        CompletionClientCapabilities_completionItemKind &&other
    ) -> CompletionClientCapabilities_completionItemKind &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto CompletionClientCapabilities_completionItemKind::operator=(
        const CompletionClientCapabilities_completionItemKind &other
    ) -> CompletionClientCapabilities_completionItemKind &
    {
        if (this != &other) {
            if (other.valueSet.has_value()) {
                auto &array_0 = valueSet.emplace();
                const auto &array_1 = other.valueSet.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    const std::map<CompletionItemTag, std::string> CompletionItemTagNames = {
        {CompletionItemTag::Deprecated, "Deprecated"},
    };

    auto completionItemTagByName(const std::string &name) -> CompletionItemTag
    {
        for (const auto &[enum_name, enum_value] : CompletionItemTagNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid CompletionItemTag name: " + name);
    }

    auto completionItemTagByValue(unsigned int value) -> CompletionItemTag
    {
        for (const auto &[enum_name, enum_value] : CompletionItemTagNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CompletionItemTag value: " + std::to_string(value)
        );
    }


    CompletionClientCapabilities_completionItem_tagSupport::CompletionClientCapabilities_completionItem_tagSupport()
    {
        // empty
    }

    CompletionClientCapabilities_completionItem_tagSupport::CompletionClientCapabilities_completionItem_tagSupport(
        CompletionClientCapabilities_completionItem_tagSupport &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    CompletionClientCapabilities_completionItem_tagSupport::CompletionClientCapabilities_completionItem_tagSupport(
        const CompletionClientCapabilities_completionItem_tagSupport &other
    )
    {
        valueSet = other.valueSet;
    }

    CompletionClientCapabilities_completionItem_tagSupport::~CompletionClientCapabilities_completionItem_tagSupport()
    {
        // empty
    }

    auto CompletionClientCapabilities_completionItem_tagSupport::operator=(
        CompletionClientCapabilities_completionItem_tagSupport &&other
    ) -> CompletionClientCapabilities_completionItem_tagSupport &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto CompletionClientCapabilities_completionItem_tagSupport::operator=(
        const CompletionClientCapabilities_completionItem_tagSupport &other
    ) -> CompletionClientCapabilities_completionItem_tagSupport &
    {
        if (this != &other) {
            valueSet = other.valueSet;
        }
        return *this;
    }

    const std::map<InsertTextFormat, std::string> InsertTextFormatNames = {
        {InsertTextFormat::PlainText, "PlainText"},
        {InsertTextFormat::Snippet, "Snippet"},
    };

    auto insertTextFormatByName(const std::string &name) -> InsertTextFormat
    {
        for (const auto &[enum_name, enum_value] : InsertTextFormatNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid InsertTextFormat name: " + name);
    }

    auto insertTextFormatByValue(unsigned int value) -> InsertTextFormat
    {
        for (const auto &[enum_name, enum_value] : InsertTextFormatNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid InsertTextFormat value: " + std::to_string(value)
        );
    }


    const std::map<InsertTextMode, std::string> InsertTextModeNames = {
        {InsertTextMode::AsIs, "AsIs"},
        {InsertTextMode::AdjustIndentation, "AdjustIndentation"},
    };

    auto insertTextModeByName(const std::string &name) -> InsertTextMode
    {
        for (const auto &[enum_name, enum_value] : InsertTextModeNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid InsertTextMode name: " + name);
    }

    auto insertTextModeByValue(unsigned int value) -> InsertTextMode
    {
        for (const auto &[enum_name, enum_value] : InsertTextModeNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid InsertTextMode value: " + std::to_string(value)
        );
    }


    CompletionClientCapabilities_completionItem_insertTextModeSupport::CompletionClientCapabilities_completionItem_insertTextModeSupport()
    {
        // empty
    }

    CompletionClientCapabilities_completionItem_insertTextModeSupport::CompletionClientCapabilities_completionItem_insertTextModeSupport(
        CompletionClientCapabilities_completionItem_insertTextModeSupport &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    CompletionClientCapabilities_completionItem_insertTextModeSupport::CompletionClientCapabilities_completionItem_insertTextModeSupport(
        const CompletionClientCapabilities_completionItem_insertTextModeSupport &other
    )
    {
        valueSet = other.valueSet;
    }

    CompletionClientCapabilities_completionItem_insertTextModeSupport::~CompletionClientCapabilities_completionItem_insertTextModeSupport()
    {
        // empty
    }

    auto CompletionClientCapabilities_completionItem_insertTextModeSupport::operator=(
        CompletionClientCapabilities_completionItem_insertTextModeSupport &&other
    ) -> CompletionClientCapabilities_completionItem_insertTextModeSupport &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto CompletionClientCapabilities_completionItem_insertTextModeSupport::operator=(
        const CompletionClientCapabilities_completionItem_insertTextModeSupport &other
    ) -> CompletionClientCapabilities_completionItem_insertTextModeSupport &
    {
        if (this != &other) {
            valueSet = other.valueSet;
        }
        return *this;
    }

    const std::map<DocumentHighlightKind, std::string>
    DocumentHighlightKindNames = {
        {DocumentHighlightKind::Text, "Text"},
        {DocumentHighlightKind::Read, "Read"},
        {DocumentHighlightKind::Write, "Write"},
    };

    auto documentHighlightKindByName(
        const std::string &name
    ) -> DocumentHighlightKind
    {
        for (const auto &[enum_name, enum_value]
                : DocumentHighlightKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid DocumentHighlightKind name: " + name
        );
    }

    auto documentHighlightKindByValue(
        unsigned int value
    ) -> DocumentHighlightKind
    {
        for (const auto &[enum_name, enum_value]
                : DocumentHighlightKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid DocumentHighlightKind value: " + std::to_string(value)
        );
    }


    const std::map<CodeActionKind, std::string> CodeActionKindNames = {
        {CodeActionKind::Empty, "Empty"},
        {CodeActionKind::QuickFix, "QuickFix"},
        {CodeActionKind::Refactor, "Refactor"},
        {CodeActionKind::RefactorExtract, "RefactorExtract"},
        {CodeActionKind::RefactorInline, "RefactorInline"},
        {CodeActionKind::RefactorRewrite, "RefactorRewrite"},
        {CodeActionKind::Source, "Source"},
        {CodeActionKind::SourceOrganizeImports, "SourceOrganizeImports"},
        {CodeActionKind::SourceFixAll, "SourceFixAll"},
    };

    const std::map<CodeActionKind, std::string> CodeActionKindValues = {
        {CodeActionKind::Empty, ""},
        {CodeActionKind::QuickFix, "quickfix"},
        {CodeActionKind::Refactor, "refactor"},
        {CodeActionKind::RefactorExtract, "refactor.extract"},
        {CodeActionKind::RefactorInline, "refactor.inline"},
        {CodeActionKind::RefactorRewrite, "refactor.rewrite"},
        {CodeActionKind::Source, "source"},
        {CodeActionKind::SourceOrganizeImports, "source.organizeImports"},
        {CodeActionKind::SourceFixAll, "source.fixAll"},
    };

    auto codeActionKindByName(const std::string &name) -> CodeActionKind
    {
        for (const auto &[enum_name, enum_value] : CodeActionKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid CodeActionKind name: " + name);
    }

    auto codeActionKindByValue(const std::string &value) -> CodeActionKind
    {
        for (const auto &[enum_name, enum_value] : CodeActionKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CodeActionKind value: \"" + value + "\""
        );
    }

    auto isCodeActionKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : CodeActionKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind::CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind()
    {
        // empty
    }

    CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind::CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind(
        CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind::CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind(
        const CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &other
    )
    {
        valueSet = other.valueSet;
    }

    CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind::~CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind()
    {
        // empty
    }

    auto CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind::operator=(
        CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &&other
    ) -> CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind::operator=(
        const CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &other
    ) -> CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &
    {
        if (this != &other) {
            valueSet = other.valueSet;
        }
        return *this;
    }

    CodeActionClientCapabilities_codeActionLiteralSupport::CodeActionClientCapabilities_codeActionLiteralSupport()
    {
        // empty
    }

    CodeActionClientCapabilities_codeActionLiteralSupport::CodeActionClientCapabilities_codeActionLiteralSupport(
        CodeActionClientCapabilities_codeActionLiteralSupport &&other
    )
        : codeActionKind(std::move(other.codeActionKind))
    {
        // empty
    }

    CodeActionClientCapabilities_codeActionLiteralSupport::CodeActionClientCapabilities_codeActionLiteralSupport(
        const CodeActionClientCapabilities_codeActionLiteralSupport &other
    )
        : codeActionKind(other.codeActionKind)
    {
    }

    CodeActionClientCapabilities_codeActionLiteralSupport::~CodeActionClientCapabilities_codeActionLiteralSupport()
    {
        // empty
    }

    auto CodeActionClientCapabilities_codeActionLiteralSupport::operator=(
        CodeActionClientCapabilities_codeActionLiteralSupport &&other
    ) -> CodeActionClientCapabilities_codeActionLiteralSupport &
    {
        if (this != &other) {
            codeActionKind = std::move(other.codeActionKind);
        }
        return *this;
    }

    auto CodeActionClientCapabilities_codeActionLiteralSupport::operator=(
        const CodeActionClientCapabilities_codeActionLiteralSupport &other
    ) -> CodeActionClientCapabilities_codeActionLiteralSupport &
    {
        if (this != &other) {
            codeActionKind = other.codeActionKind;
        }
        return *this;
    }

    const std::map<TraceValues, std::string> TraceValuesNames = {
        {TraceValues::Off, "Off"},
        {TraceValues::Messages, "Messages"},
        {TraceValues::Verbose, "Verbose"},
    };

    const std::map<TraceValues, std::string> TraceValuesValues = {
        {TraceValues::Off, "off"},
        {TraceValues::Messages, "messages"},
        {TraceValues::Verbose, "verbose"},
    };

    auto traceValuesByName(const std::string &name) -> TraceValues
    {
        for (const auto &[enum_name, enum_value] : TraceValuesNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid TraceValues name: " + name);
    }

    auto traceValuesByValue(const std::string &value) -> TraceValues
    {
        for (const auto &[enum_name, enum_value] : TraceValuesValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid TraceValues value: \"" + value + "\""
        );
    }

    auto isTraceValues(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : TraceValuesValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    SetTraceParams::SetTraceParams()
    {
        // empty
    }

    SetTraceParams::SetTraceParams(SetTraceParams &&other)
        : value(std::move(other.value))
    {
        // empty
    }

    SetTraceParams::SetTraceParams(const SetTraceParams &other)
        : value(other.value)
    {
    }

    SetTraceParams::~SetTraceParams()
    {
        // empty
    }

    auto SetTraceParams::operator=(SetTraceParams &&other) -> SetTraceParams &
    {
        if (this != &other) {
            value = std::move(other.value);
        }
        return *this;
    }

    auto SetTraceParams::operator=(
        const SetTraceParams &other
    ) -> SetTraceParams &
    {
        if (this != &other) {
            value = other.value;
        }
        return *this;
    }

    const std::map<MarkupKind, std::string> MarkupKindNames = {
        {MarkupKind::PlainText, "PlainText"},
        {MarkupKind::Markdown, "Markdown"},
    };

    const std::map<MarkupKind, std::string> MarkupKindValues = {
        {MarkupKind::PlainText, "plaintext"},
        {MarkupKind::Markdown, "markdown"},
    };

    auto markupKindByName(const std::string &name) -> MarkupKind
    {
        for (const auto &[enum_name, enum_value] : MarkupKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid MarkupKind name: " + name);
    }

    auto markupKindByValue(const std::string &value) -> MarkupKind
    {
        for (const auto &[enum_name, enum_value] : MarkupKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid MarkupKind value: \"" + value + "\""
        );
    }

    auto isMarkupKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : MarkupKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<InlineCompletionTriggerKind, std::string>
    InlineCompletionTriggerKindNames = {
        {InlineCompletionTriggerKind::Invoked, "Invoked"},
        {InlineCompletionTriggerKind::Automatic, "Automatic"},
    };

    auto inlineCompletionTriggerKindByName(
        const std::string &name
    ) -> InlineCompletionTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : InlineCompletionTriggerKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid InlineCompletionTriggerKind name: " + name
        );
    }

    auto inlineCompletionTriggerKindByValue(
        unsigned int value
    ) -> InlineCompletionTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : InlineCompletionTriggerKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid InlineCompletionTriggerKind value: " + std::to_string(value)
        );
    }


    const std::map<PositionEncodingKind, std::string>
    PositionEncodingKindNames = {
        {PositionEncodingKind::UTF8, "UTF8"},
        {PositionEncodingKind::UTF16, "UTF16"},
        {PositionEncodingKind::UTF32, "UTF32"},
    };

    const std::map<PositionEncodingKind, std::string>
    PositionEncodingKindValues = {
        {PositionEncodingKind::UTF8, "utf-8"},
        {PositionEncodingKind::UTF16, "utf-16"},
        {PositionEncodingKind::UTF32, "utf-32"},
    };

    auto positionEncodingKindByName(
        const std::string &name
    ) -> PositionEncodingKind
    {
        for (const auto &[enum_name, enum_value] : PositionEncodingKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid PositionEncodingKind name: " + name
        );
    }

    auto positionEncodingKindByValue(
        const std::string &value
    ) -> PositionEncodingKind
    {
        for (const auto &[enum_name, enum_value]
                : PositionEncodingKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid PositionEncodingKind value: \"" + value + "\""
        );
    }

    auto isPositionEncodingKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : PositionEncodingKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<FileChangeType, std::string> FileChangeTypeNames = {
        {FileChangeType::Created, "Created"},
        {FileChangeType::Changed, "Changed"},
        {FileChangeType::Deleted, "Deleted"},
    };

    auto fileChangeTypeByName(const std::string &name) -> FileChangeType
    {
        for (const auto &[enum_name, enum_value] : FileChangeTypeNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid FileChangeType name: " + name);
    }

    auto fileChangeTypeByValue(unsigned int value) -> FileChangeType
    {
        for (const auto &[enum_name, enum_value] : FileChangeTypeNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid FileChangeType value: " + std::to_string(value)
        );
    }


    const std::map<WatchKind, std::string> WatchKindNames = {
        {WatchKind::Create, "Create"},
        {WatchKind::Change, "Change"},
        {WatchKind::Delete, "Delete"},
    };

    auto watchKindByName(const std::string &name) -> WatchKind
    {
        for (const auto &[enum_name, enum_value] : WatchKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid WatchKind name: " + name);
    }

    auto watchKindByValue(unsigned int value) -> WatchKind
    {
        for (const auto &[enum_name, enum_value] : WatchKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid WatchKind value: " + std::to_string(value)
        );
    }


    const std::map<DiagnosticSeverity, std::string> DiagnosticSeverityNames = {
        {DiagnosticSeverity::Error, "Error"},
        {DiagnosticSeverity::Warning, "Warning"},
        {DiagnosticSeverity::Information, "Information"},
        {DiagnosticSeverity::Hint, "Hint"},
    };

    auto diagnosticSeverityByName(
        const std::string &name
    ) -> DiagnosticSeverity
    {
        for (const auto &[enum_name, enum_value] : DiagnosticSeverityNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid DiagnosticSeverity name: " + name
        );
    }

    auto diagnosticSeverityByValue(unsigned int value) -> DiagnosticSeverity
    {
        for (const auto &[enum_name, enum_value] : DiagnosticSeverityNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid DiagnosticSeverity value: " + std::to_string(value)
        );
    }


    const std::map<DiagnosticTag, std::string> DiagnosticTagNames = {
        {DiagnosticTag::Unnecessary, "Unnecessary"},
        {DiagnosticTag::Deprecated, "Deprecated"},
    };

    auto diagnosticTagByName(const std::string &name) -> DiagnosticTag
    {
        for (const auto &[enum_name, enum_value] : DiagnosticTagNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid DiagnosticTag name: " + name);
    }

    auto diagnosticTagByValue(unsigned int value) -> DiagnosticTag
    {
        for (const auto &[enum_name, enum_value] : DiagnosticTagNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid DiagnosticTag value: " + std::to_string(value)
        );
    }


    PublishDiagnosticsClientCapabilities_tagSupport::PublishDiagnosticsClientCapabilities_tagSupport()
    {
        // empty
    }

    PublishDiagnosticsClientCapabilities_tagSupport::PublishDiagnosticsClientCapabilities_tagSupport(
        PublishDiagnosticsClientCapabilities_tagSupport &&other
    )
        : valueSet(std::move(other.valueSet))
    {
        // empty
    }

    PublishDiagnosticsClientCapabilities_tagSupport::PublishDiagnosticsClientCapabilities_tagSupport(
        const PublishDiagnosticsClientCapabilities_tagSupport &other
    )
    {
        valueSet = other.valueSet;
    }

    PublishDiagnosticsClientCapabilities_tagSupport::~PublishDiagnosticsClientCapabilities_tagSupport()
    {
        // empty
    }

    auto PublishDiagnosticsClientCapabilities_tagSupport::operator=(
        PublishDiagnosticsClientCapabilities_tagSupport &&other
    ) -> PublishDiagnosticsClientCapabilities_tagSupport &
    {
        if (this != &other) {
            valueSet = std::move(other.valueSet);
        }
        return *this;
    }

    auto PublishDiagnosticsClientCapabilities_tagSupport::operator=(
        const PublishDiagnosticsClientCapabilities_tagSupport &other
    ) -> PublishDiagnosticsClientCapabilities_tagSupport &
    {
        if (this != &other) {
            valueSet = other.valueSet;
        }
        return *this;
    }

    const std::map<CompletionTriggerKind, std::string>
    CompletionTriggerKindNames = {
        {CompletionTriggerKind::Invoked, "Invoked"},
        {CompletionTriggerKind::TriggerCharacter, "TriggerCharacter"},
        {CompletionTriggerKind::TriggerForIncompleteCompletions,
         "TriggerForIncompleteCompletions"},
    };

    auto completionTriggerKindByName(
        const std::string &name
    ) -> CompletionTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : CompletionTriggerKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CompletionTriggerKind name: " + name
        );
    }

    auto completionTriggerKindByValue(
        unsigned int value
    ) -> CompletionTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : CompletionTriggerKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CompletionTriggerKind value: " + std::to_string(value)
        );
    }


    const std::map<SignatureHelpTriggerKind, std::string>
    SignatureHelpTriggerKindNames = {
        {SignatureHelpTriggerKind::Invoked, "Invoked"},
        {SignatureHelpTriggerKind::TriggerCharacter, "TriggerCharacter"},
        {SignatureHelpTriggerKind::ContentChange, "ContentChange"},
    };

    auto signatureHelpTriggerKindByName(
        const std::string &name
    ) -> SignatureHelpTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : SignatureHelpTriggerKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SignatureHelpTriggerKind name: " + name
        );
    }

    auto signatureHelpTriggerKindByValue(
        unsigned int value
    ) -> SignatureHelpTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : SignatureHelpTriggerKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid SignatureHelpTriggerKind value: " + std::to_string(value)
        );
    }


    const std::map<CodeActionTriggerKind, std::string>
    CodeActionTriggerKindNames = {
        {CodeActionTriggerKind::Invoked, "Invoked"},
        {CodeActionTriggerKind::Automatic, "Automatic"},
    };

    auto codeActionTriggerKindByName(
        const std::string &name
    ) -> CodeActionTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : CodeActionTriggerKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CodeActionTriggerKind name: " + name
        );
    }

    auto codeActionTriggerKindByValue(
        unsigned int value
    ) -> CodeActionTriggerKind
    {
        for (const auto &[enum_name, enum_value]
                : CodeActionTriggerKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid CodeActionTriggerKind value: " + std::to_string(value)
        );
    }


    const std::map<FileOperationPatternKind, std::string>
    FileOperationPatternKindNames = {
        {FileOperationPatternKind::File, "File"},
        {FileOperationPatternKind::Folder, "Folder"},
    };

    const std::map<FileOperationPatternKind, std::string>
    FileOperationPatternKindValues = {
        {FileOperationPatternKind::File, "file"},
        {FileOperationPatternKind::Folder, "folder"},
    };

    auto fileOperationPatternKindByName(
        const std::string &name
    ) -> FileOperationPatternKind
    {
        for (const auto &[enum_name, enum_value]
                : FileOperationPatternKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid FileOperationPatternKind name: " + name
        );
    }

    auto fileOperationPatternKindByValue(
        const std::string &value
    ) -> FileOperationPatternKind
    {
        for (const auto &[enum_name, enum_value]
                : FileOperationPatternKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid FileOperationPatternKind value: \"" + value + "\""
        );
    }

    auto isFileOperationPatternKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value]
                : FileOperationPatternKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<NotebookCellKind, std::string> NotebookCellKindNames = {
        {NotebookCellKind::Markup, "Markup"},
        {NotebookCellKind::Code, "Code"},
    };

    auto notebookCellKindByName(const std::string &name) -> NotebookCellKind
    {
        for (const auto &[enum_name, enum_value] : NotebookCellKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid NotebookCellKind name: " + name);
    }

    auto notebookCellKindByValue(unsigned int value) -> NotebookCellKind
    {
        for (const auto &[enum_name, enum_value] : NotebookCellKindNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid NotebookCellKind value: " + std::to_string(value)
        );
    }


    const std::map<ResourceOperationKind, std::string>
    ResourceOperationKindNames = {
        {ResourceOperationKind::Create, "Create"},
        {ResourceOperationKind::Rename, "Rename"},
        {ResourceOperationKind::Delete, "Delete"},
    };

    const std::map<ResourceOperationKind, std::string>
    ResourceOperationKindValues = {
        {ResourceOperationKind::Create, "create"},
        {ResourceOperationKind::Rename, "rename"},
        {ResourceOperationKind::Delete, "delete"},
    };

    auto resourceOperationKindByName(
        const std::string &name
    ) -> ResourceOperationKind
    {
        for (const auto &[enum_name, enum_value]
                : ResourceOperationKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid ResourceOperationKind name: " + name
        );
    }

    auto resourceOperationKindByValue(
        const std::string &value
    ) -> ResourceOperationKind
    {
        for (const auto &[enum_name, enum_value]
                : ResourceOperationKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid ResourceOperationKind value: \"" + value + "\""
        );
    }

    auto isResourceOperationKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value]
                : ResourceOperationKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<FailureHandlingKind, std::string>
    FailureHandlingKindNames = {
        {FailureHandlingKind::Abort, "Abort"},
        {FailureHandlingKind::Transactional, "Transactional"},
        {FailureHandlingKind::TextOnlyTransactional, "TextOnlyTransactional"},
        {FailureHandlingKind::Undo, "Undo"},
    };

    const std::map<FailureHandlingKind, std::string>
    FailureHandlingKindValues = {
        {FailureHandlingKind::Abort, "abort"},
        {FailureHandlingKind::Transactional, "transactional"},
        {FailureHandlingKind::TextOnlyTransactional, "textOnlyTransactional"},
        {FailureHandlingKind::Undo, "undo"},
    };

    auto failureHandlingKindByName(
        const std::string &name
    ) -> FailureHandlingKind
    {
        for (const auto &[enum_name, enum_value] : FailureHandlingKindNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid FailureHandlingKind name: " + name
        );
    }

    auto failureHandlingKindByValue(
        const std::string &value
    ) -> FailureHandlingKind
    {
        for (const auto &[enum_name, enum_value] : FailureHandlingKindValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid FailureHandlingKind value: \"" + value + "\""
        );
    }

    auto isFailureHandlingKind(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : FailureHandlingKindValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    const std::map<PrepareSupportDefaultBehavior, std::string>
    PrepareSupportDefaultBehaviorNames = {
        {PrepareSupportDefaultBehavior::Identifier, "Identifier"},
    };

    auto prepareSupportDefaultBehaviorByName(
        const std::string &name
    ) -> PrepareSupportDefaultBehavior
    {
        for (const auto &[enum_name, enum_value]
                : PrepareSupportDefaultBehaviorNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid PrepareSupportDefaultBehavior name: " + name
        );
    }

    auto prepareSupportDefaultBehaviorByValue(
        unsigned int value
    ) -> PrepareSupportDefaultBehavior
    {
        for (const auto &[enum_name, enum_value]
                : PrepareSupportDefaultBehaviorNames) {
            if (value == static_cast<unsigned int>(enum_name)) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid PrepareSupportDefaultBehavior value: " + std::to_string(value)
        );
    }


    const std::map<TokenFormat, std::string> TokenFormatNames = {
        {TokenFormat::Relative, "Relative"},
    };

    const std::map<TokenFormat, std::string> TokenFormatValues = {
        {TokenFormat::Relative, "relative"},
    };

    auto tokenFormatByName(const std::string &name) -> TokenFormat
    {
        for (const auto &[enum_name, enum_value] : TokenFormatNames) {
            if (name == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument("Invalid TokenFormat name: " + name);
    }

    auto tokenFormatByValue(const std::string &value) -> TokenFormat
    {
        for (const auto &[enum_name, enum_value] : TokenFormatValues) {
            if (value == enum_value) {
                return enum_name;
            }
        }
        throw std::invalid_argument(
            "Invalid TokenFormat value: \"" + value + "\""
        );
    }

    auto isTokenFormat(const std::string &value) -> bool
    {
        for (const auto &[enum_key, enum_value] : TokenFormatValues) {
            if (value == enum_value) {
                return true;
            }
        }
        return false;
    }

    WorkspaceSymbol_location_1::WorkspaceSymbol_location_1()
    {
        // empty
    }

    WorkspaceSymbol_location_1::WorkspaceSymbol_location_1(
        WorkspaceSymbol_location_1 &&other
    )
        : uri(std::move(other.uri))
    {
        // empty
    }

    WorkspaceSymbol_location_1::WorkspaceSymbol_location_1(
        const WorkspaceSymbol_location_1 &other
    )
        : uri(other.uri)
    {
    }

    WorkspaceSymbol_location_1::~WorkspaceSymbol_location_1()
    {
        // empty
    }

    auto WorkspaceSymbol_location_1::operator=(
        WorkspaceSymbol_location_1 &&other
    ) -> WorkspaceSymbol_location_1 &
    {
        if (this != &other) {
            uri = std::move(other.uri);
        }
        return *this;
    }

    auto WorkspaceSymbol_location_1::operator=(
        const WorkspaceSymbol_location_1 &other
    ) -> WorkspaceSymbol_location_1 &
    {
        if (this != &other) {
            uri = other.uri;
        }
        return *this;
    }

    TextDocumentIdentifier::TextDocumentIdentifier()
    {
        // empty
    }

    TextDocumentIdentifier::TextDocumentIdentifier(
        TextDocumentIdentifier &&other
    )
        : uri(std::move(other.uri))
    {
        // empty
    }

    TextDocumentIdentifier::TextDocumentIdentifier(
        const TextDocumentIdentifier &other
    )
        : uri(other.uri)
    {
    }

    TextDocumentIdentifier::~TextDocumentIdentifier()
    {
        // empty
    }

    auto TextDocumentIdentifier::operator=(
        TextDocumentIdentifier &&other
    ) -> TextDocumentIdentifier &
    {
        if (this != &other) {
            uri = std::move(other.uri);
        }
        return *this;
    }

    auto TextDocumentIdentifier::operator=(
        const TextDocumentIdentifier &other
    ) -> TextDocumentIdentifier &
    {
        if (this != &other) {
            uri = other.uri;
        }
        return *this;
    }

    DidCloseTextDocumentParams::DidCloseTextDocumentParams()
    {
        // empty
    }

    DidCloseTextDocumentParams::DidCloseTextDocumentParams(
        DidCloseTextDocumentParams &&other
    )
        : textDocument(std::move(other.textDocument))
    {
        // empty
    }

    DidCloseTextDocumentParams::DidCloseTextDocumentParams(
        const DidCloseTextDocumentParams &other
    )
        : textDocument(other.textDocument)
    {
    }

    DidCloseTextDocumentParams::~DidCloseTextDocumentParams()
    {
        // empty
    }

    auto DidCloseTextDocumentParams::operator=(
        DidCloseTextDocumentParams &&other
    ) -> DidCloseTextDocumentParams &
    {
        if (this != &other) {
            textDocument = std::move(other.textDocument);
        }
        return *this;
    }

    auto DidCloseTextDocumentParams::operator=(
        const DidCloseTextDocumentParams &other
    ) -> DidCloseTextDocumentParams &
    {
        if (this != &other) {
            textDocument = other.textDocument;
        }
        return *this;
    }

    WillSaveTextDocumentParams::WillSaveTextDocumentParams()
    {
        // empty
    }

    WillSaveTextDocumentParams::WillSaveTextDocumentParams(
        WillSaveTextDocumentParams &&other
    )
        : textDocument(std::move(other.textDocument))
        , reason(std::move(other.reason))
    {
        // empty
    }

    WillSaveTextDocumentParams::WillSaveTextDocumentParams(
        const WillSaveTextDocumentParams &other
    )
        : textDocument(other.textDocument)
        , reason(other.reason)
    {
    }

    WillSaveTextDocumentParams::~WillSaveTextDocumentParams()
    {
        // empty
    }

    auto WillSaveTextDocumentParams::operator=(
        WillSaveTextDocumentParams &&other
    ) -> WillSaveTextDocumentParams &
    {
        if (this != &other) {
            textDocument = std::move(other.textDocument);
            reason = std::move(other.reason);
        }
        return *this;
    }

    auto WillSaveTextDocumentParams::operator=(
        const WillSaveTextDocumentParams &other
    ) -> WillSaveTextDocumentParams &
    {
        if (this != &other) {
            textDocument = other.textDocument;
            reason = other.reason;
        }
        return *this;
    }

    FileEvent::FileEvent()
    {
        // empty
    }

    FileEvent::FileEvent(FileEvent &&other)
        : uri(std::move(other.uri))
        , type(std::move(other.type))
    {
        // empty
    }

    FileEvent::FileEvent(const FileEvent &other)
        : uri(other.uri)
        , type(other.type)
    {
    }

    FileEvent::~FileEvent()
    {
        // empty
    }

    auto FileEvent::operator=(FileEvent &&other) -> FileEvent &
    {
        if (this != &other) {
            uri = std::move(other.uri);
            type = std::move(other.type);
        }
        return *this;
    }

    auto FileEvent::operator=(const FileEvent &other) -> FileEvent &
    {
        if (this != &other) {
            uri = other.uri;
            type = other.type;
        }
        return *this;
    }

    DidChangeWatchedFilesParams::DidChangeWatchedFilesParams()
    {
        // empty
    }

    DidChangeWatchedFilesParams::DidChangeWatchedFilesParams(
        DidChangeWatchedFilesParams &&other
    )
        : changes(std::move(other.changes))
    {
        // empty
    }

    DidChangeWatchedFilesParams::DidChangeWatchedFilesParams(
        const DidChangeWatchedFilesParams &other
    )
    {
        changes.reserve(other.changes.size());
        for (const auto &elem_0 : other.changes) {
            changes.push_back(elem_0);
        }
    }

    DidChangeWatchedFilesParams::~DidChangeWatchedFilesParams()
    {
        // empty
    }

    auto DidChangeWatchedFilesParams::operator=(
        DidChangeWatchedFilesParams &&other
    ) -> DidChangeWatchedFilesParams &
    {
        if (this != &other) {
            changes = std::move(other.changes);
        }
        return *this;
    }

    auto DidChangeWatchedFilesParams::operator=(
        const DidChangeWatchedFilesParams &other
    ) -> DidChangeWatchedFilesParams &
    {
        if (this != &other) {
            changes.reserve(other.changes.size());
            for (const auto &elem_0 : other.changes) {
                changes.push_back(elem_0);
            }
        }
        return *this;
    }

    NotebookDocumentIdentifier::NotebookDocumentIdentifier()
    {
        // empty
    }

    NotebookDocumentIdentifier::NotebookDocumentIdentifier(
        NotebookDocumentIdentifier &&other
    )
        : uri(std::move(other.uri))
    {
        // empty
    }

    NotebookDocumentIdentifier::NotebookDocumentIdentifier(
        const NotebookDocumentIdentifier &other
    )
        : uri(other.uri)
    {
    }

    NotebookDocumentIdentifier::~NotebookDocumentIdentifier()
    {
        // empty
    }

    auto NotebookDocumentIdentifier::operator=(
        NotebookDocumentIdentifier &&other
    ) -> NotebookDocumentIdentifier &
    {
        if (this != &other) {
            uri = std::move(other.uri);
        }
        return *this;
    }

    auto NotebookDocumentIdentifier::operator=(
        const NotebookDocumentIdentifier &other
    ) -> NotebookDocumentIdentifier &
    {
        if (this != &other) {
            uri = other.uri;
        }
        return *this;
    }

    DidSaveNotebookDocumentParams::DidSaveNotebookDocumentParams()
    {
        // empty
    }

    DidSaveNotebookDocumentParams::DidSaveNotebookDocumentParams(
        DidSaveNotebookDocumentParams &&other
    )
        : notebookDocument(std::move(other.notebookDocument))
    {
        // empty
    }

    DidSaveNotebookDocumentParams::DidSaveNotebookDocumentParams(
        const DidSaveNotebookDocumentParams &other
    )
        : notebookDocument(other.notebookDocument)
    {
    }

    DidSaveNotebookDocumentParams::~DidSaveNotebookDocumentParams()
    {
        // empty
    }

    auto DidSaveNotebookDocumentParams::operator=(
        DidSaveNotebookDocumentParams &&other
    ) -> DidSaveNotebookDocumentParams &
    {
        if (this != &other) {
            notebookDocument = std::move(other.notebookDocument);
        }
        return *this;
    }

    auto DidSaveNotebookDocumentParams::operator=(
        const DidSaveNotebookDocumentParams &other
    ) -> DidSaveNotebookDocumentParams &
    {
        if (this != &other) {
            notebookDocument = other.notebookDocument;
        }
        return *this;
    }

    DidCloseNotebookDocumentParams::DidCloseNotebookDocumentParams()
    {
        // empty
    }

    DidCloseNotebookDocumentParams::DidCloseNotebookDocumentParams(
        DidCloseNotebookDocumentParams &&other
    )
        : notebookDocument(std::move(other.notebookDocument))
        , cellTextDocuments(std::move(other.cellTextDocuments))
    {
        // empty
    }

    DidCloseNotebookDocumentParams::DidCloseNotebookDocumentParams(
        const DidCloseNotebookDocumentParams &other
    )
        : notebookDocument(other.notebookDocument)
    {
        cellTextDocuments.reserve(other.cellTextDocuments.size());
        for (const auto &elem_0 : other.cellTextDocuments) {
            cellTextDocuments.push_back(elem_0);
        }
    }

    DidCloseNotebookDocumentParams::~DidCloseNotebookDocumentParams()
    {
        // empty
    }

    auto DidCloseNotebookDocumentParams::operator=(
        DidCloseNotebookDocumentParams &&other
    ) -> DidCloseNotebookDocumentParams &
    {
        if (this != &other) {
            notebookDocument = std::move(other.notebookDocument);
            cellTextDocuments = std::move(other.cellTextDocuments);
        }
        return *this;
    }

    auto DidCloseNotebookDocumentParams::operator=(
        const DidCloseNotebookDocumentParams &other
    ) -> DidCloseNotebookDocumentParams &
    {
        if (this != &other) {
            notebookDocument = other.notebookDocument;
            cellTextDocuments.reserve(other.cellTextDocuments.size());
            for (const auto &elem_0 : other.cellTextDocuments) {
                cellTextDocuments.push_back(elem_0);
            }
        }
        return *this;
    }

    CodeDescription::CodeDescription()
    {
        // empty
    }

    CodeDescription::CodeDescription(CodeDescription &&other)
        : href(std::move(other.href))
    {
        // empty
    }

    CodeDescription::CodeDescription(const CodeDescription &other)
        : href(other.href)
    {
    }

    CodeDescription::~CodeDescription()
    {
        // empty
    }

    auto CodeDescription::operator=(
        CodeDescription &&other
    ) -> CodeDescription &
    {
        if (this != &other) {
            href = std::move(other.href);
        }
        return *this;
    }

    auto CodeDescription::operator=(
        const CodeDescription &other
    ) -> CodeDescription &
    {
        if (this != &other) {
            href = other.href;
        }
        return *this;
    }

    WorkspaceFolder::WorkspaceFolder()
    {
        // empty
    }

    WorkspaceFolder::WorkspaceFolder(WorkspaceFolder &&other)
        : uri(std::move(other.uri))
        , name(std::move(other.name))
    {
        // empty
    }

    WorkspaceFolder::WorkspaceFolder(const WorkspaceFolder &other)
        : uri(other.uri)
        , name(other.name)
    {
    }

    WorkspaceFolder::~WorkspaceFolder()
    {
        // empty
    }

    auto WorkspaceFolder::operator=(
        WorkspaceFolder &&other
    ) -> WorkspaceFolder &
    {
        if (this != &other) {
            uri = std::move(other.uri);
            name = std::move(other.name);
        }
        return *this;
    }

    auto WorkspaceFolder::operator=(
        const WorkspaceFolder &other
    ) -> WorkspaceFolder &
    {
        if (this != &other) {
            uri = other.uri;
            name = other.name;
        }
        return *this;
    }

    Moniker::Moniker()
    {
        // empty
    }

    Moniker::Moniker(Moniker &&other)
        : scheme(std::move(other.scheme))
        , identifier(std::move(other.identifier))
        , unique(std::move(other.unique))
        , kind(std::move(other.kind))
    {
        // empty
    }

    Moniker::Moniker(const Moniker &other)
        : scheme(other.scheme)
        , identifier(other.identifier)
        , unique(other.unique)
    {
        if (other.kind.has_value()) {
            kind = other.kind.value();
        }
    }

    Moniker::~Moniker()
    {
        // empty
    }

    auto Moniker::operator=(Moniker &&other) -> Moniker &
    {
        if (this != &other) {
            scheme = std::move(other.scheme);
            identifier = std::move(other.identifier);
            unique = std::move(other.unique);
            kind = std::move(other.kind);
        }
        return *this;
    }

    auto Moniker::operator=(const Moniker &other) -> Moniker &
    {
        if (this != &other) {
            scheme = other.scheme;
            identifier = other.identifier;
            unique = other.unique;
            if (other.kind.has_value()) {
                kind = other.kind.value();
            }
        }
        return *this;
    }

    InitializeResult_serverInfo::InitializeResult_serverInfo()
    {
        // empty
    }

    InitializeResult_serverInfo::InitializeResult_serverInfo(
        InitializeResult_serverInfo &&other
    )
        : name(std::move(other.name))
        , version(std::move(other.version))
    {
        // empty
    }

    InitializeResult_serverInfo::InitializeResult_serverInfo(
        const InitializeResult_serverInfo &other
    )
        : name(other.name)
    {
        if (other.version.has_value()) {
            version = other.version.value();
        }
    }

    InitializeResult_serverInfo::~InitializeResult_serverInfo()
    {
        // empty
    }

    auto InitializeResult_serverInfo::operator=(
        InitializeResult_serverInfo &&other
    ) -> InitializeResult_serverInfo &
    {
        if (this != &other) {
            name = std::move(other.name);
            version = std::move(other.version);
        }
        return *this;
    }

    auto InitializeResult_serverInfo::operator=(
        const InitializeResult_serverInfo &other
    ) -> InitializeResult_serverInfo &
    {
        if (this != &other) {
            name = other.name;
            if (other.version.has_value()) {
                version = other.version.value();
            }
        }
        return *this;
    }

    const std::map<
        DidChangeConfigurationRegistrationOptions_sectionType,
        std::string
    > DidChangeConfigurationRegistrationOptions_sectionTypeNames = {
        {DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized,
         "Uninitialized"},
        {DidChangeConfigurationRegistrationOptions_sectionType::String,
         "String"},
        {DidChangeConfigurationRegistrationOptions_sectionType::StringArray,
         "StringArray"},
    };

    DidChangeConfigurationRegistrationOptions_section::DidChangeConfigurationRegistrationOptions_section()
    {
        // empty
    }

    DidChangeConfigurationRegistrationOptions_section::~DidChangeConfigurationRegistrationOptions_section()
    {
        reset();
    }

    DidChangeConfigurationRegistrationOptions_section::DidChangeConfigurationRegistrationOptions_section(
        DidChangeConfigurationRegistrationOptions_section &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case DidChangeConfigurationRegistrationOptions_sectionType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case DidChangeConfigurationRegistrationOptions_sectionType::StringArray: {
            new (&_stringArray) std::unique_ptr<DidChangeConfigurationRegistrationOptions_section_1> {
                std::move(other._stringArray)
            };
            break;
        }
        case DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized;
    }

    DidChangeConfigurationRegistrationOptions_section::DidChangeConfigurationRegistrationOptions_section(
        const DidChangeConfigurationRegistrationOptions_section &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case DidChangeConfigurationRegistrationOptions_sectionType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case DidChangeConfigurationRegistrationOptions_sectionType::StringArray: {
            _stringArray =
                std::make_unique<std::vector<string_t>>(*other._stringArray);
            break;
        }
        case DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        DidChangeConfigurationRegistrationOptions_section &&other
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case DidChangeConfigurationRegistrationOptions_sectionType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case DidChangeConfigurationRegistrationOptions_sectionType::StringArray: {
                new (&_stringArray) std::unique_ptr<DidChangeConfigurationRegistrationOptions_section_1> {
                    std::move(other._stringArray)
                };
                break;
            }
            case DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized;
        }
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        const DidChangeConfigurationRegistrationOptions_section &other
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case DidChangeConfigurationRegistrationOptions_sectionType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case DidChangeConfigurationRegistrationOptions_sectionType::StringArray: {
                _stringArray =
                    std::make_unique<std::vector<string_t>>(*other._stringArray);
                break;
            }
            case DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::reset() -> void
    {
        switch (_type) {
        case DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized: {
            // nothing to do
            break;
        }
        case DidChangeConfigurationRegistrationOptions_sectionType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type =
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized;
            break;
        }
        case DidChangeConfigurationRegistrationOptions_sectionType::StringArray: {
#ifdef DEBUG
            if (!_stringArray) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _stringArray"
                );
            }
#endif // DEBUG
            _stringArray.~unique_ptr<std::vector<string_t>>();
            _type =
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized;
            break;
        }
        default: {
            _type = DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized;
        }
        }
    }

    auto DidChangeConfigurationRegistrationOptions_section::type() const
    -> const DidChangeConfigurationRegistrationOptions_sectionType &
    {
        return _type;
    }

    auto DidChangeConfigurationRegistrationOptions_section::string() const
    -> const string_t &
    {
#ifdef DEBUG
        if (_type != DidChangeConfigurationRegistrationOptions_sectionType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "DidChangeConfigurationRegistrationOptions_section::string()"
                 " of type "
                 "DidChangeConfigurationRegistrationOptions_sectionType::String"
                 " while active type is "
                 "DidChangeConfigurationRegistrationOptions_sectionType::" +
                 DidChangeConfigurationRegistrationOptions_sectionTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        const std::unique_ptr<string_t> &string
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = DidChangeConfigurationRegistrationOptions_sectionType::String;
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        std::unique_ptr<string_t> &&string
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = DidChangeConfigurationRegistrationOptions_sectionType::String;
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        const string_t &string
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = DidChangeConfigurationRegistrationOptions_sectionType::String;
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        string_t &&string
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = DidChangeConfigurationRegistrationOptions_sectionType::String;
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::stringArray() const
    -> const std::vector<string_t> &
    {
#ifdef DEBUG
        if (_type != DidChangeConfigurationRegistrationOptions_sectionType::StringArray) {
            throw std::logic_error(
                ("Attempted to access "
                 "DidChangeConfigurationRegistrationOptions_section::stringArray()"
                 " of type "
                 "DidChangeConfigurationRegistrationOptions_sectionType::StringArray"
                 " while active type is "
                 "DidChangeConfigurationRegistrationOptions_sectionType::" +
                 DidChangeConfigurationRegistrationOptions_sectionTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_stringArray;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        const std::unique_ptr<std::vector<string_t>> &stringArray
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!stringArray) {
            throw std::logic_error("null passed as the value of stringArray");
        }
#endif // DEBUG
        _stringArray = std::make_unique<std::vector<string_t>>(*stringArray);
        _type =
            DidChangeConfigurationRegistrationOptions_sectionType::StringArray;
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        std::unique_ptr<std::vector<string_t>> &&stringArray
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!stringArray) {
            throw std::logic_error("null passed as the value of stringArray");
        }
#endif // DEBUG
        new (&_stringArray) std::unique_ptr<DidChangeConfigurationRegistrationOptions_section_1> {
            std::move(stringArray)
        };
        _type =
            DidChangeConfigurationRegistrationOptions_sectionType::StringArray;
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        const std::vector<string_t> &stringArray
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
        _stringArray = std::make_unique<std::vector<string_t>>(stringArray);
        _type =
            DidChangeConfigurationRegistrationOptions_sectionType::StringArray;
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions_section::operator=(
        std::vector<string_t> &&stringArray
    ) -> DidChangeConfigurationRegistrationOptions_section &
    {
        if (_type !=
                DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized) {
            reset();
        }
        new (&_stringArray) std::unique_ptr<DidChangeConfigurationRegistrationOptions_section_1> {
            std::make_unique<DidChangeConfigurationRegistrationOptions_section_1>(std::move(stringArray))
        };
        _type =
            DidChangeConfigurationRegistrationOptions_sectionType::StringArray;
        return *this;
    }

    DidChangeConfigurationRegistrationOptions::DidChangeConfigurationRegistrationOptions()
    {
        // empty
    }

    DidChangeConfigurationRegistrationOptions::DidChangeConfigurationRegistrationOptions(
        DidChangeConfigurationRegistrationOptions &&other
    )
        : section(std::move(other.section))
    {
        // empty
    }

    DidChangeConfigurationRegistrationOptions::DidChangeConfigurationRegistrationOptions(
        const DidChangeConfigurationRegistrationOptions &other
    )
    {
        if (other.section.has_value()) {
            section = other.section.value();
        }
    }

    DidChangeConfigurationRegistrationOptions::~DidChangeConfigurationRegistrationOptions()
    {
        // empty
    }

    auto DidChangeConfigurationRegistrationOptions::operator=(
        DidChangeConfigurationRegistrationOptions &&other
    ) -> DidChangeConfigurationRegistrationOptions &
    {
        if (this != &other) {
            section = std::move(other.section);
        }
        return *this;
    }

    auto DidChangeConfigurationRegistrationOptions::operator=(
        const DidChangeConfigurationRegistrationOptions &other
    ) -> DidChangeConfigurationRegistrationOptions &
    {
        if (this != &other) {
            if (other.section.has_value()) {
                section = other.section.value();
            }
        }
        return *this;
    }

    ShowMessageParams::ShowMessageParams()
    {
        // empty
    }

    ShowMessageParams::ShowMessageParams(ShowMessageParams &&other)
        : type(std::move(other.type))
        , message(std::move(other.message))
    {
        // empty
    }

    ShowMessageParams::ShowMessageParams(const ShowMessageParams &other)
        : type(other.type)
        , message(other.message)
    {
    }

    ShowMessageParams::~ShowMessageParams()
    {
        // empty
    }

    auto ShowMessageParams::operator=(
        ShowMessageParams &&other
    ) -> ShowMessageParams &
    {
        if (this != &other) {
            type = std::move(other.type);
            message = std::move(other.message);
        }
        return *this;
    }

    auto ShowMessageParams::operator=(
        const ShowMessageParams &other
    ) -> ShowMessageParams &
    {
        if (this != &other) {
            type = other.type;
            message = other.message;
        }
        return *this;
    }

    MessageActionItem::MessageActionItem()
    {
        // empty
    }

    MessageActionItem::MessageActionItem(MessageActionItem &&other)
        : title(std::move(other.title))
    {
        // empty
    }

    MessageActionItem::MessageActionItem(const MessageActionItem &other)
        : title(other.title)
    {
    }

    MessageActionItem::~MessageActionItem()
    {
        // empty
    }

    auto MessageActionItem::operator=(
        MessageActionItem &&other
    ) -> MessageActionItem &
    {
        if (this != &other) {
            title = std::move(other.title);
        }
        return *this;
    }

    auto MessageActionItem::operator=(
        const MessageActionItem &other
    ) -> MessageActionItem &
    {
        if (this != &other) {
            title = other.title;
        }
        return *this;
    }

    ShowMessageRequestParams::ShowMessageRequestParams()
    {
        // empty
    }

    ShowMessageRequestParams::ShowMessageRequestParams(
        ShowMessageRequestParams &&other
    )
        : type(std::move(other.type))
        , message(std::move(other.message))
        , actions(std::move(other.actions))
    {
        // empty
    }

    ShowMessageRequestParams::ShowMessageRequestParams(
        const ShowMessageRequestParams &other
    )
        : type(other.type)
        , message(other.message)
    {
        if (other.actions.has_value()) {
            auto &array_0 = actions.emplace();
            const auto &array_1 = other.actions.value();
            array_0.reserve(array_1.size());
            for (const auto &elem_0 : array_1) {
                array_0.push_back(elem_0);
            }
        }
    }

    ShowMessageRequestParams::~ShowMessageRequestParams()
    {
        // empty
    }

    auto ShowMessageRequestParams::operator=(
        ShowMessageRequestParams &&other
    ) -> ShowMessageRequestParams &
    {
        if (this != &other) {
            type = std::move(other.type);
            message = std::move(other.message);
            actions = std::move(other.actions);
        }
        return *this;
    }

    auto ShowMessageRequestParams::operator=(
        const ShowMessageRequestParams &other
    ) -> ShowMessageRequestParams &
    {
        if (this != &other) {
            type = other.type;
            message = other.message;
            if (other.actions.has_value()) {
                auto &array_0 = actions.emplace();
                const auto &array_1 = other.actions.value();
                array_0.reserve(array_1.size());
                for (const auto &elem_0 : array_1) {
                    array_0.push_back(elem_0);
                }
            }
        }
        return *this;
    }

    LogMessageParams::LogMessageParams()
    {
        // empty
    }

    LogMessageParams::LogMessageParams(LogMessageParams &&other)
        : type(std::move(other.type))
        , message(std::move(other.message))
    {
        // empty
    }

    LogMessageParams::LogMessageParams(const LogMessageParams &other)
        : type(other.type)
        , message(other.message)
    {
    }

    LogMessageParams::~LogMessageParams()
    {
        // empty
    }

    auto LogMessageParams::operator=(
        LogMessageParams &&other
    ) -> LogMessageParams &
    {
        if (this != &other) {
            type = std::move(other.type);
            message = std::move(other.message);
        }
        return *this;
    }

    auto LogMessageParams::operator=(
        const LogMessageParams &other
    ) -> LogMessageParams &
    {
        if (this != &other) {
            type = other.type;
            message = other.message;
        }
        return *this;
    }

    DidSaveTextDocumentParams::DidSaveTextDocumentParams()
    {
        // empty
    }

    DidSaveTextDocumentParams::DidSaveTextDocumentParams(
        DidSaveTextDocumentParams &&other
    )
        : textDocument(std::move(other.textDocument))
        , text(std::move(other.text))
    {
        // empty
    }

    DidSaveTextDocumentParams::DidSaveTextDocumentParams(
        const DidSaveTextDocumentParams &other
    )
        : textDocument(other.textDocument)
    {
        if (other.text.has_value()) {
            text = other.text.value();
        }
    }

    DidSaveTextDocumentParams::~DidSaveTextDocumentParams()
    {
        // empty
    }

    auto DidSaveTextDocumentParams::operator=(
        DidSaveTextDocumentParams &&other
    ) -> DidSaveTextDocumentParams &
    {
        if (this != &other) {
            textDocument = std::move(other.textDocument);
            text = std::move(other.text);
        }
        return *this;
    }

    auto DidSaveTextDocumentParams::operator=(
        const DidSaveTextDocumentParams &other
    ) -> DidSaveTextDocumentParams &
    {
        if (this != &other) {
            textDocument = other.textDocument;
            if (other.text.has_value()) {
                text = other.text.value();
            }
        }
        return *this;
    }

    CodeAction_disabled::CodeAction_disabled()
    {
        // empty
    }

    CodeAction_disabled::CodeAction_disabled(CodeAction_disabled &&other)
        : reason(std::move(other.reason))
    {
        // empty
    }

    CodeAction_disabled::CodeAction_disabled(const CodeAction_disabled &other)
        : reason(other.reason)
    {
    }

    CodeAction_disabled::~CodeAction_disabled()
    {
        // empty
    }

    auto CodeAction_disabled::operator=(
        CodeAction_disabled &&other
    ) -> CodeAction_disabled &
    {
        if (this != &other) {
            reason = std::move(other.reason);
        }
        return *this;
    }

    auto CodeAction_disabled::operator=(
        const CodeAction_disabled &other
    ) -> CodeAction_disabled &
    {
        if (this != &other) {
            reason = other.reason;
        }
        return *this;
    }

    WorkDoneProgressEnd::WorkDoneProgressEnd()
    {
        // empty
    }

    WorkDoneProgressEnd::WorkDoneProgressEnd(WorkDoneProgressEnd &&other)
        : kind(std::move(other.kind))
        , message(std::move(other.message))
    {
        // empty
    }

    WorkDoneProgressEnd::WorkDoneProgressEnd(const WorkDoneProgressEnd &other)
    {
        if (other.message.has_value()) {
            message = other.message.value();
        }
    }

    WorkDoneProgressEnd::~WorkDoneProgressEnd()
    {
        // empty
    }

    auto WorkDoneProgressEnd::operator=(
        WorkDoneProgressEnd &&other
    ) -> WorkDoneProgressEnd &
    {
        if (this != &other) {
            kind = std::move(other.kind);
            message = std::move(other.message);
        }
        return *this;
    }

    auto WorkDoneProgressEnd::operator=(
        const WorkDoneProgressEnd &other
    ) -> WorkDoneProgressEnd &
    {
        if (this != &other) {
            if (other.message.has_value()) {
                message = other.message.value();
            }
        }
        return *this;
    }

    LogTraceParams::LogTraceParams()
    {
        // empty
    }

    LogTraceParams::LogTraceParams(LogTraceParams &&other)
        : message(std::move(other.message))
        , verbose(std::move(other.verbose))
    {
        // empty
    }

    LogTraceParams::LogTraceParams(const LogTraceParams &other)
        : message(other.message)
    {
        if (other.verbose.has_value()) {
            verbose = other.verbose.value();
        }
    }

    LogTraceParams::~LogTraceParams()
    {
        // empty
    }

    auto LogTraceParams::operator=(LogTraceParams &&other) -> LogTraceParams &
    {
        if (this != &other) {
            message = std::move(other.message);
            verbose = std::move(other.verbose);
        }
        return *this;
    }

    auto LogTraceParams::operator=(
        const LogTraceParams &other
    ) -> LogTraceParams &
    {
        if (this != &other) {
            message = other.message;
            if (other.verbose.has_value()) {
                verbose = other.verbose.value();
            }
        }
        return *this;
    }

    StaticRegistrationOptions::StaticRegistrationOptions()
    {
        // empty
    }

    StaticRegistrationOptions::StaticRegistrationOptions(
        StaticRegistrationOptions &&other
    )
        : id(std::move(other.id))
    {
        // empty
    }

    StaticRegistrationOptions::StaticRegistrationOptions(
        const StaticRegistrationOptions &other
    )
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    StaticRegistrationOptions::~StaticRegistrationOptions()
    {
        // empty
    }

    auto StaticRegistrationOptions::operator=(
        StaticRegistrationOptions &&other
    ) -> StaticRegistrationOptions &
    {
        if (this != &other) {
            id = std::move(other.id);
        }
        return *this;
    }

    auto StaticRegistrationOptions::operator=(
        const StaticRegistrationOptions &other
    ) -> StaticRegistrationOptions &
    {
        if (this != &other) {
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    WorkspaceFoldersChangeEvent::WorkspaceFoldersChangeEvent()
    {
        // empty
    }

    WorkspaceFoldersChangeEvent::WorkspaceFoldersChangeEvent(
        WorkspaceFoldersChangeEvent &&other
    )
        : added(std::move(other.added))
        , removed(std::move(other.removed))
    {
        // empty
    }

    WorkspaceFoldersChangeEvent::WorkspaceFoldersChangeEvent(
        const WorkspaceFoldersChangeEvent &other
    )
    {
        added.reserve(other.added.size());
        for (const auto &elem_0 : other.added) {
            added.push_back(elem_0);
        }
        removed.reserve(other.removed.size());
        for (const auto &elem_1 : other.removed) {
            removed.push_back(elem_1);
        }
    }

    WorkspaceFoldersChangeEvent::~WorkspaceFoldersChangeEvent()
    {
        // empty
    }

    auto WorkspaceFoldersChangeEvent::operator=(
        WorkspaceFoldersChangeEvent &&other
    ) -> WorkspaceFoldersChangeEvent &
    {
        if (this != &other) {
            added = std::move(other.added);
            removed = std::move(other.removed);
        }
        return *this;
    }

    auto WorkspaceFoldersChangeEvent::operator=(
        const WorkspaceFoldersChangeEvent &other
    ) -> WorkspaceFoldersChangeEvent &
    {
        if (this != &other) {
            added.reserve(other.added.size());
            for (const auto &elem_0 : other.added) {
                added.push_back(elem_0);
            }
            removed.reserve(other.removed.size());
            for (const auto &elem_1 : other.removed) {
                removed.push_back(elem_1);
            }
        }
        return *this;
    }

    DidChangeWorkspaceFoldersParams::DidChangeWorkspaceFoldersParams()
    {
        // empty
    }

    DidChangeWorkspaceFoldersParams::DidChangeWorkspaceFoldersParams(
        DidChangeWorkspaceFoldersParams &&other
    )
        : event(std::move(other.event))
    {
        // empty
    }

    DidChangeWorkspaceFoldersParams::DidChangeWorkspaceFoldersParams(
        const DidChangeWorkspaceFoldersParams &other
    )
        : event(other.event)
    {
    }

    DidChangeWorkspaceFoldersParams::~DidChangeWorkspaceFoldersParams()
    {
        // empty
    }

    auto DidChangeWorkspaceFoldersParams::operator=(
        DidChangeWorkspaceFoldersParams &&other
    ) -> DidChangeWorkspaceFoldersParams &
    {
        if (this != &other) {
            event = std::move(other.event);
        }
        return *this;
    }

    auto DidChangeWorkspaceFoldersParams::operator=(
        const DidChangeWorkspaceFoldersParams &other
    ) -> DidChangeWorkspaceFoldersParams &
    {
        if (this != &other) {
            event = other.event;
        }
        return *this;
    }

    ConfigurationItem::ConfigurationItem()
    {
        // empty
    }

    ConfigurationItem::ConfigurationItem(ConfigurationItem &&other)
        : scopeUri(std::move(other.scopeUri))
        , section(std::move(other.section))
    {
        // empty
    }

    ConfigurationItem::ConfigurationItem(const ConfigurationItem &other)
    {
        if (other.scopeUri.has_value()) {
            scopeUri = other.scopeUri.value();
        }
        if (other.section.has_value()) {
            section = other.section.value();
        }
    }

    ConfigurationItem::~ConfigurationItem()
    {
        // empty
    }

    auto ConfigurationItem::operator=(
        ConfigurationItem &&other
    ) -> ConfigurationItem &
    {
        if (this != &other) {
            scopeUri = std::move(other.scopeUri);
            section = std::move(other.section);
        }
        return *this;
    }

    auto ConfigurationItem::operator=(
        const ConfigurationItem &other
    ) -> ConfigurationItem &
    {
        if (this != &other) {
            if (other.scopeUri.has_value()) {
                scopeUri = other.scopeUri.value();
            }
            if (other.section.has_value()) {
                section = other.section.value();
            }
        }
        return *this;
    }

    ConfigurationParams::ConfigurationParams()
    {
        // empty
    }

    ConfigurationParams::ConfigurationParams(ConfigurationParams &&other)
        : items(std::move(other.items))
    {
        // empty
    }

    ConfigurationParams::ConfigurationParams(const ConfigurationParams &other)
    {
        items.reserve(other.items.size());
        for (const auto &elem_0 : other.items) {
            items.push_back(elem_0);
        }
    }

    ConfigurationParams::~ConfigurationParams()
    {
        // empty
    }

    auto ConfigurationParams::operator=(
        ConfigurationParams &&other
    ) -> ConfigurationParams &
    {
        if (this != &other) {
            items = std::move(other.items);
        }
        return *this;
    }

    auto ConfigurationParams::operator=(
        const ConfigurationParams &other
    ) -> ConfigurationParams &
    {
        if (this != &other) {
            items.reserve(other.items.size());
            for (const auto &elem_0 : other.items) {
                items.push_back(elem_0);
            }
        }
        return *this;
    }

    FileCreate::FileCreate()
    {
        // empty
    }

    FileCreate::FileCreate(FileCreate &&other)
        : uri(std::move(other.uri))
    {
        // empty
    }

    FileCreate::FileCreate(const FileCreate &other)
        : uri(other.uri)
    {
    }

    FileCreate::~FileCreate()
    {
        // empty
    }

    auto FileCreate::operator=(FileCreate &&other) -> FileCreate &
    {
        if (this != &other) {
            uri = std::move(other.uri);
        }
        return *this;
    }

    auto FileCreate::operator=(const FileCreate &other) -> FileCreate &
    {
        if (this != &other) {
            uri = other.uri;
        }
        return *this;
    }

    CreateFilesParams::CreateFilesParams()
    {
        // empty
    }

    CreateFilesParams::CreateFilesParams(CreateFilesParams &&other)
        : files(std::move(other.files))
    {
        // empty
    }

    CreateFilesParams::CreateFilesParams(const CreateFilesParams &other)
    {
        files.reserve(other.files.size());
        for (const auto &elem_0 : other.files) {
            files.push_back(elem_0);
        }
    }

    CreateFilesParams::~CreateFilesParams()
    {
        // empty
    }

    auto CreateFilesParams::operator=(
        CreateFilesParams &&other
    ) -> CreateFilesParams &
    {
        if (this != &other) {
            files = std::move(other.files);
        }
        return *this;
    }

    auto CreateFilesParams::operator=(
        const CreateFilesParams &other
    ) -> CreateFilesParams &
    {
        if (this != &other) {
            files.reserve(other.files.size());
            for (const auto &elem_0 : other.files) {
                files.push_back(elem_0);
            }
        }
        return *this;
    }

    FileRename::FileRename()
    {
        // empty
    }

    FileRename::FileRename(FileRename &&other)
        : oldUri(std::move(other.oldUri))
        , newUri(std::move(other.newUri))
    {
        // empty
    }

    FileRename::FileRename(const FileRename &other)
        : oldUri(other.oldUri)
        , newUri(other.newUri)
    {
    }

    FileRename::~FileRename()
    {
        // empty
    }

    auto FileRename::operator=(FileRename &&other) -> FileRename &
    {
        if (this != &other) {
            oldUri = std::move(other.oldUri);
            newUri = std::move(other.newUri);
        }
        return *this;
    }

    auto FileRename::operator=(const FileRename &other) -> FileRename &
    {
        if (this != &other) {
            oldUri = other.oldUri;
            newUri = other.newUri;
        }
        return *this;
    }

    RenameFilesParams::RenameFilesParams()
    {
        // empty
    }

    RenameFilesParams::RenameFilesParams(RenameFilesParams &&other)
        : files(std::move(other.files))
    {
        // empty
    }

    RenameFilesParams::RenameFilesParams(const RenameFilesParams &other)
    {
        files.reserve(other.files.size());
        for (const auto &elem_0 : other.files) {
            files.push_back(elem_0);
        }
    }

    RenameFilesParams::~RenameFilesParams()
    {
        // empty
    }

    auto RenameFilesParams::operator=(
        RenameFilesParams &&other
    ) -> RenameFilesParams &
    {
        if (this != &other) {
            files = std::move(other.files);
        }
        return *this;
    }

    auto RenameFilesParams::operator=(
        const RenameFilesParams &other
    ) -> RenameFilesParams &
    {
        if (this != &other) {
            files.reserve(other.files.size());
            for (const auto &elem_0 : other.files) {
                files.push_back(elem_0);
            }
        }
        return *this;
    }

    FileDelete::FileDelete()
    {
        // empty
    }

    FileDelete::FileDelete(FileDelete &&other)
        : uri(std::move(other.uri))
    {
        // empty
    }

    FileDelete::FileDelete(const FileDelete &other)
        : uri(other.uri)
    {
    }

    FileDelete::~FileDelete()
    {
        // empty
    }

    auto FileDelete::operator=(FileDelete &&other) -> FileDelete &
    {
        if (this != &other) {
            uri = std::move(other.uri);
        }
        return *this;
    }

    auto FileDelete::operator=(const FileDelete &other) -> FileDelete &
    {
        if (this != &other) {
            uri = other.uri;
        }
        return *this;
    }

    DeleteFilesParams::DeleteFilesParams()
    {
        // empty
    }

    DeleteFilesParams::DeleteFilesParams(DeleteFilesParams &&other)
        : files(std::move(other.files))
    {
        // empty
    }

    DeleteFilesParams::DeleteFilesParams(const DeleteFilesParams &other)
    {
        files.reserve(other.files.size());
        for (const auto &elem_0 : other.files) {
            files.push_back(elem_0);
        }
    }

    DeleteFilesParams::~DeleteFilesParams()
    {
        // empty
    }

    auto DeleteFilesParams::operator=(
        DeleteFilesParams &&other
    ) -> DeleteFilesParams &
    {
        if (this != &other) {
            files = std::move(other.files);
        }
        return *this;
    }

    auto DeleteFilesParams::operator=(
        const DeleteFilesParams &other
    ) -> DeleteFilesParams &
    {
        if (this != &other) {
            files.reserve(other.files.size());
            for (const auto &elem_0 : other.files) {
                files.push_back(elem_0);
            }
        }
        return *this;
    }

    MarkupContent::MarkupContent()
    {
        // empty
    }

    MarkupContent::MarkupContent(MarkupContent &&other)
        : kind(std::move(other.kind))
        , value(std::move(other.value))
    {
        // empty
    }

    MarkupContent::MarkupContent(const MarkupContent &other)
        : kind(other.kind)
        , value(other.value)
    {
    }

    MarkupContent::~MarkupContent()
    {
        // empty
    }

    auto MarkupContent::operator=(MarkupContent &&other) -> MarkupContent &
    {
        if (this != &other) {
            kind = std::move(other.kind);
            value = std::move(other.value);
        }
        return *this;
    }

    auto MarkupContent::operator=(
        const MarkupContent &other
    ) -> MarkupContent &
    {
        if (this != &other) {
            kind = other.kind;
            value = other.value;
        }
        return *this;
    }

    const std::map<InlayHint_tooltipType, std::string>
    InlayHint_tooltipTypeNames = {
        {InlayHint_tooltipType::Uninitialized, "Uninitialized"},
        {InlayHint_tooltipType::String, "String"},
        {InlayHint_tooltipType::MarkupContent, "MarkupContent"},
    };

    InlayHint_tooltip::InlayHint_tooltip()
    {
        // empty
    }

    InlayHint_tooltip::~InlayHint_tooltip()
    {
        reset();
    }

    InlayHint_tooltip::InlayHint_tooltip(InlayHint_tooltip &&other)
        : _type(other._type)
    {
        switch (other._type) {
        case InlayHint_tooltipType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case InlayHint_tooltipType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::move(other._markupContent)
            };
            break;
        }
        case InlayHint_tooltipType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = InlayHint_tooltipType::Uninitialized;
    }

    InlayHint_tooltip::InlayHint_tooltip(const InlayHint_tooltip &other)
        : _type(other._type)
    {
        switch (other._type) {
        case InlayHint_tooltipType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case InlayHint_tooltipType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::make_unique<MarkupContent>(*other._markupContent)
            };
            break;
        }
        case InlayHint_tooltipType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto InlayHint_tooltip::operator=(
        InlayHint_tooltip &&other
    ) -> InlayHint_tooltip &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case InlayHint_tooltipType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case InlayHint_tooltipType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::move(other._markupContent)
                };
                break;
            }
            case InlayHint_tooltipType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = InlayHint_tooltipType::Uninitialized;
        }
        return *this;
    }

    auto InlayHint_tooltip::operator=(
        const InlayHint_tooltip &other
    ) -> InlayHint_tooltip &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case InlayHint_tooltipType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case InlayHint_tooltipType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::make_unique<MarkupContent>(*other._markupContent)
                };
                break;
            }
            case InlayHint_tooltipType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto InlayHint_tooltip::reset() -> void
    {
        switch (_type) {
        case InlayHint_tooltipType::Uninitialized: {
            // nothing to do
            break;
        }
        case InlayHint_tooltipType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = InlayHint_tooltipType::Uninitialized;
            break;
        }
        case InlayHint_tooltipType::MarkupContent: {
#ifdef DEBUG
            if (!_markupContent) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markupContent"
                );
            }
#endif // DEBUG
            _markupContent.~unique_ptr<MarkupContent>();
            _type = InlayHint_tooltipType::Uninitialized;
            break;
        }
        default: {
            _type = InlayHint_tooltipType::Uninitialized;
        }
        }
    }

    auto InlayHint_tooltip::type() const -> const InlayHint_tooltipType &
    {
        return _type;
    }

    auto InlayHint_tooltip::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != InlayHint_tooltipType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "InlayHint_tooltip::string()"
                 " of type "
                 "InlayHint_tooltipType::String"
                 " while active type is "
                 "InlayHint_tooltipType::" +
                 InlayHint_tooltipTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto InlayHint_tooltip::operator=(
        const std::unique_ptr<string_t> &string
    ) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = InlayHint_tooltipType::String;
        return *this;
    }

    auto InlayHint_tooltip::operator=(
        std::unique_ptr<string_t> &&string
    ) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = InlayHint_tooltipType::String;
        return *this;
    }

    auto InlayHint_tooltip::operator=(
        const string_t &string
    ) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = InlayHint_tooltipType::String;
        return *this;
    }

    auto InlayHint_tooltip::operator=(string_t &&string) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = InlayHint_tooltipType::String;
        return *this;
    }

    auto InlayHint_tooltip::markupContent() const -> const MarkupContent &
    {
#ifdef DEBUG
        if (_type != InlayHint_tooltipType::MarkupContent) {
            throw std::logic_error(
                ("Attempted to access "
                 "InlayHint_tooltip::markupContent()"
                 " of type "
                 "InlayHint_tooltipType::MarkupContent"
                 " while active type is "
                 "InlayHint_tooltipType::" +
                 InlayHint_tooltipTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markupContent;
    }

    auto InlayHint_tooltip::operator=(
        const std::unique_ptr<MarkupContent> &markupContent
    ) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(*markupContent)
        };
        _type = InlayHint_tooltipType::MarkupContent;
        return *this;
    }

    auto InlayHint_tooltip::operator=(
        std::unique_ptr<MarkupContent> &&markupContent
    ) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::move(markupContent)
        };
        _type = InlayHint_tooltipType::MarkupContent;
        return *this;
    }

    auto InlayHint_tooltip::operator=(
        const MarkupContent &markupContent
    ) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(markupContent)
        };
        _type = InlayHint_tooltipType::MarkupContent;
        return *this;
    }

    auto InlayHint_tooltip::operator=(
        MarkupContent &&markupContent
    ) -> InlayHint_tooltip &
    {
        if (_type != InlayHint_tooltipType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(std::move(markupContent))
        };
        _type = InlayHint_tooltipType::MarkupContent;
        return *this;
    }

    const std::map<CompletionItem_documentationType, std::string>
    CompletionItem_documentationTypeNames = {
        {CompletionItem_documentationType::Uninitialized, "Uninitialized"},
        {CompletionItem_documentationType::String, "String"},
        {CompletionItem_documentationType::MarkupContent, "MarkupContent"},
    };

    CompletionItem_documentation::CompletionItem_documentation()
    {
        // empty
    }

    CompletionItem_documentation::~CompletionItem_documentation()
    {
        reset();
    }

    CompletionItem_documentation::CompletionItem_documentation(
        CompletionItem_documentation &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case CompletionItem_documentationType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case CompletionItem_documentationType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::move(other._markupContent)
            };
            break;
        }
        case CompletionItem_documentationType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = CompletionItem_documentationType::Uninitialized;
    }

    CompletionItem_documentation::CompletionItem_documentation(
        const CompletionItem_documentation &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case CompletionItem_documentationType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case CompletionItem_documentationType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::make_unique<MarkupContent>(*other._markupContent)
            };
            break;
        }
        case CompletionItem_documentationType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto CompletionItem_documentation::operator=(
        CompletionItem_documentation &&other
    ) -> CompletionItem_documentation &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case CompletionItem_documentationType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case CompletionItem_documentationType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::move(other._markupContent)
                };
                break;
            }
            case CompletionItem_documentationType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = CompletionItem_documentationType::Uninitialized;
        }
        return *this;
    }

    auto CompletionItem_documentation::operator=(
        const CompletionItem_documentation &other
    ) -> CompletionItem_documentation &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case CompletionItem_documentationType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case CompletionItem_documentationType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::make_unique<MarkupContent>(*other._markupContent)
                };
                break;
            }
            case CompletionItem_documentationType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto CompletionItem_documentation::reset() -> void
    {
        switch (_type) {
        case CompletionItem_documentationType::Uninitialized: {
            // nothing to do
            break;
        }
        case CompletionItem_documentationType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = CompletionItem_documentationType::Uninitialized;
            break;
        }
        case CompletionItem_documentationType::MarkupContent: {
#ifdef DEBUG
            if (!_markupContent) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markupContent"
                );
            }
#endif // DEBUG
            _markupContent.~unique_ptr<MarkupContent>();
            _type = CompletionItem_documentationType::Uninitialized;
            break;
        }
        default: {
            _type = CompletionItem_documentationType::Uninitialized;
        }
        }
    }

    auto CompletionItem_documentation::type() const
    -> const CompletionItem_documentationType &
    {
        return _type;
    }

    auto CompletionItem_documentation::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != CompletionItem_documentationType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "CompletionItem_documentation::string()"
                 " of type "
                 "CompletionItem_documentationType::String"
                 " while active type is "
                 "CompletionItem_documentationType::" +
                 CompletionItem_documentationTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto CompletionItem_documentation::operator=(
        const std::unique_ptr<string_t> &string
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = CompletionItem_documentationType::String;
        return *this;
    }

    auto CompletionItem_documentation::operator=(
        std::unique_ptr<string_t> &&string
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = CompletionItem_documentationType::String;
        return *this;
    }

    auto CompletionItem_documentation::operator=(
        const string_t &string
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = CompletionItem_documentationType::String;
        return *this;
    }

    auto CompletionItem_documentation::operator=(
        string_t &&string
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = CompletionItem_documentationType::String;
        return *this;
    }

    auto CompletionItem_documentation::markupContent() const
    -> const MarkupContent &
    {
#ifdef DEBUG
        if (_type != CompletionItem_documentationType::MarkupContent) {
            throw std::logic_error(
                ("Attempted to access "
                 "CompletionItem_documentation::markupContent()"
                 " of type "
                 "CompletionItem_documentationType::MarkupContent"
                 " while active type is "
                 "CompletionItem_documentationType::" +
                 CompletionItem_documentationTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markupContent;
    }

    auto CompletionItem_documentation::operator=(
        const std::unique_ptr<MarkupContent> &markupContent
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(*markupContent)
        };
        _type = CompletionItem_documentationType::MarkupContent;
        return *this;
    }

    auto CompletionItem_documentation::operator=(
        std::unique_ptr<MarkupContent> &&markupContent
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::move(markupContent)
        };
        _type = CompletionItem_documentationType::MarkupContent;
        return *this;
    }

    auto CompletionItem_documentation::operator=(
        const MarkupContent &markupContent
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(markupContent)
        };
        _type = CompletionItem_documentationType::MarkupContent;
        return *this;
    }

    auto CompletionItem_documentation::operator=(
        MarkupContent &&markupContent
    ) -> CompletionItem_documentation &
    {
        if (_type != CompletionItem_documentationType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(std::move(markupContent))
        };
        _type = CompletionItem_documentationType::MarkupContent;
        return *this;
    }

    const std::map<InlayHintLabelPart_tooltipType, std::string>
    InlayHintLabelPart_tooltipTypeNames = {
        {InlayHintLabelPart_tooltipType::Uninitialized, "Uninitialized"},
        {InlayHintLabelPart_tooltipType::String, "String"},
        {InlayHintLabelPart_tooltipType::MarkupContent, "MarkupContent"},
    };

    InlayHintLabelPart_tooltip::InlayHintLabelPart_tooltip()
    {
        // empty
    }

    InlayHintLabelPart_tooltip::~InlayHintLabelPart_tooltip()
    {
        reset();
    }

    InlayHintLabelPart_tooltip::InlayHintLabelPart_tooltip(
        InlayHintLabelPart_tooltip &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case InlayHintLabelPart_tooltipType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case InlayHintLabelPart_tooltipType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::move(other._markupContent)
            };
            break;
        }
        case InlayHintLabelPart_tooltipType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = InlayHintLabelPart_tooltipType::Uninitialized;
    }

    InlayHintLabelPart_tooltip::InlayHintLabelPart_tooltip(
        const InlayHintLabelPart_tooltip &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case InlayHintLabelPart_tooltipType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case InlayHintLabelPart_tooltipType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::make_unique<MarkupContent>(*other._markupContent)
            };
            break;
        }
        case InlayHintLabelPart_tooltipType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto InlayHintLabelPart_tooltip::operator=(
        InlayHintLabelPart_tooltip &&other
    ) -> InlayHintLabelPart_tooltip &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case InlayHintLabelPart_tooltipType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case InlayHintLabelPart_tooltipType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::move(other._markupContent)
                };
                break;
            }
            case InlayHintLabelPart_tooltipType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = InlayHintLabelPart_tooltipType::Uninitialized;
        }
        return *this;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        const InlayHintLabelPart_tooltip &other
    ) -> InlayHintLabelPart_tooltip &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case InlayHintLabelPart_tooltipType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case InlayHintLabelPart_tooltipType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::make_unique<MarkupContent>(*other._markupContent)
                };
                break;
            }
            case InlayHintLabelPart_tooltipType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto InlayHintLabelPart_tooltip::reset() -> void
    {
        switch (_type) {
        case InlayHintLabelPart_tooltipType::Uninitialized: {
            // nothing to do
            break;
        }
        case InlayHintLabelPart_tooltipType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = InlayHintLabelPart_tooltipType::Uninitialized;
            break;
        }
        case InlayHintLabelPart_tooltipType::MarkupContent: {
#ifdef DEBUG
            if (!_markupContent) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markupContent"
                );
            }
#endif // DEBUG
            _markupContent.~unique_ptr<MarkupContent>();
            _type = InlayHintLabelPart_tooltipType::Uninitialized;
            break;
        }
        default: {
            _type = InlayHintLabelPart_tooltipType::Uninitialized;
        }
        }
    }

    auto InlayHintLabelPart_tooltip::type() const
    -> const InlayHintLabelPart_tooltipType &
    {
        return _type;
    }

    auto InlayHintLabelPart_tooltip::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != InlayHintLabelPart_tooltipType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "InlayHintLabelPart_tooltip::string()"
                 " of type "
                 "InlayHintLabelPart_tooltipType::String"
                 " while active type is "
                 "InlayHintLabelPart_tooltipType::" +
                 InlayHintLabelPart_tooltipTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        const std::unique_ptr<string_t> &string
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = InlayHintLabelPart_tooltipType::String;
        return *this;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        std::unique_ptr<string_t> &&string
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = InlayHintLabelPart_tooltipType::String;
        return *this;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        const string_t &string
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = InlayHintLabelPart_tooltipType::String;
        return *this;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        string_t &&string
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = InlayHintLabelPart_tooltipType::String;
        return *this;
    }

    auto InlayHintLabelPart_tooltip::markupContent() const
    -> const MarkupContent &
    {
#ifdef DEBUG
        if (_type != InlayHintLabelPart_tooltipType::MarkupContent) {
            throw std::logic_error(
                ("Attempted to access "
                 "InlayHintLabelPart_tooltip::markupContent()"
                 " of type "
                 "InlayHintLabelPart_tooltipType::MarkupContent"
                 " while active type is "
                 "InlayHintLabelPart_tooltipType::" +
                 InlayHintLabelPart_tooltipTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markupContent;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        const std::unique_ptr<MarkupContent> &markupContent
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(*markupContent)
        };
        _type = InlayHintLabelPart_tooltipType::MarkupContent;
        return *this;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        std::unique_ptr<MarkupContent> &&markupContent
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::move(markupContent)
        };
        _type = InlayHintLabelPart_tooltipType::MarkupContent;
        return *this;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        const MarkupContent &markupContent
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(markupContent)
        };
        _type = InlayHintLabelPart_tooltipType::MarkupContent;
        return *this;
    }

    auto InlayHintLabelPart_tooltip::operator=(
        MarkupContent &&markupContent
    ) -> InlayHintLabelPart_tooltip &
    {
        if (_type != InlayHintLabelPart_tooltipType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(std::move(markupContent))
        };
        _type = InlayHintLabelPart_tooltipType::MarkupContent;
        return *this;
    }

    UnchangedDocumentDiagnosticReport::UnchangedDocumentDiagnosticReport()
    {
        // empty
    }

    UnchangedDocumentDiagnosticReport::UnchangedDocumentDiagnosticReport(
        UnchangedDocumentDiagnosticReport &&other
    )
        : kind(std::move(other.kind))
        , resultId(std::move(other.resultId))
    {
        // empty
    }

    UnchangedDocumentDiagnosticReport::UnchangedDocumentDiagnosticReport(
        const UnchangedDocumentDiagnosticReport &other
    )
        : resultId(other.resultId)
    {
    }

    UnchangedDocumentDiagnosticReport::~UnchangedDocumentDiagnosticReport()
    {
        // empty
    }

    auto UnchangedDocumentDiagnosticReport::operator=(
        UnchangedDocumentDiagnosticReport &&other
    ) -> UnchangedDocumentDiagnosticReport &
    {
        if (this != &other) {
            kind = std::move(other.kind);
            resultId = std::move(other.resultId);
        }
        return *this;
    }

    auto UnchangedDocumentDiagnosticReport::operator=(
        const UnchangedDocumentDiagnosticReport &other
    ) -> UnchangedDocumentDiagnosticReport &
    {
        if (this != &other) {
            resultId = other.resultId;
        }
        return *this;
    }

    PreviousResultId::PreviousResultId()
    {
        // empty
    }

    PreviousResultId::PreviousResultId(PreviousResultId &&other)
        : uri(std::move(other.uri))
        , value(std::move(other.value))
    {
        // empty
    }

    PreviousResultId::PreviousResultId(const PreviousResultId &other)
        : uri(other.uri)
        , value(other.value)
    {
    }

    PreviousResultId::~PreviousResultId()
    {
        // empty
    }

    auto PreviousResultId::operator=(
        PreviousResultId &&other
    ) -> PreviousResultId &
    {
        if (this != &other) {
            uri = std::move(other.uri);
            value = std::move(other.value);
        }
        return *this;
    }

    auto PreviousResultId::operator=(
        const PreviousResultId &other
    ) -> PreviousResultId &
    {
        if (this != &other) {
            uri = other.uri;
            value = other.value;
        }
        return *this;
    }

    StringValue::StringValue()
    {
        // empty
    }

    StringValue::StringValue(StringValue &&other)
        : kind(std::move(other.kind))
        , value(std::move(other.value))
    {
        // empty
    }

    StringValue::StringValue(const StringValue &other)
        : value(other.value)
    {
    }

    StringValue::~StringValue()
    {
        // empty
    }

    auto StringValue::operator=(StringValue &&other) -> StringValue &
    {
        if (this != &other) {
            kind = std::move(other.kind);
            value = std::move(other.value);
        }
        return *this;
    }

    auto StringValue::operator=(const StringValue &other) -> StringValue &
    {
        if (this != &other) {
            value = other.value;
        }
        return *this;
    }

    const std::map<InlineCompletionItem_insertTextType, std::string>
    InlineCompletionItem_insertTextTypeNames = {
        {InlineCompletionItem_insertTextType::Uninitialized, "Uninitialized"},
        {InlineCompletionItem_insertTextType::String, "String"},
        {InlineCompletionItem_insertTextType::StringValue, "StringValue"},
    };

    InlineCompletionItem_insertText::InlineCompletionItem_insertText()
    {
        // empty
    }

    InlineCompletionItem_insertText::~InlineCompletionItem_insertText()
    {
        reset();
    }

    InlineCompletionItem_insertText::InlineCompletionItem_insertText(
        InlineCompletionItem_insertText &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case InlineCompletionItem_insertTextType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case InlineCompletionItem_insertTextType::StringValue: {
            new (&_stringValue) std::unique_ptr<StringValue> {
                std::move(other._stringValue)
            };
            break;
        }
        case InlineCompletionItem_insertTextType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = InlineCompletionItem_insertTextType::Uninitialized;
    }

    InlineCompletionItem_insertText::InlineCompletionItem_insertText(
        const InlineCompletionItem_insertText &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case InlineCompletionItem_insertTextType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case InlineCompletionItem_insertTextType::StringValue: {
            new (&_stringValue) std::unique_ptr<StringValue> {
                std::make_unique<StringValue>(*other._stringValue)
            };
            break;
        }
        case InlineCompletionItem_insertTextType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto InlineCompletionItem_insertText::operator=(
        InlineCompletionItem_insertText &&other
    ) -> InlineCompletionItem_insertText &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case InlineCompletionItem_insertTextType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case InlineCompletionItem_insertTextType::StringValue: {
                new (&_stringValue) std::unique_ptr<StringValue> {
                    std::move(other._stringValue)
                };
                break;
            }
            case InlineCompletionItem_insertTextType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = InlineCompletionItem_insertTextType::Uninitialized;
        }
        return *this;
    }

    auto InlineCompletionItem_insertText::operator=(
        const InlineCompletionItem_insertText &other
    ) -> InlineCompletionItem_insertText &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case InlineCompletionItem_insertTextType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case InlineCompletionItem_insertTextType::StringValue: {
                new (&_stringValue) std::unique_ptr<StringValue> {
                    std::make_unique<StringValue>(*other._stringValue)
                };
                break;
            }
            case InlineCompletionItem_insertTextType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto InlineCompletionItem_insertText::reset() -> void
    {
        switch (_type) {
        case InlineCompletionItem_insertTextType::Uninitialized: {
            // nothing to do
            break;
        }
        case InlineCompletionItem_insertTextType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = InlineCompletionItem_insertTextType::Uninitialized;
            break;
        }
        case InlineCompletionItem_insertTextType::StringValue: {
#ifdef DEBUG
            if (!_stringValue) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _stringValue"
                );
            }
#endif // DEBUG
            _stringValue.~unique_ptr<StringValue>();
            _type = InlineCompletionItem_insertTextType::Uninitialized;
            break;
        }
        default: {
            _type = InlineCompletionItem_insertTextType::Uninitialized;
        }
        }
    }

    auto InlineCompletionItem_insertText::type() const
    -> const InlineCompletionItem_insertTextType &
    {
        return _type;
    }

    auto InlineCompletionItem_insertText::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != InlineCompletionItem_insertTextType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "InlineCompletionItem_insertText::string()"
                 " of type "
                 "InlineCompletionItem_insertTextType::String"
                 " while active type is "
                 "InlineCompletionItem_insertTextType::" +
                 InlineCompletionItem_insertTextTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto InlineCompletionItem_insertText::operator=(
        const std::unique_ptr<string_t> &string
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = InlineCompletionItem_insertTextType::String;
        return *this;
    }

    auto InlineCompletionItem_insertText::operator=(
        std::unique_ptr<string_t> &&string
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = InlineCompletionItem_insertTextType::String;
        return *this;
    }

    auto InlineCompletionItem_insertText::operator=(
        const string_t &string
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = InlineCompletionItem_insertTextType::String;
        return *this;
    }

    auto InlineCompletionItem_insertText::operator=(
        string_t &&string
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = InlineCompletionItem_insertTextType::String;
        return *this;
    }

    auto InlineCompletionItem_insertText::stringValue() const
    -> const StringValue &
    {
#ifdef DEBUG
        if (_type != InlineCompletionItem_insertTextType::StringValue) {
            throw std::logic_error(
                ("Attempted to access "
                 "InlineCompletionItem_insertText::stringValue()"
                 " of type "
                 "InlineCompletionItem_insertTextType::StringValue"
                 " while active type is "
                 "InlineCompletionItem_insertTextType::" +
                 InlineCompletionItem_insertTextTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_stringValue;
    }

    auto InlineCompletionItem_insertText::operator=(
        const std::unique_ptr<StringValue> &stringValue
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!stringValue) {
            throw std::logic_error("null passed as the value of stringValue");
        }
#endif // DEBUG
        new (&_stringValue) std::unique_ptr<StringValue> {
            std::make_unique<StringValue>(*stringValue)
        };
        _type = InlineCompletionItem_insertTextType::StringValue;
        return *this;
    }

    auto InlineCompletionItem_insertText::operator=(
        std::unique_ptr<StringValue> &&stringValue
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!stringValue) {
            throw std::logic_error("null passed as the value of stringValue");
        }
#endif // DEBUG
        new (&_stringValue) std::unique_ptr<StringValue> {
            std::move(stringValue)
        };
        _type = InlineCompletionItem_insertTextType::StringValue;
        return *this;
    }

    auto InlineCompletionItem_insertText::operator=(
        const StringValue &stringValue
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
        new (&_stringValue) std::unique_ptr<StringValue> {
            std::make_unique<StringValue>(stringValue)
        };
        _type = InlineCompletionItem_insertTextType::StringValue;
        return *this;
    }

    auto InlineCompletionItem_insertText::operator=(
        StringValue &&stringValue
    ) -> InlineCompletionItem_insertText &
    {
        if (_type != InlineCompletionItem_insertTextType::Uninitialized) {
            reset();
        }
        new (&_stringValue) std::unique_ptr<StringValue> {
            std::make_unique<StringValue>(std::move(stringValue))
        };
        _type = InlineCompletionItem_insertTextType::StringValue;
        return *this;
    }

    Unregistration::Unregistration()
    {
        // empty
    }

    Unregistration::Unregistration(Unregistration &&other)
        : id(std::move(other.id))
        , method(std::move(other.method))
    {
        // empty
    }

    Unregistration::Unregistration(const Unregistration &other)
        : id(other.id)
        , method(other.method)
    {
    }

    Unregistration::~Unregistration()
    {
        // empty
    }

    auto Unregistration::operator=(Unregistration &&other) -> Unregistration &
    {
        if (this != &other) {
            id = std::move(other.id);
            method = std::move(other.method);
        }
        return *this;
    }

    auto Unregistration::operator=(
        const Unregistration &other
    ) -> Unregistration &
    {
        if (this != &other) {
            id = other.id;
            method = other.method;
        }
        return *this;
    }

    UnregistrationParams::UnregistrationParams()
    {
        // empty
    }

    UnregistrationParams::UnregistrationParams(UnregistrationParams &&other)
        : unregisterations(std::move(other.unregisterations))
    {
        // empty
    }

    UnregistrationParams::UnregistrationParams(
        const UnregistrationParams &other
    )
    {
        unregisterations.reserve(other.unregisterations.size());
        for (const auto &elem_0 : other.unregisterations) {
            unregisterations.push_back(elem_0);
        }
    }

    UnregistrationParams::~UnregistrationParams()
    {
        // empty
    }

    auto UnregistrationParams::operator=(
        UnregistrationParams &&other
    ) -> UnregistrationParams &
    {
        if (this != &other) {
            unregisterations = std::move(other.unregisterations);
        }
        return *this;
    }

    auto UnregistrationParams::operator=(
        const UnregistrationParams &other
    ) -> UnregistrationParams &
    {
        if (this != &other) {
            unregisterations.reserve(other.unregisterations.size());
            for (const auto &elem_0 : other.unregisterations) {
                unregisterations.push_back(elem_0);
            }
        }
        return *this;
    }

    _InitializeParams_clientInfo::_InitializeParams_clientInfo()
    {
        // empty
    }

    _InitializeParams_clientInfo::_InitializeParams_clientInfo(
        _InitializeParams_clientInfo &&other
    )
        : name(std::move(other.name))
        , version(std::move(other.version))
    {
        // empty
    }

    _InitializeParams_clientInfo::_InitializeParams_clientInfo(
        const _InitializeParams_clientInfo &other
    )
        : name(other.name)
    {
        if (other.version.has_value()) {
            version = other.version.value();
        }
    }

    _InitializeParams_clientInfo::~_InitializeParams_clientInfo()
    {
        // empty
    }

    auto _InitializeParams_clientInfo::operator=(
        _InitializeParams_clientInfo &&other
    ) -> _InitializeParams_clientInfo &
    {
        if (this != &other) {
            name = std::move(other.name);
            version = std::move(other.version);
        }
        return *this;
    }

    auto _InitializeParams_clientInfo::operator=(
        const _InitializeParams_clientInfo &other
    ) -> _InitializeParams_clientInfo &
    {
        if (this != &other) {
            name = other.name;
            if (other.version.has_value()) {
                version = other.version.value();
            }
        }
        return *this;
    }

    CompletionContext::CompletionContext()
    {
        // empty
    }

    CompletionContext::CompletionContext(CompletionContext &&other)
        : triggerKind(std::move(other.triggerKind))
        , triggerCharacter(std::move(other.triggerCharacter))
    {
        // empty
    }

    CompletionContext::CompletionContext(const CompletionContext &other)
        : triggerKind(other.triggerKind)
    {
        if (other.triggerCharacter.has_value()) {
            triggerCharacter = other.triggerCharacter.value();
        }
    }

    CompletionContext::~CompletionContext()
    {
        // empty
    }

    auto CompletionContext::operator=(
        CompletionContext &&other
    ) -> CompletionContext &
    {
        if (this != &other) {
            triggerKind = std::move(other.triggerKind);
            triggerCharacter = std::move(other.triggerCharacter);
        }
        return *this;
    }

    auto CompletionContext::operator=(
        const CompletionContext &other
    ) -> CompletionContext &
    {
        if (this != &other) {
            triggerKind = other.triggerKind;
            if (other.triggerCharacter.has_value()) {
                triggerCharacter = other.triggerCharacter.value();
            }
        }
        return *this;
    }

    CompletionItemLabelDetails::CompletionItemLabelDetails()
    {
        // empty
    }

    CompletionItemLabelDetails::CompletionItemLabelDetails(
        CompletionItemLabelDetails &&other
    )
        : detail(std::move(other.detail))
        , description(std::move(other.description))
    {
        // empty
    }

    CompletionItemLabelDetails::CompletionItemLabelDetails(
        const CompletionItemLabelDetails &other
    )
    {
        if (other.detail.has_value()) {
            detail = other.detail.value();
        }
        if (other.description.has_value()) {
            description = other.description.value();
        }
    }

    CompletionItemLabelDetails::~CompletionItemLabelDetails()
    {
        // empty
    }

    auto CompletionItemLabelDetails::operator=(
        CompletionItemLabelDetails &&other
    ) -> CompletionItemLabelDetails &
    {
        if (this != &other) {
            detail = std::move(other.detail);
            description = std::move(other.description);
        }
        return *this;
    }

    auto CompletionItemLabelDetails::operator=(
        const CompletionItemLabelDetails &other
    ) -> CompletionItemLabelDetails &
    {
        if (this != &other) {
            if (other.detail.has_value()) {
                detail = other.detail.value();
            }
            if (other.description.has_value()) {
                description = other.description.value();
            }
        }
        return *this;
    }

    const std::map<SignatureInformation_documentationType, std::string>
    SignatureInformation_documentationTypeNames = {
        {SignatureInformation_documentationType::Uninitialized,
         "Uninitialized"},
        {SignatureInformation_documentationType::String, "String"},
        {SignatureInformation_documentationType::MarkupContent,
         "MarkupContent"},
    };

    SignatureInformation_documentation::SignatureInformation_documentation()
    {
        // empty
    }

    SignatureInformation_documentation::~SignatureInformation_documentation()
    {
        reset();
    }

    SignatureInformation_documentation::SignatureInformation_documentation(
        SignatureInformation_documentation &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case SignatureInformation_documentationType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case SignatureInformation_documentationType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::move(other._markupContent)
            };
            break;
        }
        case SignatureInformation_documentationType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = SignatureInformation_documentationType::Uninitialized;
    }

    SignatureInformation_documentation::SignatureInformation_documentation(
        const SignatureInformation_documentation &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case SignatureInformation_documentationType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case SignatureInformation_documentationType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::make_unique<MarkupContent>(*other._markupContent)
            };
            break;
        }
        case SignatureInformation_documentationType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto SignatureInformation_documentation::operator=(
        SignatureInformation_documentation &&other
    ) -> SignatureInformation_documentation &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case SignatureInformation_documentationType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case SignatureInformation_documentationType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::move(other._markupContent)
                };
                break;
            }
            case SignatureInformation_documentationType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                SignatureInformation_documentationType::Uninitialized;
        }
        return *this;
    }

    auto SignatureInformation_documentation::operator=(
        const SignatureInformation_documentation &other
    ) -> SignatureInformation_documentation &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case SignatureInformation_documentationType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case SignatureInformation_documentationType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::make_unique<MarkupContent>(*other._markupContent)
                };
                break;
            }
            case SignatureInformation_documentationType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto SignatureInformation_documentation::reset() -> void
    {
        switch (_type) {
        case SignatureInformation_documentationType::Uninitialized: {
            // nothing to do
            break;
        }
        case SignatureInformation_documentationType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = SignatureInformation_documentationType::Uninitialized;
            break;
        }
        case SignatureInformation_documentationType::MarkupContent: {
#ifdef DEBUG
            if (!_markupContent) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markupContent"
                );
            }
#endif // DEBUG
            _markupContent.~unique_ptr<MarkupContent>();
            _type = SignatureInformation_documentationType::Uninitialized;
            break;
        }
        default: {
            _type = SignatureInformation_documentationType::Uninitialized;
        }
        }
    }

    auto SignatureInformation_documentation::type() const
    -> const SignatureInformation_documentationType &
    {
        return _type;
    }

    auto SignatureInformation_documentation::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != SignatureInformation_documentationType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "SignatureInformation_documentation::string()"
                 " of type "
                 "SignatureInformation_documentationType::String"
                 " while active type is "
                 "SignatureInformation_documentationType::" +
                 SignatureInformation_documentationTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto SignatureInformation_documentation::operator=(
        const std::unique_ptr<string_t> &string
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = SignatureInformation_documentationType::String;
        return *this;
    }

    auto SignatureInformation_documentation::operator=(
        std::unique_ptr<string_t> &&string
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = SignatureInformation_documentationType::String;
        return *this;
    }

    auto SignatureInformation_documentation::operator=(
        const string_t &string
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = SignatureInformation_documentationType::String;
        return *this;
    }

    auto SignatureInformation_documentation::operator=(
        string_t &&string
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = SignatureInformation_documentationType::String;
        return *this;
    }

    auto SignatureInformation_documentation::markupContent() const
    -> const MarkupContent &
    {
#ifdef DEBUG
        if (_type != SignatureInformation_documentationType::MarkupContent) {
            throw std::logic_error(
                ("Attempted to access "
                 "SignatureInformation_documentation::markupContent()"
                 " of type "
                 "SignatureInformation_documentationType::MarkupContent"
                 " while active type is "
                 "SignatureInformation_documentationType::" +
                 SignatureInformation_documentationTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markupContent;
    }

    auto SignatureInformation_documentation::operator=(
        const std::unique_ptr<MarkupContent> &markupContent
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(*markupContent)
        };
        _type = SignatureInformation_documentationType::MarkupContent;
        return *this;
    }

    auto SignatureInformation_documentation::operator=(
        std::unique_ptr<MarkupContent> &&markupContent
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::move(markupContent)
        };
        _type = SignatureInformation_documentationType::MarkupContent;
        return *this;
    }

    auto SignatureInformation_documentation::operator=(
        const MarkupContent &markupContent
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(markupContent)
        };
        _type = SignatureInformation_documentationType::MarkupContent;
        return *this;
    }

    auto SignatureInformation_documentation::operator=(
        MarkupContent &&markupContent
    ) -> SignatureInformation_documentation &
    {
        if (_type != SignatureInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(std::move(markupContent))
        };
        _type = SignatureInformation_documentationType::MarkupContent;
        return *this;
    }

    BaseSymbolInformation::BaseSymbolInformation()
    {
        // empty
    }

    BaseSymbolInformation::BaseSymbolInformation(BaseSymbolInformation &&other)
        : name(std::move(other.name))
        , kind(std::move(other.kind))
        , tags(std::move(other.tags))
        , containerName(std::move(other.containerName))
    {
        // empty
    }

    BaseSymbolInformation::BaseSymbolInformation(
        const BaseSymbolInformation &other
    )
        : name(other.name)
        , kind(other.kind)
    {
        if (other.tags.has_value()) {
            auto &array_0 = tags.emplace();
            const auto &array_1 = other.tags.value();
            array_0 = array_1;
        }
        if (other.containerName.has_value()) {
            containerName = other.containerName.value();
        }
    }

    BaseSymbolInformation::~BaseSymbolInformation()
    {
        // empty
    }

    auto BaseSymbolInformation::operator=(
        BaseSymbolInformation &&other
    ) -> BaseSymbolInformation &
    {
        if (this != &other) {
            name = std::move(other.name);
            kind = std::move(other.kind);
            tags = std::move(other.tags);
            containerName = std::move(other.containerName);
        }
        return *this;
    }

    auto BaseSymbolInformation::operator=(
        const BaseSymbolInformation &other
    ) -> BaseSymbolInformation &
    {
        if (this != &other) {
            name = other.name;
            kind = other.kind;
            if (other.tags.has_value()) {
                auto &array_0 = tags.emplace();
                const auto &array_1 = other.tags.value();
                array_0 = array_1;
            }
            if (other.containerName.has_value()) {
                containerName = other.containerName.value();
            }
        }
        return *this;
    }

    DocumentOnTypeFormattingOptions::DocumentOnTypeFormattingOptions()
    {
        // empty
    }

    DocumentOnTypeFormattingOptions::DocumentOnTypeFormattingOptions(
        DocumentOnTypeFormattingOptions &&other
    )
        : firstTriggerCharacter(std::move(other.firstTriggerCharacter))
        , moreTriggerCharacter(std::move(other.moreTriggerCharacter))
    {
        // empty
    }

    DocumentOnTypeFormattingOptions::DocumentOnTypeFormattingOptions(
        const DocumentOnTypeFormattingOptions &other
    )
        : firstTriggerCharacter(other.firstTriggerCharacter)
    {
        if (other.moreTriggerCharacter.has_value()) {
            auto &array_0 = moreTriggerCharacter.emplace();
            const auto &array_1 = other.moreTriggerCharacter.value();
            array_0 = array_1;
        }
    }

    DocumentOnTypeFormattingOptions::~DocumentOnTypeFormattingOptions()
    {
        // empty
    }

    auto DocumentOnTypeFormattingOptions::operator=(
        DocumentOnTypeFormattingOptions &&other
    ) -> DocumentOnTypeFormattingOptions &
    {
        if (this != &other) {
            firstTriggerCharacter = std::move(other.firstTriggerCharacter);
            moreTriggerCharacter = std::move(other.moreTriggerCharacter);
        }
        return *this;
    }

    auto DocumentOnTypeFormattingOptions::operator=(
        const DocumentOnTypeFormattingOptions &other
    ) -> DocumentOnTypeFormattingOptions &
    {
        if (this != &other) {
            firstTriggerCharacter = other.firstTriggerCharacter;
            if (other.moreTriggerCharacter.has_value()) {
                auto &array_0 = moreTriggerCharacter.emplace();
                const auto &array_1 = other.moreTriggerCharacter.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    SemanticTokensLegend::SemanticTokensLegend()
    {
        // empty
    }

    SemanticTokensLegend::SemanticTokensLegend(SemanticTokensLegend &&other)
        : tokenTypes(std::move(other.tokenTypes))
        , tokenModifiers(std::move(other.tokenModifiers))
    {
        // empty
    }

    SemanticTokensLegend::SemanticTokensLegend(
        const SemanticTokensLegend &other
    )
    {
        tokenTypes = other.tokenTypes;
        tokenModifiers = other.tokenModifiers;
    }

    SemanticTokensLegend::~SemanticTokensLegend()
    {
        // empty
    }

    auto SemanticTokensLegend::operator=(
        SemanticTokensLegend &&other
    ) -> SemanticTokensLegend &
    {
        if (this != &other) {
            tokenTypes = std::move(other.tokenTypes);
            tokenModifiers = std::move(other.tokenModifiers);
        }
        return *this;
    }

    auto SemanticTokensLegend::operator=(
        const SemanticTokensLegend &other
    ) -> SemanticTokensLegend &
    {
        if (this != &other) {
            tokenTypes = other.tokenTypes;
            tokenModifiers = other.tokenModifiers;
        }
        return *this;
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem::NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem()
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem::NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem(
        NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &&other
    )
        : language(std::move(other.language))
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem::NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &other
    )
        : language(other.language)
    {
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem::~NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem()
    {
        // empty
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &&other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &
    {
        if (this != &other) {
            language = std::move(other.language);
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &
    {
        if (this != &other) {
            language = other.language;
        }
        return *this;
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem::NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem()
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem::NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem(
        NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &&other
    )
        : language(std::move(other.language))
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem::NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &other
    )
        : language(other.language)
    {
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem::~NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem()
    {
        // empty
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &&other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &
    {
        if (this != &other) {
            language = std::move(other.language);
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &
    {
        if (this != &other) {
            language = other.language;
        }
        return *this;
    }

    const std::map<ParameterInformation_documentationType, std::string>
    ParameterInformation_documentationTypeNames = {
        {ParameterInformation_documentationType::Uninitialized,
         "Uninitialized"},
        {ParameterInformation_documentationType::String, "String"},
        {ParameterInformation_documentationType::MarkupContent,
         "MarkupContent"},
    };

    ParameterInformation_documentation::ParameterInformation_documentation()
    {
        // empty
    }

    ParameterInformation_documentation::~ParameterInformation_documentation()
    {
        reset();
    }

    ParameterInformation_documentation::ParameterInformation_documentation(
        ParameterInformation_documentation &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ParameterInformation_documentationType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case ParameterInformation_documentationType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::move(other._markupContent)
            };
            break;
        }
        case ParameterInformation_documentationType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ParameterInformation_documentationType::Uninitialized;
    }

    ParameterInformation_documentation::ParameterInformation_documentation(
        const ParameterInformation_documentation &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ParameterInformation_documentationType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case ParameterInformation_documentationType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::make_unique<MarkupContent>(*other._markupContent)
            };
            break;
        }
        case ParameterInformation_documentationType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ParameterInformation_documentation::operator=(
        ParameterInformation_documentation &&other
    ) -> ParameterInformation_documentation &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ParameterInformation_documentationType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case ParameterInformation_documentationType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::move(other._markupContent)
                };
                break;
            }
            case ParameterInformation_documentationType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ParameterInformation_documentationType::Uninitialized;
        }
        return *this;
    }

    auto ParameterInformation_documentation::operator=(
        const ParameterInformation_documentation &other
    ) -> ParameterInformation_documentation &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ParameterInformation_documentationType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case ParameterInformation_documentationType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::make_unique<MarkupContent>(*other._markupContent)
                };
                break;
            }
            case ParameterInformation_documentationType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ParameterInformation_documentation::reset() -> void
    {
        switch (_type) {
        case ParameterInformation_documentationType::Uninitialized: {
            // nothing to do
            break;
        }
        case ParameterInformation_documentationType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = ParameterInformation_documentationType::Uninitialized;
            break;
        }
        case ParameterInformation_documentationType::MarkupContent: {
#ifdef DEBUG
            if (!_markupContent) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markupContent"
                );
            }
#endif // DEBUG
            _markupContent.~unique_ptr<MarkupContent>();
            _type = ParameterInformation_documentationType::Uninitialized;
            break;
        }
        default: {
            _type = ParameterInformation_documentationType::Uninitialized;
        }
        }
    }

    auto ParameterInformation_documentation::type() const
    -> const ParameterInformation_documentationType &
    {
        return _type;
    }

    auto ParameterInformation_documentation::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != ParameterInformation_documentationType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "ParameterInformation_documentation::string()"
                 " of type "
                 "ParameterInformation_documentationType::String"
                 " while active type is "
                 "ParameterInformation_documentationType::" +
                 ParameterInformation_documentationTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto ParameterInformation_documentation::operator=(
        const std::unique_ptr<string_t> &string
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = ParameterInformation_documentationType::String;
        return *this;
    }

    auto ParameterInformation_documentation::operator=(
        std::unique_ptr<string_t> &&string
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = ParameterInformation_documentationType::String;
        return *this;
    }

    auto ParameterInformation_documentation::operator=(
        const string_t &string
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = ParameterInformation_documentationType::String;
        return *this;
    }

    auto ParameterInformation_documentation::operator=(
        string_t &&string
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = ParameterInformation_documentationType::String;
        return *this;
    }

    auto ParameterInformation_documentation::markupContent() const
    -> const MarkupContent &
    {
#ifdef DEBUG
        if (_type != ParameterInformation_documentationType::MarkupContent) {
            throw std::logic_error(
                ("Attempted to access "
                 "ParameterInformation_documentation::markupContent()"
                 " of type "
                 "ParameterInformation_documentationType::MarkupContent"
                 " while active type is "
                 "ParameterInformation_documentationType::" +
                 ParameterInformation_documentationTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markupContent;
    }

    auto ParameterInformation_documentation::operator=(
        const std::unique_ptr<MarkupContent> &markupContent
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(*markupContent)
        };
        _type = ParameterInformation_documentationType::MarkupContent;
        return *this;
    }

    auto ParameterInformation_documentation::operator=(
        std::unique_ptr<MarkupContent> &&markupContent
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::move(markupContent)
        };
        _type = ParameterInformation_documentationType::MarkupContent;
        return *this;
    }

    auto ParameterInformation_documentation::operator=(
        const MarkupContent &markupContent
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(markupContent)
        };
        _type = ParameterInformation_documentationType::MarkupContent;
        return *this;
    }

    auto ParameterInformation_documentation::operator=(
        MarkupContent &&markupContent
    ) -> ParameterInformation_documentation &
    {
        if (_type != ParameterInformation_documentationType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(std::move(markupContent))
        };
        _type = ParameterInformation_documentationType::MarkupContent;
        return *this;
    }

    const std::map<RelativePattern_baseUriType, std::string>
    RelativePattern_baseUriTypeNames = {
        {RelativePattern_baseUriType::Uninitialized, "Uninitialized"},
        {RelativePattern_baseUriType::WorkspaceFolder, "WorkspaceFolder"},
        {RelativePattern_baseUriType::String, "String"},
    };

    RelativePattern_baseUri::RelativePattern_baseUri()
    {
        // empty
    }

    RelativePattern_baseUri::~RelativePattern_baseUri()
    {
        reset();
    }

    RelativePattern_baseUri::RelativePattern_baseUri(
        RelativePattern_baseUri &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case RelativePattern_baseUriType::WorkspaceFolder: {
            new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
                std::move(other._workspaceFolder)
            };
            break;
        }
        case RelativePattern_baseUriType::String: {
            new (&_uri) std::unique_ptr<URI> {
                std::move(other._uri)
            };
            break;
        }
        case RelativePattern_baseUriType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = RelativePattern_baseUriType::Uninitialized;
    }

    RelativePattern_baseUri::RelativePattern_baseUri(
        const RelativePattern_baseUri &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case RelativePattern_baseUriType::WorkspaceFolder: {
            new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
                std::make_unique<WorkspaceFolder>(*other._workspaceFolder)
            };
            break;
        }
        case RelativePattern_baseUriType::String: {
            new (&_uri) std::unique_ptr<URI> {
                std::make_unique<URI>(*other._uri)
            };
            break;
        }
        case RelativePattern_baseUriType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto RelativePattern_baseUri::operator=(
        RelativePattern_baseUri &&other
    ) -> RelativePattern_baseUri &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case RelativePattern_baseUriType::WorkspaceFolder: {
                new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
                    std::move(other._workspaceFolder)
                };
                break;
            }
            case RelativePattern_baseUriType::String: {
                new (&_uri) std::unique_ptr<URI> {
                    std::move(other._uri)
                };
                break;
            }
            case RelativePattern_baseUriType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = RelativePattern_baseUriType::Uninitialized;
        }
        return *this;
    }

    auto RelativePattern_baseUri::operator=(
        const RelativePattern_baseUri &other
    ) -> RelativePattern_baseUri &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case RelativePattern_baseUriType::WorkspaceFolder: {
                new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
                    std::make_unique<WorkspaceFolder>(*other._workspaceFolder)
                };
                break;
            }
            case RelativePattern_baseUriType::String: {
                new (&_uri) std::unique_ptr<URI> {
                    std::make_unique<URI>(*other._uri)
                };
                break;
            }
            case RelativePattern_baseUriType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto RelativePattern_baseUri::reset() -> void
    {
        switch (_type) {
        case RelativePattern_baseUriType::Uninitialized: {
            // nothing to do
            break;
        }
        case RelativePattern_baseUriType::WorkspaceFolder: {
#ifdef DEBUG
            if (!_workspaceFolder) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _workspaceFolder"
                );
            }
#endif // DEBUG
            _workspaceFolder.~unique_ptr<WorkspaceFolder>();
            _type = RelativePattern_baseUriType::Uninitialized;
            break;
        }
        case RelativePattern_baseUriType::String: {
#ifdef DEBUG
            if (!_uri) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _uri"
                );
            }
#endif // DEBUG
            _uri.~unique_ptr<URI>();
            _type = RelativePattern_baseUriType::Uninitialized;
            break;
        }
        default: {
            _type = RelativePattern_baseUriType::Uninitialized;
        }
        }
    }

    auto RelativePattern_baseUri::type() const
    -> const RelativePattern_baseUriType &
    {
        return _type;
    }

    auto RelativePattern_baseUri::workspaceFolder() const
    -> const WorkspaceFolder &
    {
#ifdef DEBUG
        if (_type != RelativePattern_baseUriType::WorkspaceFolder) {
            throw std::logic_error(
                ("Attempted to access "
                 "RelativePattern_baseUri::workspaceFolder()"
                 " of type "
                 "RelativePattern_baseUriType::WorkspaceFolder"
                 " while active type is "
                 "RelativePattern_baseUriType::" +
                 RelativePattern_baseUriTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_workspaceFolder;
    }

    auto RelativePattern_baseUri::operator=(
        const std::unique_ptr<WorkspaceFolder> &workspaceFolder
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!workspaceFolder) {
            throw std::logic_error(
                "null passed as the value of workspaceFolder"
            );
        }
#endif // DEBUG
        new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
            std::make_unique<WorkspaceFolder>(*workspaceFolder)
        };
        _type = RelativePattern_baseUriType::WorkspaceFolder;
        return *this;
    }

    auto RelativePattern_baseUri::operator=(
        std::unique_ptr<WorkspaceFolder> &&workspaceFolder
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!workspaceFolder) {
            throw std::logic_error(
                "null passed as the value of workspaceFolder"
            );
        }
#endif // DEBUG
        new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
            std::move(workspaceFolder)
        };
        _type = RelativePattern_baseUriType::WorkspaceFolder;
        return *this;
    }

    auto RelativePattern_baseUri::operator=(
        const WorkspaceFolder &workspaceFolder
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
        new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
            std::make_unique<WorkspaceFolder>(workspaceFolder)
        };
        _type = RelativePattern_baseUriType::WorkspaceFolder;
        return *this;
    }

    auto RelativePattern_baseUri::operator=(
        WorkspaceFolder &&workspaceFolder
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
        new (&_workspaceFolder) std::unique_ptr<WorkspaceFolder> {
            std::make_unique<WorkspaceFolder>(std::move(workspaceFolder))
        };
        _type = RelativePattern_baseUriType::WorkspaceFolder;
        return *this;
    }

    auto RelativePattern_baseUri::uri() const -> const URI &
    {
#ifdef DEBUG
        if (_type != RelativePattern_baseUriType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "RelativePattern_baseUri::uri()"
                 " of type "
                 "RelativePattern_baseUriType::String"
                 " while active type is "
                 "RelativePattern_baseUriType::" +
                 RelativePattern_baseUriTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_uri;
    }

    auto RelativePattern_baseUri::operator=(
        const std::unique_ptr<URI> &uri
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!uri) {
            throw std::logic_error("null passed as the value of uri");
        }
#endif // DEBUG
        new (&_uri) std::unique_ptr<URI> {
            std::make_unique<URI>(*uri)
        };
        _type = RelativePattern_baseUriType::String;
        return *this;
    }

    auto RelativePattern_baseUri::operator=(
        std::unique_ptr<URI> &&uri
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!uri) {
            throw std::logic_error("null passed as the value of uri");
        }
#endif // DEBUG
        new (&_uri) std::unique_ptr<URI> {
            std::move(uri)
        };
        _type = RelativePattern_baseUriType::String;
        return *this;
    }

    auto RelativePattern_baseUri::operator=(
        const URI &uri
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
        new (&_uri) std::unique_ptr<URI> {
            std::make_unique<URI>(uri)
        };
        _type = RelativePattern_baseUriType::String;
        return *this;
    }

    auto RelativePattern_baseUri::operator=(
        URI &&uri
    ) -> RelativePattern_baseUri &
    {
        if (_type != RelativePattern_baseUriType::Uninitialized) {
            reset();
        }
        new (&_uri) std::unique_ptr<URI> {
            std::make_unique<URI>(std::move(uri))
        };
        _type = RelativePattern_baseUriType::String;
        return *this;
    }

    WorkspaceSymbolClientCapabilities_resolveSupport::WorkspaceSymbolClientCapabilities_resolveSupport()
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities_resolveSupport::WorkspaceSymbolClientCapabilities_resolveSupport(
        WorkspaceSymbolClientCapabilities_resolveSupport &&other
    )
        : properties(std::move(other.properties))
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities_resolveSupport::WorkspaceSymbolClientCapabilities_resolveSupport(
        const WorkspaceSymbolClientCapabilities_resolveSupport &other
    )
    {
        properties = other.properties;
    }

    WorkspaceSymbolClientCapabilities_resolveSupport::~WorkspaceSymbolClientCapabilities_resolveSupport()
    {
        // empty
    }

    auto WorkspaceSymbolClientCapabilities_resolveSupport::operator=(
        WorkspaceSymbolClientCapabilities_resolveSupport &&other
    ) -> WorkspaceSymbolClientCapabilities_resolveSupport &
    {
        if (this != &other) {
            properties = std::move(other.properties);
        }
        return *this;
    }

    auto WorkspaceSymbolClientCapabilities_resolveSupport::operator=(
        const WorkspaceSymbolClientCapabilities_resolveSupport &other
    ) -> WorkspaceSymbolClientCapabilities_resolveSupport &
    {
        if (this != &other) {
            properties = other.properties;
        }
        return *this;
    }

    CompletionClientCapabilities_completionItem_resolveSupport::CompletionClientCapabilities_completionItem_resolveSupport()
    {
        // empty
    }

    CompletionClientCapabilities_completionItem_resolveSupport::CompletionClientCapabilities_completionItem_resolveSupport(
        CompletionClientCapabilities_completionItem_resolveSupport &&other
    )
        : properties(std::move(other.properties))
    {
        // empty
    }

    CompletionClientCapabilities_completionItem_resolveSupport::CompletionClientCapabilities_completionItem_resolveSupport(
        const CompletionClientCapabilities_completionItem_resolveSupport &other
    )
    {
        properties = other.properties;
    }

    CompletionClientCapabilities_completionItem_resolveSupport::~CompletionClientCapabilities_completionItem_resolveSupport()
    {
        // empty
    }

    auto CompletionClientCapabilities_completionItem_resolveSupport::operator=(
        CompletionClientCapabilities_completionItem_resolveSupport &&other
    ) -> CompletionClientCapabilities_completionItem_resolveSupport &
    {
        if (this != &other) {
            properties = std::move(other.properties);
        }
        return *this;
    }

    auto CompletionClientCapabilities_completionItem_resolveSupport::operator=(
        const CompletionClientCapabilities_completionItem_resolveSupport &other
    ) -> CompletionClientCapabilities_completionItem_resolveSupport &
    {
        if (this != &other) {
            properties = other.properties;
        }
        return *this;
    }

    CompletionClientCapabilities_completionList::CompletionClientCapabilities_completionList()
    {
        // empty
    }

    CompletionClientCapabilities_completionList::CompletionClientCapabilities_completionList(
        CompletionClientCapabilities_completionList &&other
    )
        : itemDefaults(std::move(other.itemDefaults))
    {
        // empty
    }

    CompletionClientCapabilities_completionList::CompletionClientCapabilities_completionList(
        const CompletionClientCapabilities_completionList &other
    )
    {
        if (other.itemDefaults.has_value()) {
            auto &array_0 = itemDefaults.emplace();
            const auto &array_1 = other.itemDefaults.value();
            array_0 = array_1;
        }
    }

    CompletionClientCapabilities_completionList::~CompletionClientCapabilities_completionList()
    {
        // empty
    }

    auto CompletionClientCapabilities_completionList::operator=(
        CompletionClientCapabilities_completionList &&other
    ) -> CompletionClientCapabilities_completionList &
    {
        if (this != &other) {
            itemDefaults = std::move(other.itemDefaults);
        }
        return *this;
    }

    auto CompletionClientCapabilities_completionList::operator=(
        const CompletionClientCapabilities_completionList &other
    ) -> CompletionClientCapabilities_completionList &
    {
        if (this != &other) {
            if (other.itemDefaults.has_value()) {
                auto &array_0 = itemDefaults.emplace();
                const auto &array_1 = other.itemDefaults.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    CodeActionClientCapabilities_resolveSupport::CodeActionClientCapabilities_resolveSupport()
    {
        // empty
    }

    CodeActionClientCapabilities_resolveSupport::CodeActionClientCapabilities_resolveSupport(
        CodeActionClientCapabilities_resolveSupport &&other
    )
        : properties(std::move(other.properties))
    {
        // empty
    }

    CodeActionClientCapabilities_resolveSupport::CodeActionClientCapabilities_resolveSupport(
        const CodeActionClientCapabilities_resolveSupport &other
    )
    {
        properties = other.properties;
    }

    CodeActionClientCapabilities_resolveSupport::~CodeActionClientCapabilities_resolveSupport()
    {
        // empty
    }

    auto CodeActionClientCapabilities_resolveSupport::operator=(
        CodeActionClientCapabilities_resolveSupport &&other
    ) -> CodeActionClientCapabilities_resolveSupport &
    {
        if (this != &other) {
            properties = std::move(other.properties);
        }
        return *this;
    }

    auto CodeActionClientCapabilities_resolveSupport::operator=(
        const CodeActionClientCapabilities_resolveSupport &other
    ) -> CodeActionClientCapabilities_resolveSupport &
    {
        if (this != &other) {
            properties = other.properties;
        }
        return *this;
    }

    InlayHintClientCapabilities_resolveSupport::InlayHintClientCapabilities_resolveSupport()
    {
        // empty
    }

    InlayHintClientCapabilities_resolveSupport::InlayHintClientCapabilities_resolveSupport(
        InlayHintClientCapabilities_resolveSupport &&other
    )
        : properties(std::move(other.properties))
    {
        // empty
    }

    InlayHintClientCapabilities_resolveSupport::InlayHintClientCapabilities_resolveSupport(
        const InlayHintClientCapabilities_resolveSupport &other
    )
    {
        properties = other.properties;
    }

    InlayHintClientCapabilities_resolveSupport::~InlayHintClientCapabilities_resolveSupport()
    {
        // empty
    }

    auto InlayHintClientCapabilities_resolveSupport::operator=(
        InlayHintClientCapabilities_resolveSupport &&other
    ) -> InlayHintClientCapabilities_resolveSupport &
    {
        if (this != &other) {
            properties = std::move(other.properties);
        }
        return *this;
    }

    auto InlayHintClientCapabilities_resolveSupport::operator=(
        const InlayHintClientCapabilities_resolveSupport &other
    ) -> InlayHintClientCapabilities_resolveSupport &
    {
        if (this != &other) {
            properties = other.properties;
        }
        return *this;
    }

    RegularExpressionsClientCapabilities::RegularExpressionsClientCapabilities()
    {
        // empty
    }

    RegularExpressionsClientCapabilities::RegularExpressionsClientCapabilities(
        RegularExpressionsClientCapabilities &&other
    )
        : engine(std::move(other.engine))
        , version(std::move(other.version))
    {
        // empty
    }

    RegularExpressionsClientCapabilities::RegularExpressionsClientCapabilities(
        const RegularExpressionsClientCapabilities &other
    )
        : engine(other.engine)
    {
        if (other.version.has_value()) {
            version = other.version.value();
        }
    }

    RegularExpressionsClientCapabilities::~RegularExpressionsClientCapabilities()
    {
        // empty
    }

    auto RegularExpressionsClientCapabilities::operator=(
        RegularExpressionsClientCapabilities &&other
    ) -> RegularExpressionsClientCapabilities &
    {
        if (this != &other) {
            engine = std::move(other.engine);
            version = std::move(other.version);
        }
        return *this;
    }

    auto RegularExpressionsClientCapabilities::operator=(
        const RegularExpressionsClientCapabilities &other
    ) -> RegularExpressionsClientCapabilities &
    {
        if (this != &other) {
            engine = other.engine;
            if (other.version.has_value()) {
                version = other.version.value();
            }
        }
        return *this;
    }

    MarkdownClientCapabilities::MarkdownClientCapabilities()
    {
        // empty
    }

    MarkdownClientCapabilities::MarkdownClientCapabilities(
        MarkdownClientCapabilities &&other
    )
        : parser(std::move(other.parser))
        , version(std::move(other.version))
        , allowedTags(std::move(other.allowedTags))
    {
        // empty
    }

    MarkdownClientCapabilities::MarkdownClientCapabilities(
        const MarkdownClientCapabilities &other
    )
        : parser(other.parser)
    {
        if (other.version.has_value()) {
            version = other.version.value();
        }
        if (other.allowedTags.has_value()) {
            auto &array_0 = allowedTags.emplace();
            const auto &array_1 = other.allowedTags.value();
            array_0 = array_1;
        }
    }

    MarkdownClientCapabilities::~MarkdownClientCapabilities()
    {
        // empty
    }

    auto MarkdownClientCapabilities::operator=(
        MarkdownClientCapabilities &&other
    ) -> MarkdownClientCapabilities &
    {
        if (this != &other) {
            parser = std::move(other.parser);
            version = std::move(other.version);
            allowedTags = std::move(other.allowedTags);
        }
        return *this;
    }

    auto MarkdownClientCapabilities::operator=(
        const MarkdownClientCapabilities &other
    ) -> MarkdownClientCapabilities &
    {
        if (this != &other) {
            parser = other.parser;
            if (other.version.has_value()) {
                version = other.version.value();
            }
            if (other.allowedTags.has_value()) {
                auto &array_0 = allowedTags.emplace();
                const auto &array_1 = other.allowedTags.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    Message::Message()
    {
        // empty
    }

    Message::Message(Message &&other)
        : jsonrpc(std::move(other.jsonrpc))
    {
        // empty
    }

    Message::Message(const Message &other)
        : jsonrpc(other.jsonrpc)
    {
    }

    Message::~Message()
    {
        // empty
    }

    auto Message::operator=(Message &&other) -> Message &
    {
        if (this != &other) {
            jsonrpc = std::move(other.jsonrpc);
        }
        return *this;
    }

    auto Message::operator=(const Message &other) -> Message &
    {
        if (this != &other) {
            jsonrpc = other.jsonrpc;
        }
        return *this;
    }

    DocumentParams::DocumentParams()
    {
        // empty
    }

    DocumentParams::DocumentParams(DocumentParams &&other)
        : uri(std::move(other.uri))
    {
        // empty
    }

    DocumentParams::DocumentParams(const DocumentParams &other)
        : uri(other.uri)
    {
    }

    DocumentParams::~DocumentParams()
    {
        // empty
    }

    auto DocumentParams::operator=(DocumentParams &&other) -> DocumentParams &
    {
        if (this != &other) {
            uri = std::move(other.uri);
        }
        return *this;
    }

    auto DocumentParams::operator=(
        const DocumentParams &other
    ) -> DocumentParams &
    {
        if (this != &other) {
            uri = other.uri;
        }
        return *this;
    }

    ResourceOperation::ResourceOperation()
    {
        // empty
    }

    ResourceOperation::ResourceOperation(ResourceOperation &&other)
        : kind(std::move(other.kind))
        , annotationId(std::move(other.annotationId))
    {
        // empty
    }

    ResourceOperation::ResourceOperation(const ResourceOperation &other)
        : kind(other.kind)
    {
        if (other.annotationId.has_value()) {
            annotationId = other.annotationId.value();
        }
    }

    ResourceOperation::~ResourceOperation()
    {
        // empty
    }

    auto ResourceOperation::operator=(
        ResourceOperation &&other
    ) -> ResourceOperation &
    {
        if (this != &other) {
            kind = std::move(other.kind);
            annotationId = std::move(other.annotationId);
        }
        return *this;
    }

    auto ResourceOperation::operator=(
        const ResourceOperation &other
    ) -> ResourceOperation &
    {
        if (this != &other) {
            kind = other.kind;
            if (other.annotationId.has_value()) {
                annotationId = other.annotationId.value();
            }
        }
        return *this;
    }

    TextDocumentContentChangeEvent_1::TextDocumentContentChangeEvent_1()
    {
        // empty
    }

    TextDocumentContentChangeEvent_1::TextDocumentContentChangeEvent_1(
        TextDocumentContentChangeEvent_1 &&other
    )
        : text(std::move(other.text))
    {
        // empty
    }

    TextDocumentContentChangeEvent_1::TextDocumentContentChangeEvent_1(
        const TextDocumentContentChangeEvent_1 &other
    )
        : text(other.text)
    {
    }

    TextDocumentContentChangeEvent_1::~TextDocumentContentChangeEvent_1()
    {
        // empty
    }

    auto TextDocumentContentChangeEvent_1::operator=(
        TextDocumentContentChangeEvent_1 &&other
    ) -> TextDocumentContentChangeEvent_1 &
    {
        if (this != &other) {
            text = std::move(other.text);
        }
        return *this;
    }

    auto TextDocumentContentChangeEvent_1::operator=(
        const TextDocumentContentChangeEvent_1 &other
    ) -> TextDocumentContentChangeEvent_1 &
    {
        if (this != &other) {
            text = other.text;
        }
        return *this;
    }

    MarkedString_1::MarkedString_1()
    {
        // empty
    }

    MarkedString_1::MarkedString_1(MarkedString_1 &&other)
        : language(std::move(other.language))
        , value(std::move(other.value))
    {
        // empty
    }

    MarkedString_1::MarkedString_1(const MarkedString_1 &other)
        : language(other.language)
        , value(other.value)
    {
    }

    MarkedString_1::~MarkedString_1()
    {
        // empty
    }

    auto MarkedString_1::operator=(MarkedString_1 &&other) -> MarkedString_1 &
    {
        if (this != &other) {
            language = std::move(other.language);
            value = std::move(other.value);
        }
        return *this;
    }

    auto MarkedString_1::operator=(
        const MarkedString_1 &other
    ) -> MarkedString_1 &
    {
        if (this != &other) {
            language = other.language;
            value = other.value;
        }
        return *this;
    }

    const std::map<MarkedStringType, std::string> MarkedStringTypeNames = {
        {MarkedStringType::Uninitialized, "Uninitialized"},
        {MarkedStringType::String, "String"},
        {MarkedStringType::MarkedString_1, "MarkedString_1"},
    };

    MarkedString::MarkedString()
    {
        // empty
    }

    MarkedString::~MarkedString()
    {
        reset();
    }

    MarkedString::MarkedString(MarkedString &&other)
        : _type(other._type)
    {
        switch (other._type) {
        case MarkedStringType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case MarkedStringType::MarkedString_1: {
            new (&_markedString_1) std::unique_ptr<MarkedString_1> {
                std::move(other._markedString_1)
            };
            break;
        }
        case MarkedStringType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = MarkedStringType::Uninitialized;
    }

    MarkedString::MarkedString(const MarkedString &other)
        : _type(other._type)
    {
        switch (other._type) {
        case MarkedStringType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case MarkedStringType::MarkedString_1: {
            new (&_markedString_1) std::unique_ptr<MarkedString_1> {
                std::make_unique<MarkedString_1>(*other._markedString_1)
            };
            break;
        }
        case MarkedStringType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto MarkedString::operator=(MarkedString &&other) -> MarkedString &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case MarkedStringType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case MarkedStringType::MarkedString_1: {
                new (&_markedString_1) std::unique_ptr<MarkedString_1> {
                    std::move(other._markedString_1)
                };
                break;
            }
            case MarkedStringType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = MarkedStringType::Uninitialized;
        }
        return *this;
    }

    auto MarkedString::operator=(const MarkedString &other) -> MarkedString &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case MarkedStringType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case MarkedStringType::MarkedString_1: {
                new (&_markedString_1) std::unique_ptr<MarkedString_1> {
                    std::make_unique<MarkedString_1>(*other._markedString_1)
                };
                break;
            }
            case MarkedStringType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto MarkedString::reset() -> void
    {
        switch (_type) {
        case MarkedStringType::Uninitialized: {
            // nothing to do
            break;
        }
        case MarkedStringType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = MarkedStringType::Uninitialized;
            break;
        }
        case MarkedStringType::MarkedString_1: {
#ifdef DEBUG
            if (!_markedString_1) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markedString_1"
                );
            }
#endif // DEBUG
            _markedString_1.~unique_ptr<MarkedString_1>();
            _type = MarkedStringType::Uninitialized;
            break;
        }
        default: {
            _type = MarkedStringType::Uninitialized;
        }
        }
    }

    auto MarkedString::type() const -> const MarkedStringType &
    {
        return _type;
    }

    auto MarkedString::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != MarkedStringType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "MarkedString::string()"
                 " of type "
                 "MarkedStringType::String"
                 " while active type is "
                 "MarkedStringType::" +
                 MarkedStringTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto MarkedString::operator=(
        const std::unique_ptr<string_t> &string
    ) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = MarkedStringType::String;
        return *this;
    }

    auto MarkedString::operator=(
        std::unique_ptr<string_t> &&string
    ) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = MarkedStringType::String;
        return *this;
    }

    auto MarkedString::operator=(const string_t &string) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = MarkedStringType::String;
        return *this;
    }

    auto MarkedString::operator=(string_t &&string) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = MarkedStringType::String;
        return *this;
    }

    auto MarkedString::markedString_1() const -> const MarkedString_1 &
    {
#ifdef DEBUG
        if (_type != MarkedStringType::MarkedString_1) {
            throw std::logic_error(
                ("Attempted to access "
                 "MarkedString::markedString_1()"
                 " of type "
                 "MarkedStringType::MarkedString_1"
                 " while active type is "
                 "MarkedStringType::" +
                 MarkedStringTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markedString_1;
    }

    auto MarkedString::operator=(
        const std::unique_ptr<MarkedString_1> &markedString_1
    ) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markedString_1) {
            throw std::logic_error(
                "null passed as the value of markedString_1"
            );
        }
#endif // DEBUG
        new (&_markedString_1) std::unique_ptr<MarkedString_1> {
            std::make_unique<MarkedString_1>(*markedString_1)
        };
        _type = MarkedStringType::MarkedString_1;
        return *this;
    }

    auto MarkedString::operator=(
        std::unique_ptr<MarkedString_1> &&markedString_1
    ) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markedString_1) {
            throw std::logic_error(
                "null passed as the value of markedString_1"
            );
        }
#endif // DEBUG
        new (&_markedString_1) std::unique_ptr<MarkedString_1> {
            std::move(markedString_1)
        };
        _type = MarkedStringType::MarkedString_1;
        return *this;
    }

    auto MarkedString::operator=(
        const MarkedString_1 &markedString_1
    ) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
        new (&_markedString_1) std::unique_ptr<MarkedString_1> {
            std::make_unique<MarkedString_1>(markedString_1)
        };
        _type = MarkedStringType::MarkedString_1;
        return *this;
    }

    auto MarkedString::operator=(
        MarkedString_1 &&markedString_1
    ) -> MarkedString &
    {
        if (_type != MarkedStringType::Uninitialized) {
            reset();
        }
        new (&_markedString_1) std::unique_ptr<MarkedString_1> {
            std::make_unique<MarkedString_1>(std::move(markedString_1))
        };
        _type = MarkedStringType::MarkedString_1;
        return *this;
    }

    const std::map<Hover_contentsType, std::string> Hover_contentsTypeNames = {
        {Hover_contentsType::Uninitialized, "Uninitialized"},
        {Hover_contentsType::MarkupContent, "MarkupContent"},
        {Hover_contentsType::MarkedString, "MarkedString"},
        {Hover_contentsType::MarkedStringArray, "MarkedStringArray"},
    };

    Hover_contents::Hover_contents()
    {
        // empty
    }

    Hover_contents::~Hover_contents()
    {
        reset();
    }

    Hover_contents::Hover_contents(Hover_contents &&other)
        : _type(other._type)
    {
        switch (other._type) {
        case Hover_contentsType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::move(other._markupContent)
            };
            break;
        }
        case Hover_contentsType::MarkedString: {
            new (&_markedString) std::unique_ptr<MarkedString> {
                std::move(other._markedString)
            };
            break;
        }
        case Hover_contentsType::MarkedStringArray: {
            new (&_markedStringArray) std::unique_ptr<Hover_contents_2> {
                std::move(other._markedStringArray)
            };
            break;
        }
        case Hover_contentsType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = Hover_contentsType::Uninitialized;
    }

    Hover_contents::Hover_contents(const Hover_contents &other)
        : _type(other._type)
    {
        switch (other._type) {
        case Hover_contentsType::MarkupContent: {
            new (&_markupContent) std::unique_ptr<MarkupContent> {
                std::make_unique<MarkupContent>(*other._markupContent)
            };
            break;
        }
        case Hover_contentsType::MarkedString: {
            new (&_markedString) std::unique_ptr<MarkedString> {
                std::make_unique<MarkedString>(*other._markedString)
            };
            break;
        }
        case Hover_contentsType::MarkedStringArray: {
            _markedStringArray =
                std::make_unique<std::vector<MarkedString>>(*other._markedStringArray);
            break;
        }
        case Hover_contentsType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto Hover_contents::operator=(Hover_contents &&other) -> Hover_contents &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case Hover_contentsType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::move(other._markupContent)
                };
                break;
            }
            case Hover_contentsType::MarkedString: {
                new (&_markedString) std::unique_ptr<MarkedString> {
                    std::move(other._markedString)
                };
                break;
            }
            case Hover_contentsType::MarkedStringArray: {
                new (&_markedStringArray) std::unique_ptr<Hover_contents_2> {
                    std::move(other._markedStringArray)
                };
                break;
            }
            case Hover_contentsType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = Hover_contentsType::Uninitialized;
        }
        return *this;
    }

    auto Hover_contents::operator=(
        const Hover_contents &other
    ) -> Hover_contents &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case Hover_contentsType::MarkupContent: {
                new (&_markupContent) std::unique_ptr<MarkupContent> {
                    std::make_unique<MarkupContent>(*other._markupContent)
                };
                break;
            }
            case Hover_contentsType::MarkedString: {
                new (&_markedString) std::unique_ptr<MarkedString> {
                    std::make_unique<MarkedString>(*other._markedString)
                };
                break;
            }
            case Hover_contentsType::MarkedStringArray: {
                _markedStringArray =
                    std::make_unique<std::vector<MarkedString>>(*other._markedStringArray);
                break;
            }
            case Hover_contentsType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto Hover_contents::reset() -> void
    {
        switch (_type) {
        case Hover_contentsType::Uninitialized: {
            // nothing to do
            break;
        }
        case Hover_contentsType::MarkupContent: {
#ifdef DEBUG
            if (!_markupContent) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markupContent"
                );
            }
#endif // DEBUG
            _markupContent.~unique_ptr<MarkupContent>();
            _type = Hover_contentsType::Uninitialized;
            break;
        }
        case Hover_contentsType::MarkedString: {
#ifdef DEBUG
            if (!_markedString) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markedString"
                );
            }
#endif // DEBUG
            _markedString.~unique_ptr<MarkedString>();
            _type = Hover_contentsType::Uninitialized;
            break;
        }
        case Hover_contentsType::MarkedStringArray: {
#ifdef DEBUG
            if (!_markedStringArray) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _markedStringArray"
                );
            }
#endif // DEBUG
            _markedStringArray.~unique_ptr<std::vector<MarkedString>>();
            _type = Hover_contentsType::Uninitialized;
            break;
        }
        default: {
            _type = Hover_contentsType::Uninitialized;
        }
        }
    }

    auto Hover_contents::type() const -> const Hover_contentsType &
    {
        return _type;
    }

    auto Hover_contents::markupContent() const -> const MarkupContent &
    {
#ifdef DEBUG
        if (_type != Hover_contentsType::MarkupContent) {
            throw std::logic_error(
                ("Attempted to access "
                 "Hover_contents::markupContent()"
                 " of type "
                 "Hover_contentsType::MarkupContent"
                 " while active type is "
                 "Hover_contentsType::" +
                 Hover_contentsTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markupContent;
    }

    auto Hover_contents::operator=(
        const std::unique_ptr<MarkupContent> &markupContent
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(*markupContent)
        };
        _type = Hover_contentsType::MarkupContent;
        return *this;
    }

    auto Hover_contents::operator=(
        std::unique_ptr<MarkupContent> &&markupContent
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markupContent) {
            throw std::logic_error(
                "null passed as the value of markupContent"
            );
        }
#endif // DEBUG
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::move(markupContent)
        };
        _type = Hover_contentsType::MarkupContent;
        return *this;
    }

    auto Hover_contents::operator=(
        const MarkupContent &markupContent
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(markupContent)
        };
        _type = Hover_contentsType::MarkupContent;
        return *this;
    }

    auto Hover_contents::operator=(
        MarkupContent &&markupContent
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
        new (&_markupContent) std::unique_ptr<MarkupContent> {
            std::make_unique<MarkupContent>(std::move(markupContent))
        };
        _type = Hover_contentsType::MarkupContent;
        return *this;
    }

    auto Hover_contents::markedString() const -> const MarkedString &
    {
#ifdef DEBUG
        if (_type != Hover_contentsType::MarkedString) {
            throw std::logic_error(
                ("Attempted to access "
                 "Hover_contents::markedString()"
                 " of type "
                 "Hover_contentsType::MarkedString"
                 " while active type is "
                 "Hover_contentsType::" +
                 Hover_contentsTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markedString;
    }

    auto Hover_contents::operator=(
        const std::unique_ptr<MarkedString> &markedString
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markedString) {
            throw std::logic_error("null passed as the value of markedString");
        }
#endif // DEBUG
        new (&_markedString) std::unique_ptr<MarkedString> {
            std::make_unique<MarkedString>(*markedString)
        };
        _type = Hover_contentsType::MarkedString;
        return *this;
    }

    auto Hover_contents::operator=(
        std::unique_ptr<MarkedString> &&markedString
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markedString) {
            throw std::logic_error("null passed as the value of markedString");
        }
#endif // DEBUG
        new (&_markedString) std::unique_ptr<MarkedString> {
            std::move(markedString)
        };
        _type = Hover_contentsType::MarkedString;
        return *this;
    }

    auto Hover_contents::operator=(
        const MarkedString &markedString
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
        new (&_markedString) std::unique_ptr<MarkedString> {
            std::make_unique<MarkedString>(markedString)
        };
        _type = Hover_contentsType::MarkedString;
        return *this;
    }

    auto Hover_contents::operator=(
        MarkedString &&markedString
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
        new (&_markedString) std::unique_ptr<MarkedString> {
            std::make_unique<MarkedString>(std::move(markedString))
        };
        _type = Hover_contentsType::MarkedString;
        return *this;
    }

    auto Hover_contents::markedStringArray() const
    -> const std::vector<MarkedString> &
    {
#ifdef DEBUG
        if (_type != Hover_contentsType::MarkedStringArray) {
            throw std::logic_error(
                ("Attempted to access "
                 "Hover_contents::markedStringArray()"
                 " of type "
                 "Hover_contentsType::MarkedStringArray"
                 " while active type is "
                 "Hover_contentsType::" +
                 Hover_contentsTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_markedStringArray;
    }

    auto Hover_contents::operator=(
        const std::unique_ptr<std::vector<MarkedString>> &markedStringArray
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markedStringArray) {
            throw std::logic_error(
                "null passed as the value of markedStringArray"
            );
        }
#endif // DEBUG
        _markedStringArray =
            std::make_unique<std::vector<MarkedString>>(*markedStringArray);
        _type = Hover_contentsType::MarkedStringArray;
        return *this;
    }

    auto Hover_contents::operator=(
        std::unique_ptr<std::vector<MarkedString>> &&markedStringArray
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!markedStringArray) {
            throw std::logic_error(
                "null passed as the value of markedStringArray"
            );
        }
#endif // DEBUG
        new (&_markedStringArray) std::unique_ptr<Hover_contents_2> {
            std::move(markedStringArray)
        };
        _type = Hover_contentsType::MarkedStringArray;
        return *this;
    }

    auto Hover_contents::operator=(
        const std::vector<MarkedString> &markedStringArray
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
        _markedStringArray =
            std::make_unique<std::vector<MarkedString>>(markedStringArray);
        _type = Hover_contentsType::MarkedStringArray;
        return *this;
    }

    auto Hover_contents::operator=(
        std::vector<MarkedString> &&markedStringArray
    ) -> Hover_contents &
    {
        if (_type != Hover_contentsType::Uninitialized) {
            reset();
        }
        new (&_markedStringArray) std::unique_ptr<Hover_contents_2> {
            std::make_unique<Hover_contents_2>(std::move(markedStringArray))
        };
        _type = Hover_contentsType::MarkedStringArray;
        return *this;
    }

    TextDocumentFilter_0::TextDocumentFilter_0()
    {
        // empty
    }

    TextDocumentFilter_0::TextDocumentFilter_0(TextDocumentFilter_0 &&other)
        : language(std::move(other.language))
        , scheme(std::move(other.scheme))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    TextDocumentFilter_0::TextDocumentFilter_0(
        const TextDocumentFilter_0 &other
    )
        : language(other.language)
    {
        if (other.scheme.has_value()) {
            scheme = other.scheme.value();
        }
        if (other.pattern.has_value()) {
            pattern = other.pattern.value();
        }
    }

    TextDocumentFilter_0::~TextDocumentFilter_0()
    {
        // empty
    }

    auto TextDocumentFilter_0::operator=(
        TextDocumentFilter_0 &&other
    ) -> TextDocumentFilter_0 &
    {
        if (this != &other) {
            language = std::move(other.language);
            scheme = std::move(other.scheme);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto TextDocumentFilter_0::operator=(
        const TextDocumentFilter_0 &other
    ) -> TextDocumentFilter_0 &
    {
        if (this != &other) {
            language = other.language;
            if (other.scheme.has_value()) {
                scheme = other.scheme.value();
            }
            if (other.pattern.has_value()) {
                pattern = other.pattern.value();
            }
        }
        return *this;
    }

    TextDocumentFilter_1::TextDocumentFilter_1()
    {
        // empty
    }

    TextDocumentFilter_1::TextDocumentFilter_1(TextDocumentFilter_1 &&other)
        : language(std::move(other.language))
        , scheme(std::move(other.scheme))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    TextDocumentFilter_1::TextDocumentFilter_1(
        const TextDocumentFilter_1 &other
    )
        : scheme(other.scheme)
    {
        if (other.language.has_value()) {
            language = other.language.value();
        }
        if (other.pattern.has_value()) {
            pattern = other.pattern.value();
        }
    }

    TextDocumentFilter_1::~TextDocumentFilter_1()
    {
        // empty
    }

    auto TextDocumentFilter_1::operator=(
        TextDocumentFilter_1 &&other
    ) -> TextDocumentFilter_1 &
    {
        if (this != &other) {
            language = std::move(other.language);
            scheme = std::move(other.scheme);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto TextDocumentFilter_1::operator=(
        const TextDocumentFilter_1 &other
    ) -> TextDocumentFilter_1 &
    {
        if (this != &other) {
            if (other.language.has_value()) {
                language = other.language.value();
            }
            scheme = other.scheme;
            if (other.pattern.has_value()) {
                pattern = other.pattern.value();
            }
        }
        return *this;
    }

    TextDocumentFilter_2::TextDocumentFilter_2()
    {
        // empty
    }

    TextDocumentFilter_2::TextDocumentFilter_2(TextDocumentFilter_2 &&other)
        : language(std::move(other.language))
        , scheme(std::move(other.scheme))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    TextDocumentFilter_2::TextDocumentFilter_2(
        const TextDocumentFilter_2 &other
    )
        : pattern(other.pattern)
    {
        if (other.language.has_value()) {
            language = other.language.value();
        }
        if (other.scheme.has_value()) {
            scheme = other.scheme.value();
        }
    }

    TextDocumentFilter_2::~TextDocumentFilter_2()
    {
        // empty
    }

    auto TextDocumentFilter_2::operator=(
        TextDocumentFilter_2 &&other
    ) -> TextDocumentFilter_2 &
    {
        if (this != &other) {
            language = std::move(other.language);
            scheme = std::move(other.scheme);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto TextDocumentFilter_2::operator=(
        const TextDocumentFilter_2 &other
    ) -> TextDocumentFilter_2 &
    {
        if (this != &other) {
            if (other.language.has_value()) {
                language = other.language.value();
            }
            if (other.scheme.has_value()) {
                scheme = other.scheme.value();
            }
            pattern = other.pattern;
        }
        return *this;
    }

    const std::map<TextDocumentFilterType, std::string>
    TextDocumentFilterTypeNames = {
        {TextDocumentFilterType::Uninitialized, "Uninitialized"},
        {TextDocumentFilterType::TextDocumentFilter_0, "TextDocumentFilter_0"},
        {TextDocumentFilterType::TextDocumentFilter_1, "TextDocumentFilter_1"},
        {TextDocumentFilterType::TextDocumentFilter_2, "TextDocumentFilter_2"},
    };

    TextDocumentFilter::TextDocumentFilter()
    {
        // empty
    }

    TextDocumentFilter::~TextDocumentFilter()
    {
        reset();
    }

    TextDocumentFilter::TextDocumentFilter(TextDocumentFilter &&other)
        : _type(other._type)
    {
        switch (other._type) {
        case TextDocumentFilterType::TextDocumentFilter_0: {
            new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
                std::move(other._textDocumentFilter_0)
            };
            break;
        }
        case TextDocumentFilterType::TextDocumentFilter_1: {
            new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
                std::move(other._textDocumentFilter_1)
            };
            break;
        }
        case TextDocumentFilterType::TextDocumentFilter_2: {
            new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
                std::move(other._textDocumentFilter_2)
            };
            break;
        }
        case TextDocumentFilterType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = TextDocumentFilterType::Uninitialized;
    }

    TextDocumentFilter::TextDocumentFilter(const TextDocumentFilter &other)
        : _type(other._type)
    {
        switch (other._type) {
        case TextDocumentFilterType::TextDocumentFilter_0: {
            new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
                std::make_unique<TextDocumentFilter_0>(*other._textDocumentFilter_0)
            };
            break;
        }
        case TextDocumentFilterType::TextDocumentFilter_1: {
            new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
                std::make_unique<TextDocumentFilter_1>(*other._textDocumentFilter_1)
            };
            break;
        }
        case TextDocumentFilterType::TextDocumentFilter_2: {
            new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
                std::make_unique<TextDocumentFilter_2>(*other._textDocumentFilter_2)
            };
            break;
        }
        case TextDocumentFilterType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto TextDocumentFilter::operator=(
        TextDocumentFilter &&other
    ) -> TextDocumentFilter &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case TextDocumentFilterType::TextDocumentFilter_0: {
                new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
                    std::move(other._textDocumentFilter_0)
                };
                break;
            }
            case TextDocumentFilterType::TextDocumentFilter_1: {
                new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
                    std::move(other._textDocumentFilter_1)
                };
                break;
            }
            case TextDocumentFilterType::TextDocumentFilter_2: {
                new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
                    std::move(other._textDocumentFilter_2)
                };
                break;
            }
            case TextDocumentFilterType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = TextDocumentFilterType::Uninitialized;
        }
        return *this;
    }

    auto TextDocumentFilter::operator=(
        const TextDocumentFilter &other
    ) -> TextDocumentFilter &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case TextDocumentFilterType::TextDocumentFilter_0: {
                new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
                    std::make_unique<TextDocumentFilter_0>(*other._textDocumentFilter_0)
                };
                break;
            }
            case TextDocumentFilterType::TextDocumentFilter_1: {
                new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
                    std::make_unique<TextDocumentFilter_1>(*other._textDocumentFilter_1)
                };
                break;
            }
            case TextDocumentFilterType::TextDocumentFilter_2: {
                new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
                    std::make_unique<TextDocumentFilter_2>(*other._textDocumentFilter_2)
                };
                break;
            }
            case TextDocumentFilterType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto TextDocumentFilter::reset() -> void
    {
        switch (_type) {
        case TextDocumentFilterType::Uninitialized: {
            // nothing to do
            break;
        }
        case TextDocumentFilterType::TextDocumentFilter_0: {
#ifdef DEBUG
            if (!_textDocumentFilter_0) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _textDocumentFilter_0"
                );
            }
#endif // DEBUG
            _textDocumentFilter_0.~unique_ptr<TextDocumentFilter_0>();
            _type = TextDocumentFilterType::Uninitialized;
            break;
        }
        case TextDocumentFilterType::TextDocumentFilter_1: {
#ifdef DEBUG
            if (!_textDocumentFilter_1) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _textDocumentFilter_1"
                );
            }
#endif // DEBUG
            _textDocumentFilter_1.~unique_ptr<TextDocumentFilter_1>();
            _type = TextDocumentFilterType::Uninitialized;
            break;
        }
        case TextDocumentFilterType::TextDocumentFilter_2: {
#ifdef DEBUG
            if (!_textDocumentFilter_2) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _textDocumentFilter_2"
                );
            }
#endif // DEBUG
            _textDocumentFilter_2.~unique_ptr<TextDocumentFilter_2>();
            _type = TextDocumentFilterType::Uninitialized;
            break;
        }
        default: {
            _type = TextDocumentFilterType::Uninitialized;
        }
        }
    }

    auto TextDocumentFilter::type() const -> const TextDocumentFilterType &
    {
        return _type;
    }

    auto TextDocumentFilter::textDocumentFilter_0() const
    -> const TextDocumentFilter_0 &
    {
#ifdef DEBUG
        if (_type != TextDocumentFilterType::TextDocumentFilter_0) {
            throw std::logic_error(
                ("Attempted to access "
                 "TextDocumentFilter::textDocumentFilter_0()"
                 " of type "
                 "TextDocumentFilterType::TextDocumentFilter_0"
                 " while active type is "
                 "TextDocumentFilterType::" +
                 TextDocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_textDocumentFilter_0;
    }

    auto TextDocumentFilter::operator=(
        const std::unique_ptr<TextDocumentFilter_0> &textDocumentFilter_0
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter_0) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter_0"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
            std::make_unique<TextDocumentFilter_0>(*textDocumentFilter_0)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_0;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        std::unique_ptr<TextDocumentFilter_0> &&textDocumentFilter_0
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter_0) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter_0"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
            std::move(textDocumentFilter_0)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_0;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        const TextDocumentFilter_0 &textDocumentFilter_0
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
            std::make_unique<TextDocumentFilter_0>(textDocumentFilter_0)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_0;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        TextDocumentFilter_0 &&textDocumentFilter_0
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter_0) std::unique_ptr<TextDocumentFilter_0> {
            std::make_unique<TextDocumentFilter_0>(std::move(textDocumentFilter_0))
        };
        _type = TextDocumentFilterType::TextDocumentFilter_0;
        return *this;
    }

    auto TextDocumentFilter::textDocumentFilter_1() const
    -> const TextDocumentFilter_1 &
    {
#ifdef DEBUG
        if (_type != TextDocumentFilterType::TextDocumentFilter_1) {
            throw std::logic_error(
                ("Attempted to access "
                 "TextDocumentFilter::textDocumentFilter_1()"
                 " of type "
                 "TextDocumentFilterType::TextDocumentFilter_1"
                 " while active type is "
                 "TextDocumentFilterType::" +
                 TextDocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_textDocumentFilter_1;
    }

    auto TextDocumentFilter::operator=(
        const std::unique_ptr<TextDocumentFilter_1> &textDocumentFilter_1
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter_1) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter_1"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
            std::make_unique<TextDocumentFilter_1>(*textDocumentFilter_1)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_1;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        std::unique_ptr<TextDocumentFilter_1> &&textDocumentFilter_1
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter_1) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter_1"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
            std::move(textDocumentFilter_1)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_1;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        const TextDocumentFilter_1 &textDocumentFilter_1
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
            std::make_unique<TextDocumentFilter_1>(textDocumentFilter_1)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_1;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        TextDocumentFilter_1 &&textDocumentFilter_1
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter_1) std::unique_ptr<TextDocumentFilter_1> {
            std::make_unique<TextDocumentFilter_1>(std::move(textDocumentFilter_1))
        };
        _type = TextDocumentFilterType::TextDocumentFilter_1;
        return *this;
    }

    auto TextDocumentFilter::textDocumentFilter_2() const
    -> const TextDocumentFilter_2 &
    {
#ifdef DEBUG
        if (_type != TextDocumentFilterType::TextDocumentFilter_2) {
            throw std::logic_error(
                ("Attempted to access "
                 "TextDocumentFilter::textDocumentFilter_2()"
                 " of type "
                 "TextDocumentFilterType::TextDocumentFilter_2"
                 " while active type is "
                 "TextDocumentFilterType::" +
                 TextDocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_textDocumentFilter_2;
    }

    auto TextDocumentFilter::operator=(
        const std::unique_ptr<TextDocumentFilter_2> &textDocumentFilter_2
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter_2) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter_2"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
            std::make_unique<TextDocumentFilter_2>(*textDocumentFilter_2)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_2;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        std::unique_ptr<TextDocumentFilter_2> &&textDocumentFilter_2
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter_2) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter_2"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
            std::move(textDocumentFilter_2)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_2;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        const TextDocumentFilter_2 &textDocumentFilter_2
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
            std::make_unique<TextDocumentFilter_2>(textDocumentFilter_2)
        };
        _type = TextDocumentFilterType::TextDocumentFilter_2;
        return *this;
    }

    auto TextDocumentFilter::operator=(
        TextDocumentFilter_2 &&textDocumentFilter_2
    ) -> TextDocumentFilter &
    {
        if (_type != TextDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter_2) std::unique_ptr<TextDocumentFilter_2> {
            std::make_unique<TextDocumentFilter_2>(std::move(textDocumentFilter_2))
        };
        _type = TextDocumentFilterType::TextDocumentFilter_2;
        return *this;
    }

    NotebookDocumentFilter_0::NotebookDocumentFilter_0()
    {
        // empty
    }

    NotebookDocumentFilter_0::NotebookDocumentFilter_0(
        NotebookDocumentFilter_0 &&other
    )
        : notebookType(std::move(other.notebookType))
        , scheme(std::move(other.scheme))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    NotebookDocumentFilter_0::NotebookDocumentFilter_0(
        const NotebookDocumentFilter_0 &other
    )
        : notebookType(other.notebookType)
    {
        if (other.scheme.has_value()) {
            scheme = other.scheme.value();
        }
        if (other.pattern.has_value()) {
            pattern = other.pattern.value();
        }
    }

    NotebookDocumentFilter_0::~NotebookDocumentFilter_0()
    {
        // empty
    }

    auto NotebookDocumentFilter_0::operator=(
        NotebookDocumentFilter_0 &&other
    ) -> NotebookDocumentFilter_0 &
    {
        if (this != &other) {
            notebookType = std::move(other.notebookType);
            scheme = std::move(other.scheme);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto NotebookDocumentFilter_0::operator=(
        const NotebookDocumentFilter_0 &other
    ) -> NotebookDocumentFilter_0 &
    {
        if (this != &other) {
            notebookType = other.notebookType;
            if (other.scheme.has_value()) {
                scheme = other.scheme.value();
            }
            if (other.pattern.has_value()) {
                pattern = other.pattern.value();
            }
        }
        return *this;
    }

    NotebookDocumentFilter_1::NotebookDocumentFilter_1()
    {
        // empty
    }

    NotebookDocumentFilter_1::NotebookDocumentFilter_1(
        NotebookDocumentFilter_1 &&other
    )
        : notebookType(std::move(other.notebookType))
        , scheme(std::move(other.scheme))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    NotebookDocumentFilter_1::NotebookDocumentFilter_1(
        const NotebookDocumentFilter_1 &other
    )
        : scheme(other.scheme)
    {
        if (other.notebookType.has_value()) {
            notebookType = other.notebookType.value();
        }
        if (other.pattern.has_value()) {
            pattern = other.pattern.value();
        }
    }

    NotebookDocumentFilter_1::~NotebookDocumentFilter_1()
    {
        // empty
    }

    auto NotebookDocumentFilter_1::operator=(
        NotebookDocumentFilter_1 &&other
    ) -> NotebookDocumentFilter_1 &
    {
        if (this != &other) {
            notebookType = std::move(other.notebookType);
            scheme = std::move(other.scheme);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto NotebookDocumentFilter_1::operator=(
        const NotebookDocumentFilter_1 &other
    ) -> NotebookDocumentFilter_1 &
    {
        if (this != &other) {
            if (other.notebookType.has_value()) {
                notebookType = other.notebookType.value();
            }
            scheme = other.scheme;
            if (other.pattern.has_value()) {
                pattern = other.pattern.value();
            }
        }
        return *this;
    }

    NotebookDocumentFilter_2::NotebookDocumentFilter_2()
    {
        // empty
    }

    NotebookDocumentFilter_2::NotebookDocumentFilter_2(
        NotebookDocumentFilter_2 &&other
    )
        : notebookType(std::move(other.notebookType))
        , scheme(std::move(other.scheme))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    NotebookDocumentFilter_2::NotebookDocumentFilter_2(
        const NotebookDocumentFilter_2 &other
    )
        : pattern(other.pattern)
    {
        if (other.notebookType.has_value()) {
            notebookType = other.notebookType.value();
        }
        if (other.scheme.has_value()) {
            scheme = other.scheme.value();
        }
    }

    NotebookDocumentFilter_2::~NotebookDocumentFilter_2()
    {
        // empty
    }

    auto NotebookDocumentFilter_2::operator=(
        NotebookDocumentFilter_2 &&other
    ) -> NotebookDocumentFilter_2 &
    {
        if (this != &other) {
            notebookType = std::move(other.notebookType);
            scheme = std::move(other.scheme);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto NotebookDocumentFilter_2::operator=(
        const NotebookDocumentFilter_2 &other
    ) -> NotebookDocumentFilter_2 &
    {
        if (this != &other) {
            if (other.notebookType.has_value()) {
                notebookType = other.notebookType.value();
            }
            if (other.scheme.has_value()) {
                scheme = other.scheme.value();
            }
            pattern = other.pattern;
        }
        return *this;
    }

    const std::map<NotebookDocumentFilterType, std::string>
    NotebookDocumentFilterTypeNames = {
        {NotebookDocumentFilterType::Uninitialized, "Uninitialized"},
        {NotebookDocumentFilterType::NotebookDocumentFilter_0,
         "NotebookDocumentFilter_0"},
        {NotebookDocumentFilterType::NotebookDocumentFilter_1,
         "NotebookDocumentFilter_1"},
        {NotebookDocumentFilterType::NotebookDocumentFilter_2,
         "NotebookDocumentFilter_2"},
    };

    NotebookDocumentFilter::NotebookDocumentFilter()
    {
        // empty
    }

    NotebookDocumentFilter::~NotebookDocumentFilter()
    {
        reset();
    }

    NotebookDocumentFilter::NotebookDocumentFilter(
        NotebookDocumentFilter &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentFilterType::NotebookDocumentFilter_0: {
            new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
                std::move(other._notebookDocumentFilter_0)
            };
            break;
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_1: {
            new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
                std::move(other._notebookDocumentFilter_1)
            };
            break;
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_2: {
            new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
                std::move(other._notebookDocumentFilter_2)
            };
            break;
        }
        case NotebookDocumentFilterType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = NotebookDocumentFilterType::Uninitialized;
    }

    NotebookDocumentFilter::NotebookDocumentFilter(
        const NotebookDocumentFilter &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentFilterType::NotebookDocumentFilter_0: {
            new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
                std::make_unique<NotebookDocumentFilter_0>(*other._notebookDocumentFilter_0)
            };
            break;
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_1: {
            new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
                std::make_unique<NotebookDocumentFilter_1>(*other._notebookDocumentFilter_1)
            };
            break;
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_2: {
            new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
                std::make_unique<NotebookDocumentFilter_2>(*other._notebookDocumentFilter_2)
            };
            break;
        }
        case NotebookDocumentFilterType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto NotebookDocumentFilter::operator=(
        NotebookDocumentFilter &&other
    ) -> NotebookDocumentFilter &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentFilterType::NotebookDocumentFilter_0: {
                new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
                    std::move(other._notebookDocumentFilter_0)
                };
                break;
            }
            case NotebookDocumentFilterType::NotebookDocumentFilter_1: {
                new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
                    std::move(other._notebookDocumentFilter_1)
                };
                break;
            }
            case NotebookDocumentFilterType::NotebookDocumentFilter_2: {
                new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
                    std::move(other._notebookDocumentFilter_2)
                };
                break;
            }
            case NotebookDocumentFilterType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = NotebookDocumentFilterType::Uninitialized;
        }
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        const NotebookDocumentFilter &other
    ) -> NotebookDocumentFilter &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentFilterType::NotebookDocumentFilter_0: {
                new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
                    std::make_unique<NotebookDocumentFilter_0>(*other._notebookDocumentFilter_0)
                };
                break;
            }
            case NotebookDocumentFilterType::NotebookDocumentFilter_1: {
                new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
                    std::make_unique<NotebookDocumentFilter_1>(*other._notebookDocumentFilter_1)
                };
                break;
            }
            case NotebookDocumentFilterType::NotebookDocumentFilter_2: {
                new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
                    std::make_unique<NotebookDocumentFilter_2>(*other._notebookDocumentFilter_2)
                };
                break;
            }
            case NotebookDocumentFilterType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto NotebookDocumentFilter::reset() -> void
    {
        switch (_type) {
        case NotebookDocumentFilterType::Uninitialized: {
            // nothing to do
            break;
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_0: {
#ifdef DEBUG
            if (!_notebookDocumentFilter_0) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentFilter_0"
                );
            }
#endif // DEBUG
            _notebookDocumentFilter_0.~unique_ptr<NotebookDocumentFilter_0>();
            _type = NotebookDocumentFilterType::Uninitialized;
            break;
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_1: {
#ifdef DEBUG
            if (!_notebookDocumentFilter_1) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentFilter_1"
                );
            }
#endif // DEBUG
            _notebookDocumentFilter_1.~unique_ptr<NotebookDocumentFilter_1>();
            _type = NotebookDocumentFilterType::Uninitialized;
            break;
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_2: {
#ifdef DEBUG
            if (!_notebookDocumentFilter_2) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentFilter_2"
                );
            }
#endif // DEBUG
            _notebookDocumentFilter_2.~unique_ptr<NotebookDocumentFilter_2>();
            _type = NotebookDocumentFilterType::Uninitialized;
            break;
        }
        default: {
            _type = NotebookDocumentFilterType::Uninitialized;
        }
        }
    }

    auto NotebookDocumentFilter::type() const
    -> const NotebookDocumentFilterType &
    {
        return _type;
    }

    auto NotebookDocumentFilter::notebookDocumentFilter_0() const
    -> const NotebookDocumentFilter_0 &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentFilterType::NotebookDocumentFilter_0) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentFilter::notebookDocumentFilter_0()"
                 " of type "
                 "NotebookDocumentFilterType::NotebookDocumentFilter_0"
                 " while active type is "
                 "NotebookDocumentFilterType::" +
                 NotebookDocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentFilter_0;
    }

    auto NotebookDocumentFilter::operator=(
        const std::unique_ptr<NotebookDocumentFilter_0> &notebookDocumentFilter_0
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter_0) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter_0"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
            std::make_unique<NotebookDocumentFilter_0>(*notebookDocumentFilter_0)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_0;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        std::unique_ptr<NotebookDocumentFilter_0> &&notebookDocumentFilter_0
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter_0) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter_0"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
            std::move(notebookDocumentFilter_0)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_0;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        const NotebookDocumentFilter_0 &notebookDocumentFilter_0
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
            std::make_unique<NotebookDocumentFilter_0>(notebookDocumentFilter_0)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_0;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        NotebookDocumentFilter_0 &&notebookDocumentFilter_0
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter_0) std::unique_ptr<NotebookDocumentFilter_0> {
            std::make_unique<NotebookDocumentFilter_0>(std::move(notebookDocumentFilter_0))
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_0;
        return *this;
    }

    auto NotebookDocumentFilter::notebookDocumentFilter_1() const
    -> const NotebookDocumentFilter_1 &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentFilterType::NotebookDocumentFilter_1) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentFilter::notebookDocumentFilter_1()"
                 " of type "
                 "NotebookDocumentFilterType::NotebookDocumentFilter_1"
                 " while active type is "
                 "NotebookDocumentFilterType::" +
                 NotebookDocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentFilter_1;
    }

    auto NotebookDocumentFilter::operator=(
        const std::unique_ptr<NotebookDocumentFilter_1> &notebookDocumentFilter_1
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter_1) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter_1"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
            std::make_unique<NotebookDocumentFilter_1>(*notebookDocumentFilter_1)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_1;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        std::unique_ptr<NotebookDocumentFilter_1> &&notebookDocumentFilter_1
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter_1) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter_1"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
            std::move(notebookDocumentFilter_1)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_1;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        const NotebookDocumentFilter_1 &notebookDocumentFilter_1
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
            std::make_unique<NotebookDocumentFilter_1>(notebookDocumentFilter_1)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_1;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        NotebookDocumentFilter_1 &&notebookDocumentFilter_1
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter_1) std::unique_ptr<NotebookDocumentFilter_1> {
            std::make_unique<NotebookDocumentFilter_1>(std::move(notebookDocumentFilter_1))
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_1;
        return *this;
    }

    auto NotebookDocumentFilter::notebookDocumentFilter_2() const
    -> const NotebookDocumentFilter_2 &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentFilterType::NotebookDocumentFilter_2) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentFilter::notebookDocumentFilter_2()"
                 " of type "
                 "NotebookDocumentFilterType::NotebookDocumentFilter_2"
                 " while active type is "
                 "NotebookDocumentFilterType::" +
                 NotebookDocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentFilter_2;
    }

    auto NotebookDocumentFilter::operator=(
        const std::unique_ptr<NotebookDocumentFilter_2> &notebookDocumentFilter_2
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter_2) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter_2"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
            std::make_unique<NotebookDocumentFilter_2>(*notebookDocumentFilter_2)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_2;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        std::unique_ptr<NotebookDocumentFilter_2> &&notebookDocumentFilter_2
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter_2) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter_2"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
            std::move(notebookDocumentFilter_2)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_2;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        const NotebookDocumentFilter_2 &notebookDocumentFilter_2
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
            std::make_unique<NotebookDocumentFilter_2>(notebookDocumentFilter_2)
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_2;
        return *this;
    }

    auto NotebookDocumentFilter::operator=(
        NotebookDocumentFilter_2 &&notebookDocumentFilter_2
    ) -> NotebookDocumentFilter &
    {
        if (_type != NotebookDocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter_2) std::unique_ptr<NotebookDocumentFilter_2> {
            std::make_unique<NotebookDocumentFilter_2>(std::move(notebookDocumentFilter_2))
        };
        _type = NotebookDocumentFilterType::NotebookDocumentFilter_2;
        return *this;
    }

    const std::map<
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType,
        std::string
    > NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookTypeNames = {
        {NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized,
         "Uninitialized"},
        {NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String,
         "String"},
        {NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter,
         "NotebookDocumentFilter"},
    };

    NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook()
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::~NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook()
    {
        reset();
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter: {
            new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                std::move(other._notebookDocumentFilter)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized;
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter: {
            new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                std::make_unique<NotebookDocumentFilter>(*other._notebookDocumentFilter)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &&other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter: {
                new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                    std::move(other._notebookDocumentFilter)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized;
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter: {
                new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                    std::make_unique<NotebookDocumentFilter>(*other._notebookDocumentFilter)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::reset()
    -> void
    {
        switch (_type) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized: {
            // nothing to do
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type =
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized;
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter: {
#ifdef DEBUG
            if (!_notebookDocumentFilter) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentFilter"
                );
            }
#endif // DEBUG
            _notebookDocumentFilter.~unique_ptr<NotebookDocumentFilter>();
            _type =
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized;
            break;
        }
        default: {
            _type = NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized;
        }
        }
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::type() const
    -> const NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType &
    {
        return _type;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::string() const
    -> const string_t &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::string()"
                 " of type "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String"
                 " while active type is "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::" +
                 NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        const std::unique_ptr<string_t> &string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        std::unique_ptr<string_t> &&string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        const string_t &string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        string_t &&string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::notebookDocumentFilter() const
    -> const NotebookDocumentFilter &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::notebookDocumentFilter()"
                 " of type "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter"
                 " while active type is "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::" +
                 NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentFilter;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        const std::unique_ptr<NotebookDocumentFilter> &notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(*notebookDocumentFilter)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        std::unique_ptr<NotebookDocumentFilter> &&notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::move(notebookDocumentFilter)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        const NotebookDocumentFilter &notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(notebookDocumentFilter)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook::operator=(
        NotebookDocumentFilter &&notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(std::move(notebookDocumentFilter))
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter;
        return *this;
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0::NotebookDocumentSyncOptions_notebookSelector_elem_0()
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0::NotebookDocumentSyncOptions_notebookSelector_elem_0(
        NotebookDocumentSyncOptions_notebookSelector_elem_0 &&other
    )
        : notebook(std::move(other.notebook))
        , cells(std::move(other.cells))
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0::NotebookDocumentSyncOptions_notebookSelector_elem_0(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0 &other
    )
        : notebook(NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(other.notebook))
    {
        if (other.cells.has_value()) {
            auto &array_0 = cells.emplace();
            const auto &array_1 = other.cells.value();
            array_0.reserve(array_1.size());
            for (const auto &elem_0 : array_1) {
                array_0.push_back(elem_0);
            }
        }
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_0::~NotebookDocumentSyncOptions_notebookSelector_elem_0()
    {
        // empty
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_0 &&other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0 &
    {
        if (this != &other) {
            notebook = std::move(other.notebook);
            cells = std::move(other.cells);
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_0::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0 &other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0 &
    {
        if (this != &other) {
            notebook =
                NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(other.notebook);
            if (other.cells.has_value()) {
                auto &array_0 = cells.emplace();
                const auto &array_1 = other.cells.value();
                array_0.reserve(array_1.size());
                for (const auto &elem_0 : array_1) {
                    array_0.push_back(elem_0);
                }
            }
        }
        return *this;
    }

    const std::map<
        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType,
        std::string
    > NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookTypeNames = {
        {NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized,
         "Uninitialized"},
        {NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String,
         "String"},
        {NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter,
         "NotebookDocumentFilter"},
    };

    NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook()
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::~NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook()
    {
        reset();
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook(
        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter: {
            new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                std::move(other._notebookDocumentFilter)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized;
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter: {
            new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                std::make_unique<NotebookDocumentFilter>(*other._notebookDocumentFilter)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &&other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter: {
                new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                    std::move(other._notebookDocumentFilter)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized;
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter: {
                new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                    std::make_unique<NotebookDocumentFilter>(*other._notebookDocumentFilter)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::reset()
    -> void
    {
        switch (_type) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized: {
            // nothing to do
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type =
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized;
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter: {
#ifdef DEBUG
            if (!_notebookDocumentFilter) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentFilter"
                );
            }
#endif // DEBUG
            _notebookDocumentFilter.~unique_ptr<NotebookDocumentFilter>();
            _type =
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized;
            break;
        }
        default: {
            _type = NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized;
        }
        }
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::type() const
    -> const NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType &
    {
        return _type;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::string() const
    -> const string_t &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::string()"
                 " of type "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String"
                 " while active type is "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::" +
                 NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        const std::unique_ptr<string_t> &string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        std::unique_ptr<string_t> &&string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        const string_t &string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        string_t &&string
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::notebookDocumentFilter() const
    -> const NotebookDocumentFilter &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::notebookDocumentFilter()"
                 " of type "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter"
                 " while active type is "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::" +
                 NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentFilter;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        const std::unique_ptr<NotebookDocumentFilter> &notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(*notebookDocumentFilter)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        std::unique_ptr<NotebookDocumentFilter> &&notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::move(notebookDocumentFilter)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        const NotebookDocumentFilter &notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(notebookDocumentFilter)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook::operator=(
        NotebookDocumentFilter &&notebookDocumentFilter
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(std::move(notebookDocumentFilter))
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter;
        return *this;
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1::NotebookDocumentSyncOptions_notebookSelector_elem_1()
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1::NotebookDocumentSyncOptions_notebookSelector_elem_1(
        NotebookDocumentSyncOptions_notebookSelector_elem_1 &&other
    )
        : notebook(std::move(other.notebook))
        , cells(std::move(other.cells))
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1::NotebookDocumentSyncOptions_notebookSelector_elem_1(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1 &other
    )
    {
        if (other.notebook.has_value()) {
            notebook = other.notebook.value();
        }
        cells.reserve(other.cells.size());
        for (const auto &elem_0 : other.cells) {
            cells.push_back(elem_0);
        }
    }

    NotebookDocumentSyncOptions_notebookSelector_elem_1::~NotebookDocumentSyncOptions_notebookSelector_elem_1()
    {
        // empty
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_1 &&other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1 &
    {
        if (this != &other) {
            notebook = std::move(other.notebook);
            cells = std::move(other.cells);
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem_1::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1 &other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1 &
    {
        if (this != &other) {
            if (other.notebook.has_value()) {
                notebook = other.notebook.value();
            }
            cells.reserve(other.cells.size());
            for (const auto &elem_0 : other.cells) {
                cells.push_back(elem_0);
            }
        }
        return *this;
    }

    const std::map<
        NotebookDocumentSyncOptions_notebookSelector_elemType,
        std::string
    > NotebookDocumentSyncOptions_notebookSelector_elemTypeNames = {
        {NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized,
         "Uninitialized"},
        {NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0,
         "NotebookDocumentSyncOptions_notebookSelector_elem_0"},
        {NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1,
         "NotebookDocumentSyncOptions_notebookSelector_elem_1"},
    };

    NotebookDocumentSyncOptions_notebookSelector_elem::NotebookDocumentSyncOptions_notebookSelector_elem()
    {
        // empty
    }

    NotebookDocumentSyncOptions_notebookSelector_elem::~NotebookDocumentSyncOptions_notebookSelector_elem()
    {
        reset();
    }

    NotebookDocumentSyncOptions_notebookSelector_elem::NotebookDocumentSyncOptions_notebookSelector_elem(
        NotebookDocumentSyncOptions_notebookSelector_elem &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0: {
            new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
                std::move(other._notebookDocumentSyncOptions_notebookSelector_elem_0)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1: {
            new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
                std::move(other._notebookDocumentSyncOptions_notebookSelector_elem_1)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized;
    }

    NotebookDocumentSyncOptions_notebookSelector_elem::NotebookDocumentSyncOptions_notebookSelector_elem(
        const NotebookDocumentSyncOptions_notebookSelector_elem &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0: {
            new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
                std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_0>(*other._notebookDocumentSyncOptions_notebookSelector_elem_0)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1: {
            new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
                std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_1>(*other._notebookDocumentSyncOptions_notebookSelector_elem_1)
            };
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem &&other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0: {
                new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
                    std::move(other._notebookDocumentSyncOptions_notebookSelector_elem_0)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1: {
                new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
                    std::move(other._notebookDocumentSyncOptions_notebookSelector_elem_1)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized;
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem &other
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0: {
                new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
                    std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_0>(*other._notebookDocumentSyncOptions_notebookSelector_elem_0)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1: {
                new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
                    std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_1>(*other._notebookDocumentSyncOptions_notebookSelector_elem_1)
                };
                break;
            }
            case NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::reset() -> void
    {
        switch (_type) {
        case NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized: {
            // nothing to do
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0: {
#ifdef DEBUG
            if (!_notebookDocumentSyncOptions_notebookSelector_elem_0) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentSyncOptions_notebookSelector_elem_0"
                );
            }
#endif // DEBUG
            _notebookDocumentSyncOptions_notebookSelector_elem_0.~unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0>();
            _type =
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized;
            break;
        }
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1: {
#ifdef DEBUG
            if (!_notebookDocumentSyncOptions_notebookSelector_elem_1) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentSyncOptions_notebookSelector_elem_1"
                );
            }
#endif // DEBUG
            _notebookDocumentSyncOptions_notebookSelector_elem_1.~unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1>();
            _type =
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized;
            break;
        }
        default: {
            _type = NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized;
        }
        }
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::type() const
    -> const NotebookDocumentSyncOptions_notebookSelector_elemType &
    {
        return _type;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::notebookDocumentSyncOptions_notebookSelector_elem_0() const
    -> const NotebookDocumentSyncOptions_notebookSelector_elem_0 &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentSyncOptions_notebookSelector_elem::notebookDocumentSyncOptions_notebookSelector_elem_0()"
                 " of type "
                 "NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0"
                 " while active type is "
                 "NotebookDocumentSyncOptions_notebookSelector_elemType::" +
                 NotebookDocumentSyncOptions_notebookSelector_elemTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentSyncOptions_notebookSelector_elem_0;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        const std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> &notebookDocumentSyncOptions_notebookSelector_elem_0
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncOptions_notebookSelector_elem_0) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncOptions_notebookSelector_elem_0"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
            std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_0>(*notebookDocumentSyncOptions_notebookSelector_elem_0)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> &&notebookDocumentSyncOptions_notebookSelector_elem_0
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncOptions_notebookSelector_elem_0) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncOptions_notebookSelector_elem_0"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
            std::move(notebookDocumentSyncOptions_notebookSelector_elem_0)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0 &notebookDocumentSyncOptions_notebookSelector_elem_0
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
            std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_0>(notebookDocumentSyncOptions_notebookSelector_elem_0)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_0 &&notebookDocumentSyncOptions_notebookSelector_elem_0
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_0) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> {
            std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_0>(std::move(notebookDocumentSyncOptions_notebookSelector_elem_0))
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::notebookDocumentSyncOptions_notebookSelector_elem_1() const
    -> const NotebookDocumentSyncOptions_notebookSelector_elem_1 &
    {
#ifdef DEBUG
        if (_type != NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookDocumentSyncOptions_notebookSelector_elem::notebookDocumentSyncOptions_notebookSelector_elem_1()"
                 " of type "
                 "NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1"
                 " while active type is "
                 "NotebookDocumentSyncOptions_notebookSelector_elemType::" +
                 NotebookDocumentSyncOptions_notebookSelector_elemTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentSyncOptions_notebookSelector_elem_1;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        const std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> &notebookDocumentSyncOptions_notebookSelector_elem_1
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncOptions_notebookSelector_elem_1) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncOptions_notebookSelector_elem_1"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
            std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_1>(*notebookDocumentSyncOptions_notebookSelector_elem_1)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> &&notebookDocumentSyncOptions_notebookSelector_elem_1
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncOptions_notebookSelector_elem_1) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncOptions_notebookSelector_elem_1"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
            std::move(notebookDocumentSyncOptions_notebookSelector_elem_1)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1 &notebookDocumentSyncOptions_notebookSelector_elem_1
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
            std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_1>(notebookDocumentSyncOptions_notebookSelector_elem_1)
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1;
        return *this;
    }

    auto NotebookDocumentSyncOptions_notebookSelector_elem::operator=(
        NotebookDocumentSyncOptions_notebookSelector_elem_1 &&notebookDocumentSyncOptions_notebookSelector_elem_1
    ) -> NotebookDocumentSyncOptions_notebookSelector_elem &
    {
        if (_type !=
                NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncOptions_notebookSelector_elem_1) std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> {
            std::make_unique<NotebookDocumentSyncOptions_notebookSelector_elem_1>(std::move(notebookDocumentSyncOptions_notebookSelector_elem_1))
        };
        _type =
            NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1;
        return *this;
    }

    const std::map<NotebookCellTextDocumentFilter_notebookType, std::string>
    NotebookCellTextDocumentFilter_notebookTypeNames = {
        {NotebookCellTextDocumentFilter_notebookType::Uninitialized,
         "Uninitialized"},
        {NotebookCellTextDocumentFilter_notebookType::String, "String"},
        {NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter,
         "NotebookDocumentFilter"},
    };

    NotebookCellTextDocumentFilter_notebook::NotebookCellTextDocumentFilter_notebook()
    {
        // empty
    }

    NotebookCellTextDocumentFilter_notebook::~NotebookCellTextDocumentFilter_notebook()
    {
        reset();
    }

    NotebookCellTextDocumentFilter_notebook::NotebookCellTextDocumentFilter_notebook(
        NotebookCellTextDocumentFilter_notebook &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookCellTextDocumentFilter_notebookType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter: {
            new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                std::move(other._notebookDocumentFilter)
            };
            break;
        }
        case NotebookCellTextDocumentFilter_notebookType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            NotebookCellTextDocumentFilter_notebookType::Uninitialized;
    }

    NotebookCellTextDocumentFilter_notebook::NotebookCellTextDocumentFilter_notebook(
        const NotebookCellTextDocumentFilter_notebook &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case NotebookCellTextDocumentFilter_notebookType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter: {
            new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                std::make_unique<NotebookDocumentFilter>(*other._notebookDocumentFilter)
            };
            break;
        }
        case NotebookCellTextDocumentFilter_notebookType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        NotebookCellTextDocumentFilter_notebook &&other
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookCellTextDocumentFilter_notebookType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter: {
                new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                    std::move(other._notebookDocumentFilter)
                };
                break;
            }
            case NotebookCellTextDocumentFilter_notebookType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                NotebookCellTextDocumentFilter_notebookType::Uninitialized;
        }
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        const NotebookCellTextDocumentFilter_notebook &other
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case NotebookCellTextDocumentFilter_notebookType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter: {
                new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
                    std::make_unique<NotebookDocumentFilter>(*other._notebookDocumentFilter)
                };
                break;
            }
            case NotebookCellTextDocumentFilter_notebookType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::reset() -> void
    {
        switch (_type) {
        case NotebookCellTextDocumentFilter_notebookType::Uninitialized: {
            // nothing to do
            break;
        }
        case NotebookCellTextDocumentFilter_notebookType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = NotebookCellTextDocumentFilter_notebookType::Uninitialized;
            break;
        }
        case NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter: {
#ifdef DEBUG
            if (!_notebookDocumentFilter) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentFilter"
                );
            }
#endif // DEBUG
            _notebookDocumentFilter.~unique_ptr<NotebookDocumentFilter>();
            _type = NotebookCellTextDocumentFilter_notebookType::Uninitialized;
            break;
        }
        default: {
            _type = NotebookCellTextDocumentFilter_notebookType::Uninitialized;
        }
        }
    }

    auto NotebookCellTextDocumentFilter_notebook::type() const
    -> const NotebookCellTextDocumentFilter_notebookType &
    {
        return _type;
    }

    auto NotebookCellTextDocumentFilter_notebook::string() const
    -> const string_t &
    {
#ifdef DEBUG
        if (_type != NotebookCellTextDocumentFilter_notebookType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookCellTextDocumentFilter_notebook::string()"
                 " of type "
                 "NotebookCellTextDocumentFilter_notebookType::String"
                 " while active type is "
                 "NotebookCellTextDocumentFilter_notebookType::" +
                 NotebookCellTextDocumentFilter_notebookTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        const std::unique_ptr<string_t> &string
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = NotebookCellTextDocumentFilter_notebookType::String;
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        std::unique_ptr<string_t> &&string
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = NotebookCellTextDocumentFilter_notebookType::String;
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        const string_t &string
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = NotebookCellTextDocumentFilter_notebookType::String;
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        string_t &&string
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = NotebookCellTextDocumentFilter_notebookType::String;
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::notebookDocumentFilter() const
    -> const NotebookDocumentFilter &
    {
#ifdef DEBUG
        if (_type != NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter) {
            throw std::logic_error(
                ("Attempted to access "
                 "NotebookCellTextDocumentFilter_notebook::notebookDocumentFilter()"
                 " of type "
                 "NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter"
                 " while active type is "
                 "NotebookCellTextDocumentFilter_notebookType::" +
                 NotebookCellTextDocumentFilter_notebookTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentFilter;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        const std::unique_ptr<NotebookDocumentFilter> &notebookDocumentFilter
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(*notebookDocumentFilter)
        };
        _type =
            NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        std::unique_ptr<NotebookDocumentFilter> &&notebookDocumentFilter
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::move(notebookDocumentFilter)
        };
        _type =
            NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        const NotebookDocumentFilter &notebookDocumentFilter
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(notebookDocumentFilter)
        };
        _type =
            NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter;
        return *this;
    }

    auto NotebookCellTextDocumentFilter_notebook::operator=(
        NotebookDocumentFilter &&notebookDocumentFilter
    ) -> NotebookCellTextDocumentFilter_notebook &
    {
        if (_type !=
                NotebookCellTextDocumentFilter_notebookType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentFilter) std::unique_ptr<NotebookDocumentFilter> {
            std::make_unique<NotebookDocumentFilter>(std::move(notebookDocumentFilter))
        };
        _type =
            NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter;
        return *this;
    }

    NotebookCellTextDocumentFilter::NotebookCellTextDocumentFilter()
    {
        // empty
    }

    NotebookCellTextDocumentFilter::NotebookCellTextDocumentFilter(
        NotebookCellTextDocumentFilter &&other
    )
        : notebook(std::move(other.notebook))
        , language(std::move(other.language))
    {
        // empty
    }

    NotebookCellTextDocumentFilter::NotebookCellTextDocumentFilter(
        const NotebookCellTextDocumentFilter &other
    )
        : notebook(NotebookCellTextDocumentFilter_notebook(other.notebook))
    {
        if (other.language.has_value()) {
            language = other.language.value();
        }
    }

    NotebookCellTextDocumentFilter::~NotebookCellTextDocumentFilter()
    {
        // empty
    }

    auto NotebookCellTextDocumentFilter::operator=(
        NotebookCellTextDocumentFilter &&other
    ) -> NotebookCellTextDocumentFilter &
    {
        if (this != &other) {
            notebook = std::move(other.notebook);
            language = std::move(other.language);
        }
        return *this;
    }

    auto NotebookCellTextDocumentFilter::operator=(
        const NotebookCellTextDocumentFilter &other
    ) -> NotebookCellTextDocumentFilter &
    {
        if (this != &other) {
            notebook = NotebookCellTextDocumentFilter_notebook(other.notebook);
            if (other.language.has_value()) {
                language = other.language.value();
            }
        }
        return *this;
    }

    const std::map<DocumentFilterType, std::string> DocumentFilterTypeNames = {
        {DocumentFilterType::Uninitialized, "Uninitialized"},
        {DocumentFilterType::TextDocumentFilter, "TextDocumentFilter"},
        {DocumentFilterType::NotebookCellTextDocumentFilter,
         "NotebookCellTextDocumentFilter"},
    };

    DocumentFilter::DocumentFilter()
    {
        // empty
    }

    DocumentFilter::~DocumentFilter()
    {
        reset();
    }

    DocumentFilter::DocumentFilter(DocumentFilter &&other)
        : _type(other._type)
    {
        switch (other._type) {
        case DocumentFilterType::TextDocumentFilter: {
            new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
                std::move(other._textDocumentFilter)
            };
            break;
        }
        case DocumentFilterType::NotebookCellTextDocumentFilter: {
            new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
                std::move(other._notebookCellTextDocumentFilter)
            };
            break;
        }
        case DocumentFilterType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = DocumentFilterType::Uninitialized;
    }

    DocumentFilter::DocumentFilter(const DocumentFilter &other)
        : _type(other._type)
    {
        switch (other._type) {
        case DocumentFilterType::TextDocumentFilter: {
            new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
                std::make_unique<TextDocumentFilter>(*other._textDocumentFilter)
            };
            break;
        }
        case DocumentFilterType::NotebookCellTextDocumentFilter: {
            new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
                std::make_unique<NotebookCellTextDocumentFilter>(*other._notebookCellTextDocumentFilter)
            };
            break;
        }
        case DocumentFilterType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto DocumentFilter::operator=(DocumentFilter &&other) -> DocumentFilter &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case DocumentFilterType::TextDocumentFilter: {
                new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
                    std::move(other._textDocumentFilter)
                };
                break;
            }
            case DocumentFilterType::NotebookCellTextDocumentFilter: {
                new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
                    std::move(other._notebookCellTextDocumentFilter)
                };
                break;
            }
            case DocumentFilterType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = DocumentFilterType::Uninitialized;
        }
        return *this;
    }

    auto DocumentFilter::operator=(
        const DocumentFilter &other
    ) -> DocumentFilter &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case DocumentFilterType::TextDocumentFilter: {
                new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
                    std::make_unique<TextDocumentFilter>(*other._textDocumentFilter)
                };
                break;
            }
            case DocumentFilterType::NotebookCellTextDocumentFilter: {
                new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
                    std::make_unique<NotebookCellTextDocumentFilter>(*other._notebookCellTextDocumentFilter)
                };
                break;
            }
            case DocumentFilterType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto DocumentFilter::reset() -> void
    {
        switch (_type) {
        case DocumentFilterType::Uninitialized: {
            // nothing to do
            break;
        }
        case DocumentFilterType::TextDocumentFilter: {
#ifdef DEBUG
            if (!_textDocumentFilter) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _textDocumentFilter"
                );
            }
#endif // DEBUG
            _textDocumentFilter.~unique_ptr<TextDocumentFilter>();
            _type = DocumentFilterType::Uninitialized;
            break;
        }
        case DocumentFilterType::NotebookCellTextDocumentFilter: {
#ifdef DEBUG
            if (!_notebookCellTextDocumentFilter) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookCellTextDocumentFilter"
                );
            }
#endif // DEBUG
            _notebookCellTextDocumentFilter.~unique_ptr<NotebookCellTextDocumentFilter>();
            _type = DocumentFilterType::Uninitialized;
            break;
        }
        default: {
            _type = DocumentFilterType::Uninitialized;
        }
        }
    }

    auto DocumentFilter::type() const -> const DocumentFilterType &
    {
        return _type;
    }

    auto DocumentFilter::textDocumentFilter() const
    -> const TextDocumentFilter &
    {
#ifdef DEBUG
        if (_type != DocumentFilterType::TextDocumentFilter) {
            throw std::logic_error(
                ("Attempted to access "
                 "DocumentFilter::textDocumentFilter()"
                 " of type "
                 "DocumentFilterType::TextDocumentFilter"
                 " while active type is "
                 "DocumentFilterType::" +
                 DocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_textDocumentFilter;
    }

    auto DocumentFilter::operator=(
        const std::unique_ptr<TextDocumentFilter> &textDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
            std::make_unique<TextDocumentFilter>(*textDocumentFilter)
        };
        _type = DocumentFilterType::TextDocumentFilter;
        return *this;
    }

    auto DocumentFilter::operator=(
        std::unique_ptr<TextDocumentFilter> &&textDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of textDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
            std::move(textDocumentFilter)
        };
        _type = DocumentFilterType::TextDocumentFilter;
        return *this;
    }

    auto DocumentFilter::operator=(
        const TextDocumentFilter &textDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
            std::make_unique<TextDocumentFilter>(textDocumentFilter)
        };
        _type = DocumentFilterType::TextDocumentFilter;
        return *this;
    }

    auto DocumentFilter::operator=(
        TextDocumentFilter &&textDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_textDocumentFilter) std::unique_ptr<TextDocumentFilter> {
            std::make_unique<TextDocumentFilter>(std::move(textDocumentFilter))
        };
        _type = DocumentFilterType::TextDocumentFilter;
        return *this;
    }

    auto DocumentFilter::notebookCellTextDocumentFilter() const
    -> const NotebookCellTextDocumentFilter &
    {
#ifdef DEBUG
        if (_type != DocumentFilterType::NotebookCellTextDocumentFilter) {
            throw std::logic_error(
                ("Attempted to access "
                 "DocumentFilter::notebookCellTextDocumentFilter()"
                 " of type "
                 "DocumentFilterType::NotebookCellTextDocumentFilter"
                 " while active type is "
                 "DocumentFilterType::" +
                 DocumentFilterTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookCellTextDocumentFilter;
    }

    auto DocumentFilter::operator=(
        const std::unique_ptr<NotebookCellTextDocumentFilter> &notebookCellTextDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookCellTextDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookCellTextDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
            std::make_unique<NotebookCellTextDocumentFilter>(*notebookCellTextDocumentFilter)
        };
        _type = DocumentFilterType::NotebookCellTextDocumentFilter;
        return *this;
    }

    auto DocumentFilter::operator=(
        std::unique_ptr<NotebookCellTextDocumentFilter> &&notebookCellTextDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookCellTextDocumentFilter) {
            throw std::logic_error(
                "null passed as the value of notebookCellTextDocumentFilter"
            );
        }
#endif // DEBUG
        new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
            std::move(notebookCellTextDocumentFilter)
        };
        _type = DocumentFilterType::NotebookCellTextDocumentFilter;
        return *this;
    }

    auto DocumentFilter::operator=(
        const NotebookCellTextDocumentFilter &notebookCellTextDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
            std::make_unique<NotebookCellTextDocumentFilter>(notebookCellTextDocumentFilter)
        };
        _type = DocumentFilterType::NotebookCellTextDocumentFilter;
        return *this;
    }

    auto DocumentFilter::operator=(
        NotebookCellTextDocumentFilter &&notebookCellTextDocumentFilter
    ) -> DocumentFilter &
    {
        if (_type != DocumentFilterType::Uninitialized) {
            reset();
        }
        new (&_notebookCellTextDocumentFilter) std::unique_ptr<NotebookCellTextDocumentFilter> {
            std::make_unique<NotebookCellTextDocumentFilter>(std::move(notebookCellTextDocumentFilter))
        };
        _type = DocumentFilterType::NotebookCellTextDocumentFilter;
        return *this;
    }

    RelativePattern::RelativePattern()
    {
        // empty
    }

    RelativePattern::RelativePattern(RelativePattern &&other)
        : baseUri(std::move(other.baseUri))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    RelativePattern::RelativePattern(const RelativePattern &other)
        : baseUri(RelativePattern_baseUri(other.baseUri))
        , pattern(other.pattern)
    {
    }

    RelativePattern::~RelativePattern()
    {
        // empty
    }

    auto RelativePattern::operator=(
        RelativePattern &&other
    ) -> RelativePattern &
    {
        if (this != &other) {
            baseUri = std::move(other.baseUri);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto RelativePattern::operator=(
        const RelativePattern &other
    ) -> RelativePattern &
    {
        if (this != &other) {
            baseUri = RelativePattern_baseUri(other.baseUri);
            pattern = other.pattern;
        }
        return *this;
    }

    const std::map<GlobPatternType, std::string> GlobPatternTypeNames = {
        {GlobPatternType::Uninitialized, "Uninitialized"},
        {GlobPatternType::Pattern, "Pattern"},
        {GlobPatternType::RelativePattern, "RelativePattern"},
    };

    GlobPattern::GlobPattern()
    {
        // empty
    }

    GlobPattern::~GlobPattern()
    {
        reset();
    }

    GlobPattern::GlobPattern(GlobPattern &&other)
        : _type(other._type)
    {
        switch (other._type) {
        case GlobPatternType::Pattern: {
            new (&_pattern) std::unique_ptr<Pattern> {
                std::move(other._pattern)
            };
            break;
        }
        case GlobPatternType::RelativePattern: {
            new (&_relativePattern) std::unique_ptr<RelativePattern> {
                std::move(other._relativePattern)
            };
            break;
        }
        case GlobPatternType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = GlobPatternType::Uninitialized;
    }

    GlobPattern::GlobPattern(const GlobPattern &other)
        : _type(other._type)
    {
        switch (other._type) {
        case GlobPatternType::Pattern: {
            new (&_pattern) std::unique_ptr<Pattern> {
                std::make_unique<Pattern>(*other._pattern)
            };
            break;
        }
        case GlobPatternType::RelativePattern: {
            new (&_relativePattern) std::unique_ptr<RelativePattern> {
                std::make_unique<RelativePattern>(*other._relativePattern)
            };
            break;
        }
        case GlobPatternType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto GlobPattern::operator=(GlobPattern &&other) -> GlobPattern &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case GlobPatternType::Pattern: {
                new (&_pattern) std::unique_ptr<Pattern> {
                    std::move(other._pattern)
                };
                break;
            }
            case GlobPatternType::RelativePattern: {
                new (&_relativePattern) std::unique_ptr<RelativePattern> {
                    std::move(other._relativePattern)
                };
                break;
            }
            case GlobPatternType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = GlobPatternType::Uninitialized;
        }
        return *this;
    }

    auto GlobPattern::operator=(const GlobPattern &other) -> GlobPattern &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case GlobPatternType::Pattern: {
                new (&_pattern) std::unique_ptr<Pattern> {
                    std::make_unique<Pattern>(*other._pattern)
                };
                break;
            }
            case GlobPatternType::RelativePattern: {
                new (&_relativePattern) std::unique_ptr<RelativePattern> {
                    std::make_unique<RelativePattern>(*other._relativePattern)
                };
                break;
            }
            case GlobPatternType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto GlobPattern::reset() -> void
    {
        switch (_type) {
        case GlobPatternType::Uninitialized: {
            // nothing to do
            break;
        }
        case GlobPatternType::Pattern: {
#ifdef DEBUG
            if (!_pattern) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _pattern"
                );
            }
#endif // DEBUG
            _pattern.~unique_ptr<string_t>();
            _type = GlobPatternType::Uninitialized;
            break;
        }
        case GlobPatternType::RelativePattern: {
#ifdef DEBUG
            if (!_relativePattern) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _relativePattern"
                );
            }
#endif // DEBUG
            _relativePattern.~unique_ptr<RelativePattern>();
            _type = GlobPatternType::Uninitialized;
            break;
        }
        default: {
            _type = GlobPatternType::Uninitialized;
        }
        }
    }

    auto GlobPattern::type() const -> const GlobPatternType &
    {
        return _type;
    }

    auto GlobPattern::pattern() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != GlobPatternType::Pattern) {
            throw std::logic_error(
                ("Attempted to access "
                 "GlobPattern::pattern()"
                 " of type "
                 "GlobPatternType::Pattern"
                 " while active type is "
                 "GlobPatternType::" +
                 GlobPatternTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_pattern;
    }

    auto GlobPattern::operator=(
        const std::unique_ptr<string_t> &pattern
    ) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!pattern) {
            throw std::logic_error("null passed as the value of pattern");
        }
#endif // DEBUG
        new (&_pattern) std::unique_ptr<Pattern> {
            std::make_unique<Pattern>(*pattern)
        };
        _type = GlobPatternType::Pattern;
        return *this;
    }

    auto GlobPattern::operator=(
        std::unique_ptr<string_t> &&pattern
    ) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!pattern) {
            throw std::logic_error("null passed as the value of pattern");
        }
#endif // DEBUG
        new (&_pattern) std::unique_ptr<Pattern> {
            std::move(pattern)
        };
        _type = GlobPatternType::Pattern;
        return *this;
    }

    auto GlobPattern::operator=(const string_t &pattern) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
        new (&_pattern) std::unique_ptr<Pattern> {
            std::make_unique<Pattern>(pattern)
        };
        _type = GlobPatternType::Pattern;
        return *this;
    }

    auto GlobPattern::operator=(string_t &&pattern) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
        new (&_pattern) std::unique_ptr<Pattern> {
            std::make_unique<Pattern>(std::move(pattern))
        };
        _type = GlobPatternType::Pattern;
        return *this;
    }

    auto GlobPattern::relativePattern() const -> const RelativePattern &
    {
#ifdef DEBUG
        if (_type != GlobPatternType::RelativePattern) {
            throw std::logic_error(
                ("Attempted to access "
                 "GlobPattern::relativePattern()"
                 " of type "
                 "GlobPatternType::RelativePattern"
                 " while active type is "
                 "GlobPatternType::" +
                 GlobPatternTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_relativePattern;
    }

    auto GlobPattern::operator=(
        const std::unique_ptr<RelativePattern> &relativePattern
    ) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!relativePattern) {
            throw std::logic_error(
                "null passed as the value of relativePattern"
            );
        }
#endif // DEBUG
        new (&_relativePattern) std::unique_ptr<RelativePattern> {
            std::make_unique<RelativePattern>(*relativePattern)
        };
        _type = GlobPatternType::RelativePattern;
        return *this;
    }

    auto GlobPattern::operator=(
        std::unique_ptr<RelativePattern> &&relativePattern
    ) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!relativePattern) {
            throw std::logic_error(
                "null passed as the value of relativePattern"
            );
        }
#endif // DEBUG
        new (&_relativePattern) std::unique_ptr<RelativePattern> {
            std::move(relativePattern)
        };
        _type = GlobPatternType::RelativePattern;
        return *this;
    }

    auto GlobPattern::operator=(
        const RelativePattern &relativePattern
    ) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
        new (&_relativePattern) std::unique_ptr<RelativePattern> {
            std::make_unique<RelativePattern>(relativePattern)
        };
        _type = GlobPatternType::RelativePattern;
        return *this;
    }

    auto GlobPattern::operator=(
        RelativePattern &&relativePattern
    ) -> GlobPattern &
    {
        if (_type != GlobPatternType::Uninitialized) {
            reset();
        }
        new (&_relativePattern) std::unique_ptr<RelativePattern> {
            std::make_unique<RelativePattern>(std::move(relativePattern))
        };
        _type = GlobPatternType::RelativePattern;
        return *this;
    }

    FileSystemWatcher::FileSystemWatcher()
    {
        // empty
    }

    FileSystemWatcher::FileSystemWatcher(FileSystemWatcher &&other)
        : globPattern(std::move(other.globPattern))
        , kind(std::move(other.kind))
    {
        // empty
    }

    FileSystemWatcher::FileSystemWatcher(const FileSystemWatcher &other)
        : globPattern(GlobPattern(other.globPattern))
    {
        if (other.kind.has_value()) {
            kind = other.kind.value();
        }
    }

    FileSystemWatcher::~FileSystemWatcher()
    {
        // empty
    }

    auto FileSystemWatcher::operator=(
        FileSystemWatcher &&other
    ) -> FileSystemWatcher &
    {
        if (this != &other) {
            globPattern = std::move(other.globPattern);
            kind = std::move(other.kind);
        }
        return *this;
    }

    auto FileSystemWatcher::operator=(
        const FileSystemWatcher &other
    ) -> FileSystemWatcher &
    {
        if (this != &other) {
            globPattern = GlobPattern(other.globPattern);
            if (other.kind.has_value()) {
                kind = other.kind.value();
            }
        }
        return *this;
    }

    DidChangeWatchedFilesRegistrationOptions::DidChangeWatchedFilesRegistrationOptions()
    {
        // empty
    }

    DidChangeWatchedFilesRegistrationOptions::DidChangeWatchedFilesRegistrationOptions(
        DidChangeWatchedFilesRegistrationOptions &&other
    )
        : watchers(std::move(other.watchers))
    {
        // empty
    }

    DidChangeWatchedFilesRegistrationOptions::DidChangeWatchedFilesRegistrationOptions(
        const DidChangeWatchedFilesRegistrationOptions &other
    )
    {
        watchers.reserve(other.watchers.size());
        for (const auto &elem_0 : other.watchers) {
            watchers.push_back(elem_0);
        }
    }

    DidChangeWatchedFilesRegistrationOptions::~DidChangeWatchedFilesRegistrationOptions()
    {
        // empty
    }

    auto DidChangeWatchedFilesRegistrationOptions::operator=(
        DidChangeWatchedFilesRegistrationOptions &&other
    ) -> DidChangeWatchedFilesRegistrationOptions &
    {
        if (this != &other) {
            watchers = std::move(other.watchers);
        }
        return *this;
    }

    auto DidChangeWatchedFilesRegistrationOptions::operator=(
        const DidChangeWatchedFilesRegistrationOptions &other
    ) -> DidChangeWatchedFilesRegistrationOptions &
    {
        if (this != &other) {
            watchers.reserve(other.watchers.size());
            for (const auto &elem_0 : other.watchers) {
                watchers.push_back(elem_0);
            }
        }
        return *this;
    }

    WorkDoneProgressOptions::WorkDoneProgressOptions()
    {
        // empty
    }

    WorkDoneProgressOptions::WorkDoneProgressOptions(
        WorkDoneProgressOptions &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    WorkDoneProgressOptions::WorkDoneProgressOptions(
        const WorkDoneProgressOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    WorkDoneProgressOptions::~WorkDoneProgressOptions()
    {
        // empty
    }

    auto WorkDoneProgressOptions::operator=(
        WorkDoneProgressOptions &&other
    ) -> WorkDoneProgressOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto WorkDoneProgressOptions::operator=(
        const WorkDoneProgressOptions &other
    ) -> WorkDoneProgressOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    ShowDocumentResult::ShowDocumentResult()
    {
        // empty
    }

    ShowDocumentResult::ShowDocumentResult(ShowDocumentResult &&other)
        : success(other.success)
    {
        // empty
    }

    ShowDocumentResult::ShowDocumentResult(const ShowDocumentResult &other)
        : success(other.success)
    {
    }

    ShowDocumentResult::~ShowDocumentResult()
    {
        // empty
    }

    auto ShowDocumentResult::operator=(
        ShowDocumentResult &&other
    ) -> ShowDocumentResult &
    {
        if (this != &other) {
            success = other.success;
        }
        return *this;
    }

    auto ShowDocumentResult::operator=(
        const ShowDocumentResult &other
    ) -> ShowDocumentResult &
    {
        if (this != &other) {
            success = other.success;
        }
        return *this;
    }

    DiagnosticServerCancellationData::DiagnosticServerCancellationData()
    {
        // empty
    }

    DiagnosticServerCancellationData::DiagnosticServerCancellationData(
        DiagnosticServerCancellationData &&other
    )
        : retriggerRequest(other.retriggerRequest)
    {
        // empty
    }

    DiagnosticServerCancellationData::DiagnosticServerCancellationData(
        const DiagnosticServerCancellationData &other
    )
        : retriggerRequest(other.retriggerRequest)
    {
    }

    DiagnosticServerCancellationData::~DiagnosticServerCancellationData()
    {
        // empty
    }

    auto DiagnosticServerCancellationData::operator=(
        DiagnosticServerCancellationData &&other
    ) -> DiagnosticServerCancellationData &
    {
        if (this != &other) {
            retriggerRequest = other.retriggerRequest;
        }
        return *this;
    }

    auto DiagnosticServerCancellationData::operator=(
        const DiagnosticServerCancellationData &other
    ) -> DiagnosticServerCancellationData &
    {
        if (this != &other) {
            retriggerRequest = other.retriggerRequest;
        }
        return *this;
    }

    InitializeError::InitializeError()
    {
        // empty
    }

    InitializeError::InitializeError(InitializeError &&other)
        : retry(other.retry)
    {
        // empty
    }

    InitializeError::InitializeError(const InitializeError &other)
        : retry(other.retry)
    {
    }

    InitializeError::~InitializeError()
    {
        // empty
    }

    auto InitializeError::operator=(
        InitializeError &&other
    ) -> InitializeError &
    {
        if (this != &other) {
            retry = other.retry;
        }
        return *this;
    }

    auto InitializeError::operator=(
        const InitializeError &other
    ) -> InitializeError &
    {
        if (this != &other) {
            retry = other.retry;
        }
        return *this;
    }

    ImplementationOptions::ImplementationOptions()
    {
        // empty
    }

    ImplementationOptions::ImplementationOptions(ImplementationOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    ImplementationOptions::ImplementationOptions(
        const ImplementationOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    ImplementationOptions::~ImplementationOptions()
    {
        // empty
    }

    auto ImplementationOptions::operator=(
        ImplementationOptions &&other
    ) -> ImplementationOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto ImplementationOptions::operator=(
        const ImplementationOptions &other
    ) -> ImplementationOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    TypeDefinitionOptions::TypeDefinitionOptions()
    {
        // empty
    }

    TypeDefinitionOptions::TypeDefinitionOptions(TypeDefinitionOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    TypeDefinitionOptions::TypeDefinitionOptions(
        const TypeDefinitionOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    TypeDefinitionOptions::~TypeDefinitionOptions()
    {
        // empty
    }

    auto TypeDefinitionOptions::operator=(
        TypeDefinitionOptions &&other
    ) -> TypeDefinitionOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto TypeDefinitionOptions::operator=(
        const TypeDefinitionOptions &other
    ) -> TypeDefinitionOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    DocumentColorOptions::DocumentColorOptions()
    {
        // empty
    }

    DocumentColorOptions::DocumentColorOptions(DocumentColorOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    DocumentColorOptions::DocumentColorOptions(
        const DocumentColorOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    DocumentColorOptions::~DocumentColorOptions()
    {
        // empty
    }

    auto DocumentColorOptions::operator=(
        DocumentColorOptions &&other
    ) -> DocumentColorOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto DocumentColorOptions::operator=(
        const DocumentColorOptions &other
    ) -> DocumentColorOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    FoldingRangeOptions::FoldingRangeOptions()
    {
        // empty
    }

    FoldingRangeOptions::FoldingRangeOptions(FoldingRangeOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    FoldingRangeOptions::FoldingRangeOptions(const FoldingRangeOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    FoldingRangeOptions::~FoldingRangeOptions()
    {
        // empty
    }

    auto FoldingRangeOptions::operator=(
        FoldingRangeOptions &&other
    ) -> FoldingRangeOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto FoldingRangeOptions::operator=(
        const FoldingRangeOptions &other
    ) -> FoldingRangeOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    DeclarationOptions::DeclarationOptions()
    {
        // empty
    }

    DeclarationOptions::DeclarationOptions(DeclarationOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    DeclarationOptions::DeclarationOptions(const DeclarationOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    DeclarationOptions::~DeclarationOptions()
    {
        // empty
    }

    auto DeclarationOptions::operator=(
        DeclarationOptions &&other
    ) -> DeclarationOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto DeclarationOptions::operator=(
        const DeclarationOptions &other
    ) -> DeclarationOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    SelectionRangeOptions::SelectionRangeOptions()
    {
        // empty
    }

    SelectionRangeOptions::SelectionRangeOptions(SelectionRangeOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    SelectionRangeOptions::SelectionRangeOptions(
        const SelectionRangeOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    SelectionRangeOptions::~SelectionRangeOptions()
    {
        // empty
    }

    auto SelectionRangeOptions::operator=(
        SelectionRangeOptions &&other
    ) -> SelectionRangeOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto SelectionRangeOptions::operator=(
        const SelectionRangeOptions &other
    ) -> SelectionRangeOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    CallHierarchyOptions::CallHierarchyOptions()
    {
        // empty
    }

    CallHierarchyOptions::CallHierarchyOptions(CallHierarchyOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    CallHierarchyOptions::CallHierarchyOptions(
        const CallHierarchyOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    CallHierarchyOptions::~CallHierarchyOptions()
    {
        // empty
    }

    auto CallHierarchyOptions::operator=(
        CallHierarchyOptions &&other
    ) -> CallHierarchyOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto CallHierarchyOptions::operator=(
        const CallHierarchyOptions &other
    ) -> CallHierarchyOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    SemanticTokensOptions_full_1::SemanticTokensOptions_full_1()
    {
        // empty
    }

    SemanticTokensOptions_full_1::SemanticTokensOptions_full_1(
        SemanticTokensOptions_full_1 &&other
    )
        : delta(std::move(other.delta))
    {
        // empty
    }

    SemanticTokensOptions_full_1::SemanticTokensOptions_full_1(
        const SemanticTokensOptions_full_1 &other
    )
    {
        if (other.delta.has_value()) {
            delta = other.delta.value();
        }
    }

    SemanticTokensOptions_full_1::~SemanticTokensOptions_full_1()
    {
        // empty
    }

    auto SemanticTokensOptions_full_1::operator=(
        SemanticTokensOptions_full_1 &&other
    ) -> SemanticTokensOptions_full_1 &
    {
        if (this != &other) {
            delta = std::move(other.delta);
        }
        return *this;
    }

    auto SemanticTokensOptions_full_1::operator=(
        const SemanticTokensOptions_full_1 &other
    ) -> SemanticTokensOptions_full_1 &
    {
        if (this != &other) {
            if (other.delta.has_value()) {
                delta = other.delta.value();
            }
        }
        return *this;
    }

    const std::map<SemanticTokensOptions_fullType, std::string>
    SemanticTokensOptions_fullTypeNames = {
        {SemanticTokensOptions_fullType::Uninitialized, "Uninitialized"},
        {SemanticTokensOptions_fullType::Boolean, "Boolean"},
        {SemanticTokensOptions_fullType::SemanticTokensOptions_full_1,
         "SemanticTokensOptions_full_1"},
    };

    SemanticTokensOptions_full::SemanticTokensOptions_full()
    {
        // empty
    }

    SemanticTokensOptions_full::~SemanticTokensOptions_full()
    {
        reset();
    }

    SemanticTokensOptions_full::SemanticTokensOptions_full(
        SemanticTokensOptions_full &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case SemanticTokensOptions_fullType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case SemanticTokensOptions_fullType::SemanticTokensOptions_full_1: {
            new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
                std::move(other._semanticTokensOptions_full_1)
            };
            break;
        }
        case SemanticTokensOptions_fullType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = SemanticTokensOptions_fullType::Uninitialized;
    }

    SemanticTokensOptions_full::SemanticTokensOptions_full(
        const SemanticTokensOptions_full &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case SemanticTokensOptions_fullType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case SemanticTokensOptions_fullType::SemanticTokensOptions_full_1: {
            new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
                std::make_unique<SemanticTokensOptions_full_1>(*other._semanticTokensOptions_full_1)
            };
            break;
        }
        case SemanticTokensOptions_fullType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto SemanticTokensOptions_full::operator=(
        SemanticTokensOptions_full &&other
    ) -> SemanticTokensOptions_full &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case SemanticTokensOptions_fullType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case SemanticTokensOptions_fullType::SemanticTokensOptions_full_1: {
                new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
                    std::move(other._semanticTokensOptions_full_1)
                };
                break;
            }
            case SemanticTokensOptions_fullType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = SemanticTokensOptions_fullType::Uninitialized;
        }
        return *this;
    }

    auto SemanticTokensOptions_full::operator=(
        const SemanticTokensOptions_full &other
    ) -> SemanticTokensOptions_full &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case SemanticTokensOptions_fullType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case SemanticTokensOptions_fullType::SemanticTokensOptions_full_1: {
                new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
                    std::make_unique<SemanticTokensOptions_full_1>(*other._semanticTokensOptions_full_1)
                };
                break;
            }
            case SemanticTokensOptions_fullType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto SemanticTokensOptions_full::reset() -> void
    {
        switch (_type) {
        case SemanticTokensOptions_fullType::Uninitialized: {
            // nothing to do
            break;
        }
        case SemanticTokensOptions_fullType::SemanticTokensOptions_full_1: {
#ifdef DEBUG
            if (!_semanticTokensOptions_full_1) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _semanticTokensOptions_full_1"
                );
            }
#endif // DEBUG
            _semanticTokensOptions_full_1.~unique_ptr<SemanticTokensOptions_full_1>();
            _type = SemanticTokensOptions_fullType::Uninitialized;
            break;
        }
        default: {
            _type = SemanticTokensOptions_fullType::Uninitialized;
        }
        }
    }

    auto SemanticTokensOptions_full::type() const
    -> const SemanticTokensOptions_fullType &
    {
        return _type;
    }

    auto SemanticTokensOptions_full::boolean() const -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != SemanticTokensOptions_fullType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "SemanticTokensOptions_full::boolean()"
                 " of type "
                 "SemanticTokensOptions_fullType::Boolean"
                 " while active type is "
                 "SemanticTokensOptions_fullType::" +
                 SemanticTokensOptions_fullTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto SemanticTokensOptions_full::operator=(
        boolean_t boolean
    ) -> SemanticTokensOptions_full &
    {
        if (_type != SemanticTokensOptions_fullType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = SemanticTokensOptions_fullType::Boolean;
        return *this;
    }

    auto SemanticTokensOptions_full::semanticTokensOptions_full_1() const
    -> const SemanticTokensOptions_full_1 &
    {
#ifdef DEBUG
        if (_type != SemanticTokensOptions_fullType::SemanticTokensOptions_full_1) {
            throw std::logic_error(
                ("Attempted to access "
                 "SemanticTokensOptions_full::semanticTokensOptions_full_1()"
                 " of type "
                 "SemanticTokensOptions_fullType::SemanticTokensOptions_full_1"
                 " while active type is "
                 "SemanticTokensOptions_fullType::" +
                 SemanticTokensOptions_fullTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_semanticTokensOptions_full_1;
    }

    auto SemanticTokensOptions_full::operator=(
        const std::unique_ptr<SemanticTokensOptions_full_1> &semanticTokensOptions_full_1
    ) -> SemanticTokensOptions_full &
    {
        if (_type != SemanticTokensOptions_fullType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!semanticTokensOptions_full_1) {
            throw std::logic_error(
                "null passed as the value of semanticTokensOptions_full_1"
            );
        }
#endif // DEBUG
        new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
            std::make_unique<SemanticTokensOptions_full_1>(*semanticTokensOptions_full_1)
        };
        _type = SemanticTokensOptions_fullType::SemanticTokensOptions_full_1;
        return *this;
    }

    auto SemanticTokensOptions_full::operator=(
        std::unique_ptr<SemanticTokensOptions_full_1> &&semanticTokensOptions_full_1
    ) -> SemanticTokensOptions_full &
    {
        if (_type != SemanticTokensOptions_fullType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!semanticTokensOptions_full_1) {
            throw std::logic_error(
                "null passed as the value of semanticTokensOptions_full_1"
            );
        }
#endif // DEBUG
        new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
            std::move(semanticTokensOptions_full_1)
        };
        _type = SemanticTokensOptions_fullType::SemanticTokensOptions_full_1;
        return *this;
    }

    auto SemanticTokensOptions_full::operator=(
        const SemanticTokensOptions_full_1 &semanticTokensOptions_full_1
    ) -> SemanticTokensOptions_full &
    {
        if (_type != SemanticTokensOptions_fullType::Uninitialized) {
            reset();
        }
        new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
            std::make_unique<SemanticTokensOptions_full_1>(semanticTokensOptions_full_1)
        };
        _type = SemanticTokensOptions_fullType::SemanticTokensOptions_full_1;
        return *this;
    }

    auto SemanticTokensOptions_full::operator=(
        SemanticTokensOptions_full_1 &&semanticTokensOptions_full_1
    ) -> SemanticTokensOptions_full &
    {
        if (_type != SemanticTokensOptions_fullType::Uninitialized) {
            reset();
        }
        new (&_semanticTokensOptions_full_1) std::unique_ptr<SemanticTokensOptions_full_1> {
            std::make_unique<SemanticTokensOptions_full_1>(std::move(semanticTokensOptions_full_1))
        };
        _type = SemanticTokensOptions_fullType::SemanticTokensOptions_full_1;
        return *this;
    }

    LinkedEditingRangeOptions::LinkedEditingRangeOptions()
    {
        // empty
    }

    LinkedEditingRangeOptions::LinkedEditingRangeOptions(
        LinkedEditingRangeOptions &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    LinkedEditingRangeOptions::LinkedEditingRangeOptions(
        const LinkedEditingRangeOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    LinkedEditingRangeOptions::~LinkedEditingRangeOptions()
    {
        // empty
    }

    auto LinkedEditingRangeOptions::operator=(
        LinkedEditingRangeOptions &&other
    ) -> LinkedEditingRangeOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto LinkedEditingRangeOptions::operator=(
        const LinkedEditingRangeOptions &other
    ) -> LinkedEditingRangeOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    ChangeAnnotation::ChangeAnnotation()
    {
        // empty
    }

    ChangeAnnotation::ChangeAnnotation(ChangeAnnotation &&other)
        : label(std::move(other.label))
        , needsConfirmation(std::move(other.needsConfirmation))
        , description(std::move(other.description))
    {
        // empty
    }

    ChangeAnnotation::ChangeAnnotation(const ChangeAnnotation &other)
        : label(other.label)
    {
        if (other.needsConfirmation.has_value()) {
            needsConfirmation = other.needsConfirmation.value();
        }
        if (other.description.has_value()) {
            description = other.description.value();
        }
    }

    ChangeAnnotation::~ChangeAnnotation()
    {
        // empty
    }

    auto ChangeAnnotation::operator=(
        ChangeAnnotation &&other
    ) -> ChangeAnnotation &
    {
        if (this != &other) {
            label = std::move(other.label);
            needsConfirmation = std::move(other.needsConfirmation);
            description = std::move(other.description);
        }
        return *this;
    }

    auto ChangeAnnotation::operator=(
        const ChangeAnnotation &other
    ) -> ChangeAnnotation &
    {
        if (this != &other) {
            label = other.label;
            if (other.needsConfirmation.has_value()) {
                needsConfirmation = other.needsConfirmation.value();
            }
            if (other.description.has_value()) {
                description = other.description.value();
            }
        }
        return *this;
    }

    MonikerOptions::MonikerOptions()
    {
        // empty
    }

    MonikerOptions::MonikerOptions(MonikerOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    MonikerOptions::MonikerOptions(const MonikerOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    MonikerOptions::~MonikerOptions()
    {
        // empty
    }

    auto MonikerOptions::operator=(MonikerOptions &&other) -> MonikerOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto MonikerOptions::operator=(
        const MonikerOptions &other
    ) -> MonikerOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    TypeHierarchyOptions::TypeHierarchyOptions()
    {
        // empty
    }

    TypeHierarchyOptions::TypeHierarchyOptions(TypeHierarchyOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    TypeHierarchyOptions::TypeHierarchyOptions(
        const TypeHierarchyOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    TypeHierarchyOptions::~TypeHierarchyOptions()
    {
        // empty
    }

    auto TypeHierarchyOptions::operator=(
        TypeHierarchyOptions &&other
    ) -> TypeHierarchyOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto TypeHierarchyOptions::operator=(
        const TypeHierarchyOptions &other
    ) -> TypeHierarchyOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    InlineValueOptions::InlineValueOptions()
    {
        // empty
    }

    InlineValueOptions::InlineValueOptions(InlineValueOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    InlineValueOptions::InlineValueOptions(const InlineValueOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    InlineValueOptions::~InlineValueOptions()
    {
        // empty
    }

    auto InlineValueOptions::operator=(
        InlineValueOptions &&other
    ) -> InlineValueOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto InlineValueOptions::operator=(
        const InlineValueOptions &other
    ) -> InlineValueOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    InlayHintOptions::InlayHintOptions()
    {
        // empty
    }

    InlayHintOptions::InlayHintOptions(InlayHintOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , resolveProvider(std::move(other.resolveProvider))
    {
        // empty
    }

    InlayHintOptions::InlayHintOptions(const InlayHintOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.resolveProvider.has_value()) {
            resolveProvider = other.resolveProvider.value();
        }
    }

    InlayHintOptions::~InlayHintOptions()
    {
        // empty
    }

    auto InlayHintOptions::operator=(
        InlayHintOptions &&other
    ) -> InlayHintOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            resolveProvider = std::move(other.resolveProvider);
        }
        return *this;
    }

    auto InlayHintOptions::operator=(
        const InlayHintOptions &other
    ) -> InlayHintOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.resolveProvider.has_value()) {
                resolveProvider = other.resolveProvider.value();
            }
        }
        return *this;
    }

    DiagnosticOptions::DiagnosticOptions()
    {
        // empty
    }

    DiagnosticOptions::DiagnosticOptions(DiagnosticOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , identifier(std::move(other.identifier))
        , interFileDependencies(other.interFileDependencies)
        , workspaceDiagnostics(other.workspaceDiagnostics)
    {
        // empty
    }

    DiagnosticOptions::DiagnosticOptions(const DiagnosticOptions &other)
        : interFileDependencies(other.interFileDependencies)
        , workspaceDiagnostics(other.workspaceDiagnostics)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.identifier.has_value()) {
            identifier = other.identifier.value();
        }
    }

    DiagnosticOptions::~DiagnosticOptions()
    {
        // empty
    }

    auto DiagnosticOptions::operator=(
        DiagnosticOptions &&other
    ) -> DiagnosticOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            identifier = std::move(other.identifier);
            interFileDependencies = other.interFileDependencies;
            workspaceDiagnostics = other.workspaceDiagnostics;
        }
        return *this;
    }

    auto DiagnosticOptions::operator=(
        const DiagnosticOptions &other
    ) -> DiagnosticOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.identifier.has_value()) {
                identifier = other.identifier.value();
            }
            interFileDependencies = other.interFileDependencies;
            workspaceDiagnostics = other.workspaceDiagnostics;
        }
        return *this;
    }

    InlineCompletionOptions::InlineCompletionOptions()
    {
        // empty
    }

    InlineCompletionOptions::InlineCompletionOptions(
        InlineCompletionOptions &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    InlineCompletionOptions::InlineCompletionOptions(
        const InlineCompletionOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    InlineCompletionOptions::~InlineCompletionOptions()
    {
        // empty
    }

    auto InlineCompletionOptions::operator=(
        InlineCompletionOptions &&other
    ) -> InlineCompletionOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto InlineCompletionOptions::operator=(
        const InlineCompletionOptions &other
    ) -> InlineCompletionOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    const std::map<
        ServerCapabilities_inlineCompletionProviderType,
        std::string
    > ServerCapabilities_inlineCompletionProviderTypeNames = {
        {ServerCapabilities_inlineCompletionProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_inlineCompletionProviderType::Boolean, "Boolean"},
        {ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions,
         "InlineCompletionOptions"},
    };

    ServerCapabilities_inlineCompletionProvider::ServerCapabilities_inlineCompletionProvider()
    {
        // empty
    }

    ServerCapabilities_inlineCompletionProvider::~ServerCapabilities_inlineCompletionProvider()
    {
        reset();
    }

    ServerCapabilities_inlineCompletionProvider::ServerCapabilities_inlineCompletionProvider(
        ServerCapabilities_inlineCompletionProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_inlineCompletionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions: {
            new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
                std::move(other._inlineCompletionOptions)
            };
            break;
        }
        case ServerCapabilities_inlineCompletionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_inlineCompletionProviderType::Uninitialized;
    }

    ServerCapabilities_inlineCompletionProvider::ServerCapabilities_inlineCompletionProvider(
        const ServerCapabilities_inlineCompletionProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_inlineCompletionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions: {
            new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
                std::make_unique<InlineCompletionOptions>(*other._inlineCompletionOptions)
            };
            break;
        }
        case ServerCapabilities_inlineCompletionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_inlineCompletionProvider::operator=(
        ServerCapabilities_inlineCompletionProvider &&other
    ) -> ServerCapabilities_inlineCompletionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_inlineCompletionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions: {
                new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
                    std::move(other._inlineCompletionOptions)
                };
                break;
            }
            case ServerCapabilities_inlineCompletionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_inlineCompletionProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_inlineCompletionProvider::operator=(
        const ServerCapabilities_inlineCompletionProvider &other
    ) -> ServerCapabilities_inlineCompletionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_inlineCompletionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions: {
                new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
                    std::make_unique<InlineCompletionOptions>(*other._inlineCompletionOptions)
                };
                break;
            }
            case ServerCapabilities_inlineCompletionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_inlineCompletionProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_inlineCompletionProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions: {
#ifdef DEBUG
            if (!_inlineCompletionOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _inlineCompletionOptions"
                );
            }
#endif // DEBUG
            _inlineCompletionOptions.~unique_ptr<InlineCompletionOptions>();
            _type =
                ServerCapabilities_inlineCompletionProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_inlineCompletionProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_inlineCompletionProvider::type() const
    -> const ServerCapabilities_inlineCompletionProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_inlineCompletionProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_inlineCompletionProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_inlineCompletionProvider::boolean()"
                 " of type "
                 "ServerCapabilities_inlineCompletionProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_inlineCompletionProviderType::" +
                 ServerCapabilities_inlineCompletionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_inlineCompletionProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_inlineCompletionProvider &
    {
        if (_type !=
                ServerCapabilities_inlineCompletionProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_inlineCompletionProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_inlineCompletionProvider::inlineCompletionOptions() const
    -> const InlineCompletionOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_inlineCompletionProvider::inlineCompletionOptions()"
                 " of type "
                 "ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions"
                 " while active type is "
                 "ServerCapabilities_inlineCompletionProviderType::" +
                 ServerCapabilities_inlineCompletionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_inlineCompletionOptions;
    }

    auto ServerCapabilities_inlineCompletionProvider::operator=(
        const std::unique_ptr<InlineCompletionOptions> &inlineCompletionOptions
    ) -> ServerCapabilities_inlineCompletionProvider &
    {
        if (_type !=
                ServerCapabilities_inlineCompletionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!inlineCompletionOptions) {
            throw std::logic_error(
                "null passed as the value of inlineCompletionOptions"
            );
        }
#endif // DEBUG
        new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
            std::make_unique<InlineCompletionOptions>(*inlineCompletionOptions)
        };
        _type =
            ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions;
        return *this;
    }

    auto ServerCapabilities_inlineCompletionProvider::operator=(
        std::unique_ptr<InlineCompletionOptions> &&inlineCompletionOptions
    ) -> ServerCapabilities_inlineCompletionProvider &
    {
        if (_type !=
                ServerCapabilities_inlineCompletionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!inlineCompletionOptions) {
            throw std::logic_error(
                "null passed as the value of inlineCompletionOptions"
            );
        }
#endif // DEBUG
        new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
            std::move(inlineCompletionOptions)
        };
        _type =
            ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions;
        return *this;
    }

    auto ServerCapabilities_inlineCompletionProvider::operator=(
        const InlineCompletionOptions &inlineCompletionOptions
    ) -> ServerCapabilities_inlineCompletionProvider &
    {
        if (_type !=
                ServerCapabilities_inlineCompletionProviderType::Uninitialized) {
            reset();
        }
        new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
            std::make_unique<InlineCompletionOptions>(inlineCompletionOptions)
        };
        _type =
            ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions;
        return *this;
    }

    auto ServerCapabilities_inlineCompletionProvider::operator=(
        InlineCompletionOptions &&inlineCompletionOptions
    ) -> ServerCapabilities_inlineCompletionProvider &
    {
        if (_type !=
                ServerCapabilities_inlineCompletionProviderType::Uninitialized) {
            reset();
        }
        new (&_inlineCompletionOptions) std::unique_ptr<InlineCompletionOptions> {
            std::make_unique<InlineCompletionOptions>(std::move(inlineCompletionOptions))
        };
        _type =
            ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions;
        return *this;
    }

    SaveOptions::SaveOptions()
    {
        // empty
    }

    SaveOptions::SaveOptions(SaveOptions &&other)
        : includeText(std::move(other.includeText))
    {
        // empty
    }

    SaveOptions::SaveOptions(const SaveOptions &other)
    {
        if (other.includeText.has_value()) {
            includeText = other.includeText.value();
        }
    }

    SaveOptions::~SaveOptions()
    {
        // empty
    }

    auto SaveOptions::operator=(SaveOptions &&other) -> SaveOptions &
    {
        if (this != &other) {
            includeText = std::move(other.includeText);
        }
        return *this;
    }

    auto SaveOptions::operator=(const SaveOptions &other) -> SaveOptions &
    {
        if (this != &other) {
            if (other.includeText.has_value()) {
                includeText = other.includeText.value();
            }
        }
        return *this;
    }

    CompletionOptions_completionItem::CompletionOptions_completionItem()
    {
        // empty
    }

    CompletionOptions_completionItem::CompletionOptions_completionItem(
        CompletionOptions_completionItem &&other
    )
        : labelDetailsSupport(std::move(other.labelDetailsSupport))
    {
        // empty
    }

    CompletionOptions_completionItem::CompletionOptions_completionItem(
        const CompletionOptions_completionItem &other
    )
    {
        if (other.labelDetailsSupport.has_value()) {
            labelDetailsSupport = other.labelDetailsSupport.value();
        }
    }

    CompletionOptions_completionItem::~CompletionOptions_completionItem()
    {
        // empty
    }

    auto CompletionOptions_completionItem::operator=(
        CompletionOptions_completionItem &&other
    ) -> CompletionOptions_completionItem &
    {
        if (this != &other) {
            labelDetailsSupport = std::move(other.labelDetailsSupport);
        }
        return *this;
    }

    auto CompletionOptions_completionItem::operator=(
        const CompletionOptions_completionItem &other
    ) -> CompletionOptions_completionItem &
    {
        if (this != &other) {
            if (other.labelDetailsSupport.has_value()) {
                labelDetailsSupport = other.labelDetailsSupport.value();
            }
        }
        return *this;
    }

    CompletionOptions::CompletionOptions()
    {
        // empty
    }

    CompletionOptions::CompletionOptions(CompletionOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , triggerCharacters(std::move(other.triggerCharacters))
        , allCommitCharacters(std::move(other.allCommitCharacters))
        , resolveProvider(std::move(other.resolveProvider))
        , completionItem(std::move(other.completionItem))
    {
        // empty
    }

    CompletionOptions::CompletionOptions(const CompletionOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.triggerCharacters.has_value()) {
            auto &array_0 = triggerCharacters.emplace();
            const auto &array_1 = other.triggerCharacters.value();
            array_0 = array_1;
        }
        if (other.allCommitCharacters.has_value()) {
            auto &array_2 = allCommitCharacters.emplace();
            const auto &array_3 = other.allCommitCharacters.value();
            array_2 = array_3;
        }
        if (other.resolveProvider.has_value()) {
            resolveProvider = other.resolveProvider.value();
        }
        if (other.completionItem.has_value()) {
            completionItem = other.completionItem.value();
        }
    }

    CompletionOptions::~CompletionOptions()
    {
        // empty
    }

    auto CompletionOptions::operator=(
        CompletionOptions &&other
    ) -> CompletionOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            triggerCharacters = std::move(other.triggerCharacters);
            allCommitCharacters = std::move(other.allCommitCharacters);
            resolveProvider = std::move(other.resolveProvider);
            completionItem = std::move(other.completionItem);
        }
        return *this;
    }

    auto CompletionOptions::operator=(
        const CompletionOptions &other
    ) -> CompletionOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.triggerCharacters.has_value()) {
                auto &array_0 = triggerCharacters.emplace();
                const auto &array_1 = other.triggerCharacters.value();
                array_0 = array_1;
            }
            if (other.allCommitCharacters.has_value()) {
                auto &array_2 = allCommitCharacters.emplace();
                const auto &array_3 = other.allCommitCharacters.value();
                array_2 = array_3;
            }
            if (other.resolveProvider.has_value()) {
                resolveProvider = other.resolveProvider.value();
            }
            if (other.completionItem.has_value()) {
                completionItem = other.completionItem.value();
            }
        }
        return *this;
    }

    HoverOptions::HoverOptions()
    {
        // empty
    }

    HoverOptions::HoverOptions(HoverOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    HoverOptions::HoverOptions(const HoverOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    HoverOptions::~HoverOptions()
    {
        // empty
    }

    auto HoverOptions::operator=(HoverOptions &&other) -> HoverOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto HoverOptions::operator=(const HoverOptions &other) -> HoverOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_hoverProviderType, std::string>
    ServerCapabilities_hoverProviderTypeNames = {
        {ServerCapabilities_hoverProviderType::Uninitialized, "Uninitialized"},
        {ServerCapabilities_hoverProviderType::Boolean, "Boolean"},
        {ServerCapabilities_hoverProviderType::HoverOptions, "HoverOptions"},
    };

    ServerCapabilities_hoverProvider::ServerCapabilities_hoverProvider()
    {
        // empty
    }

    ServerCapabilities_hoverProvider::~ServerCapabilities_hoverProvider()
    {
        reset();
    }

    ServerCapabilities_hoverProvider::ServerCapabilities_hoverProvider(
        ServerCapabilities_hoverProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_hoverProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_hoverProviderType::HoverOptions: {
            new (&_hoverOptions) std::unique_ptr<HoverOptions> {
                std::move(other._hoverOptions)
            };
            break;
        }
        case ServerCapabilities_hoverProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_hoverProviderType::Uninitialized;
    }

    ServerCapabilities_hoverProvider::ServerCapabilities_hoverProvider(
        const ServerCapabilities_hoverProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_hoverProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_hoverProviderType::HoverOptions: {
            new (&_hoverOptions) std::unique_ptr<HoverOptions> {
                std::make_unique<HoverOptions>(*other._hoverOptions)
            };
            break;
        }
        case ServerCapabilities_hoverProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_hoverProvider::operator=(
        ServerCapabilities_hoverProvider &&other
    ) -> ServerCapabilities_hoverProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_hoverProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_hoverProviderType::HoverOptions: {
                new (&_hoverOptions) std::unique_ptr<HoverOptions> {
                    std::move(other._hoverOptions)
                };
                break;
            }
            case ServerCapabilities_hoverProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = ServerCapabilities_hoverProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_hoverProvider::operator=(
        const ServerCapabilities_hoverProvider &other
    ) -> ServerCapabilities_hoverProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_hoverProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_hoverProviderType::HoverOptions: {
                new (&_hoverOptions) std::unique_ptr<HoverOptions> {
                    std::make_unique<HoverOptions>(*other._hoverOptions)
                };
                break;
            }
            case ServerCapabilities_hoverProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_hoverProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_hoverProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_hoverProviderType::HoverOptions: {
#ifdef DEBUG
            if (!_hoverOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _hoverOptions"
                );
            }
#endif // DEBUG
            _hoverOptions.~unique_ptr<HoverOptions>();
            _type = ServerCapabilities_hoverProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_hoverProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_hoverProvider::type() const
    -> const ServerCapabilities_hoverProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_hoverProvider::boolean() const -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_hoverProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_hoverProvider::boolean()"
                 " of type "
                 "ServerCapabilities_hoverProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_hoverProviderType::" +
                 ServerCapabilities_hoverProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_hoverProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_hoverProvider &
    {
        if (_type != ServerCapabilities_hoverProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_hoverProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_hoverProvider::hoverOptions() const
    -> const HoverOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_hoverProviderType::HoverOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_hoverProvider::hoverOptions()"
                 " of type "
                 "ServerCapabilities_hoverProviderType::HoverOptions"
                 " while active type is "
                 "ServerCapabilities_hoverProviderType::" +
                 ServerCapabilities_hoverProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_hoverOptions;
    }

    auto ServerCapabilities_hoverProvider::operator=(
        const std::unique_ptr<HoverOptions> &hoverOptions
    ) -> ServerCapabilities_hoverProvider &
    {
        if (_type != ServerCapabilities_hoverProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!hoverOptions) {
            throw std::logic_error("null passed as the value of hoverOptions");
        }
#endif // DEBUG
        new (&_hoverOptions) std::unique_ptr<HoverOptions> {
            std::make_unique<HoverOptions>(*hoverOptions)
        };
        _type = ServerCapabilities_hoverProviderType::HoverOptions;
        return *this;
    }

    auto ServerCapabilities_hoverProvider::operator=(
        std::unique_ptr<HoverOptions> &&hoverOptions
    ) -> ServerCapabilities_hoverProvider &
    {
        if (_type != ServerCapabilities_hoverProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!hoverOptions) {
            throw std::logic_error("null passed as the value of hoverOptions");
        }
#endif // DEBUG
        new (&_hoverOptions) std::unique_ptr<HoverOptions> {
            std::move(hoverOptions)
        };
        _type = ServerCapabilities_hoverProviderType::HoverOptions;
        return *this;
    }

    auto ServerCapabilities_hoverProvider::operator=(
        const HoverOptions &hoverOptions
    ) -> ServerCapabilities_hoverProvider &
    {
        if (_type != ServerCapabilities_hoverProviderType::Uninitialized) {
            reset();
        }
        new (&_hoverOptions) std::unique_ptr<HoverOptions> {
            std::make_unique<HoverOptions>(hoverOptions)
        };
        _type = ServerCapabilities_hoverProviderType::HoverOptions;
        return *this;
    }

    auto ServerCapabilities_hoverProvider::operator=(
        HoverOptions &&hoverOptions
    ) -> ServerCapabilities_hoverProvider &
    {
        if (_type != ServerCapabilities_hoverProviderType::Uninitialized) {
            reset();
        }
        new (&_hoverOptions) std::unique_ptr<HoverOptions> {
            std::make_unique<HoverOptions>(std::move(hoverOptions))
        };
        _type = ServerCapabilities_hoverProviderType::HoverOptions;
        return *this;
    }

    SignatureHelpOptions::SignatureHelpOptions()
    {
        // empty
    }

    SignatureHelpOptions::SignatureHelpOptions(SignatureHelpOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , triggerCharacters(std::move(other.triggerCharacters))
        , retriggerCharacters(std::move(other.retriggerCharacters))
    {
        // empty
    }

    SignatureHelpOptions::SignatureHelpOptions(
        const SignatureHelpOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.triggerCharacters.has_value()) {
            auto &array_0 = triggerCharacters.emplace();
            const auto &array_1 = other.triggerCharacters.value();
            array_0 = array_1;
        }
        if (other.retriggerCharacters.has_value()) {
            auto &array_2 = retriggerCharacters.emplace();
            const auto &array_3 = other.retriggerCharacters.value();
            array_2 = array_3;
        }
    }

    SignatureHelpOptions::~SignatureHelpOptions()
    {
        // empty
    }

    auto SignatureHelpOptions::operator=(
        SignatureHelpOptions &&other
    ) -> SignatureHelpOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            triggerCharacters = std::move(other.triggerCharacters);
            retriggerCharacters = std::move(other.retriggerCharacters);
        }
        return *this;
    }

    auto SignatureHelpOptions::operator=(
        const SignatureHelpOptions &other
    ) -> SignatureHelpOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.triggerCharacters.has_value()) {
                auto &array_0 = triggerCharacters.emplace();
                const auto &array_1 = other.triggerCharacters.value();
                array_0 = array_1;
            }
            if (other.retriggerCharacters.has_value()) {
                auto &array_2 = retriggerCharacters.emplace();
                const auto &array_3 = other.retriggerCharacters.value();
                array_2 = array_3;
            }
        }
        return *this;
    }

    DefinitionOptions::DefinitionOptions()
    {
        // empty
    }

    DefinitionOptions::DefinitionOptions(DefinitionOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    DefinitionOptions::DefinitionOptions(const DefinitionOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    DefinitionOptions::~DefinitionOptions()
    {
        // empty
    }

    auto DefinitionOptions::operator=(
        DefinitionOptions &&other
    ) -> DefinitionOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto DefinitionOptions::operator=(
        const DefinitionOptions &other
    ) -> DefinitionOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_definitionProviderType, std::string>
    ServerCapabilities_definitionProviderTypeNames = {
        {ServerCapabilities_definitionProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_definitionProviderType::Boolean, "Boolean"},
        {ServerCapabilities_definitionProviderType::DefinitionOptions,
         "DefinitionOptions"},
    };

    ServerCapabilities_definitionProvider::ServerCapabilities_definitionProvider()
    {
        // empty
    }

    ServerCapabilities_definitionProvider::~ServerCapabilities_definitionProvider()
    {
        reset();
    }

    ServerCapabilities_definitionProvider::ServerCapabilities_definitionProvider(
        ServerCapabilities_definitionProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_definitionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_definitionProviderType::DefinitionOptions: {
            new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
                std::move(other._definitionOptions)
            };
            break;
        }
        case ServerCapabilities_definitionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_definitionProviderType::Uninitialized;
    }

    ServerCapabilities_definitionProvider::ServerCapabilities_definitionProvider(
        const ServerCapabilities_definitionProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_definitionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_definitionProviderType::DefinitionOptions: {
            new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
                std::make_unique<DefinitionOptions>(*other._definitionOptions)
            };
            break;
        }
        case ServerCapabilities_definitionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_definitionProvider::operator=(
        ServerCapabilities_definitionProvider &&other
    ) -> ServerCapabilities_definitionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_definitionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_definitionProviderType::DefinitionOptions: {
                new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
                    std::move(other._definitionOptions)
                };
                break;
            }
            case ServerCapabilities_definitionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_definitionProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_definitionProvider::operator=(
        const ServerCapabilities_definitionProvider &other
    ) -> ServerCapabilities_definitionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_definitionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_definitionProviderType::DefinitionOptions: {
                new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
                    std::make_unique<DefinitionOptions>(*other._definitionOptions)
                };
                break;
            }
            case ServerCapabilities_definitionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_definitionProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_definitionProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_definitionProviderType::DefinitionOptions: {
#ifdef DEBUG
            if (!_definitionOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _definitionOptions"
                );
            }
#endif // DEBUG
            _definitionOptions.~unique_ptr<DefinitionOptions>();
            _type = ServerCapabilities_definitionProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_definitionProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_definitionProvider::type() const
    -> const ServerCapabilities_definitionProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_definitionProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_definitionProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_definitionProvider::boolean()"
                 " of type "
                 "ServerCapabilities_definitionProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_definitionProviderType::" +
                 ServerCapabilities_definitionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_definitionProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_definitionProvider &
    {
        if (_type !=
                ServerCapabilities_definitionProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_definitionProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_definitionProvider::definitionOptions() const
    -> const DefinitionOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_definitionProviderType::DefinitionOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_definitionProvider::definitionOptions()"
                 " of type "
                 "ServerCapabilities_definitionProviderType::DefinitionOptions"
                 " while active type is "
                 "ServerCapabilities_definitionProviderType::" +
                 ServerCapabilities_definitionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_definitionOptions;
    }

    auto ServerCapabilities_definitionProvider::operator=(
        const std::unique_ptr<DefinitionOptions> &definitionOptions
    ) -> ServerCapabilities_definitionProvider &
    {
        if (_type !=
                ServerCapabilities_definitionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!definitionOptions) {
            throw std::logic_error(
                "null passed as the value of definitionOptions"
            );
        }
#endif // DEBUG
        new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
            std::make_unique<DefinitionOptions>(*definitionOptions)
        };
        _type = ServerCapabilities_definitionProviderType::DefinitionOptions;
        return *this;
    }

    auto ServerCapabilities_definitionProvider::operator=(
        std::unique_ptr<DefinitionOptions> &&definitionOptions
    ) -> ServerCapabilities_definitionProvider &
    {
        if (_type !=
                ServerCapabilities_definitionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!definitionOptions) {
            throw std::logic_error(
                "null passed as the value of definitionOptions"
            );
        }
#endif // DEBUG
        new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
            std::move(definitionOptions)
        };
        _type = ServerCapabilities_definitionProviderType::DefinitionOptions;
        return *this;
    }

    auto ServerCapabilities_definitionProvider::operator=(
        const DefinitionOptions &definitionOptions
    ) -> ServerCapabilities_definitionProvider &
    {
        if (_type !=
                ServerCapabilities_definitionProviderType::Uninitialized) {
            reset();
        }
        new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
            std::make_unique<DefinitionOptions>(definitionOptions)
        };
        _type = ServerCapabilities_definitionProviderType::DefinitionOptions;
        return *this;
    }

    auto ServerCapabilities_definitionProvider::operator=(
        DefinitionOptions &&definitionOptions
    ) -> ServerCapabilities_definitionProvider &
    {
        if (_type !=
                ServerCapabilities_definitionProviderType::Uninitialized) {
            reset();
        }
        new (&_definitionOptions) std::unique_ptr<DefinitionOptions> {
            std::make_unique<DefinitionOptions>(std::move(definitionOptions))
        };
        _type = ServerCapabilities_definitionProviderType::DefinitionOptions;
        return *this;
    }

    ReferenceContext::ReferenceContext()
    {
        // empty
    }

    ReferenceContext::ReferenceContext(ReferenceContext &&other)
        : includeDeclaration(other.includeDeclaration)
    {
        // empty
    }

    ReferenceContext::ReferenceContext(const ReferenceContext &other)
        : includeDeclaration(other.includeDeclaration)
    {
    }

    ReferenceContext::~ReferenceContext()
    {
        // empty
    }

    auto ReferenceContext::operator=(
        ReferenceContext &&other
    ) -> ReferenceContext &
    {
        if (this != &other) {
            includeDeclaration = other.includeDeclaration;
        }
        return *this;
    }

    auto ReferenceContext::operator=(
        const ReferenceContext &other
    ) -> ReferenceContext &
    {
        if (this != &other) {
            includeDeclaration = other.includeDeclaration;
        }
        return *this;
    }

    ReferenceOptions::ReferenceOptions()
    {
        // empty
    }

    ReferenceOptions::ReferenceOptions(ReferenceOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    ReferenceOptions::ReferenceOptions(const ReferenceOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    ReferenceOptions::~ReferenceOptions()
    {
        // empty
    }

    auto ReferenceOptions::operator=(
        ReferenceOptions &&other
    ) -> ReferenceOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto ReferenceOptions::operator=(
        const ReferenceOptions &other
    ) -> ReferenceOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_referencesProviderType, std::string>
    ServerCapabilities_referencesProviderTypeNames = {
        {ServerCapabilities_referencesProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_referencesProviderType::Boolean, "Boolean"},
        {ServerCapabilities_referencesProviderType::ReferenceOptions,
         "ReferenceOptions"},
    };

    ServerCapabilities_referencesProvider::ServerCapabilities_referencesProvider()
    {
        // empty
    }

    ServerCapabilities_referencesProvider::~ServerCapabilities_referencesProvider()
    {
        reset();
    }

    ServerCapabilities_referencesProvider::ServerCapabilities_referencesProvider(
        ServerCapabilities_referencesProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_referencesProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_referencesProviderType::ReferenceOptions: {
            new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
                std::move(other._referenceOptions)
            };
            break;
        }
        case ServerCapabilities_referencesProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_referencesProviderType::Uninitialized;
    }

    ServerCapabilities_referencesProvider::ServerCapabilities_referencesProvider(
        const ServerCapabilities_referencesProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_referencesProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_referencesProviderType::ReferenceOptions: {
            new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
                std::make_unique<ReferenceOptions>(*other._referenceOptions)
            };
            break;
        }
        case ServerCapabilities_referencesProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_referencesProvider::operator=(
        ServerCapabilities_referencesProvider &&other
    ) -> ServerCapabilities_referencesProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_referencesProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_referencesProviderType::ReferenceOptions: {
                new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
                    std::move(other._referenceOptions)
                };
                break;
            }
            case ServerCapabilities_referencesProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_referencesProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_referencesProvider::operator=(
        const ServerCapabilities_referencesProvider &other
    ) -> ServerCapabilities_referencesProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_referencesProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_referencesProviderType::ReferenceOptions: {
                new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
                    std::make_unique<ReferenceOptions>(*other._referenceOptions)
                };
                break;
            }
            case ServerCapabilities_referencesProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_referencesProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_referencesProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_referencesProviderType::ReferenceOptions: {
#ifdef DEBUG
            if (!_referenceOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _referenceOptions"
                );
            }
#endif // DEBUG
            _referenceOptions.~unique_ptr<ReferenceOptions>();
            _type = ServerCapabilities_referencesProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_referencesProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_referencesProvider::type() const
    -> const ServerCapabilities_referencesProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_referencesProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_referencesProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_referencesProvider::boolean()"
                 " of type "
                 "ServerCapabilities_referencesProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_referencesProviderType::" +
                 ServerCapabilities_referencesProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_referencesProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_referencesProvider &
    {
        if (_type !=
                ServerCapabilities_referencesProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_referencesProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_referencesProvider::referenceOptions() const
    -> const ReferenceOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_referencesProviderType::ReferenceOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_referencesProvider::referenceOptions()"
                 " of type "
                 "ServerCapabilities_referencesProviderType::ReferenceOptions"
                 " while active type is "
                 "ServerCapabilities_referencesProviderType::" +
                 ServerCapabilities_referencesProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_referenceOptions;
    }

    auto ServerCapabilities_referencesProvider::operator=(
        const std::unique_ptr<ReferenceOptions> &referenceOptions
    ) -> ServerCapabilities_referencesProvider &
    {
        if (_type !=
                ServerCapabilities_referencesProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!referenceOptions) {
            throw std::logic_error(
                "null passed as the value of referenceOptions"
            );
        }
#endif // DEBUG
        new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
            std::make_unique<ReferenceOptions>(*referenceOptions)
        };
        _type = ServerCapabilities_referencesProviderType::ReferenceOptions;
        return *this;
    }

    auto ServerCapabilities_referencesProvider::operator=(
        std::unique_ptr<ReferenceOptions> &&referenceOptions
    ) -> ServerCapabilities_referencesProvider &
    {
        if (_type !=
                ServerCapabilities_referencesProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!referenceOptions) {
            throw std::logic_error(
                "null passed as the value of referenceOptions"
            );
        }
#endif // DEBUG
        new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
            std::move(referenceOptions)
        };
        _type = ServerCapabilities_referencesProviderType::ReferenceOptions;
        return *this;
    }

    auto ServerCapabilities_referencesProvider::operator=(
        const ReferenceOptions &referenceOptions
    ) -> ServerCapabilities_referencesProvider &
    {
        if (_type !=
                ServerCapabilities_referencesProviderType::Uninitialized) {
            reset();
        }
        new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
            std::make_unique<ReferenceOptions>(referenceOptions)
        };
        _type = ServerCapabilities_referencesProviderType::ReferenceOptions;
        return *this;
    }

    auto ServerCapabilities_referencesProvider::operator=(
        ReferenceOptions &&referenceOptions
    ) -> ServerCapabilities_referencesProvider &
    {
        if (_type !=
                ServerCapabilities_referencesProviderType::Uninitialized) {
            reset();
        }
        new (&_referenceOptions) std::unique_ptr<ReferenceOptions> {
            std::make_unique<ReferenceOptions>(std::move(referenceOptions))
        };
        _type = ServerCapabilities_referencesProviderType::ReferenceOptions;
        return *this;
    }

    DocumentHighlightOptions::DocumentHighlightOptions()
    {
        // empty
    }

    DocumentHighlightOptions::DocumentHighlightOptions(
        DocumentHighlightOptions &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    DocumentHighlightOptions::DocumentHighlightOptions(
        const DocumentHighlightOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    DocumentHighlightOptions::~DocumentHighlightOptions()
    {
        // empty
    }

    auto DocumentHighlightOptions::operator=(
        DocumentHighlightOptions &&other
    ) -> DocumentHighlightOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto DocumentHighlightOptions::operator=(
        const DocumentHighlightOptions &other
    ) -> DocumentHighlightOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    const std::map<
        ServerCapabilities_documentHighlightProviderType,
        std::string
    > ServerCapabilities_documentHighlightProviderTypeNames = {
        {ServerCapabilities_documentHighlightProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_documentHighlightProviderType::Boolean, "Boolean"},
        {ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions,
         "DocumentHighlightOptions"},
    };

    ServerCapabilities_documentHighlightProvider::ServerCapabilities_documentHighlightProvider()
    {
        // empty
    }

    ServerCapabilities_documentHighlightProvider::~ServerCapabilities_documentHighlightProvider()
    {
        reset();
    }

    ServerCapabilities_documentHighlightProvider::ServerCapabilities_documentHighlightProvider(
        ServerCapabilities_documentHighlightProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentHighlightProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions: {
            new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
                std::move(other._documentHighlightOptions)
            };
            break;
        }
        case ServerCapabilities_documentHighlightProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_documentHighlightProviderType::Uninitialized;
    }

    ServerCapabilities_documentHighlightProvider::ServerCapabilities_documentHighlightProvider(
        const ServerCapabilities_documentHighlightProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentHighlightProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions: {
            new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
                std::make_unique<DocumentHighlightOptions>(*other._documentHighlightOptions)
            };
            break;
        }
        case ServerCapabilities_documentHighlightProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_documentHighlightProvider::operator=(
        ServerCapabilities_documentHighlightProvider &&other
    ) -> ServerCapabilities_documentHighlightProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentHighlightProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions: {
                new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
                    std::move(other._documentHighlightOptions)
                };
                break;
            }
            case ServerCapabilities_documentHighlightProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_documentHighlightProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_documentHighlightProvider::operator=(
        const ServerCapabilities_documentHighlightProvider &other
    ) -> ServerCapabilities_documentHighlightProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentHighlightProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions: {
                new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
                    std::make_unique<DocumentHighlightOptions>(*other._documentHighlightOptions)
                };
                break;
            }
            case ServerCapabilities_documentHighlightProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_documentHighlightProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_documentHighlightProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions: {
#ifdef DEBUG
            if (!_documentHighlightOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentHighlightOptions"
                );
            }
#endif // DEBUG
            _documentHighlightOptions.~unique_ptr<DocumentHighlightOptions>();
            _type =
                ServerCapabilities_documentHighlightProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_documentHighlightProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_documentHighlightProvider::type() const
    -> const ServerCapabilities_documentHighlightProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_documentHighlightProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentHighlightProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentHighlightProvider::boolean()"
                 " of type "
                 "ServerCapabilities_documentHighlightProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_documentHighlightProviderType::" +
                 ServerCapabilities_documentHighlightProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_documentHighlightProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_documentHighlightProvider &
    {
        if (_type !=
                ServerCapabilities_documentHighlightProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_documentHighlightProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_documentHighlightProvider::documentHighlightOptions() const
    -> const DocumentHighlightOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentHighlightProvider::documentHighlightOptions()"
                 " of type "
                 "ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions"
                 " while active type is "
                 "ServerCapabilities_documentHighlightProviderType::" +
                 ServerCapabilities_documentHighlightProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentHighlightOptions;
    }

    auto ServerCapabilities_documentHighlightProvider::operator=(
        const std::unique_ptr<DocumentHighlightOptions> &documentHighlightOptions
    ) -> ServerCapabilities_documentHighlightProvider &
    {
        if (_type !=
                ServerCapabilities_documentHighlightProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentHighlightOptions) {
            throw std::logic_error(
                "null passed as the value of documentHighlightOptions"
            );
        }
#endif // DEBUG
        new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
            std::make_unique<DocumentHighlightOptions>(*documentHighlightOptions)
        };
        _type =
            ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions;
        return *this;
    }

    auto ServerCapabilities_documentHighlightProvider::operator=(
        std::unique_ptr<DocumentHighlightOptions> &&documentHighlightOptions
    ) -> ServerCapabilities_documentHighlightProvider &
    {
        if (_type !=
                ServerCapabilities_documentHighlightProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentHighlightOptions) {
            throw std::logic_error(
                "null passed as the value of documentHighlightOptions"
            );
        }
#endif // DEBUG
        new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
            std::move(documentHighlightOptions)
        };
        _type =
            ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions;
        return *this;
    }

    auto ServerCapabilities_documentHighlightProvider::operator=(
        const DocumentHighlightOptions &documentHighlightOptions
    ) -> ServerCapabilities_documentHighlightProvider &
    {
        if (_type !=
                ServerCapabilities_documentHighlightProviderType::Uninitialized) {
            reset();
        }
        new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
            std::make_unique<DocumentHighlightOptions>(documentHighlightOptions)
        };
        _type =
            ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions;
        return *this;
    }

    auto ServerCapabilities_documentHighlightProvider::operator=(
        DocumentHighlightOptions &&documentHighlightOptions
    ) -> ServerCapabilities_documentHighlightProvider &
    {
        if (_type !=
                ServerCapabilities_documentHighlightProviderType::Uninitialized) {
            reset();
        }
        new (&_documentHighlightOptions) std::unique_ptr<DocumentHighlightOptions> {
            std::make_unique<DocumentHighlightOptions>(std::move(documentHighlightOptions))
        };
        _type =
            ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions;
        return *this;
    }

    DocumentSymbolOptions::DocumentSymbolOptions()
    {
        // empty
    }

    DocumentSymbolOptions::DocumentSymbolOptions(DocumentSymbolOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , label(std::move(other.label))
    {
        // empty
    }

    DocumentSymbolOptions::DocumentSymbolOptions(
        const DocumentSymbolOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.label.has_value()) {
            label = other.label.value();
        }
    }

    DocumentSymbolOptions::~DocumentSymbolOptions()
    {
        // empty
    }

    auto DocumentSymbolOptions::operator=(
        DocumentSymbolOptions &&other
    ) -> DocumentSymbolOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            label = std::move(other.label);
        }
        return *this;
    }

    auto DocumentSymbolOptions::operator=(
        const DocumentSymbolOptions &other
    ) -> DocumentSymbolOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.label.has_value()) {
                label = other.label.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_documentSymbolProviderType, std::string>
    ServerCapabilities_documentSymbolProviderTypeNames = {
        {ServerCapabilities_documentSymbolProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_documentSymbolProviderType::Boolean, "Boolean"},
        {ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions,
         "DocumentSymbolOptions"},
    };

    ServerCapabilities_documentSymbolProvider::ServerCapabilities_documentSymbolProvider()
    {
        // empty
    }

    ServerCapabilities_documentSymbolProvider::~ServerCapabilities_documentSymbolProvider()
    {
        reset();
    }

    ServerCapabilities_documentSymbolProvider::ServerCapabilities_documentSymbolProvider(
        ServerCapabilities_documentSymbolProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentSymbolProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions: {
            new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
                std::move(other._documentSymbolOptions)
            };
            break;
        }
        case ServerCapabilities_documentSymbolProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_documentSymbolProviderType::Uninitialized;
    }

    ServerCapabilities_documentSymbolProvider::ServerCapabilities_documentSymbolProvider(
        const ServerCapabilities_documentSymbolProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentSymbolProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions: {
            new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
                std::make_unique<DocumentSymbolOptions>(*other._documentSymbolOptions)
            };
            break;
        }
        case ServerCapabilities_documentSymbolProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_documentSymbolProvider::operator=(
        ServerCapabilities_documentSymbolProvider &&other
    ) -> ServerCapabilities_documentSymbolProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentSymbolProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions: {
                new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
                    std::move(other._documentSymbolOptions)
                };
                break;
            }
            case ServerCapabilities_documentSymbolProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_documentSymbolProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_documentSymbolProvider::operator=(
        const ServerCapabilities_documentSymbolProvider &other
    ) -> ServerCapabilities_documentSymbolProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentSymbolProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions: {
                new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
                    std::make_unique<DocumentSymbolOptions>(*other._documentSymbolOptions)
                };
                break;
            }
            case ServerCapabilities_documentSymbolProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_documentSymbolProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_documentSymbolProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions: {
#ifdef DEBUG
            if (!_documentSymbolOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentSymbolOptions"
                );
            }
#endif // DEBUG
            _documentSymbolOptions.~unique_ptr<DocumentSymbolOptions>();
            _type =
                ServerCapabilities_documentSymbolProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_documentSymbolProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_documentSymbolProvider::type() const
    -> const ServerCapabilities_documentSymbolProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_documentSymbolProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentSymbolProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentSymbolProvider::boolean()"
                 " of type "
                 "ServerCapabilities_documentSymbolProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_documentSymbolProviderType::" +
                 ServerCapabilities_documentSymbolProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_documentSymbolProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_documentSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_documentSymbolProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_documentSymbolProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_documentSymbolProvider::documentSymbolOptions() const
    -> const DocumentSymbolOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentSymbolProvider::documentSymbolOptions()"
                 " of type "
                 "ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions"
                 " while active type is "
                 "ServerCapabilities_documentSymbolProviderType::" +
                 ServerCapabilities_documentSymbolProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentSymbolOptions;
    }

    auto ServerCapabilities_documentSymbolProvider::operator=(
        const std::unique_ptr<DocumentSymbolOptions> &documentSymbolOptions
    ) -> ServerCapabilities_documentSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_documentSymbolProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentSymbolOptions) {
            throw std::logic_error(
                "null passed as the value of documentSymbolOptions"
            );
        }
#endif // DEBUG
        new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
            std::make_unique<DocumentSymbolOptions>(*documentSymbolOptions)
        };
        _type =
            ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions;
        return *this;
    }

    auto ServerCapabilities_documentSymbolProvider::operator=(
        std::unique_ptr<DocumentSymbolOptions> &&documentSymbolOptions
    ) -> ServerCapabilities_documentSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_documentSymbolProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentSymbolOptions) {
            throw std::logic_error(
                "null passed as the value of documentSymbolOptions"
            );
        }
#endif // DEBUG
        new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
            std::move(documentSymbolOptions)
        };
        _type =
            ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions;
        return *this;
    }

    auto ServerCapabilities_documentSymbolProvider::operator=(
        const DocumentSymbolOptions &documentSymbolOptions
    ) -> ServerCapabilities_documentSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_documentSymbolProviderType::Uninitialized) {
            reset();
        }
        new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
            std::make_unique<DocumentSymbolOptions>(documentSymbolOptions)
        };
        _type =
            ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions;
        return *this;
    }

    auto ServerCapabilities_documentSymbolProvider::operator=(
        DocumentSymbolOptions &&documentSymbolOptions
    ) -> ServerCapabilities_documentSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_documentSymbolProviderType::Uninitialized) {
            reset();
        }
        new (&_documentSymbolOptions) std::unique_ptr<DocumentSymbolOptions> {
            std::make_unique<DocumentSymbolOptions>(std::move(documentSymbolOptions))
        };
        _type =
            ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions;
        return *this;
    }

    CodeActionOptions::CodeActionOptions()
    {
        // empty
    }

    CodeActionOptions::CodeActionOptions(CodeActionOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , codeActionKinds(std::move(other.codeActionKinds))
        , resolveProvider(std::move(other.resolveProvider))
    {
        // empty
    }

    CodeActionOptions::CodeActionOptions(const CodeActionOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.codeActionKinds.has_value()) {
            auto &array_0 = codeActionKinds.emplace();
            const auto &array_1 = other.codeActionKinds.value();
            array_0 = array_1;
        }
        if (other.resolveProvider.has_value()) {
            resolveProvider = other.resolveProvider.value();
        }
    }

    CodeActionOptions::~CodeActionOptions()
    {
        // empty
    }

    auto CodeActionOptions::operator=(
        CodeActionOptions &&other
    ) -> CodeActionOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            codeActionKinds = std::move(other.codeActionKinds);
            resolveProvider = std::move(other.resolveProvider);
        }
        return *this;
    }

    auto CodeActionOptions::operator=(
        const CodeActionOptions &other
    ) -> CodeActionOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.codeActionKinds.has_value()) {
                auto &array_0 = codeActionKinds.emplace();
                const auto &array_1 = other.codeActionKinds.value();
                array_0 = array_1;
            }
            if (other.resolveProvider.has_value()) {
                resolveProvider = other.resolveProvider.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_codeActionProviderType, std::string>
    ServerCapabilities_codeActionProviderTypeNames = {
        {ServerCapabilities_codeActionProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_codeActionProviderType::Boolean, "Boolean"},
        {ServerCapabilities_codeActionProviderType::CodeActionOptions,
         "CodeActionOptions"},
    };

    ServerCapabilities_codeActionProvider::ServerCapabilities_codeActionProvider()
    {
        // empty
    }

    ServerCapabilities_codeActionProvider::~ServerCapabilities_codeActionProvider()
    {
        reset();
    }

    ServerCapabilities_codeActionProvider::ServerCapabilities_codeActionProvider(
        ServerCapabilities_codeActionProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_codeActionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_codeActionProviderType::CodeActionOptions: {
            new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
                std::move(other._codeActionOptions)
            };
            break;
        }
        case ServerCapabilities_codeActionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_codeActionProviderType::Uninitialized;
    }

    ServerCapabilities_codeActionProvider::ServerCapabilities_codeActionProvider(
        const ServerCapabilities_codeActionProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_codeActionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_codeActionProviderType::CodeActionOptions: {
            new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
                std::make_unique<CodeActionOptions>(*other._codeActionOptions)
            };
            break;
        }
        case ServerCapabilities_codeActionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_codeActionProvider::operator=(
        ServerCapabilities_codeActionProvider &&other
    ) -> ServerCapabilities_codeActionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_codeActionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_codeActionProviderType::CodeActionOptions: {
                new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
                    std::move(other._codeActionOptions)
                };
                break;
            }
            case ServerCapabilities_codeActionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_codeActionProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_codeActionProvider::operator=(
        const ServerCapabilities_codeActionProvider &other
    ) -> ServerCapabilities_codeActionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_codeActionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_codeActionProviderType::CodeActionOptions: {
                new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
                    std::make_unique<CodeActionOptions>(*other._codeActionOptions)
                };
                break;
            }
            case ServerCapabilities_codeActionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_codeActionProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_codeActionProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_codeActionProviderType::CodeActionOptions: {
#ifdef DEBUG
            if (!_codeActionOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _codeActionOptions"
                );
            }
#endif // DEBUG
            _codeActionOptions.~unique_ptr<CodeActionOptions>();
            _type = ServerCapabilities_codeActionProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_codeActionProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_codeActionProvider::type() const
    -> const ServerCapabilities_codeActionProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_codeActionProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_codeActionProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_codeActionProvider::boolean()"
                 " of type "
                 "ServerCapabilities_codeActionProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_codeActionProviderType::" +
                 ServerCapabilities_codeActionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_codeActionProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_codeActionProvider &
    {
        if (_type !=
                ServerCapabilities_codeActionProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_codeActionProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_codeActionProvider::codeActionOptions() const
    -> const CodeActionOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_codeActionProviderType::CodeActionOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_codeActionProvider::codeActionOptions()"
                 " of type "
                 "ServerCapabilities_codeActionProviderType::CodeActionOptions"
                 " while active type is "
                 "ServerCapabilities_codeActionProviderType::" +
                 ServerCapabilities_codeActionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_codeActionOptions;
    }

    auto ServerCapabilities_codeActionProvider::operator=(
        const std::unique_ptr<CodeActionOptions> &codeActionOptions
    ) -> ServerCapabilities_codeActionProvider &
    {
        if (_type !=
                ServerCapabilities_codeActionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!codeActionOptions) {
            throw std::logic_error(
                "null passed as the value of codeActionOptions"
            );
        }
#endif // DEBUG
        new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
            std::make_unique<CodeActionOptions>(*codeActionOptions)
        };
        _type = ServerCapabilities_codeActionProviderType::CodeActionOptions;
        return *this;
    }

    auto ServerCapabilities_codeActionProvider::operator=(
        std::unique_ptr<CodeActionOptions> &&codeActionOptions
    ) -> ServerCapabilities_codeActionProvider &
    {
        if (_type !=
                ServerCapabilities_codeActionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!codeActionOptions) {
            throw std::logic_error(
                "null passed as the value of codeActionOptions"
            );
        }
#endif // DEBUG
        new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
            std::move(codeActionOptions)
        };
        _type = ServerCapabilities_codeActionProviderType::CodeActionOptions;
        return *this;
    }

    auto ServerCapabilities_codeActionProvider::operator=(
        const CodeActionOptions &codeActionOptions
    ) -> ServerCapabilities_codeActionProvider &
    {
        if (_type !=
                ServerCapabilities_codeActionProviderType::Uninitialized) {
            reset();
        }
        new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
            std::make_unique<CodeActionOptions>(codeActionOptions)
        };
        _type = ServerCapabilities_codeActionProviderType::CodeActionOptions;
        return *this;
    }

    auto ServerCapabilities_codeActionProvider::operator=(
        CodeActionOptions &&codeActionOptions
    ) -> ServerCapabilities_codeActionProvider &
    {
        if (_type !=
                ServerCapabilities_codeActionProviderType::Uninitialized) {
            reset();
        }
        new (&_codeActionOptions) std::unique_ptr<CodeActionOptions> {
            std::make_unique<CodeActionOptions>(std::move(codeActionOptions))
        };
        _type = ServerCapabilities_codeActionProviderType::CodeActionOptions;
        return *this;
    }

    WorkspaceSymbolOptions::WorkspaceSymbolOptions()
    {
        // empty
    }

    WorkspaceSymbolOptions::WorkspaceSymbolOptions(
        WorkspaceSymbolOptions &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
        , resolveProvider(std::move(other.resolveProvider))
    {
        // empty
    }

    WorkspaceSymbolOptions::WorkspaceSymbolOptions(
        const WorkspaceSymbolOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.resolveProvider.has_value()) {
            resolveProvider = other.resolveProvider.value();
        }
    }

    WorkspaceSymbolOptions::~WorkspaceSymbolOptions()
    {
        // empty
    }

    auto WorkspaceSymbolOptions::operator=(
        WorkspaceSymbolOptions &&other
    ) -> WorkspaceSymbolOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            resolveProvider = std::move(other.resolveProvider);
        }
        return *this;
    }

    auto WorkspaceSymbolOptions::operator=(
        const WorkspaceSymbolOptions &other
    ) -> WorkspaceSymbolOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.resolveProvider.has_value()) {
                resolveProvider = other.resolveProvider.value();
            }
        }
        return *this;
    }

    WorkspaceSymbolRegistrationOptions::WorkspaceSymbolRegistrationOptions()
        : WorkspaceSymbolOptions()
    {
        // empty
    }

    WorkspaceSymbolRegistrationOptions::WorkspaceSymbolRegistrationOptions(
        WorkspaceSymbolRegistrationOptions &&other
    )
        : WorkspaceSymbolOptions(other)
    {
        // empty
    }

    WorkspaceSymbolRegistrationOptions::WorkspaceSymbolRegistrationOptions(
        const WorkspaceSymbolRegistrationOptions &other
    )
        : WorkspaceSymbolOptions(other)
    {
    }

    WorkspaceSymbolRegistrationOptions::~WorkspaceSymbolRegistrationOptions()
    {
        // empty
    }

    auto WorkspaceSymbolRegistrationOptions::operator=(
        WorkspaceSymbolRegistrationOptions &&other
    ) -> WorkspaceSymbolRegistrationOptions &
    {
        if (this != &other) {
            WorkspaceSymbolOptions::operator=(other);
        }
        return *this;
    }

    auto WorkspaceSymbolRegistrationOptions::operator=(
        const WorkspaceSymbolRegistrationOptions &other
    ) -> WorkspaceSymbolRegistrationOptions &
    {
        if (this != &other) {
            WorkspaceSymbolOptions::operator=(other);
        }
        return *this;
    }

    const std::map<ServerCapabilities_workspaceSymbolProviderType, std::string>
    ServerCapabilities_workspaceSymbolProviderTypeNames = {
        {ServerCapabilities_workspaceSymbolProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_workspaceSymbolProviderType::Boolean, "Boolean"},
        {ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions,
         "WorkspaceSymbolOptions"},
    };

    ServerCapabilities_workspaceSymbolProvider::ServerCapabilities_workspaceSymbolProvider()
    {
        // empty
    }

    ServerCapabilities_workspaceSymbolProvider::~ServerCapabilities_workspaceSymbolProvider()
    {
        reset();
    }

    ServerCapabilities_workspaceSymbolProvider::ServerCapabilities_workspaceSymbolProvider(
        ServerCapabilities_workspaceSymbolProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_workspaceSymbolProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions: {
            new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
                std::move(other._workspaceSymbolOptions)
            };
            break;
        }
        case ServerCapabilities_workspaceSymbolProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_workspaceSymbolProviderType::Uninitialized;
    }

    ServerCapabilities_workspaceSymbolProvider::ServerCapabilities_workspaceSymbolProvider(
        const ServerCapabilities_workspaceSymbolProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_workspaceSymbolProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions: {
            new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
                std::make_unique<WorkspaceSymbolOptions>(*other._workspaceSymbolOptions)
            };
            break;
        }
        case ServerCapabilities_workspaceSymbolProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_workspaceSymbolProvider::operator=(
        ServerCapabilities_workspaceSymbolProvider &&other
    ) -> ServerCapabilities_workspaceSymbolProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_workspaceSymbolProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions: {
                new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
                    std::move(other._workspaceSymbolOptions)
                };
                break;
            }
            case ServerCapabilities_workspaceSymbolProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_workspaceSymbolProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_workspaceSymbolProvider::operator=(
        const ServerCapabilities_workspaceSymbolProvider &other
    ) -> ServerCapabilities_workspaceSymbolProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_workspaceSymbolProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions: {
                new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
                    std::make_unique<WorkspaceSymbolOptions>(*other._workspaceSymbolOptions)
                };
                break;
            }
            case ServerCapabilities_workspaceSymbolProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_workspaceSymbolProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_workspaceSymbolProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions: {
#ifdef DEBUG
            if (!_workspaceSymbolOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _workspaceSymbolOptions"
                );
            }
#endif // DEBUG
            _workspaceSymbolOptions.~unique_ptr<WorkspaceSymbolOptions>();
            _type =
                ServerCapabilities_workspaceSymbolProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_workspaceSymbolProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_workspaceSymbolProvider::type() const
    -> const ServerCapabilities_workspaceSymbolProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_workspaceSymbolProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_workspaceSymbolProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_workspaceSymbolProvider::boolean()"
                 " of type "
                 "ServerCapabilities_workspaceSymbolProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_workspaceSymbolProviderType::" +
                 ServerCapabilities_workspaceSymbolProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_workspaceSymbolProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_workspaceSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_workspaceSymbolProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_workspaceSymbolProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_workspaceSymbolProvider::workspaceSymbolOptions() const
    -> const WorkspaceSymbolOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_workspaceSymbolProvider::workspaceSymbolOptions()"
                 " of type "
                 "ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions"
                 " while active type is "
                 "ServerCapabilities_workspaceSymbolProviderType::" +
                 ServerCapabilities_workspaceSymbolProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_workspaceSymbolOptions;
    }

    auto ServerCapabilities_workspaceSymbolProvider::operator=(
        const std::unique_ptr<WorkspaceSymbolOptions> &workspaceSymbolOptions
    ) -> ServerCapabilities_workspaceSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_workspaceSymbolProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!workspaceSymbolOptions) {
            throw std::logic_error(
                "null passed as the value of workspaceSymbolOptions"
            );
        }
#endif // DEBUG
        new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
            std::make_unique<WorkspaceSymbolOptions>(*workspaceSymbolOptions)
        };
        _type =
            ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions;
        return *this;
    }

    auto ServerCapabilities_workspaceSymbolProvider::operator=(
        std::unique_ptr<WorkspaceSymbolOptions> &&workspaceSymbolOptions
    ) -> ServerCapabilities_workspaceSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_workspaceSymbolProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!workspaceSymbolOptions) {
            throw std::logic_error(
                "null passed as the value of workspaceSymbolOptions"
            );
        }
#endif // DEBUG
        new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
            std::move(workspaceSymbolOptions)
        };
        _type =
            ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions;
        return *this;
    }

    auto ServerCapabilities_workspaceSymbolProvider::operator=(
        const WorkspaceSymbolOptions &workspaceSymbolOptions
    ) -> ServerCapabilities_workspaceSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_workspaceSymbolProviderType::Uninitialized) {
            reset();
        }
        new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
            std::make_unique<WorkspaceSymbolOptions>(workspaceSymbolOptions)
        };
        _type =
            ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions;
        return *this;
    }

    auto ServerCapabilities_workspaceSymbolProvider::operator=(
        WorkspaceSymbolOptions &&workspaceSymbolOptions
    ) -> ServerCapabilities_workspaceSymbolProvider &
    {
        if (_type !=
                ServerCapabilities_workspaceSymbolProviderType::Uninitialized) {
            reset();
        }
        new (&_workspaceSymbolOptions) std::unique_ptr<WorkspaceSymbolOptions> {
            std::make_unique<WorkspaceSymbolOptions>(std::move(workspaceSymbolOptions))
        };
        _type =
            ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions;
        return *this;
    }

    CodeLensOptions::CodeLensOptions()
    {
        // empty
    }

    CodeLensOptions::CodeLensOptions(CodeLensOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , resolveProvider(std::move(other.resolveProvider))
    {
        // empty
    }

    CodeLensOptions::CodeLensOptions(const CodeLensOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.resolveProvider.has_value()) {
            resolveProvider = other.resolveProvider.value();
        }
    }

    CodeLensOptions::~CodeLensOptions()
    {
        // empty
    }

    auto CodeLensOptions::operator=(
        CodeLensOptions &&other
    ) -> CodeLensOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            resolveProvider = std::move(other.resolveProvider);
        }
        return *this;
    }

    auto CodeLensOptions::operator=(
        const CodeLensOptions &other
    ) -> CodeLensOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.resolveProvider.has_value()) {
                resolveProvider = other.resolveProvider.value();
            }
        }
        return *this;
    }

    DocumentLinkOptions::DocumentLinkOptions()
    {
        // empty
    }

    DocumentLinkOptions::DocumentLinkOptions(DocumentLinkOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , resolveProvider(std::move(other.resolveProvider))
    {
        // empty
    }

    DocumentLinkOptions::DocumentLinkOptions(const DocumentLinkOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.resolveProvider.has_value()) {
            resolveProvider = other.resolveProvider.value();
        }
    }

    DocumentLinkOptions::~DocumentLinkOptions()
    {
        // empty
    }

    auto DocumentLinkOptions::operator=(
        DocumentLinkOptions &&other
    ) -> DocumentLinkOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            resolveProvider = std::move(other.resolveProvider);
        }
        return *this;
    }

    auto DocumentLinkOptions::operator=(
        const DocumentLinkOptions &other
    ) -> DocumentLinkOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.resolveProvider.has_value()) {
                resolveProvider = other.resolveProvider.value();
            }
        }
        return *this;
    }

    DocumentFormattingOptions::DocumentFormattingOptions()
    {
        // empty
    }

    DocumentFormattingOptions::DocumentFormattingOptions(
        DocumentFormattingOptions &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
    {
        // empty
    }

    DocumentFormattingOptions::DocumentFormattingOptions(
        const DocumentFormattingOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
    }

    DocumentFormattingOptions::~DocumentFormattingOptions()
    {
        // empty
    }

    auto DocumentFormattingOptions::operator=(
        DocumentFormattingOptions &&other
    ) -> DocumentFormattingOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
        }
        return *this;
    }

    auto DocumentFormattingOptions::operator=(
        const DocumentFormattingOptions &other
    ) -> DocumentFormattingOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
        }
        return *this;
    }

    const std::map<
        ServerCapabilities_documentFormattingProviderType,
        std::string
    > ServerCapabilities_documentFormattingProviderTypeNames = {
        {ServerCapabilities_documentFormattingProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_documentFormattingProviderType::Boolean,
         "Boolean"},
        {ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions,
         "DocumentFormattingOptions"},
    };

    ServerCapabilities_documentFormattingProvider::ServerCapabilities_documentFormattingProvider()
    {
        // empty
    }

    ServerCapabilities_documentFormattingProvider::~ServerCapabilities_documentFormattingProvider()
    {
        reset();
    }

    ServerCapabilities_documentFormattingProvider::ServerCapabilities_documentFormattingProvider(
        ServerCapabilities_documentFormattingProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentFormattingProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions: {
            new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
                std::move(other._documentFormattingOptions)
            };
            break;
        }
        case ServerCapabilities_documentFormattingProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_documentFormattingProviderType::Uninitialized;
    }

    ServerCapabilities_documentFormattingProvider::ServerCapabilities_documentFormattingProvider(
        const ServerCapabilities_documentFormattingProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentFormattingProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions: {
            new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
                std::make_unique<DocumentFormattingOptions>(*other._documentFormattingOptions)
            };
            break;
        }
        case ServerCapabilities_documentFormattingProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_documentFormattingProvider::operator=(
        ServerCapabilities_documentFormattingProvider &&other
    ) -> ServerCapabilities_documentFormattingProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentFormattingProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions: {
                new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
                    std::move(other._documentFormattingOptions)
                };
                break;
            }
            case ServerCapabilities_documentFormattingProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_documentFormattingProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_documentFormattingProvider::operator=(
        const ServerCapabilities_documentFormattingProvider &other
    ) -> ServerCapabilities_documentFormattingProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentFormattingProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions: {
                new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
                    std::make_unique<DocumentFormattingOptions>(*other._documentFormattingOptions)
                };
                break;
            }
            case ServerCapabilities_documentFormattingProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_documentFormattingProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_documentFormattingProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions: {
#ifdef DEBUG
            if (!_documentFormattingOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentFormattingOptions"
                );
            }
#endif // DEBUG
            _documentFormattingOptions.~unique_ptr<DocumentFormattingOptions>();
            _type =
                ServerCapabilities_documentFormattingProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_documentFormattingProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_documentFormattingProvider::type() const
    -> const ServerCapabilities_documentFormattingProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_documentFormattingProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentFormattingProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentFormattingProvider::boolean()"
                 " of type "
                 "ServerCapabilities_documentFormattingProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_documentFormattingProviderType::" +
                 ServerCapabilities_documentFormattingProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_documentFormattingProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_documentFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentFormattingProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_documentFormattingProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_documentFormattingProvider::documentFormattingOptions() const
    -> const DocumentFormattingOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentFormattingProvider::documentFormattingOptions()"
                 " of type "
                 "ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions"
                 " while active type is "
                 "ServerCapabilities_documentFormattingProviderType::" +
                 ServerCapabilities_documentFormattingProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentFormattingOptions;
    }

    auto ServerCapabilities_documentFormattingProvider::operator=(
        const std::unique_ptr<DocumentFormattingOptions> &documentFormattingOptions
    ) -> ServerCapabilities_documentFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentFormattingProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentFormattingOptions) {
            throw std::logic_error(
                "null passed as the value of documentFormattingOptions"
            );
        }
#endif // DEBUG
        new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
            std::make_unique<DocumentFormattingOptions>(*documentFormattingOptions)
        };
        _type =
            ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions;
        return *this;
    }

    auto ServerCapabilities_documentFormattingProvider::operator=(
        std::unique_ptr<DocumentFormattingOptions> &&documentFormattingOptions
    ) -> ServerCapabilities_documentFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentFormattingProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentFormattingOptions) {
            throw std::logic_error(
                "null passed as the value of documentFormattingOptions"
            );
        }
#endif // DEBUG
        new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
            std::move(documentFormattingOptions)
        };
        _type =
            ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions;
        return *this;
    }

    auto ServerCapabilities_documentFormattingProvider::operator=(
        const DocumentFormattingOptions &documentFormattingOptions
    ) -> ServerCapabilities_documentFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentFormattingProviderType::Uninitialized) {
            reset();
        }
        new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
            std::make_unique<DocumentFormattingOptions>(documentFormattingOptions)
        };
        _type =
            ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions;
        return *this;
    }

    auto ServerCapabilities_documentFormattingProvider::operator=(
        DocumentFormattingOptions &&documentFormattingOptions
    ) -> ServerCapabilities_documentFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentFormattingProviderType::Uninitialized) {
            reset();
        }
        new (&_documentFormattingOptions) std::unique_ptr<DocumentFormattingOptions> {
            std::make_unique<DocumentFormattingOptions>(std::move(documentFormattingOptions))
        };
        _type =
            ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions;
        return *this;
    }

    DocumentRangeFormattingOptions::DocumentRangeFormattingOptions()
    {
        // empty
    }

    DocumentRangeFormattingOptions::DocumentRangeFormattingOptions(
        DocumentRangeFormattingOptions &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
        , rangesSupport(std::move(other.rangesSupport))
    {
        // empty
    }

    DocumentRangeFormattingOptions::DocumentRangeFormattingOptions(
        const DocumentRangeFormattingOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.rangesSupport.has_value()) {
            rangesSupport = other.rangesSupport.value();
        }
    }

    DocumentRangeFormattingOptions::~DocumentRangeFormattingOptions()
    {
        // empty
    }

    auto DocumentRangeFormattingOptions::operator=(
        DocumentRangeFormattingOptions &&other
    ) -> DocumentRangeFormattingOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            rangesSupport = std::move(other.rangesSupport);
        }
        return *this;
    }

    auto DocumentRangeFormattingOptions::operator=(
        const DocumentRangeFormattingOptions &other
    ) -> DocumentRangeFormattingOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.rangesSupport.has_value()) {
                rangesSupport = other.rangesSupport.value();
            }
        }
        return *this;
    }

    const std::map<
        ServerCapabilities_documentRangeFormattingProviderType,
        std::string
    > ServerCapabilities_documentRangeFormattingProviderTypeNames = {
        {ServerCapabilities_documentRangeFormattingProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_documentRangeFormattingProviderType::Boolean,
         "Boolean"},
        {ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions,
         "DocumentRangeFormattingOptions"},
    };

    ServerCapabilities_documentRangeFormattingProvider::ServerCapabilities_documentRangeFormattingProvider()
    {
        // empty
    }

    ServerCapabilities_documentRangeFormattingProvider::~ServerCapabilities_documentRangeFormattingProvider()
    {
        reset();
    }

    ServerCapabilities_documentRangeFormattingProvider::ServerCapabilities_documentRangeFormattingProvider(
        ServerCapabilities_documentRangeFormattingProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentRangeFormattingProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions: {
            new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
                std::move(other._documentRangeFormattingOptions)
            };
            break;
        }
        case ServerCapabilities_documentRangeFormattingProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_documentRangeFormattingProviderType::Uninitialized;
    }

    ServerCapabilities_documentRangeFormattingProvider::ServerCapabilities_documentRangeFormattingProvider(
        const ServerCapabilities_documentRangeFormattingProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_documentRangeFormattingProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions: {
            new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
                std::make_unique<DocumentRangeFormattingOptions>(*other._documentRangeFormattingOptions)
            };
            break;
        }
        case ServerCapabilities_documentRangeFormattingProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_documentRangeFormattingProvider::operator=(
        ServerCapabilities_documentRangeFormattingProvider &&other
    ) -> ServerCapabilities_documentRangeFormattingProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentRangeFormattingProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions: {
                new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
                    std::move(other._documentRangeFormattingOptions)
                };
                break;
            }
            case ServerCapabilities_documentRangeFormattingProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_documentRangeFormattingProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::operator=(
        const ServerCapabilities_documentRangeFormattingProvider &other
    ) -> ServerCapabilities_documentRangeFormattingProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_documentRangeFormattingProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions: {
                new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
                    std::make_unique<DocumentRangeFormattingOptions>(*other._documentRangeFormattingOptions)
                };
                break;
            }
            case ServerCapabilities_documentRangeFormattingProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_documentRangeFormattingProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions: {
#ifdef DEBUG
            if (!_documentRangeFormattingOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentRangeFormattingOptions"
                );
            }
#endif // DEBUG
            _documentRangeFormattingOptions.~unique_ptr<DocumentRangeFormattingOptions>();
            _type =
                ServerCapabilities_documentRangeFormattingProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_documentRangeFormattingProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_documentRangeFormattingProvider::type() const
    -> const ServerCapabilities_documentRangeFormattingProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentRangeFormattingProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentRangeFormattingProvider::boolean()"
                 " of type "
                 "ServerCapabilities_documentRangeFormattingProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_documentRangeFormattingProviderType::" +
                 ServerCapabilities_documentRangeFormattingProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_documentRangeFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentRangeFormattingProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type =
            ServerCapabilities_documentRangeFormattingProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::documentRangeFormattingOptions() const
    -> const DocumentRangeFormattingOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_documentRangeFormattingProvider::documentRangeFormattingOptions()"
                 " of type "
                 "ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions"
                 " while active type is "
                 "ServerCapabilities_documentRangeFormattingProviderType::" +
                 ServerCapabilities_documentRangeFormattingProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentRangeFormattingOptions;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::operator=(
        const std::unique_ptr<DocumentRangeFormattingOptions> &documentRangeFormattingOptions
    ) -> ServerCapabilities_documentRangeFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentRangeFormattingProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentRangeFormattingOptions) {
            throw std::logic_error(
                "null passed as the value of documentRangeFormattingOptions"
            );
        }
#endif // DEBUG
        new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
            std::make_unique<DocumentRangeFormattingOptions>(*documentRangeFormattingOptions)
        };
        _type =
            ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions;
        return *this;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::operator=(
        std::unique_ptr<DocumentRangeFormattingOptions> &&documentRangeFormattingOptions
    ) -> ServerCapabilities_documentRangeFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentRangeFormattingProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentRangeFormattingOptions) {
            throw std::logic_error(
                "null passed as the value of documentRangeFormattingOptions"
            );
        }
#endif // DEBUG
        new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
            std::move(documentRangeFormattingOptions)
        };
        _type =
            ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions;
        return *this;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::operator=(
        const DocumentRangeFormattingOptions &documentRangeFormattingOptions
    ) -> ServerCapabilities_documentRangeFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentRangeFormattingProviderType::Uninitialized) {
            reset();
        }
        new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
            std::make_unique<DocumentRangeFormattingOptions>(documentRangeFormattingOptions)
        };
        _type =
            ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions;
        return *this;
    }

    auto ServerCapabilities_documentRangeFormattingProvider::operator=(
        DocumentRangeFormattingOptions &&documentRangeFormattingOptions
    ) -> ServerCapabilities_documentRangeFormattingProvider &
    {
        if (_type !=
                ServerCapabilities_documentRangeFormattingProviderType::Uninitialized) {
            reset();
        }
        new (&_documentRangeFormattingOptions) std::unique_ptr<DocumentRangeFormattingOptions> {
            std::make_unique<DocumentRangeFormattingOptions>(std::move(documentRangeFormattingOptions))
        };
        _type =
            ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions;
        return *this;
    }

    RenameOptions::RenameOptions()
    {
        // empty
    }

    RenameOptions::RenameOptions(RenameOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , prepareProvider(std::move(other.prepareProvider))
    {
        // empty
    }

    RenameOptions::RenameOptions(const RenameOptions &other)
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.prepareProvider.has_value()) {
            prepareProvider = other.prepareProvider.value();
        }
    }

    RenameOptions::~RenameOptions()
    {
        // empty
    }

    auto RenameOptions::operator=(RenameOptions &&other) -> RenameOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            prepareProvider = std::move(other.prepareProvider);
        }
        return *this;
    }

    auto RenameOptions::operator=(
        const RenameOptions &other
    ) -> RenameOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.prepareProvider.has_value()) {
                prepareProvider = other.prepareProvider.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_renameProviderType, std::string>
    ServerCapabilities_renameProviderTypeNames = {
        {ServerCapabilities_renameProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_renameProviderType::Boolean, "Boolean"},
        {ServerCapabilities_renameProviderType::RenameOptions,
         "RenameOptions"},
    };

    ServerCapabilities_renameProvider::ServerCapabilities_renameProvider()
    {
        // empty
    }

    ServerCapabilities_renameProvider::~ServerCapabilities_renameProvider()
    {
        reset();
    }

    ServerCapabilities_renameProvider::ServerCapabilities_renameProvider(
        ServerCapabilities_renameProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_renameProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_renameProviderType::RenameOptions: {
            new (&_renameOptions) std::unique_ptr<RenameOptions> {
                std::move(other._renameOptions)
            };
            break;
        }
        case ServerCapabilities_renameProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_renameProviderType::Uninitialized;
    }

    ServerCapabilities_renameProvider::ServerCapabilities_renameProvider(
        const ServerCapabilities_renameProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_renameProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_renameProviderType::RenameOptions: {
            new (&_renameOptions) std::unique_ptr<RenameOptions> {
                std::make_unique<RenameOptions>(*other._renameOptions)
            };
            break;
        }
        case ServerCapabilities_renameProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_renameProvider::operator=(
        ServerCapabilities_renameProvider &&other
    ) -> ServerCapabilities_renameProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_renameProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_renameProviderType::RenameOptions: {
                new (&_renameOptions) std::unique_ptr<RenameOptions> {
                    std::move(other._renameOptions)
                };
                break;
            }
            case ServerCapabilities_renameProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = ServerCapabilities_renameProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_renameProvider::operator=(
        const ServerCapabilities_renameProvider &other
    ) -> ServerCapabilities_renameProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_renameProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_renameProviderType::RenameOptions: {
                new (&_renameOptions) std::unique_ptr<RenameOptions> {
                    std::make_unique<RenameOptions>(*other._renameOptions)
                };
                break;
            }
            case ServerCapabilities_renameProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_renameProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_renameProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_renameProviderType::RenameOptions: {
#ifdef DEBUG
            if (!_renameOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _renameOptions"
                );
            }
#endif // DEBUG
            _renameOptions.~unique_ptr<RenameOptions>();
            _type = ServerCapabilities_renameProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_renameProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_renameProvider::type() const
    -> const ServerCapabilities_renameProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_renameProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_renameProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_renameProvider::boolean()"
                 " of type "
                 "ServerCapabilities_renameProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_renameProviderType::" +
                 ServerCapabilities_renameProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_renameProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_renameProvider &
    {
        if (_type != ServerCapabilities_renameProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_renameProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_renameProvider::renameOptions() const
    -> const RenameOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_renameProviderType::RenameOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_renameProvider::renameOptions()"
                 " of type "
                 "ServerCapabilities_renameProviderType::RenameOptions"
                 " while active type is "
                 "ServerCapabilities_renameProviderType::" +
                 ServerCapabilities_renameProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_renameOptions;
    }

    auto ServerCapabilities_renameProvider::operator=(
        const std::unique_ptr<RenameOptions> &renameOptions
    ) -> ServerCapabilities_renameProvider &
    {
        if (_type != ServerCapabilities_renameProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!renameOptions) {
            throw std::logic_error(
                "null passed as the value of renameOptions"
            );
        }
#endif // DEBUG
        new (&_renameOptions) std::unique_ptr<RenameOptions> {
            std::make_unique<RenameOptions>(*renameOptions)
        };
        _type = ServerCapabilities_renameProviderType::RenameOptions;
        return *this;
    }

    auto ServerCapabilities_renameProvider::operator=(
        std::unique_ptr<RenameOptions> &&renameOptions
    ) -> ServerCapabilities_renameProvider &
    {
        if (_type != ServerCapabilities_renameProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!renameOptions) {
            throw std::logic_error(
                "null passed as the value of renameOptions"
            );
        }
#endif // DEBUG
        new (&_renameOptions) std::unique_ptr<RenameOptions> {
            std::move(renameOptions)
        };
        _type = ServerCapabilities_renameProviderType::RenameOptions;
        return *this;
    }

    auto ServerCapabilities_renameProvider::operator=(
        const RenameOptions &renameOptions
    ) -> ServerCapabilities_renameProvider &
    {
        if (_type != ServerCapabilities_renameProviderType::Uninitialized) {
            reset();
        }
        new (&_renameOptions) std::unique_ptr<RenameOptions> {
            std::make_unique<RenameOptions>(renameOptions)
        };
        _type = ServerCapabilities_renameProviderType::RenameOptions;
        return *this;
    }

    auto ServerCapabilities_renameProvider::operator=(
        RenameOptions &&renameOptions
    ) -> ServerCapabilities_renameProvider &
    {
        if (_type != ServerCapabilities_renameProviderType::Uninitialized) {
            reset();
        }
        new (&_renameOptions) std::unique_ptr<RenameOptions> {
            std::make_unique<RenameOptions>(std::move(renameOptions))
        };
        _type = ServerCapabilities_renameProviderType::RenameOptions;
        return *this;
    }

    ExecuteCommandOptions::ExecuteCommandOptions()
    {
        // empty
    }

    ExecuteCommandOptions::ExecuteCommandOptions(ExecuteCommandOptions &&other)
        : workDoneProgress(std::move(other.workDoneProgress))
        , commands(std::move(other.commands))
    {
        // empty
    }

    ExecuteCommandOptions::ExecuteCommandOptions(
        const ExecuteCommandOptions &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        commands = other.commands;
    }

    ExecuteCommandOptions::~ExecuteCommandOptions()
    {
        // empty
    }

    auto ExecuteCommandOptions::operator=(
        ExecuteCommandOptions &&other
    ) -> ExecuteCommandOptions &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            commands = std::move(other.commands);
        }
        return *this;
    }

    auto ExecuteCommandOptions::operator=(
        const ExecuteCommandOptions &other
    ) -> ExecuteCommandOptions &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            commands = other.commands;
        }
        return *this;
    }

    ExecuteCommandRegistrationOptions::ExecuteCommandRegistrationOptions()
        : ExecuteCommandOptions()
    {
        // empty
    }

    ExecuteCommandRegistrationOptions::ExecuteCommandRegistrationOptions(
        ExecuteCommandRegistrationOptions &&other
    )
        : ExecuteCommandOptions(other)
    {
        // empty
    }

    ExecuteCommandRegistrationOptions::ExecuteCommandRegistrationOptions(
        const ExecuteCommandRegistrationOptions &other
    )
        : ExecuteCommandOptions(other)
    {
    }

    ExecuteCommandRegistrationOptions::~ExecuteCommandRegistrationOptions()
    {
        // empty
    }

    auto ExecuteCommandRegistrationOptions::operator=(
        ExecuteCommandRegistrationOptions &&other
    ) -> ExecuteCommandRegistrationOptions &
    {
        if (this != &other) {
            ExecuteCommandOptions::operator=(other);
        }
        return *this;
    }

    auto ExecuteCommandRegistrationOptions::operator=(
        const ExecuteCommandRegistrationOptions &other
    ) -> ExecuteCommandRegistrationOptions &
    {
        if (this != &other) {
            ExecuteCommandOptions::operator=(other);
        }
        return *this;
    }

    CreateFileOptions::CreateFileOptions()
    {
        // empty
    }

    CreateFileOptions::CreateFileOptions(CreateFileOptions &&other)
        : overwrite(std::move(other.overwrite))
        , ignoreIfExists(std::move(other.ignoreIfExists))
    {
        // empty
    }

    CreateFileOptions::CreateFileOptions(const CreateFileOptions &other)
    {
        if (other.overwrite.has_value()) {
            overwrite = other.overwrite.value();
        }
        if (other.ignoreIfExists.has_value()) {
            ignoreIfExists = other.ignoreIfExists.value();
        }
    }

    CreateFileOptions::~CreateFileOptions()
    {
        // empty
    }

    auto CreateFileOptions::operator=(
        CreateFileOptions &&other
    ) -> CreateFileOptions &
    {
        if (this != &other) {
            overwrite = std::move(other.overwrite);
            ignoreIfExists = std::move(other.ignoreIfExists);
        }
        return *this;
    }

    auto CreateFileOptions::operator=(
        const CreateFileOptions &other
    ) -> CreateFileOptions &
    {
        if (this != &other) {
            if (other.overwrite.has_value()) {
                overwrite = other.overwrite.value();
            }
            if (other.ignoreIfExists.has_value()) {
                ignoreIfExists = other.ignoreIfExists.value();
            }
        }
        return *this;
    }

    CreateFile::CreateFile()
        : ResourceOperation()
    {
        // empty
    }

    CreateFile::CreateFile(CreateFile &&other)
        : ResourceOperation(other)
        , kind(std::move(other.kind))
        , uri(std::move(other.uri))
        , options(std::move(other.options))
    {
        // empty
    }

    CreateFile::CreateFile(const CreateFile &other)
        : ResourceOperation(other)
        , uri(other.uri)
    {
        if (other.options.has_value()) {
            options = other.options.value();
        }
    }

    CreateFile::~CreateFile()
    {
        // empty
    }

    auto CreateFile::operator=(CreateFile &&other) -> CreateFile &
    {
        if (this != &other) {
            ResourceOperation::operator=(other);
            kind = std::move(other.kind);
            uri = std::move(other.uri);
            options = std::move(other.options);
        }
        return *this;
    }

    auto CreateFile::operator=(const CreateFile &other) -> CreateFile &
    {
        if (this != &other) {
            ResourceOperation::operator=(other);
            uri = other.uri;
            if (other.options.has_value()) {
                options = other.options.value();
            }
        }
        return *this;
    }

    RenameFileOptions::RenameFileOptions()
    {
        // empty
    }

    RenameFileOptions::RenameFileOptions(RenameFileOptions &&other)
        : overwrite(std::move(other.overwrite))
        , ignoreIfExists(std::move(other.ignoreIfExists))
    {
        // empty
    }

    RenameFileOptions::RenameFileOptions(const RenameFileOptions &other)
    {
        if (other.overwrite.has_value()) {
            overwrite = other.overwrite.value();
        }
        if (other.ignoreIfExists.has_value()) {
            ignoreIfExists = other.ignoreIfExists.value();
        }
    }

    RenameFileOptions::~RenameFileOptions()
    {
        // empty
    }

    auto RenameFileOptions::operator=(
        RenameFileOptions &&other
    ) -> RenameFileOptions &
    {
        if (this != &other) {
            overwrite = std::move(other.overwrite);
            ignoreIfExists = std::move(other.ignoreIfExists);
        }
        return *this;
    }

    auto RenameFileOptions::operator=(
        const RenameFileOptions &other
    ) -> RenameFileOptions &
    {
        if (this != &other) {
            if (other.overwrite.has_value()) {
                overwrite = other.overwrite.value();
            }
            if (other.ignoreIfExists.has_value()) {
                ignoreIfExists = other.ignoreIfExists.value();
            }
        }
        return *this;
    }

    RenameFile::RenameFile()
        : ResourceOperation()
    {
        // empty
    }

    RenameFile::RenameFile(RenameFile &&other)
        : ResourceOperation(other)
        , kind(std::move(other.kind))
        , oldUri(std::move(other.oldUri))
        , newUri(std::move(other.newUri))
        , options(std::move(other.options))
    {
        // empty
    }

    RenameFile::RenameFile(const RenameFile &other)
        : ResourceOperation(other)
        , oldUri(other.oldUri)
        , newUri(other.newUri)
    {
        if (other.options.has_value()) {
            options = other.options.value();
        }
    }

    RenameFile::~RenameFile()
    {
        // empty
    }

    auto RenameFile::operator=(RenameFile &&other) -> RenameFile &
    {
        if (this != &other) {
            ResourceOperation::operator=(other);
            kind = std::move(other.kind);
            oldUri = std::move(other.oldUri);
            newUri = std::move(other.newUri);
            options = std::move(other.options);
        }
        return *this;
    }

    auto RenameFile::operator=(const RenameFile &other) -> RenameFile &
    {
        if (this != &other) {
            ResourceOperation::operator=(other);
            oldUri = other.oldUri;
            newUri = other.newUri;
            if (other.options.has_value()) {
                options = other.options.value();
            }
        }
        return *this;
    }

    DeleteFileOptions::DeleteFileOptions()
    {
        // empty
    }

    DeleteFileOptions::DeleteFileOptions(DeleteFileOptions &&other)
        : recursive(std::move(other.recursive))
        , ignoreIfNotExists(std::move(other.ignoreIfNotExists))
    {
        // empty
    }

    DeleteFileOptions::DeleteFileOptions(const DeleteFileOptions &other)
    {
        if (other.recursive.has_value()) {
            recursive = other.recursive.value();
        }
        if (other.ignoreIfNotExists.has_value()) {
            ignoreIfNotExists = other.ignoreIfNotExists.value();
        }
    }

    DeleteFileOptions::~DeleteFileOptions()
    {
        // empty
    }

    auto DeleteFileOptions::operator=(
        DeleteFileOptions &&other
    ) -> DeleteFileOptions &
    {
        if (this != &other) {
            recursive = std::move(other.recursive);
            ignoreIfNotExists = std::move(other.ignoreIfNotExists);
        }
        return *this;
    }

    auto DeleteFileOptions::operator=(
        const DeleteFileOptions &other
    ) -> DeleteFileOptions &
    {
        if (this != &other) {
            if (other.recursive.has_value()) {
                recursive = other.recursive.value();
            }
            if (other.ignoreIfNotExists.has_value()) {
                ignoreIfNotExists = other.ignoreIfNotExists.value();
            }
        }
        return *this;
    }

    DeleteFile::DeleteFile()
        : ResourceOperation()
    {
        // empty
    }

    DeleteFile::DeleteFile(DeleteFile &&other)
        : ResourceOperation(other)
        , kind(std::move(other.kind))
        , uri(std::move(other.uri))
        , options(std::move(other.options))
    {
        // empty
    }

    DeleteFile::DeleteFile(const DeleteFile &other)
        : ResourceOperation(other)
        , uri(other.uri)
    {
        if (other.options.has_value()) {
            options = other.options.value();
        }
    }

    DeleteFile::~DeleteFile()
    {
        // empty
    }

    auto DeleteFile::operator=(DeleteFile &&other) -> DeleteFile &
    {
        if (this != &other) {
            ResourceOperation::operator=(other);
            kind = std::move(other.kind);
            uri = std::move(other.uri);
            options = std::move(other.options);
        }
        return *this;
    }

    auto DeleteFile::operator=(const DeleteFile &other) -> DeleteFile &
    {
        if (this != &other) {
            ResourceOperation::operator=(other);
            uri = other.uri;
            if (other.options.has_value()) {
                options = other.options.value();
            }
        }
        return *this;
    }

    const std::map<TextDocumentSyncOptions_saveType, std::string>
    TextDocumentSyncOptions_saveTypeNames = {
        {TextDocumentSyncOptions_saveType::Uninitialized, "Uninitialized"},
        {TextDocumentSyncOptions_saveType::Boolean, "Boolean"},
        {TextDocumentSyncOptions_saveType::SaveOptions, "SaveOptions"},
    };

    TextDocumentSyncOptions_save::TextDocumentSyncOptions_save()
    {
        // empty
    }

    TextDocumentSyncOptions_save::~TextDocumentSyncOptions_save()
    {
        reset();
    }

    TextDocumentSyncOptions_save::TextDocumentSyncOptions_save(
        TextDocumentSyncOptions_save &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case TextDocumentSyncOptions_saveType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case TextDocumentSyncOptions_saveType::SaveOptions: {
            new (&_saveOptions) std::unique_ptr<SaveOptions> {
                std::move(other._saveOptions)
            };
            break;
        }
        case TextDocumentSyncOptions_saveType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = TextDocumentSyncOptions_saveType::Uninitialized;
    }

    TextDocumentSyncOptions_save::TextDocumentSyncOptions_save(
        const TextDocumentSyncOptions_save &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case TextDocumentSyncOptions_saveType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case TextDocumentSyncOptions_saveType::SaveOptions: {
            new (&_saveOptions) std::unique_ptr<SaveOptions> {
                std::make_unique<SaveOptions>(*other._saveOptions)
            };
            break;
        }
        case TextDocumentSyncOptions_saveType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto TextDocumentSyncOptions_save::operator=(
        TextDocumentSyncOptions_save &&other
    ) -> TextDocumentSyncOptions_save &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case TextDocumentSyncOptions_saveType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case TextDocumentSyncOptions_saveType::SaveOptions: {
                new (&_saveOptions) std::unique_ptr<SaveOptions> {
                    std::move(other._saveOptions)
                };
                break;
            }
            case TextDocumentSyncOptions_saveType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = TextDocumentSyncOptions_saveType::Uninitialized;
        }
        return *this;
    }

    auto TextDocumentSyncOptions_save::operator=(
        const TextDocumentSyncOptions_save &other
    ) -> TextDocumentSyncOptions_save &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case TextDocumentSyncOptions_saveType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case TextDocumentSyncOptions_saveType::SaveOptions: {
                new (&_saveOptions) std::unique_ptr<SaveOptions> {
                    std::make_unique<SaveOptions>(*other._saveOptions)
                };
                break;
            }
            case TextDocumentSyncOptions_saveType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto TextDocumentSyncOptions_save::reset() -> void
    {
        switch (_type) {
        case TextDocumentSyncOptions_saveType::Uninitialized: {
            // nothing to do
            break;
        }
        case TextDocumentSyncOptions_saveType::SaveOptions: {
#ifdef DEBUG
            if (!_saveOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _saveOptions"
                );
            }
#endif // DEBUG
            _saveOptions.~unique_ptr<SaveOptions>();
            _type = TextDocumentSyncOptions_saveType::Uninitialized;
            break;
        }
        default: {
            _type = TextDocumentSyncOptions_saveType::Uninitialized;
        }
        }
    }

    auto TextDocumentSyncOptions_save::type() const
    -> const TextDocumentSyncOptions_saveType &
    {
        return _type;
    }

    auto TextDocumentSyncOptions_save::boolean() const -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != TextDocumentSyncOptions_saveType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "TextDocumentSyncOptions_save::boolean()"
                 " of type "
                 "TextDocumentSyncOptions_saveType::Boolean"
                 " while active type is "
                 "TextDocumentSyncOptions_saveType::" +
                 TextDocumentSyncOptions_saveTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto TextDocumentSyncOptions_save::operator=(
        boolean_t boolean
    ) -> TextDocumentSyncOptions_save &
    {
        if (_type != TextDocumentSyncOptions_saveType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = TextDocumentSyncOptions_saveType::Boolean;
        return *this;
    }

    auto TextDocumentSyncOptions_save::saveOptions() const
    -> const SaveOptions &
    {
#ifdef DEBUG
        if (_type != TextDocumentSyncOptions_saveType::SaveOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "TextDocumentSyncOptions_save::saveOptions()"
                 " of type "
                 "TextDocumentSyncOptions_saveType::SaveOptions"
                 " while active type is "
                 "TextDocumentSyncOptions_saveType::" +
                 TextDocumentSyncOptions_saveTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_saveOptions;
    }

    auto TextDocumentSyncOptions_save::operator=(
        const std::unique_ptr<SaveOptions> &saveOptions
    ) -> TextDocumentSyncOptions_save &
    {
        if (_type != TextDocumentSyncOptions_saveType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!saveOptions) {
            throw std::logic_error("null passed as the value of saveOptions");
        }
#endif // DEBUG
        new (&_saveOptions) std::unique_ptr<SaveOptions> {
            std::make_unique<SaveOptions>(*saveOptions)
        };
        _type = TextDocumentSyncOptions_saveType::SaveOptions;
        return *this;
    }

    auto TextDocumentSyncOptions_save::operator=(
        std::unique_ptr<SaveOptions> &&saveOptions
    ) -> TextDocumentSyncOptions_save &
    {
        if (_type != TextDocumentSyncOptions_saveType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!saveOptions) {
            throw std::logic_error("null passed as the value of saveOptions");
        }
#endif // DEBUG
        new (&_saveOptions) std::unique_ptr<SaveOptions> {
            std::move(saveOptions)
        };
        _type = TextDocumentSyncOptions_saveType::SaveOptions;
        return *this;
    }

    auto TextDocumentSyncOptions_save::operator=(
        const SaveOptions &saveOptions
    ) -> TextDocumentSyncOptions_save &
    {
        if (_type != TextDocumentSyncOptions_saveType::Uninitialized) {
            reset();
        }
        new (&_saveOptions) std::unique_ptr<SaveOptions> {
            std::make_unique<SaveOptions>(saveOptions)
        };
        _type = TextDocumentSyncOptions_saveType::SaveOptions;
        return *this;
    }

    auto TextDocumentSyncOptions_save::operator=(
        SaveOptions &&saveOptions
    ) -> TextDocumentSyncOptions_save &
    {
        if (_type != TextDocumentSyncOptions_saveType::Uninitialized) {
            reset();
        }
        new (&_saveOptions) std::unique_ptr<SaveOptions> {
            std::make_unique<SaveOptions>(std::move(saveOptions))
        };
        _type = TextDocumentSyncOptions_saveType::SaveOptions;
        return *this;
    }

    TextDocumentSyncOptions::TextDocumentSyncOptions()
    {
        // empty
    }

    TextDocumentSyncOptions::TextDocumentSyncOptions(
        TextDocumentSyncOptions &&other
    )
        : openClose(std::move(other.openClose))
        , change(std::move(other.change))
        , willSave(std::move(other.willSave))
        , willSaveWaitUntil(std::move(other.willSaveWaitUntil))
        , save(std::move(other.save))
    {
        // empty
    }

    TextDocumentSyncOptions::TextDocumentSyncOptions(
        const TextDocumentSyncOptions &other
    )
    {
        if (other.openClose.has_value()) {
            openClose = other.openClose.value();
        }
        if (other.change.has_value()) {
            change = other.change.value();
        }
        if (other.willSave.has_value()) {
            willSave = other.willSave.value();
        }
        if (other.willSaveWaitUntil.has_value()) {
            willSaveWaitUntil = other.willSaveWaitUntil.value();
        }
        if (other.save.has_value()) {
            save = other.save.value();
        }
    }

    TextDocumentSyncOptions::~TextDocumentSyncOptions()
    {
        // empty
    }

    auto TextDocumentSyncOptions::operator=(
        TextDocumentSyncOptions &&other
    ) -> TextDocumentSyncOptions &
    {
        if (this != &other) {
            openClose = std::move(other.openClose);
            change = std::move(other.change);
            willSave = std::move(other.willSave);
            willSaveWaitUntil = std::move(other.willSaveWaitUntil);
            save = std::move(other.save);
        }
        return *this;
    }

    auto TextDocumentSyncOptions::operator=(
        const TextDocumentSyncOptions &other
    ) -> TextDocumentSyncOptions &
    {
        if (this != &other) {
            if (other.openClose.has_value()) {
                openClose = other.openClose.value();
            }
            if (other.change.has_value()) {
                change = other.change.value();
            }
            if (other.willSave.has_value()) {
                willSave = other.willSave.value();
            }
            if (other.willSaveWaitUntil.has_value()) {
                willSaveWaitUntil = other.willSaveWaitUntil.value();
            }
            if (other.save.has_value()) {
                save = other.save.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_textDocumentSyncType, std::string>
    ServerCapabilities_textDocumentSyncTypeNames = {
        {ServerCapabilities_textDocumentSyncType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions,
         "TextDocumentSyncOptions"},
        {ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind,
         "TextDocumentSyncKind"},
    };

    ServerCapabilities_textDocumentSync::ServerCapabilities_textDocumentSync()
    {
        // empty
    }

    ServerCapabilities_textDocumentSync::~ServerCapabilities_textDocumentSync()
    {
        reset();
    }

    ServerCapabilities_textDocumentSync::ServerCapabilities_textDocumentSync(
        ServerCapabilities_textDocumentSync &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions: {
            new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
                std::move(other._textDocumentSyncOptions)
            };
            break;
        }
        case ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind: {
            _textDocumentSyncKind = other._textDocumentSyncKind;
            break;
        }
        case ServerCapabilities_textDocumentSyncType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_textDocumentSyncType::Uninitialized;
    }

    ServerCapabilities_textDocumentSync::ServerCapabilities_textDocumentSync(
        const ServerCapabilities_textDocumentSync &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions: {
            new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
                std::make_unique<TextDocumentSyncOptions>(*other._textDocumentSyncOptions)
            };
            break;
        }
        case ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind: {
            _textDocumentSyncKind = other._textDocumentSyncKind;
            break;
        }
        case ServerCapabilities_textDocumentSyncType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_textDocumentSync::operator=(
        ServerCapabilities_textDocumentSync &&other
    ) -> ServerCapabilities_textDocumentSync &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions: {
                new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
                    std::move(other._textDocumentSyncOptions)
                };
                break;
            }
            case ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind: {
                _textDocumentSyncKind = other._textDocumentSyncKind;
                break;
            }
            case ServerCapabilities_textDocumentSyncType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_textDocumentSyncType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_textDocumentSync::operator=(
        const ServerCapabilities_textDocumentSync &other
    ) -> ServerCapabilities_textDocumentSync &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions: {
                new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
                    std::make_unique<TextDocumentSyncOptions>(*other._textDocumentSyncOptions)
                };
                break;
            }
            case ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind: {
                _textDocumentSyncKind = other._textDocumentSyncKind;
                break;
            }
            case ServerCapabilities_textDocumentSyncType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_textDocumentSync::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_textDocumentSyncType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions: {
#ifdef DEBUG
            if (!_textDocumentSyncOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _textDocumentSyncOptions"
                );
            }
#endif // DEBUG
            _textDocumentSyncOptions.~unique_ptr<TextDocumentSyncOptions>();
            _type = ServerCapabilities_textDocumentSyncType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_textDocumentSyncType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_textDocumentSync::type() const
    -> const ServerCapabilities_textDocumentSyncType &
    {
        return _type;
    }

    auto ServerCapabilities_textDocumentSync::textDocumentSyncOptions() const
    -> const TextDocumentSyncOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_textDocumentSync::textDocumentSyncOptions()"
                 " of type "
                 "ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions"
                 " while active type is "
                 "ServerCapabilities_textDocumentSyncType::" +
                 ServerCapabilities_textDocumentSyncTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_textDocumentSyncOptions;
    }

    auto ServerCapabilities_textDocumentSync::operator=(
        const std::unique_ptr<TextDocumentSyncOptions> &textDocumentSyncOptions
    ) -> ServerCapabilities_textDocumentSync &
    {
        if (_type != ServerCapabilities_textDocumentSyncType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentSyncOptions) {
            throw std::logic_error(
                "null passed as the value of textDocumentSyncOptions"
            );
        }
#endif // DEBUG
        new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
            std::make_unique<TextDocumentSyncOptions>(*textDocumentSyncOptions)
        };
        _type =
            ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_textDocumentSync::operator=(
        std::unique_ptr<TextDocumentSyncOptions> &&textDocumentSyncOptions
    ) -> ServerCapabilities_textDocumentSync &
    {
        if (_type != ServerCapabilities_textDocumentSyncType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!textDocumentSyncOptions) {
            throw std::logic_error(
                "null passed as the value of textDocumentSyncOptions"
            );
        }
#endif // DEBUG
        new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
            std::move(textDocumentSyncOptions)
        };
        _type =
            ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_textDocumentSync::operator=(
        const TextDocumentSyncOptions &textDocumentSyncOptions
    ) -> ServerCapabilities_textDocumentSync &
    {
        if (_type != ServerCapabilities_textDocumentSyncType::Uninitialized) {
            reset();
        }
        new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
            std::make_unique<TextDocumentSyncOptions>(textDocumentSyncOptions)
        };
        _type =
            ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_textDocumentSync::operator=(
        TextDocumentSyncOptions &&textDocumentSyncOptions
    ) -> ServerCapabilities_textDocumentSync &
    {
        if (_type != ServerCapabilities_textDocumentSyncType::Uninitialized) {
            reset();
        }
        new (&_textDocumentSyncOptions) std::unique_ptr<TextDocumentSyncOptions> {
            std::make_unique<TextDocumentSyncOptions>(std::move(textDocumentSyncOptions))
        };
        _type =
            ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_textDocumentSync::textDocumentSyncKind() const
    -> const TextDocumentSyncKind &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_textDocumentSync::textDocumentSyncKind()"
                 " of type "
                 "ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind"
                 " while active type is "
                 "ServerCapabilities_textDocumentSyncType::" +
                 ServerCapabilities_textDocumentSyncTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _textDocumentSyncKind;
    }

    auto ServerCapabilities_textDocumentSync::operator=(
        TextDocumentSyncKind textDocumentSyncKind
    ) -> ServerCapabilities_textDocumentSync &
    {
        if (_type != ServerCapabilities_textDocumentSyncType::Uninitialized) {
            reset();
        }
        _textDocumentSyncKind = textDocumentSyncKind;
        _type = ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind;
        return *this;
    }

    NotebookDocumentSyncOptions::NotebookDocumentSyncOptions()
    {
        // empty
    }

    NotebookDocumentSyncOptions::NotebookDocumentSyncOptions(
        NotebookDocumentSyncOptions &&other
    )
        : notebookSelector(std::move(other.notebookSelector))
        , save(std::move(other.save))
    {
        // empty
    }

    NotebookDocumentSyncOptions::NotebookDocumentSyncOptions(
        const NotebookDocumentSyncOptions &other
    )
    {
        notebookSelector = other.notebookSelector;
        if (other.save.has_value()) {
            save = other.save.value();
        }
    }

    NotebookDocumentSyncOptions::~NotebookDocumentSyncOptions()
    {
        // empty
    }

    auto NotebookDocumentSyncOptions::operator=(
        NotebookDocumentSyncOptions &&other
    ) -> NotebookDocumentSyncOptions &
    {
        if (this != &other) {
            notebookSelector = std::move(other.notebookSelector);
            save = std::move(other.save);
        }
        return *this;
    }

    auto NotebookDocumentSyncOptions::operator=(
        const NotebookDocumentSyncOptions &other
    ) -> NotebookDocumentSyncOptions &
    {
        if (this != &other) {
            notebookSelector = other.notebookSelector;
            if (other.save.has_value()) {
                save = other.save.value();
            }
        }
        return *this;
    }

    NotebookDocumentSyncRegistrationOptions::NotebookDocumentSyncRegistrationOptions()
        : NotebookDocumentSyncOptions()
    {
        // empty
    }

    NotebookDocumentSyncRegistrationOptions::NotebookDocumentSyncRegistrationOptions(
        NotebookDocumentSyncRegistrationOptions &&other
    )
        : NotebookDocumentSyncOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    NotebookDocumentSyncRegistrationOptions::NotebookDocumentSyncRegistrationOptions(
        const NotebookDocumentSyncRegistrationOptions &other
    )
        : NotebookDocumentSyncOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    NotebookDocumentSyncRegistrationOptions::~NotebookDocumentSyncRegistrationOptions()
    {
        // empty
    }

    auto NotebookDocumentSyncRegistrationOptions::operator=(
        NotebookDocumentSyncRegistrationOptions &&other
    ) -> NotebookDocumentSyncRegistrationOptions &
    {
        if (this != &other) {
            NotebookDocumentSyncOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto NotebookDocumentSyncRegistrationOptions::operator=(
        const NotebookDocumentSyncRegistrationOptions &other
    ) -> NotebookDocumentSyncRegistrationOptions &
    {
        if (this != &other) {
            NotebookDocumentSyncOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_notebookDocumentSyncType, std::string>
    ServerCapabilities_notebookDocumentSyncTypeNames = {
        {ServerCapabilities_notebookDocumentSyncType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions,
         "NotebookDocumentSyncOptions"},
        {ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions,
         "NotebookDocumentSyncRegistrationOptions"},
    };

    ServerCapabilities_notebookDocumentSync::ServerCapabilities_notebookDocumentSync()
    {
        // empty
    }

    ServerCapabilities_notebookDocumentSync::~ServerCapabilities_notebookDocumentSync()
    {
        reset();
    }

    ServerCapabilities_notebookDocumentSync::ServerCapabilities_notebookDocumentSync(
        ServerCapabilities_notebookDocumentSync &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions: {
            new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
                std::move(other._notebookDocumentSyncOptions)
            };
            break;
        }
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions: {
            new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
                std::move(other._notebookDocumentSyncRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_notebookDocumentSyncType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_notebookDocumentSyncType::Uninitialized;
    }

    ServerCapabilities_notebookDocumentSync::ServerCapabilities_notebookDocumentSync(
        const ServerCapabilities_notebookDocumentSync &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions: {
            new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
                std::make_unique<NotebookDocumentSyncOptions>(*other._notebookDocumentSyncOptions)
            };
            break;
        }
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions: {
            new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
                std::make_unique<NotebookDocumentSyncRegistrationOptions>(*other._notebookDocumentSyncRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_notebookDocumentSyncType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        ServerCapabilities_notebookDocumentSync &&other
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions: {
                new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
                    std::move(other._notebookDocumentSyncOptions)
                };
                break;
            }
            case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions: {
                new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
                    std::move(other._notebookDocumentSyncRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_notebookDocumentSyncType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_notebookDocumentSyncType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        const ServerCapabilities_notebookDocumentSync &other
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions: {
                new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
                    std::make_unique<NotebookDocumentSyncOptions>(*other._notebookDocumentSyncOptions)
                };
                break;
            }
            case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions: {
                new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
                    std::make_unique<NotebookDocumentSyncRegistrationOptions>(*other._notebookDocumentSyncRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_notebookDocumentSyncType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_notebookDocumentSyncType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions: {
#ifdef DEBUG
            if (!_notebookDocumentSyncOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentSyncOptions"
                );
            }
#endif // DEBUG
            _notebookDocumentSyncOptions.~unique_ptr<NotebookDocumentSyncOptions>();
            _type = ServerCapabilities_notebookDocumentSyncType::Uninitialized;
            break;
        }
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions: {
#ifdef DEBUG
            if (!_notebookDocumentSyncRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _notebookDocumentSyncRegistrationOptions"
                );
            }
#endif // DEBUG
            _notebookDocumentSyncRegistrationOptions.~unique_ptr<NotebookDocumentSyncRegistrationOptions>();
            _type = ServerCapabilities_notebookDocumentSyncType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_notebookDocumentSyncType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_notebookDocumentSync::type() const
    -> const ServerCapabilities_notebookDocumentSyncType &
    {
        return _type;
    }

    auto ServerCapabilities_notebookDocumentSync::notebookDocumentSyncOptions() const
    -> const NotebookDocumentSyncOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_notebookDocumentSync::notebookDocumentSyncOptions()"
                 " of type "
                 "ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions"
                 " while active type is "
                 "ServerCapabilities_notebookDocumentSyncType::" +
                 ServerCapabilities_notebookDocumentSyncTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentSyncOptions;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        const std::unique_ptr<NotebookDocumentSyncOptions> &notebookDocumentSyncOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncOptions) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncOptions"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
            std::make_unique<NotebookDocumentSyncOptions>(*notebookDocumentSyncOptions)
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        std::unique_ptr<NotebookDocumentSyncOptions> &&notebookDocumentSyncOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncOptions) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncOptions"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
            std::move(notebookDocumentSyncOptions)
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        const NotebookDocumentSyncOptions &notebookDocumentSyncOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
            std::make_unique<NotebookDocumentSyncOptions>(notebookDocumentSyncOptions)
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        NotebookDocumentSyncOptions &&notebookDocumentSyncOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncOptions) std::unique_ptr<NotebookDocumentSyncOptions> {
            std::make_unique<NotebookDocumentSyncOptions>(std::move(notebookDocumentSyncOptions))
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions;
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::notebookDocumentSyncRegistrationOptions() const
    -> const NotebookDocumentSyncRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_notebookDocumentSync::notebookDocumentSyncRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_notebookDocumentSyncType::" +
                 ServerCapabilities_notebookDocumentSyncTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_notebookDocumentSyncRegistrationOptions;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        const std::unique_ptr<NotebookDocumentSyncRegistrationOptions> &notebookDocumentSyncRegistrationOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
            std::make_unique<NotebookDocumentSyncRegistrationOptions>(*notebookDocumentSyncRegistrationOptions)
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        std::unique_ptr<NotebookDocumentSyncRegistrationOptions> &&notebookDocumentSyncRegistrationOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!notebookDocumentSyncRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of notebookDocumentSyncRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
            std::move(notebookDocumentSyncRegistrationOptions)
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        const NotebookDocumentSyncRegistrationOptions &notebookDocumentSyncRegistrationOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
            std::make_unique<NotebookDocumentSyncRegistrationOptions>(notebookDocumentSyncRegistrationOptions)
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_notebookDocumentSync::operator=(
        NotebookDocumentSyncRegistrationOptions &&notebookDocumentSyncRegistrationOptions
    ) -> ServerCapabilities_notebookDocumentSync &
    {
        if (_type !=
                ServerCapabilities_notebookDocumentSyncType::Uninitialized) {
            reset();
        }
        new (&_notebookDocumentSyncRegistrationOptions) std::unique_ptr<NotebookDocumentSyncRegistrationOptions> {
            std::make_unique<NotebookDocumentSyncRegistrationOptions>(std::move(notebookDocumentSyncRegistrationOptions))
        };
        _type =
            ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions;
        return *this;
    }

    const std::map<
        WorkspaceFoldersServerCapabilities_changeNotificationsType,
        std::string
    > WorkspaceFoldersServerCapabilities_changeNotificationsTypeNames = {
        {WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized,
         "Uninitialized"},
        {WorkspaceFoldersServerCapabilities_changeNotificationsType::String,
         "String"},
        {WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean,
         "Boolean"},
    };

    WorkspaceFoldersServerCapabilities_changeNotifications::WorkspaceFoldersServerCapabilities_changeNotifications()
    {
        // empty
    }

    WorkspaceFoldersServerCapabilities_changeNotifications::~WorkspaceFoldersServerCapabilities_changeNotifications()
    {
        reset();
    }

    WorkspaceFoldersServerCapabilities_changeNotifications::WorkspaceFoldersServerCapabilities_changeNotifications(
        WorkspaceFoldersServerCapabilities_changeNotifications &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized;
    }

    WorkspaceFoldersServerCapabilities_changeNotifications::WorkspaceFoldersServerCapabilities_changeNotifications(
        const WorkspaceFoldersServerCapabilities_changeNotifications &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::operator=(
        WorkspaceFoldersServerCapabilities_changeNotifications &&other
    ) -> WorkspaceFoldersServerCapabilities_changeNotifications &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case WorkspaceFoldersServerCapabilities_changeNotificationsType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized;
        }
        return *this;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::operator=(
        const WorkspaceFoldersServerCapabilities_changeNotifications &other
    ) -> WorkspaceFoldersServerCapabilities_changeNotifications &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case WorkspaceFoldersServerCapabilities_changeNotificationsType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::reset()
    -> void
    {
        switch (_type) {
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized: {
            // nothing to do
            break;
        }
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type =
                WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized;
            break;
        }
        default: {
            _type = WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized;
        }
        }
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::type() const
    -> const WorkspaceFoldersServerCapabilities_changeNotificationsType &
    {
        return _type;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::string() const
    -> const string_t &
    {
#ifdef DEBUG
        if (_type != WorkspaceFoldersServerCapabilities_changeNotificationsType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "WorkspaceFoldersServerCapabilities_changeNotifications::string()"
                 " of type "
                 "WorkspaceFoldersServerCapabilities_changeNotificationsType::String"
                 " while active type is "
                 "WorkspaceFoldersServerCapabilities_changeNotificationsType::" +
                 WorkspaceFoldersServerCapabilities_changeNotificationsTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::operator=(
        const std::unique_ptr<string_t> &string
    ) -> WorkspaceFoldersServerCapabilities_changeNotifications &
    {
        if (_type !=
                WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type =
            WorkspaceFoldersServerCapabilities_changeNotificationsType::String;
        return *this;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::operator=(
        std::unique_ptr<string_t> &&string
    ) -> WorkspaceFoldersServerCapabilities_changeNotifications &
    {
        if (_type !=
                WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type =
            WorkspaceFoldersServerCapabilities_changeNotificationsType::String;
        return *this;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::operator=(
        const string_t &string
    ) -> WorkspaceFoldersServerCapabilities_changeNotifications &
    {
        if (_type !=
                WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type =
            WorkspaceFoldersServerCapabilities_changeNotificationsType::String;
        return *this;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::operator=(
        string_t &&string
    ) -> WorkspaceFoldersServerCapabilities_changeNotifications &
    {
        if (_type !=
                WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type =
            WorkspaceFoldersServerCapabilities_changeNotificationsType::String;
        return *this;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "WorkspaceFoldersServerCapabilities_changeNotifications::boolean()"
                 " of type "
                 "WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean"
                 " while active type is "
                 "WorkspaceFoldersServerCapabilities_changeNotificationsType::" +
                 WorkspaceFoldersServerCapabilities_changeNotificationsTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto WorkspaceFoldersServerCapabilities_changeNotifications::operator=(
        boolean_t boolean
    ) -> WorkspaceFoldersServerCapabilities_changeNotifications &
    {
        if (_type !=
                WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type =
            WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean;
        return *this;
    }

    WorkspaceFoldersServerCapabilities::WorkspaceFoldersServerCapabilities()
    {
        // empty
    }

    WorkspaceFoldersServerCapabilities::WorkspaceFoldersServerCapabilities(
        WorkspaceFoldersServerCapabilities &&other
    )
        : supported(std::move(other.supported))
        , changeNotifications(std::move(other.changeNotifications))
    {
        // empty
    }

    WorkspaceFoldersServerCapabilities::WorkspaceFoldersServerCapabilities(
        const WorkspaceFoldersServerCapabilities &other
    )
    {
        if (other.supported.has_value()) {
            supported = other.supported.value();
        }
        if (other.changeNotifications.has_value()) {
            changeNotifications = other.changeNotifications.value();
        }
    }

    WorkspaceFoldersServerCapabilities::~WorkspaceFoldersServerCapabilities()
    {
        // empty
    }

    auto WorkspaceFoldersServerCapabilities::operator=(
        WorkspaceFoldersServerCapabilities &&other
    ) -> WorkspaceFoldersServerCapabilities &
    {
        if (this != &other) {
            supported = std::move(other.supported);
            changeNotifications = std::move(other.changeNotifications);
        }
        return *this;
    }

    auto WorkspaceFoldersServerCapabilities::operator=(
        const WorkspaceFoldersServerCapabilities &other
    ) -> WorkspaceFoldersServerCapabilities &
    {
        if (this != &other) {
            if (other.supported.has_value()) {
                supported = other.supported.value();
            }
            if (other.changeNotifications.has_value()) {
                changeNotifications = other.changeNotifications.value();
            }
        }
        return *this;
    }

    FileOperationPatternOptions::FileOperationPatternOptions()
    {
        // empty
    }

    FileOperationPatternOptions::FileOperationPatternOptions(
        FileOperationPatternOptions &&other
    )
        : ignoreCase(std::move(other.ignoreCase))
    {
        // empty
    }

    FileOperationPatternOptions::FileOperationPatternOptions(
        const FileOperationPatternOptions &other
    )
    {
        if (other.ignoreCase.has_value()) {
            ignoreCase = other.ignoreCase.value();
        }
    }

    FileOperationPatternOptions::~FileOperationPatternOptions()
    {
        // empty
    }

    auto FileOperationPatternOptions::operator=(
        FileOperationPatternOptions &&other
    ) -> FileOperationPatternOptions &
    {
        if (this != &other) {
            ignoreCase = std::move(other.ignoreCase);
        }
        return *this;
    }

    auto FileOperationPatternOptions::operator=(
        const FileOperationPatternOptions &other
    ) -> FileOperationPatternOptions &
    {
        if (this != &other) {
            if (other.ignoreCase.has_value()) {
                ignoreCase = other.ignoreCase.value();
            }
        }
        return *this;
    }

    FileOperationPattern::FileOperationPattern()
    {
        // empty
    }

    FileOperationPattern::FileOperationPattern(FileOperationPattern &&other)
        : glob(std::move(other.glob))
        , matches(std::move(other.matches))
        , options(std::move(other.options))
    {
        // empty
    }

    FileOperationPattern::FileOperationPattern(
        const FileOperationPattern &other
    )
        : glob(other.glob)
    {
        if (other.matches.has_value()) {
            matches = other.matches.value();
        }
        if (other.options.has_value()) {
            options = other.options.value();
        }
    }

    FileOperationPattern::~FileOperationPattern()
    {
        // empty
    }

    auto FileOperationPattern::operator=(
        FileOperationPattern &&other
    ) -> FileOperationPattern &
    {
        if (this != &other) {
            glob = std::move(other.glob);
            matches = std::move(other.matches);
            options = std::move(other.options);
        }
        return *this;
    }

    auto FileOperationPattern::operator=(
        const FileOperationPattern &other
    ) -> FileOperationPattern &
    {
        if (this != &other) {
            glob = other.glob;
            if (other.matches.has_value()) {
                matches = other.matches.value();
            }
            if (other.options.has_value()) {
                options = other.options.value();
            }
        }
        return *this;
    }

    FileOperationFilter::FileOperationFilter()
    {
        // empty
    }

    FileOperationFilter::FileOperationFilter(FileOperationFilter &&other)
        : scheme(std::move(other.scheme))
        , pattern(std::move(other.pattern))
    {
        // empty
    }

    FileOperationFilter::FileOperationFilter(const FileOperationFilter &other)
        : pattern(other.pattern)
    {
        if (other.scheme.has_value()) {
            scheme = other.scheme.value();
        }
    }

    FileOperationFilter::~FileOperationFilter()
    {
        // empty
    }

    auto FileOperationFilter::operator=(
        FileOperationFilter &&other
    ) -> FileOperationFilter &
    {
        if (this != &other) {
            scheme = std::move(other.scheme);
            pattern = std::move(other.pattern);
        }
        return *this;
    }

    auto FileOperationFilter::operator=(
        const FileOperationFilter &other
    ) -> FileOperationFilter &
    {
        if (this != &other) {
            if (other.scheme.has_value()) {
                scheme = other.scheme.value();
            }
            pattern = other.pattern;
        }
        return *this;
    }

    FileOperationRegistrationOptions::FileOperationRegistrationOptions()
    {
        // empty
    }

    FileOperationRegistrationOptions::FileOperationRegistrationOptions(
        FileOperationRegistrationOptions &&other
    )
        : filters(std::move(other.filters))
    {
        // empty
    }

    FileOperationRegistrationOptions::FileOperationRegistrationOptions(
        const FileOperationRegistrationOptions &other
    )
    {
        filters.reserve(other.filters.size());
        for (const auto &elem_0 : other.filters) {
            filters.push_back(elem_0);
        }
    }

    FileOperationRegistrationOptions::~FileOperationRegistrationOptions()
    {
        // empty
    }

    auto FileOperationRegistrationOptions::operator=(
        FileOperationRegistrationOptions &&other
    ) -> FileOperationRegistrationOptions &
    {
        if (this != &other) {
            filters = std::move(other.filters);
        }
        return *this;
    }

    auto FileOperationRegistrationOptions::operator=(
        const FileOperationRegistrationOptions &other
    ) -> FileOperationRegistrationOptions &
    {
        if (this != &other) {
            filters.reserve(other.filters.size());
            for (const auto &elem_0 : other.filters) {
                filters.push_back(elem_0);
            }
        }
        return *this;
    }

    FileOperationOptions::FileOperationOptions()
    {
        // empty
    }

    FileOperationOptions::FileOperationOptions(FileOperationOptions &&other)
        : didCreate(std::move(other.didCreate))
        , willCreate(std::move(other.willCreate))
        , didRename(std::move(other.didRename))
        , willRename(std::move(other.willRename))
        , didDelete(std::move(other.didDelete))
        , willDelete(std::move(other.willDelete))
    {
        // empty
    }

    FileOperationOptions::FileOperationOptions(
        const FileOperationOptions &other
    )
    {
        if (other.didCreate.has_value()) {
            didCreate = other.didCreate.value();
        }
        if (other.willCreate.has_value()) {
            willCreate = other.willCreate.value();
        }
        if (other.didRename.has_value()) {
            didRename = other.didRename.value();
        }
        if (other.willRename.has_value()) {
            willRename = other.willRename.value();
        }
        if (other.didDelete.has_value()) {
            didDelete = other.didDelete.value();
        }
        if (other.willDelete.has_value()) {
            willDelete = other.willDelete.value();
        }
    }

    FileOperationOptions::~FileOperationOptions()
    {
        // empty
    }

    auto FileOperationOptions::operator=(
        FileOperationOptions &&other
    ) -> FileOperationOptions &
    {
        if (this != &other) {
            didCreate = std::move(other.didCreate);
            willCreate = std::move(other.willCreate);
            didRename = std::move(other.didRename);
            willRename = std::move(other.willRename);
            didDelete = std::move(other.didDelete);
            willDelete = std::move(other.willDelete);
        }
        return *this;
    }

    auto FileOperationOptions::operator=(
        const FileOperationOptions &other
    ) -> FileOperationOptions &
    {
        if (this != &other) {
            if (other.didCreate.has_value()) {
                didCreate = other.didCreate.value();
            }
            if (other.willCreate.has_value()) {
                willCreate = other.willCreate.value();
            }
            if (other.didRename.has_value()) {
                didRename = other.didRename.value();
            }
            if (other.willRename.has_value()) {
                willRename = other.willRename.value();
            }
            if (other.didDelete.has_value()) {
                didDelete = other.didDelete.value();
            }
            if (other.willDelete.has_value()) {
                willDelete = other.willDelete.value();
            }
        }
        return *this;
    }

    ServerCapabilities_workspace::ServerCapabilities_workspace()
    {
        // empty
    }

    ServerCapabilities_workspace::ServerCapabilities_workspace(
        ServerCapabilities_workspace &&other
    )
        : workspaceFolders(std::move(other.workspaceFolders))
        , fileOperations(std::move(other.fileOperations))
    {
        // empty
    }

    ServerCapabilities_workspace::ServerCapabilities_workspace(
        const ServerCapabilities_workspace &other
    )
    {
        if (other.workspaceFolders.has_value()) {
            workspaceFolders = other.workspaceFolders.value();
        }
        if (other.fileOperations.has_value()) {
            fileOperations = other.fileOperations.value();
        }
    }

    ServerCapabilities_workspace::~ServerCapabilities_workspace()
    {
        // empty
    }

    auto ServerCapabilities_workspace::operator=(
        ServerCapabilities_workspace &&other
    ) -> ServerCapabilities_workspace &
    {
        if (this != &other) {
            workspaceFolders = std::move(other.workspaceFolders);
            fileOperations = std::move(other.fileOperations);
        }
        return *this;
    }

    auto ServerCapabilities_workspace::operator=(
        const ServerCapabilities_workspace &other
    ) -> ServerCapabilities_workspace &
    {
        if (this != &other) {
            if (other.workspaceFolders.has_value()) {
                workspaceFolders = other.workspaceFolders.value();
            }
            if (other.fileOperations.has_value()) {
                fileOperations = other.fileOperations.value();
            }
        }
        return *this;
    }

    GeneralClientCapabilities_staleRequestSupport::GeneralClientCapabilities_staleRequestSupport()
    {
        // empty
    }

    GeneralClientCapabilities_staleRequestSupport::GeneralClientCapabilities_staleRequestSupport(
        GeneralClientCapabilities_staleRequestSupport &&other
    )
        : cancel(other.cancel)
        , retryOnContentModified(std::move(other.retryOnContentModified))
    {
        // empty
    }

    GeneralClientCapabilities_staleRequestSupport::GeneralClientCapabilities_staleRequestSupport(
        const GeneralClientCapabilities_staleRequestSupport &other
    )
        : cancel(other.cancel)
    {
        retryOnContentModified = other.retryOnContentModified;
    }

    GeneralClientCapabilities_staleRequestSupport::~GeneralClientCapabilities_staleRequestSupport()
    {
        // empty
    }

    auto GeneralClientCapabilities_staleRequestSupport::operator=(
        GeneralClientCapabilities_staleRequestSupport &&other
    ) -> GeneralClientCapabilities_staleRequestSupport &
    {
        if (this != &other) {
            cancel = other.cancel;
            retryOnContentModified = std::move(other.retryOnContentModified);
        }
        return *this;
    }

    auto GeneralClientCapabilities_staleRequestSupport::operator=(
        const GeneralClientCapabilities_staleRequestSupport &other
    ) -> GeneralClientCapabilities_staleRequestSupport &
    {
        if (this != &other) {
            cancel = other.cancel;
            retryOnContentModified = other.retryOnContentModified;
        }
        return *this;
    }

    GeneralClientCapabilities::GeneralClientCapabilities()
    {
        // empty
    }

    GeneralClientCapabilities::GeneralClientCapabilities(
        GeneralClientCapabilities &&other
    )
        : staleRequestSupport(std::move(other.staleRequestSupport))
        , regularExpressions(std::move(other.regularExpressions))
        , markdown(std::move(other.markdown))
        , positionEncodings(std::move(other.positionEncodings))
    {
        // empty
    }

    GeneralClientCapabilities::GeneralClientCapabilities(
        const GeneralClientCapabilities &other
    )
    {
        if (other.staleRequestSupport.has_value()) {
            staleRequestSupport = other.staleRequestSupport.value();
        }
        if (other.regularExpressions.has_value()) {
            regularExpressions = other.regularExpressions.value();
        }
        if (other.markdown.has_value()) {
            markdown = other.markdown.value();
        }
        if (other.positionEncodings.has_value()) {
            auto &array_0 = positionEncodings.emplace();
            const auto &array_1 = other.positionEncodings.value();
            array_0 = array_1;
        }
    }

    GeneralClientCapabilities::~GeneralClientCapabilities()
    {
        // empty
    }

    auto GeneralClientCapabilities::operator=(
        GeneralClientCapabilities &&other
    ) -> GeneralClientCapabilities &
    {
        if (this != &other) {
            staleRequestSupport = std::move(other.staleRequestSupport);
            regularExpressions = std::move(other.regularExpressions);
            markdown = std::move(other.markdown);
            positionEncodings = std::move(other.positionEncodings);
        }
        return *this;
    }

    auto GeneralClientCapabilities::operator=(
        const GeneralClientCapabilities &other
    ) -> GeneralClientCapabilities &
    {
        if (this != &other) {
            if (other.staleRequestSupport.has_value()) {
                staleRequestSupport = other.staleRequestSupport.value();
            }
            if (other.regularExpressions.has_value()) {
                regularExpressions = other.regularExpressions.value();
            }
            if (other.markdown.has_value()) {
                markdown = other.markdown.value();
            }
            if (other.positionEncodings.has_value()) {
                auto &array_0 = positionEncodings.emplace();
                const auto &array_1 = other.positionEncodings.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    WorkspaceEditClientCapabilities_changeAnnotationSupport::WorkspaceEditClientCapabilities_changeAnnotationSupport()
    {
        // empty
    }

    WorkspaceEditClientCapabilities_changeAnnotationSupport::WorkspaceEditClientCapabilities_changeAnnotationSupport(
        WorkspaceEditClientCapabilities_changeAnnotationSupport &&other
    )
        : groupsOnLabel(std::move(other.groupsOnLabel))
    {
        // empty
    }

    WorkspaceEditClientCapabilities_changeAnnotationSupport::WorkspaceEditClientCapabilities_changeAnnotationSupport(
        const WorkspaceEditClientCapabilities_changeAnnotationSupport &other
    )
    {
        if (other.groupsOnLabel.has_value()) {
            groupsOnLabel = other.groupsOnLabel.value();
        }
    }

    WorkspaceEditClientCapabilities_changeAnnotationSupport::~WorkspaceEditClientCapabilities_changeAnnotationSupport()
    {
        // empty
    }

    auto WorkspaceEditClientCapabilities_changeAnnotationSupport::operator=(
        WorkspaceEditClientCapabilities_changeAnnotationSupport &&other
    ) -> WorkspaceEditClientCapabilities_changeAnnotationSupport &
    {
        if (this != &other) {
            groupsOnLabel = std::move(other.groupsOnLabel);
        }
        return *this;
    }

    auto WorkspaceEditClientCapabilities_changeAnnotationSupport::operator=(
        const WorkspaceEditClientCapabilities_changeAnnotationSupport &other
    ) -> WorkspaceEditClientCapabilities_changeAnnotationSupport &
    {
        if (this != &other) {
            if (other.groupsOnLabel.has_value()) {
                groupsOnLabel = other.groupsOnLabel.value();
            }
        }
        return *this;
    }

    WorkspaceEditClientCapabilities::WorkspaceEditClientCapabilities()
    {
        // empty
    }

    WorkspaceEditClientCapabilities::WorkspaceEditClientCapabilities(
        WorkspaceEditClientCapabilities &&other
    )
        : documentChanges(std::move(other.documentChanges))
        , resourceOperations(std::move(other.resourceOperations))
        , failureHandling(std::move(other.failureHandling))
        , normalizesLineEndings(std::move(other.normalizesLineEndings))
        , changeAnnotationSupport(std::move(other.changeAnnotationSupport))
    {
        // empty
    }

    WorkspaceEditClientCapabilities::WorkspaceEditClientCapabilities(
        const WorkspaceEditClientCapabilities &other
    )
    {
        if (other.documentChanges.has_value()) {
            documentChanges = other.documentChanges.value();
        }
        if (other.resourceOperations.has_value()) {
            auto &array_0 = resourceOperations.emplace();
            const auto &array_1 = other.resourceOperations.value();
            array_0 = array_1;
        }
        if (other.failureHandling.has_value()) {
            failureHandling = other.failureHandling.value();
        }
        if (other.normalizesLineEndings.has_value()) {
            normalizesLineEndings = other.normalizesLineEndings.value();
        }
        if (other.changeAnnotationSupport.has_value()) {
            changeAnnotationSupport = other.changeAnnotationSupport.value();
        }
    }

    WorkspaceEditClientCapabilities::~WorkspaceEditClientCapabilities()
    {
        // empty
    }

    auto WorkspaceEditClientCapabilities::operator=(
        WorkspaceEditClientCapabilities &&other
    ) -> WorkspaceEditClientCapabilities &
    {
        if (this != &other) {
            documentChanges = std::move(other.documentChanges);
            resourceOperations = std::move(other.resourceOperations);
            failureHandling = std::move(other.failureHandling);
            normalizesLineEndings = std::move(other.normalizesLineEndings);
            changeAnnotationSupport = std::move(other.changeAnnotationSupport);
        }
        return *this;
    }

    auto WorkspaceEditClientCapabilities::operator=(
        const WorkspaceEditClientCapabilities &other
    ) -> WorkspaceEditClientCapabilities &
    {
        if (this != &other) {
            if (other.documentChanges.has_value()) {
                documentChanges = other.documentChanges.value();
            }
            if (other.resourceOperations.has_value()) {
                auto &array_0 = resourceOperations.emplace();
                const auto &array_1 = other.resourceOperations.value();
                array_0 = array_1;
            }
            if (other.failureHandling.has_value()) {
                failureHandling = other.failureHandling.value();
            }
            if (other.normalizesLineEndings.has_value()) {
                normalizesLineEndings = other.normalizesLineEndings.value();
            }
            if (other.changeAnnotationSupport.has_value()) {
                changeAnnotationSupport =
                    other.changeAnnotationSupport.value();
            }
        }
        return *this;
    }

    DidChangeConfigurationClientCapabilities::DidChangeConfigurationClientCapabilities()
    {
        // empty
    }

    DidChangeConfigurationClientCapabilities::DidChangeConfigurationClientCapabilities(
        DidChangeConfigurationClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    DidChangeConfigurationClientCapabilities::DidChangeConfigurationClientCapabilities(
        const DidChangeConfigurationClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    DidChangeConfigurationClientCapabilities::~DidChangeConfigurationClientCapabilities()
    {
        // empty
    }

    auto DidChangeConfigurationClientCapabilities::operator=(
        DidChangeConfigurationClientCapabilities &&other
    ) -> DidChangeConfigurationClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto DidChangeConfigurationClientCapabilities::operator=(
        const DidChangeConfigurationClientCapabilities &other
    ) -> DidChangeConfigurationClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    DidChangeWatchedFilesClientCapabilities::DidChangeWatchedFilesClientCapabilities()
    {
        // empty
    }

    DidChangeWatchedFilesClientCapabilities::DidChangeWatchedFilesClientCapabilities(
        DidChangeWatchedFilesClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , relativePatternSupport(std::move(other.relativePatternSupport))
    {
        // empty
    }

    DidChangeWatchedFilesClientCapabilities::DidChangeWatchedFilesClientCapabilities(
        const DidChangeWatchedFilesClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.relativePatternSupport.has_value()) {
            relativePatternSupport = other.relativePatternSupport.value();
        }
    }

    DidChangeWatchedFilesClientCapabilities::~DidChangeWatchedFilesClientCapabilities()
    {
        // empty
    }

    auto DidChangeWatchedFilesClientCapabilities::operator=(
        DidChangeWatchedFilesClientCapabilities &&other
    ) -> DidChangeWatchedFilesClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            relativePatternSupport = std::move(other.relativePatternSupport);
        }
        return *this;
    }

    auto DidChangeWatchedFilesClientCapabilities::operator=(
        const DidChangeWatchedFilesClientCapabilities &other
    ) -> DidChangeWatchedFilesClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.relativePatternSupport.has_value()) {
                relativePatternSupport = other.relativePatternSupport.value();
            }
        }
        return *this;
    }

    WorkspaceSymbolClientCapabilities::WorkspaceSymbolClientCapabilities()
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities::WorkspaceSymbolClientCapabilities(
        WorkspaceSymbolClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , symbolKind(std::move(other.symbolKind))
        , tagSupport(std::move(other.tagSupport))
        , resolveSupport(std::move(other.resolveSupport))
    {
        // empty
    }

    WorkspaceSymbolClientCapabilities::WorkspaceSymbolClientCapabilities(
        const WorkspaceSymbolClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.symbolKind.has_value()) {
            symbolKind = other.symbolKind.value();
        }
        if (other.tagSupport.has_value()) {
            tagSupport = other.tagSupport.value();
        }
        if (other.resolveSupport.has_value()) {
            resolveSupport = other.resolveSupport.value();
        }
    }

    WorkspaceSymbolClientCapabilities::~WorkspaceSymbolClientCapabilities()
    {
        // empty
    }

    auto WorkspaceSymbolClientCapabilities::operator=(
        WorkspaceSymbolClientCapabilities &&other
    ) -> WorkspaceSymbolClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            symbolKind = std::move(other.symbolKind);
            tagSupport = std::move(other.tagSupport);
            resolveSupport = std::move(other.resolveSupport);
        }
        return *this;
    }

    auto WorkspaceSymbolClientCapabilities::operator=(
        const WorkspaceSymbolClientCapabilities &other
    ) -> WorkspaceSymbolClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.symbolKind.has_value()) {
                symbolKind = other.symbolKind.value();
            }
            if (other.tagSupport.has_value()) {
                tagSupport = other.tagSupport.value();
            }
            if (other.resolveSupport.has_value()) {
                resolveSupport = other.resolveSupport.value();
            }
        }
        return *this;
    }

    ExecuteCommandClientCapabilities::ExecuteCommandClientCapabilities()
    {
        // empty
    }

    ExecuteCommandClientCapabilities::ExecuteCommandClientCapabilities(
        ExecuteCommandClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    ExecuteCommandClientCapabilities::ExecuteCommandClientCapabilities(
        const ExecuteCommandClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    ExecuteCommandClientCapabilities::~ExecuteCommandClientCapabilities()
    {
        // empty
    }

    auto ExecuteCommandClientCapabilities::operator=(
        ExecuteCommandClientCapabilities &&other
    ) -> ExecuteCommandClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto ExecuteCommandClientCapabilities::operator=(
        const ExecuteCommandClientCapabilities &other
    ) -> ExecuteCommandClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    SemanticTokensWorkspaceClientCapabilities::SemanticTokensWorkspaceClientCapabilities()
    {
        // empty
    }

    SemanticTokensWorkspaceClientCapabilities::SemanticTokensWorkspaceClientCapabilities(
        SemanticTokensWorkspaceClientCapabilities &&other
    )
        : refreshSupport(std::move(other.refreshSupport))
    {
        // empty
    }

    SemanticTokensWorkspaceClientCapabilities::SemanticTokensWorkspaceClientCapabilities(
        const SemanticTokensWorkspaceClientCapabilities &other
    )
    {
        if (other.refreshSupport.has_value()) {
            refreshSupport = other.refreshSupport.value();
        }
    }

    SemanticTokensWorkspaceClientCapabilities::~SemanticTokensWorkspaceClientCapabilities()
    {
        // empty
    }

    auto SemanticTokensWorkspaceClientCapabilities::operator=(
        SemanticTokensWorkspaceClientCapabilities &&other
    ) -> SemanticTokensWorkspaceClientCapabilities &
    {
        if (this != &other) {
            refreshSupport = std::move(other.refreshSupport);
        }
        return *this;
    }

    auto SemanticTokensWorkspaceClientCapabilities::operator=(
        const SemanticTokensWorkspaceClientCapabilities &other
    ) -> SemanticTokensWorkspaceClientCapabilities &
    {
        if (this != &other) {
            if (other.refreshSupport.has_value()) {
                refreshSupport = other.refreshSupport.value();
            }
        }
        return *this;
    }

    CodeLensWorkspaceClientCapabilities::CodeLensWorkspaceClientCapabilities()
    {
        // empty
    }

    CodeLensWorkspaceClientCapabilities::CodeLensWorkspaceClientCapabilities(
        CodeLensWorkspaceClientCapabilities &&other
    )
        : refreshSupport(std::move(other.refreshSupport))
    {
        // empty
    }

    CodeLensWorkspaceClientCapabilities::CodeLensWorkspaceClientCapabilities(
        const CodeLensWorkspaceClientCapabilities &other
    )
    {
        if (other.refreshSupport.has_value()) {
            refreshSupport = other.refreshSupport.value();
        }
    }

    CodeLensWorkspaceClientCapabilities::~CodeLensWorkspaceClientCapabilities()
    {
        // empty
    }

    auto CodeLensWorkspaceClientCapabilities::operator=(
        CodeLensWorkspaceClientCapabilities &&other
    ) -> CodeLensWorkspaceClientCapabilities &
    {
        if (this != &other) {
            refreshSupport = std::move(other.refreshSupport);
        }
        return *this;
    }

    auto CodeLensWorkspaceClientCapabilities::operator=(
        const CodeLensWorkspaceClientCapabilities &other
    ) -> CodeLensWorkspaceClientCapabilities &
    {
        if (this != &other) {
            if (other.refreshSupport.has_value()) {
                refreshSupport = other.refreshSupport.value();
            }
        }
        return *this;
    }

    FileOperationClientCapabilities::FileOperationClientCapabilities()
    {
        // empty
    }

    FileOperationClientCapabilities::FileOperationClientCapabilities(
        FileOperationClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , didCreate(std::move(other.didCreate))
        , willCreate(std::move(other.willCreate))
        , didRename(std::move(other.didRename))
        , willRename(std::move(other.willRename))
        , didDelete(std::move(other.didDelete))
        , willDelete(std::move(other.willDelete))
    {
        // empty
    }

    FileOperationClientCapabilities::FileOperationClientCapabilities(
        const FileOperationClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.didCreate.has_value()) {
            didCreate = other.didCreate.value();
        }
        if (other.willCreate.has_value()) {
            willCreate = other.willCreate.value();
        }
        if (other.didRename.has_value()) {
            didRename = other.didRename.value();
        }
        if (other.willRename.has_value()) {
            willRename = other.willRename.value();
        }
        if (other.didDelete.has_value()) {
            didDelete = other.didDelete.value();
        }
        if (other.willDelete.has_value()) {
            willDelete = other.willDelete.value();
        }
    }

    FileOperationClientCapabilities::~FileOperationClientCapabilities()
    {
        // empty
    }

    auto FileOperationClientCapabilities::operator=(
        FileOperationClientCapabilities &&other
    ) -> FileOperationClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            didCreate = std::move(other.didCreate);
            willCreate = std::move(other.willCreate);
            didRename = std::move(other.didRename);
            willRename = std::move(other.willRename);
            didDelete = std::move(other.didDelete);
            willDelete = std::move(other.willDelete);
        }
        return *this;
    }

    auto FileOperationClientCapabilities::operator=(
        const FileOperationClientCapabilities &other
    ) -> FileOperationClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.didCreate.has_value()) {
                didCreate = other.didCreate.value();
            }
            if (other.willCreate.has_value()) {
                willCreate = other.willCreate.value();
            }
            if (other.didRename.has_value()) {
                didRename = other.didRename.value();
            }
            if (other.willRename.has_value()) {
                willRename = other.willRename.value();
            }
            if (other.didDelete.has_value()) {
                didDelete = other.didDelete.value();
            }
            if (other.willDelete.has_value()) {
                willDelete = other.willDelete.value();
            }
        }
        return *this;
    }

    InlineValueWorkspaceClientCapabilities::InlineValueWorkspaceClientCapabilities()
    {
        // empty
    }

    InlineValueWorkspaceClientCapabilities::InlineValueWorkspaceClientCapabilities(
        InlineValueWorkspaceClientCapabilities &&other
    )
        : refreshSupport(std::move(other.refreshSupport))
    {
        // empty
    }

    InlineValueWorkspaceClientCapabilities::InlineValueWorkspaceClientCapabilities(
        const InlineValueWorkspaceClientCapabilities &other
    )
    {
        if (other.refreshSupport.has_value()) {
            refreshSupport = other.refreshSupport.value();
        }
    }

    InlineValueWorkspaceClientCapabilities::~InlineValueWorkspaceClientCapabilities()
    {
        // empty
    }

    auto InlineValueWorkspaceClientCapabilities::operator=(
        InlineValueWorkspaceClientCapabilities &&other
    ) -> InlineValueWorkspaceClientCapabilities &
    {
        if (this != &other) {
            refreshSupport = std::move(other.refreshSupport);
        }
        return *this;
    }

    auto InlineValueWorkspaceClientCapabilities::operator=(
        const InlineValueWorkspaceClientCapabilities &other
    ) -> InlineValueWorkspaceClientCapabilities &
    {
        if (this != &other) {
            if (other.refreshSupport.has_value()) {
                refreshSupport = other.refreshSupport.value();
            }
        }
        return *this;
    }

    InlayHintWorkspaceClientCapabilities::InlayHintWorkspaceClientCapabilities()
    {
        // empty
    }

    InlayHintWorkspaceClientCapabilities::InlayHintWorkspaceClientCapabilities(
        InlayHintWorkspaceClientCapabilities &&other
    )
        : refreshSupport(std::move(other.refreshSupport))
    {
        // empty
    }

    InlayHintWorkspaceClientCapabilities::InlayHintWorkspaceClientCapabilities(
        const InlayHintWorkspaceClientCapabilities &other
    )
    {
        if (other.refreshSupport.has_value()) {
            refreshSupport = other.refreshSupport.value();
        }
    }

    InlayHintWorkspaceClientCapabilities::~InlayHintWorkspaceClientCapabilities()
    {
        // empty
    }

    auto InlayHintWorkspaceClientCapabilities::operator=(
        InlayHintWorkspaceClientCapabilities &&other
    ) -> InlayHintWorkspaceClientCapabilities &
    {
        if (this != &other) {
            refreshSupport = std::move(other.refreshSupport);
        }
        return *this;
    }

    auto InlayHintWorkspaceClientCapabilities::operator=(
        const InlayHintWorkspaceClientCapabilities &other
    ) -> InlayHintWorkspaceClientCapabilities &
    {
        if (this != &other) {
            if (other.refreshSupport.has_value()) {
                refreshSupport = other.refreshSupport.value();
            }
        }
        return *this;
    }

    DiagnosticWorkspaceClientCapabilities::DiagnosticWorkspaceClientCapabilities()
    {
        // empty
    }

    DiagnosticWorkspaceClientCapabilities::DiagnosticWorkspaceClientCapabilities(
        DiagnosticWorkspaceClientCapabilities &&other
    )
        : refreshSupport(std::move(other.refreshSupport))
    {
        // empty
    }

    DiagnosticWorkspaceClientCapabilities::DiagnosticWorkspaceClientCapabilities(
        const DiagnosticWorkspaceClientCapabilities &other
    )
    {
        if (other.refreshSupport.has_value()) {
            refreshSupport = other.refreshSupport.value();
        }
    }

    DiagnosticWorkspaceClientCapabilities::~DiagnosticWorkspaceClientCapabilities()
    {
        // empty
    }

    auto DiagnosticWorkspaceClientCapabilities::operator=(
        DiagnosticWorkspaceClientCapabilities &&other
    ) -> DiagnosticWorkspaceClientCapabilities &
    {
        if (this != &other) {
            refreshSupport = std::move(other.refreshSupport);
        }
        return *this;
    }

    auto DiagnosticWorkspaceClientCapabilities::operator=(
        const DiagnosticWorkspaceClientCapabilities &other
    ) -> DiagnosticWorkspaceClientCapabilities &
    {
        if (this != &other) {
            if (other.refreshSupport.has_value()) {
                refreshSupport = other.refreshSupport.value();
            }
        }
        return *this;
    }

    FoldingRangeWorkspaceClientCapabilities::FoldingRangeWorkspaceClientCapabilities()
    {
        // empty
    }

    FoldingRangeWorkspaceClientCapabilities::FoldingRangeWorkspaceClientCapabilities(
        FoldingRangeWorkspaceClientCapabilities &&other
    )
        : refreshSupport(std::move(other.refreshSupport))
    {
        // empty
    }

    FoldingRangeWorkspaceClientCapabilities::FoldingRangeWorkspaceClientCapabilities(
        const FoldingRangeWorkspaceClientCapabilities &other
    )
    {
        if (other.refreshSupport.has_value()) {
            refreshSupport = other.refreshSupport.value();
        }
    }

    FoldingRangeWorkspaceClientCapabilities::~FoldingRangeWorkspaceClientCapabilities()
    {
        // empty
    }

    auto FoldingRangeWorkspaceClientCapabilities::operator=(
        FoldingRangeWorkspaceClientCapabilities &&other
    ) -> FoldingRangeWorkspaceClientCapabilities &
    {
        if (this != &other) {
            refreshSupport = std::move(other.refreshSupport);
        }
        return *this;
    }

    auto FoldingRangeWorkspaceClientCapabilities::operator=(
        const FoldingRangeWorkspaceClientCapabilities &other
    ) -> FoldingRangeWorkspaceClientCapabilities &
    {
        if (this != &other) {
            if (other.refreshSupport.has_value()) {
                refreshSupport = other.refreshSupport.value();
            }
        }
        return *this;
    }

    WorkspaceClientCapabilities::WorkspaceClientCapabilities()
    {
        // empty
    }

    WorkspaceClientCapabilities::WorkspaceClientCapabilities(
        WorkspaceClientCapabilities &&other
    )
        : applyEdit(std::move(other.applyEdit))
        , workspaceEdit(std::move(other.workspaceEdit))
        , didChangeConfiguration(std::move(other.didChangeConfiguration))
        , didChangeWatchedFiles(std::move(other.didChangeWatchedFiles))
        , symbol(std::move(other.symbol))
        , executeCommand(std::move(other.executeCommand))
        , workspaceFolders(std::move(other.workspaceFolders))
        , configuration(std::move(other.configuration))
        , semanticTokens(std::move(other.semanticTokens))
        , codeLens(std::move(other.codeLens))
        , fileOperations(std::move(other.fileOperations))
        , inlineValue(std::move(other.inlineValue))
        , inlayHint(std::move(other.inlayHint))
        , diagnostics(std::move(other.diagnostics))
        , foldingRange(std::move(other.foldingRange))
    {
        // empty
    }

    WorkspaceClientCapabilities::WorkspaceClientCapabilities(
        const WorkspaceClientCapabilities &other
    )
    {
        if (other.applyEdit.has_value()) {
            applyEdit = other.applyEdit.value();
        }
        if (other.workspaceEdit.has_value()) {
            workspaceEdit = other.workspaceEdit.value();
        }
        if (other.didChangeConfiguration.has_value()) {
            didChangeConfiguration = other.didChangeConfiguration.value();
        }
        if (other.didChangeWatchedFiles.has_value()) {
            didChangeWatchedFiles = other.didChangeWatchedFiles.value();
        }
        if (other.symbol.has_value()) {
            symbol = other.symbol.value();
        }
        if (other.executeCommand.has_value()) {
            executeCommand = other.executeCommand.value();
        }
        if (other.workspaceFolders.has_value()) {
            workspaceFolders = other.workspaceFolders.value();
        }
        if (other.configuration.has_value()) {
            configuration = other.configuration.value();
        }
        if (other.semanticTokens.has_value()) {
            semanticTokens = other.semanticTokens.value();
        }
        if (other.codeLens.has_value()) {
            codeLens = other.codeLens.value();
        }
        if (other.fileOperations.has_value()) {
            fileOperations = other.fileOperations.value();
        }
        if (other.inlineValue.has_value()) {
            inlineValue = other.inlineValue.value();
        }
        if (other.inlayHint.has_value()) {
            inlayHint = other.inlayHint.value();
        }
        if (other.diagnostics.has_value()) {
            diagnostics = other.diagnostics.value();
        }
        if (other.foldingRange.has_value()) {
            foldingRange = other.foldingRange.value();
        }
    }

    WorkspaceClientCapabilities::~WorkspaceClientCapabilities()
    {
        // empty
    }

    auto WorkspaceClientCapabilities::operator=(
        WorkspaceClientCapabilities &&other
    ) -> WorkspaceClientCapabilities &
    {
        if (this != &other) {
            applyEdit = std::move(other.applyEdit);
            workspaceEdit = std::move(other.workspaceEdit);
            didChangeConfiguration = std::move(other.didChangeConfiguration);
            didChangeWatchedFiles = std::move(other.didChangeWatchedFiles);
            symbol = std::move(other.symbol);
            executeCommand = std::move(other.executeCommand);
            workspaceFolders = std::move(other.workspaceFolders);
            configuration = std::move(other.configuration);
            semanticTokens = std::move(other.semanticTokens);
            codeLens = std::move(other.codeLens);
            fileOperations = std::move(other.fileOperations);
            inlineValue = std::move(other.inlineValue);
            inlayHint = std::move(other.inlayHint);
            diagnostics = std::move(other.diagnostics);
            foldingRange = std::move(other.foldingRange);
        }
        return *this;
    }

    auto WorkspaceClientCapabilities::operator=(
        const WorkspaceClientCapabilities &other
    ) -> WorkspaceClientCapabilities &
    {
        if (this != &other) {
            if (other.applyEdit.has_value()) {
                applyEdit = other.applyEdit.value();
            }
            if (other.workspaceEdit.has_value()) {
                workspaceEdit = other.workspaceEdit.value();
            }
            if (other.didChangeConfiguration.has_value()) {
                didChangeConfiguration = other.didChangeConfiguration.value();
            }
            if (other.didChangeWatchedFiles.has_value()) {
                didChangeWatchedFiles = other.didChangeWatchedFiles.value();
            }
            if (other.symbol.has_value()) {
                symbol = other.symbol.value();
            }
            if (other.executeCommand.has_value()) {
                executeCommand = other.executeCommand.value();
            }
            if (other.workspaceFolders.has_value()) {
                workspaceFolders = other.workspaceFolders.value();
            }
            if (other.configuration.has_value()) {
                configuration = other.configuration.value();
            }
            if (other.semanticTokens.has_value()) {
                semanticTokens = other.semanticTokens.value();
            }
            if (other.codeLens.has_value()) {
                codeLens = other.codeLens.value();
            }
            if (other.fileOperations.has_value()) {
                fileOperations = other.fileOperations.value();
            }
            if (other.inlineValue.has_value()) {
                inlineValue = other.inlineValue.value();
            }
            if (other.inlayHint.has_value()) {
                inlayHint = other.inlayHint.value();
            }
            if (other.diagnostics.has_value()) {
                diagnostics = other.diagnostics.value();
            }
            if (other.foldingRange.has_value()) {
                foldingRange = other.foldingRange.value();
            }
        }
        return *this;
    }

    TextDocumentSyncClientCapabilities::TextDocumentSyncClientCapabilities()
    {
        // empty
    }

    TextDocumentSyncClientCapabilities::TextDocumentSyncClientCapabilities(
        TextDocumentSyncClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , willSave(std::move(other.willSave))
        , willSaveWaitUntil(std::move(other.willSaveWaitUntil))
        , didSave(std::move(other.didSave))
    {
        // empty
    }

    TextDocumentSyncClientCapabilities::TextDocumentSyncClientCapabilities(
        const TextDocumentSyncClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.willSave.has_value()) {
            willSave = other.willSave.value();
        }
        if (other.willSaveWaitUntil.has_value()) {
            willSaveWaitUntil = other.willSaveWaitUntil.value();
        }
        if (other.didSave.has_value()) {
            didSave = other.didSave.value();
        }
    }

    TextDocumentSyncClientCapabilities::~TextDocumentSyncClientCapabilities()
    {
        // empty
    }

    auto TextDocumentSyncClientCapabilities::operator=(
        TextDocumentSyncClientCapabilities &&other
    ) -> TextDocumentSyncClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            willSave = std::move(other.willSave);
            willSaveWaitUntil = std::move(other.willSaveWaitUntil);
            didSave = std::move(other.didSave);
        }
        return *this;
    }

    auto TextDocumentSyncClientCapabilities::operator=(
        const TextDocumentSyncClientCapabilities &other
    ) -> TextDocumentSyncClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.willSave.has_value()) {
                willSave = other.willSave.value();
            }
            if (other.willSaveWaitUntil.has_value()) {
                willSaveWaitUntil = other.willSaveWaitUntil.value();
            }
            if (other.didSave.has_value()) {
                didSave = other.didSave.value();
            }
        }
        return *this;
    }

    CompletionClientCapabilities_completionItem::CompletionClientCapabilities_completionItem()
    {
        // empty
    }

    CompletionClientCapabilities_completionItem::CompletionClientCapabilities_completionItem(
        CompletionClientCapabilities_completionItem &&other
    )
        : snippetSupport(std::move(other.snippetSupport))
        , commitCharactersSupport(std::move(other.commitCharactersSupport))
        , documentationFormat(std::move(other.documentationFormat))
        , deprecatedSupport(std::move(other.deprecatedSupport))
        , preselectSupport(std::move(other.preselectSupport))
        , tagSupport(std::move(other.tagSupport))
        , insertReplaceSupport(std::move(other.insertReplaceSupport))
        , resolveSupport(std::move(other.resolveSupport))
        , insertTextModeSupport(std::move(other.insertTextModeSupport))
        , labelDetailsSupport(std::move(other.labelDetailsSupport))
    {
        // empty
    }

    CompletionClientCapabilities_completionItem::CompletionClientCapabilities_completionItem(
        const CompletionClientCapabilities_completionItem &other
    )
    {
        if (other.snippetSupport.has_value()) {
            snippetSupport = other.snippetSupport.value();
        }
        if (other.commitCharactersSupport.has_value()) {
            commitCharactersSupport = other.commitCharactersSupport.value();
        }
        if (other.documentationFormat.has_value()) {
            auto &array_0 = documentationFormat.emplace();
            const auto &array_1 = other.documentationFormat.value();
            array_0 = array_1;
        }
        if (other.deprecatedSupport.has_value()) {
            deprecatedSupport = other.deprecatedSupport.value();
        }
        if (other.preselectSupport.has_value()) {
            preselectSupport = other.preselectSupport.value();
        }
        if (other.tagSupport.has_value()) {
            tagSupport = other.tagSupport.value();
        }
        if (other.insertReplaceSupport.has_value()) {
            insertReplaceSupport = other.insertReplaceSupport.value();
        }
        if (other.resolveSupport.has_value()) {
            resolveSupport = other.resolveSupport.value();
        }
        if (other.insertTextModeSupport.has_value()) {
            insertTextModeSupport = other.insertTextModeSupport.value();
        }
        if (other.labelDetailsSupport.has_value()) {
            labelDetailsSupport = other.labelDetailsSupport.value();
        }
    }

    CompletionClientCapabilities_completionItem::~CompletionClientCapabilities_completionItem()
    {
        // empty
    }

    auto CompletionClientCapabilities_completionItem::operator=(
        CompletionClientCapabilities_completionItem &&other
    ) -> CompletionClientCapabilities_completionItem &
    {
        if (this != &other) {
            snippetSupport = std::move(other.snippetSupport);
            commitCharactersSupport = std::move(other.commitCharactersSupport);
            documentationFormat = std::move(other.documentationFormat);
            deprecatedSupport = std::move(other.deprecatedSupport);
            preselectSupport = std::move(other.preselectSupport);
            tagSupport = std::move(other.tagSupport);
            insertReplaceSupport = std::move(other.insertReplaceSupport);
            resolveSupport = std::move(other.resolveSupport);
            insertTextModeSupport = std::move(other.insertTextModeSupport);
            labelDetailsSupport = std::move(other.labelDetailsSupport);
        }
        return *this;
    }

    auto CompletionClientCapabilities_completionItem::operator=(
        const CompletionClientCapabilities_completionItem &other
    ) -> CompletionClientCapabilities_completionItem &
    {
        if (this != &other) {
            if (other.snippetSupport.has_value()) {
                snippetSupport = other.snippetSupport.value();
            }
            if (other.commitCharactersSupport.has_value()) {
                commitCharactersSupport =
                    other.commitCharactersSupport.value();
            }
            if (other.documentationFormat.has_value()) {
                auto &array_0 = documentationFormat.emplace();
                const auto &array_1 = other.documentationFormat.value();
                array_0 = array_1;
            }
            if (other.deprecatedSupport.has_value()) {
                deprecatedSupport = other.deprecatedSupport.value();
            }
            if (other.preselectSupport.has_value()) {
                preselectSupport = other.preselectSupport.value();
            }
            if (other.tagSupport.has_value()) {
                tagSupport = other.tagSupport.value();
            }
            if (other.insertReplaceSupport.has_value()) {
                insertReplaceSupport = other.insertReplaceSupport.value();
            }
            if (other.resolveSupport.has_value()) {
                resolveSupport = other.resolveSupport.value();
            }
            if (other.insertTextModeSupport.has_value()) {
                insertTextModeSupport = other.insertTextModeSupport.value();
            }
            if (other.labelDetailsSupport.has_value()) {
                labelDetailsSupport = other.labelDetailsSupport.value();
            }
        }
        return *this;
    }

    CompletionClientCapabilities::CompletionClientCapabilities()
    {
        // empty
    }

    CompletionClientCapabilities::CompletionClientCapabilities(
        CompletionClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , completionItem(std::move(other.completionItem))
        , completionItemKind(std::move(other.completionItemKind))
        , insertTextMode(std::move(other.insertTextMode))
        , contextSupport(std::move(other.contextSupport))
        , completionList(std::move(other.completionList))
    {
        // empty
    }

    CompletionClientCapabilities::CompletionClientCapabilities(
        const CompletionClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.completionItem.has_value()) {
            completionItem = other.completionItem.value();
        }
        if (other.completionItemKind.has_value()) {
            completionItemKind = other.completionItemKind.value();
        }
        if (other.insertTextMode.has_value()) {
            insertTextMode = other.insertTextMode.value();
        }
        if (other.contextSupport.has_value()) {
            contextSupport = other.contextSupport.value();
        }
        if (other.completionList.has_value()) {
            completionList = other.completionList.value();
        }
    }

    CompletionClientCapabilities::~CompletionClientCapabilities()
    {
        // empty
    }

    auto CompletionClientCapabilities::operator=(
        CompletionClientCapabilities &&other
    ) -> CompletionClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            completionItem = std::move(other.completionItem);
            completionItemKind = std::move(other.completionItemKind);
            insertTextMode = std::move(other.insertTextMode);
            contextSupport = std::move(other.contextSupport);
            completionList = std::move(other.completionList);
        }
        return *this;
    }

    auto CompletionClientCapabilities::operator=(
        const CompletionClientCapabilities &other
    ) -> CompletionClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.completionItem.has_value()) {
                completionItem = other.completionItem.value();
            }
            if (other.completionItemKind.has_value()) {
                completionItemKind = other.completionItemKind.value();
            }
            if (other.insertTextMode.has_value()) {
                insertTextMode = other.insertTextMode.value();
            }
            if (other.contextSupport.has_value()) {
                contextSupport = other.contextSupport.value();
            }
            if (other.completionList.has_value()) {
                completionList = other.completionList.value();
            }
        }
        return *this;
    }

    HoverClientCapabilities::HoverClientCapabilities()
    {
        // empty
    }

    HoverClientCapabilities::HoverClientCapabilities(
        HoverClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , contentFormat(std::move(other.contentFormat))
    {
        // empty
    }

    HoverClientCapabilities::HoverClientCapabilities(
        const HoverClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.contentFormat.has_value()) {
            auto &array_0 = contentFormat.emplace();
            const auto &array_1 = other.contentFormat.value();
            array_0 = array_1;
        }
    }

    HoverClientCapabilities::~HoverClientCapabilities()
    {
        // empty
    }

    auto HoverClientCapabilities::operator=(
        HoverClientCapabilities &&other
    ) -> HoverClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            contentFormat = std::move(other.contentFormat);
        }
        return *this;
    }

    auto HoverClientCapabilities::operator=(
        const HoverClientCapabilities &other
    ) -> HoverClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.contentFormat.has_value()) {
                auto &array_0 = contentFormat.emplace();
                const auto &array_1 = other.contentFormat.value();
                array_0 = array_1;
            }
        }
        return *this;
    }

    SignatureHelpClientCapabilities_signatureInformation_parameterInformation::SignatureHelpClientCapabilities_signatureInformation_parameterInformation()
    {
        // empty
    }

    SignatureHelpClientCapabilities_signatureInformation_parameterInformation::SignatureHelpClientCapabilities_signatureInformation_parameterInformation(
        SignatureHelpClientCapabilities_signatureInformation_parameterInformation &&other
    )
        : labelOffsetSupport(std::move(other.labelOffsetSupport))
    {
        // empty
    }

    SignatureHelpClientCapabilities_signatureInformation_parameterInformation::SignatureHelpClientCapabilities_signatureInformation_parameterInformation(
        const SignatureHelpClientCapabilities_signatureInformation_parameterInformation &other
    )
    {
        if (other.labelOffsetSupport.has_value()) {
            labelOffsetSupport = other.labelOffsetSupport.value();
        }
    }

    SignatureHelpClientCapabilities_signatureInformation_parameterInformation::~SignatureHelpClientCapabilities_signatureInformation_parameterInformation()
    {
        // empty
    }

    auto SignatureHelpClientCapabilities_signatureInformation_parameterInformation::operator=(
        SignatureHelpClientCapabilities_signatureInformation_parameterInformation &&other
    ) -> SignatureHelpClientCapabilities_signatureInformation_parameterInformation &
    {
        if (this != &other) {
            labelOffsetSupport = std::move(other.labelOffsetSupport);
        }
        return *this;
    }

    auto SignatureHelpClientCapabilities_signatureInformation_parameterInformation::operator=(
        const SignatureHelpClientCapabilities_signatureInformation_parameterInformation &other
    ) -> SignatureHelpClientCapabilities_signatureInformation_parameterInformation &
    {
        if (this != &other) {
            if (other.labelOffsetSupport.has_value()) {
                labelOffsetSupport = other.labelOffsetSupport.value();
            }
        }
        return *this;
    }

    SignatureHelpClientCapabilities_signatureInformation::SignatureHelpClientCapabilities_signatureInformation()
    {
        // empty
    }

    SignatureHelpClientCapabilities_signatureInformation::SignatureHelpClientCapabilities_signatureInformation(
        SignatureHelpClientCapabilities_signatureInformation &&other
    )
        : documentationFormat(std::move(other.documentationFormat))
        , parameterInformation(std::move(other.parameterInformation))
        , activeParameterSupport(std::move(other.activeParameterSupport))
    {
        // empty
    }

    SignatureHelpClientCapabilities_signatureInformation::SignatureHelpClientCapabilities_signatureInformation(
        const SignatureHelpClientCapabilities_signatureInformation &other
    )
    {
        if (other.documentationFormat.has_value()) {
            auto &array_0 = documentationFormat.emplace();
            const auto &array_1 = other.documentationFormat.value();
            array_0 = array_1;
        }
        if (other.parameterInformation.has_value()) {
            parameterInformation = other.parameterInformation.value();
        }
        if (other.activeParameterSupport.has_value()) {
            activeParameterSupport = other.activeParameterSupport.value();
        }
    }

    SignatureHelpClientCapabilities_signatureInformation::~SignatureHelpClientCapabilities_signatureInformation()
    {
        // empty
    }

    auto SignatureHelpClientCapabilities_signatureInformation::operator=(
        SignatureHelpClientCapabilities_signatureInformation &&other
    ) -> SignatureHelpClientCapabilities_signatureInformation &
    {
        if (this != &other) {
            documentationFormat = std::move(other.documentationFormat);
            parameterInformation = std::move(other.parameterInformation);
            activeParameterSupport = std::move(other.activeParameterSupport);
        }
        return *this;
    }

    auto SignatureHelpClientCapabilities_signatureInformation::operator=(
        const SignatureHelpClientCapabilities_signatureInformation &other
    ) -> SignatureHelpClientCapabilities_signatureInformation &
    {
        if (this != &other) {
            if (other.documentationFormat.has_value()) {
                auto &array_0 = documentationFormat.emplace();
                const auto &array_1 = other.documentationFormat.value();
                array_0 = array_1;
            }
            if (other.parameterInformation.has_value()) {
                parameterInformation = other.parameterInformation.value();
            }
            if (other.activeParameterSupport.has_value()) {
                activeParameterSupport = other.activeParameterSupport.value();
            }
        }
        return *this;
    }

    SignatureHelpClientCapabilities::SignatureHelpClientCapabilities()
    {
        // empty
    }

    SignatureHelpClientCapabilities::SignatureHelpClientCapabilities(
        SignatureHelpClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , signatureInformation(std::move(other.signatureInformation))
        , contextSupport(std::move(other.contextSupport))
    {
        // empty
    }

    SignatureHelpClientCapabilities::SignatureHelpClientCapabilities(
        const SignatureHelpClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.signatureInformation.has_value()) {
            signatureInformation = other.signatureInformation.value();
        }
        if (other.contextSupport.has_value()) {
            contextSupport = other.contextSupport.value();
        }
    }

    SignatureHelpClientCapabilities::~SignatureHelpClientCapabilities()
    {
        // empty
    }

    auto SignatureHelpClientCapabilities::operator=(
        SignatureHelpClientCapabilities &&other
    ) -> SignatureHelpClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            signatureInformation = std::move(other.signatureInformation);
            contextSupport = std::move(other.contextSupport);
        }
        return *this;
    }

    auto SignatureHelpClientCapabilities::operator=(
        const SignatureHelpClientCapabilities &other
    ) -> SignatureHelpClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.signatureInformation.has_value()) {
                signatureInformation = other.signatureInformation.value();
            }
            if (other.contextSupport.has_value()) {
                contextSupport = other.contextSupport.value();
            }
        }
        return *this;
    }

    DeclarationClientCapabilities::DeclarationClientCapabilities()
    {
        // empty
    }

    DeclarationClientCapabilities::DeclarationClientCapabilities(
        DeclarationClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , linkSupport(std::move(other.linkSupport))
    {
        // empty
    }

    DeclarationClientCapabilities::DeclarationClientCapabilities(
        const DeclarationClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.linkSupport.has_value()) {
            linkSupport = other.linkSupport.value();
        }
    }

    DeclarationClientCapabilities::~DeclarationClientCapabilities()
    {
        // empty
    }

    auto DeclarationClientCapabilities::operator=(
        DeclarationClientCapabilities &&other
    ) -> DeclarationClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            linkSupport = std::move(other.linkSupport);
        }
        return *this;
    }

    auto DeclarationClientCapabilities::operator=(
        const DeclarationClientCapabilities &other
    ) -> DeclarationClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.linkSupport.has_value()) {
                linkSupport = other.linkSupport.value();
            }
        }
        return *this;
    }

    DefinitionClientCapabilities::DefinitionClientCapabilities()
    {
        // empty
    }

    DefinitionClientCapabilities::DefinitionClientCapabilities(
        DefinitionClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , linkSupport(std::move(other.linkSupport))
    {
        // empty
    }

    DefinitionClientCapabilities::DefinitionClientCapabilities(
        const DefinitionClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.linkSupport.has_value()) {
            linkSupport = other.linkSupport.value();
        }
    }

    DefinitionClientCapabilities::~DefinitionClientCapabilities()
    {
        // empty
    }

    auto DefinitionClientCapabilities::operator=(
        DefinitionClientCapabilities &&other
    ) -> DefinitionClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            linkSupport = std::move(other.linkSupport);
        }
        return *this;
    }

    auto DefinitionClientCapabilities::operator=(
        const DefinitionClientCapabilities &other
    ) -> DefinitionClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.linkSupport.has_value()) {
                linkSupport = other.linkSupport.value();
            }
        }
        return *this;
    }

    TypeDefinitionClientCapabilities::TypeDefinitionClientCapabilities()
    {
        // empty
    }

    TypeDefinitionClientCapabilities::TypeDefinitionClientCapabilities(
        TypeDefinitionClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , linkSupport(std::move(other.linkSupport))
    {
        // empty
    }

    TypeDefinitionClientCapabilities::TypeDefinitionClientCapabilities(
        const TypeDefinitionClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.linkSupport.has_value()) {
            linkSupport = other.linkSupport.value();
        }
    }

    TypeDefinitionClientCapabilities::~TypeDefinitionClientCapabilities()
    {
        // empty
    }

    auto TypeDefinitionClientCapabilities::operator=(
        TypeDefinitionClientCapabilities &&other
    ) -> TypeDefinitionClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            linkSupport = std::move(other.linkSupport);
        }
        return *this;
    }

    auto TypeDefinitionClientCapabilities::operator=(
        const TypeDefinitionClientCapabilities &other
    ) -> TypeDefinitionClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.linkSupport.has_value()) {
                linkSupport = other.linkSupport.value();
            }
        }
        return *this;
    }

    ImplementationClientCapabilities::ImplementationClientCapabilities()
    {
        // empty
    }

    ImplementationClientCapabilities::ImplementationClientCapabilities(
        ImplementationClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , linkSupport(std::move(other.linkSupport))
    {
        // empty
    }

    ImplementationClientCapabilities::ImplementationClientCapabilities(
        const ImplementationClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.linkSupport.has_value()) {
            linkSupport = other.linkSupport.value();
        }
    }

    ImplementationClientCapabilities::~ImplementationClientCapabilities()
    {
        // empty
    }

    auto ImplementationClientCapabilities::operator=(
        ImplementationClientCapabilities &&other
    ) -> ImplementationClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            linkSupport = std::move(other.linkSupport);
        }
        return *this;
    }

    auto ImplementationClientCapabilities::operator=(
        const ImplementationClientCapabilities &other
    ) -> ImplementationClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.linkSupport.has_value()) {
                linkSupport = other.linkSupport.value();
            }
        }
        return *this;
    }

    ReferenceClientCapabilities::ReferenceClientCapabilities()
    {
        // empty
    }

    ReferenceClientCapabilities::ReferenceClientCapabilities(
        ReferenceClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    ReferenceClientCapabilities::ReferenceClientCapabilities(
        const ReferenceClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    ReferenceClientCapabilities::~ReferenceClientCapabilities()
    {
        // empty
    }

    auto ReferenceClientCapabilities::operator=(
        ReferenceClientCapabilities &&other
    ) -> ReferenceClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto ReferenceClientCapabilities::operator=(
        const ReferenceClientCapabilities &other
    ) -> ReferenceClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    DocumentHighlightClientCapabilities::DocumentHighlightClientCapabilities()
    {
        // empty
    }

    DocumentHighlightClientCapabilities::DocumentHighlightClientCapabilities(
        DocumentHighlightClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    DocumentHighlightClientCapabilities::DocumentHighlightClientCapabilities(
        const DocumentHighlightClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    DocumentHighlightClientCapabilities::~DocumentHighlightClientCapabilities()
    {
        // empty
    }

    auto DocumentHighlightClientCapabilities::operator=(
        DocumentHighlightClientCapabilities &&other
    ) -> DocumentHighlightClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto DocumentHighlightClientCapabilities::operator=(
        const DocumentHighlightClientCapabilities &other
    ) -> DocumentHighlightClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    DocumentSymbolClientCapabilities::DocumentSymbolClientCapabilities()
    {
        // empty
    }

    DocumentSymbolClientCapabilities::DocumentSymbolClientCapabilities(
        DocumentSymbolClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , symbolKind(std::move(other.symbolKind))
        , hierarchicalDocumentSymbolSupport(std::move(other.hierarchicalDocumentSymbolSupport))
        , tagSupport(std::move(other.tagSupport))
        , labelSupport(std::move(other.labelSupport))
    {
        // empty
    }

    DocumentSymbolClientCapabilities::DocumentSymbolClientCapabilities(
        const DocumentSymbolClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.symbolKind.has_value()) {
            symbolKind = other.symbolKind.value();
        }
        if (other.hierarchicalDocumentSymbolSupport.has_value()) {
            hierarchicalDocumentSymbolSupport =
                other.hierarchicalDocumentSymbolSupport.value();
        }
        if (other.tagSupport.has_value()) {
            tagSupport = other.tagSupport.value();
        }
        if (other.labelSupport.has_value()) {
            labelSupport = other.labelSupport.value();
        }
    }

    DocumentSymbolClientCapabilities::~DocumentSymbolClientCapabilities()
    {
        // empty
    }

    auto DocumentSymbolClientCapabilities::operator=(
        DocumentSymbolClientCapabilities &&other
    ) -> DocumentSymbolClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            symbolKind = std::move(other.symbolKind);
            hierarchicalDocumentSymbolSupport =
                std::move(other.hierarchicalDocumentSymbolSupport);
            tagSupport = std::move(other.tagSupport);
            labelSupport = std::move(other.labelSupport);
        }
        return *this;
    }

    auto DocumentSymbolClientCapabilities::operator=(
        const DocumentSymbolClientCapabilities &other
    ) -> DocumentSymbolClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.symbolKind.has_value()) {
                symbolKind = other.symbolKind.value();
            }
            if (other.hierarchicalDocumentSymbolSupport.has_value()) {
                hierarchicalDocumentSymbolSupport =
                    other.hierarchicalDocumentSymbolSupport.value();
            }
            if (other.tagSupport.has_value()) {
                tagSupport = other.tagSupport.value();
            }
            if (other.labelSupport.has_value()) {
                labelSupport = other.labelSupport.value();
            }
        }
        return *this;
    }

    CodeActionClientCapabilities::CodeActionClientCapabilities()
    {
        // empty
    }

    CodeActionClientCapabilities::CodeActionClientCapabilities(
        CodeActionClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , codeActionLiteralSupport(std::move(other.codeActionLiteralSupport))
        , isPreferredSupport(std::move(other.isPreferredSupport))
        , disabledSupport(std::move(other.disabledSupport))
        , dataSupport(std::move(other.dataSupport))
        , resolveSupport(std::move(other.resolveSupport))
        , honorsChangeAnnotations(std::move(other.honorsChangeAnnotations))
    {
        // empty
    }

    CodeActionClientCapabilities::CodeActionClientCapabilities(
        const CodeActionClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.codeActionLiteralSupport.has_value()) {
            codeActionLiteralSupport = other.codeActionLiteralSupport.value();
        }
        if (other.isPreferredSupport.has_value()) {
            isPreferredSupport = other.isPreferredSupport.value();
        }
        if (other.disabledSupport.has_value()) {
            disabledSupport = other.disabledSupport.value();
        }
        if (other.dataSupport.has_value()) {
            dataSupport = other.dataSupport.value();
        }
        if (other.resolveSupport.has_value()) {
            resolveSupport = other.resolveSupport.value();
        }
        if (other.honorsChangeAnnotations.has_value()) {
            honorsChangeAnnotations = other.honorsChangeAnnotations.value();
        }
    }

    CodeActionClientCapabilities::~CodeActionClientCapabilities()
    {
        // empty
    }

    auto CodeActionClientCapabilities::operator=(
        CodeActionClientCapabilities &&other
    ) -> CodeActionClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            codeActionLiteralSupport =
                std::move(other.codeActionLiteralSupport);
            isPreferredSupport = std::move(other.isPreferredSupport);
            disabledSupport = std::move(other.disabledSupport);
            dataSupport = std::move(other.dataSupport);
            resolveSupport = std::move(other.resolveSupport);
            honorsChangeAnnotations = std::move(other.honorsChangeAnnotations);
        }
        return *this;
    }

    auto CodeActionClientCapabilities::operator=(
        const CodeActionClientCapabilities &other
    ) -> CodeActionClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.codeActionLiteralSupport.has_value()) {
                codeActionLiteralSupport =
                    other.codeActionLiteralSupport.value();
            }
            if (other.isPreferredSupport.has_value()) {
                isPreferredSupport = other.isPreferredSupport.value();
            }
            if (other.disabledSupport.has_value()) {
                disabledSupport = other.disabledSupport.value();
            }
            if (other.dataSupport.has_value()) {
                dataSupport = other.dataSupport.value();
            }
            if (other.resolveSupport.has_value()) {
                resolveSupport = other.resolveSupport.value();
            }
            if (other.honorsChangeAnnotations.has_value()) {
                honorsChangeAnnotations =
                    other.honorsChangeAnnotations.value();
            }
        }
        return *this;
    }

    CodeLensClientCapabilities::CodeLensClientCapabilities()
    {
        // empty
    }

    CodeLensClientCapabilities::CodeLensClientCapabilities(
        CodeLensClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    CodeLensClientCapabilities::CodeLensClientCapabilities(
        const CodeLensClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    CodeLensClientCapabilities::~CodeLensClientCapabilities()
    {
        // empty
    }

    auto CodeLensClientCapabilities::operator=(
        CodeLensClientCapabilities &&other
    ) -> CodeLensClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto CodeLensClientCapabilities::operator=(
        const CodeLensClientCapabilities &other
    ) -> CodeLensClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    DocumentLinkClientCapabilities::DocumentLinkClientCapabilities()
    {
        // empty
    }

    DocumentLinkClientCapabilities::DocumentLinkClientCapabilities(
        DocumentLinkClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , tooltipSupport(std::move(other.tooltipSupport))
    {
        // empty
    }

    DocumentLinkClientCapabilities::DocumentLinkClientCapabilities(
        const DocumentLinkClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.tooltipSupport.has_value()) {
            tooltipSupport = other.tooltipSupport.value();
        }
    }

    DocumentLinkClientCapabilities::~DocumentLinkClientCapabilities()
    {
        // empty
    }

    auto DocumentLinkClientCapabilities::operator=(
        DocumentLinkClientCapabilities &&other
    ) -> DocumentLinkClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            tooltipSupport = std::move(other.tooltipSupport);
        }
        return *this;
    }

    auto DocumentLinkClientCapabilities::operator=(
        const DocumentLinkClientCapabilities &other
    ) -> DocumentLinkClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.tooltipSupport.has_value()) {
                tooltipSupport = other.tooltipSupport.value();
            }
        }
        return *this;
    }

    DocumentColorClientCapabilities::DocumentColorClientCapabilities()
    {
        // empty
    }

    DocumentColorClientCapabilities::DocumentColorClientCapabilities(
        DocumentColorClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    DocumentColorClientCapabilities::DocumentColorClientCapabilities(
        const DocumentColorClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    DocumentColorClientCapabilities::~DocumentColorClientCapabilities()
    {
        // empty
    }

    auto DocumentColorClientCapabilities::operator=(
        DocumentColorClientCapabilities &&other
    ) -> DocumentColorClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto DocumentColorClientCapabilities::operator=(
        const DocumentColorClientCapabilities &other
    ) -> DocumentColorClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    DocumentFormattingClientCapabilities::DocumentFormattingClientCapabilities()
    {
        // empty
    }

    DocumentFormattingClientCapabilities::DocumentFormattingClientCapabilities(
        DocumentFormattingClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    DocumentFormattingClientCapabilities::DocumentFormattingClientCapabilities(
        const DocumentFormattingClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    DocumentFormattingClientCapabilities::~DocumentFormattingClientCapabilities()
    {
        // empty
    }

    auto DocumentFormattingClientCapabilities::operator=(
        DocumentFormattingClientCapabilities &&other
    ) -> DocumentFormattingClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto DocumentFormattingClientCapabilities::operator=(
        const DocumentFormattingClientCapabilities &other
    ) -> DocumentFormattingClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    DocumentRangeFormattingClientCapabilities::DocumentRangeFormattingClientCapabilities()
    {
        // empty
    }

    DocumentRangeFormattingClientCapabilities::DocumentRangeFormattingClientCapabilities(
        DocumentRangeFormattingClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , rangesSupport(std::move(other.rangesSupport))
    {
        // empty
    }

    DocumentRangeFormattingClientCapabilities::DocumentRangeFormattingClientCapabilities(
        const DocumentRangeFormattingClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.rangesSupport.has_value()) {
            rangesSupport = other.rangesSupport.value();
        }
    }

    DocumentRangeFormattingClientCapabilities::~DocumentRangeFormattingClientCapabilities()
    {
        // empty
    }

    auto DocumentRangeFormattingClientCapabilities::operator=(
        DocumentRangeFormattingClientCapabilities &&other
    ) -> DocumentRangeFormattingClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            rangesSupport = std::move(other.rangesSupport);
        }
        return *this;
    }

    auto DocumentRangeFormattingClientCapabilities::operator=(
        const DocumentRangeFormattingClientCapabilities &other
    ) -> DocumentRangeFormattingClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.rangesSupport.has_value()) {
                rangesSupport = other.rangesSupport.value();
            }
        }
        return *this;
    }

    DocumentOnTypeFormattingClientCapabilities::DocumentOnTypeFormattingClientCapabilities()
    {
        // empty
    }

    DocumentOnTypeFormattingClientCapabilities::DocumentOnTypeFormattingClientCapabilities(
        DocumentOnTypeFormattingClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    DocumentOnTypeFormattingClientCapabilities::DocumentOnTypeFormattingClientCapabilities(
        const DocumentOnTypeFormattingClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    DocumentOnTypeFormattingClientCapabilities::~DocumentOnTypeFormattingClientCapabilities()
    {
        // empty
    }

    auto DocumentOnTypeFormattingClientCapabilities::operator=(
        DocumentOnTypeFormattingClientCapabilities &&other
    ) -> DocumentOnTypeFormattingClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto DocumentOnTypeFormattingClientCapabilities::operator=(
        const DocumentOnTypeFormattingClientCapabilities &other
    ) -> DocumentOnTypeFormattingClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    RenameClientCapabilities::RenameClientCapabilities()
    {
        // empty
    }

    RenameClientCapabilities::RenameClientCapabilities(
        RenameClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , prepareSupport(std::move(other.prepareSupport))
        , prepareSupportDefaultBehavior(std::move(other.prepareSupportDefaultBehavior))
        , honorsChangeAnnotations(std::move(other.honorsChangeAnnotations))
    {
        // empty
    }

    RenameClientCapabilities::RenameClientCapabilities(
        const RenameClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.prepareSupport.has_value()) {
            prepareSupport = other.prepareSupport.value();
        }
        if (other.prepareSupportDefaultBehavior.has_value()) {
            prepareSupportDefaultBehavior =
                other.prepareSupportDefaultBehavior.value();
        }
        if (other.honorsChangeAnnotations.has_value()) {
            honorsChangeAnnotations = other.honorsChangeAnnotations.value();
        }
    }

    RenameClientCapabilities::~RenameClientCapabilities()
    {
        // empty
    }

    auto RenameClientCapabilities::operator=(
        RenameClientCapabilities &&other
    ) -> RenameClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            prepareSupport = std::move(other.prepareSupport);
            prepareSupportDefaultBehavior =
                std::move(other.prepareSupportDefaultBehavior);
            honorsChangeAnnotations = std::move(other.honorsChangeAnnotations);
        }
        return *this;
    }

    auto RenameClientCapabilities::operator=(
        const RenameClientCapabilities &other
    ) -> RenameClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.prepareSupport.has_value()) {
                prepareSupport = other.prepareSupport.value();
            }
            if (other.prepareSupportDefaultBehavior.has_value()) {
                prepareSupportDefaultBehavior =
                    other.prepareSupportDefaultBehavior.value();
            }
            if (other.honorsChangeAnnotations.has_value()) {
                honorsChangeAnnotations =
                    other.honorsChangeAnnotations.value();
            }
        }
        return *this;
    }

    FoldingRangeClientCapabilities_foldingRange::FoldingRangeClientCapabilities_foldingRange()
    {
        // empty
    }

    FoldingRangeClientCapabilities_foldingRange::FoldingRangeClientCapabilities_foldingRange(
        FoldingRangeClientCapabilities_foldingRange &&other
    )
        : collapsedText(std::move(other.collapsedText))
    {
        // empty
    }

    FoldingRangeClientCapabilities_foldingRange::FoldingRangeClientCapabilities_foldingRange(
        const FoldingRangeClientCapabilities_foldingRange &other
    )
    {
        if (other.collapsedText.has_value()) {
            collapsedText = other.collapsedText.value();
        }
    }

    FoldingRangeClientCapabilities_foldingRange::~FoldingRangeClientCapabilities_foldingRange()
    {
        // empty
    }

    auto FoldingRangeClientCapabilities_foldingRange::operator=(
        FoldingRangeClientCapabilities_foldingRange &&other
    ) -> FoldingRangeClientCapabilities_foldingRange &
    {
        if (this != &other) {
            collapsedText = std::move(other.collapsedText);
        }
        return *this;
    }

    auto FoldingRangeClientCapabilities_foldingRange::operator=(
        const FoldingRangeClientCapabilities_foldingRange &other
    ) -> FoldingRangeClientCapabilities_foldingRange &
    {
        if (this != &other) {
            if (other.collapsedText.has_value()) {
                collapsedText = other.collapsedText.value();
            }
        }
        return *this;
    }

    SelectionRangeClientCapabilities::SelectionRangeClientCapabilities()
    {
        // empty
    }

    SelectionRangeClientCapabilities::SelectionRangeClientCapabilities(
        SelectionRangeClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    SelectionRangeClientCapabilities::SelectionRangeClientCapabilities(
        const SelectionRangeClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    SelectionRangeClientCapabilities::~SelectionRangeClientCapabilities()
    {
        // empty
    }

    auto SelectionRangeClientCapabilities::operator=(
        SelectionRangeClientCapabilities &&other
    ) -> SelectionRangeClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto SelectionRangeClientCapabilities::operator=(
        const SelectionRangeClientCapabilities &other
    ) -> SelectionRangeClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    PublishDiagnosticsClientCapabilities::PublishDiagnosticsClientCapabilities()
    {
        // empty
    }

    PublishDiagnosticsClientCapabilities::PublishDiagnosticsClientCapabilities(
        PublishDiagnosticsClientCapabilities &&other
    )
        : relatedInformation(std::move(other.relatedInformation))
        , tagSupport(std::move(other.tagSupport))
        , versionSupport(std::move(other.versionSupport))
        , codeDescriptionSupport(std::move(other.codeDescriptionSupport))
        , dataSupport(std::move(other.dataSupport))
    {
        // empty
    }

    PublishDiagnosticsClientCapabilities::PublishDiagnosticsClientCapabilities(
        const PublishDiagnosticsClientCapabilities &other
    )
    {
        if (other.relatedInformation.has_value()) {
            relatedInformation = other.relatedInformation.value();
        }
        if (other.tagSupport.has_value()) {
            tagSupport = other.tagSupport.value();
        }
        if (other.versionSupport.has_value()) {
            versionSupport = other.versionSupport.value();
        }
        if (other.codeDescriptionSupport.has_value()) {
            codeDescriptionSupport = other.codeDescriptionSupport.value();
        }
        if (other.dataSupport.has_value()) {
            dataSupport = other.dataSupport.value();
        }
    }

    PublishDiagnosticsClientCapabilities::~PublishDiagnosticsClientCapabilities()
    {
        // empty
    }

    auto PublishDiagnosticsClientCapabilities::operator=(
        PublishDiagnosticsClientCapabilities &&other
    ) -> PublishDiagnosticsClientCapabilities &
    {
        if (this != &other) {
            relatedInformation = std::move(other.relatedInformation);
            tagSupport = std::move(other.tagSupport);
            versionSupport = std::move(other.versionSupport);
            codeDescriptionSupport = std::move(other.codeDescriptionSupport);
            dataSupport = std::move(other.dataSupport);
        }
        return *this;
    }

    auto PublishDiagnosticsClientCapabilities::operator=(
        const PublishDiagnosticsClientCapabilities &other
    ) -> PublishDiagnosticsClientCapabilities &
    {
        if (this != &other) {
            if (other.relatedInformation.has_value()) {
                relatedInformation = other.relatedInformation.value();
            }
            if (other.tagSupport.has_value()) {
                tagSupport = other.tagSupport.value();
            }
            if (other.versionSupport.has_value()) {
                versionSupport = other.versionSupport.value();
            }
            if (other.codeDescriptionSupport.has_value()) {
                codeDescriptionSupport = other.codeDescriptionSupport.value();
            }
            if (other.dataSupport.has_value()) {
                dataSupport = other.dataSupport.value();
            }
        }
        return *this;
    }

    CallHierarchyClientCapabilities::CallHierarchyClientCapabilities()
    {
        // empty
    }

    CallHierarchyClientCapabilities::CallHierarchyClientCapabilities(
        CallHierarchyClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    CallHierarchyClientCapabilities::CallHierarchyClientCapabilities(
        const CallHierarchyClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    CallHierarchyClientCapabilities::~CallHierarchyClientCapabilities()
    {
        // empty
    }

    auto CallHierarchyClientCapabilities::operator=(
        CallHierarchyClientCapabilities &&other
    ) -> CallHierarchyClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto CallHierarchyClientCapabilities::operator=(
        const CallHierarchyClientCapabilities &other
    ) -> CallHierarchyClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    SemanticTokensClientCapabilities_requests_full_1::SemanticTokensClientCapabilities_requests_full_1()
    {
        // empty
    }

    SemanticTokensClientCapabilities_requests_full_1::SemanticTokensClientCapabilities_requests_full_1(
        SemanticTokensClientCapabilities_requests_full_1 &&other
    )
        : delta(std::move(other.delta))
    {
        // empty
    }

    SemanticTokensClientCapabilities_requests_full_1::SemanticTokensClientCapabilities_requests_full_1(
        const SemanticTokensClientCapabilities_requests_full_1 &other
    )
    {
        if (other.delta.has_value()) {
            delta = other.delta.value();
        }
    }

    SemanticTokensClientCapabilities_requests_full_1::~SemanticTokensClientCapabilities_requests_full_1()
    {
        // empty
    }

    auto SemanticTokensClientCapabilities_requests_full_1::operator=(
        SemanticTokensClientCapabilities_requests_full_1 &&other
    ) -> SemanticTokensClientCapabilities_requests_full_1 &
    {
        if (this != &other) {
            delta = std::move(other.delta);
        }
        return *this;
    }

    auto SemanticTokensClientCapabilities_requests_full_1::operator=(
        const SemanticTokensClientCapabilities_requests_full_1 &other
    ) -> SemanticTokensClientCapabilities_requests_full_1 &
    {
        if (this != &other) {
            if (other.delta.has_value()) {
                delta = other.delta.value();
            }
        }
        return *this;
    }

    const std::map<
        SemanticTokensClientCapabilities_requests_fullType,
        std::string
    > SemanticTokensClientCapabilities_requests_fullTypeNames = {
        {SemanticTokensClientCapabilities_requests_fullType::Uninitialized,
         "Uninitialized"},
        {SemanticTokensClientCapabilities_requests_fullType::Boolean,
         "Boolean"},
        {SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1,
         "SemanticTokensClientCapabilities_requests_full_1"},
    };

    SemanticTokensClientCapabilities_requests_full::SemanticTokensClientCapabilities_requests_full()
    {
        // empty
    }

    SemanticTokensClientCapabilities_requests_full::~SemanticTokensClientCapabilities_requests_full()
    {
        reset();
    }

    SemanticTokensClientCapabilities_requests_full::SemanticTokensClientCapabilities_requests_full(
        SemanticTokensClientCapabilities_requests_full &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case SemanticTokensClientCapabilities_requests_fullType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1: {
            new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
                std::move(other._semanticTokensClientCapabilities_requests_full_1)
            };
            break;
        }
        case SemanticTokensClientCapabilities_requests_fullType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            SemanticTokensClientCapabilities_requests_fullType::Uninitialized;
    }

    SemanticTokensClientCapabilities_requests_full::SemanticTokensClientCapabilities_requests_full(
        const SemanticTokensClientCapabilities_requests_full &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case SemanticTokensClientCapabilities_requests_fullType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1: {
            new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
                std::make_unique<SemanticTokensClientCapabilities_requests_full_1>(*other._semanticTokensClientCapabilities_requests_full_1)
            };
            break;
        }
        case SemanticTokensClientCapabilities_requests_fullType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto SemanticTokensClientCapabilities_requests_full::operator=(
        SemanticTokensClientCapabilities_requests_full &&other
    ) -> SemanticTokensClientCapabilities_requests_full &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case SemanticTokensClientCapabilities_requests_fullType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1: {
                new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
                    std::move(other._semanticTokensClientCapabilities_requests_full_1)
                };
                break;
            }
            case SemanticTokensClientCapabilities_requests_fullType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                SemanticTokensClientCapabilities_requests_fullType::Uninitialized;
        }
        return *this;
    }

    auto SemanticTokensClientCapabilities_requests_full::operator=(
        const SemanticTokensClientCapabilities_requests_full &other
    ) -> SemanticTokensClientCapabilities_requests_full &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case SemanticTokensClientCapabilities_requests_fullType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1: {
                new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
                    std::make_unique<SemanticTokensClientCapabilities_requests_full_1>(*other._semanticTokensClientCapabilities_requests_full_1)
                };
                break;
            }
            case SemanticTokensClientCapabilities_requests_fullType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto SemanticTokensClientCapabilities_requests_full::reset() -> void
    {
        switch (_type) {
        case SemanticTokensClientCapabilities_requests_fullType::Uninitialized: {
            // nothing to do
            break;
        }
        case SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1: {
#ifdef DEBUG
            if (!_semanticTokensClientCapabilities_requests_full_1) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _semanticTokensClientCapabilities_requests_full_1"
                );
            }
#endif // DEBUG
            _semanticTokensClientCapabilities_requests_full_1.~unique_ptr<SemanticTokensClientCapabilities_requests_full_1>();
            _type =
                SemanticTokensClientCapabilities_requests_fullType::Uninitialized;
            break;
        }
        default: {
            _type = SemanticTokensClientCapabilities_requests_fullType::Uninitialized;
        }
        }
    }

    auto SemanticTokensClientCapabilities_requests_full::type() const
    -> const SemanticTokensClientCapabilities_requests_fullType &
    {
        return _type;
    }

    auto SemanticTokensClientCapabilities_requests_full::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != SemanticTokensClientCapabilities_requests_fullType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "SemanticTokensClientCapabilities_requests_full::boolean()"
                 " of type "
                 "SemanticTokensClientCapabilities_requests_fullType::Boolean"
                 " while active type is "
                 "SemanticTokensClientCapabilities_requests_fullType::" +
                 SemanticTokensClientCapabilities_requests_fullTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto SemanticTokensClientCapabilities_requests_full::operator=(
        boolean_t boolean
    ) -> SemanticTokensClientCapabilities_requests_full &
    {
        if (_type !=
                SemanticTokensClientCapabilities_requests_fullType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = SemanticTokensClientCapabilities_requests_fullType::Boolean;
        return *this;
    }

    auto SemanticTokensClientCapabilities_requests_full::semanticTokensClientCapabilities_requests_full_1() const
    -> const SemanticTokensClientCapabilities_requests_full_1 &
    {
#ifdef DEBUG
        if (_type != SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1) {
            throw std::logic_error(
                ("Attempted to access "
                 "SemanticTokensClientCapabilities_requests_full::semanticTokensClientCapabilities_requests_full_1()"
                 " of type "
                 "SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1"
                 " while active type is "
                 "SemanticTokensClientCapabilities_requests_fullType::" +
                 SemanticTokensClientCapabilities_requests_fullTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_semanticTokensClientCapabilities_requests_full_1;
    }

    auto SemanticTokensClientCapabilities_requests_full::operator=(
        const std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> &semanticTokensClientCapabilities_requests_full_1
    ) -> SemanticTokensClientCapabilities_requests_full &
    {
        if (_type !=
                SemanticTokensClientCapabilities_requests_fullType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!semanticTokensClientCapabilities_requests_full_1) {
            throw std::logic_error(
                "null passed as the value of semanticTokensClientCapabilities_requests_full_1"
            );
        }
#endif // DEBUG
        new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
            std::make_unique<SemanticTokensClientCapabilities_requests_full_1>(*semanticTokensClientCapabilities_requests_full_1)
        };
        _type =
            SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1;
        return *this;
    }

    auto SemanticTokensClientCapabilities_requests_full::operator=(
        std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> &&semanticTokensClientCapabilities_requests_full_1
    ) -> SemanticTokensClientCapabilities_requests_full &
    {
        if (_type !=
                SemanticTokensClientCapabilities_requests_fullType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!semanticTokensClientCapabilities_requests_full_1) {
            throw std::logic_error(
                "null passed as the value of semanticTokensClientCapabilities_requests_full_1"
            );
        }
#endif // DEBUG
        new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
            std::move(semanticTokensClientCapabilities_requests_full_1)
        };
        _type =
            SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1;
        return *this;
    }

    auto SemanticTokensClientCapabilities_requests_full::operator=(
        const SemanticTokensClientCapabilities_requests_full_1 &semanticTokensClientCapabilities_requests_full_1
    ) -> SemanticTokensClientCapabilities_requests_full &
    {
        if (_type !=
                SemanticTokensClientCapabilities_requests_fullType::Uninitialized) {
            reset();
        }
        new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
            std::make_unique<SemanticTokensClientCapabilities_requests_full_1>(semanticTokensClientCapabilities_requests_full_1)
        };
        _type =
            SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1;
        return *this;
    }

    auto SemanticTokensClientCapabilities_requests_full::operator=(
        SemanticTokensClientCapabilities_requests_full_1 &&semanticTokensClientCapabilities_requests_full_1
    ) -> SemanticTokensClientCapabilities_requests_full &
    {
        if (_type !=
                SemanticTokensClientCapabilities_requests_fullType::Uninitialized) {
            reset();
        }
        new (&_semanticTokensClientCapabilities_requests_full_1) std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> {
            std::make_unique<SemanticTokensClientCapabilities_requests_full_1>(std::move(semanticTokensClientCapabilities_requests_full_1))
        };
        _type =
            SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1;
        return *this;
    }

    LinkedEditingRangeClientCapabilities::LinkedEditingRangeClientCapabilities()
    {
        // empty
    }

    LinkedEditingRangeClientCapabilities::LinkedEditingRangeClientCapabilities(
        LinkedEditingRangeClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    LinkedEditingRangeClientCapabilities::LinkedEditingRangeClientCapabilities(
        const LinkedEditingRangeClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    LinkedEditingRangeClientCapabilities::~LinkedEditingRangeClientCapabilities()
    {
        // empty
    }

    auto LinkedEditingRangeClientCapabilities::operator=(
        LinkedEditingRangeClientCapabilities &&other
    ) -> LinkedEditingRangeClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto LinkedEditingRangeClientCapabilities::operator=(
        const LinkedEditingRangeClientCapabilities &other
    ) -> LinkedEditingRangeClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    MonikerClientCapabilities::MonikerClientCapabilities()
    {
        // empty
    }

    MonikerClientCapabilities::MonikerClientCapabilities(
        MonikerClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    MonikerClientCapabilities::MonikerClientCapabilities(
        const MonikerClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    MonikerClientCapabilities::~MonikerClientCapabilities()
    {
        // empty
    }

    auto MonikerClientCapabilities::operator=(
        MonikerClientCapabilities &&other
    ) -> MonikerClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto MonikerClientCapabilities::operator=(
        const MonikerClientCapabilities &other
    ) -> MonikerClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    TypeHierarchyClientCapabilities::TypeHierarchyClientCapabilities()
    {
        // empty
    }

    TypeHierarchyClientCapabilities::TypeHierarchyClientCapabilities(
        TypeHierarchyClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    TypeHierarchyClientCapabilities::TypeHierarchyClientCapabilities(
        const TypeHierarchyClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    TypeHierarchyClientCapabilities::~TypeHierarchyClientCapabilities()
    {
        // empty
    }

    auto TypeHierarchyClientCapabilities::operator=(
        TypeHierarchyClientCapabilities &&other
    ) -> TypeHierarchyClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto TypeHierarchyClientCapabilities::operator=(
        const TypeHierarchyClientCapabilities &other
    ) -> TypeHierarchyClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    InlineValueClientCapabilities::InlineValueClientCapabilities()
    {
        // empty
    }

    InlineValueClientCapabilities::InlineValueClientCapabilities(
        InlineValueClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    InlineValueClientCapabilities::InlineValueClientCapabilities(
        const InlineValueClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    InlineValueClientCapabilities::~InlineValueClientCapabilities()
    {
        // empty
    }

    auto InlineValueClientCapabilities::operator=(
        InlineValueClientCapabilities &&other
    ) -> InlineValueClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto InlineValueClientCapabilities::operator=(
        const InlineValueClientCapabilities &other
    ) -> InlineValueClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    InlayHintClientCapabilities::InlayHintClientCapabilities()
    {
        // empty
    }

    InlayHintClientCapabilities::InlayHintClientCapabilities(
        InlayHintClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , resolveSupport(std::move(other.resolveSupport))
    {
        // empty
    }

    InlayHintClientCapabilities::InlayHintClientCapabilities(
        const InlayHintClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.resolveSupport.has_value()) {
            resolveSupport = other.resolveSupport.value();
        }
    }

    InlayHintClientCapabilities::~InlayHintClientCapabilities()
    {
        // empty
    }

    auto InlayHintClientCapabilities::operator=(
        InlayHintClientCapabilities &&other
    ) -> InlayHintClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            resolveSupport = std::move(other.resolveSupport);
        }
        return *this;
    }

    auto InlayHintClientCapabilities::operator=(
        const InlayHintClientCapabilities &other
    ) -> InlayHintClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.resolveSupport.has_value()) {
                resolveSupport = other.resolveSupport.value();
            }
        }
        return *this;
    }

    DiagnosticClientCapabilities::DiagnosticClientCapabilities()
    {
        // empty
    }

    DiagnosticClientCapabilities::DiagnosticClientCapabilities(
        DiagnosticClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , relatedDocumentSupport(std::move(other.relatedDocumentSupport))
    {
        // empty
    }

    DiagnosticClientCapabilities::DiagnosticClientCapabilities(
        const DiagnosticClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.relatedDocumentSupport.has_value()) {
            relatedDocumentSupport = other.relatedDocumentSupport.value();
        }
    }

    DiagnosticClientCapabilities::~DiagnosticClientCapabilities()
    {
        // empty
    }

    auto DiagnosticClientCapabilities::operator=(
        DiagnosticClientCapabilities &&other
    ) -> DiagnosticClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            relatedDocumentSupport = std::move(other.relatedDocumentSupport);
        }
        return *this;
    }

    auto DiagnosticClientCapabilities::operator=(
        const DiagnosticClientCapabilities &other
    ) -> DiagnosticClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.relatedDocumentSupport.has_value()) {
                relatedDocumentSupport = other.relatedDocumentSupport.value();
            }
        }
        return *this;
    }

    InlineCompletionClientCapabilities::InlineCompletionClientCapabilities()
    {
        // empty
    }

    InlineCompletionClientCapabilities::InlineCompletionClientCapabilities(
        InlineCompletionClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
    {
        // empty
    }

    InlineCompletionClientCapabilities::InlineCompletionClientCapabilities(
        const InlineCompletionClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
    }

    InlineCompletionClientCapabilities::~InlineCompletionClientCapabilities()
    {
        // empty
    }

    auto InlineCompletionClientCapabilities::operator=(
        InlineCompletionClientCapabilities &&other
    ) -> InlineCompletionClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
        }
        return *this;
    }

    auto InlineCompletionClientCapabilities::operator=(
        const InlineCompletionClientCapabilities &other
    ) -> InlineCompletionClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
        }
        return *this;
    }

    NotebookDocumentSyncClientCapabilities::NotebookDocumentSyncClientCapabilities()
    {
        // empty
    }

    NotebookDocumentSyncClientCapabilities::NotebookDocumentSyncClientCapabilities(
        NotebookDocumentSyncClientCapabilities &&other
    )
        : dynamicRegistration(std::move(other.dynamicRegistration))
        , executionSummarySupport(std::move(other.executionSummarySupport))
    {
        // empty
    }

    NotebookDocumentSyncClientCapabilities::NotebookDocumentSyncClientCapabilities(
        const NotebookDocumentSyncClientCapabilities &other
    )
    {
        if (other.dynamicRegistration.has_value()) {
            dynamicRegistration = other.dynamicRegistration.value();
        }
        if (other.executionSummarySupport.has_value()) {
            executionSummarySupport = other.executionSummarySupport.value();
        }
    }

    NotebookDocumentSyncClientCapabilities::~NotebookDocumentSyncClientCapabilities()
    {
        // empty
    }

    auto NotebookDocumentSyncClientCapabilities::operator=(
        NotebookDocumentSyncClientCapabilities &&other
    ) -> NotebookDocumentSyncClientCapabilities &
    {
        if (this != &other) {
            dynamicRegistration = std::move(other.dynamicRegistration);
            executionSummarySupport = std::move(other.executionSummarySupport);
        }
        return *this;
    }

    auto NotebookDocumentSyncClientCapabilities::operator=(
        const NotebookDocumentSyncClientCapabilities &other
    ) -> NotebookDocumentSyncClientCapabilities &
    {
        if (this != &other) {
            if (other.dynamicRegistration.has_value()) {
                dynamicRegistration = other.dynamicRegistration.value();
            }
            if (other.executionSummarySupport.has_value()) {
                executionSummarySupport =
                    other.executionSummarySupport.value();
            }
        }
        return *this;
    }

    NotebookDocumentClientCapabilities::NotebookDocumentClientCapabilities()
    {
        // empty
    }

    NotebookDocumentClientCapabilities::NotebookDocumentClientCapabilities(
        NotebookDocumentClientCapabilities &&other
    )
        : synchronization(std::move(other.synchronization))
    {
        // empty
    }

    NotebookDocumentClientCapabilities::NotebookDocumentClientCapabilities(
        const NotebookDocumentClientCapabilities &other
    )
        : synchronization(other.synchronization)
    {
    }

    NotebookDocumentClientCapabilities::~NotebookDocumentClientCapabilities()
    {
        // empty
    }

    auto NotebookDocumentClientCapabilities::operator=(
        NotebookDocumentClientCapabilities &&other
    ) -> NotebookDocumentClientCapabilities &
    {
        if (this != &other) {
            synchronization = std::move(other.synchronization);
        }
        return *this;
    }

    auto NotebookDocumentClientCapabilities::operator=(
        const NotebookDocumentClientCapabilities &other
    ) -> NotebookDocumentClientCapabilities &
    {
        if (this != &other) {
            synchronization = other.synchronization;
        }
        return *this;
    }

    ShowMessageRequestClientCapabilities_messageActionItem::ShowMessageRequestClientCapabilities_messageActionItem()
    {
        // empty
    }

    ShowMessageRequestClientCapabilities_messageActionItem::ShowMessageRequestClientCapabilities_messageActionItem(
        ShowMessageRequestClientCapabilities_messageActionItem &&other
    )
        : additionalPropertiesSupport(std::move(other.additionalPropertiesSupport))
    {
        // empty
    }

    ShowMessageRequestClientCapabilities_messageActionItem::ShowMessageRequestClientCapabilities_messageActionItem(
        const ShowMessageRequestClientCapabilities_messageActionItem &other
    )
    {
        if (other.additionalPropertiesSupport.has_value()) {
            additionalPropertiesSupport =
                other.additionalPropertiesSupport.value();
        }
    }

    ShowMessageRequestClientCapabilities_messageActionItem::~ShowMessageRequestClientCapabilities_messageActionItem()
    {
        // empty
    }

    auto ShowMessageRequestClientCapabilities_messageActionItem::operator=(
        ShowMessageRequestClientCapabilities_messageActionItem &&other
    ) -> ShowMessageRequestClientCapabilities_messageActionItem &
    {
        if (this != &other) {
            additionalPropertiesSupport =
                std::move(other.additionalPropertiesSupport);
        }
        return *this;
    }

    auto ShowMessageRequestClientCapabilities_messageActionItem::operator=(
        const ShowMessageRequestClientCapabilities_messageActionItem &other
    ) -> ShowMessageRequestClientCapabilities_messageActionItem &
    {
        if (this != &other) {
            if (other.additionalPropertiesSupport.has_value()) {
                additionalPropertiesSupport =
                    other.additionalPropertiesSupport.value();
            }
        }
        return *this;
    }

    ShowMessageRequestClientCapabilities::ShowMessageRequestClientCapabilities()
    {
        // empty
    }

    ShowMessageRequestClientCapabilities::ShowMessageRequestClientCapabilities(
        ShowMessageRequestClientCapabilities &&other
    )
        : messageActionItem(std::move(other.messageActionItem))
    {
        // empty
    }

    ShowMessageRequestClientCapabilities::ShowMessageRequestClientCapabilities(
        const ShowMessageRequestClientCapabilities &other
    )
    {
        if (other.messageActionItem.has_value()) {
            messageActionItem = other.messageActionItem.value();
        }
    }

    ShowMessageRequestClientCapabilities::~ShowMessageRequestClientCapabilities()
    {
        // empty
    }

    auto ShowMessageRequestClientCapabilities::operator=(
        ShowMessageRequestClientCapabilities &&other
    ) -> ShowMessageRequestClientCapabilities &
    {
        if (this != &other) {
            messageActionItem = std::move(other.messageActionItem);
        }
        return *this;
    }

    auto ShowMessageRequestClientCapabilities::operator=(
        const ShowMessageRequestClientCapabilities &other
    ) -> ShowMessageRequestClientCapabilities &
    {
        if (this != &other) {
            if (other.messageActionItem.has_value()) {
                messageActionItem = other.messageActionItem.value();
            }
        }
        return *this;
    }

    ShowDocumentClientCapabilities::ShowDocumentClientCapabilities()
    {
        // empty
    }

    ShowDocumentClientCapabilities::ShowDocumentClientCapabilities(
        ShowDocumentClientCapabilities &&other
    )
        : support(other.support)
    {
        // empty
    }

    ShowDocumentClientCapabilities::ShowDocumentClientCapabilities(
        const ShowDocumentClientCapabilities &other
    )
        : support(other.support)
    {
    }

    ShowDocumentClientCapabilities::~ShowDocumentClientCapabilities()
    {
        // empty
    }

    auto ShowDocumentClientCapabilities::operator=(
        ShowDocumentClientCapabilities &&other
    ) -> ShowDocumentClientCapabilities &
    {
        if (this != &other) {
            support = other.support;
        }
        return *this;
    }

    auto ShowDocumentClientCapabilities::operator=(
        const ShowDocumentClientCapabilities &other
    ) -> ShowDocumentClientCapabilities &
    {
        if (this != &other) {
            support = other.support;
        }
        return *this;
    }

    WindowClientCapabilities::WindowClientCapabilities()
    {
        // empty
    }

    WindowClientCapabilities::WindowClientCapabilities(
        WindowClientCapabilities &&other
    )
        : workDoneProgress(std::move(other.workDoneProgress))
        , showMessage(std::move(other.showMessage))
        , showDocument(std::move(other.showDocument))
    {
        // empty
    }

    WindowClientCapabilities::WindowClientCapabilities(
        const WindowClientCapabilities &other
    )
    {
        if (other.workDoneProgress.has_value()) {
            workDoneProgress = other.workDoneProgress.value();
        }
        if (other.showMessage.has_value()) {
            showMessage = other.showMessage.value();
        }
        if (other.showDocument.has_value()) {
            showDocument = other.showDocument.value();
        }
    }

    WindowClientCapabilities::~WindowClientCapabilities()
    {
        // empty
    }

    auto WindowClientCapabilities::operator=(
        WindowClientCapabilities &&other
    ) -> WindowClientCapabilities &
    {
        if (this != &other) {
            workDoneProgress = std::move(other.workDoneProgress);
            showMessage = std::move(other.showMessage);
            showDocument = std::move(other.showDocument);
        }
        return *this;
    }

    auto WindowClientCapabilities::operator=(
        const WindowClientCapabilities &other
    ) -> WindowClientCapabilities &
    {
        if (this != &other) {
            if (other.workDoneProgress.has_value()) {
                workDoneProgress = other.workDoneProgress.value();
            }
            if (other.showMessage.has_value()) {
                showMessage = other.showMessage.value();
            }
            if (other.showDocument.has_value()) {
                showDocument = other.showDocument.value();
            }
        }
        return *this;
    }

    PrepareRenameResult_2::PrepareRenameResult_2()
    {
        // empty
    }

    PrepareRenameResult_2::PrepareRenameResult_2(PrepareRenameResult_2 &&other)
        : defaultBehavior(other.defaultBehavior)
    {
        // empty
    }

    PrepareRenameResult_2::PrepareRenameResult_2(
        const PrepareRenameResult_2 &other
    )
        : defaultBehavior(other.defaultBehavior)
    {
    }

    PrepareRenameResult_2::~PrepareRenameResult_2()
    {
        // empty
    }

    auto PrepareRenameResult_2::operator=(
        PrepareRenameResult_2 &&other
    ) -> PrepareRenameResult_2 &
    {
        if (this != &other) {
            defaultBehavior = other.defaultBehavior;
        }
        return *this;
    }

    auto PrepareRenameResult_2::operator=(
        const PrepareRenameResult_2 &other
    ) -> PrepareRenameResult_2 &
    {
        if (this != &other) {
            defaultBehavior = other.defaultBehavior;
        }
        return *this;
    }

    const std::map<
        TextDocumentRegistrationOptions_documentSelectorType,
        std::string
    > TextDocumentRegistrationOptions_documentSelectorTypeNames = {
        {TextDocumentRegistrationOptions_documentSelectorType::Uninitialized,
         "Uninitialized"},
        {TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector,
         "DocumentSelector"},
        {TextDocumentRegistrationOptions_documentSelectorType::Null, "Null"},
    };

    TextDocumentRegistrationOptions_documentSelector::TextDocumentRegistrationOptions_documentSelector()
    {
        // empty
    }

    TextDocumentRegistrationOptions_documentSelector::~TextDocumentRegistrationOptions_documentSelector()
    {
        reset();
    }

    TextDocumentRegistrationOptions_documentSelector::TextDocumentRegistrationOptions_documentSelector(
        TextDocumentRegistrationOptions_documentSelector &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector: {
            new (&_documentSelector) std::unique_ptr<DocumentSelector> {
                std::move(other._documentSelector)
            };
            break;
        }
        case TextDocumentRegistrationOptions_documentSelectorType::Null: {
            _null = other._null;
            break;
        }
        case TextDocumentRegistrationOptions_documentSelectorType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            TextDocumentRegistrationOptions_documentSelectorType::Uninitialized;
    }

    TextDocumentRegistrationOptions_documentSelector::TextDocumentRegistrationOptions_documentSelector(
        const TextDocumentRegistrationOptions_documentSelector &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector: {
            _documentSelector =
                std::make_unique<std::vector<DocumentFilter>>(*other._documentSelector);
            break;
        }
        case TextDocumentRegistrationOptions_documentSelectorType::Null: {
            _null = other._null;
            break;
        }
        case TextDocumentRegistrationOptions_documentSelectorType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto TextDocumentRegistrationOptions_documentSelector::operator=(
        TextDocumentRegistrationOptions_documentSelector &&other
    ) -> TextDocumentRegistrationOptions_documentSelector &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector: {
                new (&_documentSelector) std::unique_ptr<DocumentSelector> {
                    std::move(other._documentSelector)
                };
                break;
            }
            case TextDocumentRegistrationOptions_documentSelectorType::Null: {
                _null = other._null;
                break;
            }
            case TextDocumentRegistrationOptions_documentSelectorType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                TextDocumentRegistrationOptions_documentSelectorType::Uninitialized;
        }
        return *this;
    }

    auto TextDocumentRegistrationOptions_documentSelector::operator=(
        const TextDocumentRegistrationOptions_documentSelector &other
    ) -> TextDocumentRegistrationOptions_documentSelector &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector: {
                _documentSelector =
                    std::make_unique<std::vector<DocumentFilter>>(*other._documentSelector);
                break;
            }
            case TextDocumentRegistrationOptions_documentSelectorType::Null: {
                _null = other._null;
                break;
            }
            case TextDocumentRegistrationOptions_documentSelectorType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto TextDocumentRegistrationOptions_documentSelector::reset() -> void
    {
        switch (_type) {
        case TextDocumentRegistrationOptions_documentSelectorType::Uninitialized: {
            // nothing to do
            break;
        }
        case TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector: {
#ifdef DEBUG
            if (!_documentSelector) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentSelector"
                );
            }
#endif // DEBUG
            _documentSelector.~unique_ptr<DocumentSelector>();
            _type =
                TextDocumentRegistrationOptions_documentSelectorType::Uninitialized;
            break;
        }
        default: {
            _type = TextDocumentRegistrationOptions_documentSelectorType::Uninitialized;
        }
        }
    }

    auto TextDocumentRegistrationOptions_documentSelector::type() const
    -> const TextDocumentRegistrationOptions_documentSelectorType &
    {
        return _type;
    }

    auto TextDocumentRegistrationOptions_documentSelector::documentSelector() const
    -> const DocumentSelector &
    {
#ifdef DEBUG
        if (_type != TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector) {
            throw std::logic_error(
                ("Attempted to access "
                 "TextDocumentRegistrationOptions_documentSelector::documentSelector()"
                 " of type "
                 "TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector"
                 " while active type is "
                 "TextDocumentRegistrationOptions_documentSelectorType::" +
                 TextDocumentRegistrationOptions_documentSelectorTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentSelector;
    }

    auto TextDocumentRegistrationOptions_documentSelector::operator=(
        const std::unique_ptr<DocumentSelector> &documentSelector
    ) -> TextDocumentRegistrationOptions_documentSelector &
    {
        if (_type !=
                TextDocumentRegistrationOptions_documentSelectorType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentSelector) {
            throw std::logic_error(
                "null passed as the value of documentSelector"
            );
        }
#endif // DEBUG
        _documentSelector =
            std::make_unique<std::vector<DocumentFilter>>(*documentSelector);
        _type =
            TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector;
        return *this;
    }

    auto TextDocumentRegistrationOptions_documentSelector::operator=(
        std::unique_ptr<DocumentSelector> &&documentSelector
    ) -> TextDocumentRegistrationOptions_documentSelector &
    {
        if (_type !=
                TextDocumentRegistrationOptions_documentSelectorType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentSelector) {
            throw std::logic_error(
                "null passed as the value of documentSelector"
            );
        }
#endif // DEBUG
        new (&_documentSelector) std::unique_ptr<DocumentSelector> {
            std::move(documentSelector)
        };
        _type =
            TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector;
        return *this;
    }

    auto TextDocumentRegistrationOptions_documentSelector::operator=(
        const DocumentSelector &documentSelector
    ) -> TextDocumentRegistrationOptions_documentSelector &
    {
        if (_type !=
                TextDocumentRegistrationOptions_documentSelectorType::Uninitialized) {
            reset();
        }
        _documentSelector =
            std::make_unique<std::vector<DocumentFilter>>(documentSelector);
        _type =
            TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector;
        return *this;
    }

    auto TextDocumentRegistrationOptions_documentSelector::operator=(
        DocumentSelector &&documentSelector
    ) -> TextDocumentRegistrationOptions_documentSelector &
    {
        if (_type !=
                TextDocumentRegistrationOptions_documentSelectorType::Uninitialized) {
            reset();
        }
        new (&_documentSelector) std::unique_ptr<DocumentSelector> {
            std::make_unique<DocumentSelector>(std::move(documentSelector))
        };
        _type =
            TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector;
        return *this;
    }

    auto TextDocumentRegistrationOptions_documentSelector::null() const
    -> const null_t &
    {
#ifdef DEBUG
        if (_type != TextDocumentRegistrationOptions_documentSelectorType::Null) {
            throw std::logic_error(
                ("Attempted to access "
                 "TextDocumentRegistrationOptions_documentSelector::null()"
                 " of type "
                 "TextDocumentRegistrationOptions_documentSelectorType::Null"
                 " while active type is "
                 "TextDocumentRegistrationOptions_documentSelectorType::" +
                 TextDocumentRegistrationOptions_documentSelectorTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _null;
    }

    auto TextDocumentRegistrationOptions_documentSelector::operator=(
        null_t null
    ) -> TextDocumentRegistrationOptions_documentSelector &
    {
        if (_type !=
                TextDocumentRegistrationOptions_documentSelectorType::Uninitialized) {
            reset();
        }
        _null = null;
        _type = TextDocumentRegistrationOptions_documentSelectorType::Null;
        return *this;
    }

    TextDocumentRegistrationOptions::TextDocumentRegistrationOptions()
    {
        // empty
    }

    TextDocumentRegistrationOptions::TextDocumentRegistrationOptions(
        TextDocumentRegistrationOptions &&other
    )
        : documentSelector(std::move(other.documentSelector))
    {
        // empty
    }

    TextDocumentRegistrationOptions::TextDocumentRegistrationOptions(
        const TextDocumentRegistrationOptions &other
    )
        : documentSelector(TextDocumentRegistrationOptions_documentSelector(other.documentSelector))
    {
    }

    TextDocumentRegistrationOptions::~TextDocumentRegistrationOptions()
    {
        // empty
    }

    auto TextDocumentRegistrationOptions::operator=(
        TextDocumentRegistrationOptions &&other
    ) -> TextDocumentRegistrationOptions &
    {
        if (this != &other) {
            documentSelector = std::move(other.documentSelector);
        }
        return *this;
    }

    auto TextDocumentRegistrationOptions::operator=(
        const TextDocumentRegistrationOptions &other
    ) -> TextDocumentRegistrationOptions &
    {
        if (this != &other) {
            documentSelector =
                TextDocumentRegistrationOptions_documentSelector(other.documentSelector);
        }
        return *this;
    }

    ImplementationRegistrationOptions::ImplementationRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , ImplementationOptions()
    {
        // empty
    }

    ImplementationRegistrationOptions::ImplementationRegistrationOptions(
        ImplementationRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , ImplementationOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    ImplementationRegistrationOptions::ImplementationRegistrationOptions(
        const ImplementationRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , ImplementationOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    ImplementationRegistrationOptions::~ImplementationRegistrationOptions()
    {
        // empty
    }

    auto ImplementationRegistrationOptions::operator=(
        ImplementationRegistrationOptions &&other
    ) -> ImplementationRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            ImplementationOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto ImplementationRegistrationOptions::operator=(
        const ImplementationRegistrationOptions &other
    ) -> ImplementationRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            ImplementationOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    TypeDefinitionRegistrationOptions::TypeDefinitionRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , TypeDefinitionOptions()
    {
        // empty
    }

    TypeDefinitionRegistrationOptions::TypeDefinitionRegistrationOptions(
        TypeDefinitionRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , TypeDefinitionOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    TypeDefinitionRegistrationOptions::TypeDefinitionRegistrationOptions(
        const TypeDefinitionRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , TypeDefinitionOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    TypeDefinitionRegistrationOptions::~TypeDefinitionRegistrationOptions()
    {
        // empty
    }

    auto TypeDefinitionRegistrationOptions::operator=(
        TypeDefinitionRegistrationOptions &&other
    ) -> TypeDefinitionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            TypeDefinitionOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto TypeDefinitionRegistrationOptions::operator=(
        const TypeDefinitionRegistrationOptions &other
    ) -> TypeDefinitionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            TypeDefinitionOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    DocumentColorRegistrationOptions::DocumentColorRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DocumentColorOptions()
    {
        // empty
    }

    DocumentColorRegistrationOptions::DocumentColorRegistrationOptions(
        DocumentColorRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentColorOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    DocumentColorRegistrationOptions::DocumentColorRegistrationOptions(
        const DocumentColorRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentColorOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    DocumentColorRegistrationOptions::~DocumentColorRegistrationOptions()
    {
        // empty
    }

    auto DocumentColorRegistrationOptions::operator=(
        DocumentColorRegistrationOptions &&other
    ) -> DocumentColorRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentColorOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto DocumentColorRegistrationOptions::operator=(
        const DocumentColorRegistrationOptions &other
    ) -> DocumentColorRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentColorOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    FoldingRangeRegistrationOptions::FoldingRangeRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , FoldingRangeOptions()
    {
        // empty
    }

    FoldingRangeRegistrationOptions::FoldingRangeRegistrationOptions(
        FoldingRangeRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , FoldingRangeOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    FoldingRangeRegistrationOptions::FoldingRangeRegistrationOptions(
        const FoldingRangeRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , FoldingRangeOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    FoldingRangeRegistrationOptions::~FoldingRangeRegistrationOptions()
    {
        // empty
    }

    auto FoldingRangeRegistrationOptions::operator=(
        FoldingRangeRegistrationOptions &&other
    ) -> FoldingRangeRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            FoldingRangeOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto FoldingRangeRegistrationOptions::operator=(
        const FoldingRangeRegistrationOptions &other
    ) -> FoldingRangeRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            FoldingRangeOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    DeclarationRegistrationOptions::DeclarationRegistrationOptions()
        : DeclarationOptions()
        , TextDocumentRegistrationOptions()
    {
        // empty
    }

    DeclarationRegistrationOptions::DeclarationRegistrationOptions(
        DeclarationRegistrationOptions &&other
    )
        : DeclarationOptions(other)
        , TextDocumentRegistrationOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    DeclarationRegistrationOptions::DeclarationRegistrationOptions(
        const DeclarationRegistrationOptions &other
    )
        : DeclarationOptions(other)
        , TextDocumentRegistrationOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    DeclarationRegistrationOptions::~DeclarationRegistrationOptions()
    {
        // empty
    }

    auto DeclarationRegistrationOptions::operator=(
        DeclarationRegistrationOptions &&other
    ) -> DeclarationRegistrationOptions &
    {
        if (this != &other) {
            DeclarationOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto DeclarationRegistrationOptions::operator=(
        const DeclarationRegistrationOptions &other
    ) -> DeclarationRegistrationOptions &
    {
        if (this != &other) {
            DeclarationOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    SelectionRangeRegistrationOptions::SelectionRangeRegistrationOptions()
        : SelectionRangeOptions()
        , TextDocumentRegistrationOptions()
    {
        // empty
    }

    SelectionRangeRegistrationOptions::SelectionRangeRegistrationOptions(
        SelectionRangeRegistrationOptions &&other
    )
        : SelectionRangeOptions(other)
        , TextDocumentRegistrationOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    SelectionRangeRegistrationOptions::SelectionRangeRegistrationOptions(
        const SelectionRangeRegistrationOptions &other
    )
        : SelectionRangeOptions(other)
        , TextDocumentRegistrationOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    SelectionRangeRegistrationOptions::~SelectionRangeRegistrationOptions()
    {
        // empty
    }

    auto SelectionRangeRegistrationOptions::operator=(
        SelectionRangeRegistrationOptions &&other
    ) -> SelectionRangeRegistrationOptions &
    {
        if (this != &other) {
            SelectionRangeOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto SelectionRangeRegistrationOptions::operator=(
        const SelectionRangeRegistrationOptions &other
    ) -> SelectionRangeRegistrationOptions &
    {
        if (this != &other) {
            SelectionRangeOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    CallHierarchyRegistrationOptions::CallHierarchyRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , CallHierarchyOptions()
    {
        // empty
    }

    CallHierarchyRegistrationOptions::CallHierarchyRegistrationOptions(
        CallHierarchyRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , CallHierarchyOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    CallHierarchyRegistrationOptions::CallHierarchyRegistrationOptions(
        const CallHierarchyRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , CallHierarchyOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    CallHierarchyRegistrationOptions::~CallHierarchyRegistrationOptions()
    {
        // empty
    }

    auto CallHierarchyRegistrationOptions::operator=(
        CallHierarchyRegistrationOptions &&other
    ) -> CallHierarchyRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CallHierarchyOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto CallHierarchyRegistrationOptions::operator=(
        const CallHierarchyRegistrationOptions &other
    ) -> CallHierarchyRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CallHierarchyOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    LinkedEditingRangeRegistrationOptions::LinkedEditingRangeRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , LinkedEditingRangeOptions()
    {
        // empty
    }

    LinkedEditingRangeRegistrationOptions::LinkedEditingRangeRegistrationOptions(
        LinkedEditingRangeRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , LinkedEditingRangeOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    LinkedEditingRangeRegistrationOptions::LinkedEditingRangeRegistrationOptions(
        const LinkedEditingRangeRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , LinkedEditingRangeOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    LinkedEditingRangeRegistrationOptions::~LinkedEditingRangeRegistrationOptions()
    {
        // empty
    }

    auto LinkedEditingRangeRegistrationOptions::operator=(
        LinkedEditingRangeRegistrationOptions &&other
    ) -> LinkedEditingRangeRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            LinkedEditingRangeOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto LinkedEditingRangeRegistrationOptions::operator=(
        const LinkedEditingRangeRegistrationOptions &other
    ) -> LinkedEditingRangeRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            LinkedEditingRangeOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    MonikerRegistrationOptions::MonikerRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , MonikerOptions()
    {
        // empty
    }

    MonikerRegistrationOptions::MonikerRegistrationOptions(
        MonikerRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , MonikerOptions(other)
    {
        // empty
    }

    MonikerRegistrationOptions::MonikerRegistrationOptions(
        const MonikerRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , MonikerOptions(other)
    {
    }

    MonikerRegistrationOptions::~MonikerRegistrationOptions()
    {
        // empty
    }

    auto MonikerRegistrationOptions::operator=(
        MonikerRegistrationOptions &&other
    ) -> MonikerRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            MonikerOptions::operator=(other);
        }
        return *this;
    }

    auto MonikerRegistrationOptions::operator=(
        const MonikerRegistrationOptions &other
    ) -> MonikerRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            MonikerOptions::operator=(other);
        }
        return *this;
    }

    TypeHierarchyRegistrationOptions::TypeHierarchyRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , TypeHierarchyOptions()
    {
        // empty
    }

    TypeHierarchyRegistrationOptions::TypeHierarchyRegistrationOptions(
        TypeHierarchyRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , TypeHierarchyOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    TypeHierarchyRegistrationOptions::TypeHierarchyRegistrationOptions(
        const TypeHierarchyRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , TypeHierarchyOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    TypeHierarchyRegistrationOptions::~TypeHierarchyRegistrationOptions()
    {
        // empty
    }

    auto TypeHierarchyRegistrationOptions::operator=(
        TypeHierarchyRegistrationOptions &&other
    ) -> TypeHierarchyRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            TypeHierarchyOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto TypeHierarchyRegistrationOptions::operator=(
        const TypeHierarchyRegistrationOptions &other
    ) -> TypeHierarchyRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            TypeHierarchyOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    InlineValueRegistrationOptions::InlineValueRegistrationOptions()
        : InlineValueOptions()
        , TextDocumentRegistrationOptions()
    {
        // empty
    }

    InlineValueRegistrationOptions::InlineValueRegistrationOptions(
        InlineValueRegistrationOptions &&other
    )
        : InlineValueOptions(other)
        , TextDocumentRegistrationOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    InlineValueRegistrationOptions::InlineValueRegistrationOptions(
        const InlineValueRegistrationOptions &other
    )
        : InlineValueOptions(other)
        , TextDocumentRegistrationOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    InlineValueRegistrationOptions::~InlineValueRegistrationOptions()
    {
        // empty
    }

    auto InlineValueRegistrationOptions::operator=(
        InlineValueRegistrationOptions &&other
    ) -> InlineValueRegistrationOptions &
    {
        if (this != &other) {
            InlineValueOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto InlineValueRegistrationOptions::operator=(
        const InlineValueRegistrationOptions &other
    ) -> InlineValueRegistrationOptions &
    {
        if (this != &other) {
            InlineValueOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    InlayHintRegistrationOptions::InlayHintRegistrationOptions()
        : InlayHintOptions()
        , TextDocumentRegistrationOptions()
    {
        // empty
    }

    InlayHintRegistrationOptions::InlayHintRegistrationOptions(
        InlayHintRegistrationOptions &&other
    )
        : InlayHintOptions(other)
        , TextDocumentRegistrationOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    InlayHintRegistrationOptions::InlayHintRegistrationOptions(
        const InlayHintRegistrationOptions &other
    )
        : InlayHintOptions(other)
        , TextDocumentRegistrationOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    InlayHintRegistrationOptions::~InlayHintRegistrationOptions()
    {
        // empty
    }

    auto InlayHintRegistrationOptions::operator=(
        InlayHintRegistrationOptions &&other
    ) -> InlayHintRegistrationOptions &
    {
        if (this != &other) {
            InlayHintOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto InlayHintRegistrationOptions::operator=(
        const InlayHintRegistrationOptions &other
    ) -> InlayHintRegistrationOptions &
    {
        if (this != &other) {
            InlayHintOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    DiagnosticRegistrationOptions::DiagnosticRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DiagnosticOptions()
    {
        // empty
    }

    DiagnosticRegistrationOptions::DiagnosticRegistrationOptions(
        DiagnosticRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DiagnosticOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    DiagnosticRegistrationOptions::DiagnosticRegistrationOptions(
        const DiagnosticRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DiagnosticOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    DiagnosticRegistrationOptions::~DiagnosticRegistrationOptions()
    {
        // empty
    }

    auto DiagnosticRegistrationOptions::operator=(
        DiagnosticRegistrationOptions &&other
    ) -> DiagnosticRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DiagnosticOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto DiagnosticRegistrationOptions::operator=(
        const DiagnosticRegistrationOptions &other
    ) -> DiagnosticRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DiagnosticOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    InlineCompletionRegistrationOptions::InlineCompletionRegistrationOptions()
        : InlineCompletionOptions()
        , TextDocumentRegistrationOptions()
    {
        // empty
    }

    InlineCompletionRegistrationOptions::InlineCompletionRegistrationOptions(
        InlineCompletionRegistrationOptions &&other
    )
        : InlineCompletionOptions(other)
        , TextDocumentRegistrationOptions(other)
        , id(std::move(other.id))
    {
        // empty
    }

    InlineCompletionRegistrationOptions::InlineCompletionRegistrationOptions(
        const InlineCompletionRegistrationOptions &other
    )
        : InlineCompletionOptions(other)
        , TextDocumentRegistrationOptions(other)
    {
        if (other.id.has_value()) {
            id = other.id.value();
        }
    }

    InlineCompletionRegistrationOptions::~InlineCompletionRegistrationOptions()
    {
        // empty
    }

    auto InlineCompletionRegistrationOptions::operator=(
        InlineCompletionRegistrationOptions &&other
    ) -> InlineCompletionRegistrationOptions &
    {
        if (this != &other) {
            InlineCompletionOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            id = std::move(other.id);
        }
        return *this;
    }

    auto InlineCompletionRegistrationOptions::operator=(
        const InlineCompletionRegistrationOptions &other
    ) -> InlineCompletionRegistrationOptions &
    {
        if (this != &other) {
            InlineCompletionOptions::operator=(other);
            TextDocumentRegistrationOptions::operator=(other);
            if (other.id.has_value()) {
                id = other.id.value();
            }
        }
        return *this;
    }

    TextDocumentChangeRegistrationOptions::TextDocumentChangeRegistrationOptions()
        : TextDocumentRegistrationOptions()
    {
        // empty
    }

    TextDocumentChangeRegistrationOptions::TextDocumentChangeRegistrationOptions(
        TextDocumentChangeRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , syncKind(std::move(other.syncKind))
    {
        // empty
    }

    TextDocumentChangeRegistrationOptions::TextDocumentChangeRegistrationOptions(
        const TextDocumentChangeRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , syncKind(other.syncKind)
    {
    }

    TextDocumentChangeRegistrationOptions::~TextDocumentChangeRegistrationOptions()
    {
        // empty
    }

    auto TextDocumentChangeRegistrationOptions::operator=(
        TextDocumentChangeRegistrationOptions &&other
    ) -> TextDocumentChangeRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            syncKind = std::move(other.syncKind);
        }
        return *this;
    }

    auto TextDocumentChangeRegistrationOptions::operator=(
        const TextDocumentChangeRegistrationOptions &other
    ) -> TextDocumentChangeRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            syncKind = other.syncKind;
        }
        return *this;
    }

    TextDocumentSaveRegistrationOptions::TextDocumentSaveRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , SaveOptions()
    {
        // empty
    }

    TextDocumentSaveRegistrationOptions::TextDocumentSaveRegistrationOptions(
        TextDocumentSaveRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , SaveOptions(other)
    {
        // empty
    }

    TextDocumentSaveRegistrationOptions::TextDocumentSaveRegistrationOptions(
        const TextDocumentSaveRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , SaveOptions(other)
    {
    }

    TextDocumentSaveRegistrationOptions::~TextDocumentSaveRegistrationOptions()
    {
        // empty
    }

    auto TextDocumentSaveRegistrationOptions::operator=(
        TextDocumentSaveRegistrationOptions &&other
    ) -> TextDocumentSaveRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            SaveOptions::operator=(other);
        }
        return *this;
    }

    auto TextDocumentSaveRegistrationOptions::operator=(
        const TextDocumentSaveRegistrationOptions &other
    ) -> TextDocumentSaveRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            SaveOptions::operator=(other);
        }
        return *this;
    }

    CompletionRegistrationOptions::CompletionRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , CompletionOptions()
    {
        // empty
    }

    CompletionRegistrationOptions::CompletionRegistrationOptions(
        CompletionRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , CompletionOptions(other)
    {
        // empty
    }

    CompletionRegistrationOptions::CompletionRegistrationOptions(
        const CompletionRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , CompletionOptions(other)
    {
    }

    CompletionRegistrationOptions::~CompletionRegistrationOptions()
    {
        // empty
    }

    auto CompletionRegistrationOptions::operator=(
        CompletionRegistrationOptions &&other
    ) -> CompletionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CompletionOptions::operator=(other);
        }
        return *this;
    }

    auto CompletionRegistrationOptions::operator=(
        const CompletionRegistrationOptions &other
    ) -> CompletionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CompletionOptions::operator=(other);
        }
        return *this;
    }

    HoverRegistrationOptions::HoverRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , HoverOptions()
    {
        // empty
    }

    HoverRegistrationOptions::HoverRegistrationOptions(
        HoverRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , HoverOptions(other)
    {
        // empty
    }

    HoverRegistrationOptions::HoverRegistrationOptions(
        const HoverRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , HoverOptions(other)
    {
    }

    HoverRegistrationOptions::~HoverRegistrationOptions()
    {
        // empty
    }

    auto HoverRegistrationOptions::operator=(
        HoverRegistrationOptions &&other
    ) -> HoverRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            HoverOptions::operator=(other);
        }
        return *this;
    }

    auto HoverRegistrationOptions::operator=(
        const HoverRegistrationOptions &other
    ) -> HoverRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            HoverOptions::operator=(other);
        }
        return *this;
    }

    SignatureHelpRegistrationOptions::SignatureHelpRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , SignatureHelpOptions()
    {
        // empty
    }

    SignatureHelpRegistrationOptions::SignatureHelpRegistrationOptions(
        SignatureHelpRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , SignatureHelpOptions(other)
    {
        // empty
    }

    SignatureHelpRegistrationOptions::SignatureHelpRegistrationOptions(
        const SignatureHelpRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , SignatureHelpOptions(other)
    {
    }

    SignatureHelpRegistrationOptions::~SignatureHelpRegistrationOptions()
    {
        // empty
    }

    auto SignatureHelpRegistrationOptions::operator=(
        SignatureHelpRegistrationOptions &&other
    ) -> SignatureHelpRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            SignatureHelpOptions::operator=(other);
        }
        return *this;
    }

    auto SignatureHelpRegistrationOptions::operator=(
        const SignatureHelpRegistrationOptions &other
    ) -> SignatureHelpRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            SignatureHelpOptions::operator=(other);
        }
        return *this;
    }

    DefinitionRegistrationOptions::DefinitionRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DefinitionOptions()
    {
        // empty
    }

    DefinitionRegistrationOptions::DefinitionRegistrationOptions(
        DefinitionRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DefinitionOptions(other)
    {
        // empty
    }

    DefinitionRegistrationOptions::DefinitionRegistrationOptions(
        const DefinitionRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DefinitionOptions(other)
    {
    }

    DefinitionRegistrationOptions::~DefinitionRegistrationOptions()
    {
        // empty
    }

    auto DefinitionRegistrationOptions::operator=(
        DefinitionRegistrationOptions &&other
    ) -> DefinitionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DefinitionOptions::operator=(other);
        }
        return *this;
    }

    auto DefinitionRegistrationOptions::operator=(
        const DefinitionRegistrationOptions &other
    ) -> DefinitionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DefinitionOptions::operator=(other);
        }
        return *this;
    }

    ReferenceRegistrationOptions::ReferenceRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , ReferenceOptions()
    {
        // empty
    }

    ReferenceRegistrationOptions::ReferenceRegistrationOptions(
        ReferenceRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , ReferenceOptions(other)
    {
        // empty
    }

    ReferenceRegistrationOptions::ReferenceRegistrationOptions(
        const ReferenceRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , ReferenceOptions(other)
    {
    }

    ReferenceRegistrationOptions::~ReferenceRegistrationOptions()
    {
        // empty
    }

    auto ReferenceRegistrationOptions::operator=(
        ReferenceRegistrationOptions &&other
    ) -> ReferenceRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            ReferenceOptions::operator=(other);
        }
        return *this;
    }

    auto ReferenceRegistrationOptions::operator=(
        const ReferenceRegistrationOptions &other
    ) -> ReferenceRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            ReferenceOptions::operator=(other);
        }
        return *this;
    }

    DocumentHighlightRegistrationOptions::DocumentHighlightRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DocumentHighlightOptions()
    {
        // empty
    }

    DocumentHighlightRegistrationOptions::DocumentHighlightRegistrationOptions(
        DocumentHighlightRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentHighlightOptions(other)
    {
        // empty
    }

    DocumentHighlightRegistrationOptions::DocumentHighlightRegistrationOptions(
        const DocumentHighlightRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentHighlightOptions(other)
    {
    }

    DocumentHighlightRegistrationOptions::~DocumentHighlightRegistrationOptions()
    {
        // empty
    }

    auto DocumentHighlightRegistrationOptions::operator=(
        DocumentHighlightRegistrationOptions &&other
    ) -> DocumentHighlightRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentHighlightOptions::operator=(other);
        }
        return *this;
    }

    auto DocumentHighlightRegistrationOptions::operator=(
        const DocumentHighlightRegistrationOptions &other
    ) -> DocumentHighlightRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentHighlightOptions::operator=(other);
        }
        return *this;
    }

    DocumentSymbolRegistrationOptions::DocumentSymbolRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DocumentSymbolOptions()
    {
        // empty
    }

    DocumentSymbolRegistrationOptions::DocumentSymbolRegistrationOptions(
        DocumentSymbolRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentSymbolOptions(other)
    {
        // empty
    }

    DocumentSymbolRegistrationOptions::DocumentSymbolRegistrationOptions(
        const DocumentSymbolRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentSymbolOptions(other)
    {
    }

    DocumentSymbolRegistrationOptions::~DocumentSymbolRegistrationOptions()
    {
        // empty
    }

    auto DocumentSymbolRegistrationOptions::operator=(
        DocumentSymbolRegistrationOptions &&other
    ) -> DocumentSymbolRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentSymbolOptions::operator=(other);
        }
        return *this;
    }

    auto DocumentSymbolRegistrationOptions::operator=(
        const DocumentSymbolRegistrationOptions &other
    ) -> DocumentSymbolRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentSymbolOptions::operator=(other);
        }
        return *this;
    }

    CodeActionRegistrationOptions::CodeActionRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , CodeActionOptions()
    {
        // empty
    }

    CodeActionRegistrationOptions::CodeActionRegistrationOptions(
        CodeActionRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , CodeActionOptions(other)
    {
        // empty
    }

    CodeActionRegistrationOptions::CodeActionRegistrationOptions(
        const CodeActionRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , CodeActionOptions(other)
    {
    }

    CodeActionRegistrationOptions::~CodeActionRegistrationOptions()
    {
        // empty
    }

    auto CodeActionRegistrationOptions::operator=(
        CodeActionRegistrationOptions &&other
    ) -> CodeActionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CodeActionOptions::operator=(other);
        }
        return *this;
    }

    auto CodeActionRegistrationOptions::operator=(
        const CodeActionRegistrationOptions &other
    ) -> CodeActionRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CodeActionOptions::operator=(other);
        }
        return *this;
    }

    CodeLensRegistrationOptions::CodeLensRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , CodeLensOptions()
    {
        // empty
    }

    CodeLensRegistrationOptions::CodeLensRegistrationOptions(
        CodeLensRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , CodeLensOptions(other)
    {
        // empty
    }

    CodeLensRegistrationOptions::CodeLensRegistrationOptions(
        const CodeLensRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , CodeLensOptions(other)
    {
    }

    CodeLensRegistrationOptions::~CodeLensRegistrationOptions()
    {
        // empty
    }

    auto CodeLensRegistrationOptions::operator=(
        CodeLensRegistrationOptions &&other
    ) -> CodeLensRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CodeLensOptions::operator=(other);
        }
        return *this;
    }

    auto CodeLensRegistrationOptions::operator=(
        const CodeLensRegistrationOptions &other
    ) -> CodeLensRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            CodeLensOptions::operator=(other);
        }
        return *this;
    }

    DocumentLinkRegistrationOptions::DocumentLinkRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DocumentLinkOptions()
    {
        // empty
    }

    DocumentLinkRegistrationOptions::DocumentLinkRegistrationOptions(
        DocumentLinkRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentLinkOptions(other)
    {
        // empty
    }

    DocumentLinkRegistrationOptions::DocumentLinkRegistrationOptions(
        const DocumentLinkRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentLinkOptions(other)
    {
    }

    DocumentLinkRegistrationOptions::~DocumentLinkRegistrationOptions()
    {
        // empty
    }

    auto DocumentLinkRegistrationOptions::operator=(
        DocumentLinkRegistrationOptions &&other
    ) -> DocumentLinkRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentLinkOptions::operator=(other);
        }
        return *this;
    }

    auto DocumentLinkRegistrationOptions::operator=(
        const DocumentLinkRegistrationOptions &other
    ) -> DocumentLinkRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentLinkOptions::operator=(other);
        }
        return *this;
    }

    DocumentFormattingRegistrationOptions::DocumentFormattingRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DocumentFormattingOptions()
    {
        // empty
    }

    DocumentFormattingRegistrationOptions::DocumentFormattingRegistrationOptions(
        DocumentFormattingRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentFormattingOptions(other)
    {
        // empty
    }

    DocumentFormattingRegistrationOptions::DocumentFormattingRegistrationOptions(
        const DocumentFormattingRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentFormattingOptions(other)
    {
    }

    DocumentFormattingRegistrationOptions::~DocumentFormattingRegistrationOptions()
    {
        // empty
    }

    auto DocumentFormattingRegistrationOptions::operator=(
        DocumentFormattingRegistrationOptions &&other
    ) -> DocumentFormattingRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentFormattingOptions::operator=(other);
        }
        return *this;
    }

    auto DocumentFormattingRegistrationOptions::operator=(
        const DocumentFormattingRegistrationOptions &other
    ) -> DocumentFormattingRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentFormattingOptions::operator=(other);
        }
        return *this;
    }

    DocumentRangeFormattingRegistrationOptions::DocumentRangeFormattingRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DocumentRangeFormattingOptions()
    {
        // empty
    }

    DocumentRangeFormattingRegistrationOptions::DocumentRangeFormattingRegistrationOptions(
        DocumentRangeFormattingRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentRangeFormattingOptions(other)
    {
        // empty
    }

    DocumentRangeFormattingRegistrationOptions::DocumentRangeFormattingRegistrationOptions(
        const DocumentRangeFormattingRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentRangeFormattingOptions(other)
    {
    }

    DocumentRangeFormattingRegistrationOptions::~DocumentRangeFormattingRegistrationOptions()
    {
        // empty
    }

    auto DocumentRangeFormattingRegistrationOptions::operator=(
        DocumentRangeFormattingRegistrationOptions &&other
    ) -> DocumentRangeFormattingRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentRangeFormattingOptions::operator=(other);
        }
        return *this;
    }

    auto DocumentRangeFormattingRegistrationOptions::operator=(
        const DocumentRangeFormattingRegistrationOptions &other
    ) -> DocumentRangeFormattingRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentRangeFormattingOptions::operator=(other);
        }
        return *this;
    }

    DocumentOnTypeFormattingRegistrationOptions::DocumentOnTypeFormattingRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , DocumentOnTypeFormattingOptions()
    {
        // empty
    }

    DocumentOnTypeFormattingRegistrationOptions::DocumentOnTypeFormattingRegistrationOptions(
        DocumentOnTypeFormattingRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentOnTypeFormattingOptions(other)
    {
        // empty
    }

    DocumentOnTypeFormattingRegistrationOptions::DocumentOnTypeFormattingRegistrationOptions(
        const DocumentOnTypeFormattingRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , DocumentOnTypeFormattingOptions(other)
    {
    }

    DocumentOnTypeFormattingRegistrationOptions::~DocumentOnTypeFormattingRegistrationOptions()
    {
        // empty
    }

    auto DocumentOnTypeFormattingRegistrationOptions::operator=(
        DocumentOnTypeFormattingRegistrationOptions &&other
    ) -> DocumentOnTypeFormattingRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentOnTypeFormattingOptions::operator=(other);
        }
        return *this;
    }

    auto DocumentOnTypeFormattingRegistrationOptions::operator=(
        const DocumentOnTypeFormattingRegistrationOptions &other
    ) -> DocumentOnTypeFormattingRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            DocumentOnTypeFormattingOptions::operator=(other);
        }
        return *this;
    }

    RenameRegistrationOptions::RenameRegistrationOptions()
        : TextDocumentRegistrationOptions()
        , RenameOptions()
    {
        // empty
    }

    RenameRegistrationOptions::RenameRegistrationOptions(
        RenameRegistrationOptions &&other
    )
        : TextDocumentRegistrationOptions(other)
        , RenameOptions(other)
    {
        // empty
    }

    RenameRegistrationOptions::RenameRegistrationOptions(
        const RenameRegistrationOptions &other
    )
        : TextDocumentRegistrationOptions(other)
        , RenameOptions(other)
    {
    }

    RenameRegistrationOptions::~RenameRegistrationOptions()
    {
        // empty
    }

    auto RenameRegistrationOptions::operator=(
        RenameRegistrationOptions &&other
    ) -> RenameRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            RenameOptions::operator=(other);
        }
        return *this;
    }

    auto RenameRegistrationOptions::operator=(
        const RenameRegistrationOptions &other
    ) -> RenameRegistrationOptions &
    {
        if (this != &other) {
            TextDocumentRegistrationOptions::operator=(other);
            RenameOptions::operator=(other);
        }
        return *this;
    }

    const std::map<_InitializeParams_rootPathType, std::string>
    _InitializeParams_rootPathTypeNames = {
        {_InitializeParams_rootPathType::Uninitialized, "Uninitialized"},
        {_InitializeParams_rootPathType::String, "String"},
        {_InitializeParams_rootPathType::Null, "Null"},
    };

    _InitializeParams_rootPath::_InitializeParams_rootPath()
    {
        // empty
    }

    _InitializeParams_rootPath::~_InitializeParams_rootPath()
    {
        reset();
    }

    _InitializeParams_rootPath::_InitializeParams_rootPath(
        _InitializeParams_rootPath &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case _InitializeParams_rootPathType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::move(other._string)
            };
            break;
        }
        case _InitializeParams_rootPathType::Null: {
            _null = other._null;
            break;
        }
        case _InitializeParams_rootPathType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = _InitializeParams_rootPathType::Uninitialized;
    }

    _InitializeParams_rootPath::_InitializeParams_rootPath(
        const _InitializeParams_rootPath &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case _InitializeParams_rootPathType::String: {
            new (&_string) std::unique_ptr<string_t> {
                std::make_unique<string_t>(*other._string)
            };
            break;
        }
        case _InitializeParams_rootPathType::Null: {
            _null = other._null;
            break;
        }
        case _InitializeParams_rootPathType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto _InitializeParams_rootPath::operator=(
        _InitializeParams_rootPath &&other
    ) -> _InitializeParams_rootPath &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case _InitializeParams_rootPathType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::move(other._string)
                };
                break;
            }
            case _InitializeParams_rootPathType::Null: {
                _null = other._null;
                break;
            }
            case _InitializeParams_rootPathType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = _InitializeParams_rootPathType::Uninitialized;
        }
        return *this;
    }

    auto _InitializeParams_rootPath::operator=(
        const _InitializeParams_rootPath &other
    ) -> _InitializeParams_rootPath &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case _InitializeParams_rootPathType::String: {
                new (&_string) std::unique_ptr<string_t> {
                    std::make_unique<string_t>(*other._string)
                };
                break;
            }
            case _InitializeParams_rootPathType::Null: {
                _null = other._null;
                break;
            }
            case _InitializeParams_rootPathType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto _InitializeParams_rootPath::reset() -> void
    {
        switch (_type) {
        case _InitializeParams_rootPathType::Uninitialized: {
            // nothing to do
            break;
        }
        case _InitializeParams_rootPathType::String: {
#ifdef DEBUG
            if (!_string) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _string"
                );
            }
#endif // DEBUG
            _string.~unique_ptr<string_t>();
            _type = _InitializeParams_rootPathType::Uninitialized;
            break;
        }
        default: {
            _type = _InitializeParams_rootPathType::Uninitialized;
        }
        }
    }

    auto _InitializeParams_rootPath::type() const
    -> const _InitializeParams_rootPathType &
    {
        return _type;
    }

    auto _InitializeParams_rootPath::string() const -> const string_t &
    {
#ifdef DEBUG
        if (_type != _InitializeParams_rootPathType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "_InitializeParams_rootPath::string()"
                 " of type "
                 "_InitializeParams_rootPathType::String"
                 " while active type is "
                 "_InitializeParams_rootPathType::" +
                 _InitializeParams_rootPathTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_string;
    }

    auto _InitializeParams_rootPath::operator=(
        const std::unique_ptr<string_t> &string
    ) -> _InitializeParams_rootPath &
    {
        if (_type != _InitializeParams_rootPathType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(*string)
        };
        _type = _InitializeParams_rootPathType::String;
        return *this;
    }

    auto _InitializeParams_rootPath::operator=(
        std::unique_ptr<string_t> &&string
    ) -> _InitializeParams_rootPath &
    {
        if (_type != _InitializeParams_rootPathType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!string) {
            throw std::logic_error("null passed as the value of string");
        }
#endif // DEBUG
        new (&_string) std::unique_ptr<string_t> {
            std::move(string)
        };
        _type = _InitializeParams_rootPathType::String;
        return *this;
    }

    auto _InitializeParams_rootPath::operator=(
        const string_t &string
    ) -> _InitializeParams_rootPath &
    {
        if (_type != _InitializeParams_rootPathType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(string)
        };
        _type = _InitializeParams_rootPathType::String;
        return *this;
    }

    auto _InitializeParams_rootPath::operator=(
        string_t &&string
    ) -> _InitializeParams_rootPath &
    {
        if (_type != _InitializeParams_rootPathType::Uninitialized) {
            reset();
        }
        new (&_string) std::unique_ptr<string_t> {
            std::make_unique<string_t>(std::move(string))
        };
        _type = _InitializeParams_rootPathType::String;
        return *this;
    }

    auto _InitializeParams_rootPath::null() const -> const null_t &
    {
#ifdef DEBUG
        if (_type != _InitializeParams_rootPathType::Null) {
            throw std::logic_error(
                ("Attempted to access "
                 "_InitializeParams_rootPath::null()"
                 " of type "
                 "_InitializeParams_rootPathType::Null"
                 " while active type is "
                 "_InitializeParams_rootPathType::" +
                 _InitializeParams_rootPathTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _null;
    }

    auto _InitializeParams_rootPath::operator=(
        null_t null
    ) -> _InitializeParams_rootPath &
    {
        if (_type != _InitializeParams_rootPathType::Uninitialized) {
            reset();
        }
        _null = null;
        _type = _InitializeParams_rootPathType::Null;
        return *this;
    }

    const std::map<_InitializeParams_rootUriType, std::string>
    _InitializeParams_rootUriTypeNames = {
        {_InitializeParams_rootUriType::Uninitialized, "Uninitialized"},
        {_InitializeParams_rootUriType::String, "String"},
        {_InitializeParams_rootUriType::Null, "Null"},
    };

    _InitializeParams_rootUri::_InitializeParams_rootUri()
    {
        // empty
    }

    _InitializeParams_rootUri::~_InitializeParams_rootUri()
    {
        reset();
    }

    _InitializeParams_rootUri::_InitializeParams_rootUri(
        _InitializeParams_rootUri &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case _InitializeParams_rootUriType::String: {
            new (&_documentUri) std::unique_ptr<DocumentUri> {
                std::move(other._documentUri)
            };
            break;
        }
        case _InitializeParams_rootUriType::Null: {
            _null = other._null;
            break;
        }
        case _InitializeParams_rootUriType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = _InitializeParams_rootUriType::Uninitialized;
    }

    _InitializeParams_rootUri::_InitializeParams_rootUri(
        const _InitializeParams_rootUri &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case _InitializeParams_rootUriType::String: {
            new (&_documentUri) std::unique_ptr<DocumentUri> {
                std::make_unique<DocumentUri>(*other._documentUri)
            };
            break;
        }
        case _InitializeParams_rootUriType::Null: {
            _null = other._null;
            break;
        }
        case _InitializeParams_rootUriType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto _InitializeParams_rootUri::operator=(
        _InitializeParams_rootUri &&other
    ) -> _InitializeParams_rootUri &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case _InitializeParams_rootUriType::String: {
                new (&_documentUri) std::unique_ptr<DocumentUri> {
                    std::move(other._documentUri)
                };
                break;
            }
            case _InitializeParams_rootUriType::Null: {
                _null = other._null;
                break;
            }
            case _InitializeParams_rootUriType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = _InitializeParams_rootUriType::Uninitialized;
        }
        return *this;
    }

    auto _InitializeParams_rootUri::operator=(
        const _InitializeParams_rootUri &other
    ) -> _InitializeParams_rootUri &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case _InitializeParams_rootUriType::String: {
                new (&_documentUri) std::unique_ptr<DocumentUri> {
                    std::make_unique<DocumentUri>(*other._documentUri)
                };
                break;
            }
            case _InitializeParams_rootUriType::Null: {
                _null = other._null;
                break;
            }
            case _InitializeParams_rootUriType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto _InitializeParams_rootUri::reset() -> void
    {
        switch (_type) {
        case _InitializeParams_rootUriType::Uninitialized: {
            // nothing to do
            break;
        }
        case _InitializeParams_rootUriType::String: {
#ifdef DEBUG
            if (!_documentUri) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentUri"
                );
            }
#endif // DEBUG
            _documentUri.~unique_ptr<DocumentUri>();
            _type = _InitializeParams_rootUriType::Uninitialized;
            break;
        }
        default: {
            _type = _InitializeParams_rootUriType::Uninitialized;
        }
        }
    }

    auto _InitializeParams_rootUri::type() const
    -> const _InitializeParams_rootUriType &
    {
        return _type;
    }

    auto _InitializeParams_rootUri::documentUri() const -> const DocumentUri &
    {
#ifdef DEBUG
        if (_type != _InitializeParams_rootUriType::String) {
            throw std::logic_error(
                ("Attempted to access "
                 "_InitializeParams_rootUri::documentUri()"
                 " of type "
                 "_InitializeParams_rootUriType::String"
                 " while active type is "
                 "_InitializeParams_rootUriType::" +
                 _InitializeParams_rootUriTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentUri;
    }

    auto _InitializeParams_rootUri::operator=(
        const std::unique_ptr<DocumentUri> &documentUri
    ) -> _InitializeParams_rootUri &
    {
        if (_type != _InitializeParams_rootUriType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentUri) {
            throw std::logic_error("null passed as the value of documentUri");
        }
#endif // DEBUG
        new (&_documentUri) std::unique_ptr<DocumentUri> {
            std::make_unique<DocumentUri>(*documentUri)
        };
        _type = _InitializeParams_rootUriType::String;
        return *this;
    }

    auto _InitializeParams_rootUri::operator=(
        std::unique_ptr<DocumentUri> &&documentUri
    ) -> _InitializeParams_rootUri &
    {
        if (_type != _InitializeParams_rootUriType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentUri) {
            throw std::logic_error("null passed as the value of documentUri");
        }
#endif // DEBUG
        new (&_documentUri) std::unique_ptr<DocumentUri> {
            std::move(documentUri)
        };
        _type = _InitializeParams_rootUriType::String;
        return *this;
    }

    auto _InitializeParams_rootUri::operator=(
        const DocumentUri &documentUri
    ) -> _InitializeParams_rootUri &
    {
        if (_type != _InitializeParams_rootUriType::Uninitialized) {
            reset();
        }
        new (&_documentUri) std::unique_ptr<DocumentUri> {
            std::make_unique<DocumentUri>(documentUri)
        };
        _type = _InitializeParams_rootUriType::String;
        return *this;
    }

    auto _InitializeParams_rootUri::operator=(
        DocumentUri &&documentUri
    ) -> _InitializeParams_rootUri &
    {
        if (_type != _InitializeParams_rootUriType::Uninitialized) {
            reset();
        }
        new (&_documentUri) std::unique_ptr<DocumentUri> {
            std::make_unique<DocumentUri>(std::move(documentUri))
        };
        _type = _InitializeParams_rootUriType::String;
        return *this;
    }

    auto _InitializeParams_rootUri::null() const -> const null_t &
    {
#ifdef DEBUG
        if (_type != _InitializeParams_rootUriType::Null) {
            throw std::logic_error(
                ("Attempted to access "
                 "_InitializeParams_rootUri::null()"
                 " of type "
                 "_InitializeParams_rootUriType::Null"
                 " while active type is "
                 "_InitializeParams_rootUriType::" +
                 _InitializeParams_rootUriTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _null;
    }

    auto _InitializeParams_rootUri::operator=(
        null_t null
    ) -> _InitializeParams_rootUri &
    {
        if (_type != _InitializeParams_rootUriType::Uninitialized) {
            reset();
        }
        _null = null;
        _type = _InitializeParams_rootUriType::Null;
        return *this;
    }

    const std::map<
        WorkspaceFoldersInitializeParams_workspaceFoldersType,
        std::string
    > WorkspaceFoldersInitializeParams_workspaceFoldersTypeNames = {
        {WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized,
         "Uninitialized"},
        {WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray,
         "WorkspaceFolderArray"},
        {WorkspaceFoldersInitializeParams_workspaceFoldersType::Null, "Null"},
    };

    WorkspaceFoldersInitializeParams_workspaceFolders::WorkspaceFoldersInitializeParams_workspaceFolders()
    {
        // empty
    }

    WorkspaceFoldersInitializeParams_workspaceFolders::~WorkspaceFoldersInitializeParams_workspaceFolders()
    {
        reset();
    }

    WorkspaceFoldersInitializeParams_workspaceFolders::WorkspaceFoldersInitializeParams_workspaceFolders(
        WorkspaceFoldersInitializeParams_workspaceFolders &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray: {
            new (&_workspaceFolderArray) std::unique_ptr<WorkspaceFoldersInitializeParams_workspaceFolders_0> {
                std::move(other._workspaceFolderArray)
            };
            break;
        }
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::Null: {
            _null = other._null;
            break;
        }
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized;
    }

    WorkspaceFoldersInitializeParams_workspaceFolders::WorkspaceFoldersInitializeParams_workspaceFolders(
        const WorkspaceFoldersInitializeParams_workspaceFolders &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray: {
            new (&_workspaceFolderArray) std::unique_ptr<std::vector<WorkspaceFolder>> {
                std::make_unique<std::vector<WorkspaceFolder>>()
            };
            _workspaceFolderArray->reserve(
                other._workspaceFolderArray->size()
            );
            for (const auto &elem_0 : *other._workspaceFolderArray) {
                _workspaceFolderArray->push_back(elem_0);
            }
            break;
        }
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::Null: {
            _null = other._null;
            break;
        }
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::operator=(
        WorkspaceFoldersInitializeParams_workspaceFolders &&other
    ) -> WorkspaceFoldersInitializeParams_workspaceFolders &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray: {
                new (&_workspaceFolderArray) std::unique_ptr<WorkspaceFoldersInitializeParams_workspaceFolders_0> {
                    std::move(other._workspaceFolderArray)
                };
                break;
            }
            case WorkspaceFoldersInitializeParams_workspaceFoldersType::Null: {
                _null = other._null;
                break;
            }
            case WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized;
        }
        return *this;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::operator=(
        const WorkspaceFoldersInitializeParams_workspaceFolders &other
    ) -> WorkspaceFoldersInitializeParams_workspaceFolders &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray: {
                new (&_workspaceFolderArray) std::unique_ptr<std::vector<WorkspaceFolder>> {
                    std::make_unique<std::vector<WorkspaceFolder>>()
                };
                _workspaceFolderArray->reserve(
                    other._workspaceFolderArray->size()
                );
                for (const auto &elem_0 : *other._workspaceFolderArray) {
                    _workspaceFolderArray->push_back(elem_0);
                }
                break;
            }
            case WorkspaceFoldersInitializeParams_workspaceFoldersType::Null: {
                _null = other._null;
                break;
            }
            case WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::reset() -> void
    {
        switch (_type) {
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized: {
            // nothing to do
            break;
        }
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray: {
#ifdef DEBUG
            if (!_workspaceFolderArray) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _workspaceFolderArray"
                );
            }
#endif // DEBUG
            _workspaceFolderArray.~unique_ptr<std::vector<WorkspaceFolder>>();
            _type =
                WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized;
            break;
        }
        default: {
            _type = WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized;
        }
        }
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::type() const
    -> const WorkspaceFoldersInitializeParams_workspaceFoldersType &
    {
        return _type;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::workspaceFolderArray() const
    -> const std::vector<WorkspaceFolder> &
    {
#ifdef DEBUG
        if (_type != WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray) {
            throw std::logic_error(
                ("Attempted to access "
                 "WorkspaceFoldersInitializeParams_workspaceFolders::workspaceFolderArray()"
                 " of type "
                 "WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray"
                 " while active type is "
                 "WorkspaceFoldersInitializeParams_workspaceFoldersType::" +
                 WorkspaceFoldersInitializeParams_workspaceFoldersTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_workspaceFolderArray;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::operator=(
        const std::unique_ptr<std::vector<WorkspaceFolder>> &workspaceFolderArray
    ) -> WorkspaceFoldersInitializeParams_workspaceFolders &
    {
        if (_type !=
                WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!workspaceFolderArray) {
            throw std::logic_error(
                "null passed as the value of workspaceFolderArray"
            );
        }
#endif // DEBUG
        new (&_workspaceFolderArray) std::unique_ptr<std::vector<WorkspaceFolder>> {
            std::make_unique<std::vector<WorkspaceFolder>>()
        };
        _workspaceFolderArray->reserve(workspaceFolderArray->size());
        for (const auto &elem_0 : *workspaceFolderArray) {
            _workspaceFolderArray->push_back(elem_0);
        }
        _type =
            WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray;
        return *this;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::operator=(
        std::unique_ptr<std::vector<WorkspaceFolder>> &&workspaceFolderArray
    ) -> WorkspaceFoldersInitializeParams_workspaceFolders &
    {
        if (_type !=
                WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!workspaceFolderArray) {
            throw std::logic_error(
                "null passed as the value of workspaceFolderArray"
            );
        }
#endif // DEBUG
        new (&_workspaceFolderArray) std::unique_ptr<WorkspaceFoldersInitializeParams_workspaceFolders_0> {
            std::move(workspaceFolderArray)
        };
        _type =
            WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray;
        return *this;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::operator=(
        const std::vector<WorkspaceFolder> &workspaceFolderArray
    ) -> WorkspaceFoldersInitializeParams_workspaceFolders &
    {
        if (_type !=
                WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized) {
            reset();
        }
        new (&_workspaceFolderArray) std::unique_ptr<std::vector<WorkspaceFolder>> {
            std::make_unique<std::vector<WorkspaceFolder>>()
        };
        _workspaceFolderArray->reserve(workspaceFolderArray.size());
        for (const auto &elem_0 : workspaceFolderArray) {
            _workspaceFolderArray->push_back(elem_0);
        }
        _type =
            WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray;
        return *this;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::operator=(
        std::vector<WorkspaceFolder> &&workspaceFolderArray
    ) -> WorkspaceFoldersInitializeParams_workspaceFolders &
    {
        if (_type !=
                WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized) {
            reset();
        }
        new (&_workspaceFolderArray) std::unique_ptr<WorkspaceFoldersInitializeParams_workspaceFolders_0> {
            std::make_unique<WorkspaceFoldersInitializeParams_workspaceFolders_0>(std::move(workspaceFolderArray))
        };
        _type =
            WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray;
        return *this;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::null() const
    -> const null_t &
    {
#ifdef DEBUG
        if (_type != WorkspaceFoldersInitializeParams_workspaceFoldersType::Null) {
            throw std::logic_error(
                ("Attempted to access "
                 "WorkspaceFoldersInitializeParams_workspaceFolders::null()"
                 " of type "
                 "WorkspaceFoldersInitializeParams_workspaceFoldersType::Null"
                 " while active type is "
                 "WorkspaceFoldersInitializeParams_workspaceFoldersType::" +
                 WorkspaceFoldersInitializeParams_workspaceFoldersTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _null;
    }

    auto WorkspaceFoldersInitializeParams_workspaceFolders::operator=(
        null_t null
    ) -> WorkspaceFoldersInitializeParams_workspaceFolders &
    {
        if (_type !=
                WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized) {
            reset();
        }
        _null = null;
        _type = WorkspaceFoldersInitializeParams_workspaceFoldersType::Null;
        return *this;
    }

    WorkspaceFoldersInitializeParams::WorkspaceFoldersInitializeParams()
    {
        // empty
    }

    WorkspaceFoldersInitializeParams::WorkspaceFoldersInitializeParams(
        WorkspaceFoldersInitializeParams &&other
    )
        : workspaceFolders(std::move(other.workspaceFolders))
    {
        // empty
    }

    WorkspaceFoldersInitializeParams::WorkspaceFoldersInitializeParams(
        const WorkspaceFoldersInitializeParams &other
    )
    {
        if (other.workspaceFolders.has_value()) {
            workspaceFolders = other.workspaceFolders.value();
        }
    }

    WorkspaceFoldersInitializeParams::~WorkspaceFoldersInitializeParams()
    {
        // empty
    }

    auto WorkspaceFoldersInitializeParams::operator=(
        WorkspaceFoldersInitializeParams &&other
    ) -> WorkspaceFoldersInitializeParams &
    {
        if (this != &other) {
            workspaceFolders = std::move(other.workspaceFolders);
        }
        return *this;
    }

    auto WorkspaceFoldersInitializeParams::operator=(
        const WorkspaceFoldersInitializeParams &other
    ) -> WorkspaceFoldersInitializeParams &
    {
        if (this != &other) {
            if (other.workspaceFolders.has_value()) {
                workspaceFolders = other.workspaceFolders.value();
            }
        }
        return *this;
    }

    const std::map<ServerCapabilities_declarationProviderType, std::string>
    ServerCapabilities_declarationProviderTypeNames = {
        {ServerCapabilities_declarationProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_declarationProviderType::Boolean, "Boolean"},
        {ServerCapabilities_declarationProviderType::DeclarationOptions,
         "DeclarationOptions"},
        {ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions,
         "DeclarationRegistrationOptions"},
    };

    ServerCapabilities_declarationProvider::ServerCapabilities_declarationProvider()
    {
        // empty
    }

    ServerCapabilities_declarationProvider::~ServerCapabilities_declarationProvider()
    {
        reset();
    }

    ServerCapabilities_declarationProvider::ServerCapabilities_declarationProvider(
        ServerCapabilities_declarationProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_declarationProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_declarationProviderType::DeclarationOptions: {
            new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
                std::move(other._declarationOptions)
            };
            break;
        }
        case ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions: {
            new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
                std::move(other._declarationRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_declarationProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_declarationProviderType::Uninitialized;
    }

    ServerCapabilities_declarationProvider::ServerCapabilities_declarationProvider(
        const ServerCapabilities_declarationProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_declarationProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_declarationProviderType::DeclarationOptions: {
            new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
                std::make_unique<DeclarationOptions>(*other._declarationOptions)
            };
            break;
        }
        case ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions: {
            new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
                std::make_unique<DeclarationRegistrationOptions>(*other._declarationRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_declarationProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_declarationProvider::operator=(
        ServerCapabilities_declarationProvider &&other
    ) -> ServerCapabilities_declarationProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_declarationProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_declarationProviderType::DeclarationOptions: {
                new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
                    std::move(other._declarationOptions)
                };
                break;
            }
            case ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions: {
                new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
                    std::move(other._declarationRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_declarationProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_declarationProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        const ServerCapabilities_declarationProvider &other
    ) -> ServerCapabilities_declarationProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_declarationProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_declarationProviderType::DeclarationOptions: {
                new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
                    std::make_unique<DeclarationOptions>(*other._declarationOptions)
                };
                break;
            }
            case ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions: {
                new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
                    std::make_unique<DeclarationRegistrationOptions>(*other._declarationRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_declarationProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_declarationProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_declarationProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_declarationProviderType::DeclarationOptions: {
#ifdef DEBUG
            if (!_declarationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _declarationOptions"
                );
            }
#endif // DEBUG
            _declarationOptions.~unique_ptr<DeclarationOptions>();
            _type = ServerCapabilities_declarationProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions: {
#ifdef DEBUG
            if (!_declarationRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _declarationRegistrationOptions"
                );
            }
#endif // DEBUG
            _declarationRegistrationOptions.~unique_ptr<DeclarationRegistrationOptions>();
            _type = ServerCapabilities_declarationProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_declarationProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_declarationProvider::type() const
    -> const ServerCapabilities_declarationProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_declarationProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_declarationProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_declarationProvider::boolean()"
                 " of type "
                 "ServerCapabilities_declarationProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_declarationProviderType::" +
                 ServerCapabilities_declarationProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_declarationProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::declarationOptions() const
    -> const DeclarationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_declarationProviderType::DeclarationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_declarationProvider::declarationOptions()"
                 " of type "
                 "ServerCapabilities_declarationProviderType::DeclarationOptions"
                 " while active type is "
                 "ServerCapabilities_declarationProviderType::" +
                 ServerCapabilities_declarationProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_declarationOptions;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        const std::unique_ptr<DeclarationOptions> &declarationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!declarationOptions) {
            throw std::logic_error(
                "null passed as the value of declarationOptions"
            );
        }
#endif // DEBUG
        new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
            std::make_unique<DeclarationOptions>(*declarationOptions)
        };
        _type = ServerCapabilities_declarationProviderType::DeclarationOptions;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        std::unique_ptr<DeclarationOptions> &&declarationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!declarationOptions) {
            throw std::logic_error(
                "null passed as the value of declarationOptions"
            );
        }
#endif // DEBUG
        new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
            std::move(declarationOptions)
        };
        _type = ServerCapabilities_declarationProviderType::DeclarationOptions;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        const DeclarationOptions &declarationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
        new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
            std::make_unique<DeclarationOptions>(declarationOptions)
        };
        _type = ServerCapabilities_declarationProviderType::DeclarationOptions;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        DeclarationOptions &&declarationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
        new (&_declarationOptions) std::unique_ptr<DeclarationOptions> {
            std::make_unique<DeclarationOptions>(std::move(declarationOptions))
        };
        _type = ServerCapabilities_declarationProviderType::DeclarationOptions;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::declarationRegistrationOptions() const
    -> const DeclarationRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_declarationProvider::declarationRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_declarationProviderType::" +
                 ServerCapabilities_declarationProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_declarationRegistrationOptions;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        const std::unique_ptr<DeclarationRegistrationOptions> &declarationRegistrationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!declarationRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of declarationRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
            std::make_unique<DeclarationRegistrationOptions>(*declarationRegistrationOptions)
        };
        _type =
            ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        std::unique_ptr<DeclarationRegistrationOptions> &&declarationRegistrationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!declarationRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of declarationRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
            std::move(declarationRegistrationOptions)
        };
        _type =
            ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        const DeclarationRegistrationOptions &declarationRegistrationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
        new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
            std::make_unique<DeclarationRegistrationOptions>(declarationRegistrationOptions)
        };
        _type =
            ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_declarationProvider::operator=(
        DeclarationRegistrationOptions &&declarationRegistrationOptions
    ) -> ServerCapabilities_declarationProvider &
    {
        if (_type !=
                ServerCapabilities_declarationProviderType::Uninitialized) {
            reset();
        }
        new (&_declarationRegistrationOptions) std::unique_ptr<DeclarationRegistrationOptions> {
            std::make_unique<DeclarationRegistrationOptions>(std::move(declarationRegistrationOptions))
        };
        _type =
            ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_typeDefinitionProviderType, std::string>
    ServerCapabilities_typeDefinitionProviderTypeNames = {
        {ServerCapabilities_typeDefinitionProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_typeDefinitionProviderType::Boolean, "Boolean"},
        {ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions,
         "TypeDefinitionOptions"},
        {ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions,
         "TypeDefinitionRegistrationOptions"},
    };

    ServerCapabilities_typeDefinitionProvider::ServerCapabilities_typeDefinitionProvider()
    {
        // empty
    }

    ServerCapabilities_typeDefinitionProvider::~ServerCapabilities_typeDefinitionProvider()
    {
        reset();
    }

    ServerCapabilities_typeDefinitionProvider::ServerCapabilities_typeDefinitionProvider(
        ServerCapabilities_typeDefinitionProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_typeDefinitionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions: {
            new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
                std::move(other._typeDefinitionOptions)
            };
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions: {
            new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
                std::move(other._typeDefinitionRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_typeDefinitionProviderType::Uninitialized;
    }

    ServerCapabilities_typeDefinitionProvider::ServerCapabilities_typeDefinitionProvider(
        const ServerCapabilities_typeDefinitionProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_typeDefinitionProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions: {
            new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
                std::make_unique<TypeDefinitionOptions>(*other._typeDefinitionOptions)
            };
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions: {
            new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
                std::make_unique<TypeDefinitionRegistrationOptions>(*other._typeDefinitionRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        ServerCapabilities_typeDefinitionProvider &&other
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_typeDefinitionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions: {
                new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
                    std::move(other._typeDefinitionOptions)
                };
                break;
            }
            case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions: {
                new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
                    std::move(other._typeDefinitionRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_typeDefinitionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_typeDefinitionProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        const ServerCapabilities_typeDefinitionProvider &other
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_typeDefinitionProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions: {
                new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
                    std::make_unique<TypeDefinitionOptions>(*other._typeDefinitionOptions)
                };
                break;
            }
            case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions: {
                new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
                    std::make_unique<TypeDefinitionRegistrationOptions>(*other._typeDefinitionRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_typeDefinitionProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_typeDefinitionProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions: {
#ifdef DEBUG
            if (!_typeDefinitionOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _typeDefinitionOptions"
                );
            }
#endif // DEBUG
            _typeDefinitionOptions.~unique_ptr<TypeDefinitionOptions>();
            _type =
                ServerCapabilities_typeDefinitionProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions: {
#ifdef DEBUG
            if (!_typeDefinitionRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _typeDefinitionRegistrationOptions"
                );
            }
#endif // DEBUG
            _typeDefinitionRegistrationOptions.~unique_ptr<TypeDefinitionRegistrationOptions>();
            _type =
                ServerCapabilities_typeDefinitionProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_typeDefinitionProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_typeDefinitionProvider::type() const
    -> const ServerCapabilities_typeDefinitionProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_typeDefinitionProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_typeDefinitionProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_typeDefinitionProvider::boolean()"
                 " of type "
                 "ServerCapabilities_typeDefinitionProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_typeDefinitionProviderType::" +
                 ServerCapabilities_typeDefinitionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_typeDefinitionProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::typeDefinitionOptions() const
    -> const TypeDefinitionOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_typeDefinitionProvider::typeDefinitionOptions()"
                 " of type "
                 "ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions"
                 " while active type is "
                 "ServerCapabilities_typeDefinitionProviderType::" +
                 ServerCapabilities_typeDefinitionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_typeDefinitionOptions;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        const std::unique_ptr<TypeDefinitionOptions> &typeDefinitionOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeDefinitionOptions) {
            throw std::logic_error(
                "null passed as the value of typeDefinitionOptions"
            );
        }
#endif // DEBUG
        new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
            std::make_unique<TypeDefinitionOptions>(*typeDefinitionOptions)
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        std::unique_ptr<TypeDefinitionOptions> &&typeDefinitionOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeDefinitionOptions) {
            throw std::logic_error(
                "null passed as the value of typeDefinitionOptions"
            );
        }
#endif // DEBUG
        new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
            std::move(typeDefinitionOptions)
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        const TypeDefinitionOptions &typeDefinitionOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
        new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
            std::make_unique<TypeDefinitionOptions>(typeDefinitionOptions)
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        TypeDefinitionOptions &&typeDefinitionOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
        new (&_typeDefinitionOptions) std::unique_ptr<TypeDefinitionOptions> {
            std::make_unique<TypeDefinitionOptions>(std::move(typeDefinitionOptions))
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::typeDefinitionRegistrationOptions() const
    -> const TypeDefinitionRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_typeDefinitionProvider::typeDefinitionRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_typeDefinitionProviderType::" +
                 ServerCapabilities_typeDefinitionProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_typeDefinitionRegistrationOptions;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        const std::unique_ptr<TypeDefinitionRegistrationOptions> &typeDefinitionRegistrationOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeDefinitionRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of typeDefinitionRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
            std::make_unique<TypeDefinitionRegistrationOptions>(*typeDefinitionRegistrationOptions)
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        std::unique_ptr<TypeDefinitionRegistrationOptions> &&typeDefinitionRegistrationOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeDefinitionRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of typeDefinitionRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
            std::move(typeDefinitionRegistrationOptions)
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        const TypeDefinitionRegistrationOptions &typeDefinitionRegistrationOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
        new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
            std::make_unique<TypeDefinitionRegistrationOptions>(typeDefinitionRegistrationOptions)
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_typeDefinitionProvider::operator=(
        TypeDefinitionRegistrationOptions &&typeDefinitionRegistrationOptions
    ) -> ServerCapabilities_typeDefinitionProvider &
    {
        if (_type !=
                ServerCapabilities_typeDefinitionProviderType::Uninitialized) {
            reset();
        }
        new (&_typeDefinitionRegistrationOptions) std::unique_ptr<TypeDefinitionRegistrationOptions> {
            std::make_unique<TypeDefinitionRegistrationOptions>(std::move(typeDefinitionRegistrationOptions))
        };
        _type =
            ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_implementationProviderType, std::string>
    ServerCapabilities_implementationProviderTypeNames = {
        {ServerCapabilities_implementationProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_implementationProviderType::Boolean, "Boolean"},
        {ServerCapabilities_implementationProviderType::ImplementationOptions,
         "ImplementationOptions"},
        {ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions,
         "ImplementationRegistrationOptions"},
    };

    ServerCapabilities_implementationProvider::ServerCapabilities_implementationProvider()
    {
        // empty
    }

    ServerCapabilities_implementationProvider::~ServerCapabilities_implementationProvider()
    {
        reset();
    }

    ServerCapabilities_implementationProvider::ServerCapabilities_implementationProvider(
        ServerCapabilities_implementationProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_implementationProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_implementationProviderType::ImplementationOptions: {
            new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
                std::move(other._implementationOptions)
            };
            break;
        }
        case ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions: {
            new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
                std::move(other._implementationRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_implementationProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_implementationProviderType::Uninitialized;
    }

    ServerCapabilities_implementationProvider::ServerCapabilities_implementationProvider(
        const ServerCapabilities_implementationProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_implementationProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_implementationProviderType::ImplementationOptions: {
            new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
                std::make_unique<ImplementationOptions>(*other._implementationOptions)
            };
            break;
        }
        case ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions: {
            new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
                std::make_unique<ImplementationRegistrationOptions>(*other._implementationRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_implementationProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_implementationProvider::operator=(
        ServerCapabilities_implementationProvider &&other
    ) -> ServerCapabilities_implementationProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_implementationProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_implementationProviderType::ImplementationOptions: {
                new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
                    std::move(other._implementationOptions)
                };
                break;
            }
            case ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions: {
                new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
                    std::move(other._implementationRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_implementationProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_implementationProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        const ServerCapabilities_implementationProvider &other
    ) -> ServerCapabilities_implementationProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_implementationProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_implementationProviderType::ImplementationOptions: {
                new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
                    std::make_unique<ImplementationOptions>(*other._implementationOptions)
                };
                break;
            }
            case ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions: {
                new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
                    std::make_unique<ImplementationRegistrationOptions>(*other._implementationRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_implementationProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_implementationProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_implementationProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_implementationProviderType::ImplementationOptions: {
#ifdef DEBUG
            if (!_implementationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _implementationOptions"
                );
            }
#endif // DEBUG
            _implementationOptions.~unique_ptr<ImplementationOptions>();
            _type =
                ServerCapabilities_implementationProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions: {
#ifdef DEBUG
            if (!_implementationRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _implementationRegistrationOptions"
                );
            }
#endif // DEBUG
            _implementationRegistrationOptions.~unique_ptr<ImplementationRegistrationOptions>();
            _type =
                ServerCapabilities_implementationProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_implementationProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_implementationProvider::type() const
    -> const ServerCapabilities_implementationProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_implementationProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_implementationProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_implementationProvider::boolean()"
                 " of type "
                 "ServerCapabilities_implementationProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_implementationProviderType::" +
                 ServerCapabilities_implementationProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_implementationProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::implementationOptions() const
    -> const ImplementationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_implementationProviderType::ImplementationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_implementationProvider::implementationOptions()"
                 " of type "
                 "ServerCapabilities_implementationProviderType::ImplementationOptions"
                 " while active type is "
                 "ServerCapabilities_implementationProviderType::" +
                 ServerCapabilities_implementationProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_implementationOptions;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        const std::unique_ptr<ImplementationOptions> &implementationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!implementationOptions) {
            throw std::logic_error(
                "null passed as the value of implementationOptions"
            );
        }
#endif // DEBUG
        new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
            std::make_unique<ImplementationOptions>(*implementationOptions)
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationOptions;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        std::unique_ptr<ImplementationOptions> &&implementationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!implementationOptions) {
            throw std::logic_error(
                "null passed as the value of implementationOptions"
            );
        }
#endif // DEBUG
        new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
            std::move(implementationOptions)
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationOptions;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        const ImplementationOptions &implementationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
        new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
            std::make_unique<ImplementationOptions>(implementationOptions)
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationOptions;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        ImplementationOptions &&implementationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
        new (&_implementationOptions) std::unique_ptr<ImplementationOptions> {
            std::make_unique<ImplementationOptions>(std::move(implementationOptions))
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationOptions;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::implementationRegistrationOptions() const
    -> const ImplementationRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_implementationProvider::implementationRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_implementationProviderType::" +
                 ServerCapabilities_implementationProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_implementationRegistrationOptions;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        const std::unique_ptr<ImplementationRegistrationOptions> &implementationRegistrationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!implementationRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of implementationRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
            std::make_unique<ImplementationRegistrationOptions>(*implementationRegistrationOptions)
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        std::unique_ptr<ImplementationRegistrationOptions> &&implementationRegistrationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!implementationRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of implementationRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
            std::move(implementationRegistrationOptions)
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        const ImplementationRegistrationOptions &implementationRegistrationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
        new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
            std::make_unique<ImplementationRegistrationOptions>(implementationRegistrationOptions)
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_implementationProvider::operator=(
        ImplementationRegistrationOptions &&implementationRegistrationOptions
    ) -> ServerCapabilities_implementationProvider &
    {
        if (_type !=
                ServerCapabilities_implementationProviderType::Uninitialized) {
            reset();
        }
        new (&_implementationRegistrationOptions) std::unique_ptr<ImplementationRegistrationOptions> {
            std::make_unique<ImplementationRegistrationOptions>(std::move(implementationRegistrationOptions))
        };
        _type =
            ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_colorProviderType, std::string>
    ServerCapabilities_colorProviderTypeNames = {
        {ServerCapabilities_colorProviderType::Uninitialized, "Uninitialized"},
        {ServerCapabilities_colorProviderType::Boolean, "Boolean"},
        {ServerCapabilities_colorProviderType::DocumentColorOptions,
         "DocumentColorOptions"},
        {ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions,
         "DocumentColorRegistrationOptions"},
    };

    ServerCapabilities_colorProvider::ServerCapabilities_colorProvider()
    {
        // empty
    }

    ServerCapabilities_colorProvider::~ServerCapabilities_colorProvider()
    {
        reset();
    }

    ServerCapabilities_colorProvider::ServerCapabilities_colorProvider(
        ServerCapabilities_colorProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_colorProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_colorProviderType::DocumentColorOptions: {
            new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
                std::move(other._documentColorOptions)
            };
            break;
        }
        case ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions: {
            new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
                std::move(other._documentColorRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_colorProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_colorProviderType::Uninitialized;
    }

    ServerCapabilities_colorProvider::ServerCapabilities_colorProvider(
        const ServerCapabilities_colorProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_colorProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_colorProviderType::DocumentColorOptions: {
            new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
                std::make_unique<DocumentColorOptions>(*other._documentColorOptions)
            };
            break;
        }
        case ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions: {
            new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
                std::make_unique<DocumentColorRegistrationOptions>(*other._documentColorRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_colorProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_colorProvider::operator=(
        ServerCapabilities_colorProvider &&other
    ) -> ServerCapabilities_colorProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_colorProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_colorProviderType::DocumentColorOptions: {
                new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
                    std::move(other._documentColorOptions)
                };
                break;
            }
            case ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions: {
                new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
                    std::move(other._documentColorRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_colorProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type = ServerCapabilities_colorProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_colorProvider::operator=(
        const ServerCapabilities_colorProvider &other
    ) -> ServerCapabilities_colorProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_colorProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_colorProviderType::DocumentColorOptions: {
                new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
                    std::make_unique<DocumentColorOptions>(*other._documentColorOptions)
                };
                break;
            }
            case ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions: {
                new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
                    std::make_unique<DocumentColorRegistrationOptions>(*other._documentColorRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_colorProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_colorProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_colorProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_colorProviderType::DocumentColorOptions: {
#ifdef DEBUG
            if (!_documentColorOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentColorOptions"
                );
            }
#endif // DEBUG
            _documentColorOptions.~unique_ptr<DocumentColorOptions>();
            _type = ServerCapabilities_colorProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions: {
#ifdef DEBUG
            if (!_documentColorRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _documentColorRegistrationOptions"
                );
            }
#endif // DEBUG
            _documentColorRegistrationOptions.~unique_ptr<DocumentColorRegistrationOptions>();
            _type = ServerCapabilities_colorProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_colorProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_colorProvider::type() const
    -> const ServerCapabilities_colorProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_colorProvider::boolean() const -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_colorProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_colorProvider::boolean()"
                 " of type "
                 "ServerCapabilities_colorProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_colorProviderType::" +
                 ServerCapabilities_colorProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_colorProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_colorProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_colorProvider::documentColorOptions() const
    -> const DocumentColorOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_colorProviderType::DocumentColorOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_colorProvider::documentColorOptions()"
                 " of type "
                 "ServerCapabilities_colorProviderType::DocumentColorOptions"
                 " while active type is "
                 "ServerCapabilities_colorProviderType::" +
                 ServerCapabilities_colorProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentColorOptions;
    }

    auto ServerCapabilities_colorProvider::operator=(
        const std::unique_ptr<DocumentColorOptions> &documentColorOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentColorOptions) {
            throw std::logic_error(
                "null passed as the value of documentColorOptions"
            );
        }
#endif // DEBUG
        new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
            std::make_unique<DocumentColorOptions>(*documentColorOptions)
        };
        _type = ServerCapabilities_colorProviderType::DocumentColorOptions;
        return *this;
    }

    auto ServerCapabilities_colorProvider::operator=(
        std::unique_ptr<DocumentColorOptions> &&documentColorOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentColorOptions) {
            throw std::logic_error(
                "null passed as the value of documentColorOptions"
            );
        }
#endif // DEBUG
        new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
            std::move(documentColorOptions)
        };
        _type = ServerCapabilities_colorProviderType::DocumentColorOptions;
        return *this;
    }

    auto ServerCapabilities_colorProvider::operator=(
        const DocumentColorOptions &documentColorOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
        new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
            std::make_unique<DocumentColorOptions>(documentColorOptions)
        };
        _type = ServerCapabilities_colorProviderType::DocumentColorOptions;
        return *this;
    }

    auto ServerCapabilities_colorProvider::operator=(
        DocumentColorOptions &&documentColorOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
        new (&_documentColorOptions) std::unique_ptr<DocumentColorOptions> {
            std::make_unique<DocumentColorOptions>(std::move(documentColorOptions))
        };
        _type = ServerCapabilities_colorProviderType::DocumentColorOptions;
        return *this;
    }

    auto ServerCapabilities_colorProvider::documentColorRegistrationOptions() const
    -> const DocumentColorRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_colorProvider::documentColorRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_colorProviderType::" +
                 ServerCapabilities_colorProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_documentColorRegistrationOptions;
    }

    auto ServerCapabilities_colorProvider::operator=(
        const std::unique_ptr<DocumentColorRegistrationOptions> &documentColorRegistrationOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentColorRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of documentColorRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
            std::make_unique<DocumentColorRegistrationOptions>(*documentColorRegistrationOptions)
        };
        _type =
            ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_colorProvider::operator=(
        std::unique_ptr<DocumentColorRegistrationOptions> &&documentColorRegistrationOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!documentColorRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of documentColorRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
            std::move(documentColorRegistrationOptions)
        };
        _type =
            ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_colorProvider::operator=(
        const DocumentColorRegistrationOptions &documentColorRegistrationOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
        new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
            std::make_unique<DocumentColorRegistrationOptions>(documentColorRegistrationOptions)
        };
        _type =
            ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_colorProvider::operator=(
        DocumentColorRegistrationOptions &&documentColorRegistrationOptions
    ) -> ServerCapabilities_colorProvider &
    {
        if (_type != ServerCapabilities_colorProviderType::Uninitialized) {
            reset();
        }
        new (&_documentColorRegistrationOptions) std::unique_ptr<DocumentColorRegistrationOptions> {
            std::make_unique<DocumentColorRegistrationOptions>(std::move(documentColorRegistrationOptions))
        };
        _type =
            ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_foldingRangeProviderType, std::string>
    ServerCapabilities_foldingRangeProviderTypeNames = {
        {ServerCapabilities_foldingRangeProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_foldingRangeProviderType::Boolean, "Boolean"},
        {ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions,
         "FoldingRangeOptions"},
        {ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions,
         "FoldingRangeRegistrationOptions"},
    };

    ServerCapabilities_foldingRangeProvider::ServerCapabilities_foldingRangeProvider()
    {
        // empty
    }

    ServerCapabilities_foldingRangeProvider::~ServerCapabilities_foldingRangeProvider()
    {
        reset();
    }

    ServerCapabilities_foldingRangeProvider::ServerCapabilities_foldingRangeProvider(
        ServerCapabilities_foldingRangeProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_foldingRangeProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions: {
            new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
                std::move(other._foldingRangeOptions)
            };
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions: {
            new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
                std::move(other._foldingRangeRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_foldingRangeProviderType::Uninitialized;
    }

    ServerCapabilities_foldingRangeProvider::ServerCapabilities_foldingRangeProvider(
        const ServerCapabilities_foldingRangeProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_foldingRangeProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions: {
            new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
                std::make_unique<FoldingRangeOptions>(*other._foldingRangeOptions)
            };
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions: {
            new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
                std::make_unique<FoldingRangeRegistrationOptions>(*other._foldingRangeRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        ServerCapabilities_foldingRangeProvider &&other
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_foldingRangeProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions: {
                new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
                    std::move(other._foldingRangeOptions)
                };
                break;
            }
            case ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions: {
                new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
                    std::move(other._foldingRangeRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_foldingRangeProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_foldingRangeProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        const ServerCapabilities_foldingRangeProvider &other
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_foldingRangeProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions: {
                new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
                    std::make_unique<FoldingRangeOptions>(*other._foldingRangeOptions)
                };
                break;
            }
            case ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions: {
                new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
                    std::make_unique<FoldingRangeRegistrationOptions>(*other._foldingRangeRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_foldingRangeProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_foldingRangeProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions: {
#ifdef DEBUG
            if (!_foldingRangeOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _foldingRangeOptions"
                );
            }
#endif // DEBUG
            _foldingRangeOptions.~unique_ptr<FoldingRangeOptions>();
            _type = ServerCapabilities_foldingRangeProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions: {
#ifdef DEBUG
            if (!_foldingRangeRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _foldingRangeRegistrationOptions"
                );
            }
#endif // DEBUG
            _foldingRangeRegistrationOptions.~unique_ptr<FoldingRangeRegistrationOptions>();
            _type = ServerCapabilities_foldingRangeProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_foldingRangeProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_foldingRangeProvider::type() const
    -> const ServerCapabilities_foldingRangeProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_foldingRangeProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_foldingRangeProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_foldingRangeProvider::boolean()"
                 " of type "
                 "ServerCapabilities_foldingRangeProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_foldingRangeProviderType::" +
                 ServerCapabilities_foldingRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_foldingRangeProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::foldingRangeOptions() const
    -> const FoldingRangeOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_foldingRangeProvider::foldingRangeOptions()"
                 " of type "
                 "ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions"
                 " while active type is "
                 "ServerCapabilities_foldingRangeProviderType::" +
                 ServerCapabilities_foldingRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_foldingRangeOptions;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        const std::unique_ptr<FoldingRangeOptions> &foldingRangeOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!foldingRangeOptions) {
            throw std::logic_error(
                "null passed as the value of foldingRangeOptions"
            );
        }
#endif // DEBUG
        new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
            std::make_unique<FoldingRangeOptions>(*foldingRangeOptions)
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        std::unique_ptr<FoldingRangeOptions> &&foldingRangeOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!foldingRangeOptions) {
            throw std::logic_error(
                "null passed as the value of foldingRangeOptions"
            );
        }
#endif // DEBUG
        new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
            std::move(foldingRangeOptions)
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        const FoldingRangeOptions &foldingRangeOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
            std::make_unique<FoldingRangeOptions>(foldingRangeOptions)
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        FoldingRangeOptions &&foldingRangeOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_foldingRangeOptions) std::unique_ptr<FoldingRangeOptions> {
            std::make_unique<FoldingRangeOptions>(std::move(foldingRangeOptions))
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::foldingRangeRegistrationOptions() const
    -> const FoldingRangeRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_foldingRangeProvider::foldingRangeRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_foldingRangeProviderType::" +
                 ServerCapabilities_foldingRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_foldingRangeRegistrationOptions;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        const std::unique_ptr<FoldingRangeRegistrationOptions> &foldingRangeRegistrationOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!foldingRangeRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of foldingRangeRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
            std::make_unique<FoldingRangeRegistrationOptions>(*foldingRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        std::unique_ptr<FoldingRangeRegistrationOptions> &&foldingRangeRegistrationOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!foldingRangeRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of foldingRangeRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
            std::move(foldingRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        const FoldingRangeRegistrationOptions &foldingRangeRegistrationOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
            std::make_unique<FoldingRangeRegistrationOptions>(foldingRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_foldingRangeProvider::operator=(
        FoldingRangeRegistrationOptions &&foldingRangeRegistrationOptions
    ) -> ServerCapabilities_foldingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_foldingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_foldingRangeRegistrationOptions) std::unique_ptr<FoldingRangeRegistrationOptions> {
            std::make_unique<FoldingRangeRegistrationOptions>(std::move(foldingRangeRegistrationOptions))
        };
        _type =
            ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_selectionRangeProviderType, std::string>
    ServerCapabilities_selectionRangeProviderTypeNames = {
        {ServerCapabilities_selectionRangeProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_selectionRangeProviderType::Boolean, "Boolean"},
        {ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions,
         "SelectionRangeOptions"},
        {ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions,
         "SelectionRangeRegistrationOptions"},
    };

    ServerCapabilities_selectionRangeProvider::ServerCapabilities_selectionRangeProvider()
    {
        // empty
    }

    ServerCapabilities_selectionRangeProvider::~ServerCapabilities_selectionRangeProvider()
    {
        reset();
    }

    ServerCapabilities_selectionRangeProvider::ServerCapabilities_selectionRangeProvider(
        ServerCapabilities_selectionRangeProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_selectionRangeProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions: {
            new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
                std::move(other._selectionRangeOptions)
            };
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions: {
            new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
                std::move(other._selectionRangeRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_selectionRangeProviderType::Uninitialized;
    }

    ServerCapabilities_selectionRangeProvider::ServerCapabilities_selectionRangeProvider(
        const ServerCapabilities_selectionRangeProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_selectionRangeProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions: {
            new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
                std::make_unique<SelectionRangeOptions>(*other._selectionRangeOptions)
            };
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions: {
            new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
                std::make_unique<SelectionRangeRegistrationOptions>(*other._selectionRangeRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        ServerCapabilities_selectionRangeProvider &&other
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_selectionRangeProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions: {
                new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
                    std::move(other._selectionRangeOptions)
                };
                break;
            }
            case ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions: {
                new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
                    std::move(other._selectionRangeRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_selectionRangeProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_selectionRangeProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        const ServerCapabilities_selectionRangeProvider &other
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_selectionRangeProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions: {
                new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
                    std::make_unique<SelectionRangeOptions>(*other._selectionRangeOptions)
                };
                break;
            }
            case ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions: {
                new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
                    std::make_unique<SelectionRangeRegistrationOptions>(*other._selectionRangeRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_selectionRangeProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_selectionRangeProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions: {
#ifdef DEBUG
            if (!_selectionRangeOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _selectionRangeOptions"
                );
            }
#endif // DEBUG
            _selectionRangeOptions.~unique_ptr<SelectionRangeOptions>();
            _type =
                ServerCapabilities_selectionRangeProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions: {
#ifdef DEBUG
            if (!_selectionRangeRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _selectionRangeRegistrationOptions"
                );
            }
#endif // DEBUG
            _selectionRangeRegistrationOptions.~unique_ptr<SelectionRangeRegistrationOptions>();
            _type =
                ServerCapabilities_selectionRangeProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_selectionRangeProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_selectionRangeProvider::type() const
    -> const ServerCapabilities_selectionRangeProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_selectionRangeProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_selectionRangeProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_selectionRangeProvider::boolean()"
                 " of type "
                 "ServerCapabilities_selectionRangeProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_selectionRangeProviderType::" +
                 ServerCapabilities_selectionRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_selectionRangeProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::selectionRangeOptions() const
    -> const SelectionRangeOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_selectionRangeProvider::selectionRangeOptions()"
                 " of type "
                 "ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions"
                 " while active type is "
                 "ServerCapabilities_selectionRangeProviderType::" +
                 ServerCapabilities_selectionRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_selectionRangeOptions;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        const std::unique_ptr<SelectionRangeOptions> &selectionRangeOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!selectionRangeOptions) {
            throw std::logic_error(
                "null passed as the value of selectionRangeOptions"
            );
        }
#endif // DEBUG
        new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
            std::make_unique<SelectionRangeOptions>(*selectionRangeOptions)
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        std::unique_ptr<SelectionRangeOptions> &&selectionRangeOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!selectionRangeOptions) {
            throw std::logic_error(
                "null passed as the value of selectionRangeOptions"
            );
        }
#endif // DEBUG
        new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
            std::move(selectionRangeOptions)
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        const SelectionRangeOptions &selectionRangeOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
            std::make_unique<SelectionRangeOptions>(selectionRangeOptions)
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        SelectionRangeOptions &&selectionRangeOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_selectionRangeOptions) std::unique_ptr<SelectionRangeOptions> {
            std::make_unique<SelectionRangeOptions>(std::move(selectionRangeOptions))
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::selectionRangeRegistrationOptions() const
    -> const SelectionRangeRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_selectionRangeProvider::selectionRangeRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_selectionRangeProviderType::" +
                 ServerCapabilities_selectionRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_selectionRangeRegistrationOptions;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        const std::unique_ptr<SelectionRangeRegistrationOptions> &selectionRangeRegistrationOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!selectionRangeRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of selectionRangeRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
            std::make_unique<SelectionRangeRegistrationOptions>(*selectionRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        std::unique_ptr<SelectionRangeRegistrationOptions> &&selectionRangeRegistrationOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!selectionRangeRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of selectionRangeRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
            std::move(selectionRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        const SelectionRangeRegistrationOptions &selectionRangeRegistrationOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
            std::make_unique<SelectionRangeRegistrationOptions>(selectionRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_selectionRangeProvider::operator=(
        SelectionRangeRegistrationOptions &&selectionRangeRegistrationOptions
    ) -> ServerCapabilities_selectionRangeProvider &
    {
        if (_type !=
                ServerCapabilities_selectionRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_selectionRangeRegistrationOptions) std::unique_ptr<SelectionRangeRegistrationOptions> {
            std::make_unique<SelectionRangeRegistrationOptions>(std::move(selectionRangeRegistrationOptions))
        };
        _type =
            ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_callHierarchyProviderType, std::string>
    ServerCapabilities_callHierarchyProviderTypeNames = {
        {ServerCapabilities_callHierarchyProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_callHierarchyProviderType::Boolean, "Boolean"},
        {ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions,
         "CallHierarchyOptions"},
        {ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions,
         "CallHierarchyRegistrationOptions"},
    };

    ServerCapabilities_callHierarchyProvider::ServerCapabilities_callHierarchyProvider()
    {
        // empty
    }

    ServerCapabilities_callHierarchyProvider::~ServerCapabilities_callHierarchyProvider()
    {
        reset();
    }

    ServerCapabilities_callHierarchyProvider::ServerCapabilities_callHierarchyProvider(
        ServerCapabilities_callHierarchyProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_callHierarchyProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions: {
            new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
                std::move(other._callHierarchyOptions)
            };
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions: {
            new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
                std::move(other._callHierarchyRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_callHierarchyProviderType::Uninitialized;
    }

    ServerCapabilities_callHierarchyProvider::ServerCapabilities_callHierarchyProvider(
        const ServerCapabilities_callHierarchyProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_callHierarchyProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions: {
            new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
                std::make_unique<CallHierarchyOptions>(*other._callHierarchyOptions)
            };
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions: {
            new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
                std::make_unique<CallHierarchyRegistrationOptions>(*other._callHierarchyRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        ServerCapabilities_callHierarchyProvider &&other
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_callHierarchyProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions: {
                new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
                    std::move(other._callHierarchyOptions)
                };
                break;
            }
            case ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions: {
                new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
                    std::move(other._callHierarchyRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_callHierarchyProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_callHierarchyProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        const ServerCapabilities_callHierarchyProvider &other
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_callHierarchyProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions: {
                new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
                    std::make_unique<CallHierarchyOptions>(*other._callHierarchyOptions)
                };
                break;
            }
            case ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions: {
                new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
                    std::make_unique<CallHierarchyRegistrationOptions>(*other._callHierarchyRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_callHierarchyProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_callHierarchyProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions: {
#ifdef DEBUG
            if (!_callHierarchyOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _callHierarchyOptions"
                );
            }
#endif // DEBUG
            _callHierarchyOptions.~unique_ptr<CallHierarchyOptions>();
            _type =
                ServerCapabilities_callHierarchyProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions: {
#ifdef DEBUG
            if (!_callHierarchyRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _callHierarchyRegistrationOptions"
                );
            }
#endif // DEBUG
            _callHierarchyRegistrationOptions.~unique_ptr<CallHierarchyRegistrationOptions>();
            _type =
                ServerCapabilities_callHierarchyProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_callHierarchyProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_callHierarchyProvider::type() const
    -> const ServerCapabilities_callHierarchyProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_callHierarchyProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_callHierarchyProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_callHierarchyProvider::boolean()"
                 " of type "
                 "ServerCapabilities_callHierarchyProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_callHierarchyProviderType::" +
                 ServerCapabilities_callHierarchyProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_callHierarchyProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::callHierarchyOptions() const
    -> const CallHierarchyOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_callHierarchyProvider::callHierarchyOptions()"
                 " of type "
                 "ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions"
                 " while active type is "
                 "ServerCapabilities_callHierarchyProviderType::" +
                 ServerCapabilities_callHierarchyProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_callHierarchyOptions;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        const std::unique_ptr<CallHierarchyOptions> &callHierarchyOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!callHierarchyOptions) {
            throw std::logic_error(
                "null passed as the value of callHierarchyOptions"
            );
        }
#endif // DEBUG
        new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
            std::make_unique<CallHierarchyOptions>(*callHierarchyOptions)
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        std::unique_ptr<CallHierarchyOptions> &&callHierarchyOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!callHierarchyOptions) {
            throw std::logic_error(
                "null passed as the value of callHierarchyOptions"
            );
        }
#endif // DEBUG
        new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
            std::move(callHierarchyOptions)
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        const CallHierarchyOptions &callHierarchyOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
            std::make_unique<CallHierarchyOptions>(callHierarchyOptions)
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        CallHierarchyOptions &&callHierarchyOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_callHierarchyOptions) std::unique_ptr<CallHierarchyOptions> {
            std::make_unique<CallHierarchyOptions>(std::move(callHierarchyOptions))
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::callHierarchyRegistrationOptions() const
    -> const CallHierarchyRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_callHierarchyProvider::callHierarchyRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_callHierarchyProviderType::" +
                 ServerCapabilities_callHierarchyProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_callHierarchyRegistrationOptions;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        const std::unique_ptr<CallHierarchyRegistrationOptions> &callHierarchyRegistrationOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!callHierarchyRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of callHierarchyRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
            std::make_unique<CallHierarchyRegistrationOptions>(*callHierarchyRegistrationOptions)
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        std::unique_ptr<CallHierarchyRegistrationOptions> &&callHierarchyRegistrationOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!callHierarchyRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of callHierarchyRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
            std::move(callHierarchyRegistrationOptions)
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        const CallHierarchyRegistrationOptions &callHierarchyRegistrationOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
            std::make_unique<CallHierarchyRegistrationOptions>(callHierarchyRegistrationOptions)
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_callHierarchyProvider::operator=(
        CallHierarchyRegistrationOptions &&callHierarchyRegistrationOptions
    ) -> ServerCapabilities_callHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_callHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_callHierarchyRegistrationOptions) std::unique_ptr<CallHierarchyRegistrationOptions> {
            std::make_unique<CallHierarchyRegistrationOptions>(std::move(callHierarchyRegistrationOptions))
        };
        _type =
            ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions;
        return *this;
    }

    const std::map<
        ServerCapabilities_linkedEditingRangeProviderType,
        std::string
    > ServerCapabilities_linkedEditingRangeProviderTypeNames = {
        {ServerCapabilities_linkedEditingRangeProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_linkedEditingRangeProviderType::Boolean,
         "Boolean"},
        {ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions,
         "LinkedEditingRangeOptions"},
        {ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions,
         "LinkedEditingRangeRegistrationOptions"},
    };

    ServerCapabilities_linkedEditingRangeProvider::ServerCapabilities_linkedEditingRangeProvider()
    {
        // empty
    }

    ServerCapabilities_linkedEditingRangeProvider::~ServerCapabilities_linkedEditingRangeProvider()
    {
        reset();
    }

    ServerCapabilities_linkedEditingRangeProvider::ServerCapabilities_linkedEditingRangeProvider(
        ServerCapabilities_linkedEditingRangeProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_linkedEditingRangeProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions: {
            new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
                std::move(other._linkedEditingRangeOptions)
            };
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions: {
            new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
                std::move(other._linkedEditingRangeRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_linkedEditingRangeProviderType::Uninitialized;
    }

    ServerCapabilities_linkedEditingRangeProvider::ServerCapabilities_linkedEditingRangeProvider(
        const ServerCapabilities_linkedEditingRangeProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_linkedEditingRangeProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions: {
            new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
                std::make_unique<LinkedEditingRangeOptions>(*other._linkedEditingRangeOptions)
            };
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions: {
            new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
                std::make_unique<LinkedEditingRangeRegistrationOptions>(*other._linkedEditingRangeRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        ServerCapabilities_linkedEditingRangeProvider &&other
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_linkedEditingRangeProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions: {
                new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
                    std::move(other._linkedEditingRangeOptions)
                };
                break;
            }
            case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions: {
                new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
                    std::move(other._linkedEditingRangeRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_linkedEditingRangeProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        const ServerCapabilities_linkedEditingRangeProvider &other
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_linkedEditingRangeProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions: {
                new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
                    std::make_unique<LinkedEditingRangeOptions>(*other._linkedEditingRangeOptions)
                };
                break;
            }
            case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions: {
                new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
                    std::make_unique<LinkedEditingRangeRegistrationOptions>(*other._linkedEditingRangeRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_linkedEditingRangeProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_linkedEditingRangeProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions: {
#ifdef DEBUG
            if (!_linkedEditingRangeOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _linkedEditingRangeOptions"
                );
            }
#endif // DEBUG
            _linkedEditingRangeOptions.~unique_ptr<LinkedEditingRangeOptions>();
            _type =
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions: {
#ifdef DEBUG
            if (!_linkedEditingRangeRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _linkedEditingRangeRegistrationOptions"
                );
            }
#endif // DEBUG
            _linkedEditingRangeRegistrationOptions.~unique_ptr<LinkedEditingRangeRegistrationOptions>();
            _type =
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_linkedEditingRangeProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_linkedEditingRangeProvider::type() const
    -> const ServerCapabilities_linkedEditingRangeProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_linkedEditingRangeProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_linkedEditingRangeProvider::boolean()"
                 " of type "
                 "ServerCapabilities_linkedEditingRangeProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_linkedEditingRangeProviderType::" +
                 ServerCapabilities_linkedEditingRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_linkedEditingRangeProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::linkedEditingRangeOptions() const
    -> const LinkedEditingRangeOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_linkedEditingRangeProvider::linkedEditingRangeOptions()"
                 " of type "
                 "ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions"
                 " while active type is "
                 "ServerCapabilities_linkedEditingRangeProviderType::" +
                 ServerCapabilities_linkedEditingRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_linkedEditingRangeOptions;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        const std::unique_ptr<LinkedEditingRangeOptions> &linkedEditingRangeOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!linkedEditingRangeOptions) {
            throw std::logic_error(
                "null passed as the value of linkedEditingRangeOptions"
            );
        }
#endif // DEBUG
        new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
            std::make_unique<LinkedEditingRangeOptions>(*linkedEditingRangeOptions)
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        std::unique_ptr<LinkedEditingRangeOptions> &&linkedEditingRangeOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!linkedEditingRangeOptions) {
            throw std::logic_error(
                "null passed as the value of linkedEditingRangeOptions"
            );
        }
#endif // DEBUG
        new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
            std::move(linkedEditingRangeOptions)
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        const LinkedEditingRangeOptions &linkedEditingRangeOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
            std::make_unique<LinkedEditingRangeOptions>(linkedEditingRangeOptions)
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        LinkedEditingRangeOptions &&linkedEditingRangeOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_linkedEditingRangeOptions) std::unique_ptr<LinkedEditingRangeOptions> {
            std::make_unique<LinkedEditingRangeOptions>(std::move(linkedEditingRangeOptions))
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::linkedEditingRangeRegistrationOptions() const
    -> const LinkedEditingRangeRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_linkedEditingRangeProvider::linkedEditingRangeRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_linkedEditingRangeProviderType::" +
                 ServerCapabilities_linkedEditingRangeProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_linkedEditingRangeRegistrationOptions;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        const std::unique_ptr<LinkedEditingRangeRegistrationOptions> &linkedEditingRangeRegistrationOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!linkedEditingRangeRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of linkedEditingRangeRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
            std::make_unique<LinkedEditingRangeRegistrationOptions>(*linkedEditingRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        std::unique_ptr<LinkedEditingRangeRegistrationOptions> &&linkedEditingRangeRegistrationOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!linkedEditingRangeRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of linkedEditingRangeRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
            std::move(linkedEditingRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        const LinkedEditingRangeRegistrationOptions &linkedEditingRangeRegistrationOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
            std::make_unique<LinkedEditingRangeRegistrationOptions>(linkedEditingRangeRegistrationOptions)
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_linkedEditingRangeProvider::operator=(
        LinkedEditingRangeRegistrationOptions &&linkedEditingRangeRegistrationOptions
    ) -> ServerCapabilities_linkedEditingRangeProvider &
    {
        if (_type !=
                ServerCapabilities_linkedEditingRangeProviderType::Uninitialized) {
            reset();
        }
        new (&_linkedEditingRangeRegistrationOptions) std::unique_ptr<LinkedEditingRangeRegistrationOptions> {
            std::make_unique<LinkedEditingRangeRegistrationOptions>(std::move(linkedEditingRangeRegistrationOptions))
        };
        _type =
            ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_monikerProviderType, std::string>
    ServerCapabilities_monikerProviderTypeNames = {
        {ServerCapabilities_monikerProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_monikerProviderType::Boolean, "Boolean"},
        {ServerCapabilities_monikerProviderType::MonikerOptions,
         "MonikerOptions"},
        {ServerCapabilities_monikerProviderType::MonikerRegistrationOptions,
         "MonikerRegistrationOptions"},
    };

    ServerCapabilities_monikerProvider::ServerCapabilities_monikerProvider()
    {
        // empty
    }

    ServerCapabilities_monikerProvider::~ServerCapabilities_monikerProvider()
    {
        reset();
    }

    ServerCapabilities_monikerProvider::ServerCapabilities_monikerProvider(
        ServerCapabilities_monikerProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_monikerProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_monikerProviderType::MonikerOptions: {
            new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
                std::move(other._monikerOptions)
            };
            break;
        }
        case ServerCapabilities_monikerProviderType::MonikerRegistrationOptions: {
            new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
                std::move(other._monikerRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_monikerProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type = ServerCapabilities_monikerProviderType::Uninitialized;
    }

    ServerCapabilities_monikerProvider::ServerCapabilities_monikerProvider(
        const ServerCapabilities_monikerProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_monikerProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_monikerProviderType::MonikerOptions: {
            new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
                std::make_unique<MonikerOptions>(*other._monikerOptions)
            };
            break;
        }
        case ServerCapabilities_monikerProviderType::MonikerRegistrationOptions: {
            new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
                std::make_unique<MonikerRegistrationOptions>(*other._monikerRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_monikerProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_monikerProvider::operator=(
        ServerCapabilities_monikerProvider &&other
    ) -> ServerCapabilities_monikerProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_monikerProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_monikerProviderType::MonikerOptions: {
                new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
                    std::move(other._monikerOptions)
                };
                break;
            }
            case ServerCapabilities_monikerProviderType::MonikerRegistrationOptions: {
                new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
                    std::move(other._monikerRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_monikerProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_monikerProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        const ServerCapabilities_monikerProvider &other
    ) -> ServerCapabilities_monikerProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_monikerProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_monikerProviderType::MonikerOptions: {
                new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
                    std::make_unique<MonikerOptions>(*other._monikerOptions)
                };
                break;
            }
            case ServerCapabilities_monikerProviderType::MonikerRegistrationOptions: {
                new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
                    std::make_unique<MonikerRegistrationOptions>(*other._monikerRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_monikerProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_monikerProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_monikerProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_monikerProviderType::MonikerOptions: {
#ifdef DEBUG
            if (!_monikerOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _monikerOptions"
                );
            }
#endif // DEBUG
            _monikerOptions.~unique_ptr<MonikerOptions>();
            _type = ServerCapabilities_monikerProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_monikerProviderType::MonikerRegistrationOptions: {
#ifdef DEBUG
            if (!_monikerRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _monikerRegistrationOptions"
                );
            }
#endif // DEBUG
            _monikerRegistrationOptions.~unique_ptr<MonikerRegistrationOptions>();
            _type = ServerCapabilities_monikerProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_monikerProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_monikerProvider::type() const
    -> const ServerCapabilities_monikerProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_monikerProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_monikerProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_monikerProvider::boolean()"
                 " of type "
                 "ServerCapabilities_monikerProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_monikerProviderType::" +
                 ServerCapabilities_monikerProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_monikerProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::monikerOptions() const
    -> const MonikerOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_monikerProviderType::MonikerOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_monikerProvider::monikerOptions()"
                 " of type "
                 "ServerCapabilities_monikerProviderType::MonikerOptions"
                 " while active type is "
                 "ServerCapabilities_monikerProviderType::" +
                 ServerCapabilities_monikerProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_monikerOptions;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        const std::unique_ptr<MonikerOptions> &monikerOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!monikerOptions) {
            throw std::logic_error(
                "null passed as the value of monikerOptions"
            );
        }
#endif // DEBUG
        new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
            std::make_unique<MonikerOptions>(*monikerOptions)
        };
        _type = ServerCapabilities_monikerProviderType::MonikerOptions;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        std::unique_ptr<MonikerOptions> &&monikerOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!monikerOptions) {
            throw std::logic_error(
                "null passed as the value of monikerOptions"
            );
        }
#endif // DEBUG
        new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
            std::move(monikerOptions)
        };
        _type = ServerCapabilities_monikerProviderType::MonikerOptions;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        const MonikerOptions &monikerOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
        new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
            std::make_unique<MonikerOptions>(monikerOptions)
        };
        _type = ServerCapabilities_monikerProviderType::MonikerOptions;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        MonikerOptions &&monikerOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
        new (&_monikerOptions) std::unique_ptr<MonikerOptions> {
            std::make_unique<MonikerOptions>(std::move(monikerOptions))
        };
        _type = ServerCapabilities_monikerProviderType::MonikerOptions;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::monikerRegistrationOptions() const
    -> const MonikerRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_monikerProviderType::MonikerRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_monikerProvider::monikerRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_monikerProviderType::MonikerRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_monikerProviderType::" +
                 ServerCapabilities_monikerProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_monikerRegistrationOptions;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        const std::unique_ptr<MonikerRegistrationOptions> &monikerRegistrationOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!monikerRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of monikerRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
            std::make_unique<MonikerRegistrationOptions>(*monikerRegistrationOptions)
        };
        _type =
            ServerCapabilities_monikerProviderType::MonikerRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        std::unique_ptr<MonikerRegistrationOptions> &&monikerRegistrationOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!monikerRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of monikerRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
            std::move(monikerRegistrationOptions)
        };
        _type =
            ServerCapabilities_monikerProviderType::MonikerRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        const MonikerRegistrationOptions &monikerRegistrationOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
        new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
            std::make_unique<MonikerRegistrationOptions>(monikerRegistrationOptions)
        };
        _type =
            ServerCapabilities_monikerProviderType::MonikerRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_monikerProvider::operator=(
        MonikerRegistrationOptions &&monikerRegistrationOptions
    ) -> ServerCapabilities_monikerProvider &
    {
        if (_type != ServerCapabilities_monikerProviderType::Uninitialized) {
            reset();
        }
        new (&_monikerRegistrationOptions) std::unique_ptr<MonikerRegistrationOptions> {
            std::make_unique<MonikerRegistrationOptions>(std::move(monikerRegistrationOptions))
        };
        _type =
            ServerCapabilities_monikerProviderType::MonikerRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_typeHierarchyProviderType, std::string>
    ServerCapabilities_typeHierarchyProviderTypeNames = {
        {ServerCapabilities_typeHierarchyProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_typeHierarchyProviderType::Boolean, "Boolean"},
        {ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions,
         "TypeHierarchyOptions"},
        {ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions,
         "TypeHierarchyRegistrationOptions"},
    };

    ServerCapabilities_typeHierarchyProvider::ServerCapabilities_typeHierarchyProvider()
    {
        // empty
    }

    ServerCapabilities_typeHierarchyProvider::~ServerCapabilities_typeHierarchyProvider()
    {
        reset();
    }

    ServerCapabilities_typeHierarchyProvider::ServerCapabilities_typeHierarchyProvider(
        ServerCapabilities_typeHierarchyProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_typeHierarchyProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions: {
            new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
                std::move(other._typeHierarchyOptions)
            };
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions: {
            new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
                std::move(other._typeHierarchyRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
        other._type =
            ServerCapabilities_typeHierarchyProviderType::Uninitialized;
    }

    ServerCapabilities_typeHierarchyProvider::ServerCapabilities_typeHierarchyProvider(
        const ServerCapabilities_typeHierarchyProvider &other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_typeHierarchyProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions: {
            new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
                std::make_unique<TypeHierarchyOptions>(*other._typeHierarchyOptions)
            };
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions: {
            new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
                std::make_unique<TypeHierarchyRegistrationOptions>(*other._typeHierarchyRegistrationOptions)
            };
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::Uninitialized: {
            // other has not been initialized, there is nothing to do ...
            break;
        }
        }
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        ServerCapabilities_typeHierarchyProvider &&other
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_typeHierarchyProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions: {
                new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
                    std::move(other._typeHierarchyOptions)
                };
                break;
            }
            case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions: {
                new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
                    std::move(other._typeHierarchyRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_typeHierarchyProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
            other._type =
                ServerCapabilities_typeHierarchyProviderType::Uninitialized;
        }
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        const ServerCapabilities_typeHierarchyProvider &other
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (this != &other) {
            _type = other._type;
            switch (other._type) {
            case ServerCapabilities_typeHierarchyProviderType::Boolean: {
                _boolean = other._boolean;
                break;
            }
            case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions: {
                new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
                    std::make_unique<TypeHierarchyOptions>(*other._typeHierarchyOptions)
                };
                break;
            }
            case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions: {
                new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
                    std::make_unique<TypeHierarchyRegistrationOptions>(*other._typeHierarchyRegistrationOptions)
                };
                break;
            }
            case ServerCapabilities_typeHierarchyProviderType::Uninitialized: {
                // other has not been initialized, there is nothing to do ...
                break;
            }
            }
        }
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::reset() -> void
    {
        switch (_type) {
        case ServerCapabilities_typeHierarchyProviderType::Uninitialized: {
            // nothing to do
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions: {
#ifdef DEBUG
            if (!_typeHierarchyOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _typeHierarchyOptions"
                );
            }
#endif // DEBUG
            _typeHierarchyOptions.~unique_ptr<TypeHierarchyOptions>();
            _type =
                ServerCapabilities_typeHierarchyProviderType::Uninitialized;
            break;
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions: {
#ifdef DEBUG
            if (!_typeHierarchyRegistrationOptions) {
                throw std::logic_error(
                    "Attempted to free a null pointer to _typeHierarchyRegistrationOptions"
                );
            }
#endif // DEBUG
            _typeHierarchyRegistrationOptions.~unique_ptr<TypeHierarchyRegistrationOptions>();
            _type =
                ServerCapabilities_typeHierarchyProviderType::Uninitialized;
            break;
        }
        default: {
            _type = ServerCapabilities_typeHierarchyProviderType::Uninitialized;
        }
        }
    }

    auto ServerCapabilities_typeHierarchyProvider::type() const
    -> const ServerCapabilities_typeHierarchyProviderType &
    {
        return _type;
    }

    auto ServerCapabilities_typeHierarchyProvider::boolean() const
    -> const boolean_t &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_typeHierarchyProviderType::Boolean) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_typeHierarchyProvider::boolean()"
                 " of type "
                 "ServerCapabilities_typeHierarchyProviderType::Boolean"
                 " while active type is "
                 "ServerCapabilities_typeHierarchyProviderType::" +
                 ServerCapabilities_typeHierarchyProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return _boolean;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        boolean_t boolean
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
        _boolean = boolean;
        _type = ServerCapabilities_typeHierarchyProviderType::Boolean;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::typeHierarchyOptions() const
    -> const TypeHierarchyOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_typeHierarchyProvider::typeHierarchyOptions()"
                 " of type "
                 "ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions"
                 " while active type is "
                 "ServerCapabilities_typeHierarchyProviderType::" +
                 ServerCapabilities_typeHierarchyProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_typeHierarchyOptions;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        const std::unique_ptr<TypeHierarchyOptions> &typeHierarchyOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeHierarchyOptions) {
            throw std::logic_error(
                "null passed as the value of typeHierarchyOptions"
            );
        }
#endif // DEBUG
        new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
            std::make_unique<TypeHierarchyOptions>(*typeHierarchyOptions)
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        std::unique_ptr<TypeHierarchyOptions> &&typeHierarchyOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeHierarchyOptions) {
            throw std::logic_error(
                "null passed as the value of typeHierarchyOptions"
            );
        }
#endif // DEBUG
        new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
            std::move(typeHierarchyOptions)
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        const TypeHierarchyOptions &typeHierarchyOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
            std::make_unique<TypeHierarchyOptions>(typeHierarchyOptions)
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        TypeHierarchyOptions &&typeHierarchyOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_typeHierarchyOptions) std::unique_ptr<TypeHierarchyOptions> {
            std::make_unique<TypeHierarchyOptions>(std::move(typeHierarchyOptions))
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::typeHierarchyRegistrationOptions() const
    -> const TypeHierarchyRegistrationOptions &
    {
#ifdef DEBUG
        if (_type != ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions) {
            throw std::logic_error(
                ("Attempted to access "
                 "ServerCapabilities_typeHierarchyProvider::typeHierarchyRegistrationOptions()"
                 " of type "
                 "ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions"
                 " while active type is "
                 "ServerCapabilities_typeHierarchyProviderType::" +
                 ServerCapabilities_typeHierarchyProviderTypeNames.at(_type))
            );
        }
#endif // DEBUG
        return *_typeHierarchyRegistrationOptions;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        const std::unique_ptr<TypeHierarchyRegistrationOptions> &typeHierarchyRegistrationOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeHierarchyRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of typeHierarchyRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
            std::make_unique<TypeHierarchyRegistrationOptions>(*typeHierarchyRegistrationOptions)
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        std::unique_ptr<TypeHierarchyRegistrationOptions> &&typeHierarchyRegistrationOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
#ifdef DEBUG
        if (!typeHierarchyRegistrationOptions) {
            throw std::logic_error(
                "null passed as the value of typeHierarchyRegistrationOptions"
            );
        }
#endif // DEBUG
        new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
            std::move(typeHierarchyRegistrationOptions)
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        const TypeHierarchyRegistrationOptions &typeHierarchyRegistrationOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
            std::make_unique<TypeHierarchyRegistrationOptions>(typeHierarchyRegistrationOptions)
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions;
        return *this;
    }

    auto ServerCapabilities_typeHierarchyProvider::operator=(
        TypeHierarchyRegistrationOptions &&typeHierarchyRegistrationOptions
    ) -> ServerCapabilities_typeHierarchyProvider &
    {
        if (_type !=
                ServerCapabilities_typeHierarchyProviderType::Uninitialized) {
            reset();
        }
        new (&_typeHierarchyRegistrationOptions) std::unique_ptr<TypeHierarchyRegistrationOptions> {
            std::make_unique<TypeHierarchyRegistrationOptions>(std::move(typeHierarchyRegistrationOptions))
        };
        _type =
            ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions;
        return *this;
    }

    const std::map<ServerCapabilities_inlineValueProviderType, std::string>
    ServerCapabilities_inlineValueProviderTypeNames = {
        {ServerCapabilities_inlineValueProviderType::Uninitialized,
         "Uninitialized"},
        {ServerCapabilities_inlineValueProviderType::Boolean, "Boolean"},
        {ServerCapabilities_inlineValueProviderType::InlineValueOptions,
         "InlineValueOptions"},
        {ServerCapabilities_inlineValueProviderType::InlineValueRegistrationOptions,
         "InlineValueRegistrationOptions"},
    };

    ServerCapabilities_inlineValueProvider::ServerCapabilities_inlineValueProvider()
    {
        // empty
    }

    ServerCapabilities_inlineValueProvider::~ServerCapabilities_inlineValueProvider()
    {
        reset();
    }

    ServerCapabilities_inlineValueProvider::ServerCapabilities_inlineValueProvider(
        ServerCapabilities_inlineValueProvider &&other
    )
        : _type(other._type)
    {
        switch (other._type) {
        case ServerCapabilities_inlineValueProviderType::Boolean: {
            _boolean = other._boolean;
            break;
        }
        case ServerCapabilities_inlineValueProviderType::InlineValueOptions: {
            new (&_inlineValueOptions) std::unique_ptr<InlineValueOptions> {
                std::move(other._inlineValueOptions)
            };
            break;
        }
        case ServerCapabilities_inlineValueProviderType::InlineValueRegistrationOptions: {
            new (&_inlineValueRegistrationOptions) std::unique_ptr<InlineValueRegistrationOptions