---
title: glab ci run-trig
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

Run a CI/CD pipeline trigger.

## Synopsis

Specify one or more pipeline inputs using the `-i` or `--input` flag for each
input. Each input flag uses the format `key:value`.

The values are typed and will default to `string` unless a type is explicitly
specified. To specify a type, use the `type(value)` syntax. For example,
`key:string(value)` will pass the string `value` as the input.

Valid types are:

- `string`: A string value. This is the default type. For example, `key:string(value)`.
- `int`: An integer value. For example, `key:int(42)`.
- `float`: A floating-point value. For example, `key:float(3.14)`.
- `bool`: A boolean value. For example, `key:bool(true)`.
- `array`: An array of strings. For example, `key:array(foo,bar)`.

An array of strings can be specified with a trailing comma. For example,
`key:array(foo,bar,)` will pass the array `[foo, bar]`. `array()` specifies an
empty array. To pass an array with the empty string, use `array(,)`.

Value arguments containing parentheses should be escaped from the shell with
quotes. For example, `--input key:array(foo,bar)` should be written as
`--input 'key:array(foo,bar)'`.

```plaintext
glab ci run-trig [flags]
```

## Aliases

```plaintext
run-trig
```

## Examples

```console
$ glab ci run-trig -t xxxx
$ glab ci run-trig -t xxxx -b main

# Specify CI variables
$ glab ci run-trig -t xxxx -b main --variables key1:val1
$ glab ci run-trig -t xxxx -b main --variables key1:val1,key2:val2
$ glab ci run-trig -t xxxx -b main --variables key1:val1 --variables key2:val2

# Specify CI inputs
$ glab ci run-trig -t xxxx -b main --input key1:val1 --input key2:val2
$ glab ci run-trig -t xxxx -b main --input "replicas:int(3)" --input "debug:bool(false)" --input "regions:array(us-east,eu-west)"

```

## Options

```plaintext
  -b, --branch string        Create pipeline on branch or reference <string>.
  -i, --input stringArray    Pass inputs to pipeline in format '<key>:<value>'. Cannot be used for merge request pipelines. See documentation for examples.
  -t, --token CI_JOB_TOKEN   Pipeline trigger token. Can be omitted only if the CI_JOB_TOKEN environment variable is set.
      --variables strings    Pass variables to pipeline in the format <key>:<value>.
```

## Options inherited from parent commands

```plaintext
  -h, --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
