;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --signature-refining --closed-world -all -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt --signature-refining                -all -S -o - | filecheck %s --check-prefix OPEN_WORLD

;; Test that configureAll is respected: referred functions are not refined.
;; This is so even in closed world.

(module
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $func-2 (func (param (ref (exact $struct))) (result (ref (exact $struct)))))

  ;; CHECK:       (type $func-1 (func (param anyref) (result (ref (exact $struct)))))

  ;; CHECK:       (type $2 (func (result i32)))

  ;; CHECK:       (type $struct (struct))

  ;; CHECK:       (type $4 (func))

  ;; CHECK:      (type $externs (array (mut externref)))
  ;; OPEN_WORLD:      (rec
  ;; OPEN_WORLD-NEXT:  (type $func-2 (func (param (ref (exact $struct))) (result (ref (exact $struct)))))

  ;; OPEN_WORLD:       (type $func-1 (func (param anyref) (result (ref (exact $struct)))))

  ;; OPEN_WORLD:       (type $2 (func (result i32)))

  ;; OPEN_WORLD:       (type $struct (struct))

  ;; OPEN_WORLD:       (type $4 (func))

  ;; OPEN_WORLD:      (type $externs (array (mut externref)))
  (type $externs (array (mut externref)))

  ;; CHECK:      (type $funcs (array (mut funcref)))
  ;; OPEN_WORLD:      (type $funcs (array (mut funcref)))
  (type $funcs (array (mut funcref)))

  ;; CHECK:      (type $bytes (array (mut i8)))
  ;; OPEN_WORLD:      (type $bytes (array (mut i8)))
  (type $bytes (array (mut i8)))

  ;; CHECK:      (type $configureAll (func (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  ;; OPEN_WORLD:      (type $configureAll (func (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  (type $configureAll (func (param (ref null $externs)) (param (ref null $funcs)) (param (ref null $bytes)) (param externref)))

  (type $struct (struct))

  (rec
    (type $func-1 (func (param anyref) (result anyref)))

    ;; use brands to allow $func-1/2 to be optimized separately.
    (type $brand1 (struct))
  )

  (rec
    (type $func-2 (func (param anyref) (result anyref)))

    (type $brand2 (struct))
    (type $brand3 (struct))
  )

  ;; CHECK:      (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll) (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  ;; OPEN_WORLD:      (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll) (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll)))

  ;; CHECK:      (data $bytes "12345678")

  ;; CHECK:      (elem $externs externref (item (ref.null noextern)))
  ;; OPEN_WORLD:      (data $bytes "12345678")

  ;; OPEN_WORLD:      (elem $externs externref (item (ref.null noextern)))
  (elem $externs externref
    (ref.null extern)
  )

  ;; CHECK:      (elem $funcs func $foo $bar)
  ;; OPEN_WORLD:      (elem $funcs func $foo $bar)
  (elem $funcs funcref
    (ref.func $foo)
    (ref.func $bar)
  )

  (data $bytes "12345678")

  ;; CHECK:      (start $start)
  ;; OPEN_WORLD:      (start $start)
  (start $start)

  ;; CHECK:      (func $start (type $4)
  ;; CHECK-NEXT:  (call $configureAll
  ;; CHECK-NEXT:   (array.new_elem $externs $externs
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_elem $funcs $funcs
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_data $bytes $bytes
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (ref.null noextern)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $start (type $4)
  ;; OPEN_WORLD-NEXT:  (call $configureAll
  ;; OPEN_WORLD-NEXT:   (array.new_elem $externs $externs
  ;; OPEN_WORLD-NEXT:    (i32.const 0)
  ;; OPEN_WORLD-NEXT:    (i32.const 1)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:   (array.new_elem $funcs $funcs
  ;; OPEN_WORLD-NEXT:    (i32.const 0)
  ;; OPEN_WORLD-NEXT:    (i32.const 2)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:   (array.new_data $bytes $bytes
  ;; OPEN_WORLD-NEXT:    (i32.const 0)
  ;; OPEN_WORLD-NEXT:    (i32.const 8)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:   (ref.null noextern)
  ;; OPEN_WORLD-NEXT:  )
  ;; OPEN_WORLD-NEXT: )
  (func $start
    (call $configureAll
      (array.new_elem $externs $externs
        (i32.const 0) (i32.const 1))
      (array.new_elem $funcs $funcs
        (i32.const 0) (i32.const 2))
      (array.new_data $bytes $bytes
        (i32.const 0) (i32.const 8))
      (ref.null extern)
    )
  )

  ;; CHECK:      (func $calls (type $4)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (call $bar
  ;; CHECK-NEXT:    (struct.new_default $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (call $unconfigured
  ;; CHECK-NEXT:    (struct.new_default $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $calls (type $4)
  ;; OPEN_WORLD-NEXT:  (drop
  ;; OPEN_WORLD-NEXT:   (call $bar
  ;; OPEN_WORLD-NEXT:    (struct.new_default $struct)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:  )
  ;; OPEN_WORLD-NEXT:  (drop
  ;; OPEN_WORLD-NEXT:   (call $unconfigured
  ;; OPEN_WORLD-NEXT:    (struct.new_default $struct)
  ;; OPEN_WORLD-NEXT:   )
  ;; OPEN_WORLD-NEXT:  )
  ;; OPEN_WORLD-NEXT: )
  (func $calls
    (drop
      (call $bar
        (struct.new $struct)
      )
    )
    (drop
      (call $unconfigured
        (struct.new $struct)
      )
    )
  )

  ;; CHECK:      (func $foo (type $2) (result i32)
  ;; CHECK-NEXT:  (i32.const 42)
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $foo (type $2) (result i32)
  ;; OPEN_WORLD-NEXT:  (i32.const 42)
  ;; OPEN_WORLD-NEXT: )
  (func $foo (result i32)
    ;; Nothing to do here anyhow, but do not error.
    (i32.const 42)
  )

  ;; CHECK:      (func $bar (type $func-1) (param $x anyref) (result (ref (exact $struct)))
  ;; CHECK-NEXT:  (struct.new_default $struct)
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $bar (type $func-1) (param $x anyref) (result (ref (exact $struct)))
  ;; OPEN_WORLD-NEXT:  (struct.new_default $struct)
  ;; OPEN_WORLD-NEXT: )
  (func $bar (type $func-1) (param $x anyref) (result anyref)
    ;; The params will not be refined due to configureAll, but the result will.
    (struct.new $struct)
  )

  ;; CHECK:      (func $unconfigured (type $func-2) (param $x (ref (exact $struct))) (result (ref (exact $struct)))
  ;; CHECK-NEXT:  (struct.new_default $struct)
  ;; CHECK-NEXT: )
  ;; OPEN_WORLD:      (func $unconfigured (type $func-2) (param $x (ref (exact $struct))) (result (ref (exact $struct)))
  ;; OPEN_WORLD-NEXT:  (struct.new_default $struct)
  ;; OPEN_WORLD-NEXT: )
  (func $unconfigured (type $func-2) (param $x anyref) (result anyref)
    ;; This is not referred to by configureAll, and can be refined in both
    ;; params and result.
    (struct.new $struct)
  )
)
