///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcWhileStmt.cc  
// --------------------
// Cego procedure while look statement implementation
//               
// Design and Implementation by Bjoern Lemke
//                                   
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcWhileStmt
//
// Description: This class implements the while statement for cego stored procedures.
//              The condition and block information is stored stored for later execution  
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes 
#include <lfcbase/ListT.h>

// cego includes
#include "CegoProcWhileStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcWhileStmt::CegoProcWhileStmt(CegoTableManager *pTabMng,
				     CegoProcCond *pCond,
				     CegoProcBlock *pBlock,
				     CegoProcBlock *pParentBlock) : CegoProcStmt(pParentBlock)
{
    _pTabMng = pTabMng;
    _pCond = pCond;
    _pBlock = pBlock;
    _pParentBlock = pParentBlock;
    _pCond->setBlock(_pBlock);
}

CegoProcWhileStmt::~CegoProcWhileStmt()  
{
    if ( _pBlock )
	delete _pBlock;
    if ( _pCond )
	delete _pCond;
}

void CegoProcWhileStmt::setBlock(CegoProcBlock * pBlock)
{
    _pBlock = pBlock;
}

CegoException CegoProcWhileStmt::execute()
{

    try
    {
	while ( _pCond->eval() )
	{
	    CegoException result;
	    result =  _pBlock->execute();
	    if ( result != NONE_EXCEP )
		return result;
	    if ( _pTabMng->isAborted() ) 
	    { 
		_pParentBlock->setExceptionMsg(Chain("Procedure aborted")); 
		return ABORT_EXCEP; 
	    } 
	}
    }
    catch ( Exception e)
    {
	Chain excepMsg;
	e.pop(excepMsg);
	_pParentBlock->setExceptionMsg(excepMsg);
	return COREOP_EXCEP;	    
    }
    return NONE_EXCEP;
}

Chain CegoProcWhileStmt::toChain(const Chain& indent) const
{
    Chain s;
    s = indent + Chain("while ") + _pCond->toChain() + Chain("\n") + indent + Chain("begin\n");
    s += _pBlock->toChain(indent + Chain(DEFAULTINDENT));
    s += indent + Chain("end");
    return s;
}

Chain CegoProcWhileStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcWhileStmt(_pCond, _pBlock);
}
