--
-- ### Verification of multidimensional btree selects
-- 
--

create table a_tab ( a string(5), b string(10));
create btree b1 on a_tab(a,b);

drop if exists procedure loadData;
@
create procedure loadData()
begin

   delete from a_tab;

   insert into a_tab values ( 'erwin', 'hubertkahc');
   insert into a_tab values ( null, 'Hannah');
   insert into a_tab values ( 'erwin', null);
   insert into a_tab values ( null, null);
   insert into a_tab values ( null, 'XXpupspups');
   insert into a_tab values ( 'erwin', 'HannahXXXp');
   insert into a_tab values ( 'fried', 'gustav');
   insert into a_tab values ( 'fried', 'gustav');
   insert into a_tab values ( 'fried', 'gustav');
   insert into a_tab values ( 'anna', 'gabi');	
   insert into a_tab values ( null, null);
   insert into a_tab values ( 'anna', 'gabi');
end;
@

drop if exists procedure checkBTreeSelect001;
@
create procedure checkBTreeSelect001(msg out string(20)) return string(10)
begin

   var res string(10) = 'ok';
   
   var numrow int;

   :numrow = ( select count(*) from a_tab where a is null and b is null );
   if :numrow != 2
   then
	:res = 'ERROR';
	return :res;
   end;

   :numrow = ( select count(*) from a_tab where a is null );
   if :numrow != 4
   then
	:res = 'ERROR';
	return :res;
   end;

   :numrow = ( select count(*) from a_tab where a = 'erwin' and b = 'hubertkahc' );
   if :numrow != 1
   then
	:res = 'ERROR';
	return :res;
   end;

   :numrow = ( select count(*) from a_tab where a = 'fried' and b = 'gustav' );
   if :numrow != 3
   then
	:res = 'ERROR';
	return :res;
   end;

   :numrow = ( select count(*) from a_tab where a = 'anna' and b = 'gabi' );
   if :numrow != 2
   then
	:res = 'ERROR';
	return :res;
   end;


   :msg = 'btree select';
   return :res;
end;
@

call loadData();
:r = call checkBTreeSelect001(:msg);
insert into checklog values ('GATE-F', :msg, :r);

drop procedure loadData;
drop procedure checkBtreeSelect001;

drop if exists table a_tab;

