;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
 ;; CHECK-TEXT:      (type $ft (func (param i32) (result i32)))
 ;; CHECK-BIN:      (type $ft (func (param i32) (result i32)))
 (type $ft (func (param i32) (result i32)))
 ;; CHECK-TEXT:      (type $ct (cont $ft))
 ;; CHECK-BIN:      (type $ct (cont $ft))
 (type $ct (cont $ft))

 ;; CHECK-TEXT:      (type $2 (func (param i64)))

 ;; CHECK-TEXT:      (type $3 (func (param (ref $ct)) (result i32)))

 ;; CHECK-TEXT:      (type $4 (func (result i32)))

 ;; CHECK-TEXT:      (type $5 (func (result i32 (ref $ct))))

 ;; CHECK-TEXT:      (tag $t (type $ft) (param i32) (result i32))
 ;; CHECK-BIN:      (type $2 (func (param i64)))

 ;; CHECK-BIN:      (type $3 (func (param (ref $ct)) (result i32)))

 ;; CHECK-BIN:      (type $4 (func (result i32)))

 ;; CHECK-BIN:      (type $5 (func (result i32 (ref $ct))))

 ;; CHECK-BIN:      (tag $t (type $ft) (param i32) (result i32))
 (tag $t (param i32) (result i32))
 ;; CHECK-TEXT:      (tag $e (type $2) (param i64))
 ;; CHECK-BIN:      (tag $e (type $2) (param i64))
 (tag $e (param i64))

 ;; CHECK-TEXT:      (func $go (type $3) (param $x (ref $ct)) (result i32)
 ;; CHECK-TEXT-NEXT:  (tuple.extract 2 0
 ;; CHECK-TEXT-NEXT:   (block $handler (type $5) (result i32 (ref $ct))
 ;; CHECK-TEXT-NEXT:    (return
 ;; CHECK-TEXT-NEXT:     (resume_throw $ct $e (on $t $handler)
 ;; CHECK-TEXT-NEXT:      (i64.const 123)
 ;; CHECK-TEXT-NEXT:      (local.get $x)
 ;; CHECK-TEXT-NEXT:     )
 ;; CHECK-TEXT-NEXT:    )
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $go (type $3) (param $x (ref $ct)) (result i32)
 ;; CHECK-BIN-NEXT:  (local $scratch (tuple i32 (ref $ct)))
 ;; CHECK-BIN-NEXT:  (local $scratch_2 i32)
 ;; CHECK-BIN-NEXT:  (local.set $scratch_2
 ;; CHECK-BIN-NEXT:   (tuple.extract 2 0
 ;; CHECK-BIN-NEXT:    (local.tee $scratch
 ;; CHECK-BIN-NEXT:     (block $block (type $5) (result i32 (ref $ct))
 ;; CHECK-BIN-NEXT:      (return
 ;; CHECK-BIN-NEXT:       (resume_throw $ct $e (on $t $block)
 ;; CHECK-BIN-NEXT:        (i64.const 123)
 ;; CHECK-BIN-NEXT:        (local.get $x)
 ;; CHECK-BIN-NEXT:       )
 ;; CHECK-BIN-NEXT:      )
 ;; CHECK-BIN-NEXT:     )
 ;; CHECK-BIN-NEXT:    )
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (tuple.extract 2 1
 ;; CHECK-BIN-NEXT:    (local.get $scratch)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (local.get $scratch_2)
 ;; CHECK-BIN-NEXT: )
 (func $go (param $x (ref $ct)) (result i32)
  (tuple.extract 2 0
   (block $handler (result i32 (ref $ct))
    (return
     (resume_throw $ct $e
      (on $t $handler)
      (i64.const 123)
      (local.get $x)
     )
    )
   )
  )
 )

 ;; CHECK-TEXT:      (func $unreachable (type $4) (result i32)
 ;; CHECK-TEXT-NEXT:  (block ;; (replaces unreachable ResumeThrow we can't emit)
 ;; CHECK-TEXT-NEXT:   (drop
 ;; CHECK-TEXT-NEXT:    (i64.const 123)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:   (drop
 ;; CHECK-TEXT-NEXT:    (unreachable)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:   (unreachable)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $unreachable (type $4) (result i32)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.const 123)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (unreachable)
 ;; CHECK-BIN-NEXT: )
 (func $unreachable (result i32)
   (resume_throw $ct $e
     (i64.const 123)
     (unreachable)
   )
 )
)
;; CHECK-BIN-NODEBUG:      (type $0 (func (param i32) (result i32)))

;; CHECK-BIN-NODEBUG:      (type $1 (cont $0))

;; CHECK-BIN-NODEBUG:      (type $2 (func (param i64)))

;; CHECK-BIN-NODEBUG:      (type $3 (func (param (ref $1)) (result i32)))

;; CHECK-BIN-NODEBUG:      (type $4 (func (result i32)))

;; CHECK-BIN-NODEBUG:      (type $5 (func (result i32 (ref $1))))

;; CHECK-BIN-NODEBUG:      (tag $tag$0 (type $0) (param i32) (result i32))

;; CHECK-BIN-NODEBUG:      (tag $tag$1 (type $2) (param i64))

;; CHECK-BIN-NODEBUG:      (func $0 (type $3) (param $0 (ref $1)) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch (tuple i32 (ref $1)))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_2 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $scratch_2
;; CHECK-BIN-NODEBUG-NEXT:   (tuple.extract 2 0
;; CHECK-BIN-NODEBUG-NEXT:    (local.tee $scratch
;; CHECK-BIN-NODEBUG-NEXT:     (block $block (type $5) (result i32 (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:      (return
;; CHECK-BIN-NODEBUG-NEXT:       (resume_throw $1 $tag$1 (on $tag$0 $block)
;; CHECK-BIN-NODEBUG-NEXT:        (i64.const 123)
;; CHECK-BIN-NODEBUG-NEXT:        (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (tuple.extract 2 1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $scratch)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $scratch_2)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $4) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.const 123)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )
