# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/NOX clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "NOX requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/NOX build
## ---------------------------------------------------------------------------

set(NOX_CXX_COMPILER "D:/a/msys64/mingw64/bin/g++.exe")

set(NOX_C_COMPILER "D:/a/msys64/mingw64/bin/gcc.exe")

set(NOX_Fortran_COMPILER "D:/a/msys64/mingw64/bin/gfortran.exe")
# Deprecated!
set(NOX_FORTRAN_COMPILER "D:/a/msys64/mingw64/bin/gfortran.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/NOX build
## ---------------------------------------------------------------------------

## Give the build type
set(NOX_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(NOX_CXX_FLAGS [[ ]])

set(NOX_C_FLAGS [[  -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(NOX_Fortran_FLAGS [[ ]])
# Deprecated
set(NOX_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(NOX_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(NOX_SHARED_LIB_RPATH_COMMAND "/mingw64/lib")
set(NOX_BUILD_SHARED_LIBS "ON")

set(NOX_LINKER D:/a/msys64/mingw64/bin/ld.exe)
set(NOX_AR D:/a/msys64/mingw64/bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(NOX_INSTALL_DIR "/mingw64")

## List of package libraries
set(NOX_LIBRARIES NOX::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(NOX_MPI_LIBRARIES "")
set(NOX_MPI_LIBRARY_DIRS "")
set(NOX_MPI_INCLUDE_DIRS "")
set(NOX_MPI_EXEC "")
set(NOX_MPI_EXEC_MAX_NUMPROCS "")
set(NOX_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(NOX_ENABLE_Teuchos ON)
set(NOX_ENABLE_Epetra ON)
set(NOX_ENABLE_EpetraExt OFF)
set(NOX_ENABLE_ThyraCore ON)
set(NOX_ENABLE_ThyraEpetraAdapters OFF)
set(NOX_ENABLE_ThyraEpetraExtAdapters OFF)
set(NOX_ENABLE_Amesos OFF)
set(NOX_ENABLE_AztecOO OFF)
set(NOX_ENABLE_Ifpack OFF)
set(NOX_ENABLE_ML OFF)
set(NOX_ENABLE_Belos ON)
set(NOX_ENABLE_Anasazi OFF)
set(NOX_ENABLE_Stratimikos ON)
set(NOX_ENABLE_Teko OFF)
set(NOX_ENABLE_MF OFF)
set(NOX_ENABLE_PETSC OFF)
set(NOX_ENABLE_LAPACK ON)
set(NOX_ENABLE_BLAS ON)

# Exported cache variables
set(NOX_ENABLE_MF "")
set(HAVE_LOCA_MF "OFF")
set(NOX_ENABLE_DEBUG "OFF")
set(HAVE_NOX_DEBUG "OFF")

# Include configuration of dependent packages
if (NOT TARGET Teuchos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Teuchos/TeuchosConfig.cmake")
endif()
if (NOT TARGET Epetra::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Epetra/EpetraConfig.cmake")
endif()
if (NOT TARGET ThyraCore::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../ThyraCore/ThyraCoreConfig.cmake")
endif()
if (NOT TARGET Belos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Belos/BelosConfig.cmake")
endif()
if (NOT TARGET Stratimikos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Stratimikos/StratimikosConfig.cmake")
endif()
if (NOT TARGET LAPACK::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/LAPACK/LAPACKConfig.cmake")
endif()
if (NOT TARGET BLAS::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/BLAS/BLASConfig.cmake")
endif()

# Import NOX targets
include("${CMAKE_CURRENT_LIST_DIR}/NOXTargets.cmake")

# Standard TriBITS-compliant external package variables
set(NOX_IS_TRIBITS_COMPLIANT TRUE)
set(NOX_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(NOX_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(NOX_EXPORTED_PACKAGE_LIBS_NAMES "nox;noxlapack;loca;localapack;locathyra")

foreach(libname IN LISTS NOX_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE NOX::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'NOX::${libname}', or better yet,"
      " 'NOX::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'NOX'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'NOX_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
