/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Tool name constants to avoid circular dependencies.
 * These constants are used across multiple files and should be kept in sync
 * with the actual tool class names.
 */
export const ToolNames = {
    EDIT: 'edit',
    WRITE_FILE: 'write_file',
    READ_FILE: 'read_file',
    READ_MANY_FILES: 'read_many_files',
    GREP: 'search_file_content',
    GLOB: 'glob',
    SHELL: 'run_shell_command',
    TODO_WRITE: 'todo_write',
    MEMORY: 'save_memory',
    TASK: 'task',
    EXIT_PLAN_MODE: 'exit_plan_mode',
};
//# sourceMappingURL=tool-names.js.map