
/****************************************************************************
 *  (c) Copyright 2006 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 * License is granted only to Wi-Fi Alliance members and designated Wi-Fi
 * contractors ("Authorized Licensees").  Authorized Licensees are hereby
 * granted the limited right to use this software solely for noncommercial
 * applications and solely for testing Wi-Fi equipment. Authorized Licensees
 * may embed this software into their proprietary equipment and distribute this
 * software with such equipment under a license with at least the same
 * restrictions as contained in this License, including, without limitation,
 * the disclaimer of warranty and limitation of liability, below.  Other than
 * expressly granted herein, this License is not transferable or sublicensable,
 * and it does not extend to and may not be used with non-Wi-Fi applications.
 *
 * Commercial derivative works of this software or applications that use the
 * Wi-Fi scripts generated by this software are NOT AUTHORIZED without specific
 * prior written permission from Wi-Fi Alliance.
 *
 * Non-Commercial derivative works of this software for internal use are
 * authorized and are limited by the same restrictions; provided, however,
 * that the Authorized Licensee shall provide Wi-Fi with a copy of such
 * derivative works under a perpetual, payment-free license to use, modify,
 * and distribute such derivative works for purposes of testing Wi-Fi equipment.
 *
 * Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 * or promote products that are derived from or that use this software without
 * specific prior written permission from Wi-Fi Alliance.
 *
 * THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE,
 * ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************************
 */


/*
 * File: ca_cli.c
 *       This is the main program for sending a text string based command to
 *       Control Agent (see reference document).
 *
 *  Revision History:
 *         06/30/2006   -- 00.10 Release by qhu
 *         09/01/2006   -- 01.05 Release by qhu
 *         03/30/2007   -- 01.40 WPA2 and Official WMM Beta Release by qhu
 *         04/20/2007   -- 02.00 WPA2 and Official WMM Release by qhu
 */
 /*
 *       All the buffer size changed from 512 to MAX_CMD_BUFF(1024)
 *
 */

#ifndef WIN32
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <errno.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "wfa_types.h"
#include "wfa_debug.h"
#include "wfa_sock.h"
#include "wfa_main.h"
#include "wfa_tlv.h"
#include "wfa_tg.h"
#include "wfa_ca_resp.h"
#include "wfa_cmds.h"
#include "wfa_miscs.h"

#define WFA_ENV_AGENT_IPADDR "WFA_ENV_CA_IPADDR"
#define WFA_ENV_CA_PORT      "WFA_ENV_CA_PORT"

extern int xcCmdProcGetVersion(unsigned char *parms);
unsigned short wfa_defined_debug = WFA_DEBUG_ERR;
int sock;

char gnetIf[32];
int gtgTransac;

int
main(int argc, char *argv[])
{
	struct sockaddr_in servAddr;
	unsigned short servPort;
	char *servIP = NULL, *tstr = NULL;
	int bytesRcvd;
	char cmdName[MAX_CMD_BUFF]; /* Modified as per BRCM ASD 1.3 */
	int isFound = 0;
	int done, errno;
	int byteSent;
	int rspCnt = 0;
	BYTE caCmdBuf[MAX_CMD_BUFF]; /* Modified as per BRCM ASD 1.3 */
	memset(caCmdBuf, 0, 512);
	if ((argc != 2))
	{
		DPRINT_ERR(WFA_ERR, "Usage: %s <command string>\n", argv[0]);
		exit(1);
	}

	if ((tstr = getenv("WFA_ENV_CA_IPADDR")) == NULL)
	{
		DPRINT_ERR(WFA_ERR, "Environment variable WFA_ENV_CA_IPADDR not set\n");
		exit(1);
	}

	if (isIpV4Addr(tstr) == FALSE){
		DPRINT_ERR(WFA_ERR, "incorrect IP number\n");
		exit(1);
	}

	servIP = tstr;


	if ((tstr = getenv("WFA_ENV_CA_PORT")) == NULL)
	{
		DPRINT_ERR(WFA_ERR, "Environment variable WFA_ENV_CA_PORT not set\n");
		exit(1);
	}

	if (isNumber(tstr) == FALSE){
		DPRINT_ERR(WFA_ERR, "incorrect port number\n");
		exit(1);
	}
	
	if((errno = Start_Socket_Service()) != 0){
		DPRINT_ERR(WFA_ERR, "Start_Socket_Service failed\n");
		return 0;
	}

	servPort = atoi(tstr);

	if ((sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
	{
		DPRINT_ERR(WFA_ERR, "socket() failed");
		if((errno = Stop_Socket_Service()) != 0){
			DPRINT_ERR(WFA_ERR, "Stop_Socket_Service failed\n");
		}
		return 0;
	}

	memset(&servAddr, 0, sizeof(servAddr));
	servAddr.sin_family      = AF_INET;
	servAddr.sin_addr.s_addr = inet_addr(servIP);
	servAddr.sin_port        = htons(servPort);

	if (connect(sock, (struct sockaddr *) &servAddr, sizeof(servAddr)) < 0)
	{
		DPRINT_ERR(WFA_ERR, "connect() failed");
		if((errno = Stop_Socket_Service()) != 0){
			DPRINT_ERR(WFA_ERR, "Stop_Socket_Service failed\n");
		}
		return 0;
	}

	isFound = 0;

	memset(cmdName, 0, MAX_CMD_BUFF);

	memcpy(cmdName, argv[1], MAX_CMD_BUFF); /* Modified as per BRCM ASD 1.3 */

	strcat(cmdName, " \r\n");

	byteSent = wfaCtrlSend(sock, (BYTE *)cmdName, strlen(cmdName));
	/* Modified as per BRCM ASD 1.3 */
	memset(caCmdBuf, 0, MAX_CMD_BUFF);
	bytesRcvd = recv(sock, caCmdBuf, MAX_CMD_BUFF, 0); /* Modified as per BRCM ASD 1.3 */
	rspCnt++;
	asd_sleep(1);
	done = 1;
	while (done)
	{
		printf("=======Response======\n");
		printf("%s\n", caCmdBuf);
		asd_sleep(1);
		if (strncmp("status,COMPLETE", (char *)caCmdBuf, 15) == 0 ||
			strncmp("status,INVALID", (char *)caCmdBuf, 14) == 0 ||
			strncmp("status,ERROR", (char *)caCmdBuf, 12) == 0)
		{
			break;
		}

		if (rspCnt == 3)
			break;


		memset(caCmdBuf, 0, MAX_CMD_BUFF);
		bytesRcvd = recv(sock, caCmdBuf, MAX_CMD_BUFF, 0);
		/* Modified as per BRCM ASD 1.3 */
		rspCnt++;
	}
	asd_closeSocket(sock);

		/* Tell the user that we could not find a usable */
	/* WinSock DLL.                                  */
	if((errno = Stop_Socket_Service()) != 0){
		DPRINT_ERR(WFA_ERR, "Stop_Socket_Service failed\n");
	}
		return 0;
}
