/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{

}

Component.prototype.createOperations = function()
{
    component.createOperations();
}


// Returns original host path based on original host OS

originalQtHostPath_670 = function(buildHostName)
{
    if (originalHostOS_670(buildHostName) === "Linux") {
        return "/home/qt/work/install";
    }
    else {
        return "/Users/qt/work/install";
    }
}

// Function that returns the value of what the component was originally build on

originalHostOS_670 = function(buildHostName)
{
    var originalHostOSName = buildHostName.toLowerCase();

    if (originalHostOSName.startsWith("macos")) {
        return "macOS";
    }
    else if (originalHostOSName.startsWith("windows")) {
        return "Windows";
    }
    else if (originalHostOSName.startsWith("linux")) {
        return "Linux";
    }
    else {
        console.log("originalHostOSName is not defined!");
        return "";
    }
}

// Functions that return a generic value

qtPathUnixSeparators = function(TARGET_INSTALL_DIR)
{
    return installer.toNativeSeparators(installer.value("TargetDir") + TARGET_INSTALL_DIR);
}

qtPathWinSeparators = function(TARGET_INSTALL_DIR)
{
    // Windows needs separators patched forward in some cases
    var qtPathWindows = installer.value("TargetDir") + TARGET_INSTALL_DIR;
    return qtPathWindows.replace(/\\/g, "/");
}

targetQtConfDocumentation_670 = function(qt_version)
{
    return "Documentation=../../Docs/Qt-" + qt_version;
}

targetQtConfExamples_670 = function(qt_version)
{
    return "Examples=../../Examples/Qt-" + qt_version;
}

originalHostPrefix_670 = function()
{
    return "HostPrefix=../../";
}

originalHostData_670 = function()
{
    return "HostData=target";
}

qdeviceFile_670 = function()
{
    return "/mkspecs/qdevice.pri";
}

qconfigFile_670 = function()
{
    return "/mkspecs/qconfig.pri";
}

qtConfigureModuleScript_670 = function()
{
    return installer.toNativeSeparators("/bin/qt-configure-module");
}

targetQtConf_670 = function()
{
    return installer.toNativeSeparators("/bin/target_qt.conf");
}

qtToolchainCmake_670 = function()
{
    return installer.toNativeSeparators("/lib/cmake/Qt6/qt.toolchain.cmake");
}

qtBuildInternalsExtraCmake_670 = function()
{
    return installer.toNativeSeparators("/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake");
}

qt6DependenciesCMakePath_670 = function()
{
    return installer.toNativeSeparators("/lib/cmake/Qt6/Qt6Dependencies.cmake");
}

originalHostTargetPath_670 = function(buildHostName)
{
    return originalQtHostPath_670(buildHostName) + "/target";
}

// Qnx specific functions

originalSysroot_670 = function()
{
    return "Sysroot=.*";
}

originalInitialToolchain_670 = function(qnx_toolchain)
{
    return "/opt/qnx710/" + qnx_toolchain;
}

newSysroot_670 = function()
{
    return "Sysroot=" + installer.value("QNX710_SDP_PATH") + "/target/qnx7";
}

newInitialToolchain_670 = function(qnx_toolchain)
{
    return "/" + qnx_toolchain;
}

sdpDirectoryPath_670 = function()
{
    return installer.value("QNX710_SDP_PATH");
}

// Functions that return a value based on what the original packages are build on

originalSetCmakePath_670 = function(buildHostName)
{
    if (originalHostOS_670(buildHostName) === "macOS") {
        return "/Applications/CMake.app/Contents/bin/cmake";
    }
    else if (originalHostOS_670(buildHostName) === "Windows") {
        return "C:/CMake/bin/cmake.exe";
    }
    else {
        return "/opt/cmake-*.*.*/bin/cmake";
    }
}

originalHostSpec_670 = function(buildHostName)
{
    if (originalHostOS_670(buildHostName) === "macOS") {
        return "macx-clang";
    }
    else if (originalHostOS_670(buildHostName) === "Windows") {
        return "win32-g++";
    }
    else {
        return "linux-g++";
    }
}

originalBIPrefix_670 = function(qt_version, buildHostName)
{
    if (originalHostOS_670(buildHostName) === "macOS") {
        return "/usr/local/Qt-" + qt_version;
    }
    else if (originalHostOS_670(buildHostName) === "Windows") {
        return "C:/Qt/Qt-" + qt_version;
    }
    else {
        return "/usr/local/Qt-" + qt_version;
    }
}

originalHostBinPath_670 = function(buildHostName)
{
     // Packages from windows has unix path separator until Qt 6.5.0 release.
    // After that it will have windows style one
    if (originalHostOS_670(buildHostName) === "Windows" && 67 >= 65) {
        return "\\Users\\qt\\work\\install\\bin";
    }
    else {
        return  originalQtHostPath_670(buildHostName) + "/bin";
    }
}

// Functions that return values used in patching

newQtHostPath_670 = function(qt_version, buildHostName)
{
    var buildTarget = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.value("TargetDir") + "/" + qt_version + "/gcc_arm64";
        else
            return installer.value("TargetDir") + "/" + qt_version + "/gcc_64";
    }
    else if (installer.value("os") === "win") {
        if (buildTarget.includes("msvc2019")) {
            return installer.value("TargetDir") + "/" + qt_version + "/msvc2019_64";
        }
        else {
            return installer.value("TargetDir") + "/" + qt_version + "/mingw_64";
        }
    }
    else {
        return installer.value("TargetDir") + "/" + qt_version + "/macos";
    }
}

qtCMakePrivateScript_670 = function()
{
    if (installer.value("os") === "x11") {
        return "/libexec/qt-cmake-private";
    }
    else if (installer.value("os") === "mac") {
        return "/libexec/qt-cmake-private";
    }
    else {
        return "\\bin\\qt-cmake-private.bat";
    }
}

qtCMakeStandaloneTestScript_670 = function()
{
    if (installer.value("os") === "x11") {
        return "/libexec/qt-cmake-standalone-test";
    }
    else if (installer.value("os") === "mac") {
        return "/libexec/qt-cmake-standalone-test";
    }
    else {
        return "\\bin\\qt-cmake-standalone-test";
    }
}

qtPathsScript_670 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qtpaths.bat";
    }
    else {
        return "/bin/qtpaths";
    }
}

qtPaths6Script_670 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qtpaths6.bat";
    }
    else {
        return "/bin/qtpaths6";
    }
}

qtCMakeScript_670 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qt-cmake.bat";
    }
    else {
        return "/bin/qt-cmake";
    }
}

qmakeScript_670 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qmake.bat";
    }
    else {
        return "/bin/qmake";
    }
}

qmake6Script_670 = function()
{
    if (installer.value("os") === "win") {
        return "\\bin\\qmake6.bat";
    }
    else {
        return "/bin/qmake6";
    }
}

// Return a value based on targer_arch

newHostData_670 = function(target_arch)
{
    if (target_arch === "singlethread" || target_arch === "multithread") {
        return "HostData=../wasm_" + target_arch;
    }
    else {
        return "HostData=../android_" + target_arch;
    }
}

// Return variables used for patching

newQtPathsPath_670 = function(qt_version, buildHostName)
{
    var buildTarget = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/gcc_arm64/bin/qtpaths");
        else
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/gcc_64/bin/qtpaths");
    }
    else if (installer.value("os") === "win") {
        // Check if we are using msvc2019 component
        if (buildTarget.includes("msvc2019")) {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/msvc2019_64/bin/qtpaths");
        }
        else {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/mingw_64/bin/qtpaths");
        }
    }
    else {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/macos/bin/qtpaths");
    }
}

newQmakePath_670 = function(qt_version, buildHostName)
{
    var buildTarget = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/gcc_arm64/bin/qmake");
        else
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/gcc_64/bin/qmake");
    }

    else if (installer.value("os") === "win") {
        if (buildTarget.includes("msvc2019")) {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/msvc2019_64/bin/qmake");
        }
        else {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/mingw_64/bin/qmake");
        }
    }
    else {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/macos/bin/qmake");
    }
}

newHostPrefix_670 = function(buildHostName)
{
    var prefix = buildHostName.toLowerCase();

    if (installer.value("os") === "x11") {
        if (systemInfo.currentCpuArchitecture == "arm64")
            return "HostPrefix=../../gcc_arm64";
        else
            return "HostPrefix=../../gcc_64";
    }
    else if (installer.value("os") === "win") {
        if (prefix.includes("msvc2019")) {
            return "HostPrefix=../../msvc2019_64";
        }
        else {
            return "HostPrefix=../../mingw_64";
        }
    }
    else {
        return "HostPrefix=../../macos";
    }
}

platformIdentification_670 = function()
{
    if (installer.value("os") === "x11") {
        return "linux";
    }
    else if (installer.value("os") === "mac") {
        return "mac";
    }
    else if (installer.value("os") === "win") {
        return "windows";
    }
    else {
        console.log("platform not identified = " + installer.value("os"));
        return
    }
}

fromWindowsToUnixFlag_670 = function(buildHostName)
{
    // We don't need to add additional execute rules in windows environment
    if (installer.value("os") === "win") {
        return false;
    }
    // Set a flag to indicate that host build is from a windows
    else if (originalHostOS_670(buildHostName) === "Windows") {
        return true;
    }
    else {
        return false;
    }
}

newHostSpec_670 = function()
{
    if (installer.value("os") === "x11") {
        return "linux-g++";
    }
    else if (installer.value("os") === "mac") {
        return "macx-clang";
    }
    else {
        return "win32-g++";
    }
}

newNDKHost_670 = function()
{
    if (installer.value("os") === "x11") {
        return "linux-x86_64";
    }
    else if (installer.value("os") === "mac") {
        return "darwin-x86_64";
    }
    else {
        return "windows-x86_64";
     }
}

newHostLibExecutables_670 = function()
{
    if (installer.value("os") === "win") {
        return "./bin";
    }
    else {
        return "./libexec";
    }
}

newSetCMakePath_670 = function()
{
    if (installer.value("os") === "win") {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/Tools/CMake_64/bin/cmake.exe");
    }
    else if (installer.value("os") === "mac") {
        return installer.value("TargetDir") + "/Tools/CMake/CMake.app/Contents/bin/cmake";
    }
    else {
        return installer.value("TargetDir") + "/Tools/CMake/bin/cmake";
    }
}

originalQmakePath_670 = function(buildHostName)
{
    if (installer.value("os") === "win") {
        return originalHostBinPath_670(buildHostName) + "\\qmake";
    }
    else {
        return originalHostBinPath_670(buildHostName) + "/qmake";
    }
}

originalQtPathsPath_670 = function(buildHostName)
{
    if (installer.value("os") === "win") {
        return originalHostBinPath_670(buildHostName) + "\\qtpaths";
    }
    else {
        return originalHostBinPath_670(buildHostName) + "/qtpaths";
    }
}

// Qt-configure-module functions (Temporary here, will be removed from future versions)
original_QtProcessConfigureArgsCmakePath_670 = function()
{
    return "/..\\lib\\cmake\\Qt6/QtProcessConfigureArgs.cmake";
}

new_QtProcessConfigureArgsCmakePath_670 = function()
{
    return "/../lib/cmake/Qt6/QtProcessConfigureArgs.cmake";
}

