/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui/qopenglcontext.h>
#include <QtGui/private/qguiapplication_p.h>
#include <QtGui/private/qwindowsmime_p.h>
#include <qpa/qplatformopenglcontext.h>
#include <qpa/qplatformintegration.h>
#include <qpa/qplatformwindow.h>
#include <qpa/qplatformwindow_p.h>

QT_BEGIN_NAMESPACE

using namespace QNativeInterface::Private;

#ifndef QT_NO_OPENGL

/*!
    \class QNativeInterface::QWGLContext
    \inheaderfile QOpenGLContext
    \since 6.0
    \brief Native interface to a WGL context on Windows.

    Accessed through QOpenGLContext::nativeInterface().

    \inmodule QtGui
    \ingroup native-interfaces
    \ingroup native-interfaces-qopenglcontext
*/

/*!
    \fn QOpenGLContext *QNativeInterface::QWGLContext::fromNative(HGLRC context, HWND window, QOpenGLContext *shareContext = nullptr)

    \brief Adopts an WGL \a context handle.

    The \a window is needed because the its pixel format will be queried. When the
    adoption is successful, QOpenGLContext::format() will return a QSurfaceFormat
    describing this pixel format.

    \note The window specified by \a window must have its pixel format set to a
    format compatible with the context's. If no SetPixelFormat() call was made on
    any device context belonging to the window, adopting the context will fail.

    Ownership of the created QOpenGLContext \a shareContext is transferred to the
    caller.
*/

/*!
    \fn HGLRC QNativeInterface::QWGLContext::nativeContext() const

    \return the underlying context handle.
*/

/*!
    \fn HMODULE QNativeInterface::QWGLContext::openGLModuleHandle()

    \return the handle for the OpenGL implementation that is currently in use.

    \note This function requires that the QGuiApplication instance is already created.
*/

QT_DEFINE_NATIVE_INTERFACE(QWGLContext, QOpenGLContext);
QT_DEFINE_PRIVATE_NATIVE_INTERFACE(QWindowsGLIntegration);

HMODULE QNativeInterface::QWGLContext::openGLModuleHandle()
{
    return QGuiApplicationPrivate::platformIntegration()->call<
        &QWindowsGLIntegration::openGLModuleHandle>();
}

QOpenGLContext *QNativeInterface::QWGLContext::fromNative(HGLRC context, HWND window, QOpenGLContext *shareContext)
{
    return QGuiApplicationPrivate::platformIntegration()->call<
        &QWindowsGLIntegration::createOpenGLContext>(context, window, shareContext);
}

#endif // QT_NO_OPENGL

/*!
    \class QNativeInterface::Private::QWindowsApplication
    \since 6.0
    \internal
    \brief Native interface to QGuiApplication, to be retrieved from QPlatformIntegration.
    \inmodule QtGui
    \ingroup native-interfaces
*/

QT_DEFINE_PRIVATE_NATIVE_INTERFACE(QWindowsApplication);

/*!
    \enum QNativeInterface::Private::QWindowsApplication::TouchWindowTouchType

    This enum represents the supported TouchWindow touch flags for registerTouchWindow().

    \value NormalTouch
    \value FineTouch
    \value WantPalmTouch
*/

/*!
    \fn void QNativeInterface::Private::QWindowsApplication::setTouchWindowTouchType(QNativeInterface::Private::QWindowsApplication::TouchWindowTouchTypes type)
    \internal

    Sets the touch window type for all windows to \a type.
*/

/*!
    \fn QNativeInterface::Private::QWindowsApplication::TouchWindowTouchTypes QNativeInterface::Private::QWindowsApplication::touchWindowTouchType() const
    \internal

    Returns the currently set the touch window type.
*/

/*!
    \enum QNativeInterface::Private::QWindowsApplication::WindowActivationBehavior

    This enum specifies the behavior of QWidget::activateWindow() and
    QWindow::requestActivate().

    \value DefaultActivateWindow The window is activated according to the default
        behavior of the Windows operating system. This means the window will not
        be activated in some circumstances (most notably when the calling process
        is not the active process); only the taskbar entry will be flashed.
    \value AlwaysActivateWindow  The window is always activated, even when the
        calling process is not the active process.

    \sa QWidget::activateWindow(), QWindow::requestActivate()
*/

/*!
    \fn void QNativeInterface::Private::QWindowsApplication::setWindowActivationBehavior(QNativeInterface::Private::QWindowsApplication::WindowActivationBehavior behavior)
    \internal

    Sets the window activation behavior to \a behavior.

    \sa QWidget::activateWindow(), QWindow::requestActivate()
*/

/*!
    \fn QNativeInterface::Private::QWindowsApplication::WindowActivationBehavior QNativeInterface::Private::QWindowsApplication::windowActivationBehavior() const
    \internal

    Returns the currently set the window activation behavior.
*/

/*!
    \fn bool QNativeInterface::Private::QWindowsApplication::isTabletMode() const
    \internal

    Returns \c true if Windows 10 operates in \e{Tablet Mode}.
    In this mode, Windows forces all application main windows to open in maximized
    state. Applications should then avoid resizing windows or restoring geometries
    to non-maximized states.

    \sa QWidget::showMaximized(), QWidget::saveGeometry(), QWidget::restoreGeometry()
*/

/*!
    \enum QNativeInterface::Private::QWindowsApplication::DarkModeHandlingFlag

    This enum specifies the behavior of the application when Windows
    is configured to use dark mode for applications.

    \value DarkModeWindowFrames The window frames will be switched to dark.
    \value DarkModeStyle        The Windows Vista style will be turned off and
                                a simple dark style will be used.

    \sa isDarkMode(), setDarkModeHandling()
*/

/*!
    \fn bool QNativeInterface::Private::QWindowsApplication::isDarkMode() const = 0
    \internal

    Returns \c true if Windows 10 is configured to use dark mode for
    applications.
*/

/*!
    \fn void QNativeInterface::Private::QWindowsApplication::setDarkModeHandling(DarkModeHandling handling) = 0
    \internal

    Sets the dark mode handling to \a handling.
*/

/*!
    \fn QNativeInterface::Private::QWindowsApplication::DarkModeHandling QNativeInterface::Private::QWindowsApplication::darkModeHandling() const
    \internal

    Returns the currently set dark mode handling.
*/

/*!
    \fn bool QNativeInterface::Private::QWindowsApplication::isWinTabEnabled() const = 0
    \internal

    Returns whether the \e{Tablet WinTab Driver} (\c Wintab32.dll) is used.
*/

/*!
    \fn bool QNativeInterface::Private::QWindowsApplication::setWinTabEnabled(bool enabled)
    \internal

    Sets whether the \e{Tablet WinTab Driver} (\c Wintab32.dll) should be used to \a enabled.

    Returns \c true on success, \c false otherwise.
*/

/*!
    \fn bool QNativeInterface::Private::QWindowsApplication::registerMime(QWindowsMime *mime)
    \internal

    Registers the converter \a mime to the system.

    \sa QNativeInterface::Private::QWindowsMime, unregisterMime()
*/

/*!
    \fn void QNativeInterface::Private::QWindowsApplication::unregisterMime(QWindowsMime *mime)
    \internal

    Unregisters the converter \a mime from the system.

    \sa QNativeInterface::Private::QWindowsMime, registerMime()
*/

/*!
    \fn int QNativeInterface::Private::QWindowsApplication::registerMimeType(const QString &mime)
    \internal

    Registers the MIME type \a mime, and returns an ID number
    identifying the format on Windows.
*/

/*!
    \fn HWND QNativeInterface::Private::QWindowsApplication::createMessageWindow(const QString &, const QString &, QFunctionPointer) const
    \internal
*/

/*!
    \fn bool QNativeInterface::Private::QWindowsApplication::asyncExpose() const
    \internal
*/

/*!
    \fn void QNativeInterface::Private::QWindowsApplication::setAsyncExpose(bool)
    \internal
*/

/*!
    \fn QVariant QNativeInterface::Private::QWindowsApplication::gpu()
    \internal
*/

/*!
    \fn QVariant QNativeInterface::Private::QWindowsApplication::gpuList()
    \internal
*/

/*!
    \class QNativeInterface::Private::QWindowsWindow
    \since 6.0
    \internal
    \brief Native interface to QPlatformWindow.
    \inmodule QtGui
    \ingroup native-interfaces
*/

QT_DEFINE_PRIVATE_NATIVE_INTERFACE(QWindowsWindow);

/*!
    \fn void QNativeInterface::Private::QWindowsWindow::setHasBorderInFullScreen(bool border)
    \internal

    Sets whether the WS_BORDER flag will be set for the window in full screen mode
    to \a border.

    See also \l [QtDoc] {Fullscreen OpenGL Based Windows}
*/

/*!
    \fn bool QNativeInterface::Private::QWindowsWindow::hasBorderInFullScreen() const
    \internal

    Returns whether the WS_BORDER flag will be set for the window in full screen
    mode.
*/

/*!
    \fn QMargins QNativeInterface::Private::QWindowsWindow::customMargins() const
    \internal

    Returns the margin to be used when handling the \c WM_NCCALCSIZE message.
*/

/*!
    \fn void QNativeInterface::Private::QWindowsWindow::setCustomMargins(const QMargins &margins)
    \internal

    Sets the\a  margins to be used when handling the \c WM_NCCALCSIZE message. It is
    possible to remove a frame border by specifying a negative value.
*/

QT_END_NAMESPACE
