/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasupport;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class Utils {
    public static final RequestProcessor FILE_QUEUE = new RequestProcessor("File Queue");
    private static final int COPY_PACKET_SIZE = 16384;
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    public static <X, Y> boolean containsSubclass(Set<? extends Class<? extends Y>> classes, X superclassInstance) {
        for (Class<Y> classs : classes) {
            if (!classs.isInstance(superclassInstance)) continue;
            return true;
        }
        return false;
    }

    public static <X, Y> boolean containsSuperclass(Set<? extends Class<? extends Y>> classes, X subclassInstance) {
        Class<?> subclass = subclassInstance.getClass();
        for (Class<Y> classs : classes) {
            if (!classs.isAssignableFrom(subclass)) continue;
            return true;
        }
        return false;
    }

    public static <X, Y extends X, Z extends X> Set<Z> getFilteredSet(Set<Y> set, Class<Z> filter) {
        HashSet<Y> filteredSet = new HashSet<Y>();
        for (Y item : set) {
            if (!filter.isInstance(item)) continue;
            filteredSet.add(item);
        }
        return filteredSet;
    }

    public static <X extends DataSource> List<X> getSortedDataSources(Set<X> dataSources) {
        List<DataSourcePath<X>> dataSourcePaths = Utils.getSortedDataSourcePaths(dataSources);
        ArrayList<X> sortedDataSources = new ArrayList<X>();
        for (DataSourcePath<X> dataSourcePath : dataSourcePaths) {
            sortedDataSources.add(dataSourcePath.getDataSource());
        }
        return sortedDataSources;
    }

    public static <X extends DataSource> boolean areDataSourcesIndependent(Set<X> dataSources) {
        return dataSources.size() == Utils.getIndependentDataSources(dataSources).size();
    }

    public static <X extends DataSource> Set<X> getIndependentDataSources(Set<X> dataSources) {
        HashMap<Integer, HashSet<X>> independentDataSourcesMap = new HashMap<Integer, HashSet<X>>();
        List<DataSourcePath<X>> dataSourcePaths = Utils.getSortedDataSourcePaths(dataSources);
        for (DataSourcePath<X> dataSourcePath : dataSourcePaths) {
            boolean independent = true;
            for (int i = 0; i < dataSourcePath.size(); ++i) {
                DataSource dataSource = (DataSource)dataSourcePath.get(i);
                Set set = (Set)independentDataSourcesMap.get(i);
                if (set == null || !set.contains(dataSource)) continue;
                independent = false;
                break;
            }
            if (!independent) continue;
            HashSet<X> set = (HashSet<X>)independentDataSourcesMap.get(dataSourcePath.size() - 1);
            if (set == null) {
                set = new HashSet<X>();
                independentDataSourcesMap.put(dataSourcePath.size() - 1, set);
            }
            set.add(dataSourcePath.getDataSource());
        }
        HashSet independentDataSources = new HashSet();
        Collection independentSetsCollection = independentDataSourcesMap.values();
        for (Set independentSet : independentSetsCollection) {
            independentDataSources.addAll(independentSet);
        }
        return independentDataSources;
    }

    private static <X extends DataSource> List<DataSourcePath<X>> getSortedDataSourcePaths(Set<X> dataSources) {
        ArrayList<DataSourcePath<X>> dataSourcePaths = new ArrayList<DataSourcePath<X>>();
        for (DataSource dataSource : dataSources) {
            dataSourcePaths.add(new DataSourcePath<DataSource>(dataSource));
        }
        Collections.sort(dataSourcePaths);
        return dataSourcePaths;
    }

    public static String getFileBase(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, extIndex);
    }

    public static String getFileExt(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex == -1) {
            return "";
        }
        return fileName.substring(extIndex);
    }

    public static File getUniqueFile(File directory, String file) {
        return Utils.getUniqueFile(directory, Utils.getFileBase(file), Utils.getFileExt(file));
    }

    public static synchronized File getUniqueFile(File directory, String fileName, String fileExt) {
        File newFile = new File(directory, fileName + fileExt);
        while (newFile.exists()) {
            fileName = fileName + "_";
            newFile = new File(directory, fileName + fileExt);
        }
        return newFile;
    }

    public static synchronized boolean prepareDirectory(File directory) {
        if (directory.exists()) {
            return true;
        }
        directory.mkdirs();
        return directory.exists();
    }

    /*
     * Exception decompiling
     */
    public static boolean copyFile(File file, File copy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean delete(File file, boolean deleteOnExit) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File file1 : files = file.listFiles()) {
                Utils.delete(file1, deleteOnExit);
            }
        }
        if (!file.delete()) {
            if (Utilities.isWindows() && file.isFile()) {
                for (int i = 0; i < 5; ++i) {
                    System.gc();
                    if (!file.delete()) continue;
                    return true;
                }
            }
            if (deleteOnExit) {
                file.deleteOnExit();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createArchive(File directory, File archive) {
        File[] contents = directory.listFiles();
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive));){
            for (File file : contents) {
                if (!file.isFile()) continue;
                zos.putNextEntry(new ZipEntry(file.getName()));
                try (FileInputStream fis = new FileInputStream(file);){
                    int bytes;
                    byte[] packet = new byte[16384];
                    while ((bytes = fis.read(packet, 0, 16384)) != -1) {
                        zos.write(packet, 0, bytes);
                    }
                }
                finally {
                    if (zos != null) {
                        zos.closeEntry();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating archive", e);
        }
    }

    public static File extractArchive(File archive, File destination) {
        File directory = Utils.getUniqueFile(destination, archive.getName());
        try (ZipFile zipFile = new ZipFile(archive);){
            String destinationPath = directory.getCanonicalPath();
            Utils.prepareDirectory(directory);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryFile = new File(directory, entry.getName());
                String entryFilePath = entryFile.getCanonicalPath();
                if (!entryFilePath.startsWith(destinationPath)) {
                    throw new IllegalStateException("Archive entry outside of destination directory: " + entryFilePath);
                }
                FileOutputStream fos = new FileOutputStream(entryFile);
                Throwable throwable = null;
                try {
                    InputStream is = zipFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        int bytes;
                        byte[] packet = new byte[16384];
                        while ((bytes = is.read(packet, 0, 16384)) != -1) {
                            fos.write(packet, 0, bytes);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable2 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error extracting archive", e);
            return null;
        }
        return directory;
    }

    public static String encodePassword(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes());
    }

    public static char[] encodePassword(char[] value) {
        byte[] bytes = Utils.charsToBytes(value);
        Arrays.fill(value, '\u0000');
        byte[] bytes2 = Base64.getEncoder().encode(bytes);
        Arrays.fill(bytes, (byte)0);
        char[] chars = Utils.bytesToChars(bytes2);
        Arrays.fill(bytes2, (byte)0);
        return chars;
    }

    public static String decodePassword(String value) {
        return new String(Base64.getDecoder().decode(value));
    }

    public static char[] decodePassword(char[] value) {
        byte[] bytes = Utils.charsToBytes(value);
        Arrays.fill(value, '\u0000');
        byte[] bytes2 = Base64.getDecoder().decode(bytes);
        Arrays.fill(bytes, (byte)0);
        char[] chars = Utils.bytesToChars(bytes2);
        Arrays.fill(bytes2, (byte)0);
        return chars;
    }

    public static String imageToString(Image image, String format) {
        byte[] imageBytes = Utils.imageToBytes(image, format);
        return imageBytes != null ? Base64.getEncoder().encodeToString(imageBytes) : null;
    }

    public static Image stringToImage(String string) {
        return Toolkit.getDefaultToolkit().createImage(Base64.getDecoder().decode(string));
    }

    private static BufferedImage imageToBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        bufferedImage.createGraphics().drawImage(image, null, null);
        return bufferedImage;
    }

    private static byte[] imageToBytes(Image image, String format) {
        BufferedImage bufferedImage = Utils.imageToBuffered(image);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, format, outputStream);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, Utils.class.getName() + "imageToBytes", e);
            return null;
        }
        return outputStream.toByteArray();
    }

    private static byte[] charsToBytes(char[] chars) {
        byte[] bytes = new byte[chars.length * 2];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i * 2] = (byte)((chars[i] & 0xFF00) >> 8);
            bytes[i * 2 + 1] = (byte)(chars[i] & 0xFF);
        }
        return bytes;
    }

    private static char[] bytesToChars(byte[] bytes) {
        char[] chars = new char[bytes.length / 2];
        for (int i = 0; i < chars.length; ++i) {
            char ch;
            chars[i] = ch = (char)(((bytes[i * 2] & 0xFF) << 8) + (bytes[i * 2 + 1] & 0xFF));
        }
        return chars;
    }

    private static class DataSourcePath<X extends DataSource>
    extends ArrayList<DataSource>
    implements Comparable<DataSourcePath> {
        DataSourcePath(X dataSource) {
            for (Object ds = dataSource; ds != null; ds = ((DataSource)ds).getOwner()) {
                this.add(0, ds);
            }
        }

        @Override
        public int compareTo(DataSourcePath dataSourcePath) {
            int thisSize = this.size();
            return Integer.compare(thisSize, dataSourcePath.size());
        }

        public X getDataSource() {
            return (X)((DataSource)this.get(this.size() - 1));
        }
    }
}

