﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ecs/ECS_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ECS {
namespace Model {
class ListTasksResult {
 public:
  AWS_ECS_API ListTasksResult() = default;
  AWS_ECS_API ListTasksResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ECS_API ListTasksResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of task ARN entries for the <code>ListTasks</code> request.</p>
   */
  inline const Aws::Vector<Aws::String>& GetTaskArns() const { return m_taskArns; }
  template <typename TaskArnsT = Aws::Vector<Aws::String>>
  void SetTaskArns(TaskArnsT&& value) {
    m_taskArnsHasBeenSet = true;
    m_taskArns = std::forward<TaskArnsT>(value);
  }
  template <typename TaskArnsT = Aws::Vector<Aws::String>>
  ListTasksResult& WithTaskArns(TaskArnsT&& value) {
    SetTaskArns(std::forward<TaskArnsT>(value));
    return *this;
  }
  template <typename TaskArnsT = Aws::String>
  ListTasksResult& AddTaskArns(TaskArnsT&& value) {
    m_taskArnsHasBeenSet = true;
    m_taskArns.emplace_back(std::forward<TaskArnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>nextToken</code> value to include in a future
   * <code>ListTasks</code> request. When the results of a <code>ListTasks</code>
   * request exceed <code>maxResults</code>, this value can be used to retrieve the
   * next page of results. This value is <code>null</code> when there are no more
   * results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTasksResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTasksResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_taskArns;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_taskArnsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ECS
}  // namespace Aws
