/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.DefaultNameValuePair;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StructuralNodeModifier;

public class StandardParameterParser
implements ParameterParser {
    private static final String CONFIG_KV_PAIR_SEPARATORS = "kvps";
    private static final String CONFIG_KV_SEPARATORS = "kvs";
    private static final String CONFIG_STRUCTURAL_PARAMS = "struct";
    private static final String DEFAULT_KV_PAIR_SEPARATOR = "&";
    private static final String DEFAULT_KV_SEPARATOR = "=";
    private Context context;
    private Pattern keyValuePairSeparatorPattern;
    private Pattern keyValueSeparatorPattern;
    private String keyValuePairSeparators;
    private String keyValueSeparators;
    private List<String> structuralParameters = new ArrayList<String>();
    private static Logger log = LogManager.getLogger(StandardParameterParser.class);

    public StandardParameterParser(String keyValuePairSeparators, String keyValueSeparators) throws PatternSyntaxException {
        this.setKeyValuePairSeparators(keyValuePairSeparators);
        this.setKeyValueSeparators(keyValueSeparators);
    }

    public StandardParameterParser() {
        this(DEFAULT_KV_PAIR_SEPARATOR, DEFAULT_KV_SEPARATOR);
    }

    private Pattern getKeyValuePairSeparatorPattern() {
        return this.keyValuePairSeparatorPattern;
    }

    private Pattern getKeyValueSeparatorPattern() {
        return this.keyValueSeparatorPattern;
    }

    @Override
    public void init(String config) {
        if (config == null || config.isEmpty()) {
            this.setKeyValuePairSeparators(DEFAULT_KV_PAIR_SEPARATOR);
            this.setKeyValueSeparators(DEFAULT_KV_SEPARATOR);
            this.structuralParameters.clear();
            return;
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)config);
            this.setKeyValuePairSeparators(json.getString(CONFIG_KV_PAIR_SEPARATORS));
            this.setKeyValueSeparators(json.getString(CONFIG_KV_SEPARATORS));
            JSONArray ja = json.getJSONArray(CONFIG_STRUCTURAL_PARAMS);
            for (Object obj : ja.toArray()) {
                this.structuralParameters.add(obj.toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getConfig() {
        JSONObject json = new JSONObject();
        json.put((Object)CONFIG_KV_PAIR_SEPARATORS, (Object)this.getKeyValuePairSeparators());
        json.put((Object)CONFIG_KV_SEPARATORS, (Object)this.getKeyValueSeparators());
        JSONArray ja = new JSONArray();
        ja.addAll(this.structuralParameters);
        json.put((Object)CONFIG_STRUCTURAL_PARAMS, (Object)ja);
        return json.toString();
    }

    @Override
    @Deprecated
    public Map<String, String> getParams(HttpMessage msg, HtmlParameter.Type type) {
        if (msg == null) {
            return new HashMap<String, String>();
        }
        switch (type) {
            case form: {
                return this.parse(msg.getRequestBody().toString());
            }
            case url: {
                return StandardParameterParser.convertParametersList(this.parseParameters(msg.getRequestHeader().getURI().getEscapedQuery()));
            }
        }
        throw new InvalidParameterException("Type not supported: " + (Object)((Object)type));
    }

    private static Map<String, String> convertParametersList(List<NameValuePair> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair parameter : parameters) {
            String value = parameter.getValue();
            if (value == null) {
                value = "";
            }
            map.put(parameter.getName(), value);
        }
        return map;
    }

    @Override
    public List<NameValuePair> getParameters(HttpMessage msg, HtmlParameter.Type type) {
        if (msg == null) {
            throw new IllegalArgumentException("Parameter msg must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type must not be null.");
        }
        switch (type) {
            case form: {
                return this.parseParameters(msg.getRequestBody().toString());
            }
            case url: {
                String query = msg.getRequestHeader().getURI().getEscapedQuery();
                if (query == null) {
                    return new ArrayList<NameValuePair>(0);
                }
                return this.parseParameters(query);
            }
        }
        throw new IllegalArgumentException("The provided type is not supported: " + (Object)((Object)type));
    }

    private void setKeyValueSeparatorPattern(Pattern keyValueSeparatorPattern) {
        this.keyValueSeparatorPattern = keyValueSeparatorPattern;
    }

    private void setKeyValuePairSeparatorPattern(Pattern keyValuePairSeparatorPattern) {
        this.keyValuePairSeparatorPattern = keyValuePairSeparatorPattern;
    }

    public String getKeyValuePairSeparators() {
        return this.keyValuePairSeparators;
    }

    public void setKeyValuePairSeparators(String keyValuePairSeparators) throws PatternSyntaxException {
        this.setKeyValuePairSeparatorPattern(Pattern.compile("[" + keyValuePairSeparators + "]"));
        this.keyValuePairSeparators = keyValuePairSeparators;
    }

    public String getKeyValueSeparators() {
        return this.keyValueSeparators;
    }

    public void setKeyValueSeparators(String keyValueSeparators) throws PatternSyntaxException {
        this.setKeyValueSeparatorPattern(Pattern.compile("[" + keyValueSeparators + "]"));
        this.keyValueSeparators = keyValueSeparators;
    }

    @Override
    public String getDefaultKeyValuePairSeparator() {
        if (this.keyValuePairSeparators != null && this.keyValuePairSeparators.length() > 0) {
            return this.keyValuePairSeparators.substring(0, 1);
        }
        return DEFAULT_KV_PAIR_SEPARATOR;
    }

    @Override
    public String getDefaultKeyValueSeparator() {
        if (this.keyValueSeparators != null && this.keyValueSeparators.length() > 0) {
            return this.keyValueSeparators.substring(0, 1);
        }
        return DEFAULT_KV_SEPARATOR;
    }

    public List<String> getStructuralParameters() {
        return Collections.unmodifiableList(this.structuralParameters);
    }

    public void setStructuralParameters(List<String> structuralParameters) {
        this.structuralParameters.clear();
        this.structuralParameters.addAll(structuralParameters);
    }

    @Override
    @Deprecated
    public Map<String, String> parse(String paramStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (paramStr != null) {
            String[] keyValue;
            for (String s : keyValue = this.getKeyValuePairSeparatorPattern().split(paramStr)) {
                try {
                    String[] keyEqValue = this.getKeyValueSeparatorPattern().split(s);
                    if (keyEqValue.length == 1) {
                        map.put(keyEqValue[0], "");
                        continue;
                    }
                    if (keyEqValue.length <= 1) continue;
                    map.put(keyEqValue[0], keyEqValue[1]);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return map;
    }

    @Override
    public List<NameValuePair> parseParameters(String parameters) {
        return this.createParameters(parameters, (name, value) -> {
            String decodedName = StandardParameterParser.urlDecode(name);
            String decodedValue = value != null ? StandardParameterParser.urlDecode(value) : "";
            return new DefaultNameValuePair(decodedName, decodedValue);
        });
    }

    private List<NameValuePair> createParameters(String parameters, BiFunction<String, String, NameValuePair> nameValuePairFactory) {
        String[] pairs;
        if (parameters == null) {
            return new ArrayList<NameValuePair>(0);
        }
        ArrayList<NameValuePair> parametersList = new ArrayList<NameValuePair>();
        for (String pair : pairs = this.getKeyValuePairSeparatorPattern().split(parameters)) {
            String[] nameValuePair = this.getKeyValueSeparatorPattern().split(pair, 2);
            String name = nameValuePair[0];
            String value = nameValuePair.length == 1 ? null : nameValuePair[1];
            parametersList.add(nameValuePairFactory.apply(name, value));
        }
        return parametersList;
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (IllegalArgumentException e) {
            return value;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    @Override
    public List<NameValuePair> parseRawParameters(String parameters) {
        return this.createParameters(parameters, DefaultNameValuePair::new);
    }

    @Override
    public StandardParameterParser clone() {
        StandardParameterParser spp = new StandardParameterParser(this.getKeyValuePairSeparators(), this.getKeyValueSeparators());
        spp.setStructuralParameters(this.getStructuralParameters());
        return spp;
    }

    @Override
    public List<String> getTreePath(URI uri) throws URIException {
        return this.getTreePath(uri, true);
    }

    private List<String> getTreePath(URI uri, boolean incStructParams) throws URIException {
        String path = uri.getPath();
        ArrayList<String> list = new ArrayList<String>();
        if (path != null) {
            Context context = this.getContext();
            if (context != null) {
                String uriStr = uri.toString();
                boolean changed = false;
                for (StructuralNodeModifier ddn : context.getDataDrivenNodes()) {
                    Matcher m = ddn.getPattern().matcher(uriStr);
                    if (!m.find()) continue;
                    if (m.groupCount() == 3) {
                        path = m.group(1) + "\u00ab" + ddn.getName() + "\u00bb" + m.group(3);
                        if (!path.startsWith("/")) {
                            path = "/" + path;
                        }
                        changed = true;
                        continue;
                    }
                    if (m.groupCount() != 2) continue;
                    path = m.group(1) + "\u00ab" + ddn.getName() + "\u00bb";
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    changed = true;
                }
                if (changed) {
                    log.debug("Changed path from " + uri.getPath() + " to " + path);
                }
            }
            String[] pathList = path.split("/");
            for (int i = 1; i < pathList.length; ++i) {
                list.add(pathList[i]);
            }
            if (path.endsWith("/")) {
                list.add("/");
            }
        }
        if (incStructParams) {
            Map<String, String> urlParams = StandardParameterParser.convertParametersList(this.parseParameters(uri.getEscapedQuery()));
            ArrayList<String> keys = new ArrayList<String>(urlParams.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                if (!this.structuralParameters.contains(key)) continue;
                list.add(urlParams.get(key));
            }
        }
        return list;
    }

    @Override
    public List<String> getTreePath(HttpMessage msg) throws URIException {
        URI uri = msg.getRequestHeader().getURI();
        List<String> list = this.getTreePath(uri);
        List<NameValuePair> formParams = this.parseParameters(msg.getRequestBody().toString());
        formParams.stream().map(NameValuePair::getName).filter(this.structuralParameters::contains).sorted().forEach(list::add);
        return list;
    }

    @Override
    public String getAncestorPath(URI uri, int depth) throws URIException {
        String path = uri.getPath();
        if (depth == 0 || path == null) {
            return "";
        }
        List<String> pathList = this.getTreePath(uri, false);
        StringBuilder parentPath = new StringBuilder(path.length());
        for (int i = 0; i < pathList.size() && depth > 0; ++i, --depth) {
            String element = pathList.get(i);
            parentPath.append('/');
            if (element.startsWith("\u00ab")) {
                parentPath.append("(.+?)");
                continue;
            }
            parentPath.append(element);
        }
        if (depth == 0 || this.structuralParameters.isEmpty()) {
            return parentPath.toString();
        }
        boolean firstElement = true;
        Map<String, String> urlParams = StandardParameterParser.convertParametersList(this.parseParameters(uri.getEscapedQuery()));
        for (Map.Entry<String, String> param : urlParams.entrySet()) {
            if (!this.structuralParameters.contains(param.getKey())) continue;
            if (firstElement) {
                firstElement = false;
                parentPath.append('?');
            } else {
                parentPath.append(this.keyValuePairSeparators);
            }
            parentPath.append(param.getKey()).append(this.keyValueSeparators).append(param.getValue());
            if (--depth != 0) continue;
            break;
        }
        return parentPath.toString();
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

