/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.response;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.InvalidMessageDataException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class ResponseByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    private static final Logger logger = LogManager.getLogger(ResponseByteHttpPanelViewModel.class);

    @Override
    public byte[] getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return new byte[0];
        }
        byte[] headerBytes = this.httpMessage.getResponseHeader().toString().getBytes();
        byte[] bodyBytes = this.httpMessage.getResponseBody().getBytes();
        byte[] bytes = new byte[headerBytes.length + bodyBytes.length];
        System.arraycopy(headerBytes, 0, bytes, 0, headerBytes.length);
        System.arraycopy(bodyBytes, 0, bytes, headerBytes.length, bodyBytes.length);
        return bytes;
    }

    @Override
    public void setData(byte[] data) {
        if (this.httpMessage == null) {
            return;
        }
        int pos = HttpPanelViewModelUtils.findHeaderLimit(data);
        if (pos == -1) {
            logger.warn("Could not Save Header, limit not found. Header: " + new String(data));
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.notfound"));
        }
        try {
            this.httpMessage.setResponseHeader(new String(data, 0, pos));
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn("Could not Save Header: " + Arrays.toString(data), (Throwable)e);
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
        this.httpMessage.getResponseBody().setBody(ArrayUtils.subarray((byte[])data, (int)pos, (int)data.length));
    }
}

