/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import java.util.regex.Pattern;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.brk.AbstractBreakPointMessage;
import org.zaproxy.zap.extension.httppanel.Message;

public class HttpBreakpointMessage
extends AbstractBreakPointMessage {
    private static final Logger logger = LogManager.getLogger(HttpBreakpointMessage.class);
    private static final String TYPE = "HTTP";
    private String string;
    private Pattern pattern;
    private Location location;
    private Match match;
    private boolean inverse;
    private boolean ignoreCase;

    public HttpBreakpointMessage(String string, Location location, Match match, boolean inverse, boolean ignoreCase) {
        this.string = string;
        this.location = location;
        this.match = match;
        this.inverse = inverse;
        this.ignoreCase = ignoreCase;
        this.compilePattern();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String str) {
        this.string = str;
        this.compilePattern();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Match getMatch() {
        return this.match;
    }

    public void setMatch(Match match) {
        this.match = match;
        this.compilePattern();
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.compilePattern();
    }

    @Override
    public boolean match(Message aMessage, boolean isRequest, boolean onlyIfInScope) {
        if (aMessage instanceof HttpMessage) {
            HttpMessage message = (HttpMessage)aMessage;
            try {
                String src;
                String uri = message.getRequestHeader().getURI().toString();
                if (onlyIfInScope && !Model.getSingleton().getSession().isInScope(uri)) {
                    return false;
                }
                switch (this.location) {
                    default: {
                        src = uri;
                        break;
                    }
                    case request_header: {
                        if (!isRequest) {
                            return false;
                        }
                        src = message.getRequestHeader().toString();
                        break;
                    }
                    case request_body: {
                        if (!isRequest) {
                            return false;
                        }
                        src = message.getRequestBody().toString();
                        break;
                    }
                    case response_header: {
                        if (isRequest) {
                            return false;
                        }
                        src = message.getResponseHeader().toString();
                        break;
                    }
                    case response_body: {
                        if (isRequest) {
                            return false;
                        }
                        src = message.getResponseBody().toString();
                    }
                }
                boolean res = Match.contains.equals((Object)this.match) ? (this.ignoreCase ? src.toLowerCase().contains(this.string.toLowerCase()) : src.contains(this.string)) : this.pattern.matcher(src).find();
                if (this.inverse) {
                    return !res;
                }
                return res;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private void compilePattern() {
        try {
            this.pattern = this.ignoreCase ? Pattern.compile(this.string, 2) : Pattern.compile(this.string);
        }
        catch (Exception e) {
            logger.debug("Potentially invalid regex", (Throwable)e);
        }
    }

    @Override
    public String getDisplayMessage() {
        return Constant.messages.getString("brk.brkpoint.location." + this.location.name()) + ": " + Constant.messages.getString("brk.brkpoint.match." + this.match.name()) + ": " + (this.ignoreCase ? Constant.messages.getString("brk.brkpoint.ignorecase.label") : "") + (this.inverse ? Constant.messages.getString("brk.brkpoint.inverse.label") : "") + this.string;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpBreakpointMessage)) {
            return false;
        }
        HttpBreakpointMessage hbm = (HttpBreakpointMessage)obj;
        return this.getString().equals(hbm.getString()) && this.getLocation().equals((Object)hbm.getLocation()) && this.getMatch().equals((Object)hbm.getMatch()) && this.isIgnoreCase() == hbm.isIgnoreCase() && this.isInverse() == hbm.isInverse();
    }

    public int hashCode() {
        return new HashCodeBuilder(349, 631).append((Object)this.string).append((Object)this.location).append((Object)this.match).append(this.ignoreCase).append(this.inverse).toHashCode();
    }

    public static enum Match {
        contains,
        regex;

    }

    public static enum Location {
        url,
        request_header,
        request_body,
        response_header,
        response_body;

    }
}

