/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.jmx.EnvironmentProvider;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.netbeans.api.keyring.Keyring;

public abstract class CredentialsProvider
extends EnvironmentProvider {
    private static final String PROPERTY_USER = "prop_credentials_user";
    private static final String PROPERTY_PWORD = "prop_credentials_pword";
    private static Persistent PERSISTENT_PROVIDER;

    static synchronized Persistent persistent() {
        if (PERSISTENT_PROVIDER == null) {
            PERSISTENT_PROVIDER = new Persistent();
        }
        return PERSISTENT_PROVIDER;
    }

    @Override
    public String getId() {
        return CredentialsProvider.class.getName();
    }

    abstract String getUsername(Storage var1);

    abstract boolean hasPassword(Storage var1);

    abstract boolean isPersistent(Storage var1);

    private static Map<String, ?> createMap(String username, char[] pword) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (username != null && !username.isEmpty()) {
            map.put("jmx.remote.credentials", new String[]{username, pword == null ? null : new String(pword)});
        }
        if (pword != null) {
            Arrays.fill(pword, '\u0000');
        }
        return map;
    }

    private static char[] encodePassword(char[] pword) {
        return pword == null ? null : Utils.encodePassword((char[])pword);
    }

    private static char[] decodePassword(char[] pword) {
        return pword == null ? null : Utils.decodePassword((char[])pword);
    }

    public static class Persistent
    extends CredentialsProvider {
        @Override
        public Map<String, ?> getEnvironment(Application application, Storage storage) {
            String user = storage.getCustomProperty(CredentialsProvider.PROPERTY_USER);
            return CredentialsProvider.createMap(user, this.getPassword(storage));
        }

        @Override
        public String getEnvironmentId(Storage storage) {
            String user;
            if (storage != null && (user = storage.getCustomProperty(CredentialsProvider.PROPERTY_USER)) != null) {
                return user;
            }
            return super.getEnvironmentId(storage);
        }

        @Override
        String getUsername(Storage storage) {
            return storage.getCustomProperty(CredentialsProvider.PROPERTY_USER);
        }

        private char[] getPassword(Storage storage) {
            String keyringId = JmxApplication.createId(null, this, storage);
            char[] pw = Keyring.read((String)keyringId);
            if (pw != null) {
                return pw;
            }
            String pword = storage.getCustomProperty(CredentialsProvider.PROPERTY_PWORD);
            if (pword != null && !pword.isEmpty()) {
                return CredentialsProvider.decodePassword(pword.toCharArray());
            }
            return null;
        }

        @Override
        boolean hasPassword(Storage storage) {
            char[] pword = this.getPassword(storage);
            return pword != null && pword.length > 0;
        }

        @Override
        boolean isPersistent(Storage storage) {
            return this.getUsername(storage) != null || this.hasPassword(storage);
        }
    }

    public static class Custom
    extends CredentialsProvider {
        private final String user;
        private final char[] pword;
        private final boolean persistent;

        public Custom(String username, char[] password, boolean persistent) {
            this.user = username;
            this.pword = CredentialsProvider.encodePassword(password);
            this.persistent = persistent;
        }

        @Override
        public Map<String, ?> getEnvironment(Application application, Storage storage) {
            return CredentialsProvider.createMap(this.user, this.getPassword(storage));
        }

        @Override
        public String getEnvironmentId(Storage storage) {
            if (this.user != null) {
                return this.user;
            }
            return super.getEnvironmentId(storage);
        }

        @Override
        public void saveEnvironment(Storage storage) {
            if (!this.persistent) {
                return;
            }
            storage.setCustomProperty(CredentialsProvider.PROPERTY_USER, this.user);
            String keyringId = JmxApplication.createId(null, this, storage);
            char[] pw = this.getPassword(storage);
            if (pw != null) {
                Keyring.save((String)keyringId, (char[])pw, (String)("VisualVM - JMX password for " + this.user));
            } else {
                Keyring.delete((String)keyringId);
            }
        }

        @Override
        String getUsername(Storage storage) {
            return this.user;
        }

        private char[] getPassword(Storage storage) {
            if (this.hasPassword(storage)) {
                return CredentialsProvider.decodePassword(Arrays.copyOf(this.pword, this.pword.length));
            }
            return null;
        }

        @Override
        boolean hasPassword(Storage storage) {
            return this.pword != null && this.pword.length > 0;
        }

        @Override
        boolean isPersistent(Storage storage) {
            return this.persistent;
        }
    }
}

