/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.AwsCredentials;
import com.google.auth.oauth2.CredentialFormatException;
import com.google.auth.oauth2.EnvironmentProvider;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdentityPoolCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.PluggableAuthCredentials;
import com.google.auth.oauth2.StsRequestHandler;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.auth.oauth2.StsTokenExchangeResponse;
import com.google.auth.oauth2.SystemEnvironmentProvider;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class ExternalAccountCredentials
extends GoogleCredentials {
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    static final String EXTERNAL_ACCOUNT_FILE_TYPE = "external_account";
    static final String EXECUTABLE_SOURCE_KEY = "executable";
    private final String transportFactoryClassName;
    private final String audience;
    private final String subjectTokenType;
    private final String tokenUrl;
    private final CredentialSource credentialSource;
    private final Collection<String> scopes;
    private final ServiceAccountImpersonationOptions serviceAccountImpersonationOptions;
    @Nullable
    private final String tokenInfoUrl;
    @Nullable
    private final String serviceAccountImpersonationUrl;
    @Nullable
    private final String clientId;
    @Nullable
    private final String clientSecret;
    @Nullable
    private final String workforcePoolUserProject;
    protected transient HttpTransportFactory transportFactory;
    @Nullable
    protected final ImpersonatedCredentials impersonatedCredentials;
    @Nullable
    private ImpersonatedCredentials impersonatedCredentialsOverride;
    private EnvironmentProvider environmentProvider;

    protected ExternalAccountCredentials(HttpTransportFactory transportFactory, String audience, String subjectTokenType, String tokenUrl, CredentialSource credentialSource, @Nullable String tokenInfoUrl, @Nullable String serviceAccountImpersonationUrl, @Nullable String quotaProjectId, @Nullable String clientId, @Nullable String clientSecret, @Nullable Collection<String> scopes) {
        this(transportFactory, audience, subjectTokenType, tokenUrl, credentialSource, tokenInfoUrl, serviceAccountImpersonationUrl, quotaProjectId, clientId, clientSecret, scopes, null);
    }

    protected ExternalAccountCredentials(HttpTransportFactory transportFactory, String audience, String subjectTokenType, String tokenUrl, CredentialSource credentialSource, @Nullable String tokenInfoUrl, @Nullable String serviceAccountImpersonationUrl, @Nullable String quotaProjectId, @Nullable String clientId, @Nullable String clientSecret, @Nullable Collection<String> scopes, @Nullable EnvironmentProvider environmentProvider) {
        super(null, quotaProjectId);
        this.transportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)transportFactory, (Object)ExternalAccountCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = (String)Preconditions.checkNotNull((Object)this.transportFactory.getClass().getName());
        this.audience = (String)Preconditions.checkNotNull((Object)audience);
        this.subjectTokenType = (String)Preconditions.checkNotNull((Object)subjectTokenType);
        this.tokenUrl = (String)Preconditions.checkNotNull((Object)tokenUrl);
        this.credentialSource = (CredentialSource)Preconditions.checkNotNull((Object)credentialSource);
        this.tokenInfoUrl = tokenInfoUrl;
        this.serviceAccountImpersonationUrl = serviceAccountImpersonationUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = scopes == null || scopes.isEmpty() ? Arrays.asList(CLOUD_PLATFORM_SCOPE) : scopes;
        this.environmentProvider = environmentProvider == null ? SystemEnvironmentProvider.getInstance() : environmentProvider;
        this.workforcePoolUserProject = null;
        this.serviceAccountImpersonationOptions = new ServiceAccountImpersonationOptions(new HashMap<String, Object>());
        ExternalAccountCredentials.validateTokenUrl(tokenUrl);
        if (serviceAccountImpersonationUrl != null) {
            ExternalAccountCredentials.validateServiceAccountImpersonationInfoUrl(serviceAccountImpersonationUrl);
        }
        this.impersonatedCredentials = this.buildImpersonatedCredentials();
    }

    protected ExternalAccountCredentials(Builder builder) {
        super(builder);
        this.transportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)builder.transportFactory, (Object)ExternalAccountCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = (String)Preconditions.checkNotNull((Object)this.transportFactory.getClass().getName());
        this.audience = (String)Preconditions.checkNotNull((Object)builder.audience);
        this.subjectTokenType = (String)Preconditions.checkNotNull((Object)builder.subjectTokenType);
        this.tokenUrl = (String)Preconditions.checkNotNull((Object)builder.tokenUrl);
        this.credentialSource = (CredentialSource)Preconditions.checkNotNull((Object)builder.credentialSource);
        this.tokenInfoUrl = builder.tokenInfoUrl;
        this.serviceAccountImpersonationUrl = builder.serviceAccountImpersonationUrl;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.scopes = builder.scopes == null || builder.scopes.isEmpty() ? Arrays.asList(CLOUD_PLATFORM_SCOPE) : builder.scopes;
        this.environmentProvider = builder.environmentProvider == null ? SystemEnvironmentProvider.getInstance() : builder.environmentProvider;
        this.serviceAccountImpersonationOptions = builder.serviceAccountImpersonationOptions == null ? new ServiceAccountImpersonationOptions(new HashMap<String, Object>()) : builder.serviceAccountImpersonationOptions;
        this.workforcePoolUserProject = builder.workforcePoolUserProject;
        if (this.workforcePoolUserProject != null && !this.isWorkforcePoolConfiguration()) {
            throw new IllegalArgumentException("The workforce_pool_user_project parameter should only be provided for a Workforce Pool configuration.");
        }
        ExternalAccountCredentials.validateTokenUrl(this.tokenUrl);
        if (this.serviceAccountImpersonationUrl != null) {
            ExternalAccountCredentials.validateServiceAccountImpersonationInfoUrl(this.serviceAccountImpersonationUrl);
        }
        this.impersonatedCredentials = this.buildImpersonatedCredentials();
    }

    ImpersonatedCredentials buildImpersonatedCredentials() {
        if (this.serviceAccountImpersonationUrl == null) {
            return null;
        }
        ExternalAccountCredentials sourceCredentials = this instanceof AwsCredentials ? AwsCredentials.newBuilder((AwsCredentials)this).setServiceAccountImpersonationUrl(null).build() : (this instanceof PluggableAuthCredentials ? PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)this).setServiceAccountImpersonationUrl(null).build() : IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)this).setServiceAccountImpersonationUrl(null).build());
        String targetPrincipal = ImpersonatedCredentials.extractTargetPrincipal(this.serviceAccountImpersonationUrl);
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setHttpTransportFactory(this.transportFactory).setTargetPrincipal(targetPrincipal).setScopes(new ArrayList<String>(this.scopes)).setLifetime(this.serviceAccountImpersonationOptions.lifetime).setIamEndpointOverride(this.serviceAccountImpersonationUrl).build();
    }

    void overrideImpersonatedCredentials(ImpersonatedCredentials credentials) {
        this.impersonatedCredentialsOverride = credentials;
    }

    @Override
    public void getRequestMetadata(URI uri, Executor executor, final RequestMetadataCallback callback) {
        super.getRequestMetadata(uri, executor, new RequestMetadataCallback(){

            public void onSuccess(Map<String, List<String>> metadata) {
                metadata = GoogleCredentials.addQuotaProjectIdToRequestMetadata(ExternalAccountCredentials.this.quotaProjectId, metadata);
                callback.onSuccess(metadata);
            }

            public void onFailure(Throwable exception) {
                callback.onFailure(exception);
            }
        });
    }

    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        Map<String, List<String>> requestMetadata = super.getRequestMetadata(uri);
        return ExternalAccountCredentials.addQuotaProjectIdToRequestMetadata(this.quotaProjectId, requestMetadata);
    }

    public static ExternalAccountCredentials fromStream(InputStream credentialsStream) throws IOException {
        return ExternalAccountCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static ExternalAccountCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull((Object)credentialsStream);
        Preconditions.checkNotNull((Object)transportFactory);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        GenericJson fileContents = (GenericJson)parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        try {
            return ExternalAccountCredentials.fromJson((Map<String, Object>)fileContents, transportFactory);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new CredentialFormatException("An invalid input stream was provided.", e);
        }
    }

    static ExternalAccountCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) {
        Preconditions.checkNotNull(json);
        Preconditions.checkNotNull((Object)transportFactory);
        String audience = (String)json.get("audience");
        String subjectTokenType = (String)json.get("subject_token_type");
        String tokenUrl = (String)json.get("token_url");
        Map credentialSourceMap = (Map)json.get("credential_source");
        String serviceAccountImpersonationUrl = (String)json.get("service_account_impersonation_url");
        String tokenInfoUrl = (String)json.get("token_info_url");
        String clientId = (String)json.get("client_id");
        String clientSecret = (String)json.get("client_secret");
        String quotaProjectId = (String)json.get("quota_project_id");
        String userProject = (String)json.get("workforce_pool_user_project");
        HashMap<String, Object> impersonationOptionsMap = (HashMap<String, Object>)json.get("service_account_impersonation");
        if (impersonationOptionsMap == null) {
            impersonationOptionsMap = new HashMap<String, Object>();
        }
        if (ExternalAccountCredentials.isAwsCredential(credentialSourceMap)) {
            return AwsCredentials.newBuilder().setHttpTransportFactory(transportFactory).setAudience(audience).setSubjectTokenType(subjectTokenType).setTokenUrl(tokenUrl).setTokenInfoUrl(tokenInfoUrl).setCredentialSource(new AwsCredentials.AwsCredentialSource(credentialSourceMap)).setServiceAccountImpersonationUrl(serviceAccountImpersonationUrl).setQuotaProjectId(quotaProjectId).setClientId(clientId).setClientSecret(clientSecret).setServiceAccountImpersonationOptions(impersonationOptionsMap).build();
        }
        if (ExternalAccountCredentials.isPluggableAuthCredential(credentialSourceMap)) {
            return PluggableAuthCredentials.newBuilder().setHttpTransportFactory(transportFactory).setAudience(audience).setSubjectTokenType(subjectTokenType).setTokenUrl(tokenUrl).setTokenInfoUrl(tokenInfoUrl).setCredentialSource(new PluggableAuthCredentials.PluggableAuthCredentialSource(credentialSourceMap)).setServiceAccountImpersonationUrl(serviceAccountImpersonationUrl).setQuotaProjectId(quotaProjectId).setClientId(clientId).setClientSecret(clientSecret).setWorkforcePoolUserProject(userProject).setServiceAccountImpersonationOptions(impersonationOptionsMap).build();
        }
        return IdentityPoolCredentials.newBuilder().setHttpTransportFactory(transportFactory).setAudience(audience).setSubjectTokenType(subjectTokenType).setTokenUrl(tokenUrl).setTokenInfoUrl(tokenInfoUrl).setCredentialSource(new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap)).setServiceAccountImpersonationUrl(serviceAccountImpersonationUrl).setQuotaProjectId(quotaProjectId).setClientId(clientId).setClientSecret(clientSecret).setWorkforcePoolUserProject(userProject).setServiceAccountImpersonationOptions(impersonationOptionsMap).build();
    }

    private static boolean isPluggableAuthCredential(Map<String, Object> credentialSource) {
        return credentialSource.containsKey(EXECUTABLE_SOURCE_KEY);
    }

    private static boolean isAwsCredential(Map<String, Object> credentialSource) {
        return credentialSource.containsKey("environment_id") && ((String)credentialSource.get("environment_id")).startsWith("aws");
    }

    protected AccessToken exchangeExternalCredentialForAccessToken(StsTokenExchangeRequest stsTokenExchangeRequest) throws IOException {
        if (this.impersonatedCredentialsOverride != null) {
            return this.impersonatedCredentialsOverride.refreshAccessToken();
        }
        if (this.impersonatedCredentials != null) {
            return this.impersonatedCredentials.refreshAccessToken();
        }
        StsRequestHandler.Builder requestHandler = StsRequestHandler.newBuilder(this.tokenUrl, stsTokenExchangeRequest, this.transportFactory.create().createRequestFactory());
        if (this.isWorkforcePoolConfiguration()) {
            GenericJson options = new GenericJson();
            options.setFactory(OAuth2Utils.JSON_FACTORY);
            options.put("userProject", (Object)this.workforcePoolUserProject);
            requestHandler.setInternalOptions(options.toString());
        }
        if (stsTokenExchangeRequest.getInternalOptions() != null) {
            requestHandler.setInternalOptions(stsTokenExchangeRequest.getInternalOptions());
        }
        StsTokenExchangeResponse response = requestHandler.build().exchangeToken();
        return response.getAccessToken();
    }

    public abstract String retrieveSubjectToken() throws IOException;

    public String getAudience() {
        return this.audience;
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getTokenInfoUrl() {
        return this.tokenInfoUrl;
    }

    public CredentialSource getCredentialSource() {
        return this.credentialSource;
    }

    @Nullable
    public String getServiceAccountImpersonationUrl() {
        return this.serviceAccountImpersonationUrl;
    }

    @Nullable
    public String getServiceAccountEmail() {
        if (this.serviceAccountImpersonationUrl == null || this.serviceAccountImpersonationUrl.isEmpty()) {
            return null;
        }
        return ImpersonatedCredentials.extractTargetPrincipal(this.serviceAccountImpersonationUrl);
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Nullable
    public Collection<String> getScopes() {
        return this.scopes;
    }

    @Nullable
    public String getWorkforcePoolUserProject() {
        return this.workforcePoolUserProject;
    }

    @Nullable
    public ServiceAccountImpersonationOptions getServiceAccountImpersonationOptions() {
        return this.serviceAccountImpersonationOptions;
    }

    EnvironmentProvider getEnvironmentProvider() {
        return this.environmentProvider;
    }

    public boolean isWorkforcePoolConfiguration() {
        Pattern workforceAudiencePattern = Pattern.compile("^//iam.googleapis.com/locations/.+/workforcePools/.+/providers/.+$");
        return this.workforcePoolUserProject != null && workforceAudiencePattern.matcher(this.getAudience()).matches();
    }

    static void validateTokenUrl(String tokenUrl) {
        if (!ExternalAccountCredentials.isValidUrl(tokenUrl)) {
            throw new IllegalArgumentException("The provided token URL is invalid.");
        }
    }

    static void validateServiceAccountImpersonationInfoUrl(String serviceAccountImpersonationUrl) {
        if (!ExternalAccountCredentials.isValidUrl(serviceAccountImpersonationUrl)) {
            throw new IllegalArgumentException("The provided service account impersonation URL is invalid.");
        }
    }

    private static boolean isValidUrl(String url) {
        URI uri;
        try {
            uri = URI.create(url);
        }
        catch (Exception e) {
            return false;
        }
        return uri.getScheme() != null && uri.getHost() != null && "https".equals(uri.getScheme().toLowerCase(Locale.US));
    }

    public static abstract class Builder
    extends GoogleCredentials.Builder {
        protected String audience;
        protected String subjectTokenType;
        protected String tokenUrl;
        protected String tokenInfoUrl;
        protected CredentialSource credentialSource;
        protected EnvironmentProvider environmentProvider;
        protected HttpTransportFactory transportFactory;
        @Nullable
        protected String serviceAccountImpersonationUrl;
        @Nullable
        protected String clientId;
        @Nullable
        protected String clientSecret;
        @Nullable
        protected Collection<String> scopes;
        @Nullable
        protected String workforcePoolUserProject;
        @Nullable
        protected ServiceAccountImpersonationOptions serviceAccountImpersonationOptions;

        protected Builder() {
        }

        protected Builder(ExternalAccountCredentials credentials) {
            super(credentials);
            this.transportFactory = credentials.transportFactory;
            this.audience = credentials.audience;
            this.subjectTokenType = credentials.subjectTokenType;
            this.tokenUrl = credentials.tokenUrl;
            this.tokenInfoUrl = credentials.tokenInfoUrl;
            this.serviceAccountImpersonationUrl = credentials.serviceAccountImpersonationUrl;
            this.credentialSource = credentials.credentialSource;
            this.clientId = credentials.clientId;
            this.clientSecret = credentials.clientSecret;
            this.scopes = credentials.scopes;
            this.environmentProvider = credentials.environmentProvider;
            this.workforcePoolUserProject = credentials.workforcePoolUserProject;
            this.serviceAccountImpersonationOptions = credentials.serviceAccountImpersonationOptions;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public Builder setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        public Builder setSubjectTokenType(String subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
            return this;
        }

        public Builder setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder setCredentialSource(CredentialSource credentialSource) {
            this.credentialSource = credentialSource;
            return this;
        }

        public Builder setServiceAccountImpersonationUrl(String serviceAccountImpersonationUrl) {
            this.serviceAccountImpersonationUrl = serviceAccountImpersonationUrl;
            return this;
        }

        public Builder setTokenInfoUrl(String tokenInfoUrl) {
            this.tokenInfoUrl = tokenInfoUrl;
            return this;
        }

        @Override
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder setWorkforcePoolUserProject(String workforcePoolUserProject) {
            this.workforcePoolUserProject = workforcePoolUserProject;
            return this;
        }

        public Builder setServiceAccountImpersonationOptions(Map<String, Object> optionsMap) {
            this.serviceAccountImpersonationOptions = new ServiceAccountImpersonationOptions(optionsMap);
            return this;
        }

        Builder setEnvironmentProvider(EnvironmentProvider environmentProvider) {
            this.environmentProvider = environmentProvider;
            return this;
        }

        @Override
        public abstract ExternalAccountCredentials build();
    }

    static final class ServiceAccountImpersonationOptions {
        private static final int DEFAULT_TOKEN_LIFETIME_SECONDS = 3600;
        private static final int MAXIMUM_TOKEN_LIFETIME_SECONDS = 43200;
        private static final int MINIMUM_TOKEN_LIFETIME_SECONDS = 600;
        private static final String TOKEN_LIFETIME_SECONDS_KEY = "token_lifetime_seconds";
        private final int lifetime;

        ServiceAccountImpersonationOptions(Map<String, Object> optionsMap) {
            if (!optionsMap.containsKey(TOKEN_LIFETIME_SECONDS_KEY)) {
                this.lifetime = 3600;
                return;
            }
            try {
                Object lifetimeValue = optionsMap.get(TOKEN_LIFETIME_SECONDS_KEY);
                this.lifetime = lifetimeValue instanceof BigDecimal ? ((BigDecimal)lifetimeValue).intValue() : (optionsMap.get(TOKEN_LIFETIME_SECONDS_KEY) instanceof Integer ? (Integer)lifetimeValue : Integer.parseInt((String)lifetimeValue));
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw new IllegalArgumentException("Value of \"token_lifetime_seconds\" field could not be parsed into an integer.", e);
            }
            if (this.lifetime < 600 || this.lifetime > 43200) {
                throw new IllegalArgumentException(String.format("The \"token_lifetime_seconds\" field must be between %s and %s seconds.", 600, 43200));
            }
        }

        int getLifetime() {
            return this.lifetime;
        }
    }

    static abstract class CredentialSource {
        CredentialSource(Map<String, Object> credentialSourceMap) {
            Preconditions.checkNotNull(credentialSourceMap);
        }
    }
}

