/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.update.CommitUpdateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitTracker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DOC_COMMIT_DELAY_MS = 1;
    public static final int SIZE_COMMIT_DELAY_MS = 1;
    private int docsUpperBound;
    private long timeUpperBound;
    private long tLogFileSizeUpperBound;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new SolrNamedThreadFactory("commitScheduler"));
    private ScheduledFuture<?> pending;
    private AtomicLong docsSinceCommit = new AtomicLong(0L);
    private AtomicInteger autoCommitCount = new AtomicInteger(0);
    private final SolrCore core;
    private final boolean softCommit;
    private boolean openSearcher;
    private static final boolean WAIT_SEARCHER = true;
    private String name;

    public CommitTracker(String name, SolrCore core, int docsUpperBound, int timeUpperBound, long tLogFileSizeUpperBound, boolean openSearcher, boolean softCommit) {
        this.core = core;
        this.name = name;
        this.pending = null;
        this.docsUpperBound = docsUpperBound;
        this.timeUpperBound = timeUpperBound;
        this.tLogFileSizeUpperBound = tLogFileSizeUpperBound;
        this.softCommit = softCommit;
        this.openSearcher = openSearcher;
        log.info("{} AutoCommit: {}", (Object)name, (Object)this);
    }

    public boolean getOpenSearcher() {
        return this.openSearcher;
    }

    public synchronized void close() {
        if (this.pending != null) {
            this.pending.cancel(false);
            this.pending = null;
        }
        this.scheduler.shutdown();
    }

    public void scheduleCommitWithin(long commitMaxTime) {
        this._scheduleCommitWithin(commitMaxTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingCommit() {
        CommitTracker commitTracker = this;
        synchronized (commitTracker) {
            boolean canceled;
            if (this.pending != null && (canceled = this.pending.cancel(false))) {
                this.pending = null;
            }
        }
    }

    private void _scheduleCommitWithinIfNeeded(long commitWithin) {
        long ctime;
        long l = ctime = commitWithin > 0L ? commitWithin : this.timeUpperBound;
        if (ctime > 0L) {
            this._scheduleCommitWithin(ctime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _scheduleCommitWithin(long commitMaxTime) {
        if (commitMaxTime <= 0L) {
            return;
        }
        CommitTracker commitTracker = this;
        synchronized (commitTracker) {
            boolean canceled;
            if (this.pending != null && this.pending.getDelay(TimeUnit.MILLISECONDS) <= commitMaxTime) {
                return;
            }
            if (this.pending != null && !(canceled = this.pending.cancel(false))) {
                return;
            }
            this.pending = this.scheduler.schedule(this, commitMaxTime, TimeUnit.MILLISECONDS);
        }
    }

    public void addedDocument(int commitWithin) {
        this.addedDocument(commitWithin, -1L);
    }

    public void addedDocument(int commitWithin, long currentTlogSize) {
        this._scheduleMaxDocsTriggeredCommitIfNeeded();
        this._scheduleCommitWithinIfNeeded(commitWithin);
        this._scheduleMaxSizeTriggeredCommitIfNeeded(currentTlogSize);
    }

    private void _scheduleMaxDocsTriggeredCommitIfNeeded() {
        long docs;
        if (this.docsUpperBound > 0 && (docs = this.docsSinceCommit.incrementAndGet()) == (long)(this.docsUpperBound + 1)) {
            this.docsSinceCommit.set(0L);
            this._scheduleCommitWithin(1L);
        }
    }

    public void deletedDocument(int commitWithin) {
        this._scheduleCommitWithinIfNeeded(commitWithin);
    }

    public void scheduleMaxSizeTriggeredCommitIfNeeded(long currentTlogSize) {
        this._scheduleMaxSizeTriggeredCommitIfNeeded(currentTlogSize);
    }

    private void _scheduleMaxSizeTriggeredCommitIfNeeded(long currentTlogSize) {
        if (this.tLogFileSizeUpperBound > 0L && currentTlogSize > this.tLogFileSizeUpperBound) {
            this.docsSinceCommit.set(0L);
            this._scheduleCommitWithin(1L);
        }
    }

    public void didCommit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didRollback() {
        CommitTracker commitTracker = this;
        synchronized (commitTracker) {
            if (this.pending != null) {
                this.pending.cancel(false);
                this.pending = null;
            }
            this.docsSinceCommit.set(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommitTracker commitTracker = this;
        synchronized (commitTracker) {
            this.pending = null;
        }
        MDCLoggingContext.setCore(this.core);
        try (LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, (SolrParams)new ModifiableSolrParams());){
            CommitUpdateCommand command = new CommitUpdateCommand(req, false);
            command.openSearcher = this.openSearcher;
            command.waitSearcher = true;
            command.softCommit = this.softCommit;
            if (this.core.getCoreDescriptor().getCloudDescriptor() != null && this.core.getCoreDescriptor().getCloudDescriptor().isLeader() && !this.softCommit) {
                command.version = this.core.getUpdateHandler().getUpdateLog().getVersionInfo().getNewClock();
            }
            this.autoCommitCount.incrementAndGet();
            this.core.getUpdateHandler().commit(command);
        }
        catch (Exception e) {
            log.error("auto commit error...", (Throwable)e);
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public int getCommitCount() {
        return this.autoCommitCount.get();
    }

    public String toString() {
        if (this.timeUpperBound > 0L || this.docsUpperBound > 0 || this.tLogFileSizeUpperBound > 0L) {
            return (String)(this.timeUpperBound > 0L ? "if uncommitted for " + this.timeUpperBound + "ms; " : "") + (String)(this.docsUpperBound > 0 ? "if " + this.docsUpperBound + " uncommitted docs; " : "") + (this.tLogFileSizeUpperBound > 0L ? String.format(Locale.ROOT, "if tlog file size has exceeded %d bytes", this.tLogFileSizeUpperBound) : "");
        }
        return "disabled";
    }

    public long getTimeUpperBound() {
        return this.timeUpperBound;
    }

    int getDocsUpperBound() {
        return this.docsUpperBound;
    }

    long getTLogFileSizeUpperBound() {
        return this.tLogFileSizeUpperBound;
    }

    void setDocsUpperBound(int docsUpperBound) {
        this.docsUpperBound = docsUpperBound;
    }

    public void setTimeUpperBound(long timeUpperBound) {
        this.timeUpperBound = timeUpperBound;
    }

    public void setTLogFileSizeUpperBound(int sizeUpperBound) {
        this.tLogFileSizeUpperBound = sizeUpperBound;
    }

    public void setOpenSearcher(boolean openSearcher) {
        this.openSearcher = openSearcher;
    }

    public boolean hasPending() {
        return null != this.pending && !this.pending.isDone();
    }
}

