/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.servlet.HttpSolrCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@Priority(value=5)
public class PostRequestLoggingFilter
implements ContainerResponseFilter {
    public static final int PRIORITY = 5;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Logger coreRequestLogger = LoggerFactory.getLogger((String)(SolrCore.class.getName() + ".Request"));
    private static final Logger slowCoreRequestLogger = LoggerFactory.getLogger((String)(SolrCore.class.getName() + ".SlowRequest"));
    private static final Logger nonCoreRequestLogger = LoggerFactory.getLogger((String)HttpSolrCall.class.getName());
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (requestContext.getPropertyNames().contains("RESOURCE_NOT_FOUND")) {
            return;
        }
        if (!responseContext.hasEntity() || !SolrJerseyResponse.class.isInstance(responseContext.getEntity())) {
            log.debug("Skipping v2 API logging because response is of an unexpected type");
            return;
        }
        SolrJerseyResponse response = (SolrJerseyResponse)responseContext.getEntity();
        SolrQueryRequest solrQueryRequest = (SolrQueryRequest)requestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        SolrConfig solrConfig = solrQueryRequest.getCore() != null ? solrQueryRequest.getCore().getSolrConfig() : null;
        Logger requestLogger = solrConfig != null ? coreRequestLogger : nonCoreRequestLogger;
        String templatedPath = this.buildTemplatedPath(requestContext.getUriInfo().getAbsolutePath().getPath());
        String bodyVal = PostRequestLoggingFilter.buildRequestBodyString(requestContext);
        requestLogger.info(MarkerFactory.getMarker((String)templatedPath), "method={} path={} query-params={{}} entity={} status={} QTime={}", new Object[]{requestContext.getMethod(), templatedPath, PostRequestLoggingFilter.filterAndStringifyQueryParameters((MultivaluedMap<String, String>)requestContext.getUriInfo().getQueryParameters()), bodyVal, response.responseHeader.status, response.responseHeader.qTime});
        if (slowCoreRequestLogger.isWarnEnabled() && solrConfig != null && solrConfig.slowQueryThresholdMillis >= 0 && response.responseHeader.qTime >= (long)solrConfig.slowQueryThresholdMillis) {
            slowCoreRequestLogger.warn(MarkerFactory.getMarker((String)templatedPath), "method={} path={} query-params={{}} entity={} status={} QTime={}", new Object[]{requestContext.getMethod(), templatedPath, PostRequestLoggingFilter.filterAndStringifyQueryParameters((MultivaluedMap<String, String>)requestContext.getUriInfo().getQueryParameters()), response.responseHeader.status, response.responseHeader.qTime});
        }
    }

    private String buildTemplatedPath(String fallbackPath) {
        if (this.resourceInfo == null || this.resourceInfo.getResourceClass() == null || this.resourceInfo.getResourceMethod() == null) {
            return fallbackPath;
        }
        Path classPathAnnotation = this.resourceInfo.getResourceClass().getAnnotation(Path.class);
        String classPathAnnotationVal = classPathAnnotation != null ? classPathAnnotation.value() : "";
        Path methodPathAnnotation = this.resourceInfo.getResourceMethod().getAnnotation(Path.class);
        String methodPathAnnotationVal = methodPathAnnotation != null ? methodPathAnnotation.value() : "";
        return String.format(Locale.ROOT, "%s%s", classPathAnnotationVal, methodPathAnnotationVal).replaceAll("//", "/");
    }

    public static String buildRequestBodyString(ContainerRequestContext requestContext) {
        if (requestContext.getProperty("request-body") == null) {
            return "{}";
        }
        if (!(requestContext.getProperty("request-body") instanceof JacksonReflectMapWriter)) {
            log.warn("Encountered unexpected request-body type {} for request {}; only {} expected.", new Object[]{requestContext.getProperty("request-body").getClass().getName(), requestContext.getUriInfo().getPath(), JacksonReflectMapWriter.class.getName()});
            return "{}";
        }
        return ((JacksonReflectMapWriter)requestContext.getProperty("request-body")).jsonStr().replace("\n", "");
    }

    public static String filterAndStringifyQueryParameters(MultivaluedMap<String, String> unfilteredParams) {
        Set<String> paramNamesToLog = PostRequestLoggingFilter.getParamNamesToLog(unfilteredParams);
        StringBuilder sb = new StringBuilder(128);
        unfilteredParams.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            String name = (String)entry.getKey();
            if (!paramNamesToLog.contains(name)) {
                return;
            }
            for (String val : (List)entry.getValue()) {
                if (sb.length() != 0) {
                    sb.append('&');
                }
                StrUtils.partialURLEncodeVal((StringBuilder)sb, (String)name);
                sb.append('=');
                StrUtils.partialURLEncodeVal((StringBuilder)sb, (String)val);
            }
        });
        return sb.toString();
    }

    private static Set<String> getParamNamesToLog(MultivaluedMap<String, String> queryParameters) {
        if (CollectionUtil.isEmpty((Collection)((Collection)queryParameters.get((Object)"logParamsList")))) {
            return queryParameters.keySet();
        }
        String paramsToLogStr = (String)queryParameters.getFirst((Object)"logParamsList");
        if (StrUtils.isBlank((String)paramsToLogStr)) {
            return new HashSet<String>();
        }
        return Arrays.stream(paramsToLogStr.split(",")).collect(Collectors.toSet());
    }
}

