/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.handler.export.ExportWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExportBuffers {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long EXCHANGE_TIMEOUT_SECONDS = 600L;
    static final String EXPORT_BUFFERS_KEY = "__eb__";
    final Buffer bufferOne;
    final Buffer bufferTwo;
    final List<LeafReaderContext> leaves;
    final ExportWriter exportWriter;
    final OutputStream os;
    final IteratorWriter.ItemWriter rawWriter;
    final IteratorWriter.ItemWriter writer;
    final CyclicBarrier barrier;
    final int totalHits;
    Buffer fillBuffer;
    Buffer outputBuffer;
    Runnable filler;
    ExecutorService service;
    Throwable error;
    LongAdder outputCounter = new LongAdder();
    volatile boolean shutDown = false;

    ExportBuffers(ExportWriter exportWriter, List<LeafReaderContext> leaves, SolrIndexSearcher searcher, OutputStream os, final IteratorWriter.ItemWriter rawWriter, Sort sort, int queueSize, int totalHits, FixedBitSet[] sets) throws IOException {
        this.exportWriter = exportWriter;
        this.leaves = leaves;
        this.os = os;
        this.rawWriter = rawWriter;
        this.writer = new IteratorWriter.ItemWriter(){

            public IteratorWriter.ItemWriter add(Object o) throws IOException {
                rawWriter.add(o);
                ExportBuffers.this.outputCounter.increment();
                return this;
            }
        };
        this.bufferOne = new Buffer(queueSize);
        this.bufferTwo = new Buffer(queueSize);
        this.totalHits = totalHits;
        this.fillBuffer = this.bufferOne;
        this.outputBuffer = this.bufferTwo;
        SortDoc writerSortDoc = exportWriter.getSortDoc(searcher, sort.getSort());
        ExportWriter.MergeIterator mergeIterator = exportWriter.getMergeIterator(leaves, sets, writerSortDoc);
        this.bufferOne.initialize(writerSortDoc);
        this.bufferTwo.initialize(writerSortDoc);
        this.barrier = new CyclicBarrier(2, () -> this.swapBuffers());
        this.filler = () -> {
            try {
                Buffer buffer = this.getFillBuffer();
                long lastOutputCounter = 0L;
                int count = 0;
                while (count < totalHits) {
                    exportWriter.fillOutDocs(mergeIterator, buffer);
                    count += buffer.outDocsIndex + 1;
                    long startBufferWait = System.nanoTime();
                    this.exchangeBuffers();
                    long endBufferWait = System.nanoTime();
                    if (log.isDebugEnabled()) {
                        log.debug("Waited for writer thread:{}", (Object)Long.toString((endBufferWait - startBufferWait) / 1000000L));
                    }
                    buffer = this.getFillBuffer();
                    if (this.outputCounter.longValue() <= lastOutputCounter) continue;
                    lastOutputCounter = this.outputCounter.longValue();
                    this.flushOutput();
                }
                buffer.outDocsIndex = -2;
                this.exchangeBuffers();
                buffer = this.getFillBuffer();
            }
            catch (Throwable e) {
                if (!(e instanceof InterruptedException) && !(e instanceof BrokenBarrierException)) {
                    log.error("filler", e);
                }
                this.error(e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.shutdownNow();
            }
        };
    }

    public void exchangeBuffers() throws Exception {
        this.barrier.await(600L, TimeUnit.SECONDS);
    }

    public void error(Throwable t) {
        this.error = t;
        this.barrier.reset();
    }

    public Throwable getError() {
        return this.error;
    }

    private void swapBuffers() {
        Buffer one = this.fillBuffer;
        this.fillBuffer = this.outputBuffer;
        this.outputBuffer = one;
    }

    private void flushOutput() throws IOException {
    }

    public Buffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public Buffer getFillBuffer() {
        return this.fillBuffer;
    }

    public IteratorWriter.ItemWriter getWriter() {
        return this.writer;
    }

    public void shutdownNow() {
        if (this.service != null) {
            log.debug("--- shutting down buffers");
            this.service.shutdownNow();
            this.service = null;
        }
        this.shutDown = true;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Callable<Boolean> writer) throws IOException {
        this.service = ExecutorUtil.newMDCAwareFixedThreadPool((int)1, (ThreadFactory)new SolrNamedThreadFactory("ExportBuffers"));
        try {
            CompletableFuture.runAsync(this.filler, this.service);
            writer.call();
            log.debug("-- finished.");
        }
        catch (Throwable e) {
            boolean ignore = false;
            for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                String m = ex.getMessage();
                if (m == null || !m.contains("Broken pipe")) continue;
                ignore = true;
                break;
            }
            if (!ignore) {
                log.error("Exception running filler / writer", e);
            }
            this.error(e);
        }
        finally {
            log.debug("--- all done, shutting down buffers");
            this.shutdownNow();
        }
    }

    static final class Buffer {
        static final int EMPTY = -1;
        static final int NO_MORE_DOCS = -2;
        int outDocsIndex = -1;
        SortDoc[] outDocs;

        public Buffer(int size) {
            this.outDocs = new SortDoc[size];
        }

        public void initialize(SortDoc proto) {
            this.outDocsIndex = -1;
            for (int i = 0; i < this.outDocs.length; ++i) {
                this.outDocs[i] = proto.copy();
            }
        }

        public String toString() {
            return "Buffer@" + Integer.toHexString(this.hashCode()) + "{outDocsIndex=" + this.outDocsIndex + "}";
        }
    }
}

