/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.solr.client.api.endpoint.ListCollectionBackupsApi;
import org.apache.solr.client.api.model.CollectionBackupDetails;
import org.apache.solr.client.api.model.ListCollectionBackupsResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.BackupProperties;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.admin.api.BackupAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJacksonMapper;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class ListCollectionBackups
extends BackupAPIBase
implements ListCollectionBackupsApi {
    private final ObjectMapper objectMapper = SolrJacksonMapper.getObjectMapper();

    @Inject
    public ListCollectionBackups(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams v1Params = req.getParams();
        v1Params.required().check(new String[]{"name"});
        ListCollectionBackups listApi = new ListCollectionBackups(coreContainer, req, rsp);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, listApi.listBackupsAtLocation(v1Params.get("name"), v1Params.get("location"), v1Params.get("repository")));
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public ListCollectionBackupsResponse listBackupsAtLocation(String backupName, String location, String repositoryName) throws IOException {
        ListCollectionBackupsResponse response = this.instantiateJerseyResponse(ListCollectionBackupsResponse.class);
        ListCollectionBackups.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        this.ensureRequiredParameterProvided("name", backupName);
        location = this.getAndValidateIncrementalBackupLocation(repositoryName, location, backupName);
        try (BackupRepository repository = this.createBackupRepository(repositoryName);){
            URI locationURI = repository.createDirectoryURI(location);
            URI backupLocation = BackupFilePaths.buildExistingBackupLocationURI(repository, locationURI, backupName);
            String[] subFiles = repository.listAllOrEmpty(backupLocation);
            List<BackupId> propsFiles = BackupFilePaths.findAllBackupIdsFromFileListing(subFiles);
            response.backups = new ArrayList();
            for (BackupId backupId : propsFiles) {
                BackupProperties properties = BackupProperties.readFrom(repository, backupLocation, BackupFilePaths.getBackupPropsName(backupId));
                if (response.collection == null) {
                    response.collection = properties.getCollection();
                }
                Map<String, Object> details = properties.getDetails();
                details.put("backupId", backupId.id);
                response.backups.add((CollectionBackupDetails)this.objectMapper.convertValue(details, CollectionBackupDetails.class));
            }
        }
        return response;
    }
}

