/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.FullAtom;
import com.drew.metadata.mov.media.QuickTimeTimecodeDirectory;
import java.io.IOException;

public class TimecodeInformationMediaAtom
extends FullAtom {
    int textFont;
    int textFace;
    int textSize;
    int[] textColor;
    int[] backgroundColor;
    String fontName;

    public TimecodeInformationMediaAtom(SequentialReader reader, Atom atom) throws IOException {
        super(reader, atom);
        this.textFont = reader.getInt16();
        this.textFace = reader.getInt16();
        this.textSize = reader.getInt16();
        reader.skip(2L);
        this.textColor = new int[]{reader.getUInt16(), reader.getUInt16(), reader.getUInt16()};
        this.backgroundColor = new int[]{reader.getUInt16(), reader.getUInt16(), reader.getUInt16()};
        this.fontName = reader.getString(reader.getUInt8());
    }

    public void addMetadata(QuickTimeTimecodeDirectory directory) {
        directory.setInt(5, this.textFont);
        switch (this.textFace) {
            case 1: {
                directory.setString(6, "Bold");
                break;
            }
            case 2: {
                directory.setString(6, "Italic");
                break;
            }
            case 4: {
                directory.setString(6, "Underline");
                break;
            }
            case 8: {
                directory.setString(6, "Outline");
                break;
            }
            case 16: {
                directory.setString(6, "Shadow");
                break;
            }
            case 32: {
                directory.setString(6, "Condense");
                break;
            }
            case 64: {
                directory.setString(6, "Extend");
            }
        }
        directory.setInt(7, this.textSize);
        directory.setIntArray(8, this.textColor);
        directory.setIntArray(9, this.backgroundColor);
        directory.setString(10, this.fontName);
    }
}

