/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyDescriptor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

public class DateConfigurator<C extends DataObject>
extends Configurator<Date, C>
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = -570697480220814586L;
    private DateFormat dateFormat;
    private GregorianCalendar calendar;
    private JTextField textField;
    private int stepMinutes;

    public DateConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.setLayout(new BorderLayout());
        String datePattern = property.getWriteMethod().getAnnotation(Adjustable.class).datePattern();
        if (datePattern != null && datePattern.length() > 0) {
            this.dateFormat = new SimpleDateFormat();
            ((SimpleDateFormat)this.dateFormat).applyPattern(datePattern);
        } else {
            this.dateFormat = DateFormat.getInstance();
        }
        this.dateFormat.setLenient(true);
        JLabel label = new JLabel(this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).info() + ":");
        label.setHorizontalAlignment(4);
        this.add((Component)label, "West");
        this.calendar = new GregorianCalendar(TimeZone.getDefault());
        this.textField = new JTextField();
        this.textField.addFocusListener(this);
        this.add((Component)this.textField, "Center");
        this.stepMinutes = property.getWriteMethod().getAnnotation(Adjustable.class).step();
        this.textField.addKeyListener(this);
    }

    @Override
    protected void _actionPerformed(ActionEvent evt) {
        Date date;
        if ("".equals(this.textField.getText().trim())) {
            date = (Date)this.getNullValue();
        } else {
            try {
                date = this.dateFormat.parse(this.textField.getText().trim());
            }
            catch (ParseException e) {
                this.refresh();
                return;
            }
        }
        this.getBean().setValue(this.getProperty(), date);
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    public void changeHour(int diff) {
        this.calendar.setTime((Date)this.getValue());
        this.calendar.add(11, diff);
        this.refresh(this.calendar.getTime());
        this.actionPerformed(null);
    }

    public void changeMinutes(int diff) {
        this.calendar.setTime((Date)this.getValue());
        this.calendar.add(12, diff);
        this.refresh(this.calendar.getTime());
        this.actionPerformed(null);
    }

    protected void setToCurrentTime() {
        this.calendar.setTime(new Date());
        this.calendar.set(13, 0);
        this.refresh(this.calendar.getTime());
        this.actionPerformed(null);
    }

    @Override
    protected void refresh(Date value) {
        if (value.equals(this.getNullValue())) {
            this.textField.setText("");
        } else {
            this.calendar.setTime(value);
            int minutes = this.calendar.get(12);
            int mod = minutes % this.stepMinutes;
            if (mod > 0) {
                this.calendar.set(12, minutes -= mod);
                this.getBean().setValue(this.getProperty(), this.calendar.getTime());
            }
            this.textField.setText(this.dateFormat.format(this.calendar.getTime()));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.isAltDown()) {
            if (e.getKeyCode() == 37) {
                this.changeMinutes(-this.stepMinutes);
            } else if (e.getKeyCode() == 39) {
                this.changeMinutes(this.stepMinutes);
            } else if (e.getKeyCode() == 38) {
                this.changeHour(1);
            } else if (e.getKeyCode() == 40) {
                this.changeHour(-1);
            }
        } else if (e.isControlDown() && e.isShiftDown()) {
            if (e.getKeyCode() == 32) {
                this.setToCurrentTime();
            }
        } else if (e.getKeyCode() == 27) {
            this.refresh();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focus() {
        this.textField.selectAll();
        this.textField.requestFocusInWindow();
    }
}

