/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Strokes;

public class Cross
extends Drawable {
    private Point[] pts;

    public Cross(Lifeline lifeline) {
        super(lifeline.getDiagram());
        this.setWidth(lifeline.getDiagram().getConfiguration().getDestructorWidth());
        this.setHeight(this.getWidth());
    }

    public Point[] getPoints() {
        return this.pts;
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        g2d.setStroke(Strokes.getStroke(Strokes.StrokeType.SOLID, 2));
        g2d.setColor(Color.BLACK);
        g2d.drawLine(this.pts[0].x, this.pts[0].y, this.pts[1].x, this.pts[1].y);
        g2d.drawLine(this.pts[2].x, this.pts[2].y, this.pts[3].x, this.pts[3].y);
    }

    @Override
    public void computeLayoutInformation() {
        int left = this.getLeft();
        int top = this.getTop();
        int width = this.getWidth();
        this.pts = new Point[4];
        this.pts[0] = new Point(left, top - width / 2 + 3);
        this.pts[1] = new Point(left + width, top + width / 2 + 3);
        this.pts[2] = new Point(left, top + width / 2 + 3);
        this.pts[3] = new Point(left + width, top - width / 2 + 3);
    }
}

