# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

import enum

from typing import Any

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wl_callback import WlCallback
from .wl_registry import WlRegistry


class WlDisplay(Interface):
    """Core global object

    The core global object.  This is a special singleton object.  It is used
    for internal Wayland protocol features.
    """

    name = "wl_display"
    version = 1

    class error(enum.IntEnum):
        invalid_object = 0
        invalid_method = 1
        no_memory = 2
        implementation = 3


class WlDisplayProxy(Proxy[WlDisplay]):
    interface = WlDisplay

    @WlDisplay.request(
        Argument(ArgumentType.NewId, interface=WlCallback),
    )
    def sync(self) -> Proxy[WlCallback]:
        """Asynchronous roundtrip

        The sync request asks the server to emit the 'done' event on the
        returned :class:`~pywayland.protocol.wayland.WlCallback` object.  Since
        requests are handled in-order and events are delivered in-order, this
        can be used as a barrier to ensure all previous requests and the
        resulting events have been handled.

        The object returned by this request will be destroyed by the compositor
        after the callback is fired and as such the client must not attempt to
        use it after that point.

        The callback_data passed in the callback is the event serial.

        :returns:
            :class:`~pywayland.protocol.wayland.WlCallback` -- callback object
            for the sync request
        """
        callback = self._marshal_constructor(0, WlCallback)
        return callback

    @WlDisplay.request(
        Argument(ArgumentType.NewId, interface=WlRegistry),
    )
    def get_registry(self) -> Proxy[WlRegistry]:
        """Get global registry object

        This request creates a registry object that allows the client to list
        and bind the global objects available from the compositor.

        It should be noted that the server side resources consumed in response
        to a get_registry request can only be released when the client
        disconnects, not when the client side proxy is destroyed. Therefore,
        clients should invoke get_registry as infrequently as possible to avoid
        wasting memory.

        :returns:
            :class:`~pywayland.protocol.wayland.WlRegistry` -- global registry
            object
        """
        registry = self._marshal_constructor(1, WlRegistry)
        return registry


class WlDisplayResource(Resource):
    interface = WlDisplay

    @WlDisplay.event(
        Argument(ArgumentType.Object),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.String),
    )
    def error(self, object_id: Any, code: int, message: str) -> None:
        """Fatal error event

        The error event is sent out when a fatal (non-recoverable) error has
        occurred.  The object_id argument is the object where the error
        occurred, most often in response to a request to that object.  The code
        identifies the error and is defined by the object interface.  As such,
        each interface defines its own set of error codes.  The message is a
        brief description of the error, for (debugging) convenience.

        :param object_id:
            object where the error occurred
        :type object_id:
            `ArgumentType.Object`
        :param code:
            error code
        :type code:
            `ArgumentType.Uint`
        :param message:
            error description
        :type message:
            `ArgumentType.String`
        """
        self._post_event(0, object_id, code, message)

    @WlDisplay.event(
        Argument(ArgumentType.Uint),
    )
    def delete_id(self, id: int) -> None:
        """Acknowledge object id deletion

        This event is used internally by the object ID management logic. When a
        client deletes an object that it had created, the server will send this
        event to acknowledge that it has seen the delete request. When the
        client receives this event, it will know that it can safely reuse the
        object ID.

        :param id:
            deleted object ID
        :type id:
            `ArgumentType.Uint`
        """
        self._post_event(1, id)


class WlDisplayGlobal(Global):
    interface = WlDisplay


WlDisplay._gen_c()
WlDisplay.proxy_class = WlDisplayProxy
WlDisplay.resource_class = WlDisplayResource
WlDisplay.global_class = WlDisplayGlobal
