/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import impl.org.controlsfx.ImplUtils;
import impl.org.controlsfx.skin.DecorationPane;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.controlsfx.control.decoration.Decoration;

public class Decorator {
    private static final String DECORATIONS_PROPERTY_KEY = "$org.controlsfx.decorations$";
    private static List<Scene> currentlyInstallingScenes = new ArrayList<Scene>();
    private static Map<Scene, List<Consumer<DecorationPane>>> pendingTasksByScene = new HashMap<Scene, List<Consumer<DecorationPane>>>();

    private Decorator() {
    }

    public static final void addDecoration(Node target, Decoration decoration) {
        Decorator.getDecorations(target, true).add(decoration);
        Decorator.updateDecorationsOnNode(target, FXCollections.observableArrayList(decoration), null);
    }

    public static final void removeDecoration(Node target, Decoration decoration) {
        Decorator.getDecorations(target, true).remove(decoration);
        Decorator.updateDecorationsOnNode(target, null, FXCollections.observableArrayList(decoration));
    }

    public static final void removeAllDecorations(Node target) {
        ObservableList<Decoration> decorations = Decorator.getDecorations(target, true);
        ObservableList<Decoration> removed = FXCollections.observableArrayList(decorations);
        target.getProperties().remove(DECORATIONS_PROPERTY_KEY);
        Decorator.updateDecorationsOnNode(target, null, removed);
    }

    public static final ObservableList<Decoration> getDecorations(Node target) {
        return Decorator.getDecorations(target, false);
    }

    private static final ObservableList<Decoration> getDecorations(Node target, boolean createIfAbsent) {
        ObservableList decorations = (ObservableList)target.getProperties().get(DECORATIONS_PROPERTY_KEY);
        if (decorations == null && createIfAbsent) {
            decorations = FXCollections.observableArrayList();
            target.getProperties().put(DECORATIONS_PROPERTY_KEY, decorations);
        }
        return decorations;
    }

    private static void updateDecorationsOnNode(Node target, List<Decoration> added, List<Decoration> removed) {
        Decorator.getDecorationPane(target, pane -> pane.updateDecorationsOnNode(target, added, removed));
    }

    private static void getDecorationPane(final Node target, Consumer<DecorationPane> task) {
        DecorationPane pane = Decorator.getDecorationPaneInParentHierarchy(target);
        if (pane != null) {
            task.accept(pane);
        } else {
            final Consumer<Scene> sceneConsumer = scene -> {
                if (currentlyInstallingScenes.contains(scene)) {
                    List<Consumer<DecorationPane>> pendingTasks = pendingTasksByScene.get(scene);
                    if (pendingTasks == null) {
                        pendingTasks = new LinkedList<Consumer<DecorationPane>>();
                        pendingTasksByScene.put((Scene)scene, pendingTasks);
                    }
                    pendingTasks.add(task);
                    return;
                }
                DecorationPane _pane = Decorator.getDecorationPaneInParentHierarchy(target);
                if (_pane == null) {
                    currentlyInstallingScenes.add((Scene)scene);
                    _pane = new DecorationPane();
                    Parent oldRoot = scene.getRoot();
                    ImplUtils.injectAsRootPane(scene, _pane, true);
                    _pane.setRoot(oldRoot);
                    currentlyInstallingScenes.remove(scene);
                }
                task.accept(_pane);
                List<Consumer<DecorationPane>> pendingTasks = pendingTasksByScene.remove(scene);
                if (pendingTasks != null) {
                    for (Consumer<DecorationPane> pendingTask : pendingTasks) {
                        pendingTask.accept(_pane);
                    }
                }
            };
            Scene scene2 = target.getScene();
            if (scene2 != null) {
                sceneConsumer.accept(scene2);
            } else {
                InvalidationListener sceneListener = new InvalidationListener(){

                    @Override
                    public void invalidated(Observable o) {
                        if (target.getScene() != null) {
                            target.sceneProperty().removeListener(this);
                            sceneConsumer.accept(target.getScene());
                        }
                    }
                };
                target.sceneProperty().addListener(sceneListener);
            }
        }
    }

    private static DecorationPane getDecorationPaneInParentHierarchy(Node target) {
        for (Parent p = target.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof DecorationPane)) continue;
            return (DecorationPane)p;
        }
        return null;
    }
}

