/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.ConnectionPool;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003*\u0001\n\u0018\u0000 12\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u001dJ\u0006\u0010&\u001a\u00020\u0003J\u0018\u0010'\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0014J.\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010/2\u0006\u00100\u001a\u00020\rR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00062"}, d2={"Lokhttp3/internal/connection/RealConnectionPool;", "", "maxIdleConnections", "", "keepAliveDuration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(IJLjava/util/concurrent/TimeUnit;)V", "cleanupRunnable", "okhttp3/internal/connection/RealConnectionPool$cleanupRunnable$1", "Lokhttp3/internal/connection/RealConnectionPool$cleanupRunnable$1;", "cleanupRunning", "", "getCleanupRunning", "()Z", "setCleanupRunning", "(Z)V", "connections", "Ljava/util/ArrayDeque;", "Lokhttp3/internal/connection/RealConnection;", "keepAliveDurationNs", "routeDatabase", "Lokhttp3/internal/connection/RouteDatabase;", "getRouteDatabase", "()Lokhttp3/internal/connection/RouteDatabase;", "cleanup", "now", "connectFailed", "", "failedRoute", "Lokhttp3/Route;", "failure", "Ljava/io/IOException;", "connectionBecameIdle", "connection", "connectionCount", "evictAll", "idleConnectionCount", "pruneAndGetAllocationCount", "put", "transmitterAcquirePooledConnection", "address", "Lokhttp3/Address;", "transmitter", "Lokhttp3/internal/connection/Transmitter;", "routes", "", "requireMultiplexed", "Companion", "okhttp"})
public final class RealConnectionPool {
    private final long keepAliveDurationNs;
    private final cleanupRunnable.1 cleanupRunnable;
    private final ArrayDeque<RealConnection> connections;
    @NotNull
    private final RouteDatabase routeDatabase;
    private boolean cleanupRunning;
    private final int maxIdleConnections;
    private static final ThreadPoolExecutor executor;
    public static final Companion Companion;

    @NotNull
    public final RouteDatabase getRouteDatabase() {
        return this.routeDatabase;
    }

    public final boolean getCleanupRunning() {
        return this.cleanupRunning;
    }

    public final void setCleanupRunning(boolean bl) {
        this.cleanupRunning = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized int idleConnectionCount() {
        int n;
        Iterable $this$count$iv = this.connections;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RealConnection it = (RealConnection)element$iv;
                boolean bl = false;
                if (!it.getTransmitters().isEmpty()) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final synchronized int connectionCount() {
        return this.connections.size();
    }

    public final boolean transmitterAcquirePooledConnection(@NotNull Address address, @NotNull Transmitter transmitter, @Nullable List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkParameterIsNotNull(address, "address");
        Intrinsics.checkParameterIsNotNull(transmitter, "transmitter");
        boolean bl = Thread.holdsLock(this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        for (RealConnection connection : this.connections) {
            if (requireMultiplexed && !connection.isMultiplexed() || !connection.isEligible$okhttp(address, routes)) continue;
            RealConnection realConnection = connection;
            Intrinsics.checkExpressionValueIsNotNull(realConnection, "connection");
            transmitter.acquireConnectionNoEvents(realConnection);
            return true;
        }
        return false;
    }

    public final void put(@NotNull RealConnection connection) {
        Intrinsics.checkParameterIsNotNull(connection, "connection");
        boolean bl = Thread.holdsLock(this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            executor.execute(this.cleanupRunnable);
        }
        this.connections.add(connection);
    }

    public final boolean connectionBecameIdle(@NotNull RealConnection connection) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(connection, "connection");
        boolean bl2 = Thread.holdsLock(this);
        boolean bl3 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            this.connections.remove(connection);
            bl = true;
        } else {
            RealConnectionPool $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            RealConnectionPool realConnectionPool = $this$notifyAll$iv;
            if (realConnectionPool == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)realConnectionPool).notifyAll();
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        boolean bl = false;
        List evictedConnections = new ArrayList();
        RealConnectionPool realConnectionPool = this;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (realConnectionPool) {
            boolean bl4 = false;
            Iterator<RealConnection> iterator2 = this.connections.iterator();
            Intrinsics.checkExpressionValueIsNotNull(iterator2, "connections.iterator()");
            Iterator<RealConnection> i = iterator2;
            while (i.hasNext()) {
                RealConnection connection = i.next();
                if (!connection.getTransmitters().isEmpty()) continue;
                connection.setNoNewExchanges(true);
                RealConnection realConnection = connection;
                Intrinsics.checkExpressionValueIsNotNull(realConnection, "connection");
                evictedConnections.add(realConnection);
                i.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
        for (RealConnection connection : evictedConnections) {
            Util.closeQuietly(connection.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long cleanup(long now) {
        int inUseConnectionCount = 0;
        int idleConnectionCount = 0;
        RealConnection longestIdleConnection = null;
        long longestIdleDurationNs = Long.MIN_VALUE;
        RealConnectionPool realConnectionPool = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3;
            block10: {
                block12: {
                    block11: {
                        boolean bl4 = false;
                        Iterator<RealConnection> iterator2 = this.connections.iterator();
                        while (iterator2.hasNext()) {
                            int n;
                            RealConnection connection;
                            RealConnection realConnection = connection = iterator2.next();
                            Intrinsics.checkExpressionValueIsNotNull(realConnection, "connection");
                            if (this.pruneAndGetAllocationCount(realConnection, now) > 0) {
                                n = inUseConnectionCount;
                                inUseConnectionCount = n + 1;
                                continue;
                            }
                            n = idleConnectionCount;
                            idleConnectionCount = n + 1;
                            long idleDurationNs = now - connection.getIdleAtNanos$okhttp();
                            if (idleDurationNs <= longestIdleDurationNs) continue;
                            longestIdleDurationNs = idleDurationNs;
                            longestIdleConnection = connection;
                        }
                        if (longestIdleDurationNs >= this.keepAliveDurationNs || idleConnectionCount > this.maxIdleConnections) {
                            bl3 = this.connections.remove(longestIdleConnection);
                            break block10;
                        }
                        if (idleConnectionCount <= 0) break block11;
                        long l = this.keepAliveDurationNs - longestIdleDurationNs;
                        return l;
                    }
                    if (inUseConnectionCount <= 0) break block12;
                    long l = this.keepAliveDurationNs;
                    return l;
                }
                this.cleanupRunning = false;
                long l = -1L;
                return l;
            }
            bl2 = bl3;
        }
        RealConnection realConnection = longestIdleConnection;
        if (realConnection == null) {
            Intrinsics.throwNpe();
        }
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }

    private final int pruneAndGetAllocationCount(RealConnection connection, long now) {
        List<Reference<Transmitter>> references = connection.getTransmitters();
        int i = 0;
        while (i < references.size()) {
            Reference<Transmitter> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Reference<Transmitter> reference2 = reference;
            if (reference2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type okhttp3.internal.connection.Transmitter.TransmitterReference");
            }
            Transmitter.TransmitterReference transmitterRef = (Transmitter.TransmitterReference)reference2;
            String message = "A connection to " + connection.route().address().url() + " was leaked. " + "Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message, transmitterRef.getCallStackTrace());
            references.remove(i);
            connection.setNoNewExchanges(true);
            if (!references.isEmpty()) continue;
            connection.setIdleAtNanos$okhttp(now - this.keepAliveDurationNs);
            return 0;
        }
        return references.size();
    }

    public final void connectFailed(@NotNull Route failedRoute, @NotNull IOException failure) {
        Intrinsics.checkParameterIsNotNull(failedRoute, "failedRoute");
        Intrinsics.checkParameterIsNotNull(failure, "failure");
        if (failedRoute.proxy().type() != Proxy.Type.DIRECT) {
            Address address = failedRoute.address();
            address.proxySelector().connectFailed(address.url().uri(), failedRoute.proxy().address(), failure);
        }
        this.routeDatabase.failed(failedRoute);
    }

    public RealConnectionPool(int maxIdleConnections, long keepAliveDuration, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)timeUnit, "timeUnit");
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.cleanupRunnable = new Runnable(this){
            final /* synthetic */ RealConnectionPool this$0;

            public void run() {
                long waitNanos;
                while ((waitNanos = this.this$0.cleanup(System.nanoTime())) != -1L) {
                    try {
                        Util.lockAndWaitNanos(this.this$0, waitNanos);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        this.this$0.evictAll();
                        continue;
                    }
                    break;
                }
                return;
            }
            {
                this.this$0 = $outer;
            }
        };
        this.connections = new ArrayDeque();
        this.routeDatabase = new RouteDatabase();
        boolean bl = keepAliveDuration > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "keepAliveDuration <= 0: " + keepAliveDuration;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    static {
        Companion = new Companion(null);
        executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), Util.threadFactory("OkHttp ConnectionPool", true));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/RealConnectionPool$Companion;", "", "()V", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "get", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionPool", "Lokhttp3/ConnectionPool;", "okhttp"})
    public static final class Companion {
        @NotNull
        public final RealConnectionPool get(@NotNull ConnectionPool connectionPool) {
            Intrinsics.checkParameterIsNotNull(connectionPool, "connectionPool");
            return connectionPool.getDelegate$okhttp();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

