/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import java.awt.Desktop;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.imageio.ImageIO;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mac.OsxIndicatorThread;
import mediathek.mac.OsxPowerManager;
import mediathek.mac.Spotlight;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.Log;
import mediathek.tool.threads.IndicatorThread;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekGuiMac
extends MediathekGui {
    private static final String SHUTDOWN_HELPER_APP_BINARY_PATH = "/Contents/MacOS/MediathekView Shutdown Helper";
    private final OsxPowerManager powerManager = new OsxPowerManager();
    private final Logger logger = LogManager.getLogger(MediathekGuiMac.class);
    protected Stage controlsFxWorkaroundStage;

    public MediathekGuiMac() {
        this.setupDockIcon();
    }

    @Override
    public void initializeSystemTray() {
    }

    @Override
    protected void closeControlsFxWorkaroundStage() {
        Platform.runLater(() -> {
            if (this.controlsFxWorkaroundStage != null) {
                this.controlsFxWorkaroundStage.close();
            }
        });
    }

    @Override
    protected void workaroundControlsFxNotificationBug() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.controlsFxWorkaroundStage = new WorkaroundStage();
            this.controlsFxWorkaroundStage.show();
            this.controlsFxWorkaroundStage.toBack();
        });
    }

    @Override
    protected void shutdownComputer() {
        try {
            List<File> result = Spotlight.find("kMDItemCFBundleIdentifier == org.mediathekview.MediathekView-Shutdown-Helper");
            if (result.isEmpty()) {
                this.logger.error("could not locate mediathekview shutdown helper app");
            } else {
                File appLocation = result.get(0);
                this.logger.debug("Shutdown Helper location: {}", (Object)appLocation.toString());
                this.logger.info("Executing shutdown helper");
                ProcessBuilder builder = new ProcessBuilder(appLocation.toString() + SHUTDOWN_HELPER_APP_BINARY_PATH);
                builder.command().add("-shutdown");
                builder.start();
                this.logger.debug("shutdown helper app was launched");
            }
        }
        catch (Exception e) {
            this.logger.error("unexpected error occured", (Throwable)e);
        }
    }

    @Override
    protected void installMenuTabSwitchListener() {
    }

    @Override
    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.setupUserInterfaceForOsx();
    }

    @Override
    protected IndicatorThread createProgressIndicatorThread() {
        return new OsxIndicatorThread();
    }

    @Override
    protected void handleDownloadStart(DownloadStartEvent msg) {
        super.handleDownloadStart(msg);
        this.powerManager.disablePowerManagement();
        this.setDownloadsBadge(this.numDownloadsStarted.get());
    }

    @Override
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        super.handleDownloadFinishedEvent(msg);
        int numDownloads = this.numDownloadsStarted.get();
        if (numDownloads == 0) {
            this.powerManager.enablePowerManagement();
        }
        this.setDownloadsBadge(numDownloads);
    }

    private void setDownloadsBadge(int numDownloads) {
        if (numDownloads > 0) {
            Taskbar.getTaskbar().setIconBadge(Integer.toString(numDownloads));
        } else {
            Taskbar.getTaskbar().setIconBadge("");
        }
    }

    private void setupUserInterfaceForOsx() {
        Desktop desktop = Desktop.getDesktop();
        desktop.disableSuddenTermination();
        desktop.setQuitHandler((e, response) -> {
            if (!this.beenden(false, false)) {
                response.cancelQuit();
            } else {
                response.performQuit();
            }
        });
        desktop.setAboutHandler(e -> this.showAboutDialog());
        desktop.setPreferencesHandler(e -> this.showSettingsDialog());
    }

    private void setupDockIcon() {
        try {
            URL url = this.getClass().getResource("/mediathek/res/MediathekView.png");
            BufferedImage appImage = ImageIO.read(url);
            Taskbar.getTaskbar().setIconImage(appImage);
        }
        catch (IOException ex) {
            Log.errorLog(165623698, "OS X Application image could not be loaded");
        }
    }

    static class WorkaroundStage
    extends Stage {
        public WorkaroundStage() {
            this.initStyle(StageStyle.UTILITY);
            StackPane root = new StackPane();
            root.setStyle("-fx-background-color: TRANSPARENT");
            Scene scene = new Scene(root, 1.0, 1.0);
            scene.setFill(Color.TRANSPARENT);
            this.setScene(scene);
            this.setWidth(1.0);
            this.setHeight(1.0);
            this.setOpacity(0.0);
        }
    }
}

