/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.history;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.SwingUtilities;
import mediathek.controller.history.MVUsedUrl;
import mediathek.controller.history.MVUsedUrlModelHelper;
import mediathek.tool.Functions;
import mediathek.tool.MVMessageDialog;

class HistoryWriterThread
extends Thread {
    private final String ziel;
    private final List<MVUsedUrl> liste;

    public HistoryWriterThread(String ziel, List<MVUsedUrl> liste) {
        this.ziel = ziel;
        this.liste = liste;
        this.setName(HistoryWriterThread.class.getName());
    }

    @Override
    public void run() {
        Path logFilePath = Paths.get(this.ziel, new String[0]);
        try (OutputStream os = Files.newOutputStream(logFilePath, new OpenOption[0]);
             OutputStreamWriter osw = new OutputStreamWriter(os);
             BufferedWriter bw = new BufferedWriter(osw);){
            bw.newLine();
            bw.write(this.getHeaderString());
            bw.newLine();
            bw.newLine();
            for (MVUsedUrl entry : this.liste) {
                bw.write(this.prepareUrlString(entry));
                bw.newLine();
            }
            bw.newLine();
            bw.flush();
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(() -> MVMessageDialog.showMessageDialog(null, "Datei konnte nicht geschrieben werden!", "Fehler beim Schreiben", 0));
        }
    }

    private String getHeaderString() {
        return Functions.textLaenge(40, MVUsedUrlModelHelper.TITLE_HEADER[2], false, false) + "    " + Functions.textLaenge(25, MVUsedUrlModelHelper.TITLE_HEADER[1], false, false) + "    " + Functions.textLaenge(10, MVUsedUrlModelHelper.TITLE_HEADER[0], false, false) + "    " + MVUsedUrlModelHelper.TITLE_HEADER[3];
    }

    private String prepareUrlString(MVUsedUrl entry) {
        return Functions.textLaenge(40, entry.getTitel(), false, false) + "    " + Functions.textLaenge(25, entry.getThema(), false, false) + "    " + (entry.getDatum().isEmpty() ? "          " : entry.getDatum()) + "    " + entry.getUrl();
    }
}

