/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.filmInformation;

import com.jidesoft.swing.MultilineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;
import java.util.Optional;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVSenderIconCache;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;

public class InfoDialog
extends JDialog {
    private static final long serialVersionUID = -890508930316467747L;
    private static final String FILM_INFO_VISIBLE = "film.information.visible";
    private static final String FILM_INFO_LOCATION_X = "film.information.location.x";
    private static final String FILM_INFO_LOCATION_Y = "film.information.location.y";
    private static final String COPY_URL_TEXT = "URL kopieren";
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private final MVSenderIconCache senderIconCache = Daten.getInstance().getSenderIconCache();
    private DatenFilm currentFilm = null;
    private JLabel lblSender;
    private MultilineLabel lblThema;
    private MultilineLabel lblTitel;
    private JLabel lblDatum;
    private JLabel lblUhrzeit;
    private JLabel lblDauer;
    private JLabel lblSize;
    private JCheckBox cbHD;
    private JCheckBox cbSubtitle;
    private JLabel lblGeo;
    private JLabel lblAbo;
    private JFXPanel fxPanel;
    private Hyperlink hyperlink;
    private JTextArea lblDescription;

    public InfoDialog(Window parent) {
        super(parent);
        this.setType(Window.Type.UTILITY);
        this.setTitle("Filminformation");
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.buildLayout();
        this.installCopyUrlHandler(this.lblThema);
        this.installCopyUrlHandler(this.lblTitel);
        this.updateTextFields();
        this.restoreLocation();
        boolean wasVisible = this.config.getBoolean(FILM_INFO_VISIBLE, false);
        if (wasVisible) {
            this.setVisible(true);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                InfoDialog.this.config.setProperty(InfoDialog.FILM_INFO_VISIBLE, true);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                InfoDialog.this.config.setProperty(InfoDialog.FILM_INFO_VISIBLE, false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (InfoDialog.this.isVisible()) {
                    InfoDialog.this.saveLocation();
                }
            }
        });
    }

    private void installCopyUrlHandler(JTextComponent component) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(COPY_URL_TEXT);
        item.addActionListener(e -> GuiFunktionen.copyToClipboard(component.getText()));
        menu.add(item);
        component.setComponentPopupMenu(menu);
    }

    private void restoreLocation() {
        this.config.lock(LockMode.READ);
        try {
            Point newLocation = new Point();
            newLocation.x = this.config.getInt(FILM_INFO_LOCATION_X);
            newLocation.y = this.config.getInt(FILM_INFO_LOCATION_Y);
            this.setLocation(newLocation);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    private void saveLocation() {
        if (!this.isVisible()) {
            return;
        }
        this.config.lock(LockMode.WRITE);
        try {
            Point location = this.getLocationOnScreen();
            this.config.setProperty(FILM_INFO_LOCATION_X, location.x);
            this.config.setProperty(FILM_INFO_LOCATION_Y, location.y);
        }
        finally {
            this.config.unlock(LockMode.WRITE);
        }
    }

    public void showInfo() {
        this.updateTextFields();
        this.pack();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    private void clearControls() {
        this.lblSender.setText("");
        this.lblSender.setIcon(null);
        this.lblThema.setText("");
        this.lblTitel.setText("");
        this.lblDescription.setText("");
        this.lblSize.setText("");
        this.lblDatum.setText("");
        this.lblUhrzeit.setText("");
        this.lblDauer.setText("");
        this.cbHD.setSelected(false);
        this.cbSubtitle.setSelected(false);
        this.lblGeo.setText("");
        this.lblAbo.setText("");
        Platform.runLater(() -> {
            this.hyperlink.setTooltip(null);
            this.hyperlink.setDisable(true);
        });
    }

    private void setSenderIcon(JLabel control) {
        Optional<ImageIcon> optIcon = this.senderIconCache.get(this.currentFilm.getSender(), true);
        optIcon.ifPresent(icon -> {
            control.setText("");
            control.setIcon((Icon)icon);
        });
    }

    private void updateTextFields() {
        if (this.currentFilm == null) {
            this.clearControls();
        } else {
            this.setSenderIcon(this.lblSender);
            this.lblThema.setText(this.currentFilm.getThema());
            this.lblTitel.setText(this.currentFilm.getTitle());
            this.lblDescription.setText(this.currentFilm.getDescription());
            this.lblDescription.setCaretPosition(0);
            this.lblSize.setText(this.currentFilm.getSize());
            this.lblDatum.setText(this.currentFilm.getSendeDatum());
            this.lblUhrzeit.setText(this.currentFilm.getSendeZeit());
            this.lblDauer.setText(this.currentFilm.getDauer());
            this.cbHD.setSelected(this.currentFilm.isHighQuality());
            this.cbSubtitle.setSelected(this.currentFilm.hasSubtitle());
            this.lblGeo.setText(this.currentFilm.getGeo().orElse(""));
            this.lblAbo.setText(this.currentFilm.getAboName());
            Platform.runLater(() -> {
                this.hyperlink.setTooltip(new Tooltip(this.currentFilm.getWebsiteLink()));
                this.hyperlink.setDisable(false);
            });
        }
    }

    public void updateCurrentFilm(DatenFilm film) {
        this.currentFilm = film;
        if (this.isVisible()) {
            this.updateTextFields();
        }
        this.pack();
    }

    private void buildLayout() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new MigLayout("hidemode 3", "[fill][fill]", "[][][][][][][][][][][][][][fill]"));
        JLabel label = new JLabel();
        label.setText("Sender:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 0));
        this.lblSender = new JLabel();
        contentPane.add((Component)this.lblSender, new CC().cell(1, 0).maxWidth("250"));
        label = new JLabel();
        label.setText("Thema:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 1));
        this.lblThema = new MultilineLabel();
        contentPane.add((Component)this.lblThema, new CC().cell(1, 1));
        label = new JLabel();
        label.setText("Titel:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 2));
        this.lblTitel = new MultilineLabel();
        contentPane.add((Component)this.lblTitel, new CC().cell(1, 2).maxWidth("250"));
        label = new JLabel();
        label.setText("Datum:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 3));
        this.lblDatum = new JLabel();
        contentPane.add((Component)this.lblDatum, new CC().cell(1, 3).maxWidth("250"));
        label = new JLabel();
        label.setText("Uhrzeit:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 4));
        this.lblUhrzeit = new JLabel();
        contentPane.add((Component)this.lblUhrzeit, new CC().cell(1, 4).maxWidth("250"));
        label = new JLabel();
        label.setText("Dauer:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 5));
        this.lblDauer = new JLabel();
        contentPane.add((Component)this.lblDauer, new CC().cell(1, 5).maxWidth("250"));
        label = new JLabel();
        label.setText("Gr\u00f6\u00dfe (MB):");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 6));
        this.lblSize = new JLabel();
        contentPane.add((Component)this.lblSize, new CC().cell(1, 6).maxWidth("250"));
        label = new JLabel();
        label.setText("HD:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 7));
        this.cbHD = new JCheckBox();
        this.cbHD.setEnabled(false);
        contentPane.add((Component)this.cbHD, new CC().cell(1, 7).maxWidth("250"));
        label = new JLabel();
        label.setText("Untertitel:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 8));
        this.cbSubtitle = new JCheckBox();
        this.cbSubtitle.setEnabled(false);
        contentPane.add((Component)this.cbSubtitle, new CC().cell(1, 8).maxWidth("250"));
        label = new JLabel();
        label.setText("Geo:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 9));
        this.lblGeo = new JLabel();
        contentPane.add((Component)this.lblGeo, new CC().cell(1, 9).maxWidth("250"));
        label = new JLabel();
        label.setText("Abo:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 10));
        this.lblAbo = new JLabel();
        contentPane.add((Component)this.lblAbo, new CC().cell(1, 10).maxWidth("250"));
        label = new JLabel();
        label.setText("Website:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 11));
        this.fxPanel = new JFXPanel();
        contentPane.add((Component)this.fxPanel, new CC().cell(1, 11).maxWidth("250"));
        Platform.runLater(() -> {
            ContextMenu contextMenu = new ContextMenu();
            MenuItem mi = new MenuItem(COPY_URL_TEXT);
            mi.setOnAction(e -> SwingUtilities.invokeLater(() -> GuiFunktionen.copyToClipboard(this.currentFilm.getWebsiteLink())));
            contextMenu.getItems().add(mi);
            this.hyperlink = new Hyperlink("Hier klicken");
            this.hyperlink.setContextMenu(contextMenu);
            this.hyperlink.setUnderline(true);
            this.hyperlink.setBackground(new Background(new BackgroundFill(Color.rgb(236, 236, 236), CornerRadii.EMPTY, Insets.EMPTY)));
            this.hyperlink.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                if (this.currentFilm != null) {
                    try {
                        UrlHyperlinkAction.openURL(null, this.currentFilm.getWebsiteLink());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }));
            this.fxPanel.setScene(new Scene(this.hyperlink));
        });
        label = new JLabel();
        label.setText("Beschreibung:");
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, new CC().cell(0, 12));
        JScrollPane scrollPane = new JScrollPane();
        this.lblDescription = new JTextArea();
        this.lblDescription.setLineWrap(true);
        this.lblDescription.setEditable(false);
        this.lblDescription.setWrapStyleWord(true);
        this.lblDescription.setFont(UIManager.getFont("Label.font"));
        scrollPane.setViewportView(this.lblDescription);
        contentPane.add((Component)scrollPane, "cell 0 13 2 1,growy,width 250:320:400,height 100:100");
        this.pack();
    }
}

